/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.time.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.core.hr.util.HRParamUtil;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.time.DataSourceEnum;
import com.kingdee.eas.hr.time.ILeaveDetail;
import com.kingdee.eas.hr.time.LeaveBillEntryCollection;
import com.kingdee.eas.hr.time.LeaveBillEntryFactory;
import com.kingdee.eas.hr.time.LeaveBillEntryInfo;
import com.kingdee.eas.hr.time.LeaveBillFactory;
import com.kingdee.eas.hr.time.LeaveBillInfo;
import com.kingdee.eas.hr.time.LeaveDetailException;
import com.kingdee.eas.hr.time.LeaveDetailFactory;
import com.kingdee.eas.hr.time.LeaveDetailInfo;
import com.kingdee.eas.hr.time.LeaveReportBillEntryCollection;
import com.kingdee.eas.hr.time.LeaveReportBillEntryInfo;
import com.kingdee.eas.hr.time.app.TimeServerUtils;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.Date;

public class LeaveBillAppUtils {
    public static LeaveDetailInfo getLeaveDetail(Context ctx, LeaveBillEntryInfo entry) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("person.id"));
        sic.add(new SelectorItemInfo("bill.id"));
        sic.add(new SelectorItemInfo("type.id"));
        entry = LeaveBillEntryFactory.getLocalInstance(ctx).getLeaveBillEntryInfo((IObjectPK)new ObjectUuidPK(entry.getId().toString()), sic);
        LeaveDetailInfo info = new LeaveDetailInfo();
        info.setPerson(entry.getPerson());
        LeaveBillInfo leaveBillinfo = LeaveBillFactory.getLocalInstance(ctx).getLeaveBillInfo((IObjectPK)new ObjectUuidPK(entry.getBill().getId().toString()));
        if (leaveBillinfo.getHrOrgUnit() == null) {
            throw new LeaveDetailException(LeaveDetailException.HRORG_NOT);
        }
        info.setHrOrgUnit(leaveBillinfo.getHrOrgUnit());
        String personId = null;
        PositionInfo psInfo = null;
        if (entry.getPerson() != null && (psInfo = TimeServerUtils.getPrimaryPosition(ctx, personId = entry.getPerson().getId().toString())) != null) {
            info.setAdminOrgUnit(psInfo.getAdminOrgUnit());
            info.setPosition(psInfo);
        }
        info.setStartDateReg(entry.getBeginTime());
        info.setEndDateReg(entry.getEndTime());
        info.setTotalReg(entry.getLeaveLength());
        if (entry.getBeginTime() != null) {
            info.setYearOfLeave(DateTimeUtils.getYear((Date)entry.getBeginTime()));
        }
        info.setLeaveDetailEntryId(entry.getId().toString());
        info.setDataOfSource(DataSourceEnum.WORKFLOW);
        String HRO_ID = leaveBillinfo.getHrOrgUnit().getId().toString();
        if (!HRParamUtil.getParamOfHR((Context)ctx, (String)"QJ003", (String)HRO_ID)) {
            info.setTimeAttendance(entry.getType());
            info.setStartDateReal(entry.getBeginTime());
            info.setEndDateReal(entry.getEndTime());
            info.setTotalRegReal(entry.getLeaveLength());
        }
        return info;
    }

    public static void saveLeaveDetail(Context ctx, LeaveBillEntryCollection c) throws BOSException, EASBizException {
        ILeaveDetail ild = LeaveDetailFactory.getLocalInstance(ctx);
        LeaveDetailInfo info = null;
        LeaveBillEntryInfo entry = null;
        IObjectPK pk = null;
        int size = c.size();
        for (int i = 0; i < size; ++i) {
            entry = c.get(i);
            info = LeaveBillAppUtils.getLeaveDetail(ctx, entry);
            pk = ild.addnew((CoreBaseInfo)info);
        }
    }

    public static void saveLeaveDetailAll(Context ctx, LeaveReportBillEntryCollection c) throws BOSException, EASBizException {
        ILeaveDetail ild = LeaveDetailFactory.getLocalInstance(ctx);
        LeaveDetailInfo info = null;
        LeaveReportBillEntryInfo entry = null;
        int size = c.size();
        for (int i = 0; i < size; ++i) {
            entry = c.get(i);
            info = LeaveBillAppUtils.getLeaveDetail(ctx, entry.getLeaveBillEntry());
            info.setStartDateReal(entry.getBeginTime());
            info.setEndDateReal(entry.getEndTime());
            info.setTotalRegReal(entry.getLeaveLength());
            info.setTimeAttendance(entry.getType());
            ild.addnew((CoreBaseInfo)info);
        }
    }

    public static void saveLeaveDetail(Context ctx, LeaveReportBillEntryCollection c) throws BOSException, EASBizException {
        String sql = "UPDATE T_HR_LeaveDetail SET FStartDateReal = ?,FEndDateReal=?,FTotalRegReal=? WHERE FLeaveBillEntryID = ?";
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql);
            LeaveReportBillEntryInfo entry = null;
            int n = c.size();
            for (int i = 0; i < n; ++i) {
                entry = c.get(i);
                pstmt.setTimestamp(1, entry.getBeginTime());
                pstmt.setTimestamp(2, entry.getEndTime());
                pstmt.setBigDecimal(3, entry.getLeaveLength());
                pstmt.setString(4, entry.getLeaveBillEntry().getId().toString());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (Exception ex) {
            try {
                throw new BOSException(ex.getMessage(), ex.getCause());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }
}

