/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.time.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.core.hr.util.HRParamUtil;
import com.kingdee.eas.base.permission.Locale;
import com.kingdee.eas.base.permission.MultiLangHelper;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.base.permission.SecurityInfo;
import com.kingdee.eas.base.permission.UserException;
import com.kingdee.eas.base.permission.UserGroupInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserType;
import com.kingdee.eas.basedata.assistant.AddressInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgSwitchFacade;
import com.kingdee.eas.basedata.org.OrgSwitchFacadeFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.time.HRTimeException;
import com.kingdee.eas.hr.time.IYearVacationBalance;
import com.kingdee.eas.hr.time.LeaveBillEntryInfo;
import com.kingdee.eas.hr.time.LeaveBillFactory;
import com.kingdee.eas.hr.time.LeaveBillInfo;
import com.kingdee.eas.hr.time.TimeAttendanceInfo;
import com.kingdee.eas.hr.time.TimeBaseException;
import com.kingdee.eas.hr.time.TimeBaseInfo;
import com.kingdee.eas.hr.time.YearVacationBalanceFactory;
import com.kingdee.eas.hr.time.app.AbstractLeaveBillControllerBean;
import com.kingdee.eas.hr.time.app.LeaveBillAppUtils;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Random;
import org.apache.log4j.Logger;

public class LeaveBillControllerBean
extends AbstractLeaveBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.time.app.LeaveBillControllerBean");

    protected void _save(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        LeaveBillInfo info = (LeaveBillInfo)model;
        this._checkNumberDup(ctx, model);
        super._save(ctx, pk, (IObjectValue)info);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        LeaveBillInfo info = (LeaveBillInfo)model;
        this._checkNumberDup(ctx, model);
        return super._save(ctx, (IObjectValue)info);
    }

    protected void _submit(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        LeaveBillInfo info = (LeaveBillInfo)model;
        this._checkNumberDup(ctx, model);
        super._submit(ctx, pk, (IObjectValue)info);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        LeaveBillInfo info = (LeaveBillInfo)model;
        this._checkNumberDup(ctx, model);
        return super._submit(ctx, (IObjectValue)info);
    }

    protected void _checkCanDelete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        TimeBaseInfo info = (TimeBaseInfo)this._getValue(ctx, pk);
        if (info.getBizState().getValue() != 0 && info.getBizState().getValue() != -1) {
            throw new TimeBaseException(TimeBaseException.HRBILL_CAN_NOT_DELETE);
        }
    }

    protected void _saveLeaveDetail(Context ctx, IObjectValue bill) throws BOSException, EASBizException {
        LeaveBillInfo info = (LeaveBillInfo)bill;
        LeaveBillAppUtils.saveLeaveDetail(ctx, info.getEntries());
    }

    private UserInfo getUserInfo(Context context, String userNumber) throws EASBizException {
        UserInfo userInfo = null;
        try {
            Object[] params = new Object[]{userNumber.toUpperCase()};
            String nameField = MultiLangHelper.getFieldName((String)"FName", (java.util.Locale)context.getLocale());
            String descriptionField = MultiLangHelper.getFieldName((String)"FDescription", (java.util.Locale)context.getLocale());
            String aliasField = MultiLangHelper.getFieldName((String)"FAlias", (java.util.Locale)context.getLocale());
            StringBuffer sql = new StringBuffer();
            sql.append(" SELECT U.FID, U.FNumber, ").append(" U.").append(nameField).append(", ").append(" U.FPassword, U.FType, U.FIsLocked, U.FIsDelete, U.FForbidden, ").append(" U.FIsRegister, U.FGroupID, U.FPersonId, U.FSecurityID, U.FEffectiveDate, U.FInvalidationDate, ").append(" U.FDefaultLocale, U.FErrCount, U.FPWEffectiveDate, U.FLockedTime, U.FType, U.FDefOrgUnitID, ").append(" U.FControlUnitID, CtrlUnit.FNumber AS FCtrlUnitNumber, ").append(" CtrlUnit.").append(nameField).append(" AS FCtrlUnitName, ").append(" U.FIsBizAdmin, U.FIsChangedPW, ").append(" U.").append(descriptionField).append(", ").append(" Person.FNumber AS FPersonNumber, ").append("Person.").append(nameField).append(" AS FPersonName, ").append(" Security.FNumber AS FSecurityNumber, ").append(" Security.").append(aliasField).append(" AS FSecurityAlias, ").append(" Security.FPasswordLength AS FPasswordLength, ").append(" Security.FPasswordForever AS FPasswordForever, Security.FNeedLocked AS FNeedLocked, ").append(" Security.FLockCount AS FLockCount, Security.FPasswordCanChg AS FPasswordCanChg, ").append(" Security.FPasswordCycle AS FPasswordCycle, Security.FForewarnDay AS FForewarnDay, ").append(" Security.FIsComplex AS FIsComplex, Security.FIsRequireChgPW AS FIsRequireChgPW, ").append(" BaseUnit.FNumber AS FDefOrgUnitNumber, ").append(" BaseUnit.").append(nameField).append(" AS FDefOrgUnitName, ").append(" BaseUnit.FIsCU, BaseUnit.FIsCompanyOrgUnit, BaseUnit.FIsSaleOrgUnit, ").append(" BaseUnit.FIsPurchaseOrgUnit,\tBaseUnit.FIsStorageOrgUnit, BaseUnit.FIsHROrgUnit, ").append(" U.FCustomerID, Customer.FNumber AS FCustomerNumber, ").append(" Customer.").append(nameField).append(" AS FCustomerName, ").append(" U.FSupplierID, Supplier.FNumber AS FSupplierNumber, ").append(" Supplier.").append(nameField).append(" AS FSupplierName ").append(" FROM T_PM_User U ").append(" LEFT OUTER JOIN T_BD_Person Person ON Person.FID = U.FPersonId ").append(" LEFT OUTER JOIN T_PM_Security Security ON Security.FID = U.FSecurityID ").append(" LEFT OUTER JOIN T_ORG_BaseUnit BaseUnit ON BaseUnit.FID = U.FDefOrgUnitID ").append(" LEFT OUTER JOIN T_BD_Customer Customer ON Customer.FID = U.FCustomerID ").append(" LEFT OUTER JOIN T_BD_Supplier Supplier ON Supplier.FID = U.FSupplierID ").append(" INNER JOIN T_ORG_CtrlUnit CtrlUnit ON CtrlUnit.FID = U.FControlUnitID ").append(" WHERE UPPER(U.FNumber) =  ? AND U.FIsDelete = 0 ");
            IRowSet rowSet = DbUtil.executeQuery((Context)context, (String)sql.toString(), (Object[])params);
            if (rowSet.next()) {
                String ctrlUnitID;
                String securityID;
                String personID;
                userInfo = new UserInfo();
                userInfo.setId(BOSUuid.read((String)rowSet.getString("FID")));
                userInfo.setNumber(rowSet.getString("FNumber"));
                userInfo.setName(rowSet.getString(nameField), context.getLocale());
                userInfo.setPassword(rowSet.getString("FPassword"));
                userInfo.setType(UserType.getEnum((int)rowSet.getInt("FType")));
                userInfo.setIsLocked(rowSet.getInt("FIsLocked") == 1);
                userInfo.setIsDelete(rowSet.getInt("FIsDelete") == 1);
                userInfo.setIsForbidden(rowSet.getInt("FForbidden") == 1);
                userInfo.setIsRegister(rowSet.getInt("FIsRegister") == 1);
                userInfo.setBizAdmin(rowSet.getInt("FIsBizAdmin") == 1);
                userInfo.setChangedPW(rowSet.getInt("FIsChangedPW") == 1);
                userInfo.setDescription(rowSet.getString(descriptionField), context.getLocale());
                String groupID = rowSet.getString("FGroupID");
                if (!StringUtils.isEmpty((String)groupID)) {
                    UserGroupInfo groupInfo = new UserGroupInfo();
                    groupInfo.setId(BOSUuid.read((String)groupID));
                    userInfo.setGroup(groupInfo);
                }
                if (!StringUtils.isEmpty((String)(personID = rowSet.getString("FPersonId")))) {
                    String personNumber = rowSet.getString("FPersonNumber");
                    String personName = rowSet.getString("FPersonName");
                    PersonInfo personInfo = new PersonInfo();
                    personInfo.setId(BOSUuid.read((String)personID));
                    personInfo.setNumber(personNumber);
                    personInfo.setName(personName, context.getLocale());
                    userInfo.setPerson(personInfo);
                }
                if (!StringUtils.isEmpty((String)(securityID = rowSet.getString("FSecurityID")))) {
                    SecurityInfo securityInfo = new SecurityInfo();
                    securityInfo.setNumber(rowSet.getString("FSecurityNumber"));
                    securityInfo.setAlias(rowSet.getString("FSecurityAlias"), context.getLocale());
                    securityInfo.setPasswordLength(rowSet.getInt("FPasswordLength"));
                    securityInfo.setPasswordForever(rowSet.getInt("FPasswordForever") == 1);
                    securityInfo.setNeedLocked(rowSet.getInt("FNeedLocked") == 1);
                    securityInfo.setLockCount(rowSet.getInt("FLockCount"));
                    securityInfo.setPasswordCanChg(rowSet.getInt("FPasswordCanChg") == 1);
                    securityInfo.setPasswordCycle(rowSet.getInt("FPasswordCycle"));
                    securityInfo.setForewarnDay(rowSet.getInt("FForewarnDay"));
                    securityInfo.setComplex(rowSet.getInt("FIsComplex") == 1);
                    securityInfo.setRequireChgPW(rowSet.getInt("FIsRequireChgPW") == 1);
                    userInfo.setSecurity(securityInfo);
                }
                if (!StringUtils.isEmpty((String)(ctrlUnitID = rowSet.getString("FControlUnitID")))) {
                    String ctrlUnitNumber = rowSet.getString("FCtrlUnitNumber");
                    String ctrlUnitName = rowSet.getString("FCtrlUnitName");
                    CtrlUnitInfo ctrlUnitInfo = new CtrlUnitInfo();
                    ctrlUnitInfo.setId(BOSUuid.read((String)ctrlUnitID));
                    ctrlUnitInfo.setNumber(ctrlUnitNumber);
                    ctrlUnitInfo.setName(ctrlUnitName, context.getLocale());
                    userInfo.setCU(ctrlUnitInfo);
                }
                userInfo.setEffectiveDate(rowSet.getTimestamp("FEffectiveDate"));
                userInfo.setInvalidationDate(rowSet.getTimestamp("FInvalidationDate"));
                userInfo.setDefLocale(Locale.getEnum((String)rowSet.getString("FDefaultLocale")));
                userInfo.setErrCount(rowSet.getInt("FErrCount"));
                userInfo.setPWEffectiveDate((Date)rowSet.getDate("FPWEffectiveDate"));
                userInfo.setLockedTime(rowSet.getTime("FLockedTime"));
                userInfo.setType(UserType.getEnum((int)rowSet.getInt("FType")));
                String defOrgUnitID = rowSet.getString("FDefOrgUnitID");
                if (!StringUtils.isEmpty((String)defOrgUnitID)) {
                    String defOrgUnitNumber = rowSet.getString("FDefOrgUnitNumber");
                    String defOrgUnitName = rowSet.getString("FDefOrgUnitName");
                    FullOrgUnitInfo defOrgUnit = new FullOrgUnitInfo();
                    defOrgUnit.setId(BOSUuid.read((String)defOrgUnitID));
                    defOrgUnit.setNumber(defOrgUnitNumber);
                    defOrgUnit.setName(defOrgUnitName, context.getLocale());
                    defOrgUnit.setIsCU(rowSet.getInt("FIsCU") == 1);
                    defOrgUnit.setIsCompanyOrgUnit(rowSet.getInt("FIsCompanyOrgUnit") == 1);
                    defOrgUnit.setIsSaleOrgUnit(rowSet.getInt("FIsSaleOrgUnit") == 1);
                    defOrgUnit.setIsPurchaseOrgUnit(rowSet.getInt("FIsPurchaseOrgUnit") == 1);
                    defOrgUnit.setIsStorageOrgUnit(rowSet.getInt("FIsStorageOrgUnit") == 1);
                    defOrgUnit.setIsHROrgUnit(rowSet.getInt("FIsHROrgUnit") == 1);
                    userInfo.setDefOrgUnit(defOrgUnit);
                }
            }
        }
        catch (SQLException e) {
            throw new UserException(UserException.GET_USER_INFO_FAIL, (Throwable)e);
        }
        catch (BOSException e) {
            throw new PermissionException(PermissionException.SERVER_CONFIGURE_ERROR, (Throwable)e);
        }
        return userInfo;
    }

    private void setContext(Context ctx) throws EASBizException, BOSException {
        UserInfo userInfo = null;
        userInfo = this.getUserInfo(ctx, ctx.getUserName());
        ContextUtil.setCurrentUserInfo((Context)ctx, (UserInfo)userInfo);
        ContextUtil.setCurrentCtrlUnit((Context)ctx, (CtrlUnitInfo)userInfo.getCU());
        FullOrgUnitInfo ouInfo = userInfo.getDefOrgUnit();
        IOrgSwitchFacade ios = OrgSwitchFacadeFactory.getLocalInstance((Context)ctx);
        ios.orgSwitch(ouInfo.getId().toString());
    }

    protected BOSUuid _submitLeaveBill(Context ctx, HashMap values) throws BOSException, EASBizException {
        this.setContext(ctx);
        Date beginDate = (Date)values.get("beginDate");
        Date endDate = (Date)values.get("endDate");
        BigDecimal leaveLength = (BigDecimal)values.get("leaveLength");
        String type = (String)values.get("leaveType");
        String reason = (String)values.get("reason");
        LeaveBillInfo leaveInfo = new LeaveBillInfo();
        leaveInfo.setNumber(this.getBillNumber(ctx));
        leaveInfo.setAdminOrg(ContextUtil.getCurrentAdminUnit((Context)ctx));
        leaveInfo.setApplyDate(new Date());
        leaveInfo.setIsMultiEntry(false);
        PersonInfo pInfo = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
        leaveInfo.setProposer(pInfo);
        LeaveBillEntryInfo entry = new LeaveBillEntryInfo();
        entry.setBeginTime(new Timestamp(beginDate.getTime()));
        entry.setEndTime(new Timestamp(endDate.getTime()));
        entry.setLeaveLength(leaveLength);
        entry.setPerson(pInfo);
        entry.setType(this.getLeaveTypeById(type));
        entry.setReason(reason);
        leaveInfo.getEntries().add(entry);
        return BOSUuid.read((String)this.submit(ctx, (CoreBaseInfo)leaveInfo).toString());
    }

    private String getBillNumber(Context ctx) throws BOSException, EASBizException {
        String number = null;
        LeaveBillInfo leaveInfo = new LeaveBillInfo();
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        String comId = iCodingRuleManager.getCurrentAppOUID((IObjectValue)leaveInfo);
        if (comId != null) {
            if (iCodingRuleManager.isExist((IObjectValue)leaveInfo, comId)) {
                number = iCodingRuleManager.isUseIntermitNumber((IObjectValue)leaveInfo, comId) ? iCodingRuleManager.getNonbreakNumber((IObjectValue)leaveInfo, comId) : iCodingRuleManager.getNumber((IObjectValue)leaveInfo, comId);
            } else {
                this.getNumber();
            }
        } else {
            this.getNumber();
        }
        return number;
    }

    private String getNumber() {
        StringBuffer sb = new StringBuffer();
        Date date = new Date();
        sb.append("QJ-").append(String.valueOf(DateTimeUtils.getYear((Date)date))).append("-").append(String.valueOf(DateTimeUtils.getMonth((Date)date))).append("-").append(String.valueOf(DateTimeUtils.getDay((Date)date)));
        Random r = new Random();
        sb.append(date.getTime() + (long)r.nextInt() + (long)r.nextInt());
        return sb.toString();
    }

    private TimeAttendanceInfo getLeaveTypeById(String id) {
        TimeAttendanceInfo leaveType = new TimeAttendanceInfo();
        String typeId = "";
        int value = Integer.parseInt(id);
        switch (value) {
            case 8: {
                typeId = "00000000-0000-0000-0000-000000000008649E3405";
                break;
            }
            case 9: {
                typeId = "00000000-0000-0000-0000-000000000009649E3405";
                break;
            }
            case 10: {
                typeId = "00000000-0000-0000-0000-000000000010649E3405";
                break;
            }
            case 11: {
                typeId = "00000000-0000-0000-0000-000000000011649E3405";
                break;
            }
            case 12: {
                typeId = "00000000-0000-0000-0000-000000000012649E3405";
                break;
            }
            case 13: {
                typeId = "00000000-0000-0000-0000-000000000013649E3405";
                break;
            }
            default: {
                typeId = "00000000-0000-0000-0000-000000000008649E3405";
            }
        }
        leaveType.setId(BOSUuid.read((String)typeId));
        return leaveType;
    }

    protected IObjectValue _getAdminForHRandUserOrgRange(Context ctx) throws BOSException, EASBizException {
        String userID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        if (ContextUtil.getCurrentHRUnit((Context)ctx) == null) {
            return null;
        }
        String hrOrgID = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        StringBuffer sql = new StringBuffer("SELECT TOP 1 T_ORG_Admin.fid,T_ORG_Admin.fname_");
        sql.append(ctx.getLocale());
        sql.append(",T_ORG_Admin.fnumber,T_ORG_Admin.FLongNumber,T_ORG_Admin.FDisplayName_");
        sql.append(ctx.getLocale());
        sql.append(",T_ORG_Admin.FAddressID");
        sql.append(" FROM T_ORG_Admin ");
        sql.append(" INNER JOIN T_PM_OrgRange ON T_ORG_Admin.FID = T_PM_OrgRange.FOrgID ");
        if (!StringUtils.isEmpty((String)hrOrgID)) {
            sql.append(" INNER JOIN T_ORG_UnitRelation ON T_ORG_UnitRelation.FFromUnitID = T_ORG_Admin.FID");
        }
        sql.append(" WHERE T_PM_OrgRange.FType = 20 AND T_PM_OrgRange.FUserID='");
        sql.append(userID);
        if (!StringUtils.isEmpty((String)hrOrgID)) {
            sql.append("' AND T_ORG_UnitRelation.FTypeRelationID = '00000000-0000-0000-0000-0000000000100FE9F8B5' AND T_ORG_UnitRelation.FToUnitID = '");
            sql.append(hrOrgID);
            sql.append("' ORDER BY FLevel,FLongNumber ");
        } else {
            sql.append("' ORDER BY FLevel,FLongNumber ");
        }
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rows.next()) {
                AdminOrgUnitInfo adminInfo = new AdminOrgUnitInfo();
                adminInfo.setId(BOSUuid.read((String)rows.getString("fid")));
                adminInfo.setName(rows.getString("fname_" + ctx.getLocale()));
                adminInfo.setNumber(rows.getString("fnumber"));
                adminInfo.setLongNumber(rows.getString("flongnumber"));
                adminInfo.setDisplayName(rows.getString("fDisplayName_" + ctx.getLocale()));
                AddressInfo adInfo = new AddressInfo();
                if (!StringUtils.isEmpty((String)rows.getString("FAddressID"))) {
                    adInfo.setId(BOSUuid.read((String)rows.getString("FAddressID")));
                }
                adminInfo.setAddress(adInfo);
                return adminInfo;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    protected void _setPassState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        super._setPassState(ctx, billId);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("hrorgunit.id"));
        sic.add(new SelectorItemInfo("hrorgunit.name"));
        IObjectValue bill = this._getValue(ctx, (IObjectPK)new ObjectUuidPK(billId), sic);
        LeaveBillInfo info = (LeaveBillInfo)bill;
        String HRO_ID = null;
        if (info != null && info.getHrOrgUnit() != null) {
            HRO_ID = info.getHrOrgUnit().getId().toString();
        }
        if (HRO_ID == null) {
            throw new EASBizException(HRTimeException.HROGE_NOT_NULL);
        }
        if (!HRParamUtil.getParamOfHR((Context)ctx, (String)"QJ003", HRO_ID)) {
            LeaveBillInfo leaveBillinfo = LeaveBillFactory.getLocalInstance(ctx).getLeaveBillInfo((IObjectPK)new ObjectUuidPK(billId.toString()));
            LeaveBillFactory.getLocalInstance(ctx).saveLeaveDetail(leaveBillinfo);
        }
        ArrayList<String> lstPerson = new ArrayList<String>();
        String personID = null;
        StringBuffer sb = new StringBuffer();
        sb.append("select entry.fpersonid as personID,entry.ftypeid from t_hr_leavebillentry entry ");
        sb.append("inner join t_hr_leavebill bill on bill.fid = entry.fbillid ");
        sb.append("where entry.ftypeid='00000000-0000-0000-0000-000000000008649E3405' ");
        sb.append("and bill.fid='");
        sb.append(billId.toString());
        sb.append("'");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        try {
            while (rows.next()) {
                personID = rows.getString("personID");
                if (personID == null) continue;
                lstPerson.add(personID);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (lstPerson.size() > 0) {
            IYearVacationBalance iyvBalacne = YearVacationBalanceFactory.getLocalInstance(ctx);
            int year = Calendar.getInstance().get(1);
            iyvBalacne.calculate(year, lstPerson, 4, new Date(), 4);
        }
    }

    private boolean _checkNumberDup(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        LeaveBillInfo info = (LeaveBillInfo)model;
        if (info.getNumber() != null && info.getNumber().trim().length() > 0 && info.getId() == null) {
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("number", (Object)info.getNumber().toString()));
            if (LeaveBillFactory.getLocalInstance(ctx).exists(fi)) {
                throw new EASBizException(EASBizException.CHECKNUMDUP, new Object[]{info.getNumber()});
            }
        }
        return true;
    }
}

