/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.time.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.hr.util.HRParamUtil;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.Result;
import com.kingdee.eas.hr.compensation.CmpPeriodCollection;
import com.kingdee.eas.hr.compensation.CmpPeriodFactory;
import com.kingdee.eas.hr.time.CheckStateEnum;
import com.kingdee.eas.hr.time.LeaveDetailCheckException;
import com.kingdee.eas.hr.time.LeaveDetailInfo;
import com.kingdee.eas.hr.time.YVRuleException;
import com.kingdee.eas.hr.time.app.AbstractLeaveDetailControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class LeaveDetailControllerBean
extends AbstractLeaveDetailControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.time.app.LeaveDetailControllerBean");

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        LeaveDetailInfo leaveDetailInfo = (LeaveDetailInfo)model;
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)leaveDetailInfo.getBOSType(), null, (String)"\u5047\u671f\u767b\u8bb0", (String)"LeaveReg_AddNew");
        if (leaveDetailInfo.getHrOrgUnit() == null) {
            leaveDetailInfo.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
        }
        HashSet addNewSet = null;
        addNewSet = (HashSet)leaveDetailInfo.get("newLeaveDetailInfo");
        if (addNewSet == null) {
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
            return super._addnew(ctx, model);
        }
        Iterator addNewIterator = addNewSet.iterator();
        IObjectPK pkLastAddNew = null;
        while (addNewIterator.hasNext()) {
            LeaveDetailInfo leaveDetailInfoTemp = (LeaveDetailInfo)addNewIterator.next();
            pkLastAddNew = super._addnew(ctx, (IObjectValue)leaveDetailInfoTemp);
        }
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        return pkLastAddNew;
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)new LeaveDetailInfo().getBOSType(), null, (String)"\u5047\u671f\u767b\u8bb0", (String)"LeaveReg_Update");
        super._update(ctx, pk, model);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    protected Result _update(Context ctx, IObjectCollection collection) throws BOSException, EASBizException {
        if (collection != null && collection.size() > 0) {
            LeaveDetailInfo info = null;
            int size = collection.size();
            for (int i = 0; i < size; ++i) {
                info = (LeaveDetailInfo)collection.getObject(i);
                this._update(ctx, (IObjectPK)new ObjectUuidPK(info.getId().toString()), (IObjectValue)info);
            }
        }
        return null;
    }

    private String getCmpPeriodId(Context ctx, LeaveDetailInfo info) throws BOSException, EASBizException {
        String id = null;
        Date beginDate = DateTimeUtils.truncateDate((Date)new Date(info.getStartDateReal().getTime()));
        Date endDate = DateTimeUtils.truncateDate((Date)new Date(info.getEndDateReal().getTime()));
        FilterInfo filter = new FilterInfo();
        String hrOrgUnitId = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)hrOrgUnitId));
        filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)beginDate, CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)endDate, CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("enableState", (Object)Boolean.FALSE));
        filter.setMaskString("#0 and #1 and #2 and #3");
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("id"));
        CmpPeriodCollection c = CmpPeriodFactory.getLocalInstance((Context)ctx).getCmpPeriodCollection(evi);
        if (c.size() > 0) {
            id = c.get(0).getId().toString();
        }
        return id;
    }

    private String _setAudit(Context ctx, String id, CheckStateEnum state, boolean isUnCheck) throws BOSException, EASBizException {
        String failId = null;
        LeaveDetailInfo info = (LeaveDetailInfo)this._getValue(ctx, (IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
        if (!isUnCheck && state.getValue() == 0 && info.isRefrence()) {
            throw new LeaveDetailCheckException(LeaveDetailCheckException.REFERED_CAN_NOT_UNCHECK);
        }
        String sql = null;
        String cmpPeriodId = null;
        if (state.getValue() == 1) {
            if (info.getStartDateReal().getYear() == info.getEndDateReal().getYear()) {
                if (info.getCmpPeriod() != null) {
                    sql = "Update T_HR_LeaveDetail SET FYearOfLeave = ? , FCheckState = ? WHERE FID = ?";
                    DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{DateTimeUtils.getYear((Date)new Date(info.getStartDateReal().getTime())), state.getValue(), id});
                } else {
                    cmpPeriodId = this.getCmpPeriodId(ctx, info);
                    if (cmpPeriodId == null) {
                        failId = id;
                    } else {
                        sql = "Update T_HR_LeaveDetail SET FYearOfLeave = ? ,FCheckState = ?, FCmpPeriodID =? WHERE FID = ?";
                        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{DateTimeUtils.getYear((Date)new Date(info.getStartDateReal().getTime())), state.getValue(), cmpPeriodId, id});
                    }
                }
            } else {
                failId = id;
            }
        } else {
            sql = "Update T_HR_LeaveDetail SET FCheckState = " + state.getValue() + " WHERE FID = '" + id + "'";
            DbUtil.execute((Context)ctx, (String)sql);
        }
        return failId;
    }

    protected void _batchUpdate(Context ctx, IObjectCollection models) throws BOSException, EASBizException {
        LeaveDetailInfo info = null;
        LeaveDetailInfo info2 = null;
        int size = models.size();
        for (int i = 0; i < size; ++i) {
            info = (LeaveDetailInfo)models.getObject(i);
            info2 = (LeaveDetailInfo)this._getValue(ctx, (IObjectPK)new ObjectUuidPK(info.getId()));
            if (info2.getCheckState() != null && info2.getCheckState().getValue() == 1) {
                throw new LeaveDetailCheckException(LeaveDetailCheckException.CHECKED_CAN_NOT_MODIFY);
            }
            info2.setStartDateReg(info.getStartDateReg());
            info2.setStartDateReal(info.getStartDateReal());
            info2.setEndDateReg(info.getEndDateReg());
            info2.setEndDateReal(info.getEndDateReal());
            info2.setTotalReg(info.getTotalReg());
            info2.setTotalRegReal(info.getTotalRegReal());
            info2.setComment(info.getComment());
            info2.setCmpPeriod(info.getCmpPeriod());
            info2.setPosition(info.getPosition());
            info2.setAdminOrgUnit(info.getAdminOrgUnit());
            info2.setCmpScheme(info.getCmpScheme());
            this._update(ctx, (IObjectPK)new ObjectUuidPK(info.getId()), (IObjectValue)info2);
        }
    }

    protected String[] _batchAudit(Context ctx, String[] ids) throws BOSException, EASBizException {
        ArrayList<String> list = new ArrayList<String>();
        String id = null;
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)new LeaveDetailInfo().getBOSType(), null, (String)"\u5047\u671f\u6570\u636e\u5ba1\u6838", (String)"LeaveCheck");
        int size = ids.length;
        for (int i = 0; i < size; ++i) {
            id = this._setAudit(ctx, ids[i], CheckStateEnum.CHECK, false);
            if (id == null) continue;
            list.add(id);
        }
        String[] failIds = new String[list.size()];
        int size2 = list.size();
        for (int i = 0; i < size2; ++i) {
            failIds[i] = list.get(i).toString();
        }
        if (failIds.length == ids.length) {
            throw new LeaveDetailCheckException(LeaveDetailCheckException.AUDIT_FAIL_NO_CMPPERIOD);
        }
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        return failIds;
    }

    protected void _batchAntiAudit(Context ctx, String[] ids) throws BOSException, EASBizException {
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)new LeaveDetailInfo().getBOSType(), null, (String)"\u5047\u671f\u6570\u636e\u53cd\u5ba1\u6838", (String)"LeaveUnCheck");
        int size = ids.length;
        for (int i = 0; i < size; ++i) {
            this._setAudit(ctx, ids[i], CheckStateEnum.UNCHECK, false);
        }
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)new LeaveDetailInfo().getBOSType(), null, (String)"\u5047\u671f\u6570\u636e\u5220\u9664", (String)"LeaveReg_Del");
        LeaveDetailInfo info = (LeaveDetailInfo)this._getValue(ctx, pk);
        if (info.getCheckState().getValue() == 1) {
            throw new LeaveDetailCheckException(LeaveDetailCheckException.CHECKED_CAN_NOT_DELETE);
        }
        super._delete(ctx, pk);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    protected Map _getUsedCancleVacation(Context ctx, List lstPersonID, String timeAttendanceType, int year, int type, Date date) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        HashMap<String, String> map = new HashMap<String, String>();
        sb.append("select fpersonid,sum(leave.ftotalregreal) as total from t_hr_leavedetail as leave where ");
        sb.append(" fenddatereal <= ");
        sb.append(this.getSqlDate(date));
        sb.append(" and fyearofleave = ");
        sb.append(year);
        sb.append(" and (fcheckstate = ");
        sb.append(type);
        sb.append(" or (fcheckstate = 0 and fdatasource = TO_CHAR(10)))");
        if (timeAttendanceType != null && timeAttendanceType.length() > 0) {
            sb.append(" and ftimeattendanceid = '");
            sb.append(timeAttendanceType);
            sb.append("' ");
        } else {
            sb.append(" and ftimeattendanceid = '00000000-0000-0000-0000-000000000008649E3405' ");
        }
        if (lstPersonID.size() > 0) {
            sb.append(" and (");
            int size = lstPersonID.size() - 1;
            for (int i = 0; i < size; ++i) {
                sb.append(" fpersonid = '");
                sb.append(lstPersonID.get(i));
                sb.append("' or ");
            }
            sb.append(" fpersonid = '");
            sb.append(lstPersonID.get(lstPersonID.size() - 1));
            sb.append("' ) ");
        }
        sb.append(" group by fpersonid,ftimeattendanceid ");
        ISQLExecutor iQe = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sb.toString());
        IRowSet row = iQe.executeSQL();
        try {
            while (row.next()) {
                map.put(row.getString("fpersonid"), row.getString("total"));
            }
        }
        catch (SQLException sqle) {
            throw new BOSException((Throwable)sqle);
        }
        return map;
    }

    protected Map getUsedCancleVacationBy(Context ctx, List lstPersonID, String timeAttendanceType, int year, int type, Date date) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        HashMap<String, String> map = new HashMap<String, String>();
        int BATCH_SIZE = 500;
        sb.append("select fpersonid,sum(leave.ftotalregreal) as total from t_hr_leavedetail as leave where ");
        sb.append(" fleavebillentryID is null and fenddatereal <= ");
        sb.append(this.getSqlDate(date));
        sb.append(" and fyearofleave = ");
        sb.append(year);
        sb.append(" and (fcheckstate = ");
        sb.append(type);
        sb.append(" or (fcheckstate = 0 and fdatasource = TO_CHAR(10)))");
        if (timeAttendanceType != null && timeAttendanceType.length() > 0) {
            sb.append(" and ftimeattendanceid = '");
            sb.append(timeAttendanceType);
            sb.append("' ");
        } else {
            sb.append(" and ftimeattendanceid = '00000000-0000-0000-0000-000000000008649E3405' ");
        }
        if (lstPersonID.size() > 0) {
            sb.append(" and (");
            StringBuffer buf = new StringBuffer();
            StringBuffer sql = null;
            int size = lstPersonID.size();
            IRowSet rowSet = null;
            for (int i = 1; i <= size; ++i) {
                buf.append(" fpersonid = '");
                buf.append(lstPersonID.get(i - 1));
                buf.append("'");
                if (i % 500 != 0 && i != size) {
                    buf.append(" or ");
                    continue;
                }
                sql = new StringBuffer();
                sql.append(sb);
                sql.append(buf);
                sql.append(" ) ");
                sql.append("  group by fpersonid,ftimeattendanceid  ");
                rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                try {
                    while (rowSet.next()) {
                        map.put(rowSet.getString("fpersonid"), rowSet.getString("total"));
                    }
                }
                catch (SQLException sqle) {
                    logger.error((Object)sqle);
                    throw new BOSException((Throwable)sqle);
                }
                buf = new StringBuffer();
            }
        }
        return map;
    }

    protected Map _getUsedVacation(Context ctx, List lstPersonID, String timeAttendanceType, int year, int type, Date date) throws BOSException, EASBizException {
        Object o;
        int i;
        Map map = null;
        Map map1 = null;
        map = this.getUsedCancleVacationBy(ctx, lstPersonID, timeAttendanceType, year, type, date);
        map1 = this.getWorkFlowUsedVacation(ctx, lstPersonID, year, date);
        Set mapKey = map.keySet();
        Set mapKey1 = map1.keySet();
        BigDecimal b = null;
        BigDecimal b1 = null;
        HashMap<String, String> map2 = new HashMap<String, String>();
        int size = mapKey1.size();
        for (i = 0; i < size; ++i) {
            o = mapKey1.toArray()[i];
            if (map.containsKey(o)) {
                b = new BigDecimal(map.get(o.toString()).toString());
                b1 = new BigDecimal(map1.get(o.toString()).toString());
                map2.put(o.toString(), b.add(b1).toString());
                map.remove(o.toString());
                continue;
            }
            map2.put(o.toString(), (String)map1.get(o.toString()));
        }
        size = mapKey.size();
        for (i = 0; i < size; ++i) {
            o = mapKey.toArray()[i];
            map2.put(o.toString(), (String)map.get(o.toString()));
        }
        return map2;
    }

    protected Map getWorkFlowUsedVacation(Context ctx, List lstPersonID, int year, Date date) throws BOSException {
        StringBuffer sb = new StringBuffer();
        HashMap<String, String> map = new HashMap<String, String>();
        sb.append("select a.fpersonID as personID,sum(a.fleavelength) as total from t_hr_leavebillentry a ");
        sb.append("left outer join t_hr_leavereportbillentry b on a.fid = b.fleavebillentryid ");
        sb.append("inner join t_hr_leavebill c on a.fbillid = c.fid where c.fstate = 3 ");
        sb.append("and a.ftypeid ='00000000-0000-0000-0000-000000000008649E3405' ");
        sb.append("and year(a.fbegintime) = ");
        sb.append(year);
        sb.append(" and a.fendtime <= ");
        sb.append(this.getSqlDate(date));
        if (lstPersonID.size() > 0) {
            sb.append(" and (");
            StringBuffer buf = new StringBuffer();
            int size = lstPersonID.size();
            int BATCH_SIZE = 500;
            for (int i = 1; i <= size; ++i) {
                buf.append(" a.fpersonid = '");
                buf.append(lstPersonID.get(i - 1));
                buf.append("'");
                if (i % 500 != 0 && i != size) {
                    buf.append(" or ");
                    continue;
                }
                StringBuffer sql = new StringBuffer();
                sql.append(sb);
                sql.append(buf);
                sql.append(" ) ");
                sql.append("  group by a.fpersonid  ");
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                try {
                    while (rowSet.next()) {
                        map.put(rowSet.getString("personID"), rowSet.getString("total"));
                    }
                }
                catch (SQLException sqle) {
                    logger.error((Object)sqle);
                    throw new BOSException((Throwable)sqle);
                }
                buf = new StringBuffer();
            }
        }
        return map;
    }

    private String getSqlDate(Date date) throws BOSException {
        Calendar cal = Calendar.getInstance();
        cal.set(DateTimeUtils.getYear((Date)date), DateTimeUtils.getMonth((Date)date) - 1, DateTimeUtils.getDay((Date)date), 23, 59, 59);
        Date myDate = new Date(cal.getTimeInMillis() / 1000L * 1000L);
        String strTime = DateTimeUtils.format((Date)myDate, (String)"yyyy-MM-dd HH:mm:ss");
        String strKSQLTime = "{ts '" + strTime + "'}";
        return strKSQLTime;
    }

    public String getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return super.getLogInfo(ctx, pk);
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        LeaveDetailInfo info = (LeaveDetailInfo)super._getValue(ctx, pk);
        return info.toString();
    }

    protected void _batchUnCheck(Context ctx, String[] ids) throws BOSException, EASBizException {
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)new LeaveDetailInfo().getBOSType(), null, (String)"\u5047\u671f\u6570\u636e\u53cd\u5ba1\u6838", (String)"LeaveCompUnCheck");
        if (ids == null || ids.length == 0) {
            return;
        }
        StringBuffer idStr = new StringBuffer();
        for (int i = 0; i < ids.length; ++i) {
            if (ids[i] == null && ids[i].trim().length() == 0) continue;
            if (i != 0) {
                idStr.append(",");
            }
            idStr.append("'").append(ids[i]).append("'");
        }
        String sql = "Update T_HR_LeaveDetail SET FCheckState = 0 WHERE FID in(" + idStr.toString() + ")";
        DbUtil.execute((Context)ctx, (String)sql);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    protected Map _getOnAuditVacation(Context ctx, List lstPersonID) throws BOSException, EASBizException {
        Object o;
        int i;
        Map map = new HashMap();
        int year = Calendar.getInstance().get(1);
        String FHROrgUnitID = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        map = HRParamUtil.getParamOfHR((Context)ctx, (String)"Is_Calculate_ForDate", (String)FHROrgUnitID) ? (!HRParamUtil.getParamOfHR((Context)ctx, (String)"QJ003", (String)FHROrgUnitID) ? this.getVacationForRequest(ctx, lstPersonID) : this.getVacationForCheck(ctx, lstPersonID)) : this.getVacationForRequest(ctx, lstPersonID);
        Map map1 = this.getUsedCancleVacationBy(ctx, lstPersonID, null, year, 0, new Date());
        Set mapKey = map.keySet();
        Set mapKey1 = map1.keySet();
        BigDecimal b = null;
        BigDecimal b1 = null;
        HashMap<String, String> map2 = new HashMap<String, String>();
        int size = mapKey1.size();
        for (i = 0; i < size; ++i) {
            o = mapKey1.toArray()[i];
            if (map.containsKey(o)) {
                b = new BigDecimal(map.get(o.toString()).toString());
                b1 = new BigDecimal(map1.get(o.toString()).toString());
                map2.put(o.toString(), b.add(b1).toString());
                map.remove(o.toString());
                continue;
            }
            map2.put(o.toString(), (String)map1.get(o.toString()));
        }
        size = mapKey.size();
        for (i = 0; i < size; ++i) {
            o = mapKey.toArray()[i];
            map2.put(o.toString(), (String)map.get(o.toString()));
        }
        return map2;
    }

    private Map getVacationForRequest(Context ctx, List lstPersonID) throws BOSException {
        StringBuffer sb = new StringBuffer();
        String personID = null;
        HashMap<String, String> map = new HashMap<String, String>();
        int year = Calendar.getInstance().get(1);
        sb.append("select a.fpersonID as personID,");
        sb.append("sum( a.FLeaveLength) as total ");
        sb.append("from t_hr_leavebillentry a  ");
        sb.append("inner join t_hr_leavebill abill on abill.fid = a.FBillID ");
        sb.append("left outer join t_hr_leavereportbillentry b on a.fid = b.fleavebillentryid  ");
        sb.append("where abill.fsubmitstate = 1 ");
        sb.append("and (abill.fstate = 0 or abill.fstate = 1) ");
        sb.append("and a.ftypeid='00000000-0000-0000-0000-000000000008649E3405' ");
        sb.append("and year(a.fbegintime) = " + year + " ");
        sb.append("and a.fendtime <=" + this.getSqlDate(new Date()) + " ");
        sb.append("and a.fpersonID in (");
        for (int i = 0; i < lstPersonID.size(); ++i) {
            sb.append("'");
            sb.append(lstPersonID.get(i));
            if (i == lstPersonID.size() - 1) {
                sb.append("' ");
                continue;
            }
            sb.append("', ");
        }
        sb.append(") group by a.fpersonID ");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        try {
            while (rows.next()) {
                personID = rows.getString("personID");
                if (personID == null) continue;
                map.put(personID, rows.getString("total"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return map;
    }

    private Map getVacationForCheck(Context ctx, List lstPersonID) throws BOSException {
        StringBuffer sb = new StringBuffer();
        String personID = null;
        HashMap<String, String> map = new HashMap<String, String>();
        int year = Calendar.getInstance().get(1);
        sb.append("select a.fpersonID as personID,");
        sb.append("sum(case when b.FLeaveLength is null then a.FLeaveLength ");
        sb.append("when b.FLeaveLength>=a.FLeaveLength then b.FLeaveLength ");
        sb.append("else a.FLeaveLength ");
        sb.append("end) as total ");
        sb.append("from t_hr_leavebillentry a  ");
        sb.append("inner join t_hr_leavebill abill on abill.fid = a.FBillID ");
        sb.append("left outer join t_hr_leavereportbillentry b on a.fid = b.fleavebillentryid  ");
        sb.append("left outer join t_hr_leavereportbill bbill on bbill.fid = b.FBillID ");
        sb.append("where abill.fsubmitstate = 1 ");
        sb.append("and (abill.fstate = 0 or abill.fstate = 1 or abill.fstate = 3) ");
        sb.append("and (bbill.fstate = 0 or bbill.fstate = 1 or bbill.fid is null) ");
        sb.append("and a.ftypeid='00000000-0000-0000-0000-000000000008649E3405' ");
        sb.append("and year(a.fbegintime) = " + year + " ");
        sb.append("and a.fendtime <=" + this.getSqlDate(new Date()) + " ");
        sb.append("and a.fpersonID in (");
        for (int i = 0; i < lstPersonID.size(); ++i) {
            sb.append("'");
            sb.append(lstPersonID.get(i));
            if (i == lstPersonID.size() - 1) {
                sb.append("' ");
                continue;
            }
            sb.append("', ");
        }
        sb.append(") group by a.fpersonID ");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        try {
            while (rows.next()) {
                personID = rows.getString("personID");
                if (personID == null) continue;
                map.put(personID, rows.getString("total"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return map;
    }

    protected void _batchCheckYVRule(Context ctx, List personIds) throws BOSException, EASBizException {
        int size = personIds.size();
        for (int i = 0; i < size; ++i) {
            String personId = (String)personIds.get(i);
            String sql = "select fyvruleid from t_hr_yvperson where fpersonid='" + personId + "'";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            try {
                if (rowSet.next()) continue;
                throw new YVRuleException(YVRuleException.NOT_EXIST_YV);
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IObjectPK[] addnewBatchData(Context ctx, CoreBaseCollection colls) throws BOSException, EASBizException {
        Connection cn = null;
        IObjectPK[] objectPKArray = null;
        try {
            cn = this.getConnection(ctx);
            IORMappingDAO dao = this.getDAO(ctx, cn);
            for (IObjectValue value : colls) {
                dao.addNewBatch(value);
            }
            objectPKArray = dao.executeBatchWithReturn();
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
        return objectPKArray;
    }
}

