/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.time.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.compensation.CmpPeriodCollection;
import com.kingdee.eas.hr.compensation.CmpPeriodFactory;
import com.kingdee.eas.hr.compensation.ICmpPeriod;
import com.kingdee.eas.hr.time.CheckStateEnum;
import com.kingdee.eas.hr.time.DataSourceEnum;
import com.kingdee.eas.hr.time.ITimeAttendance;
import com.kingdee.eas.hr.time.LeaveDetailFactory;
import com.kingdee.eas.hr.time.LeaveDetailInfo;
import com.kingdee.eas.hr.time.TimeAttendanceCollection;
import com.kingdee.eas.hr.time.TimeAttendanceFactory;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import org.apache.log4j.Logger;

public class LeaveDetailDataImport
extends AbstractDataTransmission {
    public static final String HOLIDAY_CATA_ID = "00000000-0000-0000-0000-000000000002BE0D0183";
    private String RES = "com.kingdee.eas.hr.time.LeaveDetailResource";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.time.app.LeaveDetailDataImport");

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return LeaveDetailFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        LeaveDetailInfo leaveDetailInfo = new LeaveDetailInfo();
        String str = null;
        try {
            int year;
            Date date = null;
            Timestamp timestamp = null;
            str = (String)((DataToken)hsData.get((Object)"FStartDateReal")).data;
            if (str != null && !str.trim().equalsIgnoreCase("")) {
                try {
                    date = DateTimeUtils.parseDate((String)str);
                    timestamp = this.getSqlTimestamp(date);
                    timestamp.setSeconds(0);
                    leaveDetailInfo.setStartDateReal(timestamp);
                    year = DateTimeUtils.getYear((Date)timestamp);
                }
                catch (Exception e) {
                    throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"0_AttendanceManagerDataImport", (Locale)ctx.getLocale()));
                }
            } else {
                throw new TaskExternalException(this.getString(ctx, this.RES, "STARTDATE_NULL"));
            }
            str = (String)((DataToken)hsData.get((Object)"FEndDateReal")).data;
            if (str != null && !str.trim().equalsIgnoreCase("")) {
                try {
                    date = DateTimeUtils.parseDate((String)str);
                    timestamp = this.getSqlTimestamp(date);
                    timestamp.setSeconds(0);
                    leaveDetailInfo.setEndDateReal(timestamp);
                    year = DateTimeUtils.getYear((Date)timestamp);
                }
                catch (Exception e) {
                    throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"0_AttendanceManagerDataImport", (Locale)ctx.getLocale()));
                }
            } else {
                throw new TaskExternalException(this.getString(ctx, this.RES, "ENDDATE_NULL"));
            }
            leaveDetailInfo.setYearOfLeave(year);
            if (leaveDetailInfo.getStartDateReal() == null) {
                throw new TaskExternalException(this.getString(ctx, this.RES, "STARTDATE_NULL"));
            }
            if (leaveDetailInfo.getEndDateReal() == null) {
                throw new TaskExternalException(this.getString(ctx, this.RES, "ENDDATE_NULL"));
            }
            if (leaveDetailInfo.getEndDateReal().before(leaveDetailInfo.getStartDateReal())) {
                throw new TaskExternalException(this.getString(ctx, this.RES, "STARTDATE_ENDDATE_ERROR"));
            }
            str = (String)((DataToken)hsData.get((Object)"FPersonNumber")).data;
            if (str == null || str.trim().equalsIgnoreCase("")) {
                throw new TaskExternalException(this.getString(ctx, this.RES, "PNUMBER") + str + this.getString(ctx, this.RES, "NOTNULL"));
            }
            PersonInfo pInfo = this.getPersonInfo(ctx, str, true);
            leaveDetailInfo.setPerson(pInfo);
            str = (String)((DataToken)hsData.get((Object)"FAttendanceNumber")).data;
            if (str == null || str.trim().equalsIgnoreCase("")) {
                throw new TaskExternalException(this.getString(ctx, this.RES, "ANUMBER") + str + this.getString(ctx, this.RES, "NOTNULL"));
            }
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("attendCatalog.id", (Object)HOLIDAY_CATA_ID));
            filterInfo.getFilterItems().add(new FilterItemInfo("enable", (Object)"1"));
            filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)str));
            filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString()));
            filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", null));
            filterInfo.setMaskString("#0  and #1 and #2 and (#3 or #4)");
            viewInfo.setFilter(filterInfo);
            ITimeAttendance iTime = TimeAttendanceFactory.getLocalInstance(ctx);
            TimeAttendanceCollection timeColl = iTime.getTimeAttendanceCollection(viewInfo);
            if (timeColl == null || timeColl.size() == 0) {
                throw new TaskExternalException(this.getString(ctx, this.RES, "ANUMBER") + " '" + str + "' " + this.getString(ctx, this.RES, "NOTFOUND"));
            }
            leaveDetailInfo.setTimeAttendance(timeColl.get(0));
            str = (String)((DataToken)hsData.get((Object)"FCmpPeriodNumber")).data;
            if (str != null && str.length() > 0) {
                viewInfo = new EntityViewInfo();
                filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("enableState", (Object)"0"));
                filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)str));
                filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString()));
                viewInfo.setFilter(filterInfo);
                ICmpPeriod iCmp = CmpPeriodFactory.getLocalInstance((Context)ctx);
                CmpPeriodCollection cmpColl = iCmp.getCmpPeriodCollection(viewInfo);
                if (cmpColl == null || cmpColl.size() == 0) {
                    throw new TaskExternalException(this.getString(ctx, this.RES, "CMPNUMBER") + " '" + str + "' " + this.getString(ctx, this.RES, "NOTFOUND"));
                }
                leaveDetailInfo.setCmpPeriod(cmpColl.get(0));
            }
            if ((str = (String)((DataToken)hsData.get((Object)"FTotalRegReal")).data) == null || str.trim().equalsIgnoreCase("")) {
                throw new TaskExternalException(this.getString(ctx, this.RES, "TOTAL") + str + this.getString(ctx, this.RES, "NOTNULL"));
            }
            leaveDetailInfo.setTotalRegReal(new BigDecimal(str));
            str = (String)((DataToken)hsData.get((Object)"Fcomment")).data;
            if (str != null) {
                leaveDetailInfo.setComment(str);
            } else {
                leaveDetailInfo.setComment("");
            }
            leaveDetailInfo.setCheckState(CheckStateEnum.UNCHECK);
            leaveDetailInfo.setRefrence(false);
            leaveDetailInfo.setDataOfSource(DataSourceEnum.LEAVEREG);
            leaveDetailInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
            leaveDetailInfo.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return leaveDetailInfo;
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            LeaveDetailInfo leaveDetailInfo = null;
            if (coreBaseInfo != null) {
                leaveDetailInfo = (LeaveDetailInfo)coreBaseInfo;
                if (this.isSltImportUpdate()) {
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("person", (Object)leaveDetailInfo.getPerson().getId().toString()));
                    filter.getFilterItems().add(new FilterItemInfo("startDateReal", (Object)leaveDetailInfo.getStartDateReal()));
                    filter.getFilterItems().add(new FilterItemInfo("endDateReal", (Object)leaveDetailInfo.getEndDateReal()));
                    filter.getFilterItems().add(new FilterItemInfo("timeAttendance.id", (Object)leaveDetailInfo.getTimeAttendance().getId().toString()));
                    LeaveDetailFactory.getLocalInstance(ctx).delete(filter);
                }
                LeaveDetailFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)leaveDetailInfo);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    private Timestamp getSqlTimestamp(Date date) {
        return new Timestamp(date.getTime());
    }

    private PersonInfo getPersonInfo(Context ctx, String str, boolean isNeed) throws BOSException, TaskExternalException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)str));
        view.setFilter(filterInfo);
        IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
        PersonCollection personColl = iPerson.getPersonCollection(view);
        if (personColl == null || personColl.size() == 0) {
            if (isNeed) {
                throw new TaskExternalException(this.getString(ctx, this.RES, "PNUMBER") + " '" + str + "' " + this.getString(ctx, this.RES, "NOTFOUND"));
            }
            return null;
        }
        return personColl.get(0);
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, Object> table = new Hashtable<String, Object>();
        try {
            table.put("FPersonNumber", rs.getString("person.number"));
            table.put("FName_" + LocaleUtils.getLocaleString((Locale)ctx.getLocale()).toUpperCase(), rs.getString("person.name"));
            table.put("FAttendanceNumber", rs.getString("timeAttendance.number"));
            table.put("FTotalRegReal", rs.getString("totalRegReal"));
            table.put("FStartDateReal", rs.getTimestamp("startDateReal"));
            table.put("FEndDateReal", rs.getTimestamp("endDateReal"));
            table.put("FCmpPeriodNumber", rs.getString("cmpPeriod.number"));
            String comment = rs.getString("comment");
            if (!StringUtils.isEmpty((String)comment)) {
                table.put("FComment", comment);
            }
        }
        catch (SQLException ex) {
            logger.error((Object)ex);
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
        return table;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        return null;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.hr.time.app.LeaveDetailQuery";
    }

    private String getString(Context ctx, String res, String key) {
        return ResourceBase.getString((String)res, (String)key, (Locale)ctx.getLocale());
    }
}

