/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.time.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.time.IYearVacationBalance;
import com.kingdee.eas.hr.time.LeaveReportBillEntryCollection;
import com.kingdee.eas.hr.time.LeaveReportBillEntryInfo;
import com.kingdee.eas.hr.time.LeaveReportBillInfo;
import com.kingdee.eas.hr.time.ReportToStateEnum;
import com.kingdee.eas.hr.time.TimeBaseException;
import com.kingdee.eas.hr.time.TimeBaseInfo;
import com.kingdee.eas.hr.time.YearVacationBalanceFactory;
import com.kingdee.eas.hr.time.app.AbstractLeaveReportBillControllerBean;
import com.kingdee.eas.hr.time.app.LeaveBillAppUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;

public class LeaveReportBillControllerBean
extends AbstractLeaveReportBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.time.app.LeaveReportBillControllerBean");

    protected void _save(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        LeaveReportBillInfo info = (LeaveReportBillInfo)model;
        super._save(ctx, pk, (IObjectValue)info);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        LeaveReportBillInfo info = (LeaveReportBillInfo)model;
        return super._save(ctx, (IObjectValue)info);
    }

    protected void _submit(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        LeaveReportBillInfo info = (LeaveReportBillInfo)model;
        super._submit(ctx, pk, (IObjectValue)info);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        LeaveReportBillInfo info = (LeaveReportBillInfo)model;
        return super._submit(ctx, (IObjectValue)info);
    }

    protected void _checkCanDelete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        TimeBaseInfo info = (TimeBaseInfo)this._getValue(ctx, pk);
        if (info.getBizState().getValue() != 0 && info.getBizState().getValue() != -1) {
            throw new TimeBaseException(TimeBaseException.HRBILL_CAN_NOT_DELETE);
        }
    }

    protected void _saveLeaveDetail(Context ctx, IObjectValue bill) throws BOSException, EASBizException {
        LeaveReportBillInfo info = (LeaveReportBillInfo)bill;
        LeaveBillAppUtils.saveLeaveDetailAll(ctx, info.getEntries());
    }

    private void setReportToState(Context ctx, BOSUuid billId, ReportToStateEnum state) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(billId);
        LeaveReportBillInfo info = (LeaveReportBillInfo)this._getValue(ctx, (IObjectPK)pk);
        info.setReportToState(state);
        this._update(ctx, (IObjectPK)pk, (IObjectValue)info);
    }

    protected void _setNoPassState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        super._setNoPassState(ctx, billId);
        this.setReportToState(ctx, billId, ReportToStateEnum.STOP);
    }

    protected void _setPassState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        super._setPassState(ctx, billId);
        this.setReportToState(ctx, billId, ReportToStateEnum.COMPLETE);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("entries.*"));
        sic.add(new SelectorItemInfo("entries.type.id"));
        sic.add(new SelectorItemInfo("entries.person.id"));
        sic.add(new SelectorItemInfo("entries.leaveBillEntry.*"));
        IObjectValue bill = this._getValue(ctx, (IObjectPK)new ObjectUuidPK(billId), sic);
        this._saveLeaveDetail(ctx, bill);
        LeaveReportBillInfo info = (LeaveReportBillInfo)bill;
        LeaveReportBillEntryCollection c = info.getEntries();
        LeaveReportBillEntryInfo entry = null;
        ArrayList<String> lstPerson = new ArrayList<String>();
        int size = c.size();
        for (int i = 0; i < size; ++i) {
            entry = c.get(i);
            if (entry.getType() == null || !entry.getType().getId().toString().equals("00000000-0000-0000-0000-000000000008649E3405")) continue;
            lstPerson.add(entry.getPerson().getId().toString());
        }
        if (lstPerson.size() > 0) {
            IYearVacationBalance iyvBalacne = YearVacationBalanceFactory.getLocalInstance(ctx);
            int year = Calendar.getInstance().get(1);
            iyvBalacne.calculate(year, lstPerson, 4, new Date(), 4);
        }
    }
}

