/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.time.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.time.TimeAttendanceCatalogFactory;
import com.kingdee.eas.hr.time.TimeAttendanceCatalogInfo;
import com.kingdee.eas.hr.time.TimeAttendanceException;
import com.kingdee.eas.hr.time.app.AbstractTimeAttendanceCatalogControllerBean;
import com.kingdee.eas.util.app.ContextUtil;

public class TimeAttendanceCatalogControllerBean
extends AbstractTimeAttendanceCatalogControllerBean {
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.checkAttendanceCatalogIsInner(ctx, pk);
        super._delete(ctx, pk);
    }

    void checkAttendanceCatalogIsInner(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        TimeAttendanceCatalogInfo cataInfo = this.getTimeAttendanceCatalogInfo(ctx, pk);
        if (cataInfo.isIsInner()) {
            throw new TimeAttendanceException(TimeAttendanceException.ATTENDANCE_CATALOG_INNER_NOT_DELETE);
        }
    }

    protected IObjectPK _addnew(Context arg0, IObjectValue arg1) throws BOSException, EASBizException {
        this.checkNameOrNumber(arg0, arg1);
        TimeAttendanceCatalogInfo cataInfo = (TimeAttendanceCatalogInfo)arg1;
        cataInfo.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)arg0));
        return super._addnew(arg0, (IObjectValue)cataInfo);
    }

    void checkNameOrNumber(Context ctx, IObjectValue arg1) throws EASBizException, BOSException {
        this._checkNameBlank(ctx, arg1);
        this._checkNumberBlank(ctx, arg1);
        this.checkNumberByHrRange(ctx, arg1);
        this._checkNameDup(ctx, arg1);
    }

    private void checkNumberByHrRange(Context ctx, IObjectValue obj) throws BOSException, EASBizException {
        if (obj == null) {
            return;
        }
        TimeAttendanceCatalogInfo info = (TimeAttendanceCatalogInfo)obj;
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("number", (Object)info.getNumber()));
        if (info.getId() != null) {
            TimeAttendanceCatalogInfo oldInfo = TimeAttendanceCatalogFactory.getLocalInstance(ctx).getTimeAttendanceCatalogInfo((IObjectPK)new ObjectUuidPK(info.getId().toString()));
            fi.getFilterItems().add(new FilterItemInfo("number", (Object)oldInfo.getNumber(), CompareType.NOTEQUALS));
        }
        if (super._exists(ctx, fi)) {
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{info.getNumber()});
        }
    }

    protected IObjectPK _submit(Context arg0, IObjectValue arg1) throws BOSException, EASBizException {
        return super._submit(arg0, arg1);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.checkNameOrNumber(ctx, model);
        super._update(ctx, pk, model);
    }
}

