/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.time.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.ItemSubjectEnum;
import com.kingdee.eas.hr.time.CmpRefCollection;
import com.kingdee.eas.hr.time.CmpRefFactory;
import com.kingdee.eas.hr.time.CmpRefInfo;
import com.kingdee.eas.hr.time.TimeAttendanceException;
import com.kingdee.eas.hr.time.TimeAttendanceInfo;
import com.kingdee.eas.hr.time.app.AbstractTimeAttendanceControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;

public class TimeAttendanceControllerBean
extends AbstractTimeAttendanceControllerBean {
    private static final long serialVersionUID = -61166L;
    private static final String ID = "'8c2f39a0-00ff-1115-e000-001fc0a813c30AB3465D'";

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this._checkInput(ctx, model);
        TimeAttendanceInfo timeInfo = (TimeAttendanceInfo)model;
        timeInfo.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
        super._addnew(ctx, pk, (IObjectValue)timeInfo);
        if (timeInfo.getCmpItem() != null) {
            CmpRefInfo cmpRef = new CmpRefInfo();
            cmpRef.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
            cmpRef.setTimeAttendance(timeInfo);
            timeInfo.setId(BOSUuid.read((String)pk.toString()));
            cmpRef.setCmpItem(timeInfo.getCmpItem());
            CmpRefFactory.getLocalInstance(ctx).submit(cmpRef);
        }
        DbUtil.execute((Context)ctx, (String)"Update T_HR_PARAMETER Set FNumber=FNumber+1 Where FID='8c2f39a0-00ff-1115-e000-001fc0a813c30AB3465D'");
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this._checkInput(ctx, model);
        TimeAttendanceInfo timeInfo = (TimeAttendanceInfo)model;
        timeInfo.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
        IObjectPK pk = super._addnew(ctx, (IObjectValue)timeInfo);
        if (timeInfo.getCmpItem() != null) {
            CmpRefInfo cmpRef = new CmpRefInfo();
            cmpRef.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
            timeInfo.setId(BOSUuid.read((String)pk.toString()));
            cmpRef.setTimeAttendance(timeInfo);
            cmpRef.setCmpItem(timeInfo.getCmpItem());
            CmpRefFactory.getLocalInstance(ctx).submit(cmpRef);
        }
        DbUtil.execute((Context)ctx, (String)"Update T_HR_PARAMETER Set FNumber=FNumber+1 Where FID='8c2f39a0-00ff-1115-e000-001fc0a813c30AB3465D'");
        return pk;
    }

    void _checkInput(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        this._checkNameBlank(ctx, model);
        this._checkNameDup(ctx, model);
        this._checkNumberBlank(ctx, (IObjectValue)((DataBaseInfo)model));
        this._checkNumberDup(ctx, (IObjectValue)((DataBaseInfo)model));
        this.checkOnlyCmpItem(ctx, model);
    }

    void checkOnlyCmpItem(Context ctx, IObjectValue info) throws BOSException, TimeAttendanceException {
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this._checkInput(ctx, model);
        super._update(ctx, pk, model);
        TimeAttendanceInfo timeInfo = (TimeAttendanceInfo)model;
        String sql = null;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("timeAttendance.id", (Object)timeInfo.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString()));
        if (timeInfo.getCmpItem() != null) {
            if (CmpRefFactory.getLocalInstance(ctx).exists(filter)) {
                sql = "UPDATE T_HR_CmpRef SET FCmpItemID = ? WHERE FHROrgUnitID = ? AND FTimeAttID = ? ";
                Object[] params = new Object[]{timeInfo.getCmpItem().getId().toString(), ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString(), timeInfo.getId().toString()};
                DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
            } else {
                CmpRefInfo cmpRef = new CmpRefInfo();
                cmpRef.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
                cmpRef.setTimeAttendance(timeInfo);
                cmpRef.setCmpItem(timeInfo.getCmpItem());
                CmpRefFactory.getLocalInstance(ctx).submit(cmpRef);
            }
        } else {
            CmpRefFactory.getLocalInstance(ctx).delete(filter);
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.checkAttendanceIsInner(ctx, pk);
        super._delete(ctx, pk);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("timeAttendance.id", (Object)pk.toString()));
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString()));
        CmpRefFactory.getLocalInstance(ctx).delete(filter);
    }

    void checkAttendanceIsInner(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        TimeAttendanceInfo info = this.getTimeAttendanceInfo(ctx, pk);
        if (info.getInnerType().equals((Object)ItemSubjectEnum.SYSINIT)) {
            throw new TimeAttendanceException(TimeAttendanceException.ATTENDANCE_INNER_NOT_DELETE);
        }
    }

    protected int _getMaxNumber(Context ctx) throws BOSException, EASBizException {
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)"Select FNumber From T_HR_PARAMETER Where FID='8c2f39a0-00ff-1115-e000-001fc0a813c30AB3465D'");
        try {
            rowSet.next();
            return rowSet.getInt("FNumber");
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected IObjectValue _getValue(Context ctx, IObjectPK pk, SelectorItemCollection selector, SorterItemCollection sorter) throws BOSException, EASBizException {
        TimeAttendanceInfo timeInfo = (TimeAttendanceInfo)super._getValue(ctx, pk, selector, sorter);
        timeInfo.setCmpItem(this.getCurrentHROrgUnitCmpItemInfo(ctx, timeInfo.getId()));
        return timeInfo;
    }

    protected IObjectValue _getValue(Context ctx, IObjectPK pk, SelectorItemCollection selector) throws BOSException, EASBizException {
        TimeAttendanceInfo timeInfo = (TimeAttendanceInfo)super._getValue(ctx, pk, selector);
        timeInfo.setCmpItem(this.getCurrentHROrgUnitCmpItemInfo(ctx, timeInfo.getId()));
        return timeInfo;
    }

    protected IObjectValue _getValue(Context ctx, IObjectPK pk, SorterItemCollection sorter) throws BOSException, EASBizException {
        TimeAttendanceInfo timeInfo = (TimeAttendanceInfo)super._getValue(ctx, pk, sorter);
        timeInfo.setCmpItem(this.getCurrentHROrgUnitCmpItemInfo(ctx, timeInfo.getId()));
        return timeInfo;
    }

    protected IObjectValue _getValue(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        TimeAttendanceInfo timeInfo = (TimeAttendanceInfo)super._getValue(ctx, pk);
        timeInfo.setCmpItem(this.getCurrentHROrgUnitCmpItemInfo(ctx, timeInfo.getId()));
        return timeInfo;
    }

    protected IObjectValue _getValue(Context ctx, String oql) throws BOSException, EASBizException {
        TimeAttendanceInfo timeInfo = (TimeAttendanceInfo)super._getValue(ctx, oql);
        timeInfo.setCmpItem(this.getCurrentHROrgUnitCmpItemInfo(ctx, timeInfo.getId()));
        return timeInfo;
    }

    private CmpItemInfo getCurrentHROrgUnitCmpItemInfo(Context ctx, BOSUuid timeAttID) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection sic = viewInfo.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("cmpItem.id"));
        sic.add(new SelectorItemInfo("cmpItem.name"));
        sic.add(new SelectorItemInfo("cmpItem.number"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("timeAttendance.id", (Object)timeAttID.toString()));
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString()));
        viewInfo.setFilter(filter);
        CmpRefCollection coll = CmpRefFactory.getLocalInstance(ctx).getCmpRefCollection(viewInfo);
        if (coll != null && coll.size() == 1) {
            return coll.get(0).getCmpItem();
        }
        return null;
    }

    protected void _checkNameDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TimeAttendanceInfo timeAttendanceInfo = (TimeAttendanceInfo)model;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)timeAttendanceInfo.getName()));
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString()));
        String id = null;
        if (timeAttendanceInfo.getId() != null) {
            id = timeAttendanceInfo.getId().toString();
        }
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)id, CompareType.NOTEQUALS));
        filter.setMaskString("#0 and #1 and #2");
        if (super._exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{timeAttendanceInfo.getName()});
        }
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TimeAttendanceInfo timeAttendanceInfo = (TimeAttendanceInfo)model;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)timeAttendanceInfo.getNumber()));
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", null));
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString()));
        String id = null;
        if (timeAttendanceInfo.getId() != null) {
            id = timeAttendanceInfo.getId().toString();
        }
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)id, CompareType.NOTEQUALS));
        filter.setMaskString("#0 and (#1 or #2) and #3");
        if (super._exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{timeAttendanceInfo.getNumber()});
        }
        super._checkNameDup(ctx, model);
        super._checkNumberDup(ctx, model);
    }
}

