/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.time.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.time.BizStateEnum;
import com.kingdee.eas.hr.time.app.AbstractTimeBaseFacadeControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class TimeBaseFacadeControllerBean
extends AbstractTimeBaseFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.emp.app.TimeBaseFacadeControllerBean");

    protected boolean _canUpdate(Context ctx, String billId) throws BOSException, EASBizException {
        boolean value = true;
        BOSObjectType billBosType = BOSUuid.read((String)billId).getType();
        IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx);
        String billTableName = loader.getEntity(billBosType).getTable().getName();
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        if (user.getPerson() == null) {
            throw new BOSException("current person can not be null");
        }
        String personId = user.getPerson().getId().toString();
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT FProposer, FIsMultiEntry FROM ");
        sb.append(billTableName);
        sb.append(" WHERE FID = '");
        sb.append(billId);
        sb.append("' ");
        logger.debug((Object)sb.toString());
        IRowSet rows = null;
        rows = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sb.toString()).executeSQL();
        Object id = null;
        try {
            if (rows.next()) {
                String pId = rows.getString("FProposer");
                boolean isMulti = rows.getBoolean("FIsMultiEntry");
                if (pId.equals(personId) && !isMulti) {
                    value = false;
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return value;
    }

    protected String _getSelfBillId(Context ctx, BOSObjectType billBosType, String personId, boolean isInProcess) throws BOSException, EASBizException {
        String state = "0";
        if (isInProcess) {
            state = "1";
        }
        IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx);
        String billTableName = loader.getEntity(billBosType).getTable().getName();
        PropertyCollection c = loader.getEntity(billBosType).getEntityProperties();
        int index = 0;
        int size = c.size();
        for (int i = 0; i < size; ++i) {
            if (!c.get(i).getName().equals("entries")) continue;
            index = i;
            break;
        }
        String entryTableName = ((LinkPropertyInfo)c.get(index)).getRelationship().getSupplierObject().getTable().getName();
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT A.FID AS FID FROM ");
        sb.append(billTableName);
        sb.append(" A INNER JOIN ");
        sb.append(entryTableName);
        sb.append(" B ON A.FID = B.FBillID ");
        sb.append("WHERE B.FPersonID = '");
        sb.append(personId);
        sb.append("' AND A.FState = ");
        sb.append(state);
        sb.append(" AND A.FIsMultiEntry = 0 ");
        sb.append(" ORDER BY A.FCreateTime DESC");
        logger.debug((Object)sb.toString());
        IRowSet rows = null;
        rows = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sb.toString()).executeSQL();
        String id = null;
        try {
            if (rows.next()) {
                id = rows.getString("FID");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return id;
    }

    protected void _setPassState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        this._setState(ctx, billId, BizStateEnum.COMPLETE);
    }

    protected void _setNoPassState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        this._setState(ctx, billId, BizStateEnum.STOP);
    }

    protected void _setApproveState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        this._setState(ctx, billId, BizStateEnum.APPROVE);
    }

    protected void _setEditState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        this._setState(ctx, billId, BizStateEnum.EDIT);
    }

    protected void _setState(Context ctx, BOSUuid billId, BizStateEnum state) throws BOSException, EASBizException {
    }

    protected Set _getOutRangePersonIds(Context ctx) throws BOSException {
        String userID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String hrOrgUnitID = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append(" select person.FID id from T_BD_PERSON person ");
        sql.append(" inner join t_hr_personPosition pp on person.fid = pp.fPersonId");
        sql.append(" where pp.fpersonDep in ( ");
        sql.append("SELECT FFromUnitID FROM T_ORG_UnitRelation WHERE FToUnitID = ");
        sql.append("'");
        sql.append(hrOrgUnitID);
        sql.append("'");
        sql.append(" AND ");
        sql.append(" FTypeRelationID = ");
        sql.append("'00000000-0000-0000-0000-0000000000100FE9F8B5'");
        sql.append(" AND ");
        sql.append("FFromUnitID IN (");
        sql.append("SELECT FOrgID FROM T_PM_OrgRange WHERE FUserID = ");
        sql.append("'");
        sql.append(userID);
        sql.append("'");
        sql.append(" AND ");
        sql.append("FType = ");
        sql.append(20);
        sql.append("))");
        HashSet<String> set = new HashSet<String>();
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (row.next()) {
                String id = row.getString("id");
                set.add(id);
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage());
        }
        return set;
    }

    protected Date _getServerTime(Context ctx) throws BOSException {
        return new Date();
    }
}

