/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.time.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;

public class TimeServerUtils {
    public static final String ROLL_CATA_ID = "00000000-0000-0000-0000-000000000001BE0D0183";
    public static final String HOLIDAY_CATA_ID = "00000000-0000-0000-0000-000000000002BE0D0183";
    public static final String OVERTIME_CATA_ID = "00000000-0000-0000-0000-000000000003BE0D0183";

    public static boolean getParamValue(Context ctx, String number) throws BOSException, EASBizException {
        String HRO_ID;
        IParamControl iParam = ParamControlFactory.getLocalInstance((Context)ctx);
        String val = iParam.getParamValue((IObjectPK)new ObjectUuidPK(HRO_ID = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString()), number);
        return "true".equals(val);
    }

    public static FilterInfo getHRAndAdminRangeFilterInfo(String hrColumnName, String orgUnitColumnName) {
        String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        String hrOrgUnitID = SysContext.getSysContext().getCurrentHRUnit().getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FFromUnitID FROM T_ORG_UnitRelation WHERE FToUnitID = ");
        sql.append("'");
        sql.append(hrOrgUnitID);
        sql.append("'");
        sql.append(" AND ");
        sql.append(" FTypeRelationID = ");
        sql.append("'00000000-0000-0000-0000-0000000000100FE9F8B5'");
        sql.append(" AND ");
        sql.append("FFromUnitID IN (");
        sql.append("SELECT FOrgID FROM T_PM_OrgRange WHERE FUserID = ");
        sql.append("'");
        sql.append(userID);
        sql.append("'");
        sql.append(" AND ");
        sql.append("FType = ");
        sql.append(20);
        sql.append(")");
        FilterInfo filter = new FilterInfo();
        FilterItemInfo item = new FilterItemInfo(orgUnitColumnName, (Object)sql.toString(), CompareType.INNER);
        filter.getFilterItems().add(item);
        if (hrColumnName != null) {
            item = new FilterItemInfo(hrColumnName, (Object)hrOrgUnitID);
            filter.getFilterItems().add(item);
        }
        return filter;
    }

    public static String getHRAndAdminRangePersonSQL(String hrOrgUnitID, String userID) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT PERSON.FID FROM T_BD_PERSON AS PERSON");
        sql.append(" INNER JOIN T_HR_PERSONPOSITION AS PP ON PP.FPERSONID = PERSON.FID");
        sql.append(" INNER JOIN T_ORG_UNITRELATION AS REL ON REL.FFROMUNITID = PP.FPERSONDEP");
        sql.append(" INNER JOIN T_PM_ORGRANGE AS RANGE ON RANGE.FORGID = REL.FFROMUNITID");
        sql.append(" WHERE ");
        sql.append(" REL.FTOUNITID = ");
        sql.append("'");
        sql.append(hrOrgUnitID);
        sql.append("'");
        sql.append(" AND ");
        sql.append(" REL.FTYPERELATIONID = ");
        sql.append("'");
        sql.append("00000000-0000-0000-0000-0000000000100FE9F8B5");
        sql.append("'");
        sql.append(" AND ");
        sql.append(" RANGE.FUSERID = ");
        sql.append("'");
        sql.append(userID);
        sql.append("'");
        sql.append(" AND ");
        sql.append(" RANGE.FTYPE = ");
        sql.append(20);
        return sql.toString();
    }

    public static FilterInfo getHRAndAdminOrgRangeFilter(Context ctx, String hrOrgId, String adminOrgColName) {
        String userID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FFromUnitID FROM T_ORG_UnitRelation WHERE FToUnitID = ");
        sql.append("'");
        sql.append(hrOrgId);
        sql.append("'");
        sql.append(" AND ");
        sql.append(" FTypeRelationID = ");
        sql.append("'00000000-0000-0000-0000-0000000000100FE9F8B5'");
        sql.append(" AND ");
        sql.append("FFromUnitID IN (");
        sql.append("SELECT FOrgID FROM T_PM_OrgRange WHERE FUserID = ");
        sql.append("'");
        sql.append(userID);
        sql.append("'");
        sql.append(" AND ");
        sql.append("FType = ");
        sql.append(20);
        sql.append(")");
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo(adminOrgColName, (Object)sql.toString(), CompareType.INNER));
        return fi;
    }

    static PositionInfo getPrimaryPosition(Context ctx, String personId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select person.FNumber pNum,pm.fPositionId psId,admin.FID orgId ");
        sql.append(" from T_ORG_PositionMember pm ");
        sql.append(" left join t_bd_person person on pm.fpersonId = person.fid ");
        sql.append(" left join T_ORG_Position position on pm.FPositionID = position.FID ");
        sql.append(" left join T_ORG_Admin admin on position.FAdminOrgUnitID = admin.FID ");
        sql.append(" where pm.fIsPrimary = 1 and person.FId in(");
        sql.append("'").append(personId).append("'");
        sql.append(" ) ");
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (result.next()) {
                PositionInfo psInfo = new PositionInfo();
                AdminOrgUnitInfo orgInfo = new AdminOrgUnitInfo();
                String pNum = result.getString("pNum");
                String psId = result.getString("psId");
                String orgId = result.getString("orgId");
                if (pNum == null) continue;
                if (psId != null && orgId != null) {
                    orgInfo.setId(BOSUuid.read((String)orgId));
                    psInfo.setId(BOSUuid.read((String)psId));
                    psInfo.setAdminOrgUnit(orgInfo);
                }
                return psInfo;
            }
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage());
        }
        return null;
    }

    static boolean isEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        return obj.toString().trim().length() == 0;
    }
}

