/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.time.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.kscript.ParserException;
import com.kingdee.bos.kscript.runtime.Interpreter;
import com.kingdee.bos.kscript.runtime.InterpreterException;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.hr.util.HRParamUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.eas.hr.emp.PersonPositionCollection;
import com.kingdee.eas.hr.emp.PersonPositionFactory;
import com.kingdee.eas.hr.time.ILeaveDetail;
import com.kingdee.eas.hr.time.IYearVacationRule;
import com.kingdee.eas.hr.time.LeaveDetailFactory;
import com.kingdee.eas.hr.time.ObtainVacationDateEnum;
import com.kingdee.eas.hr.time.YVRuleException;
import com.kingdee.eas.hr.time.YearVacationCarryforwardInfo;
import com.kingdee.eas.hr.time.YearVacationQuantityInfo;
import com.kingdee.eas.hr.time.YearVacationRuleCollection;
import com.kingdee.eas.hr.time.YearVacationRuleFactory;
import com.kingdee.eas.hr.time.YearVacationRuleInfo;
import com.kingdee.eas.hr.time.app.AbstractYearVacationBalanceControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class YearVacationBalanceControllerBean
extends AbstractYearVacationBalanceControllerBean {
    private static final long serialVersionUID = -61166L;
    private static final String strInsertSql = "insert into t_hr_yvbalance(fcurrquantity,fcurravaiable,flastbalance,foverdue,fused,fstatus,fpersonid,fyear) values(?,?,?,?,?,?,?,?)";
    private static final String strUpdateSql = "update t_hr_yvbalance set fcurrquantity=?,fcurravaiable=?,flastbalance=?,foverdue=?,fused=? where fpersonid=? and fyear=?";
    private static final String strDeleteSql = "delete from t_hr_yvblance where fpersonid=? and fyear=?";
    private Map mapRuleServiceYear = null;
    private Map mapYVRule = null;
    private Map mapYVRulePerson = null;
    private Map mapYVServiceYearMap = null;
    private Map mapPersonServiceYear = null;
    private Set setLeftPerson = null;
    private boolean flagPrepareDate = false;
    private float standardDays = 0.0f;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.time.app.YearVacationBalanceControllerBean");
    Map beforeUsed = null;

    protected void _addnew(Context ctx, Map mapBalance) throws BOSException, EASBizException {
        Connection cn = null;
        PreparedStatement stmt = null;
        try {
            cn = this.getConnection(ctx);
            stmt = cn.prepareStatement(strInsertSql);
            this.setStmt(stmt, mapBalance);
            stmt.execute();
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)cn);
    }

    protected void _update(Context ctx, String personId, int year, Map mapBalance) throws BOSException, EASBizException {
        Connection cn = null;
        PreparedStatement stmt = null;
        try {
            cn = this.getConnection(ctx);
            stmt = cn.prepareStatement(strUpdateSql);
            mapBalance.put("fpersonid", personId);
            mapBalance.put("fyear", year);
            this.setStmt(stmt, mapBalance);
            stmt.execute();
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)cn);
    }

    private void setStmt(PreparedStatement stmt, Map map) throws SQLException {
        int i = 1;
        stmt.setFloat(i++, ((Float)map.get("fcurrquantity")).floatValue());
        stmt.setFloat(i++, ((Float)map.get("fcurravaiable")).floatValue());
        stmt.setFloat(i++, ((Float)map.get("flastbalance")).floatValue());
        stmt.setFloat(i++, ((Float)map.get("foverdue")).floatValue());
        stmt.setFloat(i++, ((Float)map.get("fused")).floatValue());
        stmt.setString(i++, (String)map.get("fpersonid"));
        stmt.setInt(i++, (Integer)map.get("fyear"));
    }

    protected void _updateBalacne(Context ctx, int year, List lstValue) throws BOSException, EASBizException {
        Connection cn = null;
        PreparedStatement stmt = null;
        try {
            cn = this.getConnection(ctx);
            stmt = cn.prepareStatement(strUpdateSql);
            Map mapBalance = null;
            int size = lstValue.size();
            for (int j = 0; j < size; ++j) {
                mapBalance = (Map)lstValue.get(j);
                this.setStmt(stmt, mapBalance);
                stmt.addBatch();
            }
            stmt.executeBatch();
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)cn);
    }

    protected void _delete(Context ctx, String personId, int year) throws BOSException, EASBizException {
        Connection cn = null;
        PreparedStatement stmt = null;
        try {
            cn = this.getConnection(ctx);
            stmt = cn.prepareStatement(strDeleteSql);
            int i = 1;
            stmt.setString(i++, personId);
            stmt.setInt(i++, year);
            stmt.execute();
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)cn);
    }

    private void deleteYearData(Context ctx, int year, List lstPerson) throws BOSException {
        Connection cn = null;
        PreparedStatement stmt = null;
        String sql = "delete from t_hr_yvbalance where fyear = " + year;
        if (lstPerson.size() > 0) {
            TempTablePool pool = TempTablePool.getInstance((Context)ctx);
            HashSet idSet = new HashSet();
            for (int i = 0; i < lstPerson.size(); ++i) {
                idSet.addAll(lstPerson);
            }
            String tempPoolName = this.createIdTmpTable(ctx, pool, idSet);
            String where = " and fpersonid in (select fid from " + tempPoolName + ")";
            sql = sql + where;
            try {
                cn = this.getConnection(ctx);
                stmt = cn.prepareStatement(sql);
                stmt.execute();
            }
            catch (Exception e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(stmt, (Connection)cn);
                    pool.releaseTable(tempPoolName);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)stmt, (Connection)cn);
            pool.releaseTable(tempPoolName);
        }
    }

    protected float _calculateAvailableValue(Context ctx, String personId, int year) throws BOSException, EASBizException {
        YearVacationRuleInfo ruleInfo = this.getYVRInfoFromCache(ctx, personId);
        float currQuantity = this._calculateYearVacation(ctx, personId, year);
        return this.calculateEachPerson(ctx, ruleInfo, currQuantity, personId, year);
    }

    private YearVacationRuleInfo getYVRInfoFromCache(Context ctx, String personId) throws BOSException, EASBizException {
        YearVacationRuleInfo ruleInfo = null;
        ruleInfo = this.mapYVRulePerson != null && this.mapYVRulePerson.size() > 0 ? this.getYVRule(personId) : this.getYVRInfoByPerson(ctx, personId);
        return ruleInfo;
    }

    protected float _calculateYearVacation(Context ctx, String personId, int year) throws BOSException, EASBizException {
        int joinYear;
        Calendar calJoin;
        YearVacationRuleInfo ruleInfo = this.getYVRInfoFromCache(ctx, personId);
        int type = ruleInfo.getQuantity().getServiceYearType().getValue();
        float serviceYear = this.getServiceYear(ctx, type, personId);
        Date baseDate = this.getEnterOrOffDate(personId, true);
        if (baseDate == null) {
            return 0.0f;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(baseDate);
        Date temp = null;
        if (type == 20) {
            if (this.getJoinDate(personId) == null) {
                return 0.0f;
            }
            calJoin = Calendar.getInstance();
            calJoin.setTime(this.getJoinDate(personId));
            joinYear = calJoin.get(1);
            if (joinYear > year) {
                return 0.0f;
            }
            if (DateTimeUtils.dayBefore((Date)new Date(), (Date)this.getJoinDate(personId))) {
                return 0.0f;
            }
        } else if (type == 10) {
            if (this.getJoinGroupDate(personId) == null) {
                return 0.0f;
            }
            calJoin = Calendar.getInstance();
            calJoin.setTime(this.getJoinGroupDate(personId));
            joinYear = calJoin.get(1);
            if (joinYear > year) {
                return 0.0f;
            }
            if (DateTimeUtils.dayBefore((Date)new Date(), (Date)this.getJoinGroupDate(personId))) {
                return 0.0f;
            }
        } else if (type == 30) {
            temp = this.getBeginWorkDate(personId);
            if (temp == null) {
                return 0.0f;
            }
            calJoin = Calendar.getInstance();
            calJoin.setTime(temp);
            joinYear = calJoin.get(1);
            if (joinYear > year) {
                return 0.0f;
            }
            if (DateTimeUtils.dayBefore((Date)new Date(), (Date)temp)) {
                return 0.0f;
            }
        }
        if (!this.isHoldYearVacation(ruleInfo, personId)) {
            return 0.0f;
        }
        float days = 0.0f;
        YearVacationQuantityInfo yvQuantity = ruleInfo.getQuantity();
        String ServiceYearSet = yvQuantity.getServiceYearSet();
        days = ServiceYearSet.indexOf("_") == -1 ? this.getYVDays(ruleInfo, serviceYear) : this.getYCDayS(serviceYear, ServiceYearSet);
        days = this.calculateEachPerson(ctx, ruleInfo, days, personId, year);
        int precision = ruleInfo.getQuantity().getPrecisionLength();
        float bigValue = 0.0f;
        boolean isChecked = ruleInfo.getQuantity().isIsChecked();
        bigValue = isChecked ? this.setScale(days, 0, 30) : this.setScale(days, precision, 0);
        return bigValue;
    }

    private float getYCDayS(float serviceYear, String ServiceYearSet) throws InterpreterException, ParserException {
        float days = 0.0f;
        String[] items = ServiceYearSet.split("&");
        StringBuffer text = new StringBuffer();
        for (int i = 0; i < items.length; ++i) {
            String[] subItemss = items[i].split("_");
            if (subItemss.length != 3) continue;
            text.append("if(");
            text.append("list" + subItemss[0].trim() + subItemss[1].trim());
            text.append("){return ");
            text.append(subItemss[2].trim());
            text.append(";}");
        }
        Interpreter interpreter = new Interpreter();
        HashMap<String, Float> context = new HashMap<String, Float>();
        context.put("list", new Float(serviceYear));
        if (text != null) {
            days = Float.parseFloat(interpreter.eval(text.toString(), context) != null ? interpreter.eval(text.toString(), context).toString() : "0");
        }
        return days;
    }

    protected float _carryforwardYearVacation(Context ctx, String personId, int year, float availVacation) throws EASBizException, BOSException {
        YearVacationRuleInfo ruleInfo = this.getYVRInfoFromCache(ctx, personId);
        YearVacationCarryforwardInfo yvCarry = ruleInfo.getCarryforward();
        return this.carryforwardYearVacation(yvCarry, availVacation);
    }

    private float carryforwardYearVacation(YearVacationCarryforwardInfo yvCarry, float days) {
        float lastBalance = 0.0f;
        if (yvCarry.isIsAbandon()) {
            lastBalance = days;
        } else {
            int maxValue = yvCarry.getObtainDays();
            lastBalance = (float)maxValue > days ? days : (float)maxValue;
            lastBalance = this.setScale(lastBalance, yvCarry.getPrecision(), yvCarry.getPrecisionType().getValue());
        }
        return lastBalance;
    }

    private float setScale(float value, int precision, int type) {
        BigDecimal bigValue = new BigDecimal(new Float(value).toString());
        switch (type) {
            case 30: {
                bigValue = bigValue.setScale(precision, 1);
                break;
            }
            case 10: {
                bigValue = bigValue.setScale(precision, 5);
                break;
            }
            case 20: {
                bigValue = bigValue.setScale(precision, 0);
                break;
            }
            default: {
                bigValue = bigValue.setScale(precision, 0);
            }
        }
        return bigValue.floatValue();
    }

    private float getValueOfReserved(YearVacationCarryforwardInfo cInfo, float available) {
        int type = cInfo.getReservationType().getValue();
        float reservedValue = cInfo.getReservationValue();
        if (type == 10) {
            if (reservedValue > available) {
                reservedValue = available;
            }
        } else {
            reservedValue = available * reservedValue / 100.0f;
        }
        return reservedValue;
    }

    protected Map _calculateYearVacation(Context ctx, List lstPerson, int year) throws BOSException, EASBizException {
        this.prepareData(ctx, lstPerson, year);
        int size = lstPerson.size();
        HashMap<String, Float> map = new HashMap<String, Float>((int)((double)size * 1.5));
        for (int i = 0; i < size; ++i) {
            String personId = (String)lstPerson.get(i);
            float days = this._calculateYearVacation(ctx, personId, year);
            map.put(personId, new Float(days));
        }
        return map;
    }

    private float calculateEachPerson(Context ctx, YearVacationRuleInfo yvRule, float currQuantity, String personId, int year) throws EASBizException, BOSException {
        YearVacationQuantityInfo yvQuantity = yvRule.getQuantity();
        float available = 0.0f;
        Date baseDate = this.getEnterOrOffDate(personId, true);
        if (baseDate == null) {
            return 0.0f;
        }
        Calendar cal = Calendar.getInstance();
        int type = yvRule.getQuantity().getServiceYearType().getValue();
        Date joinDate = null;
        if (type == 20) {
            joinDate = this.getJoinDate(personId);
        } else if (type == 10) {
            joinDate = this.getJoinGroupDate(personId);
        } else if (type == 30) {
            joinDate = this.getBeginWorkDate(personId);
        }
        if (ObtainVacationDateEnum.ENTER_ONE_YEAR == yvQuantity.getObtainVacationDate()) {
            baseDate = DateTimeUtils.addYear((Date)baseDate, (int)1);
        }
        if (ObtainVacationDateEnum.TRYOUT_END_DATE == yvQuantity.getObtainVacationDate()) {
            baseDate = this.getFormalDate(personId);
        }
        cal.setTime(baseDate);
        Date startDate = YearVacationRuleInfo.strToDate(yvQuantity.getVacationStartDate(), year);
        Calendar calStart = Calendar.getInstance();
        calStart.setTime(startDate);
        if (cal.get(1) < year) {
            available = currQuantity;
        } else if (cal.get(1) == year) {
            int precType = yvQuantity.getPrecisionType().getValue();
            if (precType == 10) {
                int days = 0;
                days = 365 - cal.get(6) + 1;
                available = (float)days * this.calByDayOfAvaiable(currQuantity);
            } else if (precType == 20) {
                available = this.calByMonthOfAvaiable(ctx, personId, yvRule, currQuantity, calStart.get(2));
            }
        } else {
            available = 0.0f;
        }
        return available;
    }

    protected Map _carryforwardYearVacation(Context ctx, List lstPerson, int year, Map mapAvailVacation) throws BOSException, EASBizException {
        int size = lstPerson.size();
        HashMap<String, Float> map = new HashMap<String, Float>((int)(1.5 * (double)size));
        String personId = null;
        for (int i = 0; i < size; ++i) {
            personId = (String)lstPerson.get(i);
            if (!mapAvailVacation.containsKey(personId)) continue;
            float availVacation = ((Float)mapAvailVacation.get(personId)).floatValue();
            float actualVacation = this._carryforwardYearVacation(ctx, personId, year, availVacation);
            map.put(personId, new Float(actualVacation));
        }
        return map;
    }

    protected void _calculateAvailableValue(Context ctx, int year, List lstPerson, String ruleId) throws EASBizException, BOSException {
        YearVacationRuleInfo ruleInfo = this.getYVRInfo(ctx, ruleId);
        int size = lstPerson.size();
        HashMap<String, Float> map = new HashMap<String, Float>((int)((double)size * 1.5));
        for (int i = 0; i < size; ++i) {
            String personId = (String)lstPerson.get(i);
            float currQuantity = this._calculateYearVacation(ctx, personId, year);
            float available = this.calculateEachPerson(ctx, ruleInfo, currQuantity, personId, year);
            map.put(personId, new Float(available));
        }
        this.updateValue(ctx, year, "fcurravaiable", map);
    }

    protected void _calculateYearVacation(Context ctx, int year, List lstPerson, String ruleId) throws BOSException, EASBizException {
        YearVacationRuleInfo ruleInfo = this.getYVRInfo(ctx, ruleId);
        int serviceYearType = ruleInfo.getQuantity().getServiceYearType().getValue();
        int size = lstPerson.size();
        HashMap<String, Float> map = new HashMap<String, Float>((int)((double)size * 1.5));
        YearVacationQuantityInfo yvQuantity = null;
        String ServiceYearSet = null;
        for (int i = 0; i < size; ++i) {
            String personId = (String)lstPerson.get(i);
            float days = 0.0f;
            float serviceYear = this.getServiceYear(ctx, serviceYearType, personId);
            if (this.isHoldYearVacation(ruleInfo, personId)) {
                yvQuantity = ruleInfo.getQuantity();
                if (yvQuantity == null) continue;
                ServiceYearSet = yvQuantity.getServiceYearSet();
                days = ServiceYearSet.indexOf("_") == -1 ? this.getYVDays(ruleInfo, serviceYear) : this.getYCDayS(serviceYear, ServiceYearSet);
            }
            map.put(personId, new Float(days));
        }
        this.updateValue(ctx, year, "fcurrquantity", map);
    }

    protected void _carryforwardYearVacation(Context ctx, int year, List lstPerson, String ruleId, Map mapValue) throws BOSException, EASBizException {
    }

    protected void _updateValue(Context ctx, int year, String fieldName, Map mapValue) throws BOSException, EASBizException {
        Connection cn = null;
        PreparedStatement stmt = null;
        String sql = "update t_hr_yvbalance set " + fieldName + "=? where fpersonid=? and fyear=?";
        try {
            cn = this.getConnection(ctx);
            stmt = cn.prepareStatement(sql);
            for (Map.Entry entry : mapValue.entrySet()) {
                String personId = (String)entry.getKey();
                int i = 1;
                stmt.setFloat(i++, ((Float)mapValue.get(personId)).floatValue());
                stmt.setString(i++, personId);
                stmt.setInt(i++, year);
                stmt.addBatch();
            }
            stmt.executeBatch();
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)cn);
    }

    protected void _initYearVacation(Context ctx, String ruleId, int year, boolean overlay) throws BOSException, EASBizException {
        List lstPerson = this.getPersonOfRule(ctx, ruleId);
        this._initYearVacation(ctx, lstPerson, year, overlay);
    }

    protected void _initYearVacation(Context ctx, List lstPerson, int year, boolean overlay) throws BOSException, EASBizException {
        if (lstPerson == null || lstPerson.size() == 0) {
            return;
        }
        Map mapQuantity = this._calculateYearVacation(ctx, lstPerson, year);
        Map mapAvail = this.getAvailQuantity(ctx, mapQuantity, year);
        List lstPer = this.getPerList(ctx, year, lstPerson);
        if (overlay) {
            this.deleteYearData(ctx, year, lstPer);
        }
        this.insertValue(ctx, lstPer, year, mapQuantity, mapAvail, null);
    }

    private Map getAvailQuantity(Context ctx, Map mapQuantity, int year) {
        HashMap<String, Float> map = new HashMap<String, Float>(mapQuantity.size());
        Iterator itor = mapQuantity.entrySet().iterator();
        YearVacationRuleInfo ruleInfo = null;
        while (itor.hasNext()) {
            Map.Entry entry = itor.next();
            String personId = (String)entry.getKey();
            Float value = new Float(0.0f);
            try {
                ruleInfo = this.getYVRInfoFromCache(ctx, personId);
                if (this.isUseYearVacation(ruleInfo, personId)) {
                    value = (Float)mapQuantity.get(personId);
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage());
            }
            map.put(personId, value);
        }
        return map;
    }

    private void insertValue(Context ctx, List lstPerson, int year, Map mapQuantity, Map mapAvailablity, Map mapCarryforward) throws BOSException {
        this.setYearVactionValue(ctx, strInsertSql, lstPerson, year, mapQuantity, mapAvailablity, mapCarryforward, null, null);
    }

    private void setYearVactionValue(Context ctx, String sql, List lstPerson, int year, Map mapQuantity, Map mapAvailablity, Map mapCarryforward, Map mapOverdue, Map mapUsed) throws BOSException {
        int size = lstPerson.size();
        if (size == 0) {
            return;
        }
        Connection cn = null;
        PreparedStatement stmt = null;
        try {
            cn = this.getConnection(ctx);
            stmt = cn.prepareStatement(strInsertSql);
            for (int j = 0; j < size; ++j) {
                String personId = (String)lstPerson.get(j);
                int i = 1;
                stmt.setFloat(i++, this.getValue(personId, mapQuantity));
                stmt.setFloat(i++, this.getValue(personId, mapAvailablity));
                stmt.setFloat(i++, this.getValue(personId, mapCarryforward));
                stmt.setFloat(i++, this.getValue(personId, mapOverdue));
                stmt.setFloat(i++, this.getValue(personId, mapUsed));
                stmt.setInt(i++, 0);
                stmt.setString(i++, personId);
                stmt.setInt(i++, year);
                stmt.addBatch();
            }
            stmt.executeBatch();
        }
        catch (SQLException se) {
            try {
                throw new BOSException((Throwable)se);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)cn);
    }

    private float getYVDays(YearVacationRuleInfo ruleInfo, float serviceYear) {
        int[] arrServiceYear = null;
        String ruleId = ruleInfo.getId().toString();
        arrServiceYear = this.mapRuleServiceYear != null && this.mapRuleServiceYear.containsKey(ruleId) ? (int[])this.mapRuleServiceYear.get(ruleId) : this.sortArraySeviceYear(ruleInfo);
        int serviceKey = this.getServiceKey(serviceYear, arrServiceYear);
        YearVacationQuantityInfo yvQuantity = ruleInfo.getQuantity();
        Map map = null;
        map = this.mapYVServiceYearMap != null && this.mapYVServiceYearMap.containsKey(ruleId) ? (Map)this.mapYVServiceYearMap.get(ruleId) : yvQuantity.parseQuantity(yvQuantity.getServiceYearSet());
        if (map.get(serviceKey) == null) {
            return 0.0f;
        }
        return new Float(map.get(serviceKey).toString()).floatValue();
    }

    private int getServiceKey(float serviceYear, int[] arrServiceYear) {
        int i;
        for (i = 0; i < arrServiceYear.length && !(serviceYear <= (float)arrServiceYear[i]); ++i) {
        }
        if (i == arrServiceYear.length) {
            --i;
        }
        return arrServiceYear[i];
    }

    private int[] sortArraySeviceYear(YearVacationRuleInfo ruleInfo) {
        YearVacationQuantityInfo yvQuantity = ruleInfo.getQuantity();
        Map map = yvQuantity.parseQuantity(yvQuantity.getServiceYearSet());
        Object[] arr = map.keySet().toArray();
        int[] arrServiceYear = new int[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            arrServiceYear[i] = (Integer)arr[i];
        }
        Arrays.sort(arrServiceYear);
        if (this.mapYVServiceYearMap != null) {
            this.mapYVServiceYearMap.put(ruleInfo.getId().toString(), map);
        }
        return arrServiceYear;
    }

    private Map getUsedVacation(Context ctx, List lstPerson, int year, int type, Date endDate) throws EASBizException, BOSException {
        ILeaveDetail leave = LeaveDetailFactory.getLocalInstance(ctx);
        return leave.getUsedVacation(lstPerson, null, year, 1, endDate);
    }

    private Map getUsedCancleVacation(Context ctx, List lstPerson, int year, int type, Date endDate) throws EASBizException, BOSException {
        ILeaveDetail leave = LeaveDetailFactory.getLocalInstance(ctx);
        return leave.getUsedCancleVacation(lstPerson, null, year, 1, endDate);
    }

    private float calByDayOfAvaiable(float quantity) {
        return quantity / 365.0f;
    }

    private boolean getStatusOfPerson(String personId) {
        return !this.setLeftPerson.contains(personId);
    }

    private Set getLeftPerson(Context ctx) throws BOSException {
        Connection cn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String sql = "select a.fid from t_bd_person a,t_hr_bdemployeetype b where a.femployeetypeid = b.fid and b.finservice = 2";
        HashSet<String> setLeft = new HashSet<String>(128);
        try {
            cn = this.getConnection(ctx);
            stmt = cn.prepareStatement(sql);
            rs = stmt.executeQuery();
            while (rs.next()) {
                setLeft.add(rs.getString("fid"));
            }
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)cn);
        return setLeft;
    }

    private float calByMonthOfAvaiable(Context ctx, String personId, YearVacationRuleInfo yvrule, float vacaDaysOfYear, int startMonth) {
        float vacaDays = 0.0f;
        boolean status = this.getStatusOfPerson(personId);
        YearVacationQuantityInfo yvQuantity = yvrule.getQuantity();
        Date baseDate = this.getEnterOrOffDate(personId, status);
        if (ObtainVacationDateEnum.TRYOUT_END_DATE == yvQuantity.getObtainVacationDate()) {
            baseDate = this.getFormalDate(personId);
        }
        if (baseDate == null) {
            return 0.0f;
        }
        int type = yvQuantity.getConvertType().getValue();
        if (type == 10) {
            vacaDays = this.getVacationDaysByAllDay(personId, baseDate, status, vacaDaysOfYear, yvQuantity, startMonth);
        } else if (type == 20) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(baseDate);
            int dayth = cal.get(5);
            int month = cal.get(2) + 1;
            int subType = yvQuantity.getConvertTypeValue();
            float days = this.getStandardDays(ctx);
            if (subType == 20) {
                days = this.getDaysOfMonth(cal.get(1), month);
            }
            if (startMonth > month) {
                month = startMonth;
            }
            if (status) {
                cal.setTime(new Date());
                int lastDay = DateTimeUtils.daysOfMonth((int)cal.get(1), (int)month);
                vacaDays = ((float)(lastDay - dayth + 1) / days + (float)(12 - month)) * (vacaDaysOfYear / 12.0f);
            } else {
                vacaDays = ((float)dayth / days + (float)(12 - month)) * (vacaDaysOfYear / 12.0f);
            }
        }
        return vacaDays;
    }

    private int getDaysOfMonth(int year, int month) {
        if (month == 4 || month == 6 || month == 9 || month == 11) {
            return 30;
        }
        if (month == 2) {
            GregorianCalendar gcal = new GregorianCalendar();
            if (gcal.isLeapYear(year)) {
                return 29;
            }
            return 28;
        }
        return 31;
    }

    private float getStandardDays(Context ctx) {
        if (this.standardDays > 0.0f) {
            return this.standardDays;
        }
        try {
            BigDecimal bigV = HRUtils.getSysConfigInfo((Context)ctx).getMonStaWorkDays();
            this.standardDays = bigV.floatValue();
        }
        catch (Exception e) {
            return 20.92f;
        }
        return this.standardDays;
    }

    private float getVacationDaysByAllDay(String personId, Date baseDate, boolean status, float vacaDaysOfYear, YearVacationQuantityInfo yvQuantity, int startMonth) {
        int dateNo = yvQuantity.getConvertTypeValue();
        Calendar cal = Calendar.getInstance();
        cal.setTime(baseDate);
        int dayOfMonth = cal.get(5);
        int month = cal.get(2);
        int restMonth = 0;
        if (startMonth > month) {
            month = startMonth;
        }
        restMonth = status ? (dayOfMonth <= dateNo ? 12 - month : 11 - month) : (dayOfMonth <= dateNo ? month : month + 1);
        return (float)restMonth * (vacaDaysOfYear / 12.0f);
    }

    private YearVacationRuleInfo getYVRule(String personId) {
        HashSet set;
        Iterator itor = this.mapYVRulePerson.keySet().iterator();
        String key = null;
        while (itor.hasNext() && !(set = (HashSet)this.mapYVRulePerson.get(key = (String)itor.next())).contains(personId)) {
        }
        return (YearVacationRuleInfo)this.mapYVRule.get(key);
    }

    private Date getEnterOrOffDate(String personId, boolean status) {
        Date date = null;
        if (!this.mapPersonServiceYear.containsKey(personId)) {
            return date;
        }
        date = status ? ((SimplePersonInfo)this.mapPersonServiceYear.get((Object)personId)).enterDate : ((SimplePersonInfo)this.mapPersonServiceYear.get((Object)personId)).leftDate;
        return date;
    }

    private Date getJoinDate(String personId) {
        Date date = null;
        if (!this.mapPersonServiceYear.containsKey(personId)) {
            return date;
        }
        date = ((SimplePersonInfo)this.mapPersonServiceYear.get((Object)personId)).joinDate;
        return date;
    }

    private Date getJoinGroupDate(String personId) {
        Date date = null;
        if (!this.mapPersonServiceYear.containsKey(personId)) {
            return date;
        }
        date = ((SimplePersonInfo)this.mapPersonServiceYear.get((Object)personId)).joinGroupDate;
        return date;
    }

    private Date getFormalDate(String personId) {
        if (!this.mapPersonServiceYear.containsKey(personId)) {
            return new Date();
        }
        Date date = ((SimplePersonInfo)this.mapPersonServiceYear.get((Object)personId)).formalDate;
        return date;
    }

    private Date getBeginWorkDate(String personId) {
        if (!this.mapPersonServiceYear.containsKey(personId)) {
            return null;
        }
        Date date = ((SimplePersonInfo)this.mapPersonServiceYear.get((Object)personId)).beginWorkDate;
        return date;
    }

    private float getServiceYear(Context ctx, int type, String personId) throws BOSException, EASBizException {
        float days = 0.0f;
        String FHROrgUnitID = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        if (HRParamUtil.getParamOfHR((Context)ctx, (String)"IS_Adjusted_Value", (String)FHROrgUnitID)) {
            if (type == 20) {
                if (this.mapPersonServiceYear.get(personId) != null) {
                    return ((SimplePersonInfo)this.mapPersonServiceYear.get((Object)personId)).serviceYearForCompany - ((SimplePersonInfo)this.mapPersonServiceYear.get((Object)personId)).adjustCoValue;
                }
                return days;
            }
            if (type == 10) {
                if (this.mapPersonServiceYear.get(personId) != null) {
                    return ((SimplePersonInfo)this.mapPersonServiceYear.get((Object)personId)).serviceYearForGroup - ((SimplePersonInfo)this.mapPersonServiceYear.get((Object)personId)).adjustGroupVal;
                }
                return days;
            }
            if (type == 30) {
                if (this.mapPersonServiceYear.get(personId) != null) {
                    if (this.mapPersonServiceYear.get(personId) == null) {
                        return 0.0f;
                    }
                    Date date = ((SimplePersonInfo)this.mapPersonServiceYear.get((Object)personId)).beginWorkDate;
                    if (date == null) {
                        return 0.0f;
                    }
                    Calendar begin = Calendar.getInstance();
                    begin.setTime(date);
                    Calendar end = Calendar.getInstance();
                    float ret = 0.0f;
                    ret = ret + (float)end.get(1) - (float)begin.get(1) - ((SimplePersonInfo)this.mapPersonServiceYear.get((Object)personId)).adjustWorkValue;
                    return ret += ((float)(end.get(2) - begin.get(2)) - ((SimplePersonInfo)this.mapPersonServiceYear.get((Object)personId)).adjustWorkValue) / 12.0f;
                }
                return days;
            }
            return 0.0f;
        }
        if (type == 20) {
            if (this.mapPersonServiceYear.get(personId) != null) {
                return ((SimplePersonInfo)this.mapPersonServiceYear.get((Object)personId)).serviceYearForCompany;
            }
            return days;
        }
        if (type == 10) {
            if (this.mapPersonServiceYear.get(personId) != null) {
                return ((SimplePersonInfo)this.mapPersonServiceYear.get((Object)personId)).serviceYearForGroup;
            }
            return days;
        }
        if (type == 30) {
            if (this.mapPersonServiceYear.get(personId) != null) {
                if (this.mapPersonServiceYear.get(personId) == null) {
                    return 0.0f;
                }
                Date date = ((SimplePersonInfo)this.mapPersonServiceYear.get((Object)personId)).beginWorkDate;
                if (date == null) {
                    return 0.0f;
                }
                Calendar begin = Calendar.getInstance();
                begin.setTime(date);
                Calendar end = Calendar.getInstance();
                float ret = 0.0f;
                ret = ret + (float)end.get(1) - (float)begin.get(1);
                return ret += (float)(end.get(2) - begin.get(2)) / 12.0f;
            }
            return days;
        }
        return 0.0f;
    }

    private boolean isHoldYearVacation(YearVacationRuleInfo ruleInfo, String personId) {
        Date currDate = new Date();
        YearVacationQuantityInfo quanInfo = ruleInfo.getQuantity();
        Date obtainDate = this.getObtainValPoint(quanInfo.getObtainVacationDate().getValue(), personId);
        if (obtainDate == null) {
            return false;
        }
        return !DateTimeUtils.dayBefore((Date)currDate, (Date)obtainDate);
    }

    private boolean isUseYearVacation(YearVacationRuleInfo ruleInfo, String personId) {
        Date currDate = new Date();
        YearVacationQuantityInfo quanInfo = ruleInfo.getQuantity();
        Date useDate = this.getUsePoint(quanInfo.getUseVacationDate().getValue(), personId);
        if (useDate == null) {
            return false;
        }
        return !DateTimeUtils.dayBefore((Date)currDate, (Date)useDate);
    }

    private Date getObtainPoint(int type, String personId) {
        if (type == 10) {
            return this.getEnterOrOffDate(personId, true);
        }
        return this.getFormalDate(personId);
    }

    private Date getUsePoint(int type, String personId) {
        if (type == 20) {
            Date date = this.getEnterOrOffDate(personId, true);
            if (date != null) {
                return DateTimeUtils.addYear((Date)this.getEnterOrOffDate(personId, true), (int)1);
            }
            return null;
        }
        return this.getObtainPoint(type, personId);
    }

    private Date getObtainValPoint(int type, String personId) {
        if (type == 40) {
            Date date = this.getEnterOrOffDate(personId, true);
            if (date != null) {
                return DateTimeUtils.addYear((Date)this.getEnterOrOffDate(personId, true), (int)1);
            }
            return null;
        }
        return this.getObtainPoint(type, personId);
    }

    private Map getPersonsOfYVRule(Context ctx, int year, HashSet setPerson) throws BOSException {
        HashMap map = new HashMap(16);
        Connection cn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        HashSet<String> set = null;
        boolean small = true;
        int size = setPerson.size();
        String sql = "select fyvruleid,fpersonid from t_hr_yvperson ";
        if (size > 0) {
            if (size <= 5000) {
                sql = sql + " where " + this.getWhereInCaluse(ctx, setPerson);
            } else {
                small = false;
            }
        } else {
            small = false;
        }
        try {
            cn = this.getConnection(ctx);
            stmt = cn.prepareStatement(sql);
            rs = stmt.executeQuery();
            while (rs.next()) {
                String personId = rs.getString(2);
                if (!small && size > 0 && !setPerson.contains(personId)) continue;
                String yvrule = rs.getString(1);
                if (map.containsKey(yvrule)) {
                    set = (HashSet<String>)map.get(yvrule);
                } else {
                    set = new HashSet<String>(256);
                    map.put(yvrule, set);
                }
                set.add(personId);
            }
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)cn);
                TempTablePool pool = TempTablePool.getInstance((Context)ctx);
                if (ctx.get((Object)"hrTimeVacationTmpTable") != null) {
                    pool.releaseTable(ctx.get((Object)"hrTimeVacationTmpTable").toString());
                }
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)cn);
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        if (ctx.get((Object)"hrTimeVacationTmpTable") != null) {
            pool.releaseTable(ctx.get((Object)"hrTimeVacationTmpTable").toString());
        }
        return map;
    }

    private String getWhereInCaluse(Set set) {
        StringBuffer buff = new StringBuffer(3192);
        buff.append(" fpersonid in (");
        Iterator itor = set.iterator();
        while (itor.hasNext()) {
            buff.append("'" + itor.next() + "',");
        }
        return buff.substring(0, buff.length() - 1) + ")";
    }

    private String getWhereInCaluse(Context ctx, Set set) throws BOSException {
        String tempPoolName;
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        StringBuffer buff = new StringBuffer(3192);
        try {
            tempPoolName = this.createIdTmpTable(ctx, pool, set);
            String where = "select fid from " + tempPoolName + ")";
            buff.append(" fpersonid in (");
            buff.append(where);
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
        ctx.put((Object)"hrTimeVacationTmpTable", (Object)tempPoolName);
        return buff.toString();
    }

    private String getYVRuleId(Context ctx, String personId) throws BOSException, YVRuleException {
        String sql = "select fyvruleid from t_hr_yvperson where fpersonid='" + personId + "'";
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (!rs.next()) {
                throw new YVRuleException(YVRuleException.NOT_EXIST_YV);
            }
            String string = rs.getString(1);
            return string;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("quantity.*"));
        sic.add(new SelectorItemInfo("carryforward.*"));
        return sic;
    }

    private YearVacationRuleInfo getYVRInfo(Context ctx, String yvRuleId) throws EASBizException, BOSException {
        IYearVacationRule iyv = YearVacationRuleFactory.getLocalInstance(ctx);
        return iyv.getYearVacationRuleInfo((IObjectPK)new ObjectUuidPK(yvRuleId), this.getSelectors());
    }

    private YearVacationRuleInfo getYVRInfoByPerson(Context ctx, String personId) throws EASBizException, BOSException {
        String ruleId = this.getYVRuleId(ctx, personId);
        return this.getYVRInfo(ctx, ruleId);
    }

    private Map getYVRCollection(Context ctx, Set setRule) throws BOSException {
        IYearVacationRule iyv = YearVacationRuleFactory.getLocalInstance(ctx);
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (setRule.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("Id", (Object)setRule, CompareType.INCLUDE));
        }
        ev.setFilter(filter);
        YearVacationRuleCollection yvcoll = iyv.getYearVacationRuleCollection(ev);
        HashMap<String, YearVacationRuleInfo> map = new HashMap<String, YearVacationRuleInfo>(32);
        int size = yvcoll.size();
        for (int i = 0; i < size; ++i) {
            String yvruleId = yvcoll.get(i).getId().toString();
            map.put(yvruleId, yvcoll.get(i));
        }
        return map;
    }

    private void getPersonBaseInfo(Context ctx, List personList) throws BOSException {
        if (personList.size() == 0) {
            return;
        }
        Object personInfo = null;
        HashSet<String> set = new HashSet<String>();
        int n = personList.size();
        for (int i = 0; i < n; ++i) {
            set.add(personList.get(i).toString());
        }
        IRowSet rowSet = null;
        if (set.size() < 500) {
            set.addAll(personList);
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("person.id", set, CompareType.INCLUDE));
            viewInfo.setFilter(filter);
            viewInfo.getSelector().add(new SelectorItemInfo("id"));
            viewInfo.getSelector().add(new SelectorItemInfo("person.id"));
            viewInfo.getSelector().add(new SelectorItemInfo("enterDate"));
            viewInfo.getSelector().add(new SelectorItemInfo("leftDate"));
            viewInfo.getSelector().add(new SelectorItemInfo("formalDate"));
            viewInfo.getSelector().add(new SelectorItemInfo("joinDate"));
            viewInfo.getSelector().add(new SelectorItemInfo("joinGroupDate"));
            viewInfo.getSelector().add(new SelectorItemInfo("joinCompanyYears"));
            viewInfo.getSelector().add(new SelectorItemInfo("joinGroupYears"));
            viewInfo.getSelector().add(new SelectorItemInfo("jobStartDate"));
            viewInfo.getSelector().add(new SelectorItemInfo("adjustCoValue"));
            viewInfo.getSelector().add(new SelectorItemInfo("adjustGroupVal"));
            viewInfo.getSelector().add(new SelectorItemInfo("adjustWorkValue"));
            PersonPositionCollection coll = PersonPositionFactory.getLocalInstance((Context)ctx).getPersonPositionCollection(viewInfo);
            SimplePersonInfo spinfo = null;
            int n2 = coll.size();
            for (int i = 0; i < n2; ++i) {
                set.remove(coll.get(i).getPerson().getId().toString());
                spinfo = new SimplePersonInfo();
                spinfo.enterDate = coll.get(i).getEnterDate();
                spinfo.leftDate = coll.get(i).getLeftDate();
                spinfo.formalDate = coll.get(i).getFormalDate();
                spinfo.joinDate = coll.get(i).getJoinDate();
                spinfo.joinGroupDate = coll.get(i).getJoinGroupDate();
                spinfo.serviceYearForCompany = coll.get(i).getJoinCompanyYears();
                spinfo.serviceYearForGroup = coll.get(i).getJoinGroupYears();
                spinfo.beginWorkDate = coll.get(i).getJobStartDate();
                spinfo.adjustCoValue = coll.get(i).getAdjustCoValue();
                spinfo.adjustGroupVal = coll.get(i).getAdjustGroupVal();
                spinfo.adjustWorkValue = coll.get(i).getAdjustWorkValue();
                this.mapPersonServiceYear.put(coll.get(i).getPerson().getId().toString(), spinfo);
            }
        } else {
            try {
                rowSet = this.getSelectPersonPositionRowSet(ctx, "com.kingdee.eas.hr.emp.app.PersonPositionQuery", set);
            }
            catch (EASBizException e) {
                throw new BOSException((Throwable)e);
            }
            String ppID = "";
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            try {
                while (rowSet.next()) {
                    SimplePersonInfo spInfo = new SimplePersonInfo();
                    ppID = rowSet.getString("id");
                    if (rowSet.getString("enterDate") != null) {
                        spInfo.enterDate = sdf.parse(rowSet.getString("enterDate"));
                    }
                    if (rowSet.getString("leftDate") != null) {
                        spInfo.leftDate = sdf.parse(rowSet.getString("leftDate"));
                    }
                    if (rowSet.getString("formalDate") != null) {
                        spInfo.formalDate = sdf.parse(rowSet.getString("formalDate"));
                    }
                    if (rowSet.getString("joinDate") != null) {
                        spInfo.joinDate = sdf.parse(rowSet.getString("joinDate"));
                    }
                    if (rowSet.getString("joinGroupDate") != null) {
                        spInfo.joinGroupDate = sdf.parse(rowSet.getString("joinGroupDate"));
                    }
                    spInfo.serviceYearForCompany = Float.valueOf(rowSet.getString("joinCompanyYears")).floatValue();
                    spInfo.serviceYearForGroup = Float.valueOf(rowSet.getString("joinGroupYears")).floatValue();
                    if (rowSet.getString("jobStartDate") != null) {
                        spInfo.beginWorkDate = sdf.parse(rowSet.getString("jobStartDate"));
                    }
                    if (rowSet.getString("adjustCoValue") != null) {
                        spInfo.adjustCoValue = Float.valueOf(rowSet.getString("adjustCoValue")).floatValue();
                    }
                    if (rowSet.getString("adjustGroupVal") != null) {
                        spInfo.adjustGroupVal = Float.valueOf(rowSet.getString("adjustGroupVal")).floatValue();
                    }
                    if (rowSet.getString("adjustWorkValue") != null) {
                        spInfo.adjustWorkValue = Float.valueOf(rowSet.getString("adjustWorkValue")).floatValue();
                    }
                    this.mapPersonServiceYear.put(rowSet.getString("person.id"), spInfo);
                }
            }
            catch (NumberFormatException e) {
                throw new BOSException((Throwable)e);
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            catch (ParseException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    private void prepareData(Context ctx, List lstPerson, int year) throws BOSException {
        if (this.flagPrepareDate) {
            return;
        }
        int size = lstPerson.size();
        HashSet set = new HashSet(lstPerson);
        this.mapPersonServiceYear = new HashMap((int)(1.5 * (double)size));
        this.mapYVRulePerson = this.getPersonsOfYVRule(ctx, year, set);
        this.mapYVRule = this.getYVRCollection(ctx, this.mapYVRulePerson.keySet());
        this.mapRuleServiceYear = new HashMap(this.mapYVRule.size());
        this.mapYVServiceYearMap = new HashMap(this.mapYVRule.size());
        String sql1 = " update T_HR_PersonPosition set fjoingroupyears = YEAR(getdate())-YEAR(isnull(fjoingroupdate,getdate())) + (((MONTH(getdate())- MONTH(isnull(fjoingroupdate,getdate()))))/12.0), fjoincompanyyears = YEAR(getdate()) - YEAR(isnull(fjoindate,getdate())) + ((MONTH(getdate())-MONTH(isnull(fjoindate,getdate())))/12.0 - isnull(fadjustcovalue,0.0))";
        DbUtil.execute((Context)ctx, (String)sql1);
        this.getPersonBaseInfo(ctx, lstPerson);
        this.setLeftPerson = this.getLeftPerson(ctx);
        this.flagPrepareDate = true;
    }

    protected void _calculate(Context ctx, int year, List lstPerson, int type, Date endDate, int applyOrCancle) throws BOSException, EASBizException {
        this.realCalculate(ctx, year, lstPerson, type, endDate, applyOrCancle);
    }

    private Map realCalculate(Context ctx, int year, List lstPerson, int type, Date endDate, int applyOrCancle) throws BOSException, EASBizException {
        List lstValue;
        Map mapUsed = new HashMap();
        if (lstPerson.size() == 1 && lstPerson.get(0).toString().equalsIgnoreCase("0")) {
            lstPerson.remove(0);
        }
        if (lstPerson.size() == 0) {
            IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)"select distinct fpersonid from T_HR_YVPerson");
            ArrayList<String> lstPersons = new ArrayList<String>();
            try {
                while (iRowSet.next()) {
                    lstPersons.add(iRowSet.getString("fpersonid"));
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            this.preparePersonData(ctx, lstPersons, year);
        }
        if ((lstValue = this.getCurrValue(ctx, year, lstPerson)).size() == 0) {
            return new HashMap();
        }
        this.mapYVRulePerson = this.getPersonsOfYVRule(ctx, year, new HashSet(lstPerson));
        Set setRule = this.mapYVRulePerson.keySet();
        this.mapYVRule = this.getYVRCollection(ctx, setRule);
        this.beforeUsed = new HashMap();
        HashMap<String, Date> personId_bandonPoint = new HashMap<String, Date>();
        String[] strPerson = lstPerson.toArray(new String[lstPerson.size()]);
        int j = strPerson.length;
        for (int i = 0; i < j; ++i) {
            YearVacationRuleInfo ruleInfo = this.getYVRule(strPerson[i].toString());
            if (ruleInfo == null) continue;
            YearVacationCarryforwardInfo cInfo = ruleInfo.getCarryforward();
            personId_bandonPoint.put(strPerson[i].toString(), this.strToDate(cInfo.getAbandonDate(), year));
        }
        if (applyOrCancle == 5) {
            mapUsed = this.getUsedCancleVacation(ctx, lstPerson, year, type, endDate);
            this.beforeUsed = this.getBeforeUsedCancleVacationby(ctx, lstPerson, null, year, 1, personId_bandonPoint);
        } else if (applyOrCancle == 4) {
            mapUsed = this.getUsedVacation(ctx, lstPerson, year, type, endDate);
            this.beforeUsed = this.getBeforeUsedVacation(ctx, lstPerson, null, year, 1, personId_bandonPoint);
        }
        Map mapAvailable = this.calculateItemValue(ctx, lstValue, mapUsed, year);
        this._updateBalacne(ctx, year, lstValue);
        return mapAvailable;
    }

    private void preparePersonData(Context ctx, List lstPerson, int year) throws EASBizException, BOSException {
        Set setPerson = this.getYearVactionPersonSet(ctx);
        ArrayList<String> lstNewPerson = new ArrayList<String>(128);
        int size = lstPerson.size();
        for (int i = 0; i < size; ++i) {
            String personId = (String)lstPerson.get(i);
            if (setPerson.contains(personId)) continue;
            lstNewPerson.add(personId);
        }
        this.prepareData(ctx, lstPerson, year);
        if (DateTimeUtils.getYear((Date)new Date()) == year) {
            this._initYearVacation(ctx, lstNewPerson, year, false);
        }
    }

    protected void _calculate(Context ctx, int year, String ruleId, int type, Date endDate, int applyOrCancle) throws BOSException, EASBizException {
        this.realCalculate(ctx, year, ruleId, type, endDate, applyOrCancle);
    }

    private Map realCalculate(Context ctx, int year, String ruleId, int type, Date endDate, int applyOrCancle) throws BOSException, EASBizException {
        Map mapUsed = new HashMap();
        List lstPerson = this.getPersonOfRule(ctx, ruleId);
        if (lstPerson.size() == 0) {
            return new HashMap();
        }
        HashSet<String> setRuleId = new HashSet<String>(8);
        setRuleId.add(ruleId);
        this.preparePersonData(ctx, lstPerson, year);
        this.mapYVRule = this.getYVRCollection(ctx, setRuleId);
        List lstValue = this.getCurrValue(ctx, year, lstPerson);
        if (lstValue.size() == 0) {
            return new HashMap();
        }
        this.mapYVRulePerson = new HashMap(8);
        this.mapYVRulePerson.put(ruleId, new HashSet(lstPerson));
        this.beforeUsed = new HashMap();
        YearVacationRuleInfo ruleInfo = this.getYVRule(lstPerson.get(0) + "");
        if (ruleInfo == null) {
            return new HashMap();
        }
        YearVacationCarryforwardInfo cInfo = ruleInfo.getCarryforward();
        Date beforeEndDate = this.strToDate(cInfo.getAbandonDate(), year);
        if (applyOrCancle == 5) {
            mapUsed = this.getUsedCancleVacation(ctx, lstPerson, year, type, endDate);
            this.beforeUsed = this.getUsedCancleVacation(ctx, lstPerson, year, type, beforeEndDate);
        } else if (applyOrCancle == 4) {
            mapUsed = this.getUsedVacation(ctx, lstPerson, year, type, endDate);
            this.beforeUsed = this.getUsedVacation(ctx, lstPerson, year, type, beforeEndDate);
        }
        Map mapAvailable = this.calculateItemValue(ctx, lstValue, mapUsed, year);
        this._updateBalacne(ctx, year, lstValue);
        return mapAvailable;
    }

    protected void _carryforwardBalance(Context ctx, List lstPerson, int year, int type, Date endDate) throws BOSException, EASBizException {
        List lst = null;
        lst = lstPerson.size() == 1 && lstPerson.get(0).toString().equalsIgnoreCase("0") ? this.getPersonOfRule(ctx, null, year) : lstPerson;
        if (lst.size() == 1) {
            this.carryforwardCheck(ctx, year, lst);
        }
        List perList = this.getPerList(ctx, year, lst);
        this.carryforward(ctx, perList, year + 1, type, endDate);
    }

    private List getPersonOfRule(Context ctx, String ruleId, int year) throws BOSException {
        ArrayList<String> lst = new ArrayList<String>(1024);
        StringBuffer sql1 = new StringBuffer();
        sql1.append("select distinct fpersonid from t_hr_yvperson");
        sql1.append(" where fpersonid in (select distinct fpersonid from t_hr_yvbalance where fyear =" + year + ")");
        if (ruleId != null) {
            sql1.append(" and fyvruleid = '" + ruleId + "'");
        }
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql1.toString());
            while (rs.next()) {
                lst.add(rs.getString(1));
            }
        }
        catch (SQLException se) {
            throw new BOSException((Throwable)se);
        }
        return lst;
    }

    private List getPerList(Context ctx, int year, List lstPerson) throws BOSException {
        String selSql = "select fpersonid from t_hr_yvbalance where fyear = " + year + " and fstatus = 1";
        String perid = null;
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)selSql);
        try {
            while (rowSet.next()) {
                perid = rowSet.getString("fpersonid");
                if (!lstPerson.contains(perid)) continue;
                lstPerson.remove(perid);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new BOSException((Throwable)e);
        }
        return lstPerson;
    }

    protected void _carryforwardBalance(Context ctx, String ruleId, int year, int type, Date endDate) throws BOSException, EASBizException {
        List lstPerson = this.getPersonOfRule(ctx, ruleId);
        List perList = this.getPerList(ctx, year, lstPerson);
        this.carryforward(ctx, perList, year + 1, type, endDate);
    }

    private void carryforward(Context ctx, List lstPerson, int year, int type, Date endDate) throws BOSException, EASBizException {
        List lstPerson1 = this.getPerList(ctx, year, lstPerson);
        Map mapQuantity = this._calculateYearVacation(ctx, lstPerson1, year);
        Map mapLastAvailablity = this.getLastAvailVacation(ctx, lstPerson1, year - 1);
        Map mapBalance = this._carryforwardYearVacation(ctx, lstPerson1, year, mapLastAvailablity);
        Map mapOverdue = this.getOverDue(mapLastAvailablity, mapBalance, year);
        Map mapUsed = this.getUsedVacation(ctx, lstPerson1, year, type, endDate);
        Map mapAvail = this.getAvailVacation(mapQuantity, mapBalance, mapOverdue, mapUsed);
        this.setYearVactionValue(ctx, strInsertSql, lstPerson1, year, mapQuantity, mapAvail, mapBalance, mapOverdue, mapUsed);
        this.setCarryforwardFlag(ctx, lstPerson1, year - 1);
        this.setCarryforwardZeroAvailab(ctx, lstPerson1, year - 1);
    }

    private Map getAvailVacation(Map mapQuantity, Map mapBalance, Map mapOverdue, Map mapUsed) {
        HashMap<String, Float> mapAvail = new HashMap<String, Float>(mapQuantity.size());
        for (String personId : mapQuantity.keySet()) {
            float quantity = this.getValue(personId, mapQuantity);
            float balance = this.getValue(personId, mapBalance);
            float overdue = this.getValue(personId, mapOverdue);
            float used = this.getValue(personId, mapUsed);
            mapAvail.put(personId, new Float(quantity + balance - overdue - used));
        }
        return mapAvail;
    }

    private float getValue(String key, Map mapValue) {
        if (mapValue == null || mapValue.size() == 0 || !mapValue.containsKey(key)) {
            return 0.0f;
        }
        return new Float(mapValue.get(key).toString()).floatValue();
    }

    private Map getOverDue(Map mapAvail, Map mapBalance, int year) {
        HashMap<String, Float> map = new HashMap<String, Float>(mapAvail.size());
        Iterator itor = mapAvail.keySet().iterator();
        float overdue = 0.0f;
        while (itor.hasNext()) {
            String personId = (String)itor.next();
            float balance = ((Float)mapBalance.get(personId)).floatValue();
            YearVacationRuleInfo ruleInfo = this.getYVRule(personId);
            if (ruleInfo == null) continue;
            YearVacationCarryforwardInfo cInfo = ruleInfo.getCarryforward();
            overdue = cInfo.isIsAbandon() && DateTimeUtils.dayAfter((Date)new Date(), (Date)cInfo.getAbandonPoint(year)) ? balance - this.getValueOfReserved(cInfo, balance) : 0.0f;
            map.put(personId, new Float(overdue));
        }
        return map;
    }

    private Map getLastAvailVacation(Context ctx, List lstPerson, int year) throws BOSException {
        String sqlSrc = "select fpersonid,FCurrAvaiable from t_hr_yvbalance where fyear = " + year;
        List lstSql = new ArrayList(32);
        if (lstPerson.size() > 0) {
            sqlSrc = sqlSrc + " and ";
            lstSql = this.getSqlList(ctx, lstPerson, year, sqlSrc);
        }
        Connection cn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        HashMap<String, Float> map = new HashMap<String, Float>(512);
        try {
            cn = this.getConnection(ctx);
            int size = lstSql.size();
            for (int i = 0; i < size; ++i) {
                String sql = (String)lstSql.get(i);
                stmt = cn.prepareStatement(sql);
                rs = stmt.executeQuery();
                while (rs.next()) {
                    String personId = rs.getString(1);
                    if (map.containsKey(personId)) continue;
                    map.put(personId, new Float(rs.getFloat(2)));
                }
                SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
            }
        }
        catch (SQLException se) {
            throw new BOSException((Throwable)se);
        }
        finally {
            SQLUtils.cleanup(stmt, (Connection)cn);
            TempTablePool pool = TempTablePool.getInstance((Context)ctx);
            if (ctx.get((Object)"hrTimeVacationTmpTable") != null) {
                pool.releaseTable(ctx.get((Object)"hrTimeVacationTmpTable").toString());
            }
        }
        return map;
    }

    private void carryforwardCheck(Context ctx, int year, List lstPerson) throws BOSException, YVRuleException {
        String sqlSrc = "select count(*) from t_hr_yvbalance where fstatus = 1 and fyear = " + year;
        List lstSql = new ArrayList(32);
        if (lstPerson.size() > 0) {
            sqlSrc = sqlSrc + " and ";
            lstSql = this.getSqlList(ctx, lstPerson, year, sqlSrc);
        }
        Connection cn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            cn = this.getConnection(ctx);
            int size = lstSql.size();
            for (int i = 0; i < size; ++i) {
                String sql = (String)lstSql.get(i);
                stmt = cn.prepareStatement(sql);
                rs = stmt.executeQuery();
                rs.next();
                if (rs.getInt(1) <= 0) continue;
                throw new YVRuleException(YVRuleException.CANNT_CARRYFORWARD);
            }
        }
        catch (SQLException se) {
            throw new BOSException((Throwable)se);
        }
        finally {
            SQLUtils.cleanup(rs);
            SQLUtils.cleanup(stmt, (Connection)cn);
            TempTablePool pool = TempTablePool.getInstance((Context)ctx);
            if (ctx.get((Object)"hrTimeVacationTmpTable") != null) {
                pool.releaseTable(ctx.get((Object)"hrTimeVacationTmpTable").toString());
            }
        }
    }

    private List getSqlList(Context ctx, List lstPerson, int year, String sql) throws BOSException {
        int eachCount = 0;
        String where = "";
        ArrayList<String> lstSql = new ArrayList<String>(32);
        HashSet<String> set = new HashSet<String>(600);
        int size = lstPerson.size();
        for (int i = 0; i < size; ++i) {
            String personId = (String)lstPerson.get(i);
            if (eachCount < 500) {
                ++eachCount;
                set.add(personId);
                continue;
            }
            eachCount = 1;
            where = this.getWhereInCaluse(ctx, set);
            lstSql.add(sql + where);
            set.clear();
            set.add(personId);
        }
        where = this.getWhereInCaluse(ctx, set);
        lstSql.add(sql + where);
        return lstSql;
    }

    private void setCarryforwardFlag(Context ctx, List lstPerson, int year) throws BOSException {
        String sql = "update t_hr_yvbalance set fstatus = 1 where fpersonid = ? and fyear = " + year;
        Connection cn = null;
        PreparedStatement stmt = null;
        try {
            cn = this.getConnection(ctx);
            stmt = cn.prepareStatement(sql);
            int size = lstPerson.size();
            for (int i = 0; i < size; ++i) {
                String personId = (String)lstPerson.get(i);
                stmt.setString(1, personId);
                stmt.addBatch();
            }
            stmt.executeBatch();
        }
        catch (SQLException se) {
            try {
                throw new BOSException((Throwable)se);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)cn);
    }

    private void setCarryforwardZeroAvailab(Context ctx, List lstPerson, int year) throws BOSException {
        String sql = "update t_hr_yvbalance set fcurravaiable = 0.000 where fpersonid = ? and fyear = " + year;
        Connection cn = null;
        PreparedStatement stmt = null;
        try {
            cn = this.getConnection(ctx);
            stmt = cn.prepareStatement(sql);
            int size = lstPerson.size();
            for (int i = 0; i < size; ++i) {
                String personId = (String)lstPerson.get(i);
                stmt.setString(1, personId);
                stmt.addBatch();
            }
            stmt.executeBatch();
        }
        catch (SQLException se) {
            try {
                throw new BOSException((Throwable)se);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)cn);
    }

    private List getCurrValue(Context ctx, int year, List lstPerson) throws BOSException {
        String sql = "select fpersonid,fcurrquantity,fcurravaiable,flastbalance,foverdue,fyear,fstatus from t_hr_yvbalance where fstatus = 0 and fyear = " + year;
        Connection cn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        boolean small = true;
        int size = lstPerson.size();
        HashSet set = new HashSet();
        ArrayList lstValue = null;
        HashMap<String, Object> map = null;
        if (size > 0) {
            set = new HashSet(lstPerson);
            sql = size <= 500 ? sql + " and " + this.getWhereInCaluse(set) : sql + " and " + this.getWhereInCaluse(ctx, set);
            lstValue = new ArrayList(2 * size);
            lstPerson.clear();
        } else {
            small = false;
        }
        if (!small) {
            lstValue = new ArrayList(2 * size);
        }
        try {
            cn = this.getConnection(ctx);
            stmt = cn.prepareStatement(sql);
            rs = stmt.executeQuery();
            while (rs.next()) {
                String personId = rs.getString("fpersonid");
                map = new HashMap<String, Object>(16);
                map.put("fpersonid", personId);
                map.put("fcurrquantity", new Float(rs.getFloat("fcurrquantity")));
                map.put("fcurravaiable", new Float(rs.getFloat("fcurravaiable")));
                map.put("flastbalance", new Float(rs.getFloat("flastbalance")));
                map.put("foverdue", new Float(rs.getFloat("foverdue")));
                map.put("fyear", rs.getInt("fyear"));
                lstValue.add(map);
                lstPerson.add(personId);
            }
        }
        catch (SQLException se) {
            try {
                throw new BOSException((Throwable)se);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)cn);
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        if (ctx.get((Object)"hrTimeVacationTmpTable") != null) {
            pool.releaseTable(ctx.get((Object)"hrTimeVacationTmpTable").toString());
        }
        return lstValue;
    }

    private Set getYearVactionPersonSet(Context ctx) throws BOSException {
        HashSet<String> setPerson = new HashSet<String>(1204);
        String sql = "select distinct fpersonid from t_hr_yvbalance";
        Connection cn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            cn = this.getConnection(ctx);
            stmt = cn.prepareStatement(sql);
            rs = stmt.executeQuery();
            while (rs.next()) {
                setPerson.add(rs.getString(1));
            }
        }
        catch (SQLException se) {
            try {
                throw new BOSException((Throwable)se);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)cn);
        return setPerson;
    }

    private Map calculateItemValue(Context ctx, List lstValue, Map mapUsed, int year) throws EASBizException, BOSException {
        int i;
        Map map = null;
        String personId = null;
        HashMap<String, Float> mapAvailable = new HashMap<String, Float>(lstValue.size() * 2);
        float currQuantity = 0.0f;
        float available = 0.0f;
        float lastBalance = 0.0f;
        float overdue = 0.0f;
        float used = 0.0f;
        YearVacationRuleInfo ruleInfo = null;
        YearVacationCarryforwardInfo cInfo = null;
        ArrayList personids = new ArrayList();
        int size = lstValue.size();
        for (i = 0; i < size; ++i) {
            personids.add(((Map)lstValue.get(i)).get("fpersonid"));
        }
        this.prepareData(ctx, personids, 0);
        size = lstValue.size();
        for (i = 0; i < size; ++i) {
            float overd;
            map = (Map)lstValue.get(i);
            personId = (String)map.get("fpersonid");
            currQuantity = ((Float)map.get("fcurrquantity")).floatValue();
            lastBalance = ((Float)map.get("flastbalance")).floatValue();
            overdue = ((Float)map.get("foverdue")).floatValue();
            used = mapUsed.containsKey(personId) ? new Float(mapUsed.get(personId).toString()).floatValue() : 0.0f;
            float beforUsed = 0.0f;
            if (this.beforeUsed != null && this.beforeUsed.containsKey(personId)) {
                beforUsed = new Float(this.beforeUsed.get(personId).toString()).floatValue();
            }
            map.put("fused", new Float(used));
            ruleInfo = this.getYVRule(personId);
            if (ruleInfo == null) continue;
            float rest = currQuantity + lastBalance - used;
            cInfo = ruleInfo.getCarryforward();
            overdue = cInfo.isIsAbandon() && DateTimeUtils.dayAfter((Date)new Date(), (Date)cInfo.getAbandonPoint(year)) ? (lastBalance - beforUsed > 0.0f ? ((overd = lastBalance - beforUsed - this.getValueOfReserved(cInfo, lastBalance - beforUsed)) > 0.0f ? overd : 0.0f) : 0.0f) : 0.0f;
            rest -= overdue;
            map.put("foverdue", new Float(overdue));
            map.put("flastbalance", new Float(lastBalance));
            if (!this.isUseYearVacation(ruleInfo, personId)) {
                rest = 0.0f;
            }
            available = rest > 0.0f ? rest : 0.0f;
            map.put("fcurravaiable", new Float(available));
            mapAvailable.put(personId, new Float(available));
        }
        return mapAvailable;
    }

    private List getPersonOfRule(Context ctx, String ruleId) throws BOSException {
        ArrayList<String> lst = new ArrayList<String>(1024);
        String sql = "select distinct fpersonid from t_hr_yvperson";
        if (ruleId != null) {
            sql = sql + " where fyvruleid = '" + ruleId + "'";
        }
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                lst.add(rs.getString(1));
            }
        }
        catch (SQLException se) {
            throw new BOSException((Throwable)se);
        }
        return lst;
    }

    protected void _setCurrquantity(Context ctx) throws BOSException, EASBizException {
        Map map = this.getmapQuantity(ctx);
        if (map == null || map.size() == 0) {
            return;
        }
        Map.Entry entry2 = null;
        String personid = null;
        Float CurQuantity = null;
        int year = DateTimeUtils.getYear((Date)new Date());
        for (Map.Entry entry2 : map.entrySet()) {
            personid = (String)entry2.getKey();
            CurQuantity = (Float)entry2.getValue();
            this._update1(ctx, CurQuantity, personid, year);
        }
    }

    private Map getYvRuleIds(Context ctx) throws BOSException {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        StringBuffer sb = new StringBuffer();
        sb.append("select yvr.fid fid,yvq.FObtainVacationDate datetype from t_hr_yvrule yvr ");
        sb.append("inner join T_HR_YVQuantity yvq on yvr.fquantityid = yvq.fid ");
        sb.append("where yvq.FObtainVacationDate = 20 or yvq.FObtainVacationDate = 40");
        Connection cn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            cn = this.getConnection(ctx);
            stmt = cn.prepareStatement(sb.toString());
            rs = stmt.executeQuery();
            while (rs.next()) {
                map.put(rs.getString(1), rs.getInt(2));
            }
        }
        catch (SQLException se) {
            try {
                throw new BOSException((Throwable)se);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)cn);
        return map;
    }

    private List getPersonForRule(Context ctx, String ruleId, String datetype) throws BOSException {
        ArrayList<String> lst = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        if (datetype.equals("40")) {
            sb.append("select per.fpersonid fpersonid from t_hr_PersonPosition  per ");
            sb.append("inner join t_hr_yvperson yv on per.fpersonid = yv.fpersonid ");
            sb.append("where YEAR(ADD_YEARS(fenterDate,1))=Year(CURDATE()) ");
            sb.append("and ADD_YEARS(fenterDate,1) <= getdate() ");
            sb.append("and fenterDate is not null ");
            sb.append("and yv.FYvRuleID='");
            sb.append(ruleId);
            sb.append("'");
        }
        if (datetype.equals("20")) {
            sb.append("select per.fpersonid fpersonid from t_hr_PersonPosition  per ");
            sb.append("inner join t_hr_yvperson yv on per.fpersonid = yv.fpersonid ");
            sb.append("where YEAR(fformalDate)=Year(CURDATE()) ");
            sb.append("and fformalDate <= getdate() ");
            sb.append("and fformalDate is not null ");
            sb.append("and yv.FYvRuleID='");
            sb.append(ruleId);
            sb.append("'");
        }
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            while (rs.next()) {
                lst.add(rs.getString(1));
            }
        }
        catch (SQLException se) {
            throw new BOSException((Throwable)se);
        }
        return lst;
    }

    private void prepareData1(Context ctx, List lstPerson, int year) throws BOSException {
        int size = lstPerson.size();
        HashSet set = new HashSet(lstPerson);
        this.mapPersonServiceYear = new HashMap((int)(1.5 * (double)size));
        this.mapYVRulePerson = this.getPersonsOfYVRule(ctx, year, set);
        this.mapYVRule = this.getYVRCollection(ctx, this.mapYVRulePerson.keySet());
        this.mapRuleServiceYear = new HashMap(this.mapYVRule.size());
        this.mapYVServiceYearMap = new HashMap(this.mapYVRule.size());
        String sql1 = " update T_HR_PersonPosition set fjoingroupyears = YEAR(getdate())-YEAR(isnull(fjoingroupdate,getdate())) + (((MONTH(getdate())-MONTH(isnull(fjoingroupdate,getdate()))))/12.0), fjoincompanyyears = YEAR(getdate()) - YEAR(isnull(fjoindate,getdate())) + (((MONTH({ts'2012-12-31 23:59:59'})-MONTH(isnull(fjoindate,{ts'2012-12-31 23:59:59'}))) - (case when DAYOFMONTH({ts'2012-12-31 23:59:59'}) < DAYOFMONTH(isnull(fjoindate,{ts'2012-12-31 23:59:59'})) then 1 else 0 end))/12.0)";
        DbUtil.execute((Context)ctx, (String)sql1);
        this.getPersonBaseInfo(ctx, lstPerson);
        this.setLeftPerson = this.getLeftPerson(ctx);
    }

    private Map getmapQuantity(Context ctx) throws BOSException, EASBizException {
        Map YvRuleMap = this.getYvRuleIds(ctx);
        if (YvRuleMap == null || YvRuleMap.size() == 0) {
            return null;
        }
        Map.Entry entry12 = null;
        String yvRuleid = null;
        String datetype = null;
        HashMap<String, Float> map = new HashMap<String, Float>();
        for (Map.Entry entry12 : YvRuleMap.entrySet()) {
            float days;
            int i;
            int size;
            yvRuleid = (String)entry12.getKey();
            datetype = entry12.getValue().toString();
            List personids = null;
            Calendar cal = Calendar.getInstance();
            cal.setTime(new Date());
            String personId = null;
            if (yvRuleid != null && datetype != null && datetype.equals("40")) {
                personids = this.getPersonForRule(ctx, yvRuleid, datetype);
                if (personids == null || personids.size() == 0) {
                    return null;
                }
                this.prepareData1(ctx, personids, cal.get(1));
                size = personids.size();
                for (i = 0; i < size; ++i) {
                    personId = (String)personids.get(i);
                    days = this._calculateYearVacation(ctx, personId, cal.get(1));
                    map.put(personId, new Float(days));
                }
            }
            if (yvRuleid == null || datetype == null || !datetype.equals("20")) continue;
            personids = this.getPersonForRule(ctx, yvRuleid, datetype);
            if (personids == null || personids.size() == 0) {
                return null;
            }
            this.prepareData1(ctx, personids, cal.get(1));
            size = personids.size();
            for (i = 0; i < size; ++i) {
                personId = (String)personids.get(i);
                days = this._calculateYearVacation(ctx, personId, cal.get(1));
                map.put(personId, new Float(days));
            }
        }
        return map;
    }

    protected void _update1(Context ctx, Float CurQuantity, String personId, int year) throws BOSException, EASBizException {
        Connection cn = null;
        PreparedStatement stmt = null;
        String strUpdateSql = "update t_hr_yvbalance set fcurrquantity=? where fpersonid=? and fyear=?";
        int i = 1;
        try {
            cn = this.getConnection(ctx);
            stmt = cn.prepareStatement(strUpdateSql);
            stmt.setFloat(i++, CurQuantity.floatValue());
            stmt.setString(i++, personId);
            stmt.setInt(i++, year);
            stmt.execute();
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)cn);
    }

    private Map getBeforeUsedCancleVacation(Context ctx, List lstPersonID, String timeAttendanceType, int year, int type, Map beforeUsed) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        HashMap<String, String> map = new HashMap<String, String>();
        int BATCH_SIZE = 500;
        sb.append("select fpersonid,sum(leave.ftotalregreal) as total from t_hr_leavedetail as leave where ");
        sb.append(" fleavebillentryID is null ");
        sb.append(" and fyearofleave = ");
        sb.append(year);
        sb.append(" and (fcheckstate = ");
        sb.append(type);
        sb.append(" or (fcheckstate = 0 and fdatasource = TO_CHAR(10)))");
        if (timeAttendanceType != null && timeAttendanceType.length() > 0) {
            sb.append(" and ftimeattendanceid = '");
            sb.append(timeAttendanceType);
            sb.append("' ");
        } else {
            sb.append(" and ftimeattendanceid = '00000000-0000-0000-0000-000000000008649E3405' ");
        }
        if (lstPersonID.size() > 0) {
            sb.append(" and (");
            StringBuffer buf = new StringBuffer();
            StringBuffer sql = null;
            int i = 1;
            int size = lstPersonID.size();
            while (i <= size) {
                buf.append(" ( fpersonid = '");
                buf.append(lstPersonID.get(i - 1));
                buf.append("'");
                buf.append(" and fenddatereal <= ");
                if (beforeUsed.get(lstPersonID.get(i - 1)) == null) {
                    ++i;
                    continue;
                }
                buf.append(this.getSqlDate((Date)beforeUsed.get(lstPersonID.get(i - 1))));
                buf.append(" ) ");
                if (i % 500 != 0 && i != size) {
                    buf.append(" or ");
                } else {
                    sql = new StringBuffer();
                    sql.append(sb);
                    sql.append(buf);
                    sql.append(" ) ");
                    sql.append("  group by fpersonid,ftimeattendanceid  ");
                    IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                    try {
                        while (rowSet.next()) {
                            map.put(rowSet.getString("fpersonid"), rowSet.getString("total"));
                        }
                    }
                    catch (SQLException sqle) {
                        logger.error((Object)sqle);
                        throw new BOSException((Throwable)sqle);
                    }
                    buf = new StringBuffer();
                }
                ++i;
            }
        }
        return map;
    }

    private String getSqlDate(Date date) throws BOSException {
        Calendar cal = Calendar.getInstance();
        cal.set(DateTimeUtils.getYear((Date)date), DateTimeUtils.getMonth((Date)date) - 1, DateTimeUtils.getDay((Date)date), 23, 59, 59);
        Date myDate = new Date(cal.getTimeInMillis() / 1000L * 1000L);
        String strTime = DateTimeUtils.format((Date)myDate, (String)"yyyy-MM-dd HH:mm:ss");
        String strKSQLTime = "{ts '" + strTime + "'}";
        return strKSQLTime;
    }

    private Map getBeforeWorkFlowUsedVacation(Context ctx, List lstPersonID, int year, Map beforeUsed) throws BOSException {
        StringBuffer sb = new StringBuffer();
        HashMap<String, String> map = new HashMap<String, String>();
        sb.append("select a.fpersonID as personID,sum(a.fleavelength) as total from t_hr_leavebillentry a ");
        sb.append("left outer join t_hr_leavereportbillentry b on a.fid = b.fleavebillentryid ");
        sb.append("inner join t_hr_leavebill c on a.fbillid = c.fid where c.fstate = 3 ");
        sb.append("and a.ftypeid ='00000000-0000-0000-0000-000000000008649E3405' ");
        sb.append("and year(a.fbegintime) = ");
        sb.append(year);
        if (lstPersonID.size() > 0) {
            sb.append(" and (");
            StringBuffer buf = new StringBuffer();
            int i = 1;
            int size = lstPersonID.size();
            int BATCH_SIZE = 500;
            while (i <= size) {
                buf.append(" ( a.fpersonid = '");
                buf.append(lstPersonID.get(i - 1));
                buf.append("'");
                buf.append(" and a.fendtime <= ");
                if (beforeUsed.get(lstPersonID.get(i - 1)) == null) {
                    ++i;
                    continue;
                }
                buf.append(this.getSqlDate((Date)beforeUsed.get(lstPersonID.get(i - 1))));
                buf.append(" ) ");
                if (i % 500 != 0 && i != size) {
                    buf.append(" or ");
                } else {
                    StringBuffer sql = new StringBuffer();
                    sql.append(sb);
                    sql.append(buf);
                    sql.append(" ) ");
                    sql.append("  group by a.fpersonid  ");
                    IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                    try {
                        while (rowSet.next()) {
                            map.put(rowSet.getString("personID"), rowSet.getString("total"));
                        }
                    }
                    catch (SQLException sqle) {
                        logger.error((Object)sqle);
                        throw new BOSException((Throwable)sqle);
                    }
                    buf = new StringBuffer();
                }
                ++i;
            }
        }
        return map;
    }

    protected Map getBeforeUsedVacation(Context ctx, List lstPersonID, String timeAttendanceType, int year, int type, Map beforeUsed) throws BOSException, EASBizException {
        Object o;
        int i;
        Map map = this.getBeforeUsedCancleVacation(ctx, lstPersonID, timeAttendanceType, year, type, beforeUsed);
        Map map1 = this.getBeforeWorkFlowUsedVacation(ctx, lstPersonID, year, beforeUsed);
        Set mapKey = map.keySet();
        Set mapKey1 = map1.keySet();
        BigDecimal b = null;
        BigDecimal b1 = null;
        HashMap<String, String> map2 = new HashMap<String, String>();
        int size = mapKey1.size();
        for (i = 0; i < size; ++i) {
            o = mapKey1.toArray()[i];
            if (map.containsKey(o)) {
                b = new BigDecimal(map.get(o.toString()).toString());
                b1 = new BigDecimal(map1.get(o.toString()).toString());
                map2.put(o.toString(), b.add(b1).toString());
                map.remove(o.toString());
                continue;
            }
            map2.put(o.toString(), (String)map1.get(o.toString()));
        }
        size = mapKey.size();
        for (i = 0; i < size; ++i) {
            o = mapKey.toArray()[i];
            map2.put(o.toString(), (String)map.get(o.toString()));
        }
        return map2;
    }

    protected Map getBeforeUsedCancleVacationby(Context ctx, List lstPersonID, String timeAttendanceType, int year, int type, Map beforeUsed) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        HashMap<String, String> map = new HashMap<String, String>();
        sb.append("select fpersonid,sum(leave.ftotalregreal) as total from t_hr_leavedetail as leave where ");
        sb.append(" fyearofleave = ");
        sb.append(year);
        sb.append(" and (fcheckstate = ");
        sb.append(type);
        sb.append(" or (fcheckstate = 0 and fdatasource = TO_CHAR(10)))");
        if (timeAttendanceType != null && timeAttendanceType.length() > 0) {
            sb.append(" and ftimeattendanceid = '");
            sb.append(timeAttendanceType);
            sb.append("' ");
        } else {
            sb.append(" and ftimeattendanceid = '00000000-0000-0000-0000-000000000008649E3405' ");
        }
        if (lstPersonID.size() > 0) {
            sb.append(" and (");
            StringBuffer buf = new StringBuffer();
            int size = lstPersonID.size();
            int BATCH_SIZE = 500;
            for (int i = 1; i <= size; ++i) {
                buf.append(" ( fpersonid = '");
                buf.append(lstPersonID.get(i - 1));
                buf.append("'");
                buf.append(" and fenddatereal <= ");
                buf.append(this.getSqlDate((Date)beforeUsed.get(lstPersonID.get(i - 1))));
                buf.append(" ) ");
                if (i % 500 != 0 && i != size) {
                    buf.append(" or ");
                    continue;
                }
                StringBuffer sql = new StringBuffer();
                sql.append(sb);
                sql.append(buf);
                sql.append(" ) ");
                sql.append(" group by fpersonid,ftimeattendanceid ");
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                try {
                    while (rowSet.next()) {
                        map.put(rowSet.getString("fpersonid"), rowSet.getString("total"));
                    }
                }
                catch (SQLException sqle) {
                    logger.error((Object)sqle);
                    throw new BOSException((Throwable)sqle);
                }
                buf = new StringBuffer();
            }
        }
        return map;
    }

    public Date strToDate(String str, int year) {
        if (str == null || str.length() <= 1) {
            return new Date();
        }
        int index = str.indexOf("/");
        if (index == -1) {
            return new Date();
        }
        int month = Integer.parseInt(str.substring(0, index));
        int day = Integer.parseInt(str.substring(index + 1));
        Calendar cal = Calendar.getInstance();
        cal.set(year, month - 1, day);
        return cal.getTime();
    }

    private String createIdTmpTable(Context ctx, TempTablePool pool, Set idSet) throws BOSException {
        pool = TempTablePool.getInstance((Context)ctx);
        String cSql = " create TABLE  t1 (FID varchar(44) not null primary key) ";
        String tmpTableName = null;
        try {
            tmpTableName = pool.createTempTable(cSql);
        }
        catch (Exception ex) {
            throw new BOSException(ex.getMessage(), ex.getCause());
        }
        StringBuffer sbInsert = new StringBuffer("insert into ");
        sbInsert.append(tmpTableName + " ( FID ) values (?) \n");
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        Iterator it = idSet.iterator();
        while (it.hasNext()) {
            list.add(new Object[]{it.next()});
        }
        HRUtil.executeBatch((Context)ctx, (String)sbInsert.toString(), list);
        return tmpTableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRowSet getSelectPersonPositionRowSet(Context ctx, String queryPk, HashSet idSet) throws BOSException, EASBizException {
        TempTablePool pool = null;
        IRowSet rows = null;
        String tmpTable = null;
        try {
            tmpTable = this.createIdTmpTable(ctx, pool, idSet);
            MetaDataPK queryPK = new MetaDataPK(queryPk);
            IQueryExecutor queryExcu = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("person.id", (Object)("select FID from " + tmpTable), CompareType.INNER));
            viewInfo.setFilter(fi);
            queryExcu.setObjectView(viewInfo);
            rows = DbUtil.executeQuery((Context)ctx, (String)queryExcu.getSQL());
        }
        finally {
            if (pool != null && tmpTable != null) {
                pool.releaseTable(tmpTable);
            }
        }
        return rows;
    }

    protected IRowSet _getSelectPersonRowSet(Context ctx, String queryPk, Set idSet, String queryFieldID) throws BOSException, EASBizException {
        TempTablePool pool = null;
        IRowSet rows = null;
        MetaDataPK queryPK = new MetaDataPK(queryPk);
        IQueryExecutor queryExcu = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        String tmpTable = null;
        if (idSet != null && idSet.size() > 100) {
            tmpTable = this.createIdTmpTable(ctx, pool, idSet);
            fi.getFilterItems().add(new FilterItemInfo(queryFieldID, (Object)("select FID from " + tmpTable), CompareType.INNER));
        } else {
            fi.getFilterItems().add(new FilterItemInfo(queryFieldID, (Object)idSet, CompareType.INCLUDE));
        }
        viewInfo.setFilter(fi);
        queryExcu.setObjectView(viewInfo);
        rows = queryExcu.executeQuery();
        if (tmpTable != null) {
            TempTablePool.getInstance((Context)ctx).releaseTable(tmpTable);
        }
        return rows;
    }

    private static class SimplePersonInfo {
        Date enterDate;
        Date leftDate;
        Date formalDate;
        Date joinDate;
        Date joinGroupDate;
        Date beginWorkDate;
        float serviceYearForGroup;
        float serviceYearForCompany;
        float adjustCoValue;
        float adjustGroupVal;
        float adjustWorkValue;

        private SimplePersonInfo() {
        }
    }
}

