/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.time.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.hr.time.IYearVacationBalance;
import com.kingdee.eas.hr.time.IYearVacationPerson;
import com.kingdee.eas.hr.time.YearVacationBalanceFactory;
import com.kingdee.eas.hr.time.YearVacationCarryforwardFactory;
import com.kingdee.eas.hr.time.YearVacationCarryforwardInfo;
import com.kingdee.eas.hr.time.YearVacationPersonCollection;
import com.kingdee.eas.hr.time.YearVacationPersonFactory;
import com.kingdee.eas.hr.time.YearVacationQuantityFactory;
import com.kingdee.eas.hr.time.YearVacationQuantityInfo;
import com.kingdee.eas.hr.time.YearVacationRuleInfo;
import com.kingdee.eas.hr.time.app.AbstractYearVacationRuleControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class YearVacationRuleControllerBean
extends AbstractYearVacationRuleControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.time.app.YearVacationRuleControllerBean");
    Set PersonIds = new HashSet();

    protected IObjectPK _addnew(Context arg0, IObjectValue arg1) throws BOSException, EASBizException {
        this.checkInput(arg0, arg1);
        this.deleteYearVacationPerson(arg0, arg1, true);
        IObjectPK pk = super._addnew(arg0, arg1);
        this.updatePersonCmp(arg0, pk);
        this.updateYVBalance(arg0, arg1);
        return pk;
    }

    void updatePersonCmp(Context ctx, IObjectPK pk) throws BOSException {
        IYearVacationPerson iYPerson = YearVacationPersonFactory.getLocalInstance(ctx);
        YearVacationPersonCollection yvInfos = iYPerson.getYearVacationPersonCollection("Select * Where yvRule.id='" + pk.toString() + "'");
        int counts = yvInfos.size();
        Connection conn = null;
        PreparedStatement pstmt = null;
        String sql = "Update T_HR_PersonCmp Set FYearHolidayRuleID= ? WHERE FPersonID=?";
        try {
            conn = super.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            for (int i = 0; i < counts; ++i) {
                pstmt.setString(1, pk.toString());
                pstmt.setString(2, yvInfos.get(i).getPerson().getId().toString());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (Exception ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    void deleteYearVacationPerson(Context ctx, IObjectValue arg1, boolean isAddNew) throws EASBizException, BOSException {
        YearVacationRuleInfo info = (YearVacationRuleInfo)arg1;
        YearVacationPersonCollection pInfos = info.getPersons();
        IYearVacationPerson iyvPerson = YearVacationPersonFactory.getLocalInstance(ctx);
        int counts = pInfos.size();
        HashSet<String> personIds = new HashSet<String>();
        for (int i = 0; i < counts; ++i) {
            if (isAddNew) {
                if (pInfos.get(i).getPerson().get("YVId") == null) continue;
                iyvPerson.delete((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)pInfos.get(i).getPerson().get("YVId").toString())));
                personIds.add(pInfos.get(i).getPerson().getId().toString());
                continue;
            }
            if (pInfos.get(i).getPerson().get("YVId") != null && pInfos.get(i).getId() != null) {
                if (pInfos.get(i).getPerson().get("YVId").toString().equals(pInfos.get(i).getId().toString())) continue;
                iyvPerson.delete((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)pInfos.get(i).getPerson().get("YVId").toString())));
                personIds.add(pInfos.get(i).getPerson().getId().toString());
                continue;
            }
            if (pInfos.get(i).getPerson().get("YVId") == null) continue;
            iyvPerson.delete((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)pInfos.get(i).getPerson().get("YVId").toString())));
            personIds.add(pInfos.get(i).getPerson().getId().toString());
        }
        this.PersonIds = personIds;
    }

    private void updateYVBalance(Context ctx, IObjectValue arg2) throws EASBizException, BOSException {
        Set personIds = this.PersonIds;
        if (personIds.size() <= 0) {
            return;
        }
        ArrayList personids = new ArrayList(personIds);
        IYearVacationBalance iyvBalacne = YearVacationBalanceFactory.getLocalInstance(ctx);
        int year = Calendar.getInstance().get(1);
        Map map = iyvBalacne.calculateYearVacation(personids, year);
        Connection conn = null;
        PreparedStatement pstmt = null;
        String sql = "Update T_HR_YVBalance Set FCurrQuantity= ? WHERE Fyear =" + year + " and FPersonID=?";
        try {
            conn = super.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            int size = personids.size();
            for (int i = 0; i < size; ++i) {
                pstmt.setBigDecimal(1, new BigDecimal(map.get(personids.get(i)).toString()));
                pstmt.setString(2, personids.get(i).toString());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (Exception ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    protected void _update(Context arg0, IObjectPK arg1, IObjectValue arg2) throws BOSException, EASBizException {
        this.checkInput(arg0, arg2);
        this.deleteYearVacationPerson(arg0, arg2, false);
        super._update(arg0, arg1, arg2);
        this.updatePersonCmp(arg0, arg1);
        this.updateYVBalance(arg0, arg2);
    }

    void checkInput(Context ctx, IObjectValue arg1) throws EASBizException, BOSException {
        this._checkNumberBlank(ctx, arg1);
        this._checkNumberDup(ctx, arg1);
        this._checkNameBlank(ctx, arg1);
        this._checkNameDup(ctx, arg1);
    }

    void _checkNumberBlank(Context ctx, IObjectValue arg1) throws EASBizException {
        YearVacationRuleInfo info = (YearVacationRuleInfo)arg1;
        if (info.getNumber() == null || info.getNumber().trim().equals("")) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{"number"});
        }
    }

    void _checkNumberDup(Context ctx, IObjectValue arg1) throws EASBizException, BOSException {
        YearVacationRuleInfo coreBillBaseInfo = (YearVacationRuleInfo)arg1;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)coreBillBaseInfo.getString("number"), CompareType.EQUALS);
        FilterItemInfo filterItem1 = new FilterItemInfo("hrOrgUnit.id", (Object)ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        filter.getFilterItems().add(filterItem1);
        if (coreBillBaseInfo.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)coreBillBaseInfo.getId().toString(), CompareType.NOTEQUALS));
        }
        if (super._exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{coreBillBaseInfo.getString("number"), ""});
        }
    }

    void _checkNameBlank(Context ctx, IObjectValue arg1) throws EASBizException {
        YearVacationRuleInfo info = (YearVacationRuleInfo)arg1;
        if (info.getName() == null || info.getName().equals("")) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{"name"});
        }
    }

    void _checkNameDup(Context ctx, IObjectValue arg1) throws EASBizException, BOSException {
        CoreBillBaseInfo coreBillBaseInfo = (CoreBillBaseInfo)arg1;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("name", (Object)coreBillBaseInfo.getString("name"), CompareType.EQUALS);
        FilterItemInfo filterItem1 = new FilterItemInfo("hrOrgUnit.id", (Object)ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        filter.getFilterItems().add(filterItem1);
        if (coreBillBaseInfo.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)coreBillBaseInfo.getId().toString(), CompareType.NOTEQUALS));
        }
        if (super._exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKNAMEDUP, new Object[]{coreBillBaseInfo.getString("name"), ""});
        }
    }

    protected IObjectValue _getSimpleValue(Context ctx, String ID) throws BOSException {
        String sql = "SELECT FNumber, FName_L1,FName_L2,FName_L3,FDescription,FQuantityID,FCarryforwardID FROM T_HR_YVRule WHERE FID = '" + ID + "'";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        YearVacationRuleInfo value = null;
        try {
            if (rowSet.next()) {
                String cID;
                value = new YearVacationRuleInfo();
                value.setNumber(rowSet.getString("FNumber"));
                value.setName(rowSet.getString("FName_L1"), LocaleUtils.getLocale((String)"L1"));
                value.setName(rowSet.getString("FName_L2"), LocaleUtils.getLocale((String)"L2"));
                value.setName(rowSet.getString("FName_L3"), LocaleUtils.getLocale((String)"L3"));
                value.setDescription(rowSet.getString("FDescription"));
                value.setId(BOSUuid.read((String)ID));
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("*"));
                String qID = rowSet.getString("FQuantityID");
                if (qID != null && !"".equals(qID.trim())) {
                    YearVacationQuantityInfo qInfo = YearVacationQuantityFactory.getLocalInstance(ctx).getYearVacationQuantityInfo((IObjectPK)new ObjectUuidPK(qID), sic);
                    value.setQuantity(qInfo);
                }
                if ((cID = rowSet.getString("FCarryforwardID")) != null && !"".equals(cID.trim())) {
                    YearVacationCarryforwardInfo cInfo = YearVacationCarryforwardFactory.getLocalInstance(ctx).getYearVacationCarryforwardInfo((IObjectPK)new ObjectUuidPK(cID), sic);
                    value.setCarryforward(cInfo);
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            throw new BOSException(ex.getMessage(), ex.getCause());
        }
        return value;
    }
}

