/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.time.web;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.hr.util.HRParamUtil;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.time.ApproveStateEnum;
import com.kingdee.eas.hr.time.ILeaveBill;
import com.kingdee.eas.hr.time.LeaveBillEntryInfo;
import com.kingdee.eas.hr.time.LeaveBillFactory;
import com.kingdee.eas.hr.time.LeaveBillInfo;
import com.kingdee.eas.hr.time.LeaveDetailFactory;
import com.kingdee.eas.hr.time.SubmitStateEnum;
import com.kingdee.eas.hr.time.TimeAttendanceFactory;
import com.kingdee.eas.hr.time.TimeAttendanceInfo;
import com.kingdee.eas.hr.time.util.TimeServerUtils;
import com.kingdee.eas.hr.time.web.LeaveBillWebUtil;
import com.kingdee.eas.hr.train.web.TrainWebUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.buffalo.server.BuffaloService;
import org.apache.log4j.Logger;

public class LeaveBillWebService
extends BuffaloService {
    private static final String RES = "com.kingdee.eas.hr.time.TimeWebResource";
    public static final String LEAVE_ITEM_ID_YEAR = "00000000-0000-0000-0000-000000000008649E3405";
    static Logger logger = Logger.getLogger((String)LeaveBillWebService.class.getName());

    public String[] submitLeaveBillSelf(String id, String entryId, String isAdd, String approveNumber, String phone, String approveType, int beginyear, int beginmonth, int beginday, int beginhour, int beginminute, int beginsecond, int endyear, int endmonth, int endday, int endhour, int endminute, int endsecond, String leaveType, String leaveTimeLength, String leaveCauseComment, String remarkComment) {
        String[] error = new String[2];
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        LeaveBillInfo leaveBillInfo = new LeaveBillInfo();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        if (isAdd.equals("false") && !id.equals("")) {
            leaveBillInfo.setId(BOSUuid.read((String)id));
        }
        if (approveNumber == null || approveNumber.equalsIgnoreCase("null")) {
            error[1] = ResourceBase.getString((String)RES, (String)"approveNumberNull", (Locale)ctx.getLocale());
            error[0] = "error";
            return error;
        }
        leaveBillInfo.setNumber(approveNumber);
        PersonInfo pInfo = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
        leaveBillInfo.setProposer(pInfo);
        try {
            leaveBillInfo.setAdminOrg((AdminOrgUnitInfo)LeaveBillWebUtil.getProposer(ctx).get("adminOrgUnit"));
        }
        catch (BOSException e1) {
            logger.error((Object)e1.getStackTrace(), (Throwable)e1);
        }
        leaveBillInfo.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
        leaveBillInfo.setApplyDate(new Date());
        leaveBillInfo.setPhone(phone);
        leaveBillInfo.setIsMultiEntry(false);
        ApproveStateEnum approveState = null;
        approveState = "0".equals(approveType) ? ApproveStateEnum.getEnum(0) : ApproveStateEnum.getEnum(1);
        leaveBillInfo.setApproveState(approveState);
        if (leaveBillInfo.getApproveState().getValue() == 0) {
            leaveBillInfo.setExtendedProperty("ignoreWorkflow", "true");
        }
        leaveBillInfo.setSubmitState(SubmitStateEnum.SUBMIT);
        leaveBillInfo.setInnerState(0);
        LeaveBillEntryInfo entryInfo = new LeaveBillEntryInfo();
        leaveBillInfo.getEntries().add(entryInfo);
        if (isAdd.equals("false") && !id.equals("")) {
            entryInfo.setId(BOSUuid.read((String)entryId));
        }
        Date beginDate = new Date();
        beginDate.setYear(beginyear - 1900);
        beginDate.setMonth(beginmonth);
        beginDate.setDate(beginday);
        beginDate = DateTimeUtils.truncateDate((Date)beginDate);
        beginDate = DateTimeUtils.addHour((Date)beginDate, (long)beginhour);
        beginDate = DateTimeUtils.addMinute((Date)beginDate, (long)beginminute);
        beginDate = DateTimeUtils.addSecond((Date)beginDate, (long)beginsecond);
        entryInfo.setBeginTime(new Timestamp(beginDate.getTime()));
        Date endDate = new Date();
        endDate.setYear(endyear - 1900);
        endDate.setMonth(endmonth);
        endDate.setDate(endday);
        endDate = DateTimeUtils.truncateDate((Date)endDate);
        endDate = DateTimeUtils.addHour((Date)endDate, (long)endhour);
        endDate = DateTimeUtils.addMinute((Date)endDate, (long)endminute);
        endDate = DateTimeUtils.addSecond((Date)endDate, (long)endsecond);
        entryInfo.setEndTime(new Timestamp(endDate.getTime()));
        TimeAttendanceInfo tdInfo = new TimeAttendanceInfo();
        tdInfo.setId(BOSUuid.read((String)leaveType));
        entryInfo.setType(tdInfo);
        entryInfo.setReason(leaveCauseComment);
        entryInfo.setRemark(remarkComment);
        entryInfo.setLeaveLength(new BigDecimal(leaveTimeLength));
        entryInfo.setPerson(pInfo);
        String operateError = ResourceBase.getString((String)RES, (String)"operateError", (Locale)ctx.getLocale());
        TimeAttendanceInfo timeAttendInfo = null;
        try {
            ILeaveBill leaveBill;
            IObjectPK pk;
            timeAttendInfo = TimeAttendanceFactory.getLocalInstance(ctx).getTimeAttendanceInfo((IObjectPK)new ObjectUuidPK(leaveType.toString()));
            BigDecimal LeaveLength = new BigDecimal("0.00");
            if (leaveTimeLength != null) {
                LeaveLength = new BigDecimal(leaveTimeLength);
            }
            if (LeaveLength.floatValue() > 0.0f && timeAttendInfo.getLastUnit() != null && timeAttendInfo.getLastUnit().floatValue() > 0.0f) {
                int a = (int)(LeaveLength.floatValue() * 100.0f);
                int b = (int)(timeAttendInfo.getLastUnit().floatValue() * 100.0f);
                BigDecimal lastUnit = new BigDecimal("0.00");
                lastUnit = timeAttendInfo.getLastUnit();
                if (a % b != 0) {
                    throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"72_LeaveBillSelfEditUI", (Locale)ctx.getLocale()) + lastUnit.floatValue() + ResourceBase.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"65_HRTimeClientUtils", (Locale)ctx.getLocale()));
                }
            }
            String HRO_ID = null;
            if (ContextUtil.getCurrentHRUnit((Context)ctx) != null) {
                HRO_ID = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
            }
            if (leaveType.equals(LEAVE_ITEM_ID_YEAR) && HRParamUtil.getParamOfHR((Context)ctx, (String)"Is_allow_leave", (String)HRO_ID)) {
                String unitTypeString = TimeServerUtils.getTimeAttendanceType(null);
                BigDecimal b = LeaveBillWebUtil.getYearHoliday(ctx, pInfo.getId().toString());
                if (b.intValue() == 0) {
                    String msg = pInfo.getName() + ResourceBase.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"69_LeaveBillEditUI", (Locale)ctx.getLocale());
                    msg = msg.replaceAll("\u5929", unitTypeString);
                    throw new Exception(msg);
                }
                ArrayList<String> lstPersonID = new ArrayList<String>();
                lstPersonID.add(pInfo.getId().toString());
                Map map = LeaveDetailFactory.getLocalInstance(ctx).getOnAuditVacation(lstPersonID);
                BigDecimal b1 = new BigDecimal("0.0");
                if (map.get(pInfo.getId().toString()) != null) {
                    b1 = new BigDecimal(map.get(pInfo.getId().toString()).toString());
                }
                BigDecimal b2 = LeaveLength;
                if (b.subtract(b1).subtract(b2).floatValue() < 0.0f) {
                    String msg = pInfo.getName() + ResourceBase.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"70_LeaveBillEditUI", (Locale)ctx.getLocale());
                    msg = msg.replaceAll("\u5929", unitTypeString);
                    throw new Exception(msg);
                }
            }
            if ((pk = (leaveBill = LeaveBillFactory.getLocalInstance(WebContextUtil.getEasContext((HttpServletRequest)request))).submit2((CoreBaseInfo)leaveBillInfo)) == null) {
                error[1] = operateError;
                error[0] = "error";
            } else {
                error[0] = "success";
                error[1] = pk.toString();
            }
        }
        catch (EASBizException e) {
            logger.info((Object)e);
            error[1] = e.getMessage();
            error[0] = "error";
            return error;
        }
        catch (BOSException e) {
            logger.info((Object)e);
            error[1] = operateError;
            error[0] = "error";
            return error;
        }
        catch (Exception e) {
            logger.info((Object)e);
            error[1] = e.getMessage();
            error[0] = "error";
            return error;
        }
        return error;
    }

    public static String getLeaveBillDataXML(HttpServletRequest request) {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        String curPersonId = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
        int COLS = 9;
        int pageCount = Integer.parseInt(request.getParameter("pageCount"));
        int pageNumber = Integer.parseInt(request.getParameter("pageNumber"));
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("proposer.id", (Object)curPersonId));
        filter.getFilterItems().add(new FilterItemInfo("isMultiEntry", (Object)Boolean.FALSE));
        viewInfo.setFilter(filter);
        SorterItemInfo sorterItem = null;
        sorterItem = new SorterItemInfo("applyDate");
        sorterItem.setSortType(SortType.DESCEND);
        viewInfo.getSorter().add(sorterItem);
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.time.app", "LeaveBillQuery");
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        exec.option().isAutoIgnoreZero = false;
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        exec.setObjectView(viewInfo);
        String xmlData = null;
        int startRow = (pageNumber - 1) * pageCount;
        ArrayList<Object> list = new ArrayList<Object>();
        try {
            IRowSet rowSet = exec.executeQuery(startRow, pageCount);
            list.add(String.valueOf(exec.getRowCount()));
            int index = 1;
            DecimalFormat format = new DecimalFormat("0.00");
            while (rowSet.next()) {
                String[] array = new String[COLS];
                array[0] = "" + index++;
                array[1] = rowSet.getString("id");
                array[2] = rowSet.getString("number");
                array[3] = rowSet.getDate("applyDate") != null ? DateTimeUtils.format((Date)rowSet.getDate("applyDate"), (String)"yyyy-M-d") : "";
                array[4] = rowSet.getString("type.name");
                array[5] = format.format(rowSet.getFloat("entries.leaveLength"));
                array[6] = rowSet.getDate("entries.beginTime") != null ? DateTimeUtils.format((Date)rowSet.getDate("entries.beginTime"), (String)"yyyy-MM-dd HH:mm:ss") : "";
                array[7] = rowSet.getDate("entries.endTime") != null ? DateTimeUtils.format((Date)rowSet.getDate("entries.endTime"), (String)"yyyy-MM-dd HH:mm:ss") : "";
                array[8] = rowSet.getString("bizState");
                list.add(array);
            }
            xmlData = TrainWebUtils.makeProcDataToXMLData(list, (int)COLS);
        }
        catch (Exception e) {
            logger.error((Object)("LeaveBillWebService.getLeaveBillDataXML:" + e.getMessage()));
            xmlData = TrainWebUtils.makeErrorProcDataToXMLData((int)COLS);
        }
        return xmlData;
    }
}

