/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.time.web;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.core.hr.util.HRParamUtil;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.org.PositionMemberInfo;
import com.kingdee.eas.hr.time.LeaveBillEntryCollection;
import com.kingdee.eas.hr.time.LeaveBillEntryFactory;
import com.kingdee.eas.hr.time.LeaveBillEntryInfo;
import com.kingdee.eas.hr.time.LeaveBillInfo;
import com.kingdee.eas.hr.time.LeaveDetailFactory;
import com.kingdee.eas.hr.time.TimeAttendanceCollection;
import com.kingdee.eas.hr.time.TimeAttendanceFactory;
import com.kingdee.eas.hr.time.util.TimeServerUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class LeaveBillWebUtil {
    static Logger logger = Logger.getLogger((String)LeaveBillWebUtil.class.getName());
    private static final String procCatalogResource = "com.kingdee.eas.hr.train.TrainWebResource";
    public static final String HOLIDAY_CATA_ID = "00000000-0000-0000-0000-000000000002BE0D0183";

    public static HashMap getProposer(Context ctx) throws BOSException {
        HashMap<String, String> map = new HashMap<String, String>();
        String name = "";
        String orgUnit = "";
        name = ContextUtil.getCurrentUserInfo((Context)ctx).getName();
        map.put("name", name);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        String personID = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
        filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)personID, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("isPrimary", (Object)1, CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        viewInfo.getSelector().add(new SelectorItemInfo("position.adminOrgUnit.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("position.adminOrgUnit.name"));
        PositionMemberCollection collection = PositionMemberFactory.getLocalInstance((Context)ctx).getPositionMemberCollection(viewInfo);
        if (collection != null && collection.size() > 0) {
            PositionMemberInfo info = collection.get(0);
            orgUnit = info.getPosition().getAdminOrgUnit().getName();
            map.put("orgUnit", orgUnit);
            map.put("adminOrgUnit", (String)info.getPosition().getAdminOrgUnit());
        }
        return map;
    }

    public static TimeAttendanceCollection getSimpleLeaveItems(Context ctx) throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        viewInfo.getSelector().add(new SelectorItemInfo("unitType"));
        viewInfo.getSelector().add(new SelectorItemInfo("length"));
        viewInfo.getSelector().add(new SelectorItemInfo("dataType"));
        viewInfo.getSelector().add(new SelectorItemInfo("decDigital"));
        FilterInfo filter = new FilterInfo();
        viewInfo.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("attendCatalog.id", (Object)HOLIDAY_CATA_ID));
        filter.getFilterItems().add(new FilterItemInfo("enable", (Object)1));
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", null));
        filter.setMaskString("#0 and #1 and (#2 or #3)");
        SorterItemInfo sorterOrderItem = new SorterItemInfo("number");
        sorterOrderItem.setSortType(SortType.ASCEND);
        viewInfo.getSorter().add(sorterOrderItem);
        return TimeAttendanceFactory.getLocalInstance(ctx).getTimeAttendanceCollection(viewInfo);
    }

    public static String getCurCUId(Context ctx) {
        String cuId = null;
        if (ContextUtil.getCurrentCtrlUnit((Context)ctx) != null) {
            cuId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        }
        return cuId;
    }

    public static HashMap getLeaveBill(Context ctx, String id) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("bill.id", (Object)id));
            viewInfo.setFilter(filterInfo);
            SelectorItemCollection selector = viewInfo.getSelector();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("beginTime"));
            selector.add(new SelectorItemInfo("endTime"));
            selector.add(new SelectorItemInfo("leaveLength"));
            selector.add(new SelectorItemInfo("type.id"));
            selector.add(new SelectorItemInfo("person.id"));
            selector.add(new SelectorItemInfo("person.name"));
            selector.add(new SelectorItemInfo("reason"));
            selector.add(new SelectorItemInfo("remark"));
            selector.add(new SelectorItemInfo("bill.id"));
            selector.add(new SelectorItemInfo("bill.number"));
            selector.add(new SelectorItemInfo("bill.proposer.id"));
            selector.add(new SelectorItemInfo("bill.proposer.name"));
            selector.add(new SelectorItemInfo("bill.adminOrg.id"));
            selector.add(new SelectorItemInfo("bill.adminOrg.name"));
            selector.add(new SelectorItemInfo("bill.applyDate"));
            selector.add(new SelectorItemInfo("bill.phone"));
            selector.add(new SelectorItemInfo("bill.approveState"));
            LeaveBillEntryCollection entryCollection = LeaveBillEntryFactory.getLocalInstance(ctx).getLeaveBillEntryCollection(viewInfo);
            if (entryCollection != null && entryCollection.size() > 0) {
                LeaveBillEntryInfo entryInfo = entryCollection.get(0);
                map.put("approveNumber", entryInfo.getBill().getNumber());
                map.put("adminOrgUnitName", entryInfo.getBill().getAdminOrg().getName());
                map.put("applyDate", entryInfo.getBill().getApplyDate());
                map.put("proposer", entryInfo.getBill().getProposer().getName());
                map.put("phone", entryInfo.getBill().getPhone());
                map.put("approveTypeItem", "" + entryInfo.getBill().getApproveState().getValue());
                map.put("entryId", entryInfo.getId().toString());
                map.put("leaveBeginTime", entryInfo.getBeginTime());
                map.put("leaveEndTime", entryInfo.getEndTime());
                map.put("leaveTypeID", entryInfo.getType().getId().toString());
                BigDecimal leavelength = entryInfo.getLeaveLength();
                DecimalFormat format = new DecimalFormat("0.00");
                map.put("leaveTimeLength", format.format(leavelength));
                map.put("leaveCauseComment", entryInfo.getReason());
                map.put("remarkComment", entryInfo.getRemark());
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
            map.put("error", e.getCause());
            return map;
        }
        return map;
    }

    public static Object[] getNumberEtc(Context ctx) {
        Object[] objs = new Object[2];
        String number = null;
        boolean canModifable = false;
        try {
            ICodingRuleManager icrm = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            LeaveBillInfo caller = (LeaveBillInfo)LeaveBillInfo.class.newInstance();
            CtrlUnitInfo ctrlUnitInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
            HROrgUnitInfo hrORgUnitInfo = ContextUtil.getCurrentHRUnit((Context)ctx);
            caller.setCU(ctrlUnitInfo);
            caller.setHrOrgUnit(hrORgUnitInfo);
            String companyId = icrm.getCurrentAppOUID((IObjectValue)caller);
            if (companyId != null && companyId.trim().length() > 0) {
                boolean isAddView = false;
                boolean isExistRule = false;
                boolean isModifable = false;
                boolean isUseIntermitNumber = false;
                isExistRule = icrm.isExist((IObjectValue)caller, companyId);
                if (isExistRule) {
                    isAddView = icrm.isAddView((IObjectValue)caller, companyId);
                    isUseIntermitNumber = icrm.isUseIntermitNumber((IObjectValue)caller, companyId);
                    isModifable = icrm.isModifiable((IObjectValue)caller, companyId);
                    if (!isAddView) {
                        canModifable = isModifable;
                        number = isUseIntermitNumber ? icrm.readNumber((IObjectValue)caller, companyId) : icrm.getNumber((IObjectValue)caller, companyId);
                    } else {
                        number = isUseIntermitNumber ? icrm.readNumber((IObjectValue)caller, companyId) : icrm.getNumber((IObjectValue)caller, companyId);
                        canModifable = isModifable;
                    }
                } else {
                    canModifable = true;
                }
            }
            objs[0] = number;
            objs[1] = canModifable;
            return objs;
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
    }

    public static String getCurrCanUserForYear(Context ctx) throws Exception {
        String unitTypeString = TimeServerUtils.getTimeAttendanceType(null);
        String mes = ResourceBase.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"mes", (Locale)ctx.getLocale());
        mes = mes.replaceFirst("#1", LeaveBillWebUtil.currCanUser(ctx));
        mes = mes.replaceAll(mes.substring(mes.length() - 1), unitTypeString);
        return mes;
    }

    public static String currCanUser(Context ctx) throws Exception {
        String personId = null;
        if (ContextUtil.getCurrentUserInfo((Context)ctx) != null && ContextUtil.getCurrentUserInfo((Context)ctx).getPerson() != null) {
            personId = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
        }
        if (personId == null) {
            return null;
        }
        BigDecimal b = LeaveBillWebUtil.getYearHoliday(ctx, personId);
        if (b.intValue() == 0) {
            return b.toString();
        }
        String HRO_ID = null;
        if (ContextUtil.getCurrentHRUnit((Context)ctx) != null) {
            HRO_ID = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        }
        if (HRParamUtil.getParamOfHR((Context)ctx, (String)"Is_allow_leave", HRO_ID)) {
            ArrayList<String> lstPersonID = new ArrayList<String>();
            lstPersonID.add(personId);
            Map map = LeaveDetailFactory.getLocalInstance(ctx).getOnAuditVacation(lstPersonID);
            BigDecimal b1 = new BigDecimal("0.0");
            if (map.get(personId) != null) {
                b1 = new BigDecimal(map.get(personId).toString());
            }
            return b + ResourceBase.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"71_LeaveBillEditUI", (Locale)ctx.getLocale()) + b1.setScale(1);
        }
        return b.toString();
    }

    public static BigDecimal getYearHoliday(Context ctx, String personId) throws Exception {
        int year = DateTimeUtils.getYear((Date)new Date());
        Map mapValue = LeaveBillWebUtil.getYearVacation(ctx, year, personId);
        float currQuantity = ((Float)mapValue.get("FCurrAvailable")).floatValue();
        return new BigDecimal(String.valueOf(currQuantity));
    }

    public static Map getYearVacation(Context ctx, int year, String personId) throws Exception {
        HashMap<String, Float> mapValue = new HashMap<String, Float>(16);
        float currQuantity = 0.0f;
        float currBalance = 0.0f;
        float lastBalance = 0.0f;
        String sql = " select * from t_hr_yvbalance where fyear=" + year + " and fpersonId = '" + personId + "'";
        ISQLExecutor executor = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sql);
        IRowSet rs = executor.executeSQL();
        if (rs.next()) {
            currQuantity = rs.getFloat("FCurrQuantity");
            currBalance = rs.getFloat("FCurrAvaiable");
            lastBalance = rs.getFloat("FLastBalance");
        }
        mapValue.put("FLastBalance", new Float(lastBalance));
        mapValue.put("FCurrQuantity", new Float(currQuantity));
        mapValue.put("FCurrAvailable", new Float(currBalance));
        return mapValue;
    }
}

