/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.bg.BgBizException;
import com.kingdee.eas.ma.bg.BgCtrlTypeEnum;
import com.kingdee.eas.ma.bg.BgCurrencyCtrlTypeEnum;
import com.kingdee.eas.ma.bg.BgDataInfo;
import com.kingdee.eas.ma.bg.BgDataTypeEnum;
import com.kingdee.eas.ma.bg.BgORMEngine;
import com.kingdee.eas.ma.bg.app.dao.BgDAO;
import com.kingdee.util.db.SQLUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public class BgBalanceAccess {
    private BOSUuid bgFormId;
    private BOSUuid periodId;
    private Context ctx;
    private BOSUuid companyId;
    private CompanyOrgUnitInfo comInfo;

    public BgBalanceAccess(Context ctx, BOSUuid companyId, BOSUuid bgFormId, BOSUuid periodId) {
        this.ctx = ctx;
        this.companyId = companyId;
        this.bgFormId = bgFormId;
        this.periodId = periodId;
        try {
            ICompanyOrgUnit ico = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
            this.comInfo = ico.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
    }

    private int getEndPeriodSerial(Context ctx, BOSUuid bgFormId) throws BOSException, EASBizException {
        int n;
        ResultSet rs;
        PreparedStatement stmt;
        Connection conn;
        block5: {
            conn = null;
            stmt = null;
            rs = null;
            String sql = "SELECT P.FPeriodYear * 100 + P.FPeriodNumber AS FSerial  FROM T_BG_BgForm F INNER JOIN T_BD_Period P  ON F.FPeriodToID = P.FID WHERE (F.FID = ?) ";
            conn = this.getConnection(ctx);
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, bgFormId.toString());
            rs = stmt.executeQuery();
            if (!rs.next()) break block5;
            int n2 = rs.getInt(1);
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
            return n2;
        }
        try {
            n = 0;
        }
        catch (SQLException e) {
            try {
                throw new BgBizException(BgBizException.GETDATA, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return n;
    }

    private BigDecimal getStatData(Context ctx, BOSUuid bgDataId, BOSUuid Cur, BOSUuid elem, BgCtrlTypeEnum ctrlType, String type) throws BOSException, EASBizException {
        BigDecimal bgBalance = null;
        BgDAO dao = new BgDAO();
        dao.initDAO(ctx);
        if (ctrlType == BgCtrlTypeEnum.PeriodCtrl) {
            bgBalance = this.getStatData(ctx, Cur, elem, this.getItems(ctx, bgDataId), dao.getPeriodSerial(this.periodId), true, type);
        } else if (ctrlType == BgCtrlTypeEnum.TotalCtrl) {
            bgBalance = this.getStatData(ctx, Cur, elem, this.getItems(ctx, bgDataId), this.getEndPeriodSerial(ctx, this.bgFormId), false, type);
        } else if (ctrlType == BgCtrlTypeEnum.AddUpCtrl) {
            bgBalance = this.getStatData(ctx, Cur, elem, this.getItems(ctx, bgDataId), dao.getPeriodSerial(this.periodId), false, type);
        } else if (ctrlType == BgCtrlTypeEnum.NoCtrl) {
            bgBalance = BgORMEngine.getVO(ctx, bgDataId, new String[]{"bgBalance"}).getBigDecimal("bgBalance");
        }
        return bgBalance;
    }

    private String getItems(Context ctx, BOSUuid bgData) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String result = null;
        String sql = "SELECT  ISNULL(E.FBgItem1ID, '') || ISNULL(E.FBgItem2ID, '') || ISNULL(E.FBgItem3ID, '') || ISNULL(E.FBgItem4ID, '') || ISNULL(E.FBgItem5ID, '')|| ISNULL(E.FBgItem6ID, '') AS items FROM T_BG_BgData D INNER JOIN T_BG_BgEntry E ON D.FBgEntryID = E.FID WHERE (D.FID = ?)";
        try {
            conn = this.getConnection(ctx);
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, bgData.toString());
            rs = stmt.executeQuery();
            if (rs.next()) {
                result = rs.getString(1).trim();
            }
        }
        catch (SQLException e) {
            try {
                throw new BgBizException(BgBizException.GETDATA, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return result;
    }

    private List getRefCurrList(Context ctx, BOSUuid bgForm) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String sql = "SELECT DISTINCT R.FCurrencyID FROM T_BG_BgForm F INNER JOIN T_BG_BgTemplate T ON F.FBgTemplateID = T.FID INNER JOIN T_BG_ReferencedCurrency R ON T.FID = R.FBgTemplateID WHERE (F.FID = ?)";
        ArrayList<BOSUuid> list = new ArrayList<BOSUuid>();
        try {
            conn = this.getConnection(ctx);
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, bgForm.toString());
            rs = stmt.executeQuery();
            while (rs.next()) {
                list.add(BOSUuid.read((String)rs.getString(1)));
            }
        }
        catch (SQLException e) {
            try {
                throw new BgBizException(BgBizException.GETDATA, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return list;
    }

    private Connection getConnection(Context ctx) {
        try {
            return EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    private BigDecimal getStatData(Context ctx, BOSUuid curId, BOSUuid bgElementId, String items, int endPeriodSerial, boolean isPeriodCtrl, String type) throws BOSException, BgBizException {
        BigDecimal bgBalance = null;
        StringBuffer sb = new StringBuffer(128);
        sb.append("SELECT ");
        sb.append(" SUM(d.");
        sb.append(type);
        sb.append(") ");
        sb.append(" FROM T_BD_Period p INNER JOIN T_BG_BgEntry e ON p.FID = e.FPeriodID INNER JOIN T_BG_BgData d ON e.FID = d.FBgEntryID  WHERE (e.FBgFormID = ?) AND ((p.FPeriodYear * 100 + p.FPeriodNumber) ");
        if (isPeriodCtrl) {
            sb.append("=");
        } else {
            sb.append("<=");
        }
        sb.append("? ) AND (e.FIsLeafPeriod = 1) AND (e.FIsLeafEntry = 1)  and d.FBgElementId =?  and d.FCurrencyID =? and isnull(e.FBgItem1ID,'')|| isnull(e.FBgItem2ID,'')|| isnull(e.FBgItem3ID,'')|| isnull(e.FBgItem4ID,'')|| isnull(e.FBgItem5ID,'')|| isnull(e.FBgItem6ID,'') =?");
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection(ctx);
            stmt = conn.prepareStatement(sb.toString());
            int length = this.bgFormId.toString().length();
            if (length != 28 && length != 44) {
                throw new SQLException("\u4e1a\u52a1\u5bf9\u8c61ID\u957f\u5ea6\u8bbe\u7f6e\u5f02\u5e38\uff01");
            }
            stmt.setAsciiStream(1, (InputStream)new ByteArrayInputStream(this.bgFormId.toString().getBytes()), length);
            stmt.setInt(2, endPeriodSerial);
            int length1 = bgElementId.toString().length();
            if (length1 != 28 && length1 != 44) {
                throw new SQLException("\u4e1a\u52a1\u5bf9\u8c61ID\u957f\u5ea6\u8bbe\u7f6e\u5f02\u5e38\uff01");
            }
            stmt.setAsciiStream(3, (InputStream)new ByteArrayInputStream(bgElementId.toString().getBytes()), length1);
            int length2 = curId.toString().length();
            if (length2 != 28 && length2 != 44) {
                throw new SQLException("\u4e1a\u52a1\u5bf9\u8c61ID\u957f\u5ea6\u8bbe\u7f6e\u5f02\u5e38\uff01");
            }
            stmt.setAsciiStream(4, (InputStream)new ByteArrayInputStream(curId.toString().getBytes()), length2);
            stmt.setAsciiStream(5, (InputStream)new ByteArrayInputStream(items.getBytes()), items.length());
            rst = stmt.executeQuery();
            if (rst.next()) {
                bgBalance = rst.getBigDecimal(1);
            }
        }
        catch (SQLException exp) {
            try {
                throw new BgBizException(BgBizException.GETDATA, exp, new Object[]{bgBalance});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)stmt, (Connection)conn);
        return bgBalance;
    }

    public BigDecimal getBgEnableValue(Context ctx, BgDataInfo curdata, BgCurrencyCtrlTypeEnum crCtrlType) throws BOSException, EASBizException {
        BigDecimal balance = null;
        BigDecimal value = null;
        if (curdata.getBgCtrlType() == BgCtrlTypeEnum.NoCtrl) {
            return curdata.getBgValue();
        }
        if (curdata.getDataType() == BgDataTypeEnum.Percent) {
            return curdata.getBgValue();
        }
        List refList = null;
        if (refList != null && curdata.getDataType() == BgDataTypeEnum.Quantity) {
            refList.add(curdata.getCurrency().getId());
        } else if (crCtrlType == BgCurrencyCtrlTypeEnum.RAW) {
            refList = new ArrayList<BOSUuid>();
            refList.add(curdata.getCurrency().getId());
        } else {
            refList = this.getRefCurrList(ctx, this.bgFormId);
        }
        balance = new BigDecimal("0");
        value = new BigDecimal("0");
        ExchangeTableInfo exInfo = this.comInfo.getBaseExchangeTable();
        if (exInfo == null) {
            throw new BgBizException(BgBizException.COMNOBASEEXRATE);
        }
        String baseExchangeTbId = exInfo.getId().toString();
        IExchangeRate ier = ExchangeRateFactory.getLocalInstance((Context)ctx);
        String tarCurrencyId = curdata.getCurrency().getId().toString();
        String key = "";
        for (int i = 0; i < refList.size(); ++i) {
            BigDecimal valrs;
            Hashtable table;
            BigDecimal rs = this.getStatData(ctx, curdata.getId(), (BOSUuid)refList.get(i), curdata.getBgElement().getId(), curdata.getBgCtrlType(), "FBgBalance");
            if (rs == null) {
                rs = new BigDecimal("0");
            }
            BigDecimal rate = new BigDecimal("1");
            key = baseExchangeTbId + "_" + this.periodId + "_" + (BOSUuid)refList.get(i) + "_" + tarCurrencyId;
            ExchangeRateInfo rateInfo = null;
            if (ctx.get((Object)"BgRate") != null) {
                table = (Hashtable)ctx.get((Object)"BgRate");
                if (table.get(key) != null) {
                    rate = (BigDecimal)table.get(key);
                } else {
                    rateInfo = ier.getExchangeRateByBG((IObjectPK)new ObjectUuidPK(baseExchangeTbId), (IObjectPK)new ObjectUuidPK(this.periodId), (IObjectPK)new ObjectUuidPK(((BOSUuid)refList.get(i)).toString()), (IObjectPK)new ObjectUuidPK(tarCurrencyId));
                    if (rateInfo != null) {
                        rate = rateInfo.getConvertRate();
                    }
                    if (rate == null) {
                        rate = new BigDecimal("1");
                    }
                    table.put(key, rate);
                }
            } else {
                table = new Hashtable();
                rateInfo = ier.getExchangeRateByBG((IObjectPK)new ObjectUuidPK(baseExchangeTbId), (IObjectPK)new ObjectUuidPK(this.periodId), (IObjectPK)new ObjectUuidPK(((BOSUuid)refList.get(i)).toString()), (IObjectPK)new ObjectUuidPK(tarCurrencyId));
                if (rateInfo != null) {
                    rate = rateInfo.getConvertRate();
                }
                if (rate == null) {
                    rate = new BigDecimal("1");
                }
                table.put(key, rate);
                ctx.put((Object)"BgRate", (Object)table);
            }
            balance = balance.add(rs.multiply(rate));
            if (!curdata.isIsFlexibleCtrl() || (valrs = this.getStatData(ctx, curdata.getId(), (BOSUuid)refList.get(i), curdata.getBgElement().getId(), curdata.getBgCtrlType(), "FBgValue")) == null) continue;
            value = value.add(valrs.multiply(rate));
        }
        if (curdata.isIsFlexibleCtrl()) {
            if (balance == null) {
                balance = new BigDecimal("0");
            }
            if (value == null) {
                value = new BigDecimal("0");
            }
            BigDecimal delta = value.multiply(curdata.getFlexibleBgCtrlParam().subtract(new BigDecimal("1")));
            balance = balance.add(delta);
        }
        return balance;
    }
}

