/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.bg.BgConstants;
import com.kingdee.eas.ma.bg.BgContext;
import com.kingdee.eas.ma.bg.BgCtrlTypeEnum;
import com.kingdee.eas.ma.bg.BgCurrencyCtrlTypeEnum;
import com.kingdee.eas.ma.bg.BgDataCollection;
import com.kingdee.eas.ma.bg.BgDataInfo;
import com.kingdee.eas.ma.bg.BgDataTypeEnum;
import com.kingdee.eas.ma.bg.BgElementEnum;
import com.kingdee.eas.ma.bg.BgElementInfo;
import com.kingdee.eas.ma.bg.BgEntryInfo;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;

public class BgCtrlHelper {
    public static String ITEMS_FLAG = "ItemFlag";

    public static BgDataCollection buildBgData(ResultSet rs, BOSUuid entryId, BOSUuid currencyId) throws SQLException {
        BgDataCollection coll = new BgDataCollection();
        CurrencyInfo curInfo = new CurrencyInfo();
        curInfo.setId(currencyId);
        while (rs.next()) {
            BgDataInfo data = new BgDataInfo();
            BgEntryInfo entry = BgCtrlHelper.getBgEntry(rs, entryId);
            data.setId(BOSUuid.read((String)rs.getString("FID")));
            data.setBgBalance(rs.getBigDecimal("FBgBalance"));
            data.setBgElement(new BgElementInfo());
            data.getBgElement().setId(BOSUuid.read((String)rs.getString("FBgElementID")));
            data.getBgElement().setBizElement(BgElementEnum.getEnum(rs.getInt("FBizElement")));
            data.setBgEntry(entry);
            data.setBgValue(rs.getBigDecimal("FBgValue"));
            int ctrlType = rs.getInt("FBgCtrlType");
            if (ctrlType != 0) {
                data.setBgCtrlType(BgCtrlTypeEnum.getEnum(ctrlType));
            }
            data.setDataType(BgDataTypeEnum.getEnum(rs.getInt("FDataType")));
            data.setCurrency(curInfo);
            data.setFlexibleBgCtrlParam(rs.getBigDecimal("FFlexibleBgCtrlParam"));
            data.setIsFlexibleCtrl(rs.getBoolean("FIsFlexibleCtrl"));
            coll.add(data);
        }
        return coll;
    }

    public static BigDecimal getReqValue(BigDecimal bizValue, BigDecimal bgBalance, BigDecimal flxParam) {
        System.out.println(flxParam);
        if (bizValue == null) {
            bizValue = new BigDecimal("0");
        }
        if (bgBalance == null) {
            bgBalance = new BigDecimal("0");
        }
        if (flxParam == null || flxParam.compareTo(BgConstants.ZERO) == 0) {
            flxParam = new BigDecimal("1");
        }
        if (bgBalance.compareTo(BgConstants.ZERO) > 0) {
            BigDecimal value = bizValue.subtract(bgBalance);
            return value.divide(flxParam, 10, 6);
        }
        return bizValue.divide(flxParam, 6);
    }

    private static BgEntryInfo getBgEntry(ResultSet rs, BOSUuid id) throws SQLException {
        BgEntryInfo info = new BgEntryInfo();
        info.setId(id);
        info.setPeriod(new PeriodInfo());
        info.getPeriod().setId(BOSUuid.read((String)rs.getString("FPeriodID")));
        StringBuffer sb = new StringBuffer(128);
        for (int i = 1; i < 7; ++i) {
            String val = rs.getString("FBgItem" + i + "ID");
            if (val == null) continue;
            sb.append(val);
        }
        info.setString(ITEMS_FLAG, sb.toString());
        return info;
    }

    public static BgCurrencyCtrlTypeEnum getBgCurrencyCtrlType(Context ctx, BOSUuid companyId) throws EASBizException, BOSException {
        String key = "BG003" + companyId;
        BgContext bgContext = BgContext.getServerInstance(ctx);
        String paramValue = (String)bgContext.getObject(key);
        if (paramValue == null) {
            IParamControl paramCtrl = ParamControlFactory.getLocalInstance((Context)ctx);
            paramValue = paramCtrl.getParamValue((IObjectPK)new ObjectUuidPK(companyId), "BG003");
            if (paramValue == null) {
                paramValue = "0";
            }
            bgContext.putObject(key, paramValue);
        }
        return BgCurrencyCtrlTypeEnum.getEnum(Integer.parseInt(paramValue));
    }
}

