/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.IBOSObject;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControl;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.bg.BgControl;
import com.kingdee.eas.ma.bg.BgCtrlParam;
import com.kingdee.eas.ma.bg.BgCtrlTypeEnum;
import com.kingdee.eas.ma.bg.BgCurrencyCtrlTypeEnum;
import com.kingdee.eas.ma.bg.BgDataCollection;
import com.kingdee.eas.ma.bg.BgDataInfo;
import com.kingdee.eas.ma.bg.BgDataTypeEnum;
import com.kingdee.eas.ma.bg.BgDimensionEnum;
import com.kingdee.eas.ma.bg.BgElementEnum;
import com.kingdee.eas.ma.bg.BgElementInfo;
import com.kingdee.eas.ma.bg.BgExchangeRate;
import com.kingdee.eas.ma.bg.BgFormInfo;
import com.kingdee.eas.ma.bg.BgItemInfo;
import com.kingdee.eas.ma.bg.BgManager;
import com.kingdee.eas.ma.bg.BgProvider;
import com.kingdee.eas.ma.bg.BgTemplateColumnCollection;
import com.kingdee.eas.ma.bg.BgTemplateColumnInfo;
import com.kingdee.eas.ma.bg.BgTemplateInfo;
import com.kingdee.eas.ma.bg.BgTemplateRowCollection;
import com.kingdee.eas.ma.bg.BgTemplateRowInfo;
import com.kingdee.eas.ma.bg.BgTypeInfo;
import com.kingdee.eas.ma.bg.DataProvider;
import com.kingdee.eas.ma.bg.IBgControl;
import com.kingdee.eas.ma.bg.IBgExchangeRate;
import com.kingdee.eas.ma.bg.IBgManager;
import com.kingdee.eas.ma.bg.IBgProvider;
import com.kingdee.eas.ma.bg.ReferencedCurrencyCollection;
import com.kingdee.eas.ma.bg.ReferencedCurrencyInfo;
import com.kingdee.eas.ma.bg.ReferencedDimensionCollection;
import com.kingdee.eas.ma.bg.ReferencedDimensionInfo;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class DataProviderServer
extends DataProvider {
    private static Logger logger = Logger.getLogger(DataProviderServer.class);
    private Context _ctx;
    private static Map properties = new HashMap();

    private DataProviderServer() {
    }

    public static DataProviderServer newInstance(Context ctx) {
        DataProviderServer result = new DataProviderServer();
        result._ctx = ctx;
        return result;
    }

    public static void main(String[] args) {
    }

    @Override
    protected IBOSObject getCtrl(String iName, AbstractObjectValue info) throws BOSException {
        IBOSObject ctrl = BOSObjectFactory.createBOSObject((Context)this._ctx, (BOSObjectType)info.getBOSType());
        return ctrl;
    }

    public static void setProperty(String name, String value) {
        properties.put(name, value);
    }

    public static String getProperty(String name) {
        Object result = properties.get(name);
        if (result == null) {
            return null;
        }
        return properties.get(name).toString();
    }

    public static IBgManager getBgManage(final Context ctx) {
        BgManager ctr = new BgManager(ctx){

            public BgFormInfo getExecutiveBgForm(String orgUnitID, BgTypeInfo bgTypeInfo, PeriodInfo periodInfo) throws BOSException {
                DataProviderServer provider = DataProviderServer.newInstance(ctx);
                BgFormInfo bgFormInfo = provider.getBgFormInfo();
                bgFormInfo.setBgTemplate(new BgTemplateInfo());
                if (DataProviderServer.getProperty("muti").equals("true")) {
                    bgFormInfo.getBgTemplate().setIsMultidimensional(true);
                } else {
                    bgFormInfo.getBgTemplate().setIsMultidimensional(false);
                }
                ReferencedCurrencyCollection refCurrencies = bgFormInfo.getBgTemplate().getRefCurrencies();
                refCurrencies.add(new ReferencedCurrencyInfo());
                refCurrencies.get(0).setCurrency(provider.getCurrencyInfo_RMB());
                refCurrencies.add(new ReferencedCurrencyInfo());
                refCurrencies.get(1).setCurrency(provider.getCurrencyInfo_US());
                refCurrencies.add(new ReferencedCurrencyInfo());
                refCurrencies.get(2).setCurrency(provider.getCurrencyInfo_EU());
                BgTemplateColumnCollection bgTpColumns = bgFormInfo.getBgTemplate().getBgTpColumns();
                bgTpColumns.add(new BgTemplateColumnInfo());
                bgTpColumns.get(0).setBgElement(new BgElementInfo());
                bgTpColumns.get(0).getBgElement().setBizElement(BgElementEnum.QTY);
                bgTpColumns.add(new BgTemplateColumnInfo());
                bgTpColumns.get(1).setBgElement(new BgElementInfo());
                bgTpColumns.get(1).getBgElement().setBizElement(BgElementEnum.AMT);
                BgTemplateRowCollection bgTpRows = bgFormInfo.getBgTemplate().getBgTpRows();
                bgTpRows.add(new BgTemplateRowInfo());
                bgTpRows.get(0).setBgItem1(new BgItemInfo());
                ReferencedDimensionCollection refDimensions = bgFormInfo.getBgTemplate().getRefDimensions();
                refDimensions.add(new ReferencedDimensionInfo());
                refDimensions.get(0).setIsPrimary(true);
                refDimensions.get(0).setBgDimension(BgDimensionEnum.ACCOUNT);
                refDimensions.add(new ReferencedDimensionInfo());
                refDimensions.get(1).setBgDimension(BgDimensionEnum.MATERIAL);
                if (DataProviderServer.getProperty("OrgDim").equals("true")) {
                    refDimensions.add(new ReferencedDimensionInfo());
                    refDimensions.get(2).setBgDimension(BgDimensionEnum.ORGANIZES_STORAGE);
                }
                return bgFormInfo;
            }
        };
        return ctr;
    }

    public static IBgProvider getBgProvider(final Context ctx) {
        BgProvider ctr = new BgProvider(ctx){

            public BgDataCollection getBalance(BgFormInfo bgFormInfo, PeriodInfo periodInfo, CurrencyInfo currencyInfo, Map dims) throws BOSException {
                Collection values = dims.values();
                BgDataCollection value = new BgDataCollection();
                DataProviderServer provider = DataProviderServer.newInstance(ctx);
                value.add(provider.getBgDataInfo_1());
                if (currencyInfo.getId().equals((Object)DataProviderServer.newInstance(ctx).getCurrencyInfo_RMB().getId())) {
                    value.get(0).setBgBalance(new BigDecimal("100"));
                } else if (currencyInfo.getId().equals((Object)DataProviderServer.newInstance(ctx).getCurrencyInfo_US().getId())) {
                    value.get(0).setBgBalance(new BigDecimal("500"));
                } else if (currencyInfo.getId().equals((Object)DataProviderServer.newInstance(ctx).getCurrencyInfo_EU().getId())) {
                    value.get(0).setBgBalance(new BigDecimal("1000"));
                }
                value.get(0).setDataType(BgDataTypeEnum.Amount);
                value.get(0).setBgCtrlType(BgCtrlTypeEnum.PeriodCtrl);
                value.get(0).setBgElement(new BgElementInfo());
                value.get(0).getBgElement().setBizElement(BgElementEnum.AMT);
                value.add(provider.getBgDataInfo_2());
                value.get(1).setDataType(BgDataTypeEnum.Quantity);
                value.get(1).setBgBalance(new BigDecimal("1100"));
                if (DataProviderServer.getProperty("qtyCtrlType") != null && DataProviderServer.getProperty("qtyCtrlType").equals("NoCtrl")) {
                    value.get(1).setBgCtrlType(BgCtrlTypeEnum.NoCtrl);
                } else {
                    value.get(1).setBgCtrlType(BgCtrlTypeEnum.TotalCtrl);
                }
                value.get(1).setBgElement(new BgElementInfo());
                value.get(1).getBgElement().setBizElement(BgElementEnum.QTY);
                return value;
            }

            public BigDecimal getTotalBalance(BgFormInfo bgFormInfo, PeriodInfo periodInfo, CurrencyInfo currInfo, Map dimMap) throws BOSException, EASBizException {
                BigDecimal result = null;
                if (currInfo.getId().equals((Object)DataProviderServer.newInstance(ctx).getCurrencyInfo_RMB().getId())) {
                    result = new BigDecimal("5100");
                }
                if (currInfo.getId().equals((Object)DataProviderServer.newInstance(ctx).getCurrencyInfo_US().getId())) {
                    result = new BigDecimal("637.5000");
                }
                if (currInfo.getId().equals((Object)DataProviderServer.newInstance(ctx).getCurrencyInfo_EU().getId())) {
                    result = new BigDecimal("5100");
                }
                return result;
            }

            public BgDataInfo getLocalBalance(BgFormInfo bgFormInfo, BgDataInfo bgDataInfo) throws BOSException, EASBizException {
                DataProviderServer provider = DataProviderServer.newInstance(ctx);
                BgDataInfo value = provider.getBgDataInfo_2();
                value.setBgBalance(new BigDecimal("100"));
                return value;
            }
        };
        return ctr;
    }

    public static IBgControl getBgControl(Context ctx) {
        BgControl ctr = new BgControl(ctx){

            @Override
            public BgCtrlParam[] bgAudit(BgCtrlParam[] bgCtrlParam) throws BOSException, EASBizException {
                for (int i = 0; i < bgCtrlParam.length; ++i) {
                    bgCtrlParam[i].setOK(true);
                }
                return bgCtrlParam;
            }
        };
        return ctr;
    }

    public static IParamControl getParamControl(Context ctx) {
        ParamControl ctr = new ParamControl(ctx){

            public String getParamValue(IObjectPK orgUnitID, String paramNumber) throws BOSException, EASBizException {
                String result = null;
                result = paramNumber.equals("BgCurrencyCtrlType") ? DataProviderServer.getProperty(BgCurrencyCtrlTypeEnum.class.getName()) : DataProviderServer.getProperty(paramNumber);
                return result;
            }
        };
        return ctr;
    }

    public static IBgExchangeRate getBgExchangeRate(final Context ctx) {
        BgExchangeRate ctr = new BgExchangeRate(ctx){

            public BigDecimal getBgExRate(OrgUnitInfo orgUnitInfo, CurrencyInfo srcCurrencyInfo, CurrencyInfo desCurrencyInfo, PeriodInfo periodInfo) throws BOSException {
                if (desCurrencyInfo.getId().equals((Object)DataProviderServer.newInstance(ctx).getCurrencyInfo_US().getId())) {
                    return new BigDecimal("8");
                }
                if (desCurrencyInfo.getId().equals((Object)DataProviderServer.newInstance(ctx).getCurrencyInfo_EU().getId())) {
                    return new BigDecimal("1");
                }
                return null;
            }
        };
        return ctr;
    }
}

