/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.ContextUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.bg.BgDataInfo;
import com.kingdee.eas.ma.bg.BgInstantApproveException;
import com.kingdee.eas.ma.bg.BgPastDataInfo;
import com.kingdee.eas.ma.bg.BgPastRecordInfo;
import com.kingdee.eas.ma.bg.app.BgSqlStore;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public class BgCommon {
    public static List getBgData(Connection cn, String bgFormId) throws SQLException {
        ArrayList<BgDataInfo> lst = new ArrayList<BgDataInfo>(100);
        String sql = BgSqlStore.getInstance().getBgDataByBgFormSql();
        PreparedStatement stmt = cn.prepareStatement(sql);
        stmt.setString(1, bgFormId);
        ResultSet rs = stmt.executeQuery();
        BgDataInfo info = null;
        while (rs.next()) {
            info = new BgDataInfo();
            info.setId(BOSUuid.read((String)rs.getString("FBgDataID")));
            info.setBgValue(new BigDecimal(Double.toString(rs.getDouble("FBgValue"))));
            info.setBgBalance(new BigDecimal(Double.toString(rs.getDouble("FBgBalance"))));
            info.setBizActual(new BigDecimal(Double.toString(rs.getDouble("FBizActual"))));
            lst.add(info);
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        return lst;
    }

    public static void sub_addPastRecord(Context ctx, Connection conn, List lstSrc, List lstDest, String originalBgformId) throws EASBizException {
        BgDataInfo srcInfo = null;
        BgDataInfo destInfo = null;
        ArrayList lstDiff = new ArrayList(100);
        boolean isExistPastRecord = false;
        String pastRecordId = "";
        int size = lstSrc.size();
        for (int i = 0; i < size; ++i) {
            BigDecimal value;
            srcInfo = (BgDataInfo)lstSrc.get(i);
            destInfo = (BgDataInfo)lstDest.get(i);
            BigDecimal srcValue = srcInfo.getBgValue();
            if (srcValue.compareTo(value = destInfo.getBgValue()) == 0) continue;
            if (!isExistPastRecord) {
                pastRecordId = BgCommon.buildPastRecord(ctx, conn, originalBgformId);
                isExistPastRecord = true;
            }
            BgCommon.buildPastData(ctx, conn, pastRecordId, srcInfo.getId().toString(), srcValue, value);
        }
    }

    public static String buildPastRecord(Context ctx, Connection conn, String bgFormId) throws EASBizException {
        String sql = "insert into t_bg_bgpastrecord(FID,FSeq,FModifyDate,FBgFormID,FModifierID) values(?,?,?,?,?)";
        String fId = BOSUuid.create((BOSObjectType)new BgPastRecordInfo().getBOSType()).toString();
        int seq = BgCommon.getSeq(conn, bgFormId);
        Timestamp time = new Timestamp(System.currentTimeMillis());
        String modifierId = ContextUtils.getUser((Context)ctx).getId().toString();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, fId);
            stmt.setInt(2, seq);
            stmt.setTimestamp(3, time);
            stmt.setString(4, bgFormId);
            stmt.setString(5, modifierId);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BgInstantApproveException(BgInstantApproveException.DATABASEERROR, e);
        }
        finally {
            SQLUtils.cleanup(rs, (Statement)stmt);
        }
        return fId;
    }

    public static void buildPastData(Context ctx, Connection conn, String bgPastRecordId, String bgDataId, BigDecimal srcValue, BigDecimal value) throws EASBizException {
        String sql = "insert into t_bg_bgpastdata(FID,FPastValue,FBalance,FBgDataID,FBgPastRecordID,FDataSource) values(?,?,?,?,?,?)";
        String fId = BOSUuid.create((BOSObjectType)new BgPastDataInfo().getBOSType()).toString();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, fId);
            stmt.setBigDecimal(2, srcValue);
            stmt.setBigDecimal(3, value.subtract(srcValue));
            stmt.setString(4, bgDataId);
            stmt.setString(5, bgPastRecordId);
            stmt.setInt(6, 0);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BgInstantApproveException(BgInstantApproveException.DATABASEERROR, e);
        }
        finally {
            SQLUtils.cleanup(rs, (Statement)stmt);
        }
    }

    public static int getSeq(Connection conn, String bgFormId) throws EASBizException {
        int result = 1;
        String sql = "select max(fseq) from t_bg_bgpastrecord where fbgformid=?";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, bgFormId);
            rs = stmt.executeQuery();
            if (rs.next()) {
                result = rs.getInt(1) + 1;
            }
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                throw new BgInstantApproveException(BgInstantApproveException.DATABASEERROR, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)stmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        return result;
    }
}

