/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.bg.BgBizException;
import com.kingdee.eas.ma.bg.BgConstants;
import com.kingdee.eas.ma.bg.BgContext;
import com.kingdee.eas.ma.bg.BgExchangeRateException;
import com.kingdee.eas.ma.bg.BgExchangeRateInfo;
import com.kingdee.eas.ma.bg.app.AbstractBgExchangeRateControllerBean;
import com.kingdee.eas.ma.bg.app.dao.BgDAO;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class BgExchangeRateControllerBean
extends AbstractBgExchangeRateControllerBean {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void _checkData(Context ctx, IObjectValue objectValue) throws BOSException, EASBizException {
        BgExchangeRateInfo bgExRateInfo = (BgExchangeRateInfo)objectValue;
        BgExchangeRateInfo.checkMaturity(bgExRateInfo);
        if (!BgExchangeRateInfo.checkRate(bgExRateInfo.getRate())) {
            throw new BgExchangeRateException(BgExchangeRateException.INVALIDRATE);
        }
        boolean isAcross = false;
        Connection conn = this.getConnection(ctx);
        try {
            isAcross = BgExchangeRateInfo.checkPeriodAcross(conn, bgExRateInfo);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        if (isAcross) {
            throw new BgExchangeRateException(BgExchangeRateException.PERIODACROSS);
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this._checkData(ctx, model);
        return super._submit(ctx, model);
    }

    @Override
    public BigDecimal _getBgExRate(Context ctx, BOSUuid orgUnitId, BOSUuid srcCurrencyId, BOSUuid desCurrencyId, BOSUuid periodId) throws BOSException, EASBizException {
        if (srcCurrencyId.equals((Object)desCurrencyId)) {
            return new BigDecimal("1");
        }
        String key = "BgExRate" + orgUnitId + periodId + srcCurrencyId + desCurrencyId;
        BgContext bgContext = BgContext.getServerInstance(ctx);
        BigDecimal result = (BigDecimal)bgContext.getObject(key);
        if (result != null) {
            return result;
        }
        BgDAO dao = BgDAO.getInstant(ctx);
        String longNumber = dao.getLongNumber(BgConstants.COMPANY_TREEID, orgUnitId);
        String sql = "SELECT Rate.FID, Rate.FRate  FROM T_BG_BgExchangeRate Rate  INNER JOIN T_ORG_Structure Stru  ON Rate.FCompanyID = Stru.FUnitId INNER JOIN T_BD_Period EndP ON Rate.FValidPeriodToID = EndP.FID INNER JOIN T_BD_Period FromP ON Rate.FValidPeriodFromID = FromP.FID  WHERE (Stru.FTreeId = ?)   AND (Rate.FSrcCurrencyID = ?)  AND (Rate.FDesCurrencyID = ?)  AND (? <= (EndP.FPeriodYear * 100 + EndP.FPeriodNumber))  AND (?>=(FromP.FPeriodYear * 100 + FromP.FPeriodNumber))  AND left('" + longNumber + "',LENGTH(Stru.FLongNumber))=Stru.FLongNumber  ORDER BY Stru.FLongNumber DESC";
        Connection conn = this.getConnection(ctx);
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, BgConstants.COMPANY_TREEID.toString());
            stmt.setString(2, srcCurrencyId.toString());
            stmt.setString(3, desCurrencyId.toString());
            int ser = BgExchangeRateInfo.getPeriodSerial(conn, periodId);
            stmt.setInt(4, ser);
            stmt.setInt(5, ser);
            rs = stmt.executeQuery();
            result = rs.next() ? rs.getBigDecimal("FRate") : new BigDecimal("1");
        }
        catch (SQLException e) {
            try {
                throw new BgBizException(BgBizException.GETDATA, e, new Object[]{periodId});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        bgContext.putObject(key, result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean _getConvertMode(Context ctx, String id) throws BOSException, EASBizException {
        ResultSet rs;
        PreparedStatement ps;
        Connection conn;
        int result;
        block4: {
            result = 0;
            String sql = "SELECT EXCHANGEAUX.FConvertMode FROM T_BD_ExchangeAux AS EXCHANGEAUX INNER JOIN T_BD_ExchangeRate AS EXCHANGERATE ON EXCHANGERATE.FExchangeAuxID = EXCHANGEAUX.FID where EXCHANGERATE.FID=?";
            conn = null;
            ps = null;
            rs = null;
            try {
                conn = this.getConnection(ctx);
                ps = conn.prepareStatement(sql);
                ps.setString(1, id);
                rs = ps.executeQuery();
                if (!rs.next()) break block4;
                result = rs.getInt(1);
            }
            catch (SQLException e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, ps, (Connection)conn);
                    throw throwable;
                }
                SQLUtils.cleanup(rs, (Statement)ps, (Connection)conn);
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return result == 0;
    }
}

