/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.bg.BgFormInfo;
import com.kingdee.eas.ma.bg.BgFormLogCollection;
import com.kingdee.eas.ma.bg.BgFormLogInfo;
import com.kingdee.eas.ma.bg.BgOperationEnum;
import com.kingdee.eas.ma.bg.app.AbstractBgFormLogControllerBean;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;

public class BgFormLogControllerBean
extends AbstractBgFormLogControllerBean {
    @Override
    protected IObjectCollection _getCollectionByBgFormId(Context ctx, BOSUuid bgFormId) throws BOSException, EASBizException {
        BgFormLogCollection bgFormLogCollection = new BgFormLogCollection();
        if (bgFormId == null) {
            return bgFormLogCollection;
        }
        PreparedStatement statement = null;
        ResultSet rs = null;
        Connection conn = null;
        conn = this.getConnection(ctx);
        Locale local = ctx.getLocale();
        StringBuffer strBuff = new StringBuffer(500);
        strBuff.append("select FLog.FID AS FID, FLog.FSeq AS FSeq, FLog.FBgOperation AS FOpr, FLog.FCreateTime AS FTime, FBgForm.Fid AS FFormId, FBgForm.FName AS FName, FUser.Fid AS FUserId, FUser.FName_");
        strBuff.append(local.toString());
        strBuff.append(" AS FUserName from T_BG_BgFormlog FLog, T_BG_BgForm FBgForm, T_PM_User FUser where FLog.FBgFormId = FBgForm.FId and FLog.FCreatorId = FUser.FID and FLog.fbgFormid =");
        strBuff.append("?");
        strBuff.append(" order by FLog.FSeq ");
        try {
            statement = conn.prepareStatement(strBuff.toString());
            statement.setString(1, bgFormId.toString());
            rs = statement.executeQuery();
            strBuff = null;
            while (rs.next()) {
                BgFormLogInfo bgFormLogInfo = new BgFormLogInfo();
                String strId = rs.getString("FID");
                bgFormLogInfo.setId(BOSUuid.read((String)strId));
                bgFormLogInfo.setSeq(rs.getInt("FSeq"));
                BgOperationEnum bgOpr = BgOperationEnum.getEnum(rs.getInt("FOpr"));
                bgFormLogInfo.setBgOperation(bgOpr);
                bgFormLogInfo.setCreateTime(rs.getTimestamp("FTime"));
                BgFormInfo bgFormInfo = new BgFormInfo();
                bgFormInfo.setId(bgFormId);
                bgFormInfo.setName(rs.getString("FName"));
                bgFormLogInfo.setBgForm(bgFormInfo);
                String strUserId = rs.getString("FUserId");
                if (strUserId != null) {
                    UserInfo userInfo = new UserInfo();
                    userInfo.setId(BOSUuid.read((String)strUserId));
                    userInfo.setName(rs.getString("FUserName"));
                    bgFormLogInfo.setCreator(userInfo);
                }
                bgFormLogCollection.add(bgFormLogInfo);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)statement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)conn);
        return bgFormLogCollection;
    }

    @Override
    protected int _getSeqByBgFromId(Context ctx, BOSUuid bgFormId) throws BOSException, EASBizException {
        int seq = 0;
        if (ctx == null) {
            return seq;
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        Connection conn = null;
        String strSql = "Select count(fid) as fseq from T_BG_BgFormLog where FBgFormId = ? ";
        conn = this.getConnection(ctx);
        try {
            ps = conn.prepareStatement(strSql);
            ps.setString(1, bgFormId.toString());
            rs = ps.executeQuery();
            if (rs.next()) {
                seq = rs.getInt("fseq");
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return seq;
    }
}

