/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.kdf.expr.Macro;
import com.kingdee.bos.ctrl.kdf.expr.SyntaxErrorException;
import com.kingdee.bos.ctrl.kdf.expr.TableRelations;
import com.kingdee.bos.ctrl.kdf.expr.Variant;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.SimpleTimer;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitCommon;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCommonFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.ITableManagerFacade;
import com.kingdee.eas.common.TableManagerFacadeFactory;
import com.kingdee.eas.ma.bg.BgCycleTypeEnum;
import com.kingdee.eas.ma.bg.BgDataInfo;
import com.kingdee.eas.ma.bg.BgElementCollection;
import com.kingdee.eas.ma.bg.BgElementInfo;
import com.kingdee.eas.ma.bg.BgEntryInfo;
import com.kingdee.eas.ma.bg.BgFormException;
import com.kingdee.eas.ma.bg.BgFormInfo;
import com.kingdee.eas.ma.bg.BgFormLogHelper;
import com.kingdee.eas.ma.bg.BgFormulaCollection;
import com.kingdee.eas.ma.bg.BgFormulaInfo;
import com.kingdee.eas.ma.bg.BgFormulaProxy;
import com.kingdee.eas.ma.bg.BgHelper;
import com.kingdee.eas.ma.bg.BgInstantApproveException;
import com.kingdee.eas.ma.bg.BgItemInfo;
import com.kingdee.eas.ma.bg.BgORMException;
import com.kingdee.eas.ma.bg.BgOperationEnum;
import com.kingdee.eas.ma.bg.BgOrgHelper;
import com.kingdee.eas.ma.bg.BgPastDataInfo;
import com.kingdee.eas.ma.bg.BgPastRecordInfo;
import com.kingdee.eas.ma.bg.BgPeriodNode;
import com.kingdee.eas.ma.bg.BgPeriodRange;
import com.kingdee.eas.ma.bg.BgProviderFactory;
import com.kingdee.eas.ma.bg.BgRollFormFactory;
import com.kingdee.eas.ma.bg.BgRptTemplateInfo;
import com.kingdee.eas.ma.bg.BgRptTemplateRowCollection;
import com.kingdee.eas.ma.bg.BgRptTemplateRowInfo;
import com.kingdee.eas.ma.bg.BgSchemeFactory;
import com.kingdee.eas.ma.bg.BgSchemeInfo;
import com.kingdee.eas.ma.bg.BgTemplateInfo;
import com.kingdee.eas.ma.bg.BgTypeFactory;
import com.kingdee.eas.ma.bg.BgTypeInfo;
import com.kingdee.eas.ma.bg.BgVersionInfo;
import com.kingdee.eas.ma.bg.IBgProvider;
import com.kingdee.eas.ma.bg.IBgScheme;
import com.kingdee.eas.ma.bg.IBgType;
import com.kingdee.eas.ma.bg.app.AbstractBgFormProcessControllerBean;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Logger;

public class BgFormProcessControllerBean
extends AbstractBgFormProcessControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.bg.app.BgFormProcessControllerBean");

    @Override
    protected String _addnewBgForm(Context ctx, IObjectValue bgFormInfo) throws BOSException, EASBizException {
        SimpleTimer timer = new SimpleTimer();
        BgFormInfo formInfo = (BgFormInfo)bgFormInfo;
        String name = formInfo.getName();
        String number = formInfo.getNumber();
        BgSchemeInfo schemeInfo = formInfo.getBgScheme();
        if (schemeInfo == null || schemeInfo.getId() == null) {
            throw new BOSException("NoSchemeInfo");
        }
        BOSUuid schemeId = schemeInfo.getId();
        BgTemplateInfo templateInfo = formInfo.getBgTemplate();
        if (templateInfo == null || templateInfo.getId() == null || templateInfo.getBgCycle() == null) {
            throw new BOSException("NoTemplateInfo");
        }
        BOSUuid templateId = templateInfo.getId();
        BgCycleTypeEnum bgCycle = templateInfo.getBgCycle();
        BgTypeInfo typeInfo = formInfo.getBgType();
        if (typeInfo == null || typeInfo.getId() == null) {
            throw new BOSException("NoTypeInfo");
        }
        BOSUuid typeId = typeInfo.getId();
        FullOrgUnitInfo orgUnitInfo = formInfo.getOrgUnit();
        if (orgUnitInfo == null || orgUnitInfo.getId() == null) {
            throw new BOSException("NoOrgUnitInfo");
        }
        BOSUuid orgUnitId = orgUnitInfo.getId();
        System.out.println("--------------------------------addnew BgForm 1 prepare: " + timer.getTime());
        String bgFormId = this.addnew_insertBgForm(ctx, name, number, schemeId.toString(), templateId.toString(), typeId.toString(), orgUnitId.toString(), false);
        System.out.println("--------------------------------addnew BgForm 2 addnew head: " + timer.getTime());
        ITableManagerFacade mang = TableManagerFacadeFactory.getLocalInstance((Context)ctx);
        String tmpPeriodTable = mang.getTableName("bg");
        try {
            this.addnew_createTmpTable(ctx, tmpPeriodTable);
            this.addnew_insertTmpPeriodTable(ctx, tmpPeriodTable, schemeId.toString(), bgCycle, orgUnitId.toString());
            System.out.println("--------------------------------addnew BgForm 3 addnew tmpPeriod: " + timer.getTime());
            this.addnew_insertBgEntry(ctx, bgFormId, tmpPeriodTable, templateId.toString());
            System.out.println("--------------------------------addnew BgForm 4 addnew entry: " + timer.getTime());
            this.addnew_insertBgData(ctx, bgFormId, templateId.toString(), tmpPeriodTable);
            System.out.println("--------------------------------addnew BgForm 5 addnew data: " + timer.getTime());
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            this.dropTmpTable(ctx, tmpPeriodTable);
        }
        this.addnew_applyScheme(ctx, bgFormId, templateId, schemeId);
        System.out.println("--------------------------------addnew BgForm: " + timer.getTime());
        return bgFormId;
    }

    private void addnew_applyScheme(Context ctx, String bgFormId, BOSUuid templateId, BOSUuid schemeId) throws EASBizException, BOSException {
        BgFormulaCollection bgc = this.getBgFormulaC(ctx, templateId, schemeId);
        BgFormulaProxy proxy = new BgFormulaProxy(ctx, schemeId.toString());
        TableRelations relations = new TableRelations();
        relations.getDefaultFunctionProvider().add(proxy);
        for (int i = 0; i < bgc.size(); ++i) {
            BgFormulaInfo formula = bgc.get(i);
            String fitem1id = formula.getBgItem1() == null ? "" : formula.getBgItem1().getId().toString();
            String fitem2id = formula.getBgItem2() == null ? "" : formula.getBgItem2().getId().toString();
            String fitem3id = formula.getBgItem3() == null ? "" : formula.getBgItem3().getId().toString();
            String fitem4id = formula.getBgItem4() == null ? "" : formula.getBgItem4().getId().toString();
            String fitem5id = formula.getBgItem5() == null ? "" : formula.getBgItem5().getId().toString();
            String fitem6id = formula.getBgItem6() == null ? "" : formula.getBgItem6().getId().toString();
            Vector entryIdVec = this.getBgEntryIdVec(ctx, bgFormId, fitem1id, fitem2id, fitem3id, fitem4id, fitem5id, fitem6id);
            for (int j = 0; j < entryIdVec.size(); ++j) {
                String formulaStr = formula.getFormula();
                formulaStr = "=" + formulaStr;
                String id = (String)entryIdVec.get(j);
                BgEntryInfo bgEntry = this.getBgEntryInfo(ctx, id);
                String item1id = (String)bgEntry.get("myItem1");
                String item2id = (String)bgEntry.get("myItem2");
                String item3id = (String)bgEntry.get("myItem3");
                String item4id = (String)bgEntry.get("myItem4");
                String item5id = (String)bgEntry.get("myItem5");
                String item6id = (String)bgEntry.get("myItem6");
                int year = (Integer)bgEntry.get("myYear");
                int quarter = (Integer)bgEntry.get("myQuarter");
                int number = (Integer)bgEntry.get("myNumber");
                int cycle = (Integer)bgEntry.get("myCycle");
                String periodStr = "";
                if (formulaStr.indexOf("CurrentPeriod") != -1) {
                    periodStr = year + "|" + quarter + "|" + number + "|";
                } else if (formulaStr.indexOf("PreviousPeriod") != -1) {
                    if (cycle == 3) {
                        if (number == 4 || number == 7 || number == 10) {
                            --number;
                            --quarter;
                        } else if (number == 1) {
                            --year;
                            number = 12;
                            quarter = 4;
                        } else {
                            --number;
                        }
                    } else if (cycle == 2) {
                        if (quarter == 4 || quarter == 2 || quarter == 3) {
                            number = 1;
                            --quarter;
                        } else if (quarter == 1) {
                            --year;
                            number = 10;
                            quarter = 4;
                        }
                    } else if (cycle == 1) {
                        --year;
                        number = 1;
                        quarter = 1;
                    }
                    periodStr = year + "|" + quarter + "|" + number + "|";
                } else if (formulaStr.indexOf("NextPeriod") != -1) {
                    if (cycle == 3) {
                        if (number == 3 || number == 6 || number == 9) {
                            ++number;
                            ++quarter;
                        } else if (number == 12) {
                            ++year;
                            number = 1;
                            quarter = 1;
                        } else {
                            ++number;
                        }
                    } else if (cycle == 2) {
                        if (quarter == 1 || quarter == 2 || quarter == 3) {
                            number = quarter == 1 ? 4 : (quarter == 2 ? 7 : 10);
                            ++quarter;
                        } else if (quarter == 4) {
                            ++year;
                            number = 1;
                            quarter = 1;
                        }
                    } else if (cycle == 1) {
                        ++year;
                        number = 1;
                        quarter = 1;
                    }
                    periodStr = year + "|" + quarter + "|" + number + "|";
                }
                if (cycle == 3) {
                    periodStr = periodStr + BgCycleTypeEnum.Period.getName();
                } else if (cycle == 2) {
                    periodStr = periodStr + BgCycleTypeEnum.Season.getName();
                } else if (cycle == 1) {
                    periodStr = periodStr + BgCycleTypeEnum.Year.getName();
                }
                if (formulaStr.indexOf("CurrentPeriod") != -1) {
                    formulaStr = formulaStr.replaceAll("CurrentPeriod", periodStr);
                } else if (formulaStr.indexOf("PreviousPeriod") != -1) {
                    formulaStr = formulaStr.replaceAll("PreviousPeriod", periodStr);
                } else if (formulaStr.indexOf("NextPeriod") != -1) {
                    formulaStr = formulaStr.replaceAll("NextPeriod", periodStr);
                }
                BigDecimal value = this.caculateFormula(formulaStr, relations);
                this.updateBgData(ctx, formula, bgEntry, id, value);
            }
        }
    }

    private void updateBgData(Context ctx, BgFormulaInfo formula, BgEntryInfo info, String id, BigDecimal value) throws BOSException {
        BgEntryInfo result = new BgEntryInfo();
        String currencySql = formula.getCurrency() == null ? "" : "and a.fcurrencyid=? ";
        String subSql = " select a.fid from t_bg_bgdata a,t_bg_bgentry b  where a.fbgentryid=b.fid " + currencySql + " and a.fbgelementid=?  and b.fid = ? ";
        String sql = " update t_bg_bgdata set fbgvalue = ?  where fid in  (  " + subSql + " ) ";
        Connection connection = null;
        PreparedStatement ps = null;
        try {
            connection = this.getConnection(ctx);
            ps = connection.prepareStatement(sql);
            ps.setBigDecimal(1, value);
            if (currencySql.equals("")) {
                ps.setString(2, formula.getBgElement().getId().toString());
                ps.setString(3, id);
            } else {
                ps.setString(2, formula.getCurrency().getId().toString());
                ps.setString(3, formula.getBgElement().getId().toString());
                ps.setString(4, id);
            }
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)connection);
    }

    private void updateBgRptData(Context ctx, String id, BigDecimal value) throws BOSException {
        BgEntryInfo result = new BgEntryInfo();
        String subSql = " select a.fid from t_bg_bgdata a,t_bg_bgentry b  where a.fbgentryid=b.fid  and b.fid = ? ";
        String sql = " update t_bg_bgdata set fbgvalue = ?  where fid in  (  " + subSql + " ) ";
        Connection connection = null;
        PreparedStatement ps = null;
        try {
            connection = this.getConnection(ctx);
            ps = connection.prepareStatement(sql);
            ps.setBigDecimal(1, value);
            ps.setString(2, id);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)connection);
    }

    private void updateBgRptData_balanceSheetBudge(Context ctx, String id, String eleNumber, BigDecimal value) throws BOSException {
        BgEntryInfo result = new BgEntryInfo();
        String subSql = " select a.fid from t_bg_bgdata a,t_bg_bgentry b  where a.fbgentryid=b.fid  and b.fid = ? and a.felementnumber = ? ";
        String sql = " update t_bg_bgdata set fbgvalue = ?  where fid in  (  " + subSql + " ) ";
        Connection connection = null;
        PreparedStatement ps = null;
        try {
            connection = this.getConnection(ctx);
            ps = connection.prepareStatement(sql);
            ps.setBigDecimal(1, value);
            ps.setString(2, id);
            ps.setString(3, eleNumber);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)connection);
    }

    private BigDecimal getCaclValue(Context ctx, HashSet set, String eleNumber, int cycle, String periodId) throws BOSException {
        BigDecimal result = new BigDecimal("0.00");
        String basicSql = "( select a.fbgvalue  from t_bg_bgdata a,t_bg_bgentry b  where a.fbgentryid=b.fid and b.fbgcycle = & and b.fperiodid = & and b.fbgitem1id = & and a.felementnumber = & )";
        String sql = " select 0 ";
        for (String str : set) {
            String[] ids = str.split("&");
            String temp = null;
            temp = ids[1].equals("+") ? "+" + new String(basicSql) : "-" + new String(basicSql);
            temp = temp.replaceFirst("&", cycle + "");
            temp = temp.replaceFirst("&", "'" + periodId + "'");
            temp = temp.replaceFirst("&", "'" + ids[0] + "'");
            temp = temp.replaceFirst("&", "'" + eleNumber + "'");
            sql = sql + temp;
        }
        sql = sql + " fbgvalue";
        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            connection = this.getConnection(ctx);
            ps = connection.prepareStatement(sql);
            rs = ps.executeQuery();
            if (rs.next()) {
                result = rs.getBigDecimal(1);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)connection);
        return result;
    }

    private BgEntryInfo getBgEntryInfo(Context ctx, String id) throws BOSException {
        BgEntryInfo result = new BgEntryInfo();
        String sql = " select a.fperiodid, a.fbgitem1id, a.fbgitem2id, a.fbgitem3id,  a.fbgitem4id, a.fbgitem5id, a.fbgitem6id,  b.fperiodyear, b.fperiodquarter, b.fperiodnumber ,a.fbgcycle from t_bg_bgentry a,t_bd_period b  where a.fperiodid = b.fid and a.fid=? ";
        ResultSet rs = null;
        Connection connection = null;
        PreparedStatement ps = null;
        try {
            connection = this.getConnection(ctx);
            ps = connection.prepareStatement(sql);
            ps.setString(1, id);
            rs = ps.executeQuery();
            if (rs.next()) {
                String periodId = rs.getString(1);
                result.put("myPeriod", periodId);
                String item1Id = rs.getString(2) == null ? "" : rs.getString(2);
                result.put("myItem1", item1Id);
                String item2Id = rs.getString(3) == null ? "" : rs.getString(3);
                result.put("myItem2", item2Id);
                String item3Id = rs.getString(4) == null ? "" : rs.getString(4);
                result.put("myItem3", item3Id);
                String item4Id = rs.getString(5) == null ? "" : rs.getString(5);
                result.put("myItem4", item4Id);
                String item5Id = rs.getString(6) == null ? "" : rs.getString(6);
                result.put("myItem5", item5Id);
                String item6Id = rs.getString(7) == null ? "" : rs.getString(7);
                result.put("myItem6", item6Id);
                int year = rs.getInt(8);
                int quarter = rs.getInt(9);
                int number = rs.getInt(10);
                result.put("myYear", new Integer(year));
                result.put("myQuarter", new Integer(quarter));
                result.put("myNumber", new Integer(number));
                int bgCycle = rs.getInt(11);
                result.put("myCycle", new Integer(bgCycle));
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)connection);
        return result;
    }

    private BigDecimal caculateFormula(String theFormula, TableRelations relations) {
        Object theValue;
        BigDecimal result = new BigDecimal("0");
        if (theFormula == null || theFormula.equals("")) {
            return result;
        }
        if (theFormula.equals("")) {
            return result;
        }
        Macro macro = relations.getNewMacroEngine(null, theFormula);
        boolean executeResult = false;
        try {
            executeResult = macro.execute();
        }
        catch (Exception e1) {
            e1.printStackTrace();
            return result;
        }
        if (!executeResult) {
            SyntaxErrorException e = macro.getSyntaxError();
            System.out.println(e.getMessage());
            return new BigDecimal("0");
        }
        Variant variant = macro.getVariableValue("$VALUE");
        if (variant != null && (theValue = variant.getValue()) != null) {
            if (theValue instanceof Number) {
                result = new BigDecimal(theValue.toString());
            } else if (theValue instanceof BigDecimal) {
                result = (BigDecimal)theValue;
            }
        }
        return result;
    }

    private BgFormulaCollection getBgFormulaC(Context ctx, BOSUuid templateId, BOSUuid schemeId) throws SQLDataException, BOSException {
        BgFormulaCollection bgc = new BgFormulaCollection();
        String sql = " select a.fformula, a.fcurrencyid, a.fbgitem1id,  a.fbgitem2id, a.fbgitem3id, a.fbgitem4id, a.fbgitem5id, a.fbgitem6id, a.fbgelementid, a.fbgmodelnodeid from t_bg_bgformula a,t_bg_bgmodelnode b  where a.fbgmodelnodeid = b.fid and b.fbgschemeid=? and b.fbgtemplateid=?";
        ResultSet rs = null;
        Connection connection = null;
        PreparedStatement ps = null;
        try {
            connection = this.getConnection(ctx);
            ps = connection.prepareStatement(sql);
            ps.setString(1, schemeId.toString());
            ps.setString(2, templateId.toString());
            rs = ps.executeQuery();
            while (rs.next()) {
                BgFormulaInfo info = new BgFormulaInfo();
                info.setFormula(rs.getString(1));
                CurrencyInfo currency = new CurrencyInfo();
                String currencyId = rs.getString(2);
                if (currencyId == null) {
                    info.setCurrency(null);
                } else {
                    currency.setId(BOSUuid.read((String)currencyId));
                    info.setCurrency(currency);
                }
                String item1id = rs.getString(3);
                if (item1id == null) {
                    info.setBgItem1(null);
                } else {
                    BgItemInfo item1 = new BgItemInfo();
                    item1.setId(BOSUuid.read((String)item1id));
                    info.setBgItem1(item1);
                }
                String item2id = rs.getString(4);
                if (item2id == null) {
                    info.setBgItem2(null);
                } else {
                    BgItemInfo item2 = new BgItemInfo();
                    item2.setId(BOSUuid.read((String)item2id));
                    info.setBgItem2(item2);
                }
                String item3id = rs.getString(5);
                if (item3id == null) {
                    info.setBgItem3(null);
                } else {
                    BgItemInfo item3 = new BgItemInfo();
                    item3.setId(BOSUuid.read((String)item3id));
                    info.setBgItem3(item3);
                }
                String item4id = rs.getString(6);
                if (item4id == null) {
                    info.setBgItem4(null);
                } else {
                    BgItemInfo item4 = new BgItemInfo();
                    item4.setId(BOSUuid.read((String)item4id));
                    info.setBgItem4(item4);
                }
                String item5id = rs.getString(7);
                if (item5id == null) {
                    info.setBgItem5(null);
                } else {
                    BgItemInfo item5 = new BgItemInfo();
                    item5.setId(BOSUuid.read((String)item5id));
                    info.setBgItem5(item5);
                }
                String item6id = rs.getString(8);
                if (item6id == null) {
                    info.setBgItem6(null);
                } else {
                    BgItemInfo item6 = new BgItemInfo();
                    item6.setId(BOSUuid.read((String)item6id));
                    info.setBgItem6(item6);
                }
                BgElementInfo ele = new BgElementInfo();
                ele.setId(BOSUuid.read((String)rs.getString(9)));
                info.setBgElement(ele);
                bgc.add(info);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)connection);
        return bgc;
    }

    private BgRptTemplateRowCollection getBgRptFormulaC(Context ctx, BOSUuid templateId, BOSUuid schemeId) throws SQLDataException, BOSException {
        BgRptTemplateRowCollection bgc = new BgRptTemplateRowCollection();
        String sql = "select  T_BG_BgRptTemplateRow.FFormula AS bgRptTpRow_formula, T_BG_BgRptTemplateRow.FNumber AS bgRptTpRow_number, t_bg_bgitem.Fid AS bgItem_id  FROM T_BG_BgRptTemplate ,T_BG_BgRptTemplateRow , T_bg_bgtemplate,T_BG_ReferencedDimension,t_bg_bgitem  where T_BG_BgRptTemplate.FID = T_BG_BgRptTemplateRow.FBgRptTemplateID  and T_BG_BgRptTemplate.fbgtemplateid = T_bg_bgtemplate.fid  and T_BG_ReferencedDimension.fbgtemplateid = T_bg_bgtemplate.fid  and t_bg_bgitem.FRefDimensionID = T_BG_ReferencedDimension.fid  and T_BG_BgRptTemplateRow.FSeq = t_bg_bgitem.fitemnumber  and T_BG_BgRptTemplate.FBgTemplateID = ?  and T_BG_BgRptTemplateRow.FType=2  and len(T_BG_BgRptTemplateRow.FFormula) > 0 ";
        ResultSet rs = null;
        Connection connection = null;
        PreparedStatement ps = null;
        try {
            connection = this.getConnection(ctx);
            ps = connection.prepareStatement(sql);
            ps.setString(1, templateId.toString());
            rs = ps.executeQuery();
            while (rs.next()) {
                BgRptTemplateRowInfo info = new BgRptTemplateRowInfo();
                info.put("myFormula", rs.getString(1));
                info.put("myNumber", rs.getString(2));
                info.put("myItem", rs.getString(3));
                bgc.add(info);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)connection);
        return bgc;
    }

    private Vector getBgEntryIdVec(Context ctx, String bgFormId, String item1id, String item2id, String item3id, String item4id, String item5id, String item6id) throws SQLDataException, BOSException {
        Vector<String> entryIdVec = new Vector<String>(100);
        String sql = "select fid from t_bg_bgentry where fbgformid=? and fisLeafPeriod = 1 ";
        if (!item1id.equals("")) {
            sql = sql + " and fbgitem1id = '" + item1id + "'";
        }
        if (!item2id.equals("")) {
            sql = sql + " and fbgitem2id = '" + item2id + "'";
        }
        if (!item3id.equals("")) {
            sql = sql + " and fbgitem3id = '" + item3id + "'";
        }
        if (!item4id.equals("")) {
            sql = sql + " and fbgitem4id = '" + item4id + "'";
        }
        if (!item5id.equals("")) {
            sql = sql + " and fbgitem5id = '" + item5id + "'";
        }
        if (!item6id.equals("")) {
            sql = sql + " and fbgitem6id = '" + item6id + "'";
        }
        ResultSet rs = null;
        Connection connection = null;
        PreparedStatement ps = null;
        try {
            connection = this.getConnection(ctx);
            ps = connection.prepareStatement(sql);
            ps.setString(1, BOSUuid.read((String)bgFormId).toString());
            rs = ps.executeQuery();
            while (rs.next()) {
                entryIdVec.add(rs.getString(1));
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)connection);
        return entryIdVec;
    }

    private Vector getBgRptEntryIdVec(Context ctx, String bgFormId, String bgItemId) throws SQLDataException, BOSException {
        Vector<String> entryIdVec = new Vector<String>(100);
        String sql = "select fid from t_bg_bgentry where fbgformid=? and fbgitem1id=? and fisLeafPeriod = 1";
        ResultSet rs = null;
        Connection connection = null;
        PreparedStatement ps = null;
        try {
            connection = this.getConnection(ctx);
            ps = connection.prepareStatement(sql);
            ps.setString(1, BOSUuid.read((String)bgFormId).toString());
            ps.setString(2, BOSUuid.read((String)bgItemId).toString());
            rs = ps.executeQuery();
            while (rs.next()) {
                entryIdVec.add(rs.getString(1));
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)connection);
        return entryIdVec;
    }

    private void addnew_insertBgData(Context ctx, String bgFormId, String bgTemplateId, String tmpPeriodTable) throws BOSException {
        BgDataInfo tmpDataInfo = new BgDataInfo();
        String bosType = tmpDataInfo.getBOSType().toString();
        StringBuffer sbInsert = new StringBuffer(" insert into t_bg_bgdata");
        sbInsert.append(" ( FID, FDataType, FBgValue, FElementNumber, ");
        sbInsert.append("FBgCtrlType, FIsFlexibleCtrl, FFlexibleBgCtrlParam, FCurrencyID, ");
        sbInsert.append(" FBgElementID, FBgEntryID, FIdentity ) ");
        sbInsert.append("select newid() || '");
        sbInsert.append(bosType);
        sbInsert.append("' as FID, ele.FDataType, 0.0 as FBgValue, ele.FNumber as FElementNumber, ");
        sbInsert.append("isnull( ( select row1.FBgControlType * col.FIsControlled where row1.FBgControlType * col.FIsControlled <> 0 ), 1 ) as FBgCtrlType, ");
        sbInsert.append("row1.FIsFlexibleCtrl, row1.FFlexibleBgCtrlParam, cur.FCurrencyID, ");
        sbInsert.append("ele.FID as FBgElementID, entry.FID as FBgEntryID, ");
        sbInsert.append("period.FIdentity||'_'||entry.FBgItemsKey||'_'||ele.FNumber||'_'||currency.FNumber as FIdentity ");
        sbInsert.append("from T_BG_BgTemplateColumn as col, T_BG_BgElement as ele, T_BG_BgEntry as entry, ");
        sbInsert.append("T_BG_BgTemplateRow as row1, T_BG_ReferencedCurrency as cur, ");
        sbInsert.append(tmpPeriodTable);
        sbInsert.append(" as period, T_BD_Currency as currency ");
        sbInsert.append("where col.FBgTemplateID='");
        sbInsert.append(bgTemplateId);
        sbInsert.append("' and cur.FBgTemplateID='");
        sbInsert.append(bgTemplateId);
        sbInsert.append("' and ele.FID=col.FBgElementID and ele.FDataType=1 and entry.FBgFormID='");
        sbInsert.append(bgFormId);
        sbInsert.append("' and row1.FBgTemplateID='");
        sbInsert.append(bgTemplateId);
        sbInsert.append("' and isnull(row1.FBgItem1ID, 'xxx')=isnull(entry.FBgItem1ID, 'xxx') ");
        sbInsert.append(" and isnull(row1.FBgItem2ID, 'xxx')=isnull(entry.FBgItem2ID, 'xxx') ");
        sbInsert.append(" and isnull(row1.FBgItem3ID, 'xxx')=isnull(entry.FBgItem3ID, 'xxx') ");
        sbInsert.append(" and entry.FPeriodID=period.FPeriodID and entry.FBgCycle=period.FBgCycle and currency.FID=cur.FCurrencyID");
        Connection connection = null;
        PreparedStatement ps = null;
        String sql = sbInsert.toString();
        try {
            connection = this.getConnection(ctx);
            ps = connection.prepareStatement(sql);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)connection);
        sbInsert = new StringBuffer(" insert into t_bg_bgdata");
        sbInsert.append(" ( FID, FDataType, FBgValue, FElementNumber, ");
        sbInsert.append("FBgCtrlType, FIsFlexibleCtrl, FFlexibleBgCtrlParam, FCurrencyID, ");
        sbInsert.append(" FBgElementID, FBgEntryID, FIdentity ) ");
        sbInsert.append("select newid() || '");
        sbInsert.append(bosType);
        sbInsert.append("' as FID, ele.FDataType, 0.0 as FBgValue, ele.FNumber as FElementNumber, ");
        sbInsert.append("isnull( ( select row1.FBgControlType * col.FIsControlled where row1.FBgControlType * col.FIsControlled <> 0 ), 1 ) as FBgCtrlType, ");
        sbInsert.append("row1.FIsFlexibleCtrl, row1.FFlexibleBgCtrlParam, ");
        sbInsert.append("(select top 1 FCurrencyID from T_BG_ReferencedCurrency where FBgTemplateID='");
        sbInsert.append(bgTemplateId);
        sbInsert.append("') as FCurrencyID, ");
        sbInsert.append("ele.FID as FBgElementID, entry.FID as FBgEntryID, ");
        sbInsert.append("period.FIdentity||'_'||entry.FBgItemsKey||'_'||ele.FNumber as FIdentity ");
        sbInsert.append("from T_BG_BgTemplateColumn as col, T_BG_BgElement as ele, T_BG_BgEntry as entry, T_BG_BgTemplateRow as row1, ");
        sbInsert.append(tmpPeriodTable);
        sbInsert.append(" as period ");
        sbInsert.append("where col.FBgTemplateID='");
        sbInsert.append(bgTemplateId);
        sbInsert.append("' and ele.FID=col.FBgElementID and ele.FDataType<>1 and entry.FBgFormID='");
        sbInsert.append(bgFormId);
        sbInsert.append("' and row1.FBgTemplateID='");
        sbInsert.append(bgTemplateId);
        sbInsert.append("' and isnull(row1.FBgItem1ID, 'xxx')=isnull(entry.FBgItem1ID, 'xxx') ");
        sbInsert.append(" and isnull(row1.FBgItem2ID, 'xxx')=isnull(entry.FBgItem2ID, 'xxx') ");
        sbInsert.append(" and isnull(row1.FBgItem3ID, 'xxx')=isnull(entry.FBgItem3ID, 'xxx') ");
        sbInsert.append("and entry.FPeriodID=period.FPeriodID and entry.FBgCycle=period.FBgCycle ");
        connection = null;
        ps = null;
        sql = sbInsert.toString();
        try {
            connection = this.getConnection(ctx);
            ps = connection.prepareStatement(sql);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Statement)ps, (Connection)connection);
        }
    }

    private void addnew_insertBgEntry(Context ctx, String bgFormId, String tmpPeriodTable, String bgTemplateId) throws BOSException {
        BgEntryInfo tmpEntryInfo = new BgEntryInfo();
        String bosType = tmpEntryInfo.getBOSType().toString();
        StringBuffer sbInsert = new StringBuffer(" insert into t_bg_bgentry");
        sbInsert.append(" ( FID, FBgCycle, FPeriodID, FIsLeafPeriod, ");
        sbInsert.append(" FBgItem1ID, FBgItem2ID, FBgItem3ID, FBgItem4ID, FBgItem5ID, FBgItem6ID, ");
        sbInsert.append(" FBgFormID, FIsLeafEntry, FBgItemsKey, FEntryType, FSplitRate ) ");
        sbInsert.append(" select newid() || '");
        sbInsert.append(bosType);
        sbInsert.append("' as FID, period.FBgCycle, period.FPeriodID, period.FIsLeafPeriod, ");
        sbInsert.append(" row1.FBgItem1ID, row1.FBgItem2ID, row1.FBgItem3ID, row1.FBgItem4ID, row1.FBgItem5ID, row1.FBgItem6ID, '");
        sbInsert.append(bgFormId);
        sbInsert.append("' as FBgFormID, isnull( (select FIsLeaf from T_BG_BgItem where FID=row1.FBgItem1ID), 1 ) * ");
        sbInsert.append(" isnull( (select FIsLeaf from T_BG_BgItem where FID=row1.FBgItem2ID), 1 ) * ");
        sbInsert.append(" isnull( (select FIsLeaf from T_BG_BgItem where FID=row1.FBgItem3ID), 1 ) * ");
        sbInsert.append(" isnull( (select FIsLeaf from T_BG_BgItem where FID=row1.FBgItem4ID), 1 ) * ");
        sbInsert.append(" isnull( (select FIsLeaf from T_BG_BgItem where FID=row1.FBgItem5ID), 1 ) * ");
        sbInsert.append(" isnull( (select FIsLeaf from T_BG_BgItem where FID=row1.FBgItem6ID), 1 ) as FIsLeafEntry, ");
        sbInsert.append(" (select FItemNumber from T_BG_BgItem where FID=row1.FBgItem1ID)");
        sbInsert.append(" || isnull( (select '_' || FItemNumber from T_BG_BgItem where FID=row1.FBgItem2ID), '' )");
        sbInsert.append(" || isnull( (select '_' || FItemNumber from T_BG_BgItem where FID=row1.FBgItem3ID), '' ) as FBgItemsKey, ");
        sbInsert.append(" 0 as FEntryType, 0.0 as FSplitRate ");
        sbInsert.append(" from ");
        sbInsert.append(tmpPeriodTable);
        sbInsert.append(" as period, t_bg_bgtemplaterow as row1 where row1.FBgTemplateID='");
        sbInsert.append(bgTemplateId);
        sbInsert.append("'");
        Connection connection = null;
        PreparedStatement ps = null;
        String sql = sbInsert.toString();
        try {
            connection = this.getConnection(ctx);
            ps = connection.prepareStatement(sql);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)connection);
    }

    private void dropTmpTable(Context ctx, String tmpTable) throws BOSException {
        ITableManagerFacade tbl = TableManagerFacadeFactory.getLocalInstance((Context)ctx);
        tbl.releaseTableName(tmpTable);
    }

    private void addnew_insertTmpPeriodTable(Context ctx, String tmpPeriodTable, String bgSchemeId, BgCycleTypeEnum bgCycle, String orgUnitId) throws EASBizException, BOSException {
        StringBuffer sbInsert = new StringBuffer(" insert into ");
        sbInsert.append(tmpPeriodTable);
        sbInsert.append(" ( FPeriodID, FBgCycle, FIsLeafPeriod, FIdentity ) values (?, ?, ?, ?)");
        String sql = sbInsert.toString();
        Vector vector = this.addnew_getPeriodNodeVector(ctx, bgSchemeId, bgCycle, orgUnitId);
        if (vector == null) {
            throw new EASBizException(BgFormException.CREATEPERIODTREE);
        }
        Connection connection = null;
        PreparedStatement ps = null;
        try {
            connection = this.getConnection(ctx);
            for (int i = 0; i < vector.size(); ++i) {
                BgPeriodNode bgPeriodNode = (BgPeriodNode)vector.get(i);
                ps = connection.prepareStatement(sql);
                ps.setString(1, bgPeriodNode.getPeriod().getId().toString());
                ps.setInt(2, bgPeriodNode.getBgCycle().getValue());
                ps.setBoolean(3, bgPeriodNode.isLeaf());
                String identity = BgPeriodNode.toNumbericString(bgPeriodNode.getPeriod(), bgPeriodNode.getBgCycle());
                ps.setString(4, identity);
                ps.execute();
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(ps, (Connection)connection);
        }
    }

    private void addnew_createTmpTable(Context ctx, String tmpPeriodTable) throws BOSException {
        Connection connection = null;
        PreparedStatement ps = null;
        try {
            StringBuffer sbCreate = new StringBuffer("create table ");
            sbCreate.append(tmpPeriodTable);
            sbCreate.append(" (FPeriodID varchar (44), FBgCycle int, FIsLeafPeriod int, FIdentity varchar(50)) ");
            String sql = sbCreate.toString();
            connection = this.getConnection(ctx);
            ps = connection.prepareStatement(sql);
            ps.execute();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String addnew_insertBgForm(Context ctx, String name, String number, String bgSchemeId, String bgTemplateId, String bgTypeId, String orgUnitId, boolean isDistribute) throws BOSException {
        Connection connection = null;
        PreparedStatement ps = null;
        String sqlInsert = "insert into t_bg_bgform (FID, FNumber, FName, FState, FPurpose, FIsCurrent, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FHasEffected, FCompanyID, FBgTemplateID, FBgSchemeID, FBgTypeID, FPeriodFromID, FPeriodToID, FOrgUnitID, FDataSource, FControlUnitID) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        String fid = "";
        try {
            connection = this.getConnection(ctx);
            ps = connection.prepareStatement(sqlInsert);
            BgFormInfo tmpFormInfo = new BgFormInfo();
            BOSUuid tmpFormId = BOSUuid.create((BOSObjectType)tmpFormInfo.getBOSType());
            fid = tmpFormId.toString();
            tmpFormInfo.setId(tmpFormId);
            ps.setString(1, fid);
            ps.setString(2, number);
            ps.setString(3, name);
            if (!isDistribute) {
                ps.setInt(4, 1);
            } else {
                ps.setInt(4, 8);
            }
            ps.setInt(5, 1);
            ps.setInt(6, 1);
            ps.setString(7, ctx.getCaller().toString());
            Date date = new Date();
            long time = date.getTime();
            Calendar d = Calendar.getInstance();
            d.setTime(new Timestamp(time));
            d.set(14, 0);
            Timestamp createtime = new Timestamp(d.getTime().getTime());
            ps.setTimestamp(8, createtime);
            ps.setString(9, ctx.getCaller().toString());
            ps.setTimestamp(10, createtime);
            ps.setInt(11, 1);
            IOrgUnitCommon iOrgUnitCommon = OrgUnitCommonFactory.getLocalInstance((Context)ctx);
            CompanyOrgUnitInfo companyInfo = null;
            try {
                companyInfo = (CompanyOrgUnitInfo)iOrgUnitCommon.getRelationUnit(BOSUuid.read((String)orgUnitId), OrgType.Company);
            }
            catch (EASBizException e1) {
                e1.printStackTrace();
            }
            catch (BOSException e1) {
                e1.printStackTrace();
            }
            ps.setString(12, companyInfo.getId().toString());
            ps.setString(13, bgTemplateId);
            ps.setString(14, bgSchemeId);
            ps.setString(15, bgTypeId);
            IBgScheme iBgScheme = BgSchemeFactory.getLocalInstance(ctx);
            BgSchemeInfo schemeInfo = iBgScheme.getBgSchemeInfo("select periodFrom, periodTo where id='" + bgSchemeId + "'");
            ps.setString(16, schemeInfo.getPeriodFrom().getId().toString());
            ps.setString(17, schemeInfo.getPeriodTo().getId().toString());
            ps.setString(18, orgUnitId);
            if (!isDistribute) {
                ps.setInt(19, 0);
            } else {
                ps.setInt(19, -1);
            }
            CtrlUnitInfo cuInfo = BgOrgHelper.getDefCU();
            ps.setString(20, cuInfo.getId().toString());
            ps.executeUpdate();
            UserInfo userInfo = new UserInfo();
            userInfo.setId(BOSUuid.read((String)ctx.getCaller().toString()));
            if (!isDistribute) {
                BgFormLogHelper.addNewBgFormLog(ctx, tmpFormInfo, BgOperationEnum.AddNew, userInfo);
            } else {
                BgFormLogHelper.addNewBgFormLog(ctx, tmpFormInfo, BgOperationEnum.Distribute, userInfo);
            }
            SQLUtils.cleanup((Statement)ps, (Connection)connection);
            return fid;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
            catch (EASBizException e2) {
                e2.printStackTrace();
                return fid;
            }
            catch (BOSException e3) {
                e3.printStackTrace();
                SQLUtils.cleanup((Statement)ps, (Connection)connection);
                return fid;
            }
        }
        finally {
            SQLUtils.cleanup(ps, (Connection)connection);
        }
    }

    private Vector addnew_getPeriodNodeVector(Context ctx, String bgSchemeId, BgCycleTypeEnum bgCycle, String orgUnitId) throws EASBizException, BOSException {
        IBgScheme iBgScheme = BgSchemeFactory.getLocalInstance(ctx);
        BgSchemeInfo schemeInfo = iBgScheme.getBgSchemeInfo("select periodFrom, periodTo where id='" + bgSchemeId + "'");
        BgPeriodRange bgPeriodRange = new BgPeriodRange(schemeInfo.getPeriodFrom(), schemeInfo.getPeriodTo());
        IOrgUnitCommon iOrgUnitCommon = OrgUnitCommonFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo companyInfo = iOrgUnitCommon.getCompany(BOSUuid.read((String)orgUnitId));
        PeriodCollection periods = PeriodUtils.getPeriodc((Context)ctx, (PeriodInfo)schemeInfo.getPeriodFrom(), (PeriodInfo)schemeInfo.getPeriodTo(), (CompanyOrgUnitInfo)companyInfo);
        periods = BgHelper.filterAdjustPeriod(periods);
        Vector vector = bgPeriodRange.getPeriodNodesInRange(companyInfo, bgCycle, periods);
        return vector;
    }

    @Override
    protected void _distributeBgForm(Context ctx, String bgFormId, IObjectCollection subOrgColl, Hashtable mapScale) throws BOSException, EASBizException {
        SimpleTimer timer = new SimpleTimer();
        BigDecimal hundred = new BigDecimal(100);
        ITableManagerFacade mang = TableManagerFacadeFactory.getLocalInstance((Context)ctx);
        String tmpBgDataTable = mang.getTableName("bg");
        BgTypeInfo bgType = this.bgType(ctx, bgFormId);
        try {
            BgFormInfo totalFormInfo = this.distribute_getTotalBgForm(ctx, bgFormId);
            this.distribute_prepareTmpBgDataTable(ctx, tmpBgDataTable, bgFormId);
            int m = subOrgColl.size();
            for (int i = 0; i < m; ++i) {
                BigDecimal scale;
                OrgUnitInfo subOrgInfo = (OrgUnitInfo)subOrgColl.getObject(i);
                BgFormInfo subFormInfo = this.distribute_matchSubBgForm(ctx, totalFormInfo, subOrgInfo);
                if (subFormInfo == null) {
                    scale = (BigDecimal)mapScale.get(subOrgInfo.getId().toString());
                    scale = scale.divide(hundred, 2, 6);
                    this.distribute_addnewSubBgForm(ctx, totalFormInfo, subOrgInfo, scale, tmpBgDataTable);
                    continue;
                }
                scale = (BigDecimal)mapScale.get(subOrgInfo.getId().toString());
                scale = scale.divide(hundred, 2, 6);
                this.distribute_updateSubBgFormWithRecord(ctx, totalFormInfo, subFormInfo, scale, tmpBgDataTable, bgType);
            }
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            this.dropTmpTable(ctx, tmpBgDataTable);
        }
        System.out.println("--------------------------------distribute BgForm: " + timer.getTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BgTypeInfo bgType(Context ctx, String bgFormId) throws EASBizException, BOSException {
        String ID;
        BOSUuid bgTypeID;
        ResultSet rs;
        Connection conn;
        PreparedStatement ps;
        block4: {
            Object connection = null;
            ps = null;
            conn = null;
            rs = null;
            bgTypeID = null;
            ID = "";
            String sql = new String("select FBgTypeId from t_bg_bgForm where Fid= ? ");
            try {
                conn = this.getConnection(ctx);
                ps = conn.prepareStatement(sql);
                ps.setString(1, bgFormId);
                rs = ps.executeQuery();
                if (!rs.next()) break block4;
                ID = rs.getString(1);
            }
            catch (SQLException e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, ps, (Connection)conn);
                    throw throwable;
                }
                SQLUtils.cleanup(rs, (Statement)ps, (Connection)conn);
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        bgTypeID = BOSUuid.read((String)ID);
        IBgType iBg = BgTypeFactory.getLocalInstance(ctx);
        return iBg.getBgTypeBySql(bgTypeID);
    }

    private void distribute_prepareTmpBgDataTable(Context ctx, String tmpBgDataTable, String bgFormId) throws BOSException, EASBizException {
        Connection connection = null;
        PreparedStatement ps = null;
        try {
            StringBuffer sbCreate = new StringBuffer("create table ");
            sbCreate.append(tmpBgDataTable);
            sbCreate.append(" (FBgValue decimal (28, 10), FIdentity varchar (255)) ");
            String sql = sbCreate.toString();
            connection = this.getConnection(ctx);
            ps = connection.prepareStatement(sql);
            ps.execute();
            sbCreate = new StringBuffer("create index IX_");
            sbCreate.append(tmpBgDataTable);
            sbCreate.append(" on ");
            sbCreate.append(tmpBgDataTable);
            sbCreate.append(" (FIdentity) ");
            sql = sbCreate.toString();
            ps = connection.prepareStatement(sql);
            ps.execute();
            sbCreate = new StringBuffer("insert into ");
            sbCreate.append(tmpBgDataTable);
            sbCreate.append(" (FBgValue, FIdentity) ");
            sbCreate.append(" select FBgValue, FIdentity from t_bg_bgdata where FBgEntryID in ");
            sbCreate.append("(select FID from t_bg_bgentry where FBgFormID=?) ");
            sql = sbCreate.toString();
            ps = connection.prepareStatement(sql);
            ps.setString(1, bgFormId);
            ps.execute();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)connection);
    }

    private void distribute_updateSubBgFormWithRecord(Context ctx, BgFormInfo totalFormInfo, BgFormInfo subFormInfo, BigDecimal scale, String tmpBgDataTable, BgTypeInfo bgType) throws BOSException, EASBizException {
        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String sql = "";
        StringBuffer sbSql = null;
        String subFormId = subFormInfo.getId().toString();
        String pastRecordId = "";
        try {
            connection = this.getConnection(ctx);
            UserInfo userInfo = new UserInfo();
            userInfo.setId(BOSUuid.read((String)ctx.getCaller().toString()));
            BgFormLogHelper.addNewBgFormLog(ctx, subFormInfo, BgOperationEnum.Distribute, userInfo);
            sql = "update t_bg_bgform set FDataSource=?, FHasEffected=? where FID=?";
            ps = connection.prepareStatement(sql);
            ps.setInt(1, -1);
            ps.setBoolean(2, true);
            ps.setString(3, subFormId);
            ps.execute();
            int seq = -1;
            sql = "select count(fid) from T_BG_BgPastRecord where FBgFormID=?";
            ps = connection.prepareStatement(sql);
            ps.setString(1, subFormId);
            rs = ps.executeQuery();
            if (rs.next()) {
                seq = rs.getInt(1);
            }
            sql = "insert into T_BG_BgPastRecord (FID, FSeq, FModifyDate, FBgFormID, FModifierID) values (?,?,?,?,?)";
            ps = connection.prepareStatement(sql);
            pastRecordId = BOSUuid.create((BOSObjectType)new BgPastRecordInfo().getBOSType()).toString();
            ps.setString(1, pastRecordId);
            ps.setInt(2, ++seq);
            Date date = new Date();
            long time = date.getTime();
            Calendar d = Calendar.getInstance();
            d.setTime(new Timestamp(time));
            d.set(14, 0);
            Timestamp modifyTime = new Timestamp(d.getTime().getTime());
            ps.setTimestamp(3, modifyTime);
            ps.setString(4, subFormId);
            ps.setString(5, ctx.getCaller().toString());
            ps.execute();
            BgElementCollection bgEleC = bgType.getElements();
            for (int i = 0; i < bgEleC.size(); ++i) {
                String bosType = new BgPastDataInfo().getBOSType().toString();
                sbSql = new StringBuffer("insert into T_BG_BgPastData (FID, FPastValue, FBalance, FBgDataID, FBgPastRecordID, FDataSource) ");
                sbSql.append(" select NEWID() || '");
                sbSql.append(bosType);
                sbSql.append("' as FID, data.FBgValue as FPastValue, ( tmp.FBgValue ");
                if (bgEleC.get(i).isApportionable()) {
                    sbSql.append(" * ");
                    sbSql.append(scale.toString());
                }
                sbSql.append(" - data.FBgValue ) as FBalance, data.FID as FBgDataID, '");
                sbSql.append(pastRecordId);
                sbSql.append("' as FBgPastRecordID, -1 as FDataSource ");
                sbSql.append("from t_bg_bgdata as data, ");
                sbSql.append(tmpBgDataTable);
                sbSql.append(" as tmp ");
                sbSql.append(" where data.fbgelementid = '");
                sbSql.append(bgEleC.get(i).getId().toString());
                sbSql.append("' and data.FBgEntryID in (select FID from t_bg_bgentry where FBgFormID='");
                sbSql.append(subFormId);
                sbSql.append("') and data.FIdentity = tmp.FIdentity and (tmp.FBgValue * ");
                sbSql.append(scale.toString());
                sbSql.append(" - data.FBgValue ) <> 0");
                sql = sbSql.toString();
                ps = connection.prepareStatement(sql);
                ps.execute();
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)connection);
        this.distribute_updateSubBgForm(ctx, totalFormInfo.getId().toString(), subFormId, scale, tmpBgDataTable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void distribute_addnewSubBgForm(Context ctx, BgFormInfo totalFormInfo, OrgUnitInfo subOrgInfo, BigDecimal scale, String tmpBgDataTable) throws BOSException, EASBizException {
        ResultSet rs = null;
        Connection connection = null;
        PreparedStatement ps = null;
        String typeId = totalFormInfo.getBgType().getId().toString();
        String templateId = null;
        BgCycleTypeEnum bgCycle = null;
        String sql = "select FID, FBgCycle FROM T_BG_BgTemplate  where (FIsCurrent = 1) and FBgTypeID = ? AND FOrgUnitID = ? ";
        try {
            connection = this.getConnection(ctx);
            ps = connection.prepareStatement(sql);
            ps.setString(1, BOSUuid.read((String)typeId).toString());
            ps.setString(2, BOSUuid.read((String)subOrgInfo.getId().toString()).toString());
            rs = ps.executeQuery();
            if (rs.next()) {
                templateId = rs.getString("FID");
                int cycle = rs.getInt("FBgCycle");
                bgCycle = BgCycleTypeEnum.getEnum(cycle);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)connection);
        if (templateId == null) {
            templateId = totalFormInfo.getBgTemplate().getId().toString();
            bgCycle = totalFormInfo.getBgTemplate().getBgCycle();
        }
        String schemeId = null;
        sql = "select fid from t_bg_bgscheme where fbgschemeid=? and forgunitid=?";
        try {
            connection = this.getConnection(ctx);
            ps = connection.prepareStatement(sql);
            ps.setString(1, BOSUuid.read((String)totalFormInfo.getBgScheme().getId().toString()).toString());
            ps.setString(2, BOSUuid.read((String)subOrgInfo.getId().toString()).toString());
            rs = ps.executeQuery();
            if (rs.next()) {
                schemeId = rs.getString(1);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)connection);
        }
        if (schemeId == null) {
            schemeId = totalFormInfo.getBgScheme().getId().toString();
        }
        IBgType iBgType = BgTypeFactory.getLocalInstance(ctx);
        BgTypeInfo typeInfo = iBgType.getBgTypeInfo("select name, number where id = '" + totalFormInfo.getBgType().getId().toString() + "'");
        String number = subOrgInfo.getNumber() + "_" + typeInfo.getNumber() + "_" + BgHelper.getTimeString();
        String name = subOrgInfo.getName() + "_" + typeInfo.getName() + "_" + BgHelper.getTimeString();
        String bgFormId = this.addnew_insertBgForm(ctx, name, number, schemeId, templateId, typeId, subOrgInfo.getId().toString(), true);
        ITableManagerFacade mang = TableManagerFacadeFactory.getLocalInstance((Context)ctx);
        String tmpPeriodTable = mang.getTableName("bg");
        try {
            this.addnew_createTmpTable(ctx, tmpPeriodTable);
            this.addnew_insertTmpPeriodTable(ctx, tmpPeriodTable, schemeId, bgCycle, subOrgInfo.getId().toString());
            this.addnew_insertBgEntry(ctx, bgFormId, tmpPeriodTable, templateId);
            this.addnew_insertBgData(ctx, bgFormId, templateId, tmpPeriodTable);
            this.distribute_updateSubBgForm(ctx, totalFormInfo.getId().toString(), bgFormId, scale, tmpBgDataTable);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            this.dropTmpTable(ctx, tmpPeriodTable);
        }
    }

    private void distribute_updateSubBgForm(Context ctx, String totalFormId, String subFormId, BigDecimal scale, String tmpBgDataTable) throws BOSException, EASBizException {
        Connection connection = null;
        PreparedStatement ps = null;
        StringBuffer sbSql = new StringBuffer(" update t_bg_bgdata ");
        sbSql.append(" set FBgValue = (select FBgValue * ? from ");
        sbSql.append(tmpBgDataTable);
        sbSql.append(" where FIdentity=t_bg_bgdata.FIdentity) ");
        sbSql.append(" where fid in (select a.fid from t_bg_bgdata a,t_bg_bgelement b,t_bg_bgentry c ");
        sbSql.append("where a.fbgelementid=b.fid and a.fbgentryid=c.fid and c.fbgformid= ? and b.FApportionable=1 )");
        try {
            connection = this.getConnection(ctx);
            ps = connection.prepareStatement(sbSql.toString());
            ps.setBigDecimal(1, scale);
            ps.setString(2, subFormId);
            ps.execute();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)connection);
        Connection connectionN = null;
        PreparedStatement psN = null;
        StringBuffer sbSqlN = new StringBuffer(" update t_bg_bgdata ");
        sbSqlN.append(" set FBgValue = (select FBgValue from ");
        sbSqlN.append(tmpBgDataTable);
        sbSqlN.append(" where FIdentity=t_bg_bgdata.FIdentity) ");
        sbSqlN.append(" where fid in (select a.fid from t_bg_bgdata a,t_bg_bgelement b,t_bg_bgentry c ");
        sbSqlN.append("where a.fbgelementid=b.fid and a.fbgentryid=c.fid and c.fbgformid= ? and b.FApportionable!=1 )");
        try {
            connectionN = this.getConnection(ctx);
            psN = connectionN.prepareStatement(sbSqlN.toString());
            psN.setString(1, subFormId);
            psN.execute();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(psN, (Connection)connectionN);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)psN, (Connection)connectionN);
    }

    private BgFormInfo distribute_matchSubBgForm(Context ctx, BgFormInfo totalFormInfo, OrgUnitInfo subOrgInfo) throws BOSException, EASBizException {
        BgFormInfo subFormInfo = null;
        ResultSet rs = null;
        Connection connection = null;
        PreparedStatement ps = null;
        String sql = "select FID from T_BG_BgForm where FSTATE in (1,2,3,4,6,7,8,9,10,11,13,14) and FBgTypeId = ?  and FOrgUnitID = ?  and FBgSchemeID = ? ";
        try {
            String fid;
            connection = this.getConnection(ctx);
            ps = connection.prepareStatement(sql);
            ps.setString(1, totalFormInfo.getBgType().getId().toString());
            ps.setString(2, subOrgInfo.getId().toString());
            ps.setString(3, totalFormInfo.getBgScheme().getId().toString());
            rs = ps.executeQuery();
            if (rs.next() && (fid = rs.getString("FID")) != null && fid.trim().length() > 0) {
                subFormInfo = new BgFormInfo();
                subFormInfo.setId(BOSUuid.read((String)fid));
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)connection);
        return subFormInfo;
    }

    private BgFormInfo distribute_getTotalBgForm(Context ctx, String bgFormId) throws BOSException, EASBizException {
        BgFormInfo formInfo = new BgFormInfo();
        formInfo.setId(BOSUuid.read((String)bgFormId));
        ResultSet rs = null;
        Connection connection = null;
        PreparedStatement ps = null;
        String sql = "select form.FBgTemplateID, form.FBgSchemeID, form.FBgTypeID, template.FBgCycle from T_BG_BgForm as form, T_BG_BgTemplate as template where form.fid=? and form.FBgTemplateID=template.FID ";
        try {
            connection = this.getConnection(ctx);
            ps = connection.prepareStatement(sql);
            ps.setString(1, bgFormId);
            rs = ps.executeQuery();
            if (rs.next()) {
                String templateId = rs.getString("FBgTemplateID");
                String schemeId = rs.getString("FBgSchemeID");
                String typeId = rs.getString("FBgTypeID");
                int bgCycle = rs.getInt("FBgCycle");
                BgTemplateInfo templateInfo = new BgTemplateInfo();
                templateInfo.setId(BOSUuid.read((String)templateId));
                templateInfo.setBgCycle(BgCycleTypeEnum.getEnum(bgCycle));
                formInfo.setBgTemplate(templateInfo);
                BgSchemeInfo schemeInfo = new BgSchemeInfo();
                schemeInfo.setId(BOSUuid.read((String)schemeId));
                formInfo.setBgScheme(schemeInfo);
                BgTypeInfo typeInfo = new BgTypeInfo();
                typeInfo.setId(BOSUuid.read((String)typeId));
                formInfo.setBgType(typeInfo);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)connection);
        return formInfo;
    }

    @Override
    protected void _deleteBgForm(Context ctx, String bgFormId) throws BOSException, EASBizException {
        SimpleTimer timer = new SimpleTimer();
        String delBgVersion = "delete from t_bg_bgversion  where FOriginalBgFormID = ? OR FAdaptedBgFormID = ? OR FPreBgFormID = ?";
        String delPastRecode = " DELETE FROM T_BG_BgPastData WHERE (FBgPastRecordID IN( SELECT fid FROM T_BG_BgPastRecord WHERE fbgformid = ?))";
        String delPastData = " DELETE FROM T_BG_BgPastRecord WHERE (FBgFormID = ?)";
        String delBgDataSql = " DELETE FROM T_BG_BgData  WHERE (FBgEntryID IN ( SELECT fid FROM t_bg_bgentry WHERE fbgformid = ?))";
        String delBgEntrySql = " DELETE FROM T_BG_BgEntry WHERE (FBgFormID = ?)";
        String delBgFormLogSql = " DELETE FROM t_bg_bgformlog WHERE (FBgFormID = ?)";
        String delBgPostilSql = " DELETE FROM T_BG_BgPostil WHERE (FBgFormID = ?)";
        String delBgKDSSql = "delete from t_bg_bgkds where fbgformid = ?";
        String delBgFormSql = " DELETE FROM T_BG_BgForm WHERE (FID = ?)";
        String noCheckSql = "";
        String checkSql = "";
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.getConnection(ctx);
            String id = bgFormId;
            stmt = conn.prepareStatement(delBgVersion);
            stmt.setString(1, id.toString());
            stmt.setString(2, id.toString());
            stmt.setString(3, id.toString());
            stmt.executeUpdate();
            System.out.println("--------------------------------delete BgForm 1 BgVersion: " + timer.getTime());
            stmt = conn.prepareStatement(delPastRecode);
            stmt.setString(1, id);
            stmt.executeUpdate();
            System.out.println("--------------------------------delete BgForm 2 PastData: " + timer.getTime());
            stmt = conn.prepareStatement(delPastData);
            stmt.setString(1, id);
            stmt.executeUpdate();
            System.out.println("--------------------------------delete BgForm 3 PastRecord: " + timer.getTime());
            if (KSqlUtil.getDbType((Connection)conn) == 3) {
                noCheckSql = "/*dialect*/ ALTER TABLE T_Bg_BgCtrlDetailEntry NOCHECK CONSTRAINT FK_BG_CtrDE_bgData ";
                stmt = conn.prepareStatement(noCheckSql);
                stmt.executeUpdate();
                noCheckSql = "/*dialect*/ ALTER TABLE T_BG_BgIncreaseReqFormEntry NOCHECK CONSTRAINT FK_BG_IncE_bgData ";
                stmt = conn.prepareStatement(noCheckSql);
                stmt.executeUpdate();
                noCheckSql = "/*dialect*/ ALTER TABLE T_BG_BgPastData NOCHECK CONSTRAINT FK_BG_BPD_BDT";
                stmt = conn.prepareStatement(noCheckSql);
                stmt.executeUpdate();
            } else if (KSqlUtil.getDbType((Connection)conn) == 2 || KSqlUtil.getDbType((Connection)conn) == 7) {
                noCheckSql = "/*dialect*/ ALTER TABLE T_Bg_BgCtrlDetailEntry DISABLE CONSTRAINT FK_BG_CtrDE_bgData ";
                stmt = conn.prepareStatement(noCheckSql);
                stmt.executeUpdate();
                noCheckSql = "/*dialect*/ ALTER TABLE T_BG_BgIncreaseReqFormEntry DISABLE CONSTRAINT FK_BG_IncE_bgData ";
                stmt = conn.prepareStatement(noCheckSql);
                stmt.executeUpdate();
                noCheckSql = "/*dialect*/ ALTER TABLE T_BG_BgPastData DISABLE CONSTRAINT FK_BG_BPD_BDT";
                stmt = conn.prepareStatement(noCheckSql);
                stmt.executeUpdate();
            }
            stmt = conn.prepareStatement(delBgDataSql);
            stmt.setString(1, id);
            stmt.executeUpdate();
            if (KSqlUtil.getDbType((Connection)conn) == 3) {
                checkSql = "/*dialect*/ ALTER TABLE T_Bg_BgCtrlDetailEntry CHECK CONSTRAINT FK_BG_CtrDE_bgData ";
                stmt = conn.prepareStatement(checkSql);
                stmt.executeUpdate();
                checkSql = "/*dialect*/ ALTER TABLE T_BG_BgIncreaseReqFormEntry CHECK CONSTRAINT FK_BG_IncE_bgData ";
                stmt = conn.prepareStatement(checkSql);
                stmt.executeUpdate();
                checkSql = "/*dialect*/ ALTER TABLE T_BG_BgPastData CHECK CONSTRAINT FK_BG_BPD_BDT";
                stmt = conn.prepareStatement(checkSql);
                stmt.executeUpdate();
            } else if (KSqlUtil.getDbType((Connection)conn) == 2 || KSqlUtil.getDbType((Connection)conn) == 7) {
                noCheckSql = "/*dialect*/ ALTER TABLE T_Bg_BgCtrlDetailEntry ENABLE CONSTRAINT FK_BG_CtrDE_bgData ";
                stmt = conn.prepareStatement(noCheckSql);
                stmt.executeUpdate();
                noCheckSql = "/*dialect*/ ALTER TABLE T_BG_BgIncreaseReqFormEntry ENABLE CONSTRAINT FK_BG_IncE_bgData ";
                stmt = conn.prepareStatement(noCheckSql);
                stmt.executeUpdate();
                noCheckSql = "/*dialect*/ ALTER TABLE T_BG_BgPastData ENABLE CONSTRAINT FK_BG_BPD_BDT";
                stmt = conn.prepareStatement(noCheckSql);
                stmt.executeUpdate();
            }
            System.out.println("--------------------------------delete BgForm 4 BgData: " + timer.getTime());
            stmt = conn.prepareStatement(delBgEntrySql);
            stmt.setString(1, id);
            stmt.executeUpdate();
            System.out.println("--------------------------------delete BgForm 5 BgEntry: " + timer.getTime());
            stmt = conn.prepareStatement(delBgFormLogSql);
            stmt.setString(1, id);
            stmt.executeUpdate();
            System.out.println("--------------------------------delete BgForm 6 BgFormLog: " + timer.getTime());
            stmt = conn.prepareStatement(delBgPostilSql);
            stmt.setString(1, id);
            stmt.executeUpdate();
            System.out.println("--------------------------------delete BgForm 7 BgPostil: " + timer.getTime());
            stmt = conn.prepareStatement(delBgKDSSql);
            stmt.setString(1, id);
            stmt.executeUpdate();
            System.out.println("--------------------------------delete BgForm 8 BgKDS: " + timer.getTime());
            stmt = conn.prepareStatement(delBgFormSql);
            stmt.setString(1, id);
            stmt.executeUpdate();
            System.out.println("--------------------------------delete BgForm 9 BgFormHead: " + timer.getTime());
        }
        catch (SQLException e) {
            try {
                ObjectUuidPK pk = new ObjectUuidPK(bgFormId);
                throw new BgORMException(BgORMException.DELETEENTITY, e, new Object[]{pk});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        System.out.println("--------------------------------delete BgForm: " + timer.getTime());
    }

    @Override
    protected void _declareBgForm(Context ctx, String bgFormId, ArrayList subBgFormIdList) throws BOSException, EASBizException {
        SimpleTimer timer = new SimpleTimer();
        ITableManagerFacade mang = TableManagerFacadeFactory.getLocalInstance((Context)ctx);
        String tmpBgDataTable = mang.getTableName("bg");
        try {
            this.declare_prepareTmpBgDataTable(ctx, tmpBgDataTable, subBgFormIdList);
            this.declare_updateTotalBgFormWithRecord(ctx, tmpBgDataTable, bgFormId);
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            this.dropTmpTable(ctx, tmpBgDataTable);
        }
        System.out.println("--------------------------------declare BgForm: " + timer.getTime());
    }

    private void declare_updateTotalBgFormWithRecord(Context ctx, String tmpBgDataTable, String bgFormId) throws BOSException, EASBizException {
        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String sql = "";
        StringBuffer sbSql = null;
        String pastRecordId = "";
        try {
            connection = this.getConnection(ctx);
            UserInfo userInfo = new UserInfo();
            userInfo.setId(BOSUuid.read((String)ctx.getCaller().toString()));
            BgFormInfo formInfo = new BgFormInfo();
            formInfo.setId(BOSUuid.read((String)bgFormId));
            BgFormLogHelper.addNewBgFormLog(ctx, formInfo, BgOperationEnum.Gather, userInfo);
            sql = "update t_bg_bgform set FDataSource=?, FHasEffected=?, FState=? where FID=?";
            ps = connection.prepareStatement(sql);
            ps.setInt(1, 1);
            ps.setBoolean(2, true);
            ps.setInt(3, 1);
            ps.setString(4, bgFormId);
            ps.execute();
            int seq = -1;
            sql = "select count(fid) from T_BG_BgPastRecord where FBgFormID=?";
            ps = connection.prepareStatement(sql);
            ps.setString(1, bgFormId);
            rs = ps.executeQuery();
            if (rs.next()) {
                seq = rs.getInt(1);
            }
            sql = "insert into T_BG_BgPastRecord (FID, FSeq, FModifyDate, FBgFormID, FModifierID) values (?,?,?,?,?)";
            ps = connection.prepareStatement(sql);
            pastRecordId = BOSUuid.create((BOSObjectType)new BgPastRecordInfo().getBOSType()).toString();
            ps.setString(1, pastRecordId);
            ps.setInt(2, ++seq);
            Date date = new Date();
            long time = date.getTime();
            Calendar d = Calendar.getInstance();
            d.setTime(new Timestamp(time));
            d.set(14, 0);
            Timestamp modifyTime = new Timestamp(d.getTime().getTime());
            ps.setTimestamp(3, modifyTime);
            ps.setString(4, bgFormId);
            ps.setString(5, ctx.getCaller().toString());
            ps.execute();
            String bosType = new BgPastDataInfo().getBOSType().toString();
            sbSql = new StringBuffer("insert into T_BG_BgPastData (FID, FPastValue, FBalance, FBgDataID, FBgPastRecordID, FDataSource) ");
            sbSql.append(" select NEWID() || '");
            sbSql.append(bosType);
            sbSql.append("' as FID, data.FBgValue as FPastValue, ( tmp.FBgValue ");
            sbSql.append(" - data.FBgValue ) as FBalance, data.FID as FBgDataID, '");
            sbSql.append(pastRecordId);
            sbSql.append("' as FBgPastRecordID, 1 as FDataSource ");
            sbSql.append("from t_bg_bgdata as data, ");
            sbSql.append(tmpBgDataTable);
            sbSql.append(" as tmp ");
            sbSql.append(" where data.FBgEntryID in (select FID from t_bg_bgentry where FBgFormID='");
            sbSql.append(bgFormId);
            sbSql.append("') and data.FIdentity = tmp.FIdentity and (tmp.FBgValue ");
            sbSql.append(" - data.FBgValue ) <> 0");
            sql = sbSql.toString();
            ps = connection.prepareStatement(sql);
            ps.execute();
            this.declare_updateTotalBgForm(ctx, bgFormId, tmpBgDataTable);
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)connection);
    }

    private void declare_updateTotalBgForm(Context ctx, String bgFormId, String tmpBgDataTable) throws BOSException, EASBizException {
        Connection connection = null;
        PreparedStatement ps = null;
        StringBuffer sbSql = new StringBuffer(" update t_bg_bgdata ");
        sbSql.append(" set FBgValue = isnull( (select FBgValue from ");
        sbSql.append(tmpBgDataTable);
        sbSql.append(" where FIdentity=t_bg_bgdata.FIdentity), t_bg_bgdata.FBgValue ) ");
        sbSql.append(" where FBgEntryID in (select FID from t_bg_bgentry where FBgFormID=?) ");
        try {
            connection = this.getConnection(ctx);
            ps = connection.prepareStatement(sbSql.toString());
            ps.setString(1, bgFormId);
            ps.execute();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)connection);
    }

    private void declare_prepareTmpBgDataTable(Context ctx, String tmpBgDataTable, ArrayList subBgFormIdList) throws BOSException, EASBizException {
        Connection connection = null;
        PreparedStatement ps = null;
        try {
            StringBuffer sbCreate = new StringBuffer("create table ");
            sbCreate.append(tmpBgDataTable);
            sbCreate.append(" (FBgValue decimal (28, 10), FIdentity varchar (255)) ");
            String sql = sbCreate.toString();
            connection = this.getConnection(ctx);
            ps = connection.prepareStatement(sql);
            ps.execute();
            sbCreate = new StringBuffer("create index IX_");
            sbCreate.append(tmpBgDataTable);
            sbCreate.append(" on ");
            sbCreate.append(tmpBgDataTable);
            sbCreate.append(" (FIdentity) ");
            sql = sbCreate.toString();
            ps = connection.prepareStatement(sql);
            ps.execute();
            sbCreate = new StringBuffer("insert into ");
            sbCreate.append(tmpBgDataTable);
            sbCreate.append(" (FBgValue, FIdentity) ");
            sbCreate.append(" select sum(FBgValue) as FBgValue, FIdentity from t_bg_bgdata where FBgEntryID in ");
            sbCreate.append(" ( select FID from t_bg_bgentry where FBgFormID in ( ");
            Object[] vecId = subBgFormIdList.toArray();
            for (int i = 0; i < vecId.length; ++i) {
                if (i > 0) {
                    sbCreate.append(" , ");
                }
                sbCreate.append("'");
                sbCreate.append(vecId[i]);
                sbCreate.append("'");
            }
            sbCreate.append(" ) ) ");
            sbCreate.append(" group by FIdentity");
            sql = sbCreate.toString();
            ps = connection.prepareStatement(sql);
            ps.execute();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)connection);
    }

    @Override
    protected String _addnewAdjustingBgForm(Context ctx, String sourceBgFormId) throws BOSException, EASBizException {
        SimpleTimer timer = new SimpleTimer();
        String destBgFormId = BOSUuid.create((BOSObjectType)new BgFormInfo().getBOSType()).toString();
        ITableManagerFacade mang = TableManagerFacadeFactory.getLocalInstance((Context)ctx);
        String tmpEntryTable = mang.getTableName("bg");
        try {
            this.adjust_prepareTmpBgEntryTable(ctx, tmpEntryTable, sourceBgFormId);
            System.out.println("--------------------------------addnew Adjusting BgForm 1 prepareTmpBgEntryTable: " + timer.getTime());
            this.adjust_cloneBgForm(ctx, sourceBgFormId, destBgFormId);
            System.out.println("--------------------------------addnew Adjusting BgForm 2 cloneBgForm: " + timer.getTime());
            this.adjust_cloneBgEntry(ctx, sourceBgFormId, destBgFormId, tmpEntryTable);
            System.out.println("--------------------------------addnew Adjusting BgForm 3 cloneBgEntry: " + timer.getTime());
            this.adjust_cloneBgData(ctx, sourceBgFormId, destBgFormId, tmpEntryTable);
            System.out.println("--------------------------------addnew Adjusting BgForm 4 cloneBgData: " + timer.getTime());
            this.adjust_registerVersion(ctx, sourceBgFormId, destBgFormId);
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            this.dropTmpTable(ctx, tmpEntryTable);
        }
        System.out.println("--------------------------------addnew Adjusting BgForm: " + timer.getTime());
        return destBgFormId;
    }

    private void adjust_registerVersion(Context ctx, String sourceBgFormId, String destBgFormId) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection(ctx);
            String orginalFormId = null;
            String querySql = "select FOriginalBgFormId,FAdaptedBgFormId,FPreBgFormId from T_BG_BgVersion where FAdaptedBgFormId = ? ";
            stmt = conn.prepareStatement(querySql);
            stmt.setString(1, BOSUuid.read((String)sourceBgFormId).toString());
            rs = stmt.executeQuery();
            if (rs.next()) {
                orginalFormId = rs.getString(1);
            }
            String insertSql = "insert into T_BG_BgVersion(FID,FOriginalBgFormId,FAdaptedBgFormId,FPreBgFormId) values(?,?,?,?)";
            stmt = conn.prepareStatement(insertSql);
            stmt.setString(1, BOSUuid.create((BOSObjectType)new BgVersionInfo().getBOSType()).toString());
            stmt.setString(2, orginalFormId == null ? sourceBgFormId : orginalFormId);
            stmt.setString(3, destBgFormId);
            stmt.setString(4, sourceBgFormId);
            stmt.execute();
        }
        catch (SQLException e) {
            try {
                throw new BgInstantApproveException(BgInstantApproveException.DATABASEERROR, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
    }

    private String adjust_generateBgFormNumber(Context ctx, String sourceBgFormId) throws BOSException, EASBizException {
        PreparedStatement ps;
        Connection connection;
        ResultSet rs;
        String number;
        block6: {
            number = "";
            rs = null;
            connection = null;
            ps = null;
            String sql = "select fnumber from T_BG_BgForm where fid=? ";
            try {
                connection = this.getConnection(ctx);
                ps = connection.prepareStatement(sql);
                ps.setString(1, BOSUuid.read((String)sourceBgFormId).toString());
                rs = ps.executeQuery();
                if (rs.next()) {
                    number = rs.getString("fnumber");
                }
                if (number.indexOf("V1.") == -1) {
                    number = number + "V1.1";
                    break block6;
                }
                String[] result = number.split("V1.");
                int index = Integer.parseInt(result[1]);
                number = result[0] + "V1." + (index + 1);
            }
            catch (SQLException e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, ps, (Connection)connection);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)connection);
        return number;
    }

    private void adjust_cloneBgData(Context ctx, String sourceBgFormId, String destBgFormId, String tmpEntryTable) throws BOSException, EASBizException {
        StringBuffer sbInsert = new StringBuffer();
        String bosType = new BgDataInfo().getBOSType().toString();
        sbInsert.append(" INSERT INTO T_BG_BgData ");
        sbInsert.append("(FID, FDataType, FBgValue, FElementNumber, FBgCtrlType, FIsFlexibleCtrl, FFlexibleBgCtrlParam, FCurrencyID, FBgElementID, FBgEntryID, FIdentity) ");
        sbInsert.append(" select NewID() || '");
        sbInsert.append(bosType);
        sbInsert.append("' as FID, d.FDataType, d.FBgValue, d.FElementNumber, d.FBgCtrlType, d.FIsFlexibleCtrl, d.FFlexibleBgCtrlParam, d.FCurrencyID, d.FBgElementID, t.FIDNew, d.FIdentity ");
        sbInsert.append(" from t_bg_bgdata as d, ");
        sbInsert.append(tmpEntryTable);
        sbInsert.append(" as t where d.FBgEntryID=t.FID ");
        String sql = sbInsert.toString();
        Connection connection = null;
        PreparedStatement ps = null;
        try {
            connection = this.getConnection(ctx);
            ps = connection.prepareStatement(sql);
            ps.execute();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)connection);
    }

    private void adjust_cloneBgEntry(Context ctx, String sourceBgFormId, String destBgFormId, String tmpEntryTable) throws BOSException, EASBizException {
        StringBuffer sbInsert = new StringBuffer();
        sbInsert.append(" INSERT INTO T_BG_BgEntry ");
        sbInsert.append("(FID, FSeq, FBgCycle, FPeriodID, FBgItem1ID, FBgItem2ID, FBgItem3ID, FBgItem4ID, FBgItem5ID, FBgItem6ID, ");
        sbInsert.append(" FBgFormID, FIsInitialized, FIsLeafPeriod, FIsLeafEntry, FBgItemsKey, FEntryType, FSplitRate) ");
        sbInsert.append(" select t.FIDNew, e.FSeq, e.FBgCycle, e.FPeriodID, e.FBgItem1ID, e.FBgItem2ID, e.FBgItem3ID, e.FBgItem4ID, e.FBgItem5ID, e.FBgItem6ID, '");
        sbInsert.append(destBgFormId);
        sbInsert.append("' as FBgFormID, e.FIsInitialized, e.FIsLeafPeriod, e.FIsLeafEntry, e.FBgItemsKey, e.FEntryType, e.FSplitRate ");
        sbInsert.append(" from t_bg_bgentry as e, ");
        sbInsert.append(tmpEntryTable);
        sbInsert.append(" as t where e.FID=t.FID");
        String sql = sbInsert.toString();
        Connection connection = null;
        PreparedStatement ps = null;
        try {
            connection = this.getConnection(ctx);
            ps = connection.prepareStatement(sql);
            ps.execute();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)connection);
    }

    private void adjust_cloneBgForm(Context ctx, String sourceBgFormId, String destBgFormId) throws BOSException, EASBizException {
        StringBuffer sbInsert = new StringBuffer();
        sbInsert.append(" insert into t_bg_bgform (FID, FNumber, FName, FState, FCreatorID, FCreateTime, ");
        sbInsert.append(" FLastUpdateUserID, FLastUpdateTime, FHasEffected, FCompanyID, FBgTemplateID, ");
        sbInsert.append(" FBgSchemeID, FBgTypeID, FPeriodFromID, FPeriodToID, FOrgUnitID, FDataSource, FControlUnitID) ");
        sbInsert.append(" select ?, ?, FName, 4, ?, ?, ");
        sbInsert.append(" ?, ?, 1, FCompanyID, FBgTemplateID, ");
        sbInsert.append(" FBgSchemeID, FBgTypeID, FPeriodFromID, FPeriodToID, FOrgUnitID, 0, FControlUnitID ");
        sbInsert.append(" from t_bg_bgform where fid=?");
        String sql = sbInsert.toString();
        Connection connection = null;
        PreparedStatement ps = null;
        try {
            connection = this.getConnection(ctx);
            ps = connection.prepareStatement(sql);
            ps.setString(1, destBgFormId);
            String number = this.adjust_generateBgFormNumber(ctx, sourceBgFormId);
            ps.setString(2, number);
            ps.setString(3, ctx.getCaller().toString());
            Date date = new Date();
            long time = date.getTime();
            Calendar d = Calendar.getInstance();
            d.setTime(new Timestamp(time));
            d.set(14, 0);
            Timestamp createtime = new Timestamp(d.getTime().getTime());
            ps.setTimestamp(4, createtime);
            ps.setString(5, ctx.getCaller().toString());
            ps.setTimestamp(6, createtime);
            ps.setString(7, sourceBgFormId);
            ps.execute();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)connection);
    }

    private void adjust_prepareTmpBgEntryTable(Context ctx, String tmpEntryTable, String sourceBgFormId) throws BOSException, EASBizException {
        Connection connection = null;
        PreparedStatement ps = null;
        String bosType = new BgEntryInfo().getBOSType().toString();
        try {
            StringBuffer sbCreate = new StringBuffer("create table ");
            sbCreate.append(tmpEntryTable);
            sbCreate.append(" (FID varchar (44), FIDNew varchar (44)) ");
            String sql = sbCreate.toString();
            connection = this.getConnection(ctx);
            ps = connection.prepareStatement(sql);
            ps.execute();
            sbCreate = new StringBuffer("create index IX_");
            sbCreate.append(tmpEntryTable);
            sbCreate.append(" on ");
            sbCreate.append(tmpEntryTable);
            sbCreate.append(" (FID) ");
            sql = sbCreate.toString();
            ps = connection.prepareStatement(sql);
            ps.execute();
            sbCreate = new StringBuffer("insert into ");
            sbCreate.append(tmpEntryTable);
            sbCreate.append(" (FID, FIDNew) ");
            sbCreate.append(" select FID, NewID() || '");
            sbCreate.append(bosType);
            sbCreate.append("' as FIDNew from t_bg_bgentry where FBgFormID=? ");
            sql = sbCreate.toString();
            ps = connection.prepareStatement(sql);
            ps.setString(1, sourceBgFormId);
            ps.execute();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)connection);
    }

    @Override
    protected String _approveAdjustingBgForm(Context ctx, String destBgFormId) throws BOSException, EASBizException {
        SimpleTimer timer = new SimpleTimer();
        String sourceBgFormId = null;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String sql = "select FOriginalBgFormID from T_BG_BgVersion where FAdaptedBgFormId=?";
        try {
            con = this.getConnection(ctx);
            stmt = con.prepareStatement(sql);
            stmt.setString(1, BOSUuid.read((String)destBgFormId).toString());
            rs = stmt.executeQuery();
            if (!rs.next()) {
                throw new BgInstantApproveException(BgInstantApproveException.EXISTBGFORM);
            }
            sourceBgFormId = rs.getString(1);
        }
        catch (SQLException e) {
            try {
                throw new BgInstantApproveException(BgInstantApproveException.DATABASEERROR, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        System.out.println("--------------------------------approve Adjusting BgForm 1 search sourceBgForm: " + timer.getTime());
        String tmpDataTableSource = this.getTempTableName();
        String tmpDataTableDest = this.getTempTableName();
        String tmpEntryIdTable = this.getTempTableName();
        try {
            this.adjust_prepareTmpBgDataTable(ctx, sourceBgFormId, tmpDataTableSource);
            this.adjust_prepareTmpBgDataTable(ctx, destBgFormId, tmpDataTableDest);
            System.out.println("--------------------------------approve Adjusting BgForm 2 prepareTmpBgDataTable: " + timer.getTime());
            this.adjust_updateSourceBgFormWithRecord(ctx, sourceBgFormId, tmpDataTableDest);
            this.adjust_updateDestBgForm(ctx, destBgFormId, tmpDataTableSource);
            System.out.println("--------------------------------approve Adjusting BgForm 3 updateBgData: " + timer.getTime());
            this.adjust_cutBgEntryWithRecord(ctx, sourceBgFormId, destBgFormId, tmpEntryIdTable);
            System.out.println("--------------------------------approve Adjusting BgForm 4 cutBgEntryWithRecord: " + timer.getTime());
            this.adjust_swapBgForm(ctx, sourceBgFormId, destBgFormId);
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            this.dropTempTable(ctx, tmpDataTableSource);
            this.dropTempTable(ctx, tmpDataTableDest);
            this.dropTempTable(ctx, tmpEntryIdTable);
        }
        System.out.println("--------------------------------approve Adjusting BgForm: " + timer.getTime());
        return sourceBgFormId;
    }

    private void dropTempTable(Context ctx, String tmpTable) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement stmt = null;
        String sql = "drop table " + tmpTable;
        try {
            conn = this.getConnection(ctx);
            stmt = conn.prepareStatement(sql);
            stmt.execute();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
    }

    private String getTempTableName() {
        String tableName = "T_BG_";
        String uuid = Uuid.create().toString();
        tableName = tableName + uuid.substring(0, 8) + uuid.substring(24);
        return tableName;
    }

    private void adjust_swapBgForm(Context ctx, String sourceBgFormId, String destBgFormId) throws BOSException, EASBizException {
        String sql1 = "select fnumber,fcreatorid,flastupdateuserid,fcreatetime from t_bg_bgform where fid=?";
        String sql2 = "update t_bg_bgform set fnumber=? where fid=?";
        String sql3 = "update t_bg_bgform set fcreatorid=?,flastupdateuserid=?,fcreatetime=?, fstate=? where fid=?";
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String number = "";
        String creatorId = "";
        String lastUserId = "";
        Timestamp createTime = null;
        String oriNumber = "";
        String oriCreatorId = "";
        String oriLastUserId = "";
        Timestamp oriCreateTime = null;
        try {
            conn = this.getConnection(ctx);
            stmt = conn.prepareStatement(sql1);
            stmt.setString(1, BOSUuid.read((String)destBgFormId).toString());
            rs = stmt.executeQuery();
            if (rs.next()) {
                number = rs.getString(1);
                creatorId = rs.getString(2);
                lastUserId = rs.getString(3);
                createTime = rs.getTimestamp(4);
            }
            stmt = conn.prepareStatement(sql1);
            stmt.setString(1, BOSUuid.read((String)sourceBgFormId).toString());
            rs = stmt.executeQuery();
            if (rs.next()) {
                oriNumber = rs.getString(1);
                oriCreatorId = rs.getString(2);
                oriLastUserId = rs.getString(3);
                oriCreateTime = rs.getTimestamp(4);
            }
            stmt = conn.prepareStatement(sql2);
            stmt.setString(1, number + "!@@##$%");
            stmt.setString(2, destBgFormId);
            stmt.executeUpdate();
            stmt = conn.prepareStatement(sql2);
            stmt.setString(1, number);
            stmt.setString(2, sourceBgFormId);
            stmt.executeUpdate();
            stmt = conn.prepareStatement(sql2);
            stmt.setString(1, oriNumber);
            stmt.setString(2, destBgFormId);
            stmt.executeUpdate();
            stmt = conn.prepareStatement(sql3);
            stmt.setString(1, oriCreatorId);
            stmt.setString(2, oriLastUserId);
            stmt.setTimestamp(3, oriCreateTime);
            stmt.setInt(4, 5);
            stmt.setString(5, destBgFormId);
            stmt.executeUpdate();
            stmt = conn.prepareStatement(sql3);
            stmt.setString(1, creatorId);
            stmt.setString(2, lastUserId);
            stmt.setTimestamp(3, createTime);
            stmt.setInt(4, 2);
            stmt.setString(5, sourceBgFormId);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                throw new BgInstantApproveException(BgInstantApproveException.DATABASEERROR, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
    }

    private void adjust_cutBgEntryWithRecord(Context ctx, String sourceBgFormId, String destBgFormId, String tmpEntryIdTable) throws BOSException, EASBizException {
        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String sql = "";
        StringBuffer sbSql = null;
        String pastRecordId = "";
        try {
            connection = this.getConnection(ctx);
            StringBuffer sbCreate = new StringBuffer("create table ");
            sbCreate.append(tmpEntryIdTable);
            sbCreate.append(" (FID varchar (44)) ");
            sql = sbCreate.toString();
            ps = connection.prepareStatement(sql);
            ps.execute();
            sbCreate = new StringBuffer("insert into ");
            sbCreate.append(tmpEntryIdTable);
            sbCreate.append(" (FID) ");
            sbCreate.append(" select FID from t_bg_bgentry where FBgFormID=? and FEntryType=2 ");
            sql = sbCreate.toString();
            ps = connection.prepareStatement(sql);
            ps.setString(1, destBgFormId);
            ps.execute();
            sbSql = new StringBuffer();
            sbSql.append(" update t_bg_bgentry set FBgFormID=?, FEntryType=0 where FID in ( ");
            sbSql.append(" select FID from ");
            sbSql.append(tmpEntryIdTable);
            sbSql.append(" ) ");
            sql = sbSql.toString();
            ps = connection.prepareStatement(sql);
            ps.setString(1, sourceBgFormId);
            ps.execute();
            int seq = -1;
            sql = "select count(fid) from T_BG_BgPastRecord where FBgFormID=?";
            ps = connection.prepareStatement(sql);
            ps.setString(1, sourceBgFormId);
            rs = ps.executeQuery();
            if (rs.next()) {
                seq = rs.getInt(1);
            }
            sql = "insert into T_BG_BgPastRecord (FID, FSeq, FModifyDate, FBgFormID, FModifierID) values (?,?,?,?,?)";
            ps = connection.prepareStatement(sql);
            pastRecordId = BOSUuid.create((BOSObjectType)new BgPastRecordInfo().getBOSType()).toString();
            ps.setString(1, pastRecordId);
            ps.setInt(2, ++seq);
            Date date = new Date();
            long time = date.getTime();
            Calendar d = Calendar.getInstance();
            d.setTime(new Timestamp(time));
            d.set(14, 0);
            Timestamp modifyTime = new Timestamp(d.getTime().getTime());
            ps.setTimestamp(3, modifyTime);
            ps.setString(4, sourceBgFormId);
            ps.setString(5, ctx.getCaller().toString());
            ps.execute();
            String bosType = new BgPastDataInfo().getBOSType().toString();
            sbSql = new StringBuffer("insert into T_BG_BgPastData (FID, FPastValue, FBalance, FBgDataID, FBgPastRecordID, FDataSource) ");
            sbSql.append(" select NEWID() || '");
            sbSql.append(bosType);
            sbSql.append("' as FID, 0 as FPastValue, FBgValue as FBalance, FID as FBgDataID, '");
            sbSql.append(pastRecordId);
            sbSql.append("' as FBgPastRecordID, 2 as FDataSource ");
            sbSql.append(" from t_bg_bgdata ");
            sbSql.append(" where FBgEntryID in ( select FID from ");
            sbSql.append(tmpEntryIdTable);
            sbSql.append(" ) ");
            sql = sbSql.toString();
            ps = connection.prepareStatement(sql);
            ps.execute();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)connection);
    }

    private void adjust_updateDestBgForm(Context ctx, String bgFormId, String tmpBgDataTable) throws BOSException, EASBizException {
        Object connection = null;
        Object ps = null;
        String sql = "";
        Object sbSql = null;
        UserInfo userInfo = new UserInfo();
        userInfo.setId(BOSUuid.read((String)ctx.getCaller().toString()));
        BgFormInfo formInfo = new BgFormInfo();
        formInfo.setId(BOSUuid.read((String)bgFormId));
        BgFormLogHelper.addNewBgFormLog(ctx, formInfo, BgOperationEnum.Approve, userInfo);
        this.declare_updateTotalBgForm(ctx, bgFormId, tmpBgDataTable);
    }

    private void adjust_updateSourceBgFormWithRecord(Context ctx, String bgFormId, String tmpBgDataTable) throws BOSException, EASBizException {
        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String sql = "";
        StringBuffer sbSql = null;
        String pastRecordId = "";
        try {
            connection = this.getConnection(ctx);
            int seq = -1;
            sql = "select count(fid) from T_BG_BgPastRecord where FBgFormID=?";
            ps = connection.prepareStatement(sql);
            ps.setString(1, bgFormId);
            rs = ps.executeQuery();
            if (rs.next()) {
                seq = rs.getInt(1);
            }
            sql = "insert into T_BG_BgPastRecord (FID, FSeq, FModifyDate, FBgFormID, FModifierID) values (?,?,?,?,?)";
            ps = connection.prepareStatement(sql);
            pastRecordId = BOSUuid.create((BOSObjectType)new BgPastRecordInfo().getBOSType()).toString();
            ps.setString(1, pastRecordId);
            ps.setInt(2, ++seq);
            Date date = new Date();
            long time = date.getTime();
            Calendar d = Calendar.getInstance();
            d.setTime(new Timestamp(time));
            d.set(14, 0);
            Timestamp modifyTime = new Timestamp(d.getTime().getTime());
            ps.setTimestamp(3, modifyTime);
            ps.setString(4, bgFormId);
            ps.setString(5, ctx.getCaller().toString());
            ps.execute();
            String bosType = new BgPastDataInfo().getBOSType().toString();
            sbSql = new StringBuffer("insert into T_BG_BgPastData (FID, FPastValue, FBalance, FBgDataID, FBgPastRecordID, FDataSource) ");
            sbSql.append(" select NEWID() || '");
            sbSql.append(bosType);
            sbSql.append("' as FID, data.FBgValue as FPastValue, ( tmp.FBgValue ");
            sbSql.append(" - data.FBgValue ) as FBalance, data.FID as FBgDataID, '");
            sbSql.append(pastRecordId);
            sbSql.append("' as FBgPastRecordID, 2 as FDataSource ");
            sbSql.append("from t_bg_bgdata as data, ");
            sbSql.append(tmpBgDataTable);
            sbSql.append(" as tmp ");
            sbSql.append(" where data.FBgEntryID in (select FID from t_bg_bgentry where FBgFormID='");
            sbSql.append(bgFormId);
            sbSql.append("') and data.FIdentity = tmp.FIdentity and (tmp.FBgValue ");
            sbSql.append(" - data.FBgValue ) <> 0");
            sql = sbSql.toString();
            ps = connection.prepareStatement(sql);
            ps.execute();
            this.declare_updateTotalBgForm(ctx, bgFormId, tmpBgDataTable);
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)connection);
    }

    private void adjust_prepareTmpBgDataTable(Context ctx, String bgFormId, String tmpBgDataTable) throws BOSException, EASBizException {
        Connection connection = null;
        PreparedStatement ps = null;
        try {
            StringBuffer sbCreate = new StringBuffer("create table ");
            sbCreate.append(tmpBgDataTable);
            sbCreate.append(" (FBgValue decimal (28, 10), FIdentity varchar (255)) ");
            String sql = sbCreate.toString();
            connection = this.getConnection(ctx);
            ps = connection.prepareStatement(sql);
            ps.execute();
            sbCreate = new StringBuffer("create index IX_");
            sbCreate.append(tmpBgDataTable);
            sbCreate.append(" on ");
            sbCreate.append(tmpBgDataTable);
            sbCreate.append(" (FIdentity) ");
            sql = sbCreate.toString();
            ps = connection.prepareStatement(sql);
            ps.execute();
            sbCreate = new StringBuffer("insert into ");
            sbCreate.append(tmpBgDataTable);
            sbCreate.append(" (FBgValue, FIdentity) ");
            sbCreate.append(" select FBgValue, FIdentity from t_bg_bgdata where FBgEntryID in ");
            sbCreate.append("(select FID from t_bg_bgentry where FBgFormID=?) ");
            sql = sbCreate.toString();
            ps = connection.prepareStatement(sql);
            ps.setString(1, bgFormId);
            ps.execute();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)connection);
    }

    @Override
    protected String _addnewRollingBgForm(Context ctx, String sourceBgFormId) throws BOSException, EASBizException {
        SimpleTimer timer = new SimpleTimer();
        String destBgFormId = "";
        BgFormInfo sourceBgFormInfo = new BgFormInfo();
        ResultSet rs = null;
        Connection connection = null;
        PreparedStatement ps = null;
        String sql = "select form.FID, form.FBgTypeID, form.FBgTemplateID, template.FBgCycle, template.FRollingBgCycle, form.FBgRptTemplateID, form.FBgSchemeID, form.FPeriodFromID, form.FPeriodToID, form.FOrgUnitID from t_bg_bgform form, t_bg_bgtemplate template where form.FID=? and form.FBgTemplateID=template.FID";
        try {
            connection = this.getConnection(ctx);
            ps = connection.prepareStatement(sql);
            ps.setString(1, sourceBgFormId);
            rs = ps.executeQuery();
            if (rs.next()) {
                String rptTpId;
                sourceBgFormInfo.setId(BOSUuid.read((String)rs.getString(1)));
                BgTypeInfo typeInfo = new BgTypeInfo();
                sourceBgFormInfo.setBgType(typeInfo);
                typeInfo.setId(BOSUuid.read((String)rs.getString(2)));
                BgTemplateInfo templateInfo = new BgTemplateInfo();
                sourceBgFormInfo.setBgTemplate(templateInfo);
                templateInfo.setId(BOSUuid.read((String)rs.getString(3)));
                templateInfo.setBgCycle(BgCycleTypeEnum.getEnum(rs.getInt(4)));
                int rollingCycle = rs.getInt(5);
                if (rollingCycle >= 1) {
                    templateInfo.setRollingBgCycle(BgCycleTypeEnum.getEnum(rollingCycle));
                }
                if ((rptTpId = rs.getString(6)) != null) {
                    BgRptTemplateInfo rptTpInfo = new BgRptTemplateInfo();
                    sourceBgFormInfo.setBgRptTemplate(rptTpInfo);
                    rptTpInfo.setId(BOSUuid.read((String)rptTpId));
                }
                BgSchemeInfo schemeInfo = new BgSchemeInfo();
                sourceBgFormInfo.setBgScheme(schemeInfo);
                schemeInfo.setId(BOSUuid.read((String)rs.getString(7)));
                PeriodInfo fromInfo = new PeriodInfo();
                sourceBgFormInfo.setPeriodFrom(fromInfo);
                fromInfo.setId(BOSUuid.read((String)rs.getString(8)));
                PeriodInfo toInfo = new PeriodInfo();
                sourceBgFormInfo.setPeriodFrom(toInfo);
                toInfo.setId(BOSUuid.read((String)rs.getString(9)));
                FullOrgUnitInfo orgUnitInfo = new FullOrgUnitInfo();
                sourceBgFormInfo.setOrgUnit(orgUnitInfo);
                orgUnitInfo.setId(BOSUuid.read((String)rs.getString(10)));
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)connection);
        ITableManagerFacade mang = TableManagerFacadeFactory.getLocalInstance((Context)ctx);
        String tmpPeriodTable = mang.getTableName("bg");
        try {
            this.roll_prepareTmpTable(ctx, tmpPeriodTable, sourceBgFormInfo);
            destBgFormId = this._addnewAdjustingBgForm(ctx, sourceBgFormId);
            if (sourceBgFormInfo.getBgRptTemplate() == null) {
                this.roll_insertBgEntry(ctx, destBgFormId, tmpPeriodTable, sourceBgFormInfo.getBgTemplate().getId().toString());
                this.addnew_insertBgData(ctx, destBgFormId, sourceBgFormInfo.getBgTemplate().getId().toString(), tmpPeriodTable);
            } else {
                this.rollRpt_insertBgEntry(ctx, destBgFormId, tmpPeriodTable, sourceBgFormInfo.getBgTemplate().getId().toString(), sourceBgFormInfo.getBgRptTemplate().getId().toString());
                this.addnewRpt_insertBgData(ctx, destBgFormId, sourceBgFormInfo.getBgTemplate().getId().toString(), tmpPeriodTable, sourceBgFormInfo.getBgType().getId().toString());
            }
        }
        catch (EASBizException ex1) {
            throw ex1;
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            this.dropTmpTable(ctx, tmpPeriodTable);
        }
        System.out.println("--------------------------------addnew Rolling BgForm: " + timer.getTime());
        return destBgFormId;
    }

    private void rollRpt_insertBgEntry(Context ctx, String destBgFormId, String tmpPeriodTable, String bgTemplateId, String rptTpId) throws BOSException, EASBizException {
        BgEntryInfo tmpEntryInfo = new BgEntryInfo();
        String bosType = tmpEntryInfo.getBOSType().toString();
        StringBuffer sbInsert = new StringBuffer(" insert into t_bg_bgentry");
        sbInsert.append(" ( FID, FBgCycle, FPeriodID, FIsLeafPeriod, ");
        sbInsert.append(" FBgItem1ID, FBgFormID, FIsLeafEntry, FBgItemsKey, FEntryType ) ");
        sbInsert.append(" select newid() || '");
        sbInsert.append(bosType);
        sbInsert.append("' as FID, period.FBgCycle, period.FPeriodID, period.FIsLeafPeriod, ");
        sbInsert.append(" item.FID as FBgItem1ID, '");
        sbInsert.append(destBgFormId);
        sbInsert.append("' as FBgFormID, isnull( (select 1 where row1.FType=2), 0 ) as FIsLeafEntry, ");
        sbInsert.append(" row1.FSeq as FBgItemsKey, 2 as FEntryType ");
        sbInsert.append(" from ");
        sbInsert.append(tmpPeriodTable);
        sbInsert.append(" as period, T_BG_BgRptTemplateRow as row1, t_bg_bgitem as item where row1.FBgRptTemplateID='");
        sbInsert.append(rptTpId);
        sbInsert.append("' and item.FRefDimensionID in (select FID from T_BG_ReferencedDimension where FBgTemplateID='");
        sbInsert.append(bgTemplateId);
        sbInsert.append("') and row1.FSeq=item.FItemNumber ");
        Connection connection = null;
        PreparedStatement ps = null;
        String sql = sbInsert.toString();
        try {
            connection = this.getConnection(ctx);
            ps = connection.prepareStatement(sql);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)connection);
    }

    private void roll_prepareTmpTable(Context ctx, String tmpPeriodTable, BgFormInfo sourceBgFormInfo) throws BOSException, EASBizException {
        Vector<BgPeriodNode> vector = new Vector<BgPeriodNode>();
        FullOrgUnitInfo orgInfo = sourceBgFormInfo.getOrgUnit();
        BgTemplateInfo bgTemInfo = sourceBgFormInfo.getBgTemplate();
        BgCycleTypeEnum cycle = bgTemInfo.getBgCycle();
        BgCycleTypeEnum rollCycle = bgTemInfo.getRollingBgCycle();
        CompanyOrgUnitInfo companyInfo = null;
        Object targetPeriod = null;
        IOrgUnitCommon iOrgUnitCommon = OrgUnitCommonFactory.getLocalInstance((Context)ctx);
        companyInfo = iOrgUnitCommon.getCompany(orgInfo.getId());
        PeriodInfo period1 = null;
        PeriodInfo period2 = null;
        period1 = BgRollFormFactory.getLocalInstance(ctx).getFinalPeriod(sourceBgFormInfo.getId().toString(), cycle);
        int year = period1.getPeriodYear();
        int quarter = period1.getPeriodQuarter();
        int number = period1.getPeriodNumber();
        int yLen = 12;
        int qLen = 3;
        if (cycle.equals((Object)BgCycleTypeEnum.Season)) {
            if (quarter < 4) {
                period2 = this.roll_getPeriodInfo(ctx, year, quarter * qLen + 1, companyInfo);
                vector.add(new BgPeriodNode(period2, BgCycleTypeEnum.Season, true));
            } else {
                period2 = this.roll_getPeriodInfo(ctx, year + 1, 1, companyInfo);
                vector.add(new BgPeriodNode(period2, BgCycleTypeEnum.Season, true));
                period2 = this.roll_getPeriodInfo(ctx, year + 1, 1, companyInfo);
                vector.add(new BgPeriodNode(period2, BgCycleTypeEnum.Year, false));
            }
        } else if (rollCycle.equals((Object)BgCycleTypeEnum.Season)) {
            int m;
            int i;
            if (number + qLen > yLen) {
                period2 = this.roll_getPeriodInfo(ctx, year + 1, 1, companyInfo);
                vector.add(new BgPeriodNode(period2, BgCycleTypeEnum.Year, false));
                period2 = this.roll_getPeriodInfo(ctx, year + 1, 1, companyInfo);
                vector.add(new BgPeriodNode(period2, BgCycleTypeEnum.Season, false));
                i = 0;
                m = 1;
                while (i < qLen) {
                    period2 = this.roll_getPeriodInfo(ctx, year + 1, m, companyInfo);
                    vector.add(new BgPeriodNode(period2, BgCycleTypeEnum.Period, true));
                    ++i;
                    ++m;
                }
            } else {
                period2 = this.roll_getPeriodInfo(ctx, year, quarter * qLen + 1, companyInfo);
                vector.add(new BgPeriodNode(period2, BgCycleTypeEnum.Season, false));
                i = 0;
                m = quarter * qLen + 1;
                while (i < qLen) {
                    period2 = this.roll_getPeriodInfo(ctx, year, m, companyInfo);
                    vector.add(new BgPeriodNode(period2, BgCycleTypeEnum.Period, true));
                    ++i;
                    ++m;
                }
            }
            i = 0;
            m = (quarter - 1) * qLen + 1;
            while (i < qLen) {
                if (m > number) {
                    period2 = this.roll_getPeriodInfo(ctx, year, m, companyInfo);
                    vector.add(new BgPeriodNode(period2, BgCycleTypeEnum.Period, true));
                }
                ++i;
                ++m;
            }
        } else if (rollCycle.equals((Object)BgCycleTypeEnum.Period)) {
            if (number + 1 > yLen) {
                period2 = this.roll_getPeriodInfo(ctx, year + 1, 1, companyInfo);
                vector.add(new BgPeriodNode(period2, BgCycleTypeEnum.Year, false));
                period2 = this.roll_getPeriodInfo(ctx, year + 1, 1, companyInfo);
                vector.add(new BgPeriodNode(period2, BgCycleTypeEnum.Season, false));
                period2 = this.roll_getPeriodInfo(ctx, year + 1, 1, companyInfo);
                vector.add(new BgPeriodNode(period2, BgCycleTypeEnum.Period, true));
            } else {
                if (number == quarter * qLen) {
                    period2 = this.roll_getPeriodInfo(ctx, year, number + 1, companyInfo);
                    vector.add(new BgPeriodNode(period2, BgCycleTypeEnum.Season, false));
                }
                period2 = this.roll_getPeriodInfo(ctx, year, number + 1, companyInfo);
                vector.add(new BgPeriodNode(period2, BgCycleTypeEnum.Period, true));
            }
        }
        Connection connection = null;
        PreparedStatement ps = null;
        try {
            StringBuffer sbCreate = new StringBuffer("create table ");
            sbCreate.append(tmpPeriodTable);
            sbCreate.append(" (FPeriodID varchar (44), FBgCycle int, FIsLeafPeriod int, FIdentity varchar(50)) ");
            String sql = sbCreate.toString();
            connection = this.getConnection(ctx);
            ps = connection.prepareStatement(sql);
            ps.execute();
            StringBuffer sbInsert = new StringBuffer(" insert into ");
            sbInsert.append(tmpPeriodTable);
            sbInsert.append(" ( FPeriodID, FBgCycle, FIsLeafPeriod, FIdentity ) values (?, ?, ?, ?)");
            sql = sbInsert.toString();
            for (int i = 0; i < vector.size(); ++i) {
                BgPeriodNode bgPeriodNode = (BgPeriodNode)vector.get(i);
                ps = connection.prepareStatement(sql);
                ps.setString(1, bgPeriodNode.getPeriod().getId().toString());
                ps.setInt(2, bgPeriodNode.getBgCycle().getValue());
                ps.setBoolean(3, bgPeriodNode.isLeaf());
                String identity = BgPeriodNode.toNumbericString(bgPeriodNode.getPeriod(), bgPeriodNode.getBgCycle());
                ps.setString(4, identity);
                ps.execute();
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)connection);
        System.out.println(vector);
    }

    private PeriodInfo roll_getPeriodInfo(Context ctx, int periodYear, int periodNumber, CompanyOrgUnitInfo companyInfo) throws BOSException, EASBizException {
        PeriodInfo period = PeriodUtils.getPeriodInfo((Context)ctx, (int)periodYear, (int)periodNumber, (CompanyOrgUnitInfo)companyInfo);
        if (period == null) {
            throw new BgFormException(BgFormException.NOADDPERIOD);
        }
        return period;
    }

    private void roll_insertBgEntry(Context ctx, String bgFormId, String tmpPeriodTable, String bgTemplateId) throws BOSException {
        BgEntryInfo tmpEntryInfo = new BgEntryInfo();
        String bosType = tmpEntryInfo.getBOSType().toString();
        StringBuffer sbInsert = new StringBuffer(" insert into t_bg_bgentry");
        sbInsert.append(" ( FID, FBgCycle, FPeriodID, FIsLeafPeriod, ");
        sbInsert.append(" FBgItem1ID, FBgItem2ID, FBgItem3ID, FBgItem4ID, FBgItem5ID, FBgItem6ID, ");
        sbInsert.append(" FBgFormID, FIsLeafEntry, FBgItemsKey, FEntryType, FSplitRate ) ");
        sbInsert.append(" select newid() || '");
        sbInsert.append(bosType);
        sbInsert.append("' as FID, period.FBgCycle, period.FPeriodID, period.FIsLeafPeriod, ");
        sbInsert.append(" row1.FBgItem1ID, row1.FBgItem2ID, row1.FBgItem3ID, row1.FBgItem4ID, row1.FBgItem5ID, row1.FBgItem6ID, '");
        sbInsert.append(bgFormId);
        sbInsert.append("' as FBgFormID, isnull( (select FIsLeaf from T_BG_BgItem where FID=row1.FBgItem1ID), 1 ) * ");
        sbInsert.append(" isnull( (select FIsLeaf from T_BG_BgItem where FID=row1.FBgItem2ID), 1 ) * ");
        sbInsert.append(" isnull( (select FIsLeaf from T_BG_BgItem where FID=row1.FBgItem3ID), 1 ) * ");
        sbInsert.append(" isnull( (select FIsLeaf from T_BG_BgItem where FID=row1.FBgItem4ID), 1 ) * ");
        sbInsert.append(" isnull( (select FIsLeaf from T_BG_BgItem where FID=row1.FBgItem5ID), 1 ) * ");
        sbInsert.append(" isnull( (select FIsLeaf from T_BG_BgItem where FID=row1.FBgItem6ID), 1 ) as FIsLeafEntry, ");
        sbInsert.append(" (select FItemNumber from T_BG_BgItem where FID=row1.FBgItem1ID)");
        sbInsert.append(" || isnull( (select '_' || FItemNumber from T_BG_BgItem where FID=row1.FBgItem2ID), '' )");
        sbInsert.append(" || isnull( (select '_' || FItemNumber from T_BG_BgItem where FID=row1.FBgItem3ID), '' ) as FBgItemsKey, ");
        sbInsert.append(" 2 as FEntryType, 0.0 as FSplitRate ");
        sbInsert.append(" from ");
        sbInsert.append(tmpPeriodTable);
        sbInsert.append(" as period, t_bg_bgtemplaterow as row1 where row1.FBgTemplateID='");
        sbInsert.append(bgTemplateId);
        sbInsert.append("'");
        Connection connection = null;
        PreparedStatement ps = null;
        String sql = sbInsert.toString();
        try {
            connection = this.getConnection(ctx);
            ps = connection.prepareStatement(sql);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)connection);
    }

    @Override
    protected String _addnewRptBgForm(Context ctx, IObjectValue bgFormInfo) throws BOSException, EASBizException {
        SimpleTimer timer = new SimpleTimer();
        BgFormInfo formInfo = (BgFormInfo)bgFormInfo;
        String name = formInfo.getName();
        String number = formInfo.getNumber();
        BgSchemeInfo schemeInfo = formInfo.getBgScheme();
        if (schemeInfo == null || schemeInfo.getId() == null) {
            throw new BOSException("NoSchemeInfo");
        }
        BOSUuid schemeId = schemeInfo.getId();
        BgTemplateInfo templateInfo = formInfo.getBgTemplate();
        if (templateInfo == null || templateInfo.getId() == null || templateInfo.getBgCycle() == null) {
            throw new BOSException("NoTemplateInfo");
        }
        BOSUuid templateId = templateInfo.getId();
        BgCycleTypeEnum bgCycle = templateInfo.getBgCycle();
        BgTypeInfo typeInfo = formInfo.getBgType();
        if (typeInfo == null || typeInfo.getId() == null) {
            throw new BOSException("NoTypeInfo");
        }
        BOSUuid typeId = typeInfo.getId();
        FullOrgUnitInfo orgUnitInfo = formInfo.getOrgUnit();
        if (orgUnitInfo == null || orgUnitInfo.getId() == null) {
            throw new BOSException("NoOrgUnitInfo");
        }
        BOSUuid orgUnitId = orgUnitInfo.getId();
        BgRptTemplateInfo rptTpInfo = formInfo.getBgRptTemplate();
        if (rptTpInfo == null || rptTpInfo.getId() == null) {
            throw new BOSException("NoTemplateInfo");
        }
        BOSUuid rptTpId = rptTpInfo.getId();
        String bgFormId = this.addnewRpt_insertBgForm(ctx, name, number, schemeId.toString(), templateId.toString(), typeId.toString(), orgUnitId.toString(), rptTpId.toString());
        ITableManagerFacade mang = TableManagerFacadeFactory.getLocalInstance((Context)ctx);
        String tmpPeriodTable = mang.getTableName("bg");
        try {
            this.addnew_createTmpTable(ctx, tmpPeriodTable);
            this.addnew_insertTmpPeriodTable(ctx, tmpPeriodTable, schemeId.toString(), bgCycle, orgUnitId.toString());
            this.addnewRpt_insertBgEntry(ctx, bgFormId, tmpPeriodTable, templateId.toString(), rptTpId.toString());
            this.addnewRpt_insertBgData(ctx, bgFormId, templateId.toString(), tmpPeriodTable, typeId.toString());
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            this.dropTmpTable(ctx, tmpPeriodTable);
        }
        this.addnew_applyRptScheme(ctx, typeInfo, bgFormId, templateId, schemeId, orgUnitInfo.getNumber());
        System.out.println("--------------------------------addnew RptBgForm: " + timer.getTime());
        return bgFormId;
    }

    private void addnew_applyRptScheme(Context ctx, BgTypeInfo bgType, String bgFormId, BOSUuid templateId, BOSUuid schemeId, String orgNumber) throws EASBizException, BOSException {
        bgType = BgTypeFactory.getLocalInstance(ctx).getBgTypeBySql(bgType.getId());
        String bgTypeNumber = bgType.getNumber();
        BgRptTemplateRowCollection bgc = this.getBgRptFormulaC(ctx, templateId, schemeId);
        BgFormulaProxy proxy = new BgFormulaProxy(ctx, schemeId.toString());
        TableRelations relations = new TableRelations();
        relations.getDefaultFunctionProvider().add(proxy);
        IBgProvider iBgP = BgProviderFactory.getLocalInstance(ctx);
        for (int i = 0; i < bgc.size(); ++i) {
            BgRptTemplateRowInfo formula = bgc.get(i);
            String formulaItemId = (String)formula.get("myItem");
            Vector entryIdVec = this.getBgRptEntryIdVec(ctx, bgFormId, formulaItemId);
            for (int j = 0; j < entryIdVec.size(); ++j) {
                String formulaStr = (String)formula.get("myFormula");
                String formulaNumber = (String)formula.get("myNumber");
                String id = (String)entryIdVec.get(j);
                BgEntryInfo bgEntry = this.getBgEntryInfo(ctx, id);
                String item1id = (String)bgEntry.get("myItem1");
                int year = (Integer)bgEntry.get("myYear");
                int quarter = (Integer)bgEntry.get("myQuarter");
                int number = (Integer)bgEntry.get("myNumber");
                int cycle = (Integer)bgEntry.get("myCycle");
                if (bgTypeNumber.equals("BalanceSheetBudget")) {
                    BgElementCollection bgEleC = bgType.getElements();
                    for (int k = 0; k < bgEleC.size(); ++k) {
                        String bgElementNumber = bgEleC.get(k).getNumber();
                        String dim = String.valueOf(1100);
                        String bgItemsString = formulaStr;
                        String cyNumber = "BB01";
                        String yearString = "" + year;
                        String quarterString = "" + quarter;
                        String periodString = "" + number;
                        BigDecimal value = iBgP.parseBgFormula(schemeId.toString(), "AccountBudget", orgNumber, bgElementNumber, dim, bgItemsString, cyNumber, yearString, quarterString, periodString, BgCycleTypeEnum.getEnum(cycle));
                        this.updateBgRptData_balanceSheetBudge(ctx, id, bgElementNumber, value);
                    }
                    continue;
                }
                formulaStr = "=" + formulaStr;
                String periodStr = "";
                if (formulaStr.indexOf("CurrentPeriod") != -1) {
                    periodStr = year + "|" + quarter + "|" + number + "|";
                } else if (formulaStr.indexOf("PreviousPeriod") != -1) {
                    if (cycle == 3) {
                        if (number == 4 || number == 7 || number == 10) {
                            --number;
                            --quarter;
                        } else if (number == 1) {
                            --year;
                            number = 12;
                            quarter = 4;
                        } else {
                            --number;
                        }
                    } else if (cycle == 2) {
                        if (quarter == 4 || quarter == 2 || quarter == 3) {
                            number = 1;
                            --quarter;
                        } else if (quarter == 1) {
                            --year;
                            number = 10;
                            quarter = 4;
                        }
                    } else if (cycle == 1) {
                        --year;
                        number = 1;
                        quarter = 1;
                    }
                    periodStr = year + "|" + quarter + "|" + number + "|";
                } else if (formulaStr.indexOf("NextPeriod") != -1) {
                    if (cycle == 3) {
                        if (number == 3 || number == 6 || number == 9) {
                            ++number;
                            ++quarter;
                        } else if (number == 12) {
                            ++year;
                            number = 1;
                            quarter = 1;
                        } else {
                            ++number;
                        }
                    } else if (cycle == 2) {
                        if (quarter == 1 || quarter == 2 || quarter == 3) {
                            number = quarter == 1 ? 4 : (quarter == 2 ? 7 : 10);
                            ++quarter;
                        } else if (quarter == 4) {
                            ++year;
                            number = 1;
                            quarter = 1;
                        }
                    } else if (cycle == 1) {
                        ++year;
                        number = 1;
                        quarter = 1;
                    }
                    periodStr = year + "|" + quarter + "|" + number + "|";
                }
                if (cycle == 3) {
                    periodStr = periodStr + BgCycleTypeEnum.Period.getName();
                } else if (cycle == 2) {
                    periodStr = periodStr + BgCycleTypeEnum.Season.getName();
                } else if (cycle == 1) {
                    periodStr = periodStr + BgCycleTypeEnum.Year.getName();
                }
                if (formulaStr.indexOf("CurrentPeriod") != -1) {
                    formulaStr = formulaStr.replaceAll("CurrentPeriod", periodStr);
                } else if (formulaStr.indexOf("PreviousPeriod") != -1) {
                    formulaStr = formulaStr.replaceAll("PreviousPeriod", periodStr);
                } else if (formulaStr.indexOf("NextPeriod") != -1) {
                    formulaStr = formulaStr.replaceAll("NextPeriod", periodStr);
                }
                BigDecimal value = this.caculateFormula(formulaStr, relations);
                this.updateBgRptData(ctx, id, value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String addnewRpt_insertBgForm(Context ctx, String name, String number, String bgSchemeId, String bgTemplateId, String bgTypeId, String orgUnitId, String rptTpId) throws BOSException {
        Connection connection = null;
        PreparedStatement ps = null;
        String sqlInsert = "insert into t_bg_bgform (FID, FNumber, FName, FState, FPurpose, FIsCurrent, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FHasEffected, FCompanyID, FBgTemplateID, FBgSchemeID, FBgTypeID, FPeriodFromID, FPeriodToID, FOrgUnitID, FDataSource, FControlUnitID, FBgRptTemplateID) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        String fid = "";
        try {
            connection = this.getConnection(ctx);
            ps = connection.prepareStatement(sqlInsert);
            BgFormInfo tmpFormInfo = new BgFormInfo();
            BOSUuid tmpFormId = BOSUuid.create((BOSObjectType)tmpFormInfo.getBOSType());
            fid = tmpFormId.toString();
            tmpFormInfo.setId(tmpFormId);
            ps.setString(1, fid);
            ps.setString(2, number);
            ps.setString(3, name);
            ps.setInt(4, 1);
            ps.setInt(5, 1);
            ps.setInt(6, 1);
            ps.setString(7, ctx.getCaller().toString());
            Date date = new Date();
            long time = date.getTime();
            Calendar d = Calendar.getInstance();
            d.setTime(new Timestamp(time));
            d.set(14, 0);
            Timestamp createtime = new Timestamp(d.getTime().getTime());
            ps.setTimestamp(8, createtime);
            ps.setString(9, ctx.getCaller().toString());
            ps.setTimestamp(10, createtime);
            ps.setInt(11, 1);
            IOrgUnitCommon iOrgUnitCommon = OrgUnitCommonFactory.getLocalInstance((Context)ctx);
            CompanyOrgUnitInfo companyInfo = null;
            try {
                companyInfo = (CompanyOrgUnitInfo)iOrgUnitCommon.getRelationUnit(BOSUuid.read((String)orgUnitId), OrgType.Company);
            }
            catch (EASBizException e1) {
                e1.printStackTrace();
            }
            catch (BOSException e1) {
                e1.printStackTrace();
            }
            ps.setString(12, companyInfo.getId().toString());
            ps.setString(13, bgTemplateId);
            ps.setString(14, bgSchemeId);
            ps.setString(15, bgTypeId);
            IBgScheme iBgScheme = BgSchemeFactory.getLocalInstance(ctx);
            BgSchemeInfo schemeInfo = iBgScheme.getBgSchemeInfo("select periodFrom, periodTo where id='" + bgSchemeId + "'");
            ps.setString(16, schemeInfo.getPeriodFrom().getId().toString());
            ps.setString(17, schemeInfo.getPeriodTo().getId().toString());
            ps.setString(18, orgUnitId);
            ps.setInt(19, 0);
            CtrlUnitInfo cuInfo = BgOrgHelper.getDefCU();
            ps.setString(20, cuInfo.getId().toString());
            ps.setString(21, rptTpId);
            ps.executeUpdate();
            UserInfo userInfo = new UserInfo();
            userInfo.setId(BOSUuid.read((String)ctx.getCaller().toString()));
            BgFormLogHelper.addNewBgFormLog(ctx, tmpFormInfo, BgOperationEnum.AddNew, userInfo);
            SQLUtils.cleanup((Statement)ps, (Connection)connection);
            return fid;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
            catch (EASBizException e2) {
                e2.printStackTrace();
                return fid;
            }
            catch (BOSException e3) {
                e3.printStackTrace();
                SQLUtils.cleanup((Statement)ps, (Connection)connection);
                return fid;
            }
        }
        finally {
            SQLUtils.cleanup(ps, (Connection)connection);
        }
    }

    private void addnewRpt_insertBgEntry(Context ctx, String bgFormId, String tmpPeriodTable, String bgTemplateId, String rptTpId) throws BOSException {
        BgEntryInfo tmpEntryInfo = new BgEntryInfo();
        String bosType = tmpEntryInfo.getBOSType().toString();
        StringBuffer sbInsert = new StringBuffer(" insert into t_bg_bgentry");
        sbInsert.append(" ( FID, FBgCycle, FPeriodID, FIsLeafPeriod, ");
        sbInsert.append(" FBgItem1ID, FBgFormID, FIsLeafEntry, FBgItemsKey ) ");
        sbInsert.append(" select newid() || '");
        sbInsert.append(bosType);
        sbInsert.append("' as FID, period.FBgCycle, period.FPeriodID, period.FIsLeafPeriod, ");
        sbInsert.append(" item.FID as FBgItem1ID, '");
        sbInsert.append(bgFormId);
        sbInsert.append("' as FBgFormID, isnull( (select 1 where row1.FType=2), 0 ) as FIsLeafEntry, ");
        sbInsert.append(" row1.FSeq as FBgItemsKey ");
        sbInsert.append(" from ");
        sbInsert.append(tmpPeriodTable);
        sbInsert.append(" as period, T_BG_BgRptTemplateRow as row1, t_bg_bgitem as item where row1.FBgRptTemplateID='");
        sbInsert.append(rptTpId);
        sbInsert.append("' and item.FRefDimensionID in (select FID from T_BG_ReferencedDimension where FBgTemplateID='");
        sbInsert.append(bgTemplateId);
        sbInsert.append("') and to_char(row1.FSeq)=item.FItemNumber ");
        Connection connection = null;
        PreparedStatement ps = null;
        String sql = sbInsert.toString();
        try {
            connection = this.getConnection(ctx);
            ps = connection.prepareStatement(sql);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)connection);
    }

    private void addnewRpt_insertBgData(Context ctx, String bgFormId, String bgTemplateId, String tmpPeriodTable, String bgTypeId) throws BOSException {
        BgDataInfo tmpDataInfo = new BgDataInfo();
        String bosType = tmpDataInfo.getBOSType().toString();
        StringBuffer sbInsert = new StringBuffer(" insert into t_bg_bgdata");
        sbInsert.append(" ( FID, FDataType, FBgValue, FElementNumber, ");
        sbInsert.append("FBgCtrlType, FIsFlexibleCtrl, FFlexibleBgCtrlParam, FCurrencyID, ");
        sbInsert.append(" FBgElementID, FBgEntryID, FIdentity ) ");
        sbInsert.append("select newid() || '");
        sbInsert.append(bosType);
        sbInsert.append("' as FID, ele.FDataType, 0.0 as FBgValue, ele.FNumber as FElementNumber, ");
        sbInsert.append("1 as FBgCtrlType, 0 as FIsFlexibleCtrl, 0.0 as FFlexibleBgCtrlParam, ");
        sbInsert.append("(select top 1 FCurrencyID from T_BG_ReferencedCurrency where FBgTemplateID='");
        sbInsert.append(bgTemplateId);
        sbInsert.append("') as FCurrencyID, ");
        sbInsert.append("ele.FID as FBgElementID, entry.FID as FBgEntryID, ");
        sbInsert.append("period.FIdentity||'_'||entry.FBgItemsKey||'_'||ele.FNumber as FIdentity ");
        sbInsert.append("from T_BG_BgElement as ele, T_BG_BgEntry as entry, ");
        sbInsert.append(tmpPeriodTable);
        sbInsert.append(" as period ");
        sbInsert.append("where ele.FBgTypeID='");
        sbInsert.append(bgTypeId);
        sbInsert.append("' and entry.FBgFormID='");
        sbInsert.append(bgFormId);
        sbInsert.append("' and entry.FPeriodID=period.FPeriodID and entry.FBgCycle=period.FBgCycle ");
        Connection connection = null;
        PreparedStatement ps = null;
        String sql = sbInsert.toString();
        try {
            connection = this.getConnection(ctx);
            ps = connection.prepareStatement(sql);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)connection);
    }

    @Override
    protected void _renameBgForm(Context ctx, IObjectValue bgForm) throws BOSException, EASBizException {
        BgFormInfo bgform = (BgFormInfo)bgForm;
        StringBuffer sbInsert = new StringBuffer(" update t_bg_bgform set fname='");
        sbInsert.append(bgform.getName());
        sbInsert.append("', fnumber='");
        sbInsert.append(bgform.getNumber());
        sbInsert.append("' where fid='");
        sbInsert.append(bgform.getId().toString());
        sbInsert.append("'");
        Connection connection = null;
        PreparedStatement ps = null;
        String sql = sbInsert.toString();
        try {
            connection = this.getConnection(ctx);
            ps = connection.prepareStatement(sql);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)connection);
    }

    @Override
    protected void _balanceBgForm(Context ctx, String bgFormId, int type) throws BOSException, EASBizException {
        ITableManagerFacade mang = TableManagerFacadeFactory.getLocalInstance((Context)ctx);
        String tmpDataTable = mang.getTableName("bg");
        Connection connection = null;
        PreparedStatement ps = null;
        StringBuffer sb = new StringBuffer();
        String sql = "";
        try {
            connection = this.getConnection(ctx);
            sb.append("CREATE TABLE ");
            sb.append(tmpDataTable);
            sb.append(" ( FID varchar (44), FBgValue decimal (28, 10), FPeriod varchar (20), ");
            sb.append("\tFBgItem1 varchar (80), FBgItem2 varchar (80), FBgItem3 varchar (80), ");
            sb.append(" FIsLeafPeriod int, FIsLeafEntry int, FBgElementID varchar (44), FCurrencyID varchar (44) )");
            sql = sb.toString();
            ps = connection.prepareStatement(sql);
            ps.execute();
            sb = new StringBuffer();
            sb.append("insert into ");
            sb.append(tmpDataTable);
            sb.append(" (FID, FBgValue, FPeriod, FBgItem1, FBgItem2, FBgItem3, FIsLeafPeriod, FIsLeafEntry, FBgElementID, FCurrencyID) ");
            sb.append(" select d.FID, d.");
            if (type == 1) {
                sb.append("FBgValue");
            } else if (type == 2) {
                sb.append("FBgBalance");
            } else if (type == 3) {
                sb.append("FBizActual");
            }
            sb.append(", substring(d.FIdentity, 0, charindex('_', d.FIdentity)) as FPeriod, ");
            sb.append(" (select isnull(FLongNumber, FItemNumber) from t_bg_bgitem where fid=e.FBgItem1ID) as FBgItem1, ");
            sb.append(" (select isnull(FLongNumber, FItemNumber) from t_bg_bgitem where fid=e.FBgItem2ID) as FBgItem2, ");
            sb.append(" (select isnull(FLongNumber, FItemNumber) from t_bg_bgitem where fid=e.FBgItem3ID) as FBgItem3, ");
            sb.append(" e.FIsLeafPeriod, e.FIsLeafEntry, d.FBgElementID, d.FCurrencyID ");
            sb.append(" from t_bg_bgdata d, t_bg_bgentry e ");
            sb.append(" where d.FBgEntryID=e.FID and e.FBgFormID = ? ");
            sql = sb.toString();
            ps = connection.prepareStatement(sql);
            ps.setString(1, bgFormId);
            ps.execute();
            sb = new StringBuffer();
            sb.append(" update ");
            sb.append(tmpDataTable);
            sb.append(" set FBgValue = isnull( ");
            sb.append(" ( select sum(a.FBgValue) from ");
            sb.append(tmpDataTable);
            sb.append(" a where a.FIsLeafPeriod=1 and a.FIsLeafEntry=1 ");
            sb.append(" and charindex(" + tmpDataTable + ".FPeriod, a.FPeriod)=1 ");
            sb.append(" and (a.FBgItem1 is null or a.FBgItem1=" + tmpDataTable + ".FBgItem1 or charindex(" + tmpDataTable + ".FBgItem1 || '!', a.FBgItem1)=1 ) ");
            sb.append(" and (a.FBgItem2 is null or a.FBgItem2=" + tmpDataTable + ".FBgItem2 or charindex(" + tmpDataTable + ".FBgItem2 || '!', a.FBgItem2)=1 ) ");
            sb.append(" and (a.FBgItem3 is null or a.FBgItem3=" + tmpDataTable + ".FBgItem3 or charindex(" + tmpDataTable + ".FBgItem3 || '!', a.FBgItem3)=1 ) ");
            sb.append(" and a.FBgElementID=" + tmpDataTable + ".FBgElementID and a.FCurrencyID=" + tmpDataTable + ".FCurrencyID ), 0) ");
            sb.append(" where " + tmpDataTable + ".FIsLeafPeriod=0 or " + tmpDataTable + ".FIsLeafEntry=0 ");
            sql = sb.toString();
            ps = connection.prepareStatement(sql);
            ps.execute();
            sb = new StringBuffer();
            sb.append(" update t_bg_bgdata set ");
            if (type == 1) {
                sb.append("FBgValue");
            } else if (type == 2) {
                sb.append("FBgBalance");
            } else if (type == 3) {
                sb.append("FBizActual");
            }
            sb.append("= isnull( ( select FBgValue from ");
            sb.append(tmpDataTable);
            sb.append(" where FID=t_bg_bgdata.FID ), 0) where t_bg_bgdata.FID in ( select FID from ");
            sb.append(tmpDataTable);
            sb.append(" ) ");
            sql = sb.toString();
            ps = connection.prepareStatement(sql);
            ps.execute();
        }
        catch (Exception ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                this.dropTmpTable(ctx, tmpDataTable);
                SQLUtils.cleanup(ps, (Connection)connection);
                throw throwable;
            }
        }
        this.dropTmpTable(ctx, tmpDataTable);
        SQLUtils.cleanup((Statement)ps, (Connection)connection);
    }

    @Override
    protected void _balanceRptBgForm(Context ctx, BOSUuid bgTypeId, String bgFormId, BOSUuid templateId) throws EASBizException, BOSException {
        String formulaStr;
        BgRptTemplateRowInfo formula;
        int i;
        BgTypeInfo bgType = BgTypeFactory.getLocalInstance(ctx).getBgTypeBySql(bgTypeId);
        String bgTypeNumber = bgType.getNumber();
        BgRptTemplateRowCollection bgc = this.getBgRptFormulaC_total(ctx, templateId);
        Hashtable<Integer, Integer> upTable = new Hashtable<Integer, Integer>();
        for (i = 0; i < bgc.size(); ++i) {
            formula = bgc.get(i);
            formulaStr = (String)formula.get("myFormula");
            int rowType = (Integer)formula.get("myRowType");
            if (rowType != 3 || formula.equals("")) continue;
            upTable.put(new Integer(i), new Integer(i));
        }
        for (i = 0; i < bgc.size(); ++i) {
            formula = bgc.get(i);
            formulaStr = (String)formula.get("myFormula");
            String formulaNumber = (String)formula.get("myNumber");
            String formulaItemId = (String)formula.get("myItem");
            int rowType = (Integer)formula.get("myRowType");
            HashSet set = new HashSet();
            if (rowType != 3 || formula.equals("")) continue;
            this.doRptSeriesItemDetail(bgc, set, upTable, i, "", formulaStr);
            Vector entryIdVec = this.getBgRptEntryIdVec(ctx, bgFormId, formulaItemId);
            for (int j = 0; j < entryIdVec.size(); ++j) {
                String id = (String)entryIdVec.get(j);
                BgEntryInfo entry = this.getBgEntryInfo(ctx, id);
                int cycle = (Integer)entry.get("myCycle");
                String periodId = (String)entry.get("myPeriod");
                BgElementCollection bgEleC = bgType.getElements();
                for (int k = 0; k < bgEleC.size(); ++k) {
                    String eleNumber = bgEleC.get(k).getNumber();
                    BigDecimal caclValue = this.getCaclValue(ctx, set, eleNumber, cycle, periodId);
                    this.updateBgRptData_balanceSheetBudge(ctx, id, eleNumber, caclValue);
                }
            }
        }
    }

    private void doRptSeriesItemDetail(BgRptTemplateRowCollection bgc, HashSet set, Hashtable upTable, int i, String tempSign, String formulaStr) {
        Vector v1;
        int j;
        String[] strArr = StringUtils.split((String)formulaStr, (int)43);
        if (strArr == null) {
            return;
        }
        Vector<Vector> vec = new Vector<Vector>();
        for (j = 0; j < strArr.length; ++j) {
            if (strArr[j].indexOf("-") != -1) {
                String[] ddd = strArr[j].split("-");
                for (int k = 0; k < ddd.length; ++k) {
                    Vector<String> v12 = new Vector<String>();
                    String strTemp = ddd[k].trim();
                    ddd[k] = strTemp = strTemp.substring(1, strTemp.length() - 1);
                    v12.add(ddd[k]);
                    if (k == 0) {
                        v12.add("+");
                    } else {
                        v12.add("-");
                    }
                    vec.add(v12);
                }
                continue;
            }
            v1 = new Vector();
            String strTemp = strArr[j].trim();
            strArr[j] = strTemp = strTemp.substring(1, strTemp.length() - 1);
            v1.add(strArr[j]);
            v1.add("+");
            vec.add(v1);
        }
        for (j = 0; j < vec.size(); ++j) {
            v1 = (Vector)vec.get(j);
            String strTemp = (String)v1.get(0);
            String sign = (String)v1.get(1);
            if (!tempSign.equals("")) {
                sign = tempSign.equals("+") ? (sign.equals("+") ? "+" : "-") : (sign.equals("+") ? "-" : "+");
            }
            String[] rowArray = StringUtils.split((String)strTemp, (int)58);
            int beginRow = Integer.parseInt(rowArray[0]);
            int endRow = Integer.parseInt(rowArray[1]);
            int size = bgc.size();
            if (beginRow > size || endRow > size) break;
            for (int k = beginRow; k <= endRow; ++k) {
                if (k == i + 1) continue;
                String id = (String)bgc.get(k - 1).get("myItem");
                String tempFormulaStr = (String)bgc.get(k - 1).get("myFormula");
                if (upTable.containsKey(new Integer(k - 1))) {
                    this.doRptSeriesItemDetail(bgc, set, upTable, k - 1, sign, tempFormulaStr);
                    continue;
                }
                if ((Integer)bgc.get(k - 1).get("myDirection") == 1) {
                    if (sign.equals("+")) {
                        set.add(id + "&+");
                        continue;
                    }
                    set.add(id + "&-");
                    continue;
                }
                if (sign.equals("+")) {
                    set.add(id + "&-");
                    continue;
                }
                set.add(id + "&+");
            }
        }
    }

    private BgRptTemplateRowCollection getBgRptFormulaC_total(Context ctx, BOSUuid templateId) throws SQLDataException, BOSException {
        BgRptTemplateRowCollection bgc = new BgRptTemplateRowCollection();
        String sql = "select  T_BG_BgRptTemplateRow.FFormula AS bgRptTpRow_formula, T_BG_BgRptTemplateRow.FNumber AS bgRptTpRow_number, t_bg_bgitem.Fid AS bgItem_id , T_BG_BgRptTemplateRow.FType AS bgRptTpRow_type ,  T_BG_BgRptTemplateRow.FDirection AS bgRptTpRow_direction  FROM T_BG_BgRptTemplate ,T_BG_BgRptTemplateRow , T_bg_bgtemplate,T_BG_ReferencedDimension,t_bg_bgitem  where T_BG_BgRptTemplate.FID = T_BG_BgRptTemplateRow.FBgRptTemplateID  and T_BG_BgRptTemplate.fbgtemplateid = T_bg_bgtemplate.fid  and T_BG_ReferencedDimension.fbgtemplateid = T_bg_bgtemplate.fid  and t_bg_bgitem.FRefDimensionID = T_BG_ReferencedDimension.fid  and T_BG_BgRptTemplateRow.FSeq = t_bg_bgitem.fitemnumber  and T_BG_BgRptTemplate.FBgTemplateID = ? ";
        ResultSet rs = null;
        Connection connection = null;
        PreparedStatement ps = null;
        try {
            connection = this.getConnection(ctx);
            ps = connection.prepareStatement(sql);
            ps.setString(1, templateId.toString());
            rs = ps.executeQuery();
            while (rs.next()) {
                BgRptTemplateRowInfo info = new BgRptTemplateRowInfo();
                info.put("myFormula", rs.getString(1) == null ? "" : rs.getString(1));
                info.put("myNumber", rs.getString(2));
                info.put("myItem", rs.getString(3));
                info.put("myRowType", new Integer(rs.getInt(4)));
                info.put("myDirection", new Integer(rs.getInt(5)));
                bgc.add(info);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)connection);
        return bgc;
    }
}

