/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.SimpleTimer;
import com.kingdee.eas.base.permission.ContextUtils;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.bg.AndVOPredicate;
import com.kingdee.eas.ma.bg.BgAdjustFormFactory;
import com.kingdee.eas.ma.bg.BgApproveTypeEnum;
import com.kingdee.eas.ma.bg.BgBizException;
import com.kingdee.eas.ma.bg.BgCycleTypeEnum;
import com.kingdee.eas.ma.bg.BgDataCollection;
import com.kingdee.eas.ma.bg.BgDataInfo;
import com.kingdee.eas.ma.bg.BgEntryCollection;
import com.kingdee.eas.ma.bg.BgEntryInfo;
import com.kingdee.eas.ma.bg.BgFormDAFactory;
import com.kingdee.eas.ma.bg.BgFormDAHelper;
import com.kingdee.eas.ma.bg.BgFormDataSourceEnum;
import com.kingdee.eas.ma.bg.BgFormException;
import com.kingdee.eas.ma.bg.BgFormFactory;
import com.kingdee.eas.ma.bg.BgFormInfo;
import com.kingdee.eas.ma.bg.BgFormProcessFactory;
import com.kingdee.eas.ma.bg.BgInstantApproveException;
import com.kingdee.eas.ma.bg.BgInstantApproveFactory;
import com.kingdee.eas.ma.bg.BgInstantApproveInfo;
import com.kingdee.eas.ma.bg.BgInstantApproveTargetEnum;
import com.kingdee.eas.ma.bg.BgKDSFactory;
import com.kingdee.eas.ma.bg.BgORMEngine;
import com.kingdee.eas.ma.bg.BgPastDataInfo;
import com.kingdee.eas.ma.bg.BgPastRecordInfo;
import com.kingdee.eas.ma.bg.HashSearchEngine;
import com.kingdee.eas.ma.bg.IBgForm;
import com.kingdee.eas.ma.bg.IBgFormDA;
import com.kingdee.eas.ma.bg.IBgKDS;
import com.kingdee.eas.ma.bg.OneVOPredicate;
import com.kingdee.eas.ma.bg.VOPredicate;
import com.kingdee.eas.ma.bg.app.AbstractBgInstantApproveControllerBean;
import com.kingdee.eas.ma.bg.app.BgSqlStore;
import com.kingdee.util.db.SQLUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class BgInstantApproveControllerBean
extends AbstractBgInstantApproveControllerBean {
    @Override
    public void _executeApprove(Context ctx, IObjectValue bgInstantApproveInfo, String bgFormId) throws BOSException, EASBizException {
        SimpleTimer st = new SimpleTimer();
        if (this.getBgState(ctx, bgFormId) == 2) {
            throw new BgInstantApproveException(BgInstantApproveException.HASAPPROVED);
        }
        BgApproveTypeEnum isOK = ((BgInstantApproveInfo)bgInstantApproveInfo).getIsApproved();
        String targetId = "";
        if (isOK.equals((Object)BgApproveTypeEnum.Pass)) {
            targetId = this._executeApprove(ctx, bgFormId);
        }
        if (targetId.equals("")) {
            targetId = bgFormId;
        }
        ((BgInstantApproveInfo)bgInstantApproveInfo).setApproveTargetID(BOSUuid.read((String)targetId));
        IObjectPK pk = this._addnew(ctx, bgInstantApproveInfo);
        this.updateBgFormDataSource(ctx, targetId);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int getBgState(Context ctx, String bgFormId) throws EASBizException {
        int state = -1;
        String sql = "select fstate from t_bg_bgform where fid=?";
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, bgFormId);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                state = rs.getInt(1);
            }
        }
        catch (SQLException e) {
            try {
                throw new BgInstantApproveException(BgInstantApproveException.DATABASEERROR, e);
                catch (SQLDataException e2) {
                    throw new BgInstantApproveException(BgInstantApproveException.DATABASEERROR, e2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        return state;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateBgFormDataSource(Context ctx, String bgFormId) throws EASBizException {
        String sql = "update t_bg_bgform set fdatasource=0 where fid=?";
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, bgFormId);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BgInstantApproveException(BgInstantApproveException.DATABASEERROR, e);
                catch (SQLDataException e2) {
                    throw new BgInstantApproveException(BgInstantApproveException.DATABASEERROR, e2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    @Override
    protected String _executeApprove(Context ctx, String bgFormId) throws EASBizException, BOSException {
        if (this.getBgState(ctx, bgFormId) == 2) {
            throw new BgInstantApproveException(BgInstantApproveException.HASAPPROVED);
        }
        String result = bgFormId;
        String sql = "SELECT T_BG_BgForm.FOrgUnitID, T_BG_BgForm.FBgTypeID, T_BG_BgForm.FState, T_BG_BgForm.FPeriodFromID,pf.FPeriodYear * 100 + pf.FPeriodNumber AS startTime,pt.FPeriodYear * 100 + pt.FPeriodNumber AS endTime FROM T_BG_BgForm INNER JOIN T_BD_Period pf ON T_BG_BgForm.FPeriodFromID = pf.FID INNER JOIN T_BD_Period pt ON T_BG_BgForm.FPeriodToID = pt.FID\tWHERE T_BG_BgForm.FID = ?";
        int stateInt = 0;
        PeriodInfo beginPeriodInfo = null;
        int startTime = 0;
        int endTime = 0;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection(ctx);
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, BOSUuid.read((String)bgFormId).toString());
            rs = stmt.executeQuery();
            if (!rs.next()) {
                // empty if block
            }
            stateInt = rs.getInt("FState");
            String beginPeriodId = rs.getString("FPeriodFromID");
            beginPeriodInfo = new PeriodInfo();
            beginPeriodInfo.setId(BOSUuid.read((String)beginPeriodId));
            startTime = rs.getInt("startTime");
            endTime = rs.getInt("endTime");
            String orgUnitId = rs.getString("FOrgUnitID");
            String bgTypeId = rs.getString("FBgTypeID");
            if (stateInt == 1 || stateInt == 9 || stateInt == 14) {
                SimpleTimer st = new SimpleTimer();
                this.checkCanBeApproved(conn, orgUnitId, bgTypeId, startTime, endTime, bgFormId);
                this.signBgForm(conn, bgFormId, 2);
                this.updateDefaultBalance(conn, bgFormId);
            } else if (stateInt == 4) {
                result = BgFormProcessFactory.getLocalInstance(ctx).approveAdjustingBgForm(bgFormId);
            }
        }
        catch (SQLException e) {
            try {
                throw new BgBizException(BgBizException.GETDATA, e, new Object[]{"BgForm"});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return result;
    }

    public void checkCanBeApproved(Connection conn, String orgUnitId, String bgTypeId, int startTime, int endTime, String bgFormId) throws EASBizException {
        String sql = "SELECT COUNT(*) AS theCount FROM T_BG_BgForm INNER JOIN T_BD_Period pf ON T_BG_BgForm.FPeriodFromID = pf.FID INNER JOIN T_BD_Period pt ON T_BG_BgForm.FPeriodToID = pt.FID WHERE (T_BG_BgForm.FState = 2) AND (T_BG_BgForm.FOrgUnitID = ?) AND (T_BG_BgForm.FBgTypeID = ?) AND (T_BG_BgForm.FID != ?) AND  ( ((pf.FPeriodYear * 100 + pf.FPeriodNumber < ?) AND (pt.FPeriodYear * 100 + pt.FPeriodNumber >= ?) ) or   ((pf.FPeriodYear * 100 + pf.FPeriodNumber >= ?) AND (pf.FPeriodYear * 100 + pf.FPeriodNumber <= ?)) )";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            int theCount;
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, orgUnitId);
            stmt.setString(2, bgTypeId);
            stmt.setString(3, bgFormId);
            stmt.setInt(4, startTime);
            stmt.setInt(5, startTime);
            stmt.setInt(6, startTime);
            stmt.setInt(7, endTime);
            rs = stmt.executeQuery();
            if (rs.next() && (theCount = rs.getInt("theCount")) > 0) {
                throw new BgFormException(BgFormException.EXECUTIVEFORMEXIST);
            }
        }
        catch (SQLException e) {
            try {
                throw new BgBizException(BgBizException.GETDATA, e, new Object[]{"BgForm"});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)stmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
    }

    public void signBgForm(Connection conn, String bgFormId, int state) throws BOSException, EASBizException {
        String sql = "UPDATE T_BG_BgForm SET FState = ? WHERE FID = ?";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement(sql);
            stmt.setInt(1, state);
            stmt.setString(2, bgFormId);
            stmt.execute();
        }
        catch (SQLException e) {
            throw new BgInstantApproveException(BgInstantApproveException.DATABASEERROR, e);
        }
        finally {
            SQLUtils.cleanup(rs, (Statement)stmt);
        }
    }

    public String dealAdjustedBgForm(Context ctx, String bgFormId) throws BOSException, EASBizException {
        Connection conn = this.getConnection(ctx);
        String oriBgFormId = this.getOriginalBgFormID(conn, bgFormId);
        IBgForm iBgFormDa = BgFormFactory.getLocalInstance(ctx);
        BgFormInfo oriBgFormInfo = null;
        BgFormInfo bgFormInfo = null;
        if (this.getBgMethod(conn, oriBgFormId) == 2) {
            oriBgFormInfo = iBgFormDa.getBgForm4Audit(BOSUuid.read((String)oriBgFormId));
            bgFormInfo = iBgFormDa.getBgForm4Audit(BOSUuid.read((String)bgFormId));
            this.added_swap(ctx, oriBgFormInfo, bgFormInfo);
            oriBgFormInfo = iBgFormDa.getBgForm4Audit(BOSUuid.read((String)oriBgFormId));
            bgFormInfo = iBgFormDa.getBgForm4Audit(BOSUuid.read((String)bgFormId));
            this.deal_all_update(ctx, bgFormInfo, oriBgFormInfo);
            this.update_periodTo(ctx, oriBgFormId, bgFormInfo.getBgTemplate().getBgCycle());
        } else if (this.getBgMethod(conn, oriBgFormId) == 1) {
            oriBgFormInfo = iBgFormDa.getBgForm4Audit(BOSUuid.read((String)oriBgFormId));
            bgFormInfo = iBgFormDa.getBgForm4Audit(BOSUuid.read((String)bgFormId));
            this.added_swap(ctx, oriBgFormInfo, bgFormInfo);
            oriBgFormInfo = iBgFormDa.getBgForm4Audit(BOSUuid.read((String)oriBgFormId));
            bgFormInfo = iBgFormDa.getBgForm4Audit(BOSUuid.read((String)bgFormId));
            this.deal_all_update(ctx, bgFormInfo, oriBgFormInfo);
        }
        this.updateState(conn, bgFormId, 5);
        this.swapBgForm_all(conn, bgFormId, oriBgFormId);
        SQLUtils.cleanup((Connection)conn);
        IBgKDS iBgKDS = BgKDSFactory.getLocalInstance(ctx);
        if (oriBgFormInfo != null) {
            iBgKDS.updateBgForm(oriBgFormInfo.getId());
        }
        if (bgFormInfo != null) {
            iBgKDS.updateBgForm(bgFormInfo.getId());
        }
        return oriBgFormId;
    }

    private void rebuildBgKDS(Context ctx, BgFormInfo info) throws BOSException, EASBizException {
        IBgFormDA bgFormDA = BgFormDAFactory.getLocalInstance(ctx);
        BgEntryCollection entryColl = bgFormDA.getBgEntryCollection((IObjectPK)new ObjectUuidPK(info.getId()));
        ArrayList<BgEntryInfo> entryList = new ArrayList<BgEntryInfo>();
        byte[] byteArray = null;
        int n = entryColl.size();
        for (int i = 0; i < n; ++i) {
            entryList.add(entryColl.get(i));
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(entryList);
            byteArray = baos.toByteArray();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        String sql = "update t_bg_bgkds set FBgEntryArray=? where FBgFormId=?";
        Connection conn = this.getConnection(ctx);
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(sql);
            if (byteArray != null) {
                stmt.setBinaryStream(1, (InputStream)new ByteArrayInputStream(byteArray), byteArray.length);
            }
            stmt.setString(2, info.getId().toString());
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BgInstantApproveException(BgInstantApproveException.DATABASEERROR, e);
        }
        finally {
            SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        }
    }

    private void update_periodTo(Context ctx, String oriBgFormId, BgCycleTypeEnum bgCycle) throws EASBizException, BOSException {
        String sql = "SELECT TOP 1 E.FPeriodID FROM T_BD_Period P INNER JOIN  T_BG_BgEntry E ON P.FID = E.FPeriodID WHERE (E.FBgFormID = ?)  ORDER BY P.FPeriodYear DESC, P.FPeriodNumber DESC ";
        String sql1 = "update t_bg_bgform set fperiodtoid=? where fid=?";
        String sql2 = "select top 1 a.fid from t_bd_period a ,t_bd_period b  where a.ftypeid=b.ftypeid and a.fperiodyear=b.fperiodyear and a.fperiodquarter=b.fperiodquarter and b.fid=?  order by a.fperiodnumber desc";
        Connection cn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            cn = this.getConnection(ctx);
            stmt = cn.prepareStatement(sql);
            stmt.setString(1, BOSUuid.read((String)oriBgFormId).toString());
            rs = stmt.executeQuery();
            String periodId = "";
            if (rs.next()) {
                periodId = rs.getString(1);
            }
            if (bgCycle.equals((Object)BgCycleTypeEnum.Season)) {
                stmt = cn.prepareStatement(sql2);
                stmt.setString(1, BOSUuid.read((String)periodId).toString());
                rs = stmt.executeQuery();
                if (rs.next()) {
                    periodId = rs.getString(1);
                }
            }
            stmt = cn.prepareStatement(sql1);
            stmt.setString(1, periodId);
            stmt.setString(2, oriBgFormId);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BgInstantApproveException(BgInstantApproveException.DATABASEERROR, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)cn);
    }

    private String getOriginalBgFormID(Connection cn, String bgFormId) throws EASBizException {
        String sql = "SELECT FOriginalBgFormID from T_BG_BgVersion where FAdaptedBgFormId=?";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String oriBgFormId = null;
        try {
            stmt = cn.prepareStatement(sql);
            stmt.setString(1, BOSUuid.read((String)bgFormId).toString());
            rs = stmt.executeQuery();
            if (!rs.next()) {
                throw new BgInstantApproveException(BgInstantApproveException.EXISTBGFORM);
            }
            oriBgFormId = rs.getString(1);
        }
        catch (SQLException e) {
            try {
                throw new BgInstantApproveException(BgInstantApproveException.DATABASEERROR, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)stmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        return oriBgFormId;
    }

    private void updateStoreData(Connection cn, List lstSrc, List lstBgData, List lstDiff) throws SQLException {
        int j = 1;
        BgDataInfo info = null;
        BgDataInfo srcInfo = null;
        String sql = "update t_bg_bgdata set fbgvalue = ?,fbgbalance = ?,fbizactual = ? where fid = ?";
        PreparedStatement pstmt = cn.prepareStatement(sql);
        int size = lstDiff.size();
        for (int i = 0; i < size; ++i) {
            j = 1;
            int index = (Integer)lstDiff.get(i);
            info = (BgDataInfo)lstBgData.get(index);
            srcInfo = (BgDataInfo)lstSrc.get(index);
            pstmt.setDouble(j++, info.getBgValue().doubleValue());
            pstmt.setDouble(j++, info.getBgBalance().doubleValue());
            pstmt.setDouble(j++, info.getBizActual().doubleValue());
            pstmt.setString(j++, srcInfo.getId().toString());
            pstmt.addBatch();
            j = 1;
            pstmt.setDouble(j++, srcInfo.getBgValue().doubleValue());
            pstmt.setDouble(j++, srcInfo.getBgBalance().doubleValue());
            pstmt.setDouble(j++, srcInfo.getBizActual().doubleValue());
            pstmt.setString(j++, info.getId().toString());
            pstmt.addBatch();
        }
        pstmt.executeBatch();
        SQLUtils.cleanup((Statement)pstmt);
    }

    private void swapBgForm(Connection cn, String bgFormId, String originalBgFormId, List lstBgData, List lstSrc) throws EASBizException {
        SimpleTimer st = new SimpleTimer();
        try {
            List lstDiff = this.compareBgDataList(lstSrc, lstBgData);
            if (lstDiff.size() == 0) {
                return;
            }
            this.updateStoreData(cn, lstSrc, lstBgData, lstDiff);
        }
        catch (SQLException se) {
            throw new BgInstantApproveException(BgInstantApproveException.DATABASEERROR, se);
        }
    }

    private List getBgData(Connection cn, String bgFormId) throws SQLException {
        ArrayList<BgDataInfo> lst = new ArrayList<BgDataInfo>(100);
        String sql = BgSqlStore.getInstance().getBgDataByBgFormSql();
        PreparedStatement stmt = cn.prepareStatement(sql);
        stmt.setString(1, bgFormId);
        ResultSet rs = stmt.executeQuery();
        BgDataInfo info = null;
        while (rs.next()) {
            info = new BgDataInfo();
            info.setId(BOSUuid.read((String)rs.getString("FBgDataID")));
            info.setBgValue(new BigDecimal(Double.toString(rs.getDouble("FBgValue"))));
            info.setBgBalance(new BigDecimal(Double.toString(rs.getDouble("FBgBalance"))));
            info.setBizActual(new BigDecimal(Double.toString(rs.getDouble("FBizActual"))));
            lst.add(info);
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        return lst;
    }

    private List compareBgDataList(List lstSrc, List lstDest) {
        BgDataInfo srcInfo = null;
        BgDataInfo destInfo = null;
        ArrayList<Integer> lstDiff = new ArrayList<Integer>(100);
        int size = lstSrc.size();
        for (int i = 0; i < size; ++i) {
            srcInfo = (BgDataInfo)lstSrc.get(i);
            if (this.compareBgData(srcInfo, destInfo = (BgDataInfo)lstDest.get(i))) continue;
            lstDiff.add(new Integer(i));
        }
        return lstDiff;
    }

    private List compareBgDataList1(List lstSrc, List lstDest) {
        BgDataInfo srcInfo = null;
        BgDataInfo destInfo = null;
        ArrayList<Integer> lstDiff = new ArrayList<Integer>(100);
        int size = lstSrc.size();
        for (int i = 0; i < size; ++i) {
            srcInfo = (BgDataInfo)lstSrc.get(i);
            destInfo = (BgDataInfo)lstDest.get(i);
            if (srcInfo.getBgValue().compareTo(destInfo.getBgValue()) == 0) continue;
            lstDiff.add(new Integer(i));
        }
        return lstDiff;
    }

    private boolean compareBgData(BgDataInfo srcInfo, BgDataInfo destInfo) {
        if (srcInfo.getBgValue().compareTo(destInfo.getBgValue()) != 0) {
            return false;
        }
        if (srcInfo.getBgBalance().compareTo(destInfo.getBgBalance()) != 0) {
            return false;
        }
        return srcInfo.getBizActual().compareTo(destInfo.getBizActual()) == 0;
    }

    private void addPastRecord(Context ctx, Connection cn, String bgFormId, String originalBgFormId, List lstBgData, List lstSrc) throws EASBizException, BOSException {
        SimpleTimer st = new SimpleTimer();
        this.sub_addPastRecord(ctx, cn, lstSrc, lstBgData, originalBgFormId);
    }

    private void sub_addPastRecord(Context ctx, Connection conn, List lstSrc, List lstDest, String originalBgformId) throws EASBizException, BOSException {
        BgDataInfo srcInfo = null;
        BgDataInfo destInfo = null;
        ArrayList lstDiff = new ArrayList(100);
        boolean isExistPastRecord = false;
        String pastRecordId = "";
        int size = lstSrc.size();
        for (int i = 0; i < size; ++i) {
            BigDecimal value;
            srcInfo = (BgDataInfo)lstSrc.get(i);
            destInfo = (BgDataInfo)lstDest.get(i);
            BigDecimal srcValue = srcInfo.getBgValue();
            if (srcValue.compareTo(value = destInfo.getBgValue()) == 0) continue;
            if (!isExistPastRecord) {
                pastRecordId = this.buildPastRecord(ctx, conn, originalBgformId);
                isExistPastRecord = true;
            }
            this.buildPastData(ctx, conn, pastRecordId, srcInfo.getId().toString(), srcValue, value);
        }
    }

    private int getBgMethod(Connection conn, String bgFormId) throws EASBizException {
        int result = -1;
        String sql = "select a.fbgmethod from t_bg_bgtemplate a,t_bg_bgform b  where a.fid=b.fbgtemplateid and b.fid=?";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, bgFormId);
            rs = stmt.executeQuery();
            if (rs.next()) {
                result = rs.getInt(1);
            }
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                throw new BgInstantApproveException(BgInstantApproveException.DATABASEERROR, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)stmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        return result;
    }

    private boolean checkExistPastRecord(Connection conn, String bgFormId) throws EASBizException {
        boolean result = false;
        String sql = "select count(*) from t_bg_bgdata where fbgformid=?";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, bgFormId);
            rs = stmt.executeQuery();
            if (rs.next() && rs.getInt(1) > 0) {
                result = true;
            }
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                throw new BgInstantApproveException(BgInstantApproveException.DATABASEERROR, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)stmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        return result;
    }

    private String buildPastRecord(Context ctx, Connection conn, String bgFormId) throws EASBizException, BOSException {
        String sql = "insert into t_bg_bgpastrecord(FID,FSeq,FModifyDate,FBgFormID,FModifierID) values(?,?,?,?,?)";
        String fId = BOSUuid.create((BOSObjectType)new BgPastRecordInfo().getBOSType()).toString();
        int seq = this.getSeq(ctx, bgFormId);
        Timestamp time = new Timestamp(System.currentTimeMillis());
        String modifierId = ContextUtils.getUser((Context)ctx).getId().toString();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, fId);
            stmt.setInt(2, seq);
            stmt.setTimestamp(3, time);
            stmt.setString(4, bgFormId);
            stmt.setString(5, modifierId);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BgInstantApproveException(BgInstantApproveException.DATABASEERROR, e);
        }
        finally {
            SQLUtils.cleanup(rs, (Statement)stmt);
        }
        return fId;
    }

    private void buildPastData(Context ctx, Connection conn, String bgPastRecordId, String bgDataId, BigDecimal srcValue, BigDecimal value) throws EASBizException {
        String sql = "insert into t_bg_bgpastdata(FID,FPastValue,FBalance,FBgDataID,FBgPastRecordID,FDataSource) values(?,?,?,?,?,?)";
        String fId = BOSUuid.create((BOSObjectType)new BgPastDataInfo().getBOSType()).toString();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, fId);
            stmt.setBigDecimal(2, srcValue);
            stmt.setBigDecimal(3, value.subtract(srcValue));
            stmt.setString(4, bgDataId);
            stmt.setString(5, bgPastRecordId);
            stmt.setInt(6, 0);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BgInstantApproveException(BgInstantApproveException.DATABASEERROR, e);
        }
        finally {
            SQLUtils.cleanup(rs, (Statement)stmt);
        }
    }

    private int getSeq(Context ctx, String bgFormId) throws EASBizException, BOSException {
        int result = 1;
        String sql = "select max(fseq) from t_bg_bgpastrecord where fbgformid=?";
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection(ctx);
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, bgFormId);
            rs = stmt.executeQuery();
            if (rs.next()) {
                result = rs.getInt(1) + 1;
            }
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                throw new BgInstantApproveException(BgInstantApproveException.DATABASEERROR, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return result;
    }

    private void swapBgForm_all(Connection conn, String bgFormId, String originalBgFormId) throws EASBizException {
        SimpleTimer st = new SimpleTimer();
        String sql1 = "select fnumber,fcreatorid,flastupdateuserid,fcreatetime from t_bg_bgform where fid=?";
        String sql2 = "update t_bg_bgform set fnumber=? where fid=?";
        String sql3 = "update t_bg_bgform set fcreatorid=?,flastupdateuserid=?,fcreatetime=? where fid=?";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String number = "";
        String creatorId = "";
        String lastUserId = "";
        Timestamp createTime = null;
        String oriNumber = "";
        String oriCreatorId = "";
        String oriLastUserId = "";
        Timestamp oriCreateTime = null;
        try {
            stmt = conn.prepareStatement(sql1);
            stmt.setString(1, BOSUuid.read((String)bgFormId).toString());
            rs = stmt.executeQuery();
            if (rs.next()) {
                number = rs.getString(1);
                creatorId = rs.getString(2);
                lastUserId = rs.getString(3);
                createTime = rs.getTimestamp(4);
            }
            stmt = conn.prepareStatement(sql1);
            stmt.setString(1, BOSUuid.read((String)originalBgFormId).toString());
            rs = stmt.executeQuery();
            if (rs.next()) {
                oriNumber = rs.getString(1);
                oriCreatorId = rs.getString(2);
                oriLastUserId = rs.getString(3);
                oriCreateTime = rs.getTimestamp(4);
            }
            stmt = conn.prepareStatement(sql2);
            stmt.setString(1, number + "!@@##$%");
            stmt.setString(2, bgFormId);
            stmt.executeUpdate();
            stmt = conn.prepareStatement(sql2);
            stmt.setString(1, number);
            stmt.setString(2, originalBgFormId);
            stmt.executeUpdate();
            stmt = conn.prepareStatement(sql2);
            stmt.setString(1, oriNumber);
            stmt.setString(2, bgFormId);
            stmt.executeUpdate();
            stmt = conn.prepareStatement(sql3);
            stmt.setString(1, oriCreatorId);
            stmt.setString(2, oriLastUserId);
            stmt.setTimestamp(3, oriCreateTime);
            stmt.setString(4, bgFormId);
            stmt.executeUpdate();
            stmt = conn.prepareStatement(sql3);
            stmt.setString(1, creatorId);
            stmt.setString(2, lastUserId);
            stmt.setTimestamp(3, createTime);
            stmt.setString(4, originalBgFormId);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                throw new BgInstantApproveException(BgInstantApproveException.DATABASEERROR, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)stmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
    }

    private void swapBgForm_createtime(Connection conn, String bgFormId, String originalBgFormId, Timestamp time, Timestamp oriTime) throws EASBizException {
        String sql = "update t_bg_bgform set fcreatetime=? where fid=?";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement(sql);
            stmt.setTimestamp(1, oriTime);
            stmt.setString(2, bgFormId);
            stmt.executeUpdate();
            stmt = conn.prepareStatement(sql);
            stmt.setTimestamp(1, time);
            stmt.setString(2, originalBgFormId);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BgInstantApproveException(BgInstantApproveException.DATABASEERROR, e);
        }
        finally {
            SQLUtils.cleanup(rs, (Statement)stmt);
        }
    }

    private void swapBgForm_creator(Connection conn, String bgFormId, String originalBgFormId, String creatorId, String oriCreatorId) throws EASBizException {
        String sql = "update t_bg_bgform set fcreatorid=? where fid=?";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, oriCreatorId);
            stmt.setString(2, bgFormId);
            stmt.executeUpdate();
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, creatorId);
            stmt.setString(2, originalBgFormId);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BgInstantApproveException(BgInstantApproveException.DATABASEERROR, e);
        }
        finally {
            SQLUtils.cleanup(rs, (Statement)stmt);
        }
    }

    private void swapBgForm_lastUser(Connection conn, String bgFormId, String originalBgFormId, String userId, String oriUserId) throws EASBizException {
        String sql = "update t_bg_bgform set flastupdateuserid=? where fid=?";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, oriUserId);
            stmt.setString(2, bgFormId);
            stmt.executeUpdate();
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, userId);
            stmt.setString(2, originalBgFormId);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BgInstantApproveException(BgInstantApproveException.DATABASEERROR, e);
        }
        finally {
            SQLUtils.cleanup(rs, (Statement)stmt);
        }
    }

    private void updateState(Connection conn, String bgFormId, int state) throws EASBizException {
        String sql = "update t_bg_bgform set fstate=? where fid=?";
        PreparedStatement stmt = null;
        Object rs = null;
        try {
            stmt = conn.prepareStatement(sql);
            stmt.setInt(1, state);
            stmt.setString(2, bgFormId);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BgInstantApproveException(BgInstantApproveException.DATABASEERROR, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDefaultBalance(Connection conn, String bgFormId) throws SQLException {
        String sql = "update t_bg_bgdata set fbgbalance = fbgvalue , fbginitialvalue = fbgvalue\twhere t_bg_bgdata.fbgentryid in\t( select entry.fid from t_bg_bgentry entry inner join t_bg_bgform form on entry.fbgformid = form.fid where form.fid = ? )";
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, bgFormId);
            stmt.execute();
        }
        finally {
            SQLUtils.cleanup((Statement)stmt);
        }
    }

    private void updateBalance(Connection conn, BgFormInfo oriBgFormInfo, BgFormInfo bgFormInfo) throws EASBizException {
        BigDecimal zero = new BigDecimal("0");
        Iterator oriBgIter = oriBgFormInfo.getBgEntries().iterator();
        Iterator bgIter = bgFormInfo.getBgEntries().iterator();
        while (oriBgIter.hasNext() && bgIter.hasNext()) {
            BgEntryInfo oriEnInfo = (BgEntryInfo)oriBgIter.next();
            BgEntryInfo enInfo = (BgEntryInfo)bgIter.next();
            Iterator oriEnIter = oriEnInfo.getBgData().iterator();
            Iterator enIter = enInfo.getBgData().iterator();
            while (oriEnIter.hasNext() && enIter.hasNext()) {
                BgDataInfo oriData = (BgDataInfo)oriEnIter.next();
                BgDataInfo data = (BgDataInfo)enIter.next();
                if (oriData.getBgBalance() == null) {
                    this.updateValue(conn, oriData.getId().toString(), "fbgbalance", zero);
                }
                if (oriData.getBgValue() == null) {
                    this.updateValue(conn, oriData.getId().toString(), "fbgvalue", zero);
                }
                if (data.getBgValue() == null) {
                    this.updateValue(conn, data.getId().toString(), "fbgvalue", zero);
                }
                this.updateSumBalance(conn, oriData.getId().toString(), data.getId().toString());
            }
        }
    }

    private void updateBalance(Connection cn, String bgFormId, String originalBgFormId, List lstBgData, List lstSrc) throws EASBizException {
        SimpleTimer st = new SimpleTimer();
        List lstDiff = this.compareBgDataList1(lstSrc, lstBgData);
        if (lstDiff.size() == 0) {
            return;
        }
        this.sub_updateBalance(cn, lstSrc, lstBgData, lstDiff);
    }

    private void sub_updateBalance(Connection cn, List lstSrc, List lstBgData, List lstDiff) throws EASBizException {
        StringBuffer sb = new StringBuffer(20);
        sb.append("update t_bg_bgdata set fbgbalance = fbgbalance + ?-? ");
        sb.append("where fid=?");
        BgDataInfo info = null;
        BgDataInfo srcInfo = null;
        PreparedStatement pstmt = null;
        int index = -1;
        try {
            pstmt = cn.prepareStatement(sb.toString());
            int size = lstDiff.size();
            for (int i = 0; i < size; ++i) {
                index = (Integer)lstDiff.get(i);
                info = (BgDataInfo)lstBgData.get(index);
                srcInfo = (BgDataInfo)lstSrc.get(index);
                pstmt.setDouble(1, srcInfo.getBgValue().doubleValue());
                pstmt.setDouble(2, info.getBgValue().doubleValue());
                pstmt.setString(3, srcInfo.getId().toString());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BgInstantApproveException(BgInstantApproveException.DATABASEERROR, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt);
    }

    private void updateValue(Connection conn, String bgDataId, String fieldName, BigDecimal value) throws EASBizException {
        StringBuffer sb = new StringBuffer(20);
        sb.append("update t_bg_bgdata set ");
        sb.append(fieldName);
        sb.append("=? where fid=?");
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement(sb.toString());
            stmt.setBigDecimal(1, value);
            stmt.setString(2, bgDataId);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BgInstantApproveException(BgInstantApproveException.DATABASEERROR, e);
        }
        finally {
            SQLUtils.cleanup(rs, (Statement)stmt);
        }
    }

    private void updateSumBalance(Connection conn, String oriBgDataId, String bgDataId) throws EASBizException {
        StringBuffer sb = new StringBuffer(20);
        sb.append("update t_bg_bgdata set fbgbalance = fbgbalance + ");
        sb.append("(select fbgvalue from t_bg_bgdata where fid=? )");
        sb.append(" - ");
        sb.append("(select fbgvalue from t_bg_bgdata where fid=? )");
        sb.append("where fid=?");
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement(sb.toString());
            stmt.setString(1, oriBgDataId);
            stmt.setString(2, bgDataId);
            stmt.setString(3, oriBgDataId);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BgInstantApproveException(BgInstantApproveException.DATABASEERROR, e);
        }
        finally {
            SQLUtils.cleanup(rs, (Statement)stmt);
        }
    }

    public void swap(BgFormInfo oriInfo, BgFormInfo info) {
        Iterator oriBgIter = oriInfo.getBgEntries().iterator();
        Iterator bgIter = info.getBgEntries().iterator();
        BgDataInfo temp = new BgDataInfo();
        while (oriBgIter.hasNext() && bgIter.hasNext()) {
            BgEntryInfo oriEnInfo = (BgEntryInfo)oriBgIter.next();
            BgEntryInfo enInfo = (BgEntryInfo)bgIter.next();
            Iterator oriEnIter = oriEnInfo.getBgData().iterator();
            Iterator enIter = enInfo.getBgData().iterator();
            while (oriEnIter.hasNext() && enIter.hasNext()) {
                BgDataInfo oriData = (BgDataInfo)oriEnIter.next();
                BgDataInfo data = (BgDataInfo)enIter.next();
                this.subSwap(oriData, data, temp);
            }
        }
    }

    public void subSwap(BgDataInfo oriData, BgDataInfo data, BgDataInfo temp) {
        temp.setBgValue(data.getBgValue());
        temp.setBgBalance(data.getBgBalance());
        temp.setBizActual(data.getBizActual());
        data.setBgValue(oriData.getBgValue());
        data.setBgBalance(oriData.getBgBalance());
        data.setBizActual(oriData.getBizActual());
        oriData.setBgValue(temp.getBgValue());
    }

    public void rollSwap(Context ctx, BgFormInfo oriInfo, BgFormInfo info) throws BOSException, EASBizException {
        BgCycleTypeEnum rollCycle = oriInfo.getBgTemplate().getRollingBgCycle();
        BgCycleTypeEnum bgCycle = oriInfo.getBgTemplate().getBgCycle();
        String oriBgFormId = oriInfo.getId().toString();
        String bgFormId = info.getId().toString();
        if (bgCycle.equals((Object)BgCycleTypeEnum.Season) && rollCycle.equals((Object)BgCycleTypeEnum.Season)) {
            this.deal_quarter_quarter(ctx, bgFormId, rollCycle, bgCycle, oriInfo, info);
        } else {
            this.deal_number_number(ctx, bgFormId, rollCycle, bgCycle, oriInfo, info);
        }
    }

    public void deal_quarter_quarter(Context ctx, String bgFormId, BgCycleTypeEnum rollCycle, BgCycleTypeEnum bgCycle, BgFormInfo oriInfo, BgFormInfo info) throws BOSException, EASBizException {
        PeriodInfo lastedSptPeriod = this.getLastedSptPeriod(ctx, bgFormId, rollCycle);
        BgEntryCollection oriBgEntries = oriInfo.getBgEntries(lastedSptPeriod, rollCycle);
        Iterator iter = oriBgEntries.iterator();
        BgEntryInfo enInfo = null;
        while (iter.hasNext()) {
            enInfo = (BgEntryInfo)iter.next();
            enInfo.setIsLeafPeriod(false);
        }
        ICompanyOrgUnit ic = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo companyInfo = ic.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(info.getOrgUnit().getId()));
        PeriodCollection pColl = PeriodUtils.getPeriodc((Context)ctx, (int)lastedSptPeriod.getPeriodYear(), (int)lastedSptPeriod.getPeriodQuarter(), (CompanyOrgUnitInfo)companyInfo);
        Iterator pIter = pColl.iterator();
        PeriodInfo p1 = null;
        BgEntryCollection bgEntries = new BgEntryCollection();
        BgEntryCollection temp = new BgEntryCollection();
        while (pIter.hasNext()) {
            p1 = (PeriodInfo)pIter.next();
            bgEntries = info.getBgEntries(p1, bgCycle);
            temp = new BgEntryCollection();
            for (int i = 0; i < bgEntries.size(); ++i) {
                BgEntryInfo enInfo1 = bgEntries.get(i).cloneData();
                temp.add(enInfo1);
            }
            oriInfo.getBgEntries().addCollection(temp);
        }
        Vector result = this.getAfterPeriod(ctx, bgFormId, lastedSptPeriod);
        int size = result.size();
        IPeriod iPer = PeriodFactory.getLocalInstance((Context)ctx);
        PeriodInfo p2 = null;
        BgCycleTypeEnum cycle = null;
        for (int i = 0; i < size; ++i) {
            String[] str = (String[])result.elementAt(i);
            p2 = iPer.getPeriodInfo((IObjectPK)new ObjectUuidPK(str[0]));
            if (Integer.parseInt(str[1]) == 1) {
                cycle = BgCycleTypeEnum.Year;
            } else if (Integer.parseInt(str[1]) == 2) {
                cycle = BgCycleTypeEnum.Season;
            } else if (Integer.parseInt(str[1]) == 3) {
                cycle = BgCycleTypeEnum.Period;
            }
            BgEntryCollection entries1 = info.getBgEntries(p2, cycle);
            BgEntryCollection entries2 = oriInfo.getBgEntries(p2, cycle);
            if (entries2 == null || entries2.size() == 0) {
                temp = new BgEntryCollection();
                for (int j = 0; j < entries1.size(); ++j) {
                    BgEntryInfo enInfo1 = entries1.get(j).cloneData();
                    temp.add(enInfo1);
                }
                oriInfo.getBgEntries().addCollection(temp);
                continue;
            }
            Iterator iter1 = entries1.iterator();
            Iterator iter2 = entries2.iterator();
            BgDataInfo tempBgData = new BgDataInfo();
            while (iter1.hasNext() && iter2.hasNext()) {
                BgEntryInfo enInfo1 = (BgEntryInfo)iter1.next();
                BgEntryInfo enInfo2 = (BgEntryInfo)iter2.next();
                Iterator enIter1 = enInfo1.getBgData().iterator();
                Iterator enIter2 = enInfo2.getBgData().iterator();
                while (enIter1.hasNext() && enIter2.hasNext()) {
                    BgDataInfo data1 = (BgDataInfo)enIter1.next();
                    BgDataInfo data2 = (BgDataInfo)enIter2.next();
                    this.subSwap(data2, data1, tempBgData);
                }
            }
        }
    }

    public void deal_number_number(Context ctx, String bgFormId, BgCycleTypeEnum rollCycle, BgCycleTypeEnum bgCycle, BgFormInfo oriInfo, BgFormInfo info) throws BOSException, EASBizException {
        Vector result = this.getAllPeriod(ctx, bgFormId);
        int size = result.size();
        IPeriod iPer = PeriodFactory.getLocalInstance((Context)ctx);
        PeriodInfo p2 = null;
        BgCycleTypeEnum cycle = null;
        for (int i = 0; i < size; ++i) {
            String[] str = (String[])result.elementAt(i);
            p2 = iPer.getPeriodInfo((IObjectPK)new ObjectUuidPK(str[0]));
            if (Integer.parseInt(str[1]) == 1) {
                cycle = BgCycleTypeEnum.Year;
            } else if (Integer.parseInt(str[1]) == 2) {
                cycle = BgCycleTypeEnum.Season;
            } else if (Integer.parseInt(str[1]) == 3) {
                cycle = BgCycleTypeEnum.Period;
            }
            BgEntryCollection entries1 = info.getBgEntries(p2, cycle);
            BgEntryCollection entries2 = oriInfo.getBgEntries(p2, cycle);
            if (entries2 == null || entries2.size() == 0) {
                BgEntryCollection temp = new BgEntryCollection();
                for (int j = 0; j < entries1.size(); ++j) {
                    BgEntryInfo enInfo1 = entries1.get(j).cloneData();
                    temp.add(enInfo1);
                }
                oriInfo.getBgEntries().addCollection(temp);
                continue;
            }
            Iterator iter1 = entries1.iterator();
            Iterator iter2 = entries2.iterator();
            BgDataInfo temp = new BgDataInfo();
            while (iter1.hasNext() && iter2.hasNext()) {
                BgEntryInfo enInfo1 = (BgEntryInfo)iter1.next();
                BgEntryInfo enInfo2 = (BgEntryInfo)iter2.next();
                Iterator enIter1 = enInfo1.getBgData().iterator();
                Iterator enIter2 = enInfo2.getBgData().iterator();
                while (enIter1.hasNext() && enIter2.hasNext()) {
                    BgDataInfo data1 = (BgDataInfo)enIter1.next();
                    BgDataInfo data2 = (BgDataInfo)enIter2.next();
                    this.subSwap(data2, data1, temp);
                }
            }
        }
    }

    public PeriodInfo getLastedSptPeriod(Context ctx, String bgFormId, BgCycleTypeEnum rollCycle) throws BOSException, EASBizException {
        PeriodInfo pInfo = null;
        StringBuffer buffer = new StringBuffer(60);
        buffer.append(" select a.FPeriodId from T_BG_BgEntry a,T_BD_Period b ");
        buffer.append(" where a.FPeriodId=b.FId and a.FIsLeafPeriod=0 and a.FBgCycle=? and a.FBgFormId=? ");
        buffer.append(" order by b.FPeriodYear desc ,b.FPeriodQuarter desc,b.FPeriodNumber desc ");
        String sql = buffer.toString();
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String pId = null;
        try {
            conn = this.getConnection(ctx);
            stmt = conn.prepareStatement(sql);
            stmt.setInt(1, rollCycle.getValue());
            stmt.setString(2, bgFormId);
            rs = stmt.executeQuery();
            rs.next();
            pId = rs.getString(1);
        }
        catch (SQLException e) {
            try {
                throw new BgInstantApproveException(BgInstantApproveException.DATABASEERROR, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        pInfo = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(pId));
        return pInfo;
    }

    public Vector getAfterPeriod(Context ctx, String bgFormId, PeriodInfo period) throws BOSException, EASBizException {
        Vector<String[]> result = new Vector<String[]>();
        StringBuffer buffer = new StringBuffer(60);
        buffer.append(" select distinct a.FPeriodId,a.FBgCycle from T_BG_BgEntry a,T_BD_Period b ");
        buffer.append(" where a.FPeriodId=b.FId and a.FBgFormId=? ");
        buffer.append(" and (b.FPeriodYear>? or b.FPeriodQuarter>?) ");
        String sql = buffer.toString();
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        Object pId = null;
        try {
            conn = this.getConnection(ctx);
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, bgFormId);
            stmt.setInt(2, period.getPeriodYear());
            stmt.setInt(3, period.getPeriodQuarter());
            rs = stmt.executeQuery();
            while (rs.next()) {
                String[] str = new String[]{rs.getString(1), "" + rs.getInt(2)};
                result.add(str);
            }
        }
        catch (SQLException e) {
            try {
                throw new BgInstantApproveException(BgInstantApproveException.DATABASEERROR, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return result;
    }

    public Vector getAllPeriod(Context ctx, String bgFormId) throws BOSException, EASBizException {
        Vector<String[]> result = new Vector<String[]>();
        StringBuffer buffer = new StringBuffer(60);
        buffer.append(" select distinct a.FPeriodId,a.FBgCycle from T_BG_BgEntry a,T_BD_Period b ");
        buffer.append(" where a.FPeriodId=b.FId and a.FBgFormId=? ");
        String sql = buffer.toString();
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        Object pId = null;
        try {
            conn = this.getConnection(ctx);
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, bgFormId);
            rs = stmt.executeQuery();
            while (rs.next()) {
                String[] str = new String[]{rs.getString(1), "" + rs.getInt(2)};
                result.add(str);
            }
        }
        catch (SQLException e) {
            try {
                throw new BgInstantApproveException(BgInstantApproveException.DATABASEERROR, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return result;
    }

    @Override
    protected void _executeWfApprove(Context ctx, String bgFormId) throws BOSException, EASBizException {
        this.executeApprove(ctx, bgFormId);
    }

    @Override
    protected void _reverseApprove(Context ctx, String bgFormId) throws BOSException, EASBizException {
        if (BgAdjustFormFactory.getLocalInstance(ctx).checkAdjust(bgFormId)) {
            throw new BgInstantApproveException(BgInstantApproveException.HASADJUSTED);
        }
        Connection conn = this.getConnection(ctx);
        String checkHaveBizActualSql = "SELECT COUNT(FID) AS theCount FROM T_BG_BgCtrlDetail WHERE FBgFormID = ?";
        String checkIsRefByIncSql = "select count(a.fid) AS theCount from t_bg_bgdata a,t_bg_bgentry b,t_bg_bgform c where a.fbgentryid=b.fid  and b.fbgformid = c.fid  and c.fid=?  and a.fid in (select fbgdataid from t_bg_bgincreasereqformentry a,t_bg_bgincreasereqform b where a.fbillid=b.fid)";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement(checkHaveBizActualSql);
            stmt.setString(1, bgFormId);
            rs = stmt.executeQuery();
            if (!rs.next()) {
                throw new BgBizException(BgBizException.GETDATA, new Object[]{"BgForm"});
            }
            int theCount = rs.getInt("theCount");
            if (theCount > 0) {
                throw new BgInstantApproveException(BgInstantApproveException.REVERSEAPPROVENOTALLOW);
            }
            stmt = conn.prepareStatement(checkIsRefByIncSql);
            stmt.setString(1, bgFormId);
            rs = stmt.executeQuery();
            if (!rs.next()) {
                throw new BgBizException(BgBizException.GETDATA, new Object[]{"BgForm"});
            }
            theCount = rs.getInt("theCount");
            if (theCount > 0) {
                throw new BgInstantApproveException(BgInstantApproveException.HASREFBYINC);
            }
            this.signBgForm(conn, bgFormId, 1);
        }
        catch (SQLException e) {
            try {
                throw new BgBizException(BgBizException.GETDATA, e, new Object[]{"BgForm"});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        BgInstantApproveInfo approveInfo = new BgInstantApproveInfo();
        approveInfo.setApproveTargetType(BgInstantApproveTargetEnum.BgForm);
        approveInfo.setApproveTargetID(BOSUuid.read((String)bgFormId));
        approveInfo.setIsApproved(BgApproveTypeEnum.Reverse);
        BgInstantApproveFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)approveInfo);
    }

    public void moveBgEntry(Context ctx, String bgFormId, String originalBgFormId) throws BOSException, EASBizException {
        SimpleTimer st = new SimpleTimer();
        Connection conn = this.getConnection(ctx);
        StringBuffer sql = new StringBuffer(40);
        sql.append("select * from  t_bg_bgentry where fbgformid= ? ");
        sql.append("and fperiodid not in (select fperiodid from  t_bg_bgentry where fbgformid=?)");
        StringBuffer sql1 = new StringBuffer(70);
        sql1.append("insert into t_bg_bgentry values(?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        StringBuffer sql2 = new StringBuffer(70);
        sql2.append("select * from t_bg_bgdata where fbgentryid=?");
        StringBuffer sql3 = new StringBuffer(70);
        sql3.append("insert into t_bg_bgdata values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        PreparedStatement stmt = null;
        PreparedStatement stmt1 = null;
        PreparedStatement stmt2 = null;
        PreparedStatement stmt3 = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement(sql.toString());
            stmt1 = conn.prepareStatement(sql1.toString());
            stmt.setString(1, bgFormId.toString());
            stmt.setString(2, originalBgFormId.toString());
            rs = stmt.executeQuery();
            BOSObjectType entryType = new BgEntryInfo().getBOSType();
            BOSObjectType dataType = new BgDataInfo().getBOSType();
            Vector<String[]> vec = new Vector<String[]>();
            while (rs.next()) {
                BOSUuid id = BOSUuid.create((BOSObjectType)entryType);
                String[] temp = new String[]{rs.getString(1), id.toString()};
                vec.add(temp);
                stmt1.setString(1, id.toString());
                stmt1.setInt(2, rs.getInt(2));
                stmt1.setInt(3, rs.getInt(3));
                stmt1.setString(4, rs.getString(4));
                stmt1.setString(5, rs.getString(5));
                stmt1.setString(6, rs.getString(6));
                stmt1.setString(7, rs.getString(7));
                stmt1.setString(8, rs.getString(8));
                stmt1.setString(9, rs.getString(9));
                stmt1.setString(10, rs.getString(10));
                stmt1.setString(11, originalBgFormId);
                stmt1.setInt(12, rs.getInt(12));
                stmt1.setInt(13, rs.getInt(13));
                stmt1.setInt(14, rs.getInt(14));
                stmt1.addBatch();
            }
            stmt1.executeBatch();
            int size = vec.size();
            if (size != 0) {
                for (int i = 0; i < size; ++i) {
                    String[] result = (String[])vec.get(i);
                    stmt2 = conn.prepareStatement(sql2.toString());
                    stmt3 = conn.prepareStatement(sql3.toString());
                    stmt2.setString(1, result[0]);
                    rs = stmt2.executeQuery();
                    while (rs.next()) {
                        BOSUuid id = BOSUuid.create((BOSObjectType)dataType);
                        stmt3.setString(1, id.toString());
                        stmt3.setInt(2, rs.getInt(2));
                        stmt3.setBigDecimal(3, rs.getBigDecimal(3));
                        stmt3.setBigDecimal(4, rs.getBigDecimal(4));
                        stmt3.setBigDecimal(5, rs.getBigDecimal(5));
                        stmt3.setString(6, rs.getString(6));
                        stmt3.setInt(7, rs.getInt(7));
                        stmt3.setInt(8, rs.getInt(8));
                        stmt3.setBigDecimal(9, rs.getBigDecimal(9));
                        stmt3.setString(10, rs.getString(10));
                        stmt3.setString(11, rs.getString(11));
                        stmt3.setString(12, rs.getString(12));
                        stmt3.setString(13, result[1]);
                        stmt3.setBigDecimal(14, rs.getBigDecimal(14));
                        stmt3.setBigDecimal(15, rs.getBigDecimal(15));
                        stmt3.setBigDecimal(16, rs.getBigDecimal(16));
                        stmt3.setBigDecimal(17, rs.getBigDecimal(17));
                        stmt3.setString(18, rs.getString(18));
                        stmt3.addBatch();
                    }
                    stmt3.executeBatch();
                }
            }
        }
        catch (SQLException e) {
            try {
                throw new BgBizException(BgBizException.GETDATA, e, new Object[]{"BgForm"});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                SQLUtils.cleanup((Statement)stmt);
                SQLUtils.cleanup(stmt1);
                SQLUtils.cleanup(stmt2);
                SQLUtils.cleanup(stmt3);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        SQLUtils.cleanup((Statement)stmt);
        SQLUtils.cleanup((Statement)stmt1);
        SQLUtils.cleanup(stmt2);
        SQLUtils.cleanup(stmt3);
        SQLUtils.cleanup((Connection)conn);
    }

    public BgEntryCollection compare(BgFormInfo oriInfo, BgFormInfo info) {
        BgEntryCollection oriColl = oriInfo.getBgEntries();
        BgEntryCollection coll = info.getBgEntries();
        BgEntryCollection addedColl = new BgEntryCollection();
        Iterator iter = coll.iterator();
        block0: while (iter.hasNext()) {
            BgEntryInfo preEntry;
            BgEntryInfo curEntry = (BgEntryInfo)iter.next();
            OneVOPredicate predicBgItem1 = new OneVOPredicate("bgItem1", curEntry.getBgItem1());
            OneVOPredicate predicBgItem2 = new OneVOPredicate("bgItem2", curEntry.getBgItem2());
            OneVOPredicate predicBgItem3 = new OneVOPredicate("bgItem3", curEntry.getBgItem3());
            OneVOPredicate predicBgItem4 = new OneVOPredicate("bgItem4", curEntry.getBgItem4());
            OneVOPredicate predicBgItem5 = new OneVOPredicate("bgItem5", curEntry.getBgItem5());
            OneVOPredicate predicBgItem6 = new OneVOPredicate("bgItem6", curEntry.getBgItem6());
            OneVOPredicate predicPeriod = new OneVOPredicate("period", curEntry.getPeriod());
            AndVOPredicate pre = new AndVOPredicate(new VOPredicate[]{predicBgItem1, predicBgItem2, predicBgItem3, predicBgItem4, predicBgItem5, predicBgItem6, predicPeriod});
            int size = oriColl.size();
            int index = 0;
            for (int i = 0; i < size && !pre.evaluate((IObjectValue)(preEntry = oriColl.get(i))); ++i) {
                if (index == size - 1) {
                    curEntry.setId(null);
                    BgDataCollection dataColl = curEntry.getBgData();
                    int length = dataColl.size();
                    for (int j = 0; j < length; ++j) {
                        BgDataInfo dataInfo = dataColl.get(j);
                        dataInfo.setId(null);
                    }
                    addedColl.add(curEntry);
                    continue block0;
                }
                ++index;
            }
        }
        if (addedColl.size() != 0) {
            return addedColl;
        }
        return null;
    }

    public BgEntryCollection compareDiff(Context ctx, BgFormInfo oriInfo, BgFormInfo info) throws BOSException {
        BgEntryCollection oriColl = oriInfo.getBgEntries();
        BgEntryCollection coll = info.getBgEntries();
        BgEntryCollection addedColl = new BgEntryCollection();
        HashSearchEngine engine = new HashSearchEngine(BgORMEngine.getObjectValue(oriColl.toArray()), new String[]{"bgItem1", "bgItem2", "bgItem3", "bgItem4", "bgItem5", "bgItem6", "period"});
        int size = coll.size();
        Vector<BgEntryInfo> removeColl = new Vector<BgEntryInfo>();
        for (int i = 0; i < size; ++i) {
            BgEntryInfo curEntry = coll.get(i);
            if (engine.evaluate((IObjectValue)curEntry)) continue;
            removeColl.add(curEntry);
        }
        HashSearchEngine engine1 = new HashSearchEngine(BgORMEngine.getObjectValue(coll.toArray()), new String[]{"bgItem1", "bgItem2", "bgItem3", "bgItem4", "bgItem5", "bgItem6", "period"});
        int size1 = oriColl.size();
        Vector<BgEntryInfo> removeColl1 = new Vector<BgEntryInfo>();
        for (int i = 0; i < size1; ++i) {
            BgEntryInfo curEntry = oriColl.get(i);
            if (engine1.evaluate((IObjectValue)curEntry)) continue;
            removeColl1.add(curEntry);
        }
        if (removeColl.size() != 0) {
            Object ob;
            BgPastRecordInfo reInfo = new BgPastRecordInfo();
            reInfo.setId(null);
            try {
                reInfo.setSeq(this.getSeq(ctx, oriInfo.getId().toString()) + 1);
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            reInfo.setBgForm(oriInfo);
            reInfo.setModifier(ContextUtils.getUser((Context)ctx));
            reInfo.setModifyDate(new Date(System.currentTimeMillis()));
            int ln = removeColl.size();
            BigDecimal zero = new BigDecimal(0);
            for (int i = 0; i < ln && (ob = removeColl.get(i)) != null; ++i) {
                BgEntryInfo bgEntry = (BgEntryInfo)ob;
                coll.remove(bgEntry);
                bgEntry.setId(null);
                BgDataCollection dataColl = bgEntry.getBgData();
                int length = dataColl.size();
                for (int j = 0; j < length; ++j) {
                    BgDataInfo dataInfo = dataColl.get(j);
                    dataInfo.setBgBalance(dataInfo.getBgValue());
                    dataInfo.setId(null);
                    BgPastDataInfo pDaInfo = new BgPastDataInfo();
                    pDaInfo.setId(null);
                    pDaInfo.setPastValue(zero);
                    pDaInfo.setBalance(zero.subtract(dataInfo.getBgValue()));
                    pDaInfo.setBgData(dataInfo);
                    pDaInfo.setBgPastRecord(reInfo);
                    pDaInfo.setDataSource(BgFormDataSourceEnum.ADJUST);
                    reInfo.getPastData().add(pDaInfo);
                }
                addedColl.add(bgEntry);
            }
            oriInfo.getPastRecords().add(reInfo);
        }
        if (removeColl1.size() != 0) {
            Object ob;
            int ln = removeColl1.size();
            for (int i = 0; i < ln && (ob = removeColl1.get(i)) != null; ++i) {
                BgEntryInfo bgEntry = (BgEntryInfo)ob;
                oriColl.remove(bgEntry);
                this.deletePastData(ctx, bgEntry.getId().toString());
            }
        }
        if (addedColl.size() != 0) {
            return addedColl;
        }
        return null;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deletePastData(Context ctx, String entryId) throws BOSException {
        Connection conn = null;
        PreparedStatement sm = null;
        try {
            conn = this.getConnection(ctx);
            String strSql = "delete from t_bg_bgpastData where fbgdataid in(select fid from t_bg_bgdata where fbgentryid=?)";
            sm = conn.prepareStatement(strSql);
            sm.setString(1, entryId);
            sm.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
                catch (SQLDataException e2) {
                    throw new BOSException((Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(sm, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)sm, (Connection)conn);
    }

    public void added_swap(Context ctx, BgFormInfo oriInfo, BgFormInfo info) throws EASBizException, BOSException {
        String[] bgFormAry = new String[]{"name", "number", "dataSource", "hasEffected"};
        String[] bgEntryAry = new String[]{"bgItem1", "bgItem2", "bgItem3", "bgItem4", "bgItem5", "bgItem6", "isLeafPeriod", "entryType"};
        String[] bgDataAry = new String[]{"bgValue", "bgBalance"};
        String[] bgPastRecAry = new String[]{"modifyDate"};
        String[] bgPstDataAry = new String[]{"balance"};
        BgFormDAHelper.addModelLisener(oriInfo, bgFormAry, bgEntryAry, bgDataAry, bgPastRecAry, bgPstDataAry);
        BgFormDAHelper.addModelLisener(info, bgFormAry, bgEntryAry, bgDataAry, bgPastRecAry, bgPstDataAry);
        BgEntryCollection addedColl = this.compareDiff(ctx, oriInfo, info);
        oriInfo.getBgEntries().addCollection(addedColl);
        BgFormDAHelper.updateInfo(ctx, oriInfo);
        BgFormDAHelper.updateInfo(ctx, info);
    }

    public void deal_all(Context ctx, BgFormInfo newInfo, BgFormInfo oldInfo) {
        BgEntryCollection oriColl = oldInfo.getBgEntries();
        BgEntryCollection coll = newInfo.getBgEntries();
        boolean hasNewPastRecord = false;
        BgPastRecordInfo reInfo = new BgPastRecordInfo();
        HashSearchEngine engine = new HashSearchEngine(BgORMEngine.getObjectValue(coll.toArray()), new String[]{"bgCycle", "period", "bgItem1", "bgItem2", "bgItem3", "bgItem4", "bgItem5", "bgItem6"});
        Iterator iter1 = oriColl.iterator();
        while (iter1.hasNext()) {
            BgEntryInfo preEntry = (BgEntryInfo)iter1.next();
            if (!engine.evaluate((IObjectValue)preEntry)) continue;
            BgDataCollection daColl = ((BgEntryInfo)engine.getResult()).getBgData();
            HashSearchEngine engine1 = new HashSearchEngine(BgORMEngine.getObjectValue(daColl.toArray()), new String[]{"elementNumber", "currency", "bgElement"});
            Iterator iter2 = preEntry.getBgData().iterator();
            while (iter2.hasNext()) {
                BgDataInfo preData = (BgDataInfo)iter2.next();
                if (!engine1.evaluate((IObjectValue)preData)) continue;
                BgDataInfo curData = (BgDataInfo)engine1.getResult();
                if (preData.getBgValue().compareTo(curData.getBgValue()) == 0) continue;
                if (!hasNewPastRecord) {
                    reInfo.setId(null);
                    try {
                        reInfo.setSeq(this.getSeq(ctx, oldInfo.getId().toString()) + 1);
                    }
                    catch (EASBizException e) {
                        e.printStackTrace();
                    }
                    catch (BOSException e) {
                        e.printStackTrace();
                    }
                    reInfo.setBgForm(oldInfo);
                    reInfo.setModifier(ContextUtils.getUser((Context)ctx));
                    reInfo.setModifyDate(new Date(System.currentTimeMillis()));
                }
                BgPastDataInfo pDaInfo = new BgPastDataInfo();
                pDaInfo.setId(null);
                pDaInfo.setPastValue(preData.getBgValue());
                pDaInfo.setBalance(curData.getBgValue().subtract(preData.getBgValue()));
                pDaInfo.setBgData(preData);
                pDaInfo.setBgPastRecord(reInfo);
                pDaInfo.setDataSource(BgFormDataSourceEnum.ADJUST);
                reInfo.getPastData().add(pDaInfo);
                BigDecimal preValue = preData.getBgValue();
                BigDecimal aa = curData.getBgValue().subtract(preData.getBgValue());
                preData.setBgBalance(preData.getBgBalance().add(aa));
                preData.setBgValue(curData.getBgValue());
                curData.setBgValue(preValue);
            }
        }
        oldInfo.getPastRecords().add(reInfo);
    }

    public void deal_all_update(Context ctx, BgFormInfo newInfo, BgFormInfo oldInfo) throws EASBizException {
        SimpleTimer st = new SimpleTimer();
        String[] bgFormAry = new String[]{"name", "number", "dataSource", "hasEffected"};
        String[] bgEntryAry = new String[]{"bgItem1", "bgItem2", "bgItem3", "bgItem4", "bgItem5", "bgItem6", "isLeafPeriod", "entryType"};
        String[] bgDataAry = new String[]{"bgValue", "bgBalance"};
        String[] bgPastRecAry = new String[]{"modifyDate"};
        String[] bgPstDataAry = new String[]{"balance"};
        BgFormDAHelper.addModelLisener(oldInfo, bgFormAry, bgEntryAry, bgDataAry, bgPastRecAry, bgPstDataAry);
        BgFormDAHelper.addModelLisener(newInfo, bgFormAry, bgEntryAry, bgDataAry, bgPastRecAry, bgPstDataAry);
        this.deal_all(ctx, newInfo, oldInfo);
        BgFormDAHelper.updateInfo(ctx, oldInfo);
        BgFormDAHelper.updateInfo(ctx, newInfo);
    }

    @Override
    protected void _executeWFApproveing(Context ctx, BOSUuid bgFormId) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = this.getConnection(ctx);
            String strSql = "update T_BG_BgForm set FState = 14 where fid = ?";
            ps = conn.prepareStatement(strSql);
            ps.setString(1, bgFormId.toString());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String _getBgItemIds_ad(Context ctx, String bgFormId) throws BOSException, EASBizException {
        String result = "";
        Connection cn = null;
        try {
            cn = this.getConnection(ctx);
            String id = this.getOriginalBgFormID(cn, bgFormId);
            result = this._getBgItemIds(ctx, id);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
        return result;
    }

    @Override
    protected String _getBgItemIds(Context ctx, String bgFormId) throws BOSException, EASBizException {
        String result = "";
        Connection conn = null;
        PreparedStatement sm = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection(ctx);
            String strSql = "SELECT DISTINCT T_BG_BgItem.FItemID,T_BG_BgItem.FID FROM T_BG_BgItem INNER JOIN  T_BG_BgEntry ON (T_BG_BgItem.FID = T_BG_BgEntry.FBgItem4ID OR  T_BG_BgItem.FID = T_BG_BgEntry.FBgItem5ID OR  T_BG_BgItem.FID = T_BG_BgEntry.FBgItem6ID OR  T_BG_BgItem.FID = T_BG_BgEntry.FBgItem1ID OR  T_BG_BgItem.FID = T_BG_BgEntry.FBgItem2ID OR  T_BG_BgItem.FID = T_BG_BgEntry.FBgItem3ID) AND  T_BG_BgEntry.FBgFormID = ?";
            sm = conn.prepareStatement(strSql);
            sm.setString(1, bgFormId);
            rs = sm.executeQuery();
            while (rs.next()) {
                result = result + "," + rs.getString(1) + "," + rs.getString(2);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, sm, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)sm, (Connection)conn);
        return result;
    }
}

