/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.bg.BgDataInfo;
import com.kingdee.eas.ma.bg.BgEntryCollection;
import com.kingdee.eas.ma.bg.BgEntryInfo;
import com.kingdee.eas.ma.bg.BgFormDAFactory;
import com.kingdee.eas.ma.bg.BgFormInfo;
import com.kingdee.eas.ma.bg.BgKDSInfo;
import com.kingdee.eas.ma.bg.BgManagerFactory;
import com.kingdee.eas.ma.bg.BgORMEngine;
import com.kingdee.eas.ma.bg.BgORMException;
import com.kingdee.eas.ma.bg.IBgFormDA;
import com.kingdee.eas.ma.bg.IBgManager;
import com.kingdee.eas.ma.bg.app.AbstractBgKDSControllerBean;
import com.kingdee.util.db.SQLUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;

public class BgKDSControllerBean
extends AbstractBgKDSControllerBean {
    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BgKDSInfo vo = (BgKDSInfo)model;
        Connection connection = null;
        PreparedStatement ps = null;
        String sql = " insert into t_bg_bgkds (FID, FBgEntryArray, FBgFormID) values(?, ?, ?) ";
        String fid = "";
        if (vo.getId() == null) {
            vo.setId(BOSUuid.create((BOSObjectType)vo.getBOSType()));
        }
        fid = vo.getId().toString();
        byte[] bgEntryArray = vo.getBgEntryArray();
        String bgFormId = vo.getBgForm().getId().toString();
        try {
            connection = this.getConnection(ctx);
            ps = connection.prepareStatement(sql);
            ps.setString(1, fid);
            ps.setBinaryStream(2, (InputStream)new ByteArrayInputStream(bgEntryArray), bgEntryArray.length);
            ps.setString(3, bgFormId);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)connection);
        return new ObjectUuidPK(fid);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        InputStream is;
        PreparedStatement ps;
        Connection connection;
        ResultSet rs;
        BgKDSInfo vo;
        block14: {
            String fid = pk.toString();
            vo = new BgKDSInfo();
            vo.setId(BOSUuid.read((String)fid));
            rs = null;
            connection = null;
            ps = null;
            String sql = " select FBgEntryArray, FBgFormId from T_BG_BgKDS where FID=? ";
            is = null;
            try {
                connection = this.getConnection(ctx);
                ps = connection.prepareStatement(sql);
                ps.setString(1, fid);
                rs = ps.executeQuery();
                if (!rs.next()) break block14;
                is = rs.getBinaryStream("FBgEntryArray");
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buffer = new byte[128];
                try {
                    int len = is.read(buffer);
                    while (len != -1) {
                        baos.write(buffer);
                        len = is.read(buffer);
                    }
                }
                catch (IOException e1) {
                    throw new SQLException(e1.getMessage());
                }
                byte[] byteArrayBgEntry = baos.toByteArray();
                vo.setBgEntryArray(byteArrayBgEntry);
                String bgFormId = rs.getString("FBgFormId");
                if (bgFormId != null) {
                    BgFormInfo bgFormInfo = new BgFormInfo();
                    bgFormInfo.setId(BOSUuid.read((String)bgFormId));
                    vo.setBgForm(bgFormInfo);
                }
            }
            catch (SQLException e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            is.close();
                        }
                    }
                    catch (IOException e2) {
                        throw new BOSException(e2.getCause().getMessage());
                    }
                    SQLUtils.cleanup(rs, (Statement)ps, (Connection)connection);
                    throw throwable;
                }
            }
        }
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (IOException e) {
            throw new BOSException(e.getCause().getMessage());
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)connection);
        return vo;
    }

    @Override
    protected void _delete(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        Connection connection = null;
        PreparedStatement ps = null;
        String sql = " delete from t_bg_bgkds where fid=? ";
        String fid = id.toString();
        try {
            connection = this.getConnection(ctx);
            ps = connection.prepareStatement(sql);
            ps.setString(1, fid);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)connection);
    }

    @Override
    protected void _addnewWF(Context ctx, BOSUuid id) throws BOSException, EASBizException {
    }

    @Override
    protected BOSUuid _getBgKDSByBgForm(Context ctx, BOSUuid bgFormId) throws BOSException, EASBizException {
        BOSUuid bgKDSId = null;
        String fid = bgFormId.toString();
        ResultSet rs = null;
        Connection connection = null;
        PreparedStatement ps = null;
        String sql = " select FID from T_BG_BgKDS where FBgFormId=? ";
        try {
            connection = this.getConnection(ctx);
            ps = connection.prepareStatement(sql);
            ps.setString(1, fid);
            rs = ps.executeQuery();
            if (rs.next()) {
                String tmp = rs.getString("FID");
                bgKDSId = BOSUuid.read((String)tmp);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)connection);
        return bgKDSId;
    }

    @Override
    protected void _updateBgFormState(Context ctx, BOSUuid bgFormId, int bgFormState) throws BOSException, EASBizException {
        ResultSet rs = null;
        Connection connection = null;
        PreparedStatement ps = null;
        String sql = "update T_BG_BgForm set FState=?  where fid =?";
        String fid = bgFormId.toString();
        try {
            connection = this.getConnection(ctx);
            ps = connection.prepareStatement(sql);
            ps.setInt(1, bgFormState);
            ps.setString(2, fid);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rs, (Statement)ps, (Connection)connection);
    }

    @Override
    protected void _addnewBgForm(Context ctx, BOSUuid bgFormId) throws BOSException, EASBizException {
        int state = this.getBgFormState(ctx, bgFormId);
        if (state == 1) {
            this._updateBgForm(ctx, bgFormId);
            return;
        }
        BOSUuid id = this._getBgKDSByBgForm(ctx, bgFormId);
        BgKDSInfo kdsInfo = (BgKDSInfo)this._getValue(ctx, (IObjectPK)new ObjectUuidPK(id));
        Object connection = null;
        Object ps = null;
        BgDataInfo[] bgDataAry = new BgDataInfo[]{};
        BgEntryInfo[] bgEntryAry = new BgEntryInfo[]{};
        try {
            byte[] byteArray = kdsInfo.getBgEntryArray();
            ByteArrayInputStream bais = new ByteArrayInputStream(byteArray);
            ObjectInputStream ois = new ObjectInputStream(bais);
            ArrayList entryColl = (ArrayList)ois.readObject();
            BgORMEngine.addnewVO(ctx, (IObjectValue[])entryColl.toArray(bgEntryAry));
            ois.close();
            bais.close();
            ArrayList<BgDataInfo> dataColl = new ArrayList<BgDataInfo>();
            for (BgEntryInfo bgEntry : entryColl) {
                Iterator dataIter = bgEntry.getBgData().iterator();
                while (dataIter.hasNext()) {
                    BgDataInfo bgData = (BgDataInfo)dataIter.next();
                    dataColl.add(bgData);
                }
            }
            BgORMEngine.addnewVO(ctx, (IObjectValue[])dataColl.toArray(bgDataAry));
        }
        catch (IOException e) {
            throw new BOSException((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _deleteWF(Context ctx, BOSUuid id) throws BOSException, EASBizException {
    }

    @Override
    protected void _deleteBgForm(Context ctx, BOSUuid bgFormId) throws BOSException, EASBizException {
        String delBgVersion = "delete from t_bg_bgversion  where FOriginalBgFormID = ? OR FAdaptedBgFormID = ? OR FPreBgFormID = ?";
        String delPastRecode = " DELETE FROM T_BG_BgPastData WHERE (FBgPastRecordID IN( SELECT fid FROM T_BG_BgPastRecord WHERE fbgformid = ?))";
        String delPastData = " DELETE FROM T_BG_BgPastRecord WHERE (FBgFormID = ?)";
        String delBgDataSql = " DELETE FROM T_BG_BgData  WHERE (FBgEntryID IN ( SELECT fid FROM t_bg_bgentry WHERE fbgformid = ?))";
        String delBgEntrySql = " DELETE FROM T_BG_BgEntry WHERE (FBgFormID = ?)";
        String delBgFormLogSql = " DELETE FROM t_bg_bgformlog WHERE (FBgFormID = ?)";
        String delBgPostilSql = " DELETE FROM T_BG_BgPostil WHERE (FBgFormID = ?)";
        String delBgFormSql = " DELETE FROM T_BG_BgForm WHERE (FID = ?)";
        String delBgKDSSql = " DELETE FROM T_BG_BgKDS WHERE (FBgFormID = ?)";
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.getConnection(ctx);
            stmt = conn.prepareStatement(delBgVersion);
            stmt.setString(1, bgFormId.toString());
            stmt.setString(2, bgFormId.toString());
            stmt.setString(3, bgFormId.toString());
            stmt.executeUpdate();
            stmt = conn.prepareStatement(delPastRecode);
            stmt.setString(1, bgFormId.toString());
            stmt.executeUpdate();
            stmt = conn.prepareStatement(delPastData);
            stmt.setString(1, bgFormId.toString());
            stmt.executeUpdate();
            stmt = conn.prepareStatement(delBgDataSql);
            stmt.setString(1, bgFormId.toString());
            stmt.executeUpdate();
            stmt = conn.prepareStatement(delBgEntrySql);
            stmt.setString(1, bgFormId.toString());
            stmt.executeUpdate();
            stmt = conn.prepareStatement(delBgFormLogSql);
            stmt.setString(1, bgFormId.toString());
            stmt.executeUpdate();
            stmt = conn.prepareStatement(delBgPostilSql);
            stmt.setString(1, bgFormId.toString());
            stmt.executeUpdate();
            stmt = conn.prepareStatement(delBgKDSSql);
            stmt.setString(1, bgFormId.toString());
            stmt.executeUpdate();
            stmt = conn.prepareStatement(delBgFormSql);
            stmt.setString(1, bgFormId.toString());
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                ObjectUuidPK pk = new ObjectUuidPK(bgFormId);
                throw new BgORMException(BgORMException.DELETEENTITY, e, new Object[]{pk});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
    }

    @Override
    protected void _updateWF(Context ctx, BOSUuid id) throws BOSException, EASBizException {
    }

    @Override
    protected void _updateBgForm(Context ctx, BOSUuid bgFormId) throws BOSException, EASBizException {
        this._updateBgFormOld(ctx, bgFormId);
    }

    @Override
    protected void _updateBgFormStateWF1(Context ctx, BOSUuid bgFormId, int bgFormState) throws BOSException, EASBizException {
        this._updateBgFormState(ctx, bgFormId, bgFormState);
    }

    @Override
    protected void _updateBgFormStateWF2(Context ctx, BOSUuid bgFormId, int bgFormState) throws BOSException, EASBizException {
        this._updateBgFormState(ctx, bgFormId, bgFormState);
    }

    @Override
    protected void _clearBgForm(Context ctx, BOSUuid bgFormId) throws BOSException, EASBizException {
        String delBgDataSql = " DELETE FROM T_BG_BgData  WHERE (FBgEntryID IN ( SELECT fid FROM t_bg_bgentry WHERE fbgformid = ?))";
        String delBgEntrySql = " DELETE FROM T_BG_BgEntry WHERE (FBgFormID = ?)";
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.getConnection(ctx);
            String id = bgFormId.toString();
            stmt = conn.prepareStatement(delBgDataSql);
            stmt.setString(1, id);
            stmt.executeUpdate();
            stmt = conn.prepareStatement(delBgEntrySql);
            stmt.setString(1, id);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BgORMException(BgORMException.DELETEENTITY, e, new Object[]{bgFormId});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
    }

    @Override
    protected void _distributeWF(Context ctx, BOSUuid id) throws BOSException, EASBizException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _distributeBgForm(Context ctx, BOSUuid kdsId) throws BOSException, EASBizException {
        BgKDSInfo kdsInfo = (BgKDSInfo)this._getValue(ctx, (IObjectPK)new ObjectUuidPK(kdsId));
        try {
            byte[] byteArray = kdsInfo.getBgEntryArray();
            ByteArrayInputStream bais = new ByteArrayInputStream(byteArray);
            ObjectInputStream ois = new ObjectInputStream(bais);
            Object obj = ois.readObject();
            Object[] obj1 = (Object[])obj;
            OrgUnitCollection subOrgs = (OrgUnitCollection)obj1[0];
            Hashtable simpleScaleTable = (Hashtable)obj1[1];
            ois.close();
            bais.close();
            IBgManager iBg = BgManagerFactory.getLocalInstance(ctx);
            iBg.dealDistribute((IObjectPK)new ObjectUuidPK(kdsInfo.getBgForm().getId().toString()), subOrgs, simpleScaleTable);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void _distributeFail(Context ctx, BOSUuid kdsId) throws BOSException, EASBizException {
        BgKDSInfo kdsInfo = (BgKDSInfo)this._getValue(ctx, (IObjectPK)new ObjectUuidPK(kdsId));
        if (kdsInfo == null) {
            return;
        }
        try {
            BOSUuid formId;
            int i;
            byte[] byteArray = kdsInfo.getBgEntryArray();
            ByteArrayInputStream bais = new ByteArrayInputStream(byteArray);
            ObjectInputStream ois = new ObjectInputStream(bais);
            ArrayList addnewList = (ArrayList)ois.readObject();
            ArrayList updateList = (ArrayList)ois.readObject();
            ois.close();
            bais.close();
            int n = addnewList.size();
            for (i = 0; i < n; ++i) {
                formId = (BOSUuid)addnewList.get(i);
                this._updateBgFormState(ctx, formId, 51);
            }
            n = updateList.size();
            for (i = 0; i < n; ++i) {
                formId = (BOSUuid)updateList.get(i);
                this._updateBgFormState(ctx, formId, 53);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        this._delete(ctx, kdsId);
    }

    private int getBgFormState(Context ctx, BOSUuid bgFormId) throws BOSException, EASBizException {
        int state = -1;
        ResultSet rs = null;
        Connection connection = null;
        PreparedStatement ps = null;
        String sql = "select FState from T_BG_BgForm where fid =?";
        String fid = bgFormId.toString();
        try {
            connection = this.getConnection(ctx);
            ps = connection.prepareStatement(sql);
            ps.setString(1, fid);
            rs = ps.executeQuery();
            if (rs.next()) {
                state = rs.getInt(1);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)connection);
        return state;
    }

    @Override
    protected void _updateBgKDS(Context ctx, IObjectValue kdsInfo) throws BOSException, EASBizException {
        BgKDSInfo bgKDS = (BgKDSInfo)kdsInfo;
        BOSUuid bgFormId = bgKDS.getBgForm().getId();
        BOSUuid id = this._getBgKDSByBgForm(ctx, bgFormId);
        byte[] byteArray = bgKDS.getBgEntryArray();
        if (id == null) {
            BgKDSInfo tmpKDS = new BgKDSInfo();
            BgFormInfo formInfo = new BgFormInfo();
            id = BOSUuid.create((BOSObjectType)bgKDS.getBOSType());
            tmpKDS.setId(id);
            formInfo.setId(bgFormId);
            tmpKDS.setBgForm(formInfo);
            byte[] nullByteArray = new byte[]{};
            tmpKDS.setBgEntryArray(nullByteArray);
            this._addnew(ctx, (IObjectValue)tmpKDS);
        }
        String fid = id.toString();
        Connection connection = null;
        PreparedStatement ps = null;
        String sql = " update T_Bg_BgKDS set FBgEntryArray=? where FID=? ";
        try {
            connection = this.getConnection(ctx);
            ps = connection.prepareStatement(sql);
            ps.setBinaryStream(1, (InputStream)new ByteArrayInputStream(byteArray), byteArray.length);
            ps.setString(2, fid);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)connection);
    }

    @Override
    protected void _upgradeAllBgForm(Context ctx) throws BOSException, EASBizException {
        ResultSet rs = null;
        Connection connection = null;
        PreparedStatement ps = null;
        String sql = "select fid from t_bg_bgform where fid not in ( select fbgformid from t_bg_bgkds )";
        try {
            connection = this.getConnection(ctx);
            ps = connection.prepareStatement(sql);
            rs = ps.executeQuery();
            while (rs.next()) {
                String bgFormId = rs.getString(1);
                try {
                    this._updateBgForm(ctx, BOSUuid.read((String)bgFormId));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)connection);
    }

    @Override
    protected IObjectPK _genKDS(Context ctx, BOSUuid formId, IObjectCollection subOrgs, Hashtable simpleScaleTable) throws BOSException, EASBizException {
        BgKDSInfo kdsInfo = new BgKDSInfo();
        BOSUuid kdsId = BOSUuid.create((BOSObjectType)kdsInfo.getBOSType());
        kdsInfo.setId(kdsId);
        BgFormInfo formInfo = new BgFormInfo();
        formInfo.setId(formId);
        kdsInfo.setBgForm(formInfo);
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            Object[] obj = new Object[]{subOrgs, simpleScaleTable};
            oos.writeObject(obj);
            byte[] byteArray = baos.toByteArray();
            kdsInfo.setBgEntryArray(byteArray);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        IObjectPK kdsPk = this.addnew(ctx, kdsInfo);
        return kdsPk;
    }

    @Override
    protected void _updateBgFormOld(Context ctx, BOSUuid bgFormId) throws BOSException, EASBizException {
        IBgFormDA iBgFormDA = BgFormDAFactory.getLocalInstance(ctx);
        BgEntryCollection entryColl = iBgFormDA.getBgEntryCollection((IObjectPK)new ObjectUuidPK(bgFormId));
        ArrayList<BgEntryInfo> entryList = new ArrayList<BgEntryInfo>();
        int n = entryColl.size();
        for (int i = 0; i < n; ++i) {
            entryList.add(entryColl.get(i));
        }
        byte[] byteArray = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(entryList);
            byteArray = baos.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        BgKDSInfo kdsInfo = new BgKDSInfo();
        BgFormInfo formInfo = new BgFormInfo();
        formInfo.setId(bgFormId);
        kdsInfo.setBgForm(formInfo);
        kdsInfo.setBgEntryArray(byteArray);
        this._updateBgKDS(ctx, (IObjectValue)kdsInfo);
    }
}

