/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitCommon;
import com.kingdee.eas.basedata.org.OrgUnitCommonFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.bg.BgBalanceAccess;
import com.kingdee.eas.ma.bg.BgBizException;
import com.kingdee.eas.ma.bg.BgCtrlHelper;
import com.kingdee.eas.ma.bg.BgCurrencyCtrlTypeEnum;
import com.kingdee.eas.ma.bg.BgCycleTypeEnum;
import com.kingdee.eas.ma.bg.BgDataCollection;
import com.kingdee.eas.ma.bg.BgDataFactory;
import com.kingdee.eas.ma.bg.BgDataInfo;
import com.kingdee.eas.ma.bg.BgEntryInfo;
import com.kingdee.eas.ma.bg.BgFormInfo;
import com.kingdee.eas.ma.bg.BgFormulaConstants;
import com.kingdee.eas.ma.bg.BgHelper;
import com.kingdee.eas.ma.bg.BgORMEngine;
import com.kingdee.eas.ma.bg.BgPeriodNode;
import com.kingdee.eas.ma.bg.BgPeriodRange;
import com.kingdee.eas.ma.bg.BgTemplateHelper;
import com.kingdee.eas.ma.bg.IBgData;
import com.kingdee.eas.ma.bg.ReferencedDimensionCollection;
import com.kingdee.eas.ma.bg.app.AbstractBgProviderControllerBean;
import com.kingdee.eas.ma.bg.app.BgPastDataControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class BgProviderControllerBean
extends AbstractBgProviderControllerBean {
    private static Logger logger = Logger.getLogger(BgPastDataControllerBean.class);
    private static String strIsRptBgForm = "IsRptBgForm";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IObjectCollection _getBgData(Context ctx, IObjectValue bgForm, BOSUuid periodId, Map dimMap, BOSUuid currencyId) throws BOSException, EASBizException {
        BgFormInfo bgFormInfo = (BgFormInfo)bgForm;
        String entryId = null;
        BgDataCollection bgDataColl = new BgDataCollection();
        entryId = this.getBgEntryId(ctx, dimMap, bgFormInfo, periodId);
        if (entryId == null) {
            return bgDataColl;
        }
        String sql = "SELECT BgData.FID, BgData.FDataType, BgData.FBgValue, BgData.FBgBalance, BgData.FBgActual, BgData.FElementNumber, BgData.FBgCtrlType, BgData.FIsFlexibleCtrl, BgData.FFlexibleBgCtrlParam, BgData.FRelativeCtrlFormula, BgData.FBgElementID, BgData.FBizActual, BgData.FBgUsableValue, BgData.FBgLastBalance, BgElement.FBizElement, E.FID AS FBgEntryID, E.FPeriodID, E.FBgItem1ID, E.FBgItem2ID, E.FBgItem3ID, E.FBgItem4ID, E.FBgItem5ID, E.FBgItem6ID FROM T_BG_BgData BgData INNER JOIN T_BG_BgElement BgElement ON BgData.FBgElementID = BgElement.FID INNER JOIN T_BG_BgEntry E ON BgData.FBgEntryID = E.FID  WHERE (BgData.FBgEntryID = ?) AND (BgData.FCurrencyID=?)";
        Connection conn = this.getConnection(ctx);
        Object jdbcRs = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, BOSUuid.read((String)entryId).toString());
            stmt.setString(2, currencyId.toString());
            rs = stmt.executeQuery();
            bgDataColl = BgCtrlHelper.buildBgData(rs, BOSUuid.read((String)entryId), currencyId);
        }
        catch (SQLException ex) {
            try {
                new EASBizException(BgBizException.GETDATA, new Object[]{"getBgData"});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)stmt, (Connection)conn);
                throw throwable;
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return bgDataColl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getBgEntryId(Context ctx, Map dimMap, BgFormInfo bgFormInfo, BOSUuid periodId) throws BOSException, EASBizException {
        Connection conn;
        String entryId;
        ResultSet rs;
        PreparedStatement stmt;
        block15: {
            String string;
            int i;
            StringBuffer sb = new StringBuffer(256);
            ReferencedDimensionCollection refDims = BgTemplateHelper.getVisibleDims_sorted(ctx, bgFormInfo.getBgTemplate());
            BgCycleTypeEnum cycleType = bgFormInfo.getBgTemplate().getBgCycle();
            PeriodInfo periodInfo = (PeriodInfo)BgORMEngine.getVO(ctx, periodId, new String[]{"periodYear", "periodQuarter", "periodNumber"});
            sb.append("SELECT top 1 V.FID FROM V_BG_BgEntryItemNumber V INNER JOIN T_BD_Period P ON V.FPeriodID = P.FID  WHERE (V.FBgFormID = ?)");
            if (cycleType == BgCycleTypeEnum.Year) {
                sb.append(" AND   (P.FPeriodYear = ");
                sb.append(periodInfo.getPeriodYear());
                sb.append(")");
            } else if (cycleType == BgCycleTypeEnum.Season) {
                sb.append(" AND   (P.FPeriodYear =");
                sb.append(periodInfo.getPeriodYear());
                sb.append(") AND (P.FPeriodQuarter = ");
                sb.append(periodInfo.getPeriodQuarter());
                sb.append(")");
            } else {
                sb.append(" AND   (P.FPeriodYear=");
                sb.append(periodInfo.getPeriodYear());
                sb.append(") AND (P.FPeriodNumber = ");
                sb.append(periodInfo.getPeriodNumber());
                sb.append(") ");
            }
            for (i = 0; i < refDims.size(); ++i) {
                AbstractObjectValue objValue = (AbstractObjectValue)dimMap.get((Object)refDims.get(i).getBgDimension());
                if (objValue == null) {
                    return null;
                }
                String number = objValue.getString("number");
                if (number == null || number.length() == 0) {
                    number = BgORMEngine.getVO(ctx, objValue.getBOSUuid("id"), new String[]{"number"}).getString("number");
                    objValue.setString("number", number);
                }
                sb.append(" AND( LEFT('");
                sb.append(number);
                sb.append("',LENGTH(V.itemNumber").append(i + 1).append(")) = V.itemNumber").append(i + 1).append(")");
            }
            sb.append(" ORDER BY itemNumber1 DESC");
            for (i = 2; i < refDims.size() + 1; ++i) {
                sb.append(", itemNumber").append(i).append(" DESC");
            }
            stmt = null;
            rs = null;
            entryId = null;
            conn = this.getConnection(ctx);
            try {
                stmt = conn.prepareStatement(sb.toString());
                int length = bgFormInfo.getId().toString().length();
                if (length != 28) {
                    if (length != 44) throw new SQLException("\u4e1a\u52a1\u5bf9\u8c61ID\u957f\u5ea6\u8bbe\u7f6e\u5f02\u5e38\uff01");
                }
                stmt.setAsciiStream(1, (InputStream)new ByteArrayInputStream(bgFormInfo.getId().toString().getBytes()), length);
                rs = stmt.executeQuery();
                if (rs.next()) {
                    entryId = rs.getString(1);
                    SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
                    break block15;
                }
                string = null;
                SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
            }
            catch (SQLException e) {
                e.printStackTrace();
                return entryId;
            }
            SQLUtils.cleanup((Connection)conn);
            return string;
        }
        SQLUtils.cleanup((Connection)conn);
        return entryId;
        finally {
            SQLUtils.cleanup(rs, (Statement)stmt);
            SQLUtils.cleanup((Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BigDecimal _parseRptFormula(Context ctx, String field, String bgTypeNumber, String orgUnitNumber, String bgElementNumber, String bgDimensionNumber, String bgItemNumber, String currencyNumber, String year, String period) throws BOSException, EASBizException {
        Connection conn = this.getConnection(ctx);
        BigDecimal result = new BigDecimal("0");
        try {
            result = this.innerParseRptFormula(conn, field, bgTypeNumber, orgUnitNumber, bgElementNumber, bgDimensionNumber, bgItemNumber, currencyNumber, year, period);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return BgHelper.cutZero(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BigDecimal _parseRptFormulaMul(Context ctx, String field, String bgTypeNumber, String orgUnitNumber, String bgElementNumber, String strDimAndItem, String currencyNumber, String year, String period) throws BOSException, EASBizException {
        Connection conn = this.getConnection(ctx);
        BigDecimal result = new BigDecimal(0.0);
        try {
            String[] strArray = strDimAndItem.split("#");
            for (int i = 0; i < strArray.length; ++i) {
                result = result.add(this.innerParseRptFormulaMul(conn, field, bgTypeNumber, orgUnitNumber, bgElementNumber, strArray[i], currencyNumber, year, period));
            }
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return BgHelper.cutZero(result);
    }

    private BigDecimal innerParseRptFormula(Connection conn, String field, String bgTypeNumber, String orgUnitNumber, String bgElementNumber, String bgDimensionNumber, String bgItemNumber, String currencyNumber, String year, String period) throws SQLDataException, EASBizException {
        StringBuffer sb = new StringBuffer(1024);
        sb.append("SELECT SUM(T_BG_BgData.");
        sb.append(field);
        sb.append(") AS THESUM ");
        this.appendTable(sb);
        sb.append(" WHERE ");
        sb.append(" T_BG_BgEntry.FIsLeafPeriod = 1 ");
        sb.append(" AND T_BG_BgForm.FState = 2");
        this.appendCondition(bgItemNumber, year, period, sb);
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        BigDecimal result = new BigDecimal("0");
        try {
            stmt = conn.prepareStatement(sb.toString());
            int index = 1;
            stmt.setString(index++, bgTypeNumber);
            stmt.setString(index++, orgUnitNumber);
            stmt.setString(index++, bgElementNumber);
            if (bgDimensionNumber != null) {
                stmt.setString(index++, bgDimensionNumber);
            }
            stmt.setString(index++, currencyNumber);
            resultSet = stmt.executeQuery();
            if (resultSet.next()) {
                result = resultSet.getBigDecimal("THESUM");
            }
        }
        catch (SQLException e) {
            try {
                throw new EASBizException(BgBizException.GETDATA, (Throwable)e, new Object[]{"Budget Provider"});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(resultSet, (Statement)stmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)resultSet, (Statement)stmt);
        return BgHelper.cutZero(result);
    }

    private BigDecimal innerParseRptFormulaMul(Connection conn, String field, String bgTypeNumber, String orgUnitNumber, String bgElementNumber, String strDimAndItem, String bgItemNumber, String currencyNumber, String year, String period) throws SQLDataException, EASBizException {
        StringBuffer sb = new StringBuffer(1024);
        sb.append("SELECT SUM(T_BG_BgData.");
        sb.append(field);
        sb.append(") AS THESUM ");
        this.appendTableMul(sb, strDimAndItem);
        sb.append(" WHERE ");
        sb.append(" T_BG_BgEntry.FIsLeafPeriod = 1 ");
        sb.append(" AND T_BG_BgForm.FState = 2");
        this.appendConditionMul(strDimAndItem, year, period, sb);
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        BigDecimal result = new BigDecimal("0");
        try {
            stmt = conn.prepareStatement(sb.toString());
            int index = 1;
            stmt.setString(index++, bgTypeNumber);
            stmt.setString(index++, orgUnitNumber);
            stmt.setString(index++, bgElementNumber);
            stmt.setString(index++, currencyNumber);
            resultSet = stmt.executeQuery();
            if (resultSet.next()) {
                result = resultSet.getBigDecimal("THESUM");
            }
        }
        catch (SQLException e) {
            try {
                throw new EASBizException(BgBizException.GETDATA, (Throwable)e, new Object[]{"Budget Provider"});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(resultSet, (Statement)stmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)resultSet, (Statement)stmt);
        return BgHelper.cutZero(result);
    }

    private void appendTable(StringBuffer sb) {
        sb.append(" FROM T_BG_BgData ");
        sb.append(" INNER JOIN T_BG_BgEntry ON T_BG_BgData.FBgEntryID = T_BG_BgEntry.FID ");
        sb.append(" INNER JOIN T_BG_BgItem ON T_BG_BgEntry.FBgItem1ID = T_BG_BgItem.FID ");
        sb.append(" INNER JOIN T_BD_Period ON T_BG_BgEntry.FPeriodID = T_BD_Period.FID ");
        sb.append(" INNER JOIN T_BG_BgForm ON T_BG_BgEntry.FBgFormID = T_BG_BgForm.FID ");
        sb.append(" INNER JOIN T_BG_BgType ON T_BG_BgForm.FBgTypeID = T_BG_BgType.FID ");
        sb.append(" INNER JOIN T_ORG_BaseUnit ON  T_BG_BgForm.FOrgUnitID = T_ORG_BaseUnit.FID ");
        sb.append(" LEFT OUTER JOIN T_BD_Currency ON T_BG_BgData.FCurrencyID = T_BD_Currency.FID ");
    }

    private void appendCondition(String bgItemNumber, String year, String period, StringBuffer sb) {
        sb.append(" AND T_BG_BgType.FNumber = ? ");
        sb.append(" AND T_ORG_BaseUnit.FNumber = ? ");
        sb.append(" AND T_BG_BgData.FElementNumber = ? ");
        sb.append(" AND T_BG_BgItem.FBgDimension = ? ");
        sb.append(" AND T_BD_Currency.FNumber = ? ");
        if (year != null && !year.equals("")) {
            sb.append(" AND T_BD_Period.FPeriodYear = " + year + " ");
        }
        if (period != null && !period.equals("")) {
            sb.append(" AND T_BD_Period.FPeriodNumber = " + period + " ");
        }
        if (bgItemNumber != null && !bgItemNumber.equals("")) {
            String[] itemsArray = StringUtils.split((String)bgItemNumber, (int)44);
            StringBuffer itemsSb = new StringBuffer();
            itemsSb.append("(");
            int size = itemsArray.length;
            for (int i = 0; i < size; ++i) {
                itemsSb.append("'");
                itemsSb.append(itemsArray[i]);
                itemsSb.append("'");
                if (i == size - 1) continue;
                itemsSb.append(",");
            }
            itemsSb.append(")");
            sb.append(" AND T_BG_BgItem.FItemNumber in ");
            sb.append(itemsSb);
            sb.append(" ");
        }
    }

    @Override
    public BigDecimal _parseBgFormula(Context ctx, String schemeId, String bgTypeNumber, String orgUnitNumber, String bgElementNumber, String bgDimensionNumber, String bgItemNumber, String currencyNumber, String year, String period) throws BOSException, EASBizException {
        BigDecimal bigDecimal;
        StringBuffer sb = new StringBuffer(1024);
        sb.append("SELECT SUM(T_BG_BgData.FBgValue) AS theValue ");
        this.appendTable(sb);
        sb.append(" WHERE ");
        sb.append(" T_BG_BgEntry.FIsLeafPeriod = 1 ");
        sb.append(" AND (T_BG_BgForm.FState = 1 OR T_BG_BgForm.FState = 4) ");
        sb.append(" AND T_BG_BgForm.FBgSchemeID = '" + schemeId + "' ");
        this.appendCondition(bgItemNumber, year, period, sb);
        sb.append(" GROUP BY T_BG_BgForm.FState");
        sb.append(" ORDER BY T_BG_BgForm.FState");
        PreparedStatement stmt = null;
        Connection conn = this.getConnection(ctx);
        ResultSet resultSet = null;
        BigDecimal result = null;
        try {
            stmt = conn.prepareStatement(sb.toString());
            int index = 1;
            stmt.setString(index++, bgTypeNumber);
            stmt.setString(index++, orgUnitNumber);
            stmt.setString(index++, bgElementNumber);
            if (bgDimensionNumber != null) {
                stmt.setString(index++, bgDimensionNumber);
            }
            stmt.setString(index++, currencyNumber);
            resultSet = stmt.executeQuery();
            if (resultSet.next()) {
                result = resultSet.getBigDecimal("theValue");
            }
            if (result == null) {
                result = this.innerParseRptFormula(conn, "FBgValue", bgTypeNumber, orgUnitNumber, bgElementNumber, bgDimensionNumber, bgItemNumber, currencyNumber, year, period);
            }
            bigDecimal = BgHelper.cutZero(result);
        }
        catch (SQLException e) {
            try {
                throw new EASBizException(BgBizException.GETDATA, (Throwable)e, new Object[]{"T_BG_BgForm"});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(resultSet, (Statement)stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)resultSet, (Statement)stmt, (Connection)conn);
        return bigDecimal;
    }

    @Override
    public BigDecimal _getEnableBalance(Context ctx, BOSUuid bgDataid) throws EASBizException, BOSException {
        IBgData bgData = BgDataFactory.getLocalInstance(ctx);
        BgDataInfo bgDataInfo = bgData.getBgDataInfo("select *, bgEntry.*,bgEntry.period.id,bgEntry.bgForm.*,bgEntry.bgForm.company.id where id='" + bgDataid.toString() + "'");
        BgEntryInfo bgEntry = bgDataInfo.getBgEntry();
        BgFormInfo bgForm = bgEntry.getBgForm();
        BgBalanceAccess ba = new BgBalanceAccess(ctx, bgForm.getCompany().getId(), bgForm.getId(), bgEntry.getPeriod().getId());
        BgCurrencyCtrlTypeEnum curCtrlType = BgCtrlHelper.getBgCurrencyCtrlType(ctx, bgForm.getCompany().getId());
        BigDecimal bgBalance = ba.getBgEnableValue(ctx, bgDataInfo, curCtrlType);
        return BgHelper.cutZero(bgBalance);
    }

    @Override
    public BigDecimal _getEnableBalance(Context ctx, String orgUnitNumber, String bgTypeNumber, String bgElementNumber, String bgDimensionNumber, String currencyNumber, int year, int number) throws EASBizException, BOSException {
        BgDataInfo data;
        BOSUuid period;
        BOSUuid formId;
        BOSUuid comapnyId;
        ResultSet rs;
        PreparedStatement stmt;
        Connection conn;
        block5: {
            BigDecimal dataCtrl2;
            String sql = "SELECT D.FID,D.FCompanyId,D.FBgFormId,D.FPeriodId FROM V_BG_BgData D INNER JOIN T_ORG_BaseUnit U ON D.FOrgUnitID = U.FID INNER JOIN T_BD_Currency C ON D.FCurrencyID = C.FID INNER JOIN T_BD_Period P ON D.FPeriodID = P.FID INNER JOIN T_BG_BgType T ON D.FBgTypeID = T.FID WHERE  (U.FNumber = ?) AND  (T.FNumber = ?) AND (D.FElementNumber = ?) AND (D.ItemNumberKey = ?) AND (C.FNumber = ?) AND (P.FPeriodYear = ?) AND (P.FPeriodNumber = ?) AND (D.FIsLeafPeriod = 1) AND (D.FIsLeafEntry = 1) AND(D.FState in(2,6))";
            conn = null;
            stmt = null;
            rs = null;
            comapnyId = null;
            formId = null;
            period = null;
            data = null;
            try {
                conn = this.getConnection(ctx);
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, orgUnitNumber);
                stmt.setString(2, bgTypeNumber);
                stmt.setString(3, bgElementNumber);
                stmt.setString(4, bgDimensionNumber);
                stmt.setString(5, currencyNumber);
                stmt.setInt(6, year);
                stmt.setInt(7, number);
                rs = stmt.executeQuery();
                if (rs.next()) {
                    comapnyId = BOSUuid.read((String)rs.getString("FCompanyId"));
                    formId = BOSUuid.read((String)rs.getString("FBgFormId"));
                    period = BOSUuid.read((String)rs.getString("FperiodId"));
                    IBgData dataCtrl2 = BgDataFactory.getLocalInstance(ctx);
                    data = dataCtrl2.getBgDataInfo("select * where id='" + rs.getString("FID") + "'");
                    break block5;
                }
                dataCtrl2 = new BigDecimal("0");
            }
            catch (SQLException exp) {
                try {
                    throw new EASBizException(BgBizException.GETDATA, (Throwable)exp, new Object[]{"getData"});
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, stmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
            return dataCtrl2;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        BgBalanceAccess ba = new BgBalanceAccess(ctx, comapnyId, formId, period);
        BgCurrencyCtrlTypeEnum curCtrlType = BgCtrlHelper.getBgCurrencyCtrlType(ctx, comapnyId);
        BigDecimal bgBalance = ba.getBgEnableValue(ctx, data, curCtrlType);
        return BgHelper.cutZero(bgBalance);
    }

    @Override
    public BigDecimal _getEnbaleBalance(Context ctx, IObjectValue orgUnit, IObjectValue bgType, IObjectValue bgElement, String dimNumbers, IObjectValue currency, IObjectValue period) throws BOSException, EASBizException {
        PeriodInfo p = (PeriodInfo)period;
        return this._getEnableBalance(ctx, orgUnit.getString("number"), bgType.getString("number"), bgElement.getString("number"), dimNumbers, currency.getString("number"), p.getPeriodYear(), p.getPeriodNumber());
    }

    @Override
    public BigDecimal _paseBgFormulaMul(Context ctx, String schemeId, String bgTypeNumber, String orgUnitNumber, String bgElementNumber, String itemNumAndDimNum, String currencyNumber, String year, String period) throws BOSException, EASBizException {
        BigDecimal bigDecimal;
        StringBuffer sb = new StringBuffer(1024);
        sb.append("SELECT SUM(T_BG_BgData.FBgValue) AS theValue ");
        this.appendTableMul(sb, itemNumAndDimNum);
        sb.append(" WHERE ");
        sb.append(" T_BG_BgEntry.FIsLeafPeriod = 1 ");
        sb.append(" AND (T_BG_BgForm.FState = 1 OR T_BG_BgForm.FState = 2) ");
        sb.append(" AND T_BG_BgForm.FBgSchemeID = '" + schemeId + "' ");
        this.appendConditionMul(itemNumAndDimNum, year, period, sb);
        PreparedStatement stmt = null;
        Connection conn = this.getConnection(ctx);
        ResultSet resultSet = null;
        BigDecimal result = null;
        try {
            stmt = conn.prepareStatement(sb.toString());
            int index = 1;
            stmt.setString(index++, bgTypeNumber);
            stmt.setString(index++, orgUnitNumber);
            stmt.setString(index++, bgElementNumber);
            stmt.setString(index++, currencyNumber);
            resultSet = stmt.executeQuery();
            if (resultSet.next()) {
                result = resultSet.getBigDecimal("theValue");
            }
            if (result == null) {
                result = this.innerParseRptFormulaMul(conn, "FBgValue", bgTypeNumber, orgUnitNumber, bgElementNumber, itemNumAndDimNum, currencyNumber, year, period);
            }
            bigDecimal = BgHelper.cutZero(result);
        }
        catch (SQLException e) {
            try {
                throw new EASBizException(BgBizException.GETDATA, (Throwable)e, new Object[]{"T_BG_BgForm"});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(resultSet, (Statement)stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)resultSet, (Statement)stmt, (Connection)conn);
        return bigDecimal;
    }

    private BigDecimal innerParseRptFormulaMul(Connection conn, String field, String bgTypeNumber, String orgUnitNumber, String bgElementNumber, String itemNumAndDimNum, String currencyNumber, String year, String period) throws SQLDataException, EASBizException {
        StringBuffer sb = new StringBuffer(1024);
        sb.append("SELECT SUM(T_BG_BgData.");
        sb.append(field);
        sb.append(") AS THESUM ");
        this.appendTableMul(sb, itemNumAndDimNum);
        sb.append(" WHERE ");
        sb.append(" T_BG_BgEntry.FIsLeafPeriod = 1 ");
        sb.append(" AND (T_BG_BgForm.FState = 1 OR T_BG_BgForm.FState = 2) ");
        this.appendConditionMul(itemNumAndDimNum, year, period, sb);
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        BigDecimal result = new BigDecimal("0");
        try {
            stmt = conn.prepareStatement(sb.toString());
            int index = 1;
            stmt.setString(index++, bgTypeNumber);
            stmt.setString(index++, orgUnitNumber);
            stmt.setString(index++, bgElementNumber);
            stmt.setString(index++, currencyNumber);
            resultSet = stmt.executeQuery();
            if (resultSet.next()) {
                result = resultSet.getBigDecimal("THESUM");
            }
        }
        catch (SQLException e) {
            try {
                throw new EASBizException(BgBizException.GETDATA, (Throwable)e, new Object[]{"Budget Provider"});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(resultSet, (Statement)stmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)resultSet, (Statement)stmt);
        return BgHelper.cutZero(result);
    }

    private void appendTableMul(StringBuffer sb, String itemNumAndDimNum) {
        String[] strTemp;
        sb.append(" From T_ORG_BaseUnit INNER JOIN T_BG_BgForm ON T_ORG_BaseUnit.FID = T_BG_BgForm.FOrgUnitID INNER JOIN  T_BG_BgType ON T_BG_BgForm.FBgTypeID = T_BG_BgType.FID LEFT OUTER JOIN  T_BD_Period INNER JOIN  T_BG_BgEntry ON T_BD_Period.FID = T_BG_BgEntry.FPeriodID INNER JOIN T_BG_BgData ON T_BG_BgEntry.FID = T_BG_BgData.FBgEntryID INNER JOIN T_BD_Currency ON T_BG_BgData.FCurrencyID = T_BD_Currency.FID ON T_BG_BgForm.FID = T_BG_BgEntry.FBgFormID");
        String[] strArr = itemNumAndDimNum.split(":");
        boolean isCurrPro = false;
        if (strArr.length == 1 && (strTemp = strArr[0].split("&")).length == 1) {
            isCurrPro = true;
        }
        if (!isCurrPro) {
            for (int i = 1; i <= strArr.length; ++i) {
                sb.append(" LEFT OUTER JOIN  T_BG_BgItem T_BG_BgItem_" + i + " ON  T_BG_BgEntry.FBgItem" + i + "ID = T_BG_BgItem_" + i + ".FID");
            }
        }
    }

    private void appendConditionMul(String dimAndItemnumber, String year, String period, StringBuffer sb) {
        String[] strTemp;
        sb.append(" AND T_BG_BgType.FNumber = ? ");
        sb.append(" AND T_ORG_BaseUnit.FNumber = ? ");
        sb.append(" AND T_BG_BgData.FElementNumber = ? ");
        sb.append(" AND T_BD_Currency.FNumber = ? ");
        if (year != null && !year.equals("")) {
            sb.append(" AND T_BD_Period.FPeriodYear = " + year);
        }
        if (period != null && !period.equals("")) {
            sb.append(" AND T_BD_Period.FPeriodNumber in(" + period + ") ");
        }
        String[] strArr = dimAndItemnumber.split(":");
        boolean isCurrPro = false;
        if (strArr.length == 1 && (strTemp = strArr[0].split("&")).length == 1) {
            isCurrPro = true;
        }
        if (!isCurrPro) {
            for (int i = 1; i <= strArr.length; ++i) {
                String str = strArr[i - 1];
                String[] strTemp2 = str.split("&");
                sb.append(" and T_BG_BgItem_" + i + ".FBgDimension=" + strTemp2[0]);
                sb.append(" and T_BG_BgItem_" + i + ".FItemNumber='" + strTemp2[1] + "'");
            }
        }
    }

    @Override
    public BigDecimal _paseBgFormulaMul(Context ctx, String schemeId, String bgTypeNumber, String orgUnitNumber, String bgElementNumber, String itemNumAndDimNum, String currencyNumber, String strBgPeriod) throws BOSException, EASBizException {
        int startYear = 0;
        int startPeriod = 0;
        int endYear = 0;
        int endPeriod = 0;
        if (strBgPeriod.equals("AllPeriod")) {
            int[] rt = this.getPeriod(ctx, schemeId);
            startYear = rt[0];
            startPeriod = rt[1];
            endYear = rt[2];
            endPeriod = rt[3];
        } else {
            strBgPeriod = strBgPeriod.replace('|', '#');
            String[] strs = strBgPeriod.split("#");
            startYear = Integer.parseInt(strs[0].trim());
            endYear = Integer.parseInt(strs[0].trim());
            if (strs[3].indexOf("Year") >= 0) {
                startPeriod = 1;
                endPeriod = 12;
            } else if (strs[3].indexOf("Season") >= 0) {
                int tmp = Integer.parseInt(strs[1]);
                if (tmp == 1) {
                    startPeriod = 1;
                    endPeriod = 3;
                } else if (tmp == 2) {
                    startPeriod = 4;
                    endPeriod = 6;
                } else if (tmp == 3) {
                    startPeriod = 7;
                    endPeriod = 9;
                } else if (tmp == 4) {
                    startPeriod = 10;
                    endPeriod = 12;
                }
            } else if (strs[3].indexOf("Period") >= 0) {
                startPeriod = Integer.parseInt(strs[2].trim());
                endPeriod = Integer.parseInt(strs[2].trim());
            }
        }
        BigDecimal result = this.getBgValue(ctx, orgUnitNumber, bgTypeNumber, bgElementNumber, itemNumAndDimNum, currencyNumber, startYear, startPeriod, endYear, endPeriod, "FBgValue");
        return result;
    }

    private int[] getPeriod(Context ctx, String bgSchemeId) throws EASBizException, SQLDataException {
        String sql = " select a.fperiodyear, a.fperiodnumber, b.fperiodyear, b.fperiodnumber  from t_bg_bgscheme c,t_bd_period a,t_bd_period b where c.fid=? and a.fid=c.fperiodfromid and b.fid=c.fperiodtoid ";
        PreparedStatement stmt = null;
        Connection conn = null;
        ResultSet resultSet = null;
        int[] result = new int[4];
        try {
            conn = this.getConnection(ctx);
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, bgSchemeId);
            resultSet = stmt.executeQuery();
            if (resultSet.next()) {
                result[0] = resultSet.getInt(1);
                result[1] = resultSet.getInt(2);
                result[2] = resultSet.getInt(3);
                result[3] = resultSet.getInt(4);
            }
        }
        catch (SQLException e) {
            try {
                throw new EASBizException(BgBizException.GETDATA, (Throwable)e, new Object[]{"T_BG_BgForm"});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(resultSet, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)resultSet, (Statement)stmt, (Connection)conn);
        return result;
    }

    private BigDecimal cacluateItem(Context ctx, String schemeId, String bgTypeNumber, String orgUnitNumber, String bgElementNumber, String itemNumAndDimNum, String currencyNumber, String strBgPeriod) throws BOSException, EASBizException {
        BigDecimal bigDecimal;
        String[] strArray = this.adjustPeriod(ctx, schemeId, bgTypeNumber, orgUnitNumber, strBgPeriod);
        String year = strArray[0];
        String period = strArray[1];
        boolean isExist = strBgPeriod.endsWith("Year");
        if (isExist) {
            period = null;
        }
        if (!strBgPeriod.endsWith("Year") && period != null && period.trim().equals("")) {
            return new BigDecimal("0");
        }
        StringBuffer sb = new StringBuffer(1024);
        sb.append("SELECT SUM(T_BG_BgData.FBgValue) AS theValue ");
        this.appendTableMul(sb, itemNumAndDimNum);
        sb.append(" WHERE ");
        sb.append(" T_BG_BgEntry.FIsLeafPeriod = 1 ");
        sb.append(" AND (T_BG_BgForm.FState = 1 OR T_BG_BgForm.FState = 2) ");
        sb.append(" AND T_BG_BgForm.FBgSchemeID = '" + schemeId + "' ");
        this.appendConditionMul(itemNumAndDimNum, year, period, sb);
        PreparedStatement stmt = null;
        Connection conn = this.getConnection(ctx);
        ResultSet resultSet = null;
        BigDecimal result = null;
        try {
            stmt = conn.prepareStatement(sb.toString());
            int index = 1;
            stmt.setString(index++, bgTypeNumber);
            stmt.setString(index++, orgUnitNumber);
            stmt.setString(index++, bgElementNumber);
            stmt.setString(index++, currencyNumber);
            resultSet = stmt.executeQuery();
            if (resultSet.next()) {
                result = resultSet.getBigDecimal("theValue");
            }
            if (result == null) {
                result = this.innerParseRptFormulaMul(conn, "FBgValue", bgTypeNumber, orgUnitNumber, bgElementNumber, itemNumAndDimNum, currencyNumber, year, period);
            }
            bigDecimal = BgHelper.cutZero(result);
        }
        catch (SQLException e) {
            try {
                throw new EASBizException(BgBizException.GETDATA, (Throwable)e, new Object[]{"T_BG_BgForm"});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(resultSet, (Statement)stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)resultSet, (Statement)stmt, (Connection)conn);
        return bigDecimal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private String[] adjustPeriod(Context ctx, String strBgSchemeId, String strTypeNumber, String strOrgNumber, String strBgPeriod) throws EASBizException, BOSException {
        String[] strArray = new String[2];
        if (!strBgPeriod.equals("AllPeriod")) {
            ResultSet rs;
            PreparedStatement sm;
            Connection conn;
            block14: {
                BgPeriodNode bgPeriodNode = new BgPeriodNode();
                bgPeriodNode.readFormulaFormat(strBgPeriod);
                strArray[0] = String.valueOf(bgPeriodNode.getPeriod().getPeriodYear());
                strArray[1] = String.valueOf(bgPeriodNode.getPeriod().getPeriodNumber());
                StringBuffer strBuffer = new StringBuffer(500);
                String fromBeginDate = bgPeriodNode.getPeriod().getPeriodYear() + "-" + bgPeriodNode.getPeriod().getPeriodNumber() + "-1";
                String toBeginDate = "";
                if (bgPeriodNode.getBgCycle() == BgCycleTypeEnum.Period) {
                    toBeginDate = fromBeginDate;
                } else if (bgPeriodNode.getBgCycle() == BgCycleTypeEnum.Season) {
                    int number = bgPeriodNode.getPeriod().getPeriodNumber() + 2;
                    toBeginDate = bgPeriodNode.getPeriod().getPeriodYear() + "-" + number + "-1";
                } else if (bgPeriodNode.getBgCycle() == BgCycleTypeEnum.Year) {
                    toBeginDate = bgPeriodNode.getPeriod().getPeriodYear() + "-12-1";
                }
                strBuffer.append("select ff.FPeriodFromId AS periodFrom, ff.FPeriodToId AS periodTo, ff.FOrgUnitid AS orgid, tmp.fbgCycle AS cycle, PeriodFrom.FBeginDate AS beginDate, PeriodTo.FEndDate AS endDate  from t_bg_bgForm ff, t_bg_bgType tt, T_org_baseunit org, t_bg_bgTemplate tmp, t_bd_Period PeriodFrom, t_bd_Period PeriodTo where ff.fbgTypeid = tt.fid and ff.forgunitid = org.fid and ff.fbgtemplateid =tmp.fid and ff.FperiodFromid = periodFrom.fid and ff.FPeriodToId= periodTo.fid ");
                strBuffer.append(" and periodFrom.FBeginDate<=?");
                strBuffer.append(" and periodTo.FBeginDate>=?");
                strBuffer.append(" and tt.fnumber=? ");
                strBuffer.append(" and org.fnumber=? ");
                strBuffer.append(" and (ff.fstate=1 or ff.fstate=4) ");
                conn = null;
                sm = null;
                rs = null;
                try {
                    int cycle;
                    conn = this.getConnection(ctx);
                    sm = conn.prepareStatement(strBuffer.toString());
                    sm.setString(1, fromBeginDate);
                    sm.setString(2, toBeginDate);
                    sm.setString(3, strTypeNumber);
                    sm.setString(4, strOrgNumber);
                    rs = sm.executeQuery();
                    if (!rs.next() || (cycle = rs.getInt("cycle")) == bgPeriodNode.getBgCycle().getValue()) break block14;
                    String strPeriodFromId = rs.getString("periodFrom");
                    PeriodInfo periodFrom = new PeriodInfo();
                    if (strPeriodFromId != null) {
                        periodFrom.setId(BOSUuid.read((String)strPeriodFromId));
                        periodFrom.setBeginDate((Date)rs.getDate("beginDate"));
                    }
                    String strPeriodToId = rs.getString("periodTo");
                    PeriodInfo periodTo = new PeriodInfo();
                    if (strPeriodToId != null) {
                        periodTo.setId(BOSUuid.read((String)strPeriodToId));
                        periodTo.setBeginDate((Date)rs.getDate("endDate"));
                    }
                    String strOrgId = rs.getString("orgid");
                    IOrgUnitCommon iOrgUnitCommon = OrgUnitCommonFactory.getLocalInstance((Context)ctx);
                    CompanyOrgUnitInfo companyInfo = iOrgUnitCommon.getCompany(BOSUuid.read((String)strOrgId));
                    PeriodCollection periods = PeriodUtils.getPeriodc((Context)ctx, (PeriodInfo)periodFrom, (PeriodInfo)periodTo, (CompanyOrgUnitInfo)companyInfo);
                    periods = BgHelper.filterAdjustPeriod(periods);
                    BgPeriodRange bgPeriodRange = new BgPeriodRange(periodFrom, periodTo);
                    Vector vector = bgPeriodRange.getPeriodNodesInRange(companyInfo, BgCycleTypeEnum.getEnum(cycle), periods);
                    strArray[1] = BgPeriodRange.adjustPeriodByBgCycle(vector, bgPeriodNode);
                }
                catch (SQLDataException e) {
                    new BOSException((Throwable)e);
                    SQLUtils.cleanup(rs, (Statement)sm, (Connection)conn);
                }
                catch (SQLException e2) {
                    new BOSException((Throwable)e2);
                    {
                        catch (Throwable throwable) {
                            SQLUtils.cleanup(rs, sm, (Connection)conn);
                            throw throwable;
                        }
                    }
                    SQLUtils.cleanup(rs, (Statement)sm, (Connection)conn);
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)sm, (Connection)conn);
        }
        return strArray;
    }

    @Override
    protected BigDecimal _parseBgFormula(Context ctx, String schemeId, String bgTypeNumber, String orgUnitNumber, String bgElementNumber, String bgDimensionNumber, String bgItemNumber, String currencyNumber, String year, String quarter, String period, BgCycleTypeEnum cycle) throws BOSException, EASBizException {
        BigDecimal bigDecimal;
        StringBuffer sb = new StringBuffer(1024);
        sb.append("SELECT SUM(T_BG_BgData.FBgValue) AS theValue ");
        this.appendTable(sb);
        sb.append(" WHERE ");
        sb.append(" T_BG_BgEntry.FIsLeafPeriod = 1 ");
        sb.append(" AND (T_BG_BgForm.FState = 1 OR T_BG_BgForm.FState = 4) ");
        sb.append(" AND T_BG_BgForm.FBgSchemeID = '" + schemeId + "' ");
        if (cycle.equals((Object)BgCycleTypeEnum.Period)) {
            this.appendCondition(bgItemNumber, year, period, sb);
        } else if (cycle.equals((Object)BgCycleTypeEnum.Season)) {
            this.appendCondition1(bgItemNumber, year, quarter, sb);
        } else if (cycle.equals((Object)BgCycleTypeEnum.Year)) {
            this.appendCondition2(bgItemNumber, year, quarter, sb);
        }
        sb.append(" GROUP BY T_BG_BgForm.FState");
        sb.append(" ORDER BY T_BG_BgForm.FState");
        PreparedStatement stmt = null;
        Connection conn = this.getConnection(ctx);
        ResultSet resultSet = null;
        BigDecimal result = null;
        try {
            stmt = conn.prepareStatement(sb.toString());
            int index = 1;
            stmt.setString(index++, bgTypeNumber);
            stmt.setString(index++, orgUnitNumber);
            stmt.setString(index++, bgElementNumber);
            if (bgDimensionNumber != null) {
                stmt.setString(index++, bgDimensionNumber);
            }
            stmt.setString(index++, currencyNumber);
            resultSet = stmt.executeQuery();
            if (resultSet.next()) {
                result = resultSet.getBigDecimal("theValue");
            }
            if (result == null) {
                result = this.innerParseRptFormula(conn, "FBgValue", bgTypeNumber, orgUnitNumber, bgElementNumber, bgDimensionNumber, bgItemNumber, currencyNumber, year, period);
            }
            bigDecimal = BgHelper.cutZero(result);
        }
        catch (SQLException e) {
            try {
                throw new BgBizException(BgBizException.GETDATA, e, new Object[]{"T_BG_BgForm"});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(resultSet, (Statement)stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)resultSet, (Statement)stmt, (Connection)conn);
        return bigDecimal;
    }

    private void appendCondition1(String bgItemNumber, String year, String quarter, StringBuffer sb) {
        sb.append(" AND T_BG_BgType.FNumber = ? ");
        sb.append(" AND T_ORG_BaseUnit.FNumber = ? ");
        sb.append(" AND T_BG_BgData.FElementNumber = ? ");
        sb.append(" AND T_BG_BgItem.FBgDimension = ? ");
        sb.append(" AND T_BD_Currency.FNumber = ? ");
        if (year != null && !year.equals("")) {
            sb.append(" AND T_BD_Period.FPeriodYear = " + year + " ");
        }
        if (quarter != null && !quarter.equals("")) {
            sb.append(" AND T_BD_Period.FPeriodQuarter = " + quarter + " ");
        }
        if (bgItemNumber != null && !bgItemNumber.equals("")) {
            String[] itemsArray = StringUtils.split((String)bgItemNumber, (int)44);
            StringBuffer itemsSb = new StringBuffer();
            itemsSb.append("(");
            int size = itemsArray.length;
            for (int i = 0; i < size; ++i) {
                itemsSb.append("'");
                itemsSb.append(itemsArray[i]);
                itemsSb.append("'");
                if (i == size - 1) continue;
                itemsSb.append(",");
            }
            itemsSb.append(")");
            sb.append(" AND T_BG_BgItem.FItemNumber in ");
            sb.append(itemsSb);
            sb.append(" ");
        }
    }

    private void appendCondition2(String bgItemNumber, String year, String quarter, StringBuffer sb) {
        sb.append(" AND T_BG_BgType.FNumber = ? ");
        sb.append(" AND T_ORG_BaseUnit.FNumber = ? ");
        sb.append(" AND T_BG_BgData.FElementNumber = ? ");
        sb.append(" AND T_BG_BgItem.FBgDimension = ? ");
        sb.append(" AND T_BD_Currency.FNumber = ? ");
        if (year != null && !year.equals("")) {
            sb.append(" AND T_BD_Period.FPeriodYear = " + year + " ");
        }
        if (bgItemNumber != null && !bgItemNumber.equals("")) {
            String[] itemsArray = StringUtils.split((String)bgItemNumber, (int)44);
            StringBuffer itemsSb = new StringBuffer();
            itemsSb.append("(");
            int size = itemsArray.length;
            for (int i = 0; i < size; ++i) {
                itemsSb.append("'");
                itemsSb.append(itemsArray[i]);
                itemsSb.append("'");
                if (i == size - 1) continue;
                itemsSb.append(",");
            }
            itemsSb.append(")");
            sb.append(" AND T_BG_BgItem.FItemNumber in ");
            sb.append(itemsSb);
            sb.append(" ");
        }
    }

    @Override
    protected BigDecimal _getBgValue(Context ctx, String orgNumber, String bgTypeNumber, String bgElementNumber, String strDimAndItemNum, String currencyNumber, int beginYear, int beginPeriod, int endYear, int endPeriod, String field) throws BOSException, EASBizException {
        int i;
        int i2;
        String periodStr;
        if (orgNumber.equals("")) {
            orgNumber = ContextUtil.getCurrentOrgUnit((Context)ctx).getNumber();
        }
        if (orgNumber.equals("") || bgTypeNumber.equals("") || bgElementNumber.equals("") || strDimAndItemNum.equals("") || currencyNumber.equals("")) {
            throw new BOSException(EASResource.getString((String)"com.kingdee.eas.ma.bg.BgBalanceResource", (String)"ParameterNotNull"));
        }
        BigDecimal result = new BigDecimal("0");
        Hashtable<String, Boolean> htIsRptBgForm = (Hashtable<String, Boolean>)ctx.get((Object)strIsRptBgForm);
        boolean isRptBgForm = false;
        if (htIsRptBgForm != null) {
            if (htIsRptBgForm.get(bgTypeNumber) != null) {
                isRptBgForm = (Boolean)htIsRptBgForm.get(bgTypeNumber);
            } else {
                isRptBgForm = this.checkIsRptBgForm(ctx, bgTypeNumber);
                htIsRptBgForm.put(bgTypeNumber, new Boolean(isRptBgForm));
            }
        } else {
            isRptBgForm = this.checkIsRptBgForm(ctx, bgTypeNumber);
            htIsRptBgForm = new Hashtable<String, Boolean>();
            htIsRptBgForm.put(bgTypeNumber, new Boolean(isRptBgForm));
            ctx.put((Object)strIsRptBgForm, htIsRptBgForm);
        }
        Hashtable<String, String> orgTable = (Hashtable<String, String>)ctx.get((Object)BgFormulaConstants.BGFORMULA_ORG);
        String orgUnitId = "";
        if (orgTable != null) {
            if (orgTable.get(orgNumber) != null) {
                orgUnitId = (String)orgTable.get(orgNumber);
            } else {
                orgUnitId = this.getOrgUnitId(ctx, orgNumber);
                orgTable.put(orgNumber, orgUnitId);
            }
        } else {
            orgUnitId = this.getOrgUnitId(ctx, orgNumber);
            orgTable = new Hashtable<String, String>();
            orgTable.put(orgNumber, orgUnitId);
            ctx.put((Object)BgFormulaConstants.BGFORMULA_ORG, orgTable);
        }
        Hashtable<String, String> bgTypeTable = (Hashtable<String, String>)ctx.get((Object)BgFormulaConstants.BGFORMULA_BGTYPE);
        String bgTypeId = "";
        if (bgTypeTable != null) {
            if (bgTypeTable.get(bgTypeNumber) != null) {
                bgTypeId = (String)bgTypeTable.get(bgTypeNumber);
            } else {
                bgTypeId = this.getBgTypeId(ctx, bgTypeNumber);
                bgTypeTable.put(bgTypeNumber, bgTypeId);
            }
        } else {
            bgTypeId = this.getBgTypeId(ctx, bgTypeNumber);
            bgTypeTable = new Hashtable<String, String>();
            bgTypeTable.put(bgTypeNumber, bgTypeId);
            ctx.put((Object)BgFormulaConstants.BGFORMULA_BGTYPE, bgTypeTable);
        }
        Hashtable<String, String> currencyTable = (Hashtable<String, String>)ctx.get((Object)BgFormulaConstants.BGFORMULA_CURRENCY);
        String currencyId = "";
        if (currencyTable != null) {
            if (currencyTable.get(currencyNumber) != null) {
                currencyId = (String)currencyTable.get(currencyNumber);
            } else {
                currencyId = this.getCurrencyId(ctx, currencyNumber);
                currencyTable.put(currencyNumber, currencyId);
            }
        } else {
            currencyId = this.getCurrencyId(ctx, currencyNumber);
            currencyTable = new Hashtable<String, String>();
            currencyTable.put(currencyNumber, currencyId);
            ctx.put((Object)BgFormulaConstants.BGFORMULA_CURRENCY, currencyTable);
        }
        Hashtable<String, Integer> currencyPrecisionTable = (Hashtable<String, Integer>)ctx.get((Object)BgFormulaConstants.BGFORMULA_CURRENCY_PRECISION);
        int precision = 0;
        if (currencyPrecisionTable != null) {
            if (currencyPrecisionTable.get(currencyNumber) != null) {
                precision = (Integer)currencyPrecisionTable.get(currencyNumber);
            } else {
                precision = this.getCurrencyPrecision(ctx, currencyId);
                currencyPrecisionTable.put(currencyNumber, new Integer(precision));
            }
        } else {
            precision = this.getCurrencyPrecision(ctx, currencyId);
            currencyPrecisionTable = new Hashtable<String, Integer>();
            currencyPrecisionTable.put(currencyNumber, new Integer(precision));
            ctx.put((Object)BgFormulaConstants.BGFORMULA_CURRENCY_PRECISION, currencyPrecisionTable);
        }
        Hashtable bgFormIDSTable = (Hashtable)ctx.get((Object)BgFormulaConstants.BGFORMIDS);
        String bgFormIDS = "";
        bgFormIDS = this.getBgFormIDS(ctx, orgUnitId, bgTypeId, beginYear, beginPeriod, endYear, endPeriod);
        StringBuffer sb = new StringBuffer(1024);
        sb.append("SELECT SUM(data.");
        sb.append(field);
        sb.append(") AS THESUM ");
        String[] strArray = strDimAndItemNum.split("#");
        this.appendTableMul_sp6(sb, strArray[0]);
        sb.append(" WHERE ");
        sb.append(" entry.FIsLeafPeriod = 1 ");
        sb.append(" and entry.FBgFormId in  ");
        sb.append(bgFormIDS);
        sb.append(" AND data.FElementNumber = ? ");
        sb.append(" AND data.FCurrencyId = ? ");
        if (beginYear == endYear) {
            sb.append(" AND period.FPeriodYear = " + beginYear);
            periodStr = "";
            for (i2 = beginPeriod; i2 <= endPeriod; ++i2) {
                periodStr = periodStr + i2 + ",";
            }
            periodStr = periodStr.substring(0, periodStr.length() - 1);
            sb.append(" AND period.FPeriodNumber in(" + periodStr + ") ");
        } else if (beginYear > endYear) {
            sb.append(" AND 1==2 ");
        } else {
            sb.append(" AND ( ( period.FPeriodYear = " + beginYear);
            periodStr = "";
            for (i2 = beginPeriod; i2 <= 12; ++i2) {
                periodStr = periodStr + i2 + ",";
            }
            periodStr = periodStr.substring(0, periodStr.length() - 1);
            sb.append(" AND period.FPeriodNumber in(" + periodStr + ")) or ");
            for (int j = beginYear + 1; j < endYear; ++j) {
                periodStr = "";
                sb.append(" ( period.FPeriodYear = " + j);
                for (i = 1; i <= 12; ++i) {
                    periodStr = periodStr + i + ",";
                }
                periodStr = periodStr.substring(0, periodStr.length() - 1);
                sb.append(" AND period.FPeriodNumber in(" + periodStr + ") ) or ");
            }
            periodStr = "";
            sb.append(" ( period.FPeriodYear = " + endYear);
            for (i2 = 1; i2 <= endPeriod; ++i2) {
                periodStr = periodStr + i2 + ",";
            }
            periodStr = periodStr.substring(0, periodStr.length() - 1);
            sb.append(" AND period.FPeriodNumber in(" + periodStr + ") ) )");
        }
        sb.append(" and ( ");
        for (int k = 0; k < strArray.length; ++k) {
            String[] strArr1 = strArray[k].split(":");
            for (i = 1; i <= strArr1.length; ++i) {
                String str = strArr1[i - 1];
                String[] strTemp = str.split("&");
                if (!isRptBgForm) {
                    sb.append(" ( T_BG_BgItem_" + i + ".FBgDimension=" + strTemp[0]);
                } else {
                    sb.append("( 1=1 ");
                }
                if (i == strArr1.length) {
                    sb.append(" and T_BG_BgItem_" + i + ".FItemNumber='" + strTemp[1] + "' ) ");
                    continue;
                }
                sb.append(" and T_BG_BgItem_" + i + ".FItemNumber='" + strTemp[1] + "' ) and ");
            }
            if (k == strArray.length - 1) {
                sb.append(" ) ");
                continue;
            }
            sb.append(" or ");
        }
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        result = new BigDecimal("0");
        Connection conn = this.getConnection(ctx);
        try {
            stmt = conn.prepareStatement(sb.toString());
            int index = 1;
            stmt.setString(index++, bgElementNumber);
            stmt.setString(index++, BOSUuid.read((String)currencyId).toString());
            resultSet = stmt.executeQuery();
            if (resultSet.next()) {
                result = resultSet.getBigDecimal("THESUM");
            }
        }
        catch (SQLException e) {
            try {
                throw new EASBizException(BgBizException.GETDATA, (Throwable)e, new Object[]{"Budget Provider"});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(resultSet, (Statement)stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)resultSet, (Statement)stmt, (Connection)conn);
        return BgHelper.cutZero(result, precision);
    }

    private String getOrgUnitId(Context ctx, String orgUnitNumber) throws SQLDataException, EASBizException {
        String id = "";
        Connection myConn = this.getConnection(ctx);
        PreparedStatement myStmt = null;
        ResultSet myRst = null;
        StringBuffer mySb = new StringBuffer(1024);
        mySb.append("select fid from t_org_baseunit where fnumber=?");
        try {
            myStmt = myConn.prepareStatement(mySb.toString());
            myStmt.setString(1, orgUnitNumber);
            myRst = myStmt.executeQuery();
            if (myRst.next()) {
                id = myRst.getString("fid");
            }
        }
        catch (SQLException e) {
            try {
                throw new EASBizException(BgBizException.GETDATA, (Throwable)e, new Object[]{"T_BG_BgForm"});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(myRst, (Statement)myStmt, (Connection)myConn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)myRst, (Statement)myStmt, (Connection)myConn);
        return id;
    }

    private String getBgTypeId(Context ctx, String bgTypeNumber) throws SQLDataException, EASBizException {
        String id = "";
        Connection myConn = this.getConnection(ctx);
        PreparedStatement myStmt = null;
        ResultSet myRst = null;
        StringBuffer mySb = new StringBuffer(1024);
        mySb.append("select fid from t_bg_bgtype_v50 where fnumber=?");
        try {
            myStmt = myConn.prepareStatement(mySb.toString());
            myStmt.setString(1, bgTypeNumber);
            myRst = myStmt.executeQuery();
            if (myRst.next()) {
                id = myRst.getString("fid");
            }
        }
        catch (SQLException e) {
            try {
                throw new EASBizException(BgBizException.GETDATA, (Throwable)e, new Object[]{"T_BG_BgForm"});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(myRst, (Statement)myStmt, (Connection)myConn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)myRst, (Statement)myStmt, (Connection)myConn);
        return id;
    }

    private String getCurrencyId(Context ctx, String currencyNumber) throws SQLDataException, EASBizException {
        String id = "";
        Connection myConn = this.getConnection(ctx);
        PreparedStatement myStmt = null;
        ResultSet myRst = null;
        StringBuffer mySb = new StringBuffer(1024);
        mySb.append("select fid from t_bd_currency where fnumber=?");
        try {
            myStmt = myConn.prepareStatement(mySb.toString());
            myStmt.setString(1, currencyNumber);
            myRst = myStmt.executeQuery();
            if (myRst.next()) {
                id = myRst.getString("fid");
            }
        }
        catch (SQLException e) {
            try {
                throw new EASBizException(BgBizException.GETDATA, (Throwable)e, new Object[]{"T_BG_BgForm"});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(myRst, (Statement)myStmt, (Connection)myConn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)myRst, (Statement)myStmt, (Connection)myConn);
        return id;
    }

    private int getCurrencyPrecision(Context ctx, String currencyID) throws SQLDataException, EASBizException {
        int result = 0;
        Connection myConn = this.getConnection(ctx);
        PreparedStatement myStmt = null;
        ResultSet myRst = null;
        StringBuffer mySb = new StringBuffer(100);
        mySb.append("select fprecision from t_bd_currency where fid = ? ");
        try {
            myStmt = myConn.prepareStatement(mySb.toString());
            myStmt.setString(1, BOSUuid.read((String)currencyID).toString());
            myRst = myStmt.executeQuery();
            if (myRst.next()) {
                result = myRst.getInt("fprecision");
            }
        }
        catch (SQLException e) {
            try {
                throw new EASBizException(BgBizException.GETDATA, (Throwable)e, new Object[]{"T_BG_BgForm"});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(myRst, (Statement)myStmt, (Connection)myConn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)myRst, (Statement)myStmt, (Connection)myConn);
        return result;
    }

    private String getBgFormIDS(Context ctx, String orgUnitId, String bgTypeId, int beginYear, int beginPeriod, int endYear, int endPeriod) throws SQLDataException, EASBizException {
        String ids = " (''";
        Connection myConn = this.getConnection(ctx);
        PreparedStatement myStmt = null;
        ResultSet myRst = null;
        StringBuffer mySb = new StringBuffer(1024);
        String periodSqlStr = BgFormulaConstants.getPeriodSQLStr(beginYear, beginPeriod, endYear, endPeriod);
        mySb.append(" select fid from t_bg_bgform_v50 where (FState = 1 OR FState = 2)  AND  FBgTypeId = ? AND FOrgUnitId = ? ");
        try {
            myStmt = myConn.prepareStatement(mySb.toString());
            myStmt.setString(1, BOSUuid.read((String)bgTypeId).toString());
            myStmt.setString(2, BOSUuid.read((String)orgUnitId).toString());
            myRst = myStmt.executeQuery();
            while (myRst.next()) {
                ids = ids + ",'" + myRst.getString("fid") + "'";
            }
            ids = ids + " )";
        }
        catch (SQLException e) {
            try {
                throw new EASBizException(BgBizException.GETDATA, (Throwable)e, new Object[]{"T_BG_BgForm"});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(myRst, (Statement)myStmt, (Connection)myConn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)myRst, (Statement)myStmt, (Connection)myConn);
        return ids;
    }

    private void appendTableMul_sp6(StringBuffer sb, String itemNumAndDimNum) {
        sb.append(" From T_Bg_BgData_v50 data  INNER JOIN T_BG_BgEntry_v50 entry ON data.FBgEntryID = entry.FID  INNER JOIN T_BD_Period period ON period.FID = entry.FPeriodID ");
        String[] strArr = itemNumAndDimNum.split(":");
        for (int i = 1; i <= strArr.length; ++i) {
            sb.append(" INNER JOIN  T_BG_BgItem_v50 T_BG_BgItem_" + i + " ON  entry.FBgItem" + i + "ID = T_BG_BgItem_" + i + ".FID");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int _getTemplateCycle(Context ctx, String orgNumber, String bgTypeNumber, String bgSchemeId) throws BOSException, EASBizException {
        int result = -1;
        String sql = " select fbgcycle from t_bg_bgtemplate  where fid in (select fbgtemplateid from t_bg_bgform where  forgunitid in (select fid from t_org_baseunit where fnumber=?) and  fbgtypeid in (select fid from t_bg_bgtype where fnumber=?) and  ( fstate=2 or fstate=1 ) and fbgschemeid=?) ";
        Connection conn = this.getConnection(ctx);
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, orgNumber);
            stmt.setString(2, bgTypeNumber);
            stmt.setString(3, bgSchemeId);
            rs = stmt.executeQuery();
            if (rs.next()) {
                result = rs.getInt(1);
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        }
        catch (SQLException ex) {
            new EASBizException(BgBizException.GETDATA, new Object[]{"getBgData"});
        }
        finally {
            SQLUtils.cleanup(rs, (Statement)stmt, (Connection)conn);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkIsRptBgForm(Context ctx, String strBgTypeNumber) throws SQLDataException {
        int result;
        ResultSet resultSet;
        Connection conn;
        PreparedStatement stmt;
        block4: {
            stmt = null;
            conn = this.getConnection(ctx);
            resultSet = null;
            result = 0;
            StringBuffer sb = new StringBuffer("select fIsRptBgForm from t_bg_bgtype_v50 where fnumber = '");
            sb.append(strBgTypeNumber);
            sb.append("'");
            try {
                stmt = conn.prepareStatement(sb.toString());
                resultSet = stmt.executeQuery();
                if (!resultSet.next()) break block4;
                result = resultSet.getInt("fIsRptBgForm");
            }
            catch (SQLException e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(resultSet, (Statement)stmt, (Connection)conn);
                    throw throwable;
                }
                SQLUtils.cleanup((ResultSet)resultSet, (Statement)stmt, (Connection)conn);
            }
        }
        SQLUtils.cleanup((ResultSet)resultSet, (Statement)stmt, (Connection)conn);
        return result != 0;
    }
}

