/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.ContextUtils;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.bg.BgBizException;
import com.kingdee.eas.ma.bg.BgOrgHelper;
import com.kingdee.eas.ma.bg.BgRptRowTypeEnum;
import com.kingdee.eas.ma.bg.BgRptTemplateCollection;
import com.kingdee.eas.ma.bg.BgRptTemplateDAFactory;
import com.kingdee.eas.ma.bg.BgRptTemplateFactory;
import com.kingdee.eas.ma.bg.BgRptTemplateInfo;
import com.kingdee.eas.ma.bg.BgRptTemplateRowInfo;
import com.kingdee.eas.ma.bg.BgTemplateException;
import com.kingdee.eas.ma.bg.BgTemplateFactory;
import com.kingdee.eas.ma.bg.BgTemplateHelper;
import com.kingdee.eas.ma.bg.BgTemplateInfo;
import com.kingdee.eas.ma.bg.IBgRptTemplate;
import com.kingdee.eas.ma.bg.IBgRptTemplateDA;
import com.kingdee.eas.ma.bg.IBgTemplate;
import com.kingdee.eas.ma.bg.app.AbstractBgRptTemplateControllerBean;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.Vector;

public class BgRptTemplateControllerBean
extends AbstractBgRptTemplateControllerBean {
    @Override
    protected IObjectValue _getCurrenctRptTemplate(Context ctx, BOSUuid bgTypeId, BOSUuid orgUnitId) throws BOSException, EASBizException {
        IBgRptTemplate iBgRptTemplate = BgRptTemplateFactory.getLocalInstance(ctx);
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("bgTemplate.orgUnit.id", (Object)orgUnitId.toString(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("bgTemplate.bgType.id", (Object)bgTypeId.toString(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("bgTemplate.isCurrent", (Object)"1", CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        BgRptTemplateCollection bgTpCollection = iBgRptTemplate.getBgRptTemplateCollection(entityViewInfo);
        if (bgTpCollection.size() == 0) {
            throw new BgTemplateException(BgTemplateException.NOCURRENTTEMPLATE);
        }
        if (bgTpCollection.size() > 1) {
            throw new BgTemplateException(BgTemplateException.MULTICURRENTTEMPLATE);
        }
        return bgTpCollection.get(0);
    }

    @Override
    protected void _deleteByTemplateId(Context ctx, IObjectPK id) throws EASBizException, BOSException {
        IBgTemplate iBgTp = BgTemplateFactory.getLocalInstance(ctx);
        iBgTp.checkRemovable(id.toString());
        IBgRptTemplateDA iBgRptTpDa = BgRptTemplateDAFactory.getLocalInstance(ctx);
        String rptId = iBgRptTpDa.getBgRptTpId(id.toString());
        if (rptId == null || rptId.equals("")) {
            iBgTp.delete(id);
        } else {
            this.delete(ctx, (IObjectPK)new ObjectUuidPK(rptId));
        }
    }

    @Override
    protected IObjectPK _addNewCurrent(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        BgTemplateInfo bgTpInfo = ((BgRptTemplateInfo)model).getBgTemplate();
        if (this.dupNumber(ctx, bgTpInfo.getId(), bgTpInfo.getNumber())) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{bgTpInfo.getNumber(), ""});
        }
        if (bgTpInfo.isIsCurrent()) {
            IBgTemplate iBgTp = BgTemplateFactory.getLocalInstance(ctx);
            iBgTp.prepareOneCurrent(null, bgTpInfo.getBgType().getId().toString(), bgTpInfo.getOrgUnit().getId().toString());
        }
        BgTemplateHelper.setCurrUserAndTime(ctx, bgTpInfo);
        return this._addnew(ctx, (IObjectValue)((BgRptTemplateInfo)model));
    }

    @Override
    protected void _updateCurrent(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        BgTemplateInfo bgTpInfo = ((BgRptTemplateInfo)model).getBgTemplate();
        if (this.dupNumber(ctx, bgTpInfo.getId(), bgTpInfo.getNumber())) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{bgTpInfo.getNumber(), ""});
        }
        if (bgTpInfo.isIsCurrent()) {
            IBgTemplate iBgTp = BgTemplateFactory.getLocalInstance(ctx);
            iBgTp.prepareOneCurrent(bgTpInfo.getId().toString(), bgTpInfo.getBgType().getId().toString(), bgTpInfo.getOrgUnit().getId().toString());
        }
        this.update(ctx, pk, (BgRptTemplateInfo)model);
    }

    @Override
    protected void _addClone(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IBgRptTemplateDA iBgRptTpDA = BgRptTemplateDAFactory.getLocalInstance(ctx);
        BgRptTemplateInfo originalBgRptTpInfo = iBgRptTpDA.getBgRptTpByBgTp(pk.toString());
        BgRptTemplateInfo clonedBgRptTpInfo = originalBgRptTpInfo.deepClone();
        BgTemplateHelper.setClonetNumberAndName(ctx, clonedBgRptTpInfo.getBgTemplate());
        clonedBgRptTpInfo.getBgTemplate().setIsCurrent(false);
        clonedBgRptTpInfo.getBgTemplate().setCreator(ContextUtils.getUser((Context)ctx));
        Timestamp time = new Timestamp(System.currentTimeMillis());
        clonedBgRptTpInfo.getBgTemplate().setCreateTime(time);
        this._addNewCurrent(ctx, (IObjectValue)clonedBgRptTpInfo);
    }

    @Override
    protected void _assign(Context ctx, Vector orgIdVec, BOSUuid bgTpId) throws EASBizException, BOSException {
        FullOrgUnitCollection orgs = new FullOrgUnitCollection();
        IFullOrgUnit iOrg = FullOrgUnitFactory.getLocalInstance((Context)ctx);
        for (int i = 0; i < orgIdVec.size(); ++i) {
            String id = (String)orgIdVec.elementAt(i);
            FullOrgUnitInfo info = iOrg.getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(id), BgOrgHelper.getUnitSelector());
            orgs.add(info);
        }
        this.innerAssign(ctx, orgs, bgTpId);
    }

    private void innerAssign(Context ctx, FullOrgUnitCollection orgs, BOSUuid bgTpId) throws EASBizException, BOSException {
        BgRptTemplateCollection brtc = new BgRptTemplateCollection();
        Iterator orgIter = orgs.iterator();
        IBgRptTemplateDA iBgRptTpDa = BgRptTemplateDAFactory.getLocalInstance(ctx);
        BgRptTemplateInfo originalBgRptTpInfo = iBgRptTpDa.getBgRptTpByBgTp(bgTpId.toString());
        while (orgIter.hasNext()) {
            FullOrgUnitInfo tempOrgInfo = (FullOrgUnitInfo)orgIter.next();
            BgRptTemplateInfo clonedRptTpInfo = originalBgRptTpInfo.deepClone();
            for (int i = 0; i < clonedRptTpInfo.getBgRptTpRows().size(); ++i) {
                if (clonedRptTpInfo.getBgRptTpRows().get(i).getNumber().trim().equals("TotalAssets") || clonedRptTpInfo.getBgRptTpRows().get(i).getNumber().trim().equals("TotalLiabilitiesAndEquity") || clonedRptTpInfo.getBgRptTpRows().get(i).getType().equals((Object)BgRptRowTypeEnum.Total)) continue;
                clonedRptTpInfo.getBgRptTpRows().get(i).setFormula("");
            }
            BgTemplateHelper.setSubNumberAndName(ctx, (OrgUnitInfo)tempOrgInfo, clonedRptTpInfo.getBgTemplate());
            clonedRptTpInfo.getBgTemplate().setOrgUnit(tempOrgInfo);
            clonedRptTpInfo.getBgTemplate().setIsCurrent(true);
            clonedRptTpInfo.getBgTemplate().setParent(originalBgRptTpInfo.getBgTemplate());
            Iterator it = clonedRptTpInfo.getBgRptTpRows().iterator();
            while (it.hasNext()) {
                BgRptTemplateRowInfo info = (BgRptTemplateRowInfo)it.next();
                info.setIsFromParent(true);
            }
            brtc.add(clonedRptTpInfo);
        }
        IBgRptTemplate iBgRptTp = BgRptTemplateFactory.getLocalInstance(ctx);
        Iterator lowerIter = brtc.iterator();
        while (lowerIter.hasNext()) {
            BgRptTemplateInfo lowerBgRptTpInfo = (BgRptTemplateInfo)lowerIter.next();
            iBgRptTp.addNewCurrent(lowerBgRptTpInfo);
        }
    }

    private boolean dupNumber(Context ctx, BOSUuid bgTpId, String number) throws BOSException, EASBizException {
        boolean bl;
        boolean result = false;
        String sql = "SELECT FNumber FROM T_BG_BgTemplate WHERE FNumber = ? AND FID <> ?";
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection(ctx);
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, number);
            stmt.setString(2, bgTpId == null ? "" : bgTpId.toString());
            rs = stmt.executeQuery();
            result = rs.next();
            bl = result;
        }
        catch (SQLException e) {
            try {
                throw new BgBizException(BgBizException.GETDATA, e, new Object[]{"T_BG_BgTemplate"});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return bl;
    }

    protected boolean _exists(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        boolean isExist = this.innerExists(ctx, pk);
        if (!isExist) {
            String strId = pk.toString();
            IBgRptTemplateDA iBgRptTemplateDa = BgRptTemplateDAFactory.getLocalInstance(ctx);
            strId = iBgRptTemplateDa.getBgRptTpId(strId);
            pk = new ObjectUuidPK(BOSUuid.read((String)strId));
            isExist = this.innerExists(ctx, pk);
        }
        return isExist;
    }
}

