/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.bg.BgCycleTypeEnum;
import com.kingdee.eas.ma.bg.BgInstantApproveException;
import com.kingdee.eas.ma.bg.app.AbstractBgSplitControllerBean;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class BgSplitControllerBean
extends AbstractBgSplitControllerBean {
    @Override
    protected IObjectCollection _getBgPeriods(Context ctx, String periodId, BgCycleTypeEnum bgCycle, int year, int season) throws BOSException, EASBizException {
        PeriodCollection result = new PeriodCollection();
        StringBuffer buf = new StringBuffer(40);
        buf.append(" select FId,FPeriodYear,FPeriodQuarter,FPeriodNumber from T_BD_Period  where ftypeid in (select ftypeId from t_bd_period where fid=?) and FIsAdjustPeriod=0 and fperiodyear=? ");
        if (bgCycle.equals((Object)BgCycleTypeEnum.Period)) {
            buf.append(" and fperiodquarter=? ");
        }
        buf.append(" order by FPeriodYear asc ,FPeriodQuarter asc,FPeriodNumber asc ");
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        int flag = 0;
        try {
            conn = this.getConnection(ctx);
            stmt = conn.prepareStatement(buf.toString());
            stmt.setString(1, periodId);
            stmt.setInt(2, year);
            if (bgCycle.equals((Object)BgCycleTypeEnum.Period)) {
                stmt.setInt(3, season);
            }
            rs = stmt.executeQuery();
            while (rs.next()) {
                if (bgCycle.equals((Object)BgCycleTypeEnum.Season)) {
                    if (flag == rs.getInt(3)) continue;
                    flag = rs.getInt(3);
                }
                PeriodInfo info = new PeriodInfo();
                info.setId(BOSUuid.read((String)rs.getString(1)));
                info.setPeriodYear(rs.getInt(2));
                info.setPeriodQuarter(rs.getInt(3));
                info.setPeriodNumber(rs.getInt(4));
                result.add(info);
            }
        }
        catch (SQLException e) {
            try {
                throw new BgInstantApproveException(BgInstantApproveException.DATABASEERROR, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return result;
    }

    @Override
    protected IObjectCollection _getBgPeriods(Context ctx, String bgFormId, BgCycleTypeEnum bgCycle) throws BOSException, EASBizException {
        PeriodCollection result = new PeriodCollection();
        StringBuffer buf = new StringBuffer(40);
        buf.append(" select FId,FPeriodYear,FPeriodQuarter,FPeriodNumber from T_BD_Period ");
        buf.append(" where fid in (select distinct fperiodId from t_bg_bgentry where fbgformid=? and fisLeafPeriod=1 and fbgcycle=? ) ");
        buf.append(" order by FPeriodYear asc ,FPeriodQuarter asc,FPeriodNumber asc ");
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection(ctx);
            stmt = conn.prepareStatement(buf.toString());
            stmt.setString(1, bgFormId);
            stmt.setInt(2, bgCycle.getValue());
            rs = stmt.executeQuery();
            while (rs.next()) {
                PeriodInfo info = new PeriodInfo();
                info.setId(BOSUuid.read((String)rs.getString(1)));
                info.setPeriodYear(rs.getInt(2));
                info.setPeriodQuarter(rs.getInt(3));
                info.setPeriodNumber(rs.getInt(4));
                result.add(info);
            }
        }
        catch (SQLException e) {
            try {
                throw new BgInstantApproveException(BgInstantApproveException.DATABASEERROR, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return result;
    }

    @Override
    protected IObjectCollection _getBgPeriods(Context ctx, String periodId, BgCycleTypeEnum sourceCycle, BgCycleTypeEnum targetCycle, int year, int season, int beginYear, int beginNumber, int endYear, int endNumber) throws BOSException, EASBizException {
        PeriodCollection result = new PeriodCollection();
        StringBuffer buf = new StringBuffer(40);
        buf.append(" select FId,FPeriodYear,FPeriodQuarter,FPeriodNumber from T_BD_Period  where ftypeid in (select ftypeId from t_bd_period where fid=?) and FIsAdjustPeriod=0 and fperiodyear=? ");
        if (sourceCycle.equals((Object)BgCycleTypeEnum.Season) && targetCycle.equals((Object)BgCycleTypeEnum.Period)) {
            buf.append(" and fperiodquarter=? ");
        }
        buf.append(" and ((FPeriodYear>");
        buf.append(beginYear);
        buf.append(" ) or (FPeriodYear=");
        buf.append(beginYear);
        buf.append(" and FPeriodNumber>=");
        buf.append(beginNumber);
        buf.append(" ))");
        buf.append(" and ((FPeriodYear<");
        buf.append(endYear);
        buf.append(" ) or (FPeriodYear=");
        buf.append(endYear);
        buf.append(" and FPeriodNumber<=");
        buf.append(endNumber);
        buf.append(" ))");
        buf.append(" order by FPeriodYear asc ,FPeriodQuarter asc,FPeriodNumber asc ");
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        int flag = 0;
        try {
            conn = this.getConnection(ctx);
            stmt = conn.prepareStatement(buf.toString());
            stmt.setString(1, periodId);
            stmt.setInt(2, year);
            if (sourceCycle.equals((Object)BgCycleTypeEnum.Season) && targetCycle.equals((Object)BgCycleTypeEnum.Period)) {
                stmt.setInt(3, season);
            }
            rs = stmt.executeQuery();
            while (rs.next()) {
                if (targetCycle.equals((Object)BgCycleTypeEnum.Season)) {
                    if (flag == rs.getInt(3)) continue;
                    flag = rs.getInt(3);
                }
                PeriodInfo info = new PeriodInfo();
                info.setId(BOSUuid.read((String)rs.getString(1)));
                info.setPeriodYear(rs.getInt(2));
                info.setPeriodQuarter(rs.getInt(3));
                info.setPeriodNumber(rs.getInt(4));
                result.add(info);
            }
        }
        catch (SQLException e) {
            try {
                throw new BgInstantApproveException(BgInstantApproveException.DATABASEERROR, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return result;
    }

    @Override
    protected boolean _isRefByBgCtrl(Context ctx, String bgFormId) throws BOSException, EASBizException {
        boolean bl;
        ResultSet rs;
        PreparedStatement stmt;
        Connection conn;
        block5: {
            PeriodCollection result = new PeriodCollection();
            StringBuffer buf = new StringBuffer(40);
            buf.append(" select top 1 FId from T_BG_BgCtrlDetailEntry ");
            buf.append(" where fbgdataid in ");
            buf.append(" ( select a.fId from t_bg_bgdata a,t_bg_bgentry b ");
            buf.append(" where a.fbgentryid=b.fid and b.fbgformid=?) ");
            conn = null;
            stmt = null;
            rs = null;
            boolean flag = false;
            conn = this.getConnection(ctx);
            stmt = conn.prepareStatement(buf.toString());
            stmt.setString(1, bgFormId);
            rs = stmt.executeQuery();
            if (!rs.next()) break block5;
            boolean bl2 = true;
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
            return bl2;
        }
        try {
            bl = false;
        }
        catch (SQLException e) {
            try {
                throw new BgInstantApproveException(BgInstantApproveException.DATABASEERROR, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return bl;
    }
}

