/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.ma.bg.BgBizException;
import com.kingdee.eas.ma.bg.BgCycleTypeEnum;
import com.kingdee.eas.ma.bg.BgHelper;
import com.kingdee.eas.ma.bg.BgItemInfo;
import com.kingdee.eas.ma.bg.BgManagerFactory;
import com.kingdee.eas.ma.bg.BgORMEngine;
import com.kingdee.eas.ma.bg.BgORMException;
import com.kingdee.eas.ma.bg.BgOrgHelper;
import com.kingdee.eas.ma.bg.BgTemplateCollection;
import com.kingdee.eas.ma.bg.BgTemplateColumnInfo;
import com.kingdee.eas.ma.bg.BgTemplateDAFactory;
import com.kingdee.eas.ma.bg.BgTemplateException;
import com.kingdee.eas.ma.bg.BgTemplateFactory;
import com.kingdee.eas.ma.bg.BgTemplateHelper;
import com.kingdee.eas.ma.bg.BgTemplateInfo;
import com.kingdee.eas.ma.bg.BgTemplateRowInfo;
import com.kingdee.eas.ma.bg.BgTypeInfo;
import com.kingdee.eas.ma.bg.CompressedObjectValue;
import com.kingdee.eas.ma.bg.IBgManager;
import com.kingdee.eas.ma.bg.IBgTemplate;
import com.kingdee.eas.ma.bg.IBgTemplateDA;
import com.kingdee.eas.ma.bg.ReferencedCurrencyInfo;
import com.kingdee.eas.ma.bg.ReferencedDimensionInfo;
import com.kingdee.eas.ma.bg.app.AbstractBgTemplateControllerBean;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;

public class BgTemplateControllerBean
extends AbstractBgTemplateControllerBean {
    private void addNewSubTemplates(Context ctx, IObjectCollection orgUnits, BOSUuid bgTpId) throws EASBizException, BOSException {
        BgTemplateCollection btc = new BgTemplateCollection();
        Iterator orgIter = orgUnits.iterator();
        IBgTemplateDA iBgTpDa = BgTemplateDAFactory.getLocalInstance(ctx);
        BgTemplateInfo originalBgTpInfo = iBgTpDa.getBgTemplate(bgTpId.toString());
        CtrlUnitInfo cuInfo = BgOrgHelper.getDefCU();
        while (orgIter.hasNext()) {
            boolean sameAccountTalbe;
            ReferencedDimensionInfo info;
            FullOrgUnitInfo subOrgInfo = (FullOrgUnitInfo)orgIter.next();
            BgTemplateInfo clonedTpInfo = originalBgTpInfo.deepClone();
            BgTemplateHelper.setSubNumberAndName(ctx, (OrgUnitInfo)subOrgInfo, clonedTpInfo);
            clonedTpInfo.setOrgUnit(subOrgInfo);
            clonedTpInfo.setIsCurrent(true);
            clonedTpInfo.setParent(originalBgTpInfo);
            clonedTpInfo.setCU(cuInfo);
            for (int i = 0; i < clonedTpInfo.getRefDimensions().size(); ++i) {
                info = clonedTpInfo.getRefDimensions().get(i);
                for (int j = 0; j < info.getBgItems().size(); ++j) {
                    info.getBgItems().get(j).setCU(cuInfo);
                }
            }
            if (originalBgTpInfo.getOrgUnit().isIsCompanyOrgUnit() && subOrgInfo.isIsCompanyOrgUnit() && !(sameAccountTalbe = this.checkSameAccountTable(ctx, originalBgTpInfo.getOrgUnit().getId().toString(), subOrgInfo.getId().toString()))) {
                BgTemplateHelper.setBgTemplateAccountByTargetOrgUnit(ctx, clonedTpInfo, (OrgUnitInfo)originalBgTpInfo.getOrgUnit(), (OrgUnitInfo)subOrgInfo);
                clonedTpInfo.initBgTpRows();
            }
            Iterator it = clonedTpInfo.getRefDimensions().iterator();
            while (it.hasNext()) {
                info = (ReferencedDimensionInfo)it.next();
                Iterator it1 = info.getBgItems().iterator();
                while (it1.hasNext()) {
                    BgItemInfo info1 = (BgItemInfo)it1.next();
                    info1.setIsFromParent(true);
                }
            }
            btc.add(clonedTpInfo);
        }
        IBgManager ibm = BgManagerFactory.getLocalInstance(ctx);
        IBgTemplate iBgTp = BgTemplateFactory.getLocalInstance(ctx);
        Iterator lowerIter = btc.iterator();
        while (lowerIter.hasNext()) {
            BgTemplateInfo lowerBgTpInfo = (BgTemplateInfo)lowerIter.next();
            this.prepareOneCurrent(ctx, null, lowerBgTpInfo.getBgType().getId().toString(), lowerBgTpInfo.getOrgUnit().getId().toString());
            IObjectPK iopk = iBgTp.addnew((CoreBaseInfo)lowerBgTpInfo);
            lowerBgTpInfo.setId(BOSUuid.read((String)iopk.toString()));
        }
    }

    private boolean checkSameAccountTable(Context ctx, String oriId, String subId) throws BgBizException {
        boolean bl;
        boolean result = false;
        String sql = "SELECT T_ORG_Company.FID, T_ORG_Company_Sub.FID FROM T_ORG_Company INNER JOIN T_ORG_Company T_ORG_Company_Sub ON T_ORG_Company.FAccountTableID = T_ORG_Company_Sub.FAccountTableID WHERE (T_ORG_Company.FID = ?) AND (T_ORG_Company_Sub.FID = ?)";
        PreparedStatement ps = null;
        ResultSet rs = null;
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            ps = conn.prepareStatement(sql);
            ps.setString(1, oriId);
            ps.setString(2, subId);
            rs = ps.executeQuery();
            result = rs.next();
            bl = result;
        }
        catch (Exception e) {
            try {
                throw new BgBizException(BgBizException.GETDATA, e, new Object[]{"T_ORG_Company"});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return bl;
    }

    private IObjectCollection getCollctionByOrgUnit(Context ctx, IObjectValue orgUnitInfo, boolean isValid) throws BOSException {
        BgTemplateCollection bgTemplateCollection = new BgTemplateCollection();
        PreparedStatement ps = null;
        ResultSet rs = null;
        Connection connection = null;
        try {
            connection = this.getConnection(ctx);
            StringBuffer strBuffer = new StringBuffer(400);
            strBuffer.append("SELECT bgTemplate.FID AS FId, bgTemplate.FNumber AS FNumber, bgTemplate.FName AS FName, bgTemplate.FBgTypeID AS FBgTypeId, bgType.FName_L2 AS FBgTypeName, bgType.FNumber AS FBgTypeNumber, bgType.FIsRptBgForm AS FIsRptBgForm , bgTemplate.FCreatorID AS FCreatorId, tUSER.FName_L2 AS FUserName, bgTemplate.FCreateTime AS FcreateTime FROM T_BG_BgTemplate bgTemplate, T_BG_BgType bgType,  T_PM_User tUSER ,T_ORG_BaseUnit unit where bgTemplate.FBgTypeID = bgType.FID and bgTemplate.FCreatorID = tUSER.FID and bgTemplate.FOrgUnitID = unit.FID and unit.FIsOUSealUp = 0 and bgType.FIsEffective = 1");
            boolean isHasOrg = false;
            if (orgUnitInfo != null && orgUnitInfo.get("id").toString() != null) {
                isHasOrg = true;
            }
            if (isHasOrg) {
                strBuffer.append(" and ( unit.FLongNumber like '");
                strBuffer.append(((FullOrgUnitInfo)orgUnitInfo).getLongNumber() + "!%");
                strBuffer.append("'");
                strBuffer.append(" or unit.FLongNumber = '");
                strBuffer.append(((FullOrgUnitInfo)orgUnitInfo).getLongNumber());
                strBuffer.append("' )");
                strBuffer.append(" and unit.FControlUnitID = '");
                strBuffer.append(((FullOrgUnitInfo)orgUnitInfo).getId().toString());
                strBuffer.append("'");
            }
            if (isValid) {
                strBuffer.append(" and FisCurrent = 1 ");
            }
            ps = connection.prepareStatement(strBuffer.toString());
            strBuffer = null;
            rs = ps.executeQuery();
            while (rs.next()) {
                BgTemplateInfo bgTemplateInfo = new BgTemplateInfo();
                bgTemplateInfo.setId(BOSUuid.read((String)rs.getString("fid")));
                bgTemplateInfo.setNumber(rs.getString("FNumber"));
                bgTemplateInfo.setName(rs.getString("FName"));
                BgTypeInfo bgTypeInfo = new BgTypeInfo();
                bgTypeInfo.setId(BOSUuid.read((String)rs.getString("FBgTypeId")));
                bgTypeInfo.setName(rs.getString("FBgTypeName"));
                bgTypeInfo.setNumber(rs.getString("FBgTypeNumber"));
                bgTypeInfo.setIsRptBgForm(rs.getInt("FIsRptBgForm") == 1);
                bgTemplateInfo.setBgType(bgTypeInfo);
                UserInfo userInfo = new UserInfo();
                userInfo.setId(BOSUuid.read((String)rs.getString("FCreatorId")));
                userInfo.setName(rs.getString("FUserName"));
                bgTemplateInfo.setCreator(userInfo);
                bgTemplateInfo.setCreateTime(rs.getTimestamp("FcreateTime"));
                bgTemplateCollection.add(bgTemplateInfo);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException(e.toString());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)connection);
        return bgTemplateCollection;
    }

    @Override
    protected IObjectPK _addNewCurrent(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        BgTemplateInfo bgTpInfo = null;
        if (model instanceof CompressedObjectValue) {
            try {
                bgTpInfo = (BgTemplateInfo)((CompressedObjectValue)model).getUncompressedObject();
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        } else {
            bgTpInfo = (BgTemplateInfo)model;
        }
        if (bgTpInfo.isIsCurrent()) {
            this.prepareOneCurrent(ctx, null, bgTpInfo.getBgType().getId().toString(), bgTpInfo.getOrgUnit().getId().toString());
        }
        IObjectPK rs = this.addnew(ctx, (CoreBaseInfo)bgTpInfo);
        return rs;
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkNumberDup(ctx, null, (CoreBillBaseInfo)((BgTemplateInfo)model));
        if (BgHelper.ISDeBug) {
            BgTemplateInfo info = (BgTemplateInfo)model;
            if (info.isIsCurrent()) {
                this.prepareOneCurrent(ctx, null, info.getBgType().getId().toString(), info.getOrgUnit().getId().toString());
            }
            BgTemplateHelper.setCurrUserAndTime(ctx, info);
            ArrayList<BgItemInfo> itemColl = new ArrayList<BgItemInfo>();
            ArrayList<ReferencedDimensionInfo> refItemColl = new ArrayList<ReferencedDimensionInfo>();
            ArrayList<ReferencedCurrencyInfo> refCurrColl = new ArrayList<ReferencedCurrencyInfo>();
            ArrayList<BgTemplateColumnInfo> tpcColl = new ArrayList<BgTemplateColumnInfo>();
            ArrayList<BgTemplateRowInfo> tprColl = new ArrayList<BgTemplateRowInfo>();
            Iterator iter = info.getRefDimensions().iterator();
            while (iter.hasNext()) {
                ReferencedDimensionInfo refItem = (ReferencedDimensionInfo)iter.next();
                Iterator dataIter = refItem.getBgItems().iterator();
                while (dataIter.hasNext()) {
                    BgItemInfo bgItem = (BgItemInfo)dataIter.next();
                    bgItem.setRefDimension(refItem);
                    itemColl.add(bgItem);
                }
                refItem.setBgTemplate(info);
                refItemColl.add(refItem);
            }
            iter = info.getRefCurrencies().iterator();
            while (iter.hasNext()) {
                ReferencedCurrencyInfo refCur = (ReferencedCurrencyInfo)iter.next();
                refCur.setBgTemplate(info);
                refCurrColl.add(refCur);
            }
            iter = info.getBgTpColumns().iterator();
            while (iter.hasNext()) {
                BgTemplateColumnInfo tpc = (BgTemplateColumnInfo)iter.next();
                tpc.setBgTemplate(info);
                tpcColl.add(tpc);
            }
            iter = info.getBgTpRows().iterator();
            while (iter.hasNext()) {
                BgTemplateRowInfo tpr = (BgTemplateRowInfo)iter.next();
                tpr.setBgTemplate(info);
                tprColl.add(tpr);
            }
            BgItemInfo[] bgItemAry = new BgItemInfo[]{};
            ReferencedDimensionInfo[] refItemAry = new ReferencedDimensionInfo[]{};
            ReferencedCurrencyInfo[] refCurAry = new ReferencedCurrencyInfo[]{};
            BgTemplateColumnInfo[] tpcAry = new BgTemplateColumnInfo[]{};
            BgTemplateRowInfo[] tprAry = new BgTemplateRowInfo[]{};
            BgORMEngine.addnewVO(ctx, (IObjectValue[])new BgTemplateInfo[]{info});
            BgORMEngine.addnewVO(ctx, (IObjectValue[])refItemColl.toArray(refItemAry));
            BgORMEngine.addnewVO(ctx, (IObjectValue[])itemColl.toArray(bgItemAry));
            BgORMEngine.addnewVO(ctx, (IObjectValue[])refCurrColl.toArray(refCurAry));
            BgORMEngine.addnewVO(ctx, (IObjectValue[])tpcColl.toArray(tpcAry));
            BgORMEngine.addnewVO(ctx, (IObjectValue[])tprColl.toArray(tprAry));
            return new ObjectUuidPK(info.getId());
        }
        return super._addnew(ctx, model);
    }

    @Override
    protected void _updateCurrent(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        BgTemplateInfo bgTpInfo = (BgTemplateInfo)model;
        if (bgTpInfo.isIsCurrent()) {
            this._prepareOneCurrent(ctx, bgTpInfo.getId().toString(), bgTpInfo.getBgType().getId().toString(), bgTpInfo.getOrgUnit().getId().toString());
        }
        this.update(ctx, (IObjectPK)new ObjectUuidPK(bgTpInfo.getId()), (CoreBaseInfo)bgTpInfo);
        this.clearSchemeFormula(ctx, bgTpInfo);
    }

    private void clearSchemeFormula(Context ctx, BgTemplateInfo bgTpInfo) throws BOSException, EASBizException {
        Connection connection = null;
        PreparedStatement ps = null;
        String sql = "delete from T_BG_BgFormula where FBgElementId=? and FBgModelNodeID in (select fid from T_BG_BgModelNode where FBgTemplateID=?)";
        String templateId = bgTpInfo.getId().toString();
        String elementId = "";
        try {
            connection = this.getConnection(ctx);
            BgTemplateColumnInfo[] columnInfo = (BgTemplateColumnInfo[])bgTpInfo.get("tpcolkey");
            if (columnInfo == null) {
                return;
            }
            int n = columnInfo.length;
            for (int i = 0; i < n; ++i) {
                String formula = columnInfo[i].getFormula();
                if (formula == null || formula.trim().equals("")) continue;
                ps = connection.prepareStatement(sql);
                elementId = columnInfo[i].getBgElement().getId().toString();
                ps.setString(1, elementId);
                ps.setString(2, templateId);
                ps.executeUpdate();
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(ps, (Connection)connection);
        }
    }

    @Override
    protected void _prepareOneCurrent(Context ctx, String bgTpId, String bgTypeId, String orgUnitId) throws BOSException, EASBizException {
        String sql = "UPDATE T_BG_BgTemplate SET FIsCurrent = 0 WHERE FID != ? AND FBgTypeID = ? AND FOrgUnitID = ?";
        PreparedStatement stmt = null;
        Connection connection = this.getConnection(ctx);
        try {
            stmt = connection.prepareStatement(sql);
            stmt.setString(1, bgTpId == null ? "xxxfffffsss" : bgTpId);
            stmt.setString(2, bgTypeId);
            stmt.setString(3, orgUnitId);
            stmt.execute();
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Statement)stmt, (Connection)connection);
        }
    }

    @Override
    protected void _deleteWithCheck(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.checkRemovable(ctx, pk.toString());
        this.delete(ctx, pk);
    }

    @Override
    protected void _checkRemovable(Context ctx, String id) throws BOSException, EASBizException {
        if (id == null) {
            return;
        }
        if (this.checkRefByBgForm(ctx, BOSUuid.read((String)id))) {
            throw new BgTemplateException(BgTemplateException.REFBYFORM);
        }
        if (this.checkRefByChild(ctx, BOSUuid.read((String)id))) {
            throw new BgTemplateException(BgTemplateException.REFBYCHILD);
        }
        this.deleteBgModelNode(ctx, id);
    }

    @Override
    protected boolean _checkRefByBgForm(Context ctx, BOSUuid bgTpId) throws BOSException {
        boolean result = false;
        String sqlForm = "SELECT FID FROM T_BG_BgForm WHERE FBgTemplateID='" + bgTpId.toString() + "'";
        ISQLExecutor iExecutor = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sqlForm);
        IRowSet irs = iExecutor.executeSQL();
        if (irs.size() != 0) {
            result = true;
        }
        return result;
    }

    @Override
    protected boolean _checkRefByBgScheme(Context ctx, BOSUuid bgTpId) throws BOSException {
        boolean result = false;
        String sqlForm = "SELECT FID FROM T_BG_BgModelNode WHERE FBgTemplateID='" + bgTpId.toString() + "'";
        ISQLExecutor iExecutor = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sqlForm);
        IRowSet irs = iExecutor.executeSQL();
        if (irs.size() != 0) {
            result = true;
        }
        return result;
    }

    @Override
    protected boolean _checkRefByChild(Context ctx, BOSUuid bgTpId) throws BOSException {
        boolean result = false;
        String sqlForm = "SELECT FID FROM T_BG_BgTemplate WHERE FParentID='" + bgTpId.toString() + "'";
        ISQLExecutor iExecutor = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sqlForm);
        IRowSet irs = iExecutor.executeSQL();
        if (irs.size() != 0) {
            result = true;
        }
        return result;
    }

    @Override
    protected IObjectPK _addClone(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BgTemplateInfo bgTpInfo = BgTemplateDAFactory.getLocalInstance(ctx).getBgTemplate(pk.toString());
        BgTemplateInfo clonedTpInfo = bgTpInfo.deepClone();
        BgTemplateHelper.setClonetNumberAndName(ctx, clonedTpInfo);
        clonedTpInfo.setIsCurrent(false);
        CtrlUnitInfo cuInfo = BgOrgHelper.getDefCU();
        clonedTpInfo.setCU(cuInfo);
        for (int i = 0; i < clonedTpInfo.getRefDimensions().size(); ++i) {
            ReferencedDimensionInfo info = clonedTpInfo.getRefDimensions().get(i);
            for (int j = 0; j < info.getBgItems().size(); ++j) {
                info.getBgItems().get(j).setCU(cuInfo);
            }
        }
        return this.addnew(ctx, (CoreBaseInfo)clonedTpInfo);
    }

    private void deleteBgModelNode(Context ctx, String strTemplateId) throws EASBizException, BOSException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        Connection connection = null;
        PreparedStatement statement = null;
        try {
            connection = this.getConnection(ctx);
            StringBuffer strBuffer = new StringBuffer(100);
            strBuffer.append("Select fid from T_Bg_BgModelNode where ");
            if (strTemplateId != null && strTemplateId.length() > 0) {
                strBuffer.append(" FBgTemplateID = '");
                strBuffer.append(BOSUuid.read((String)strTemplateId).toString());
                strBuffer.append("'");
            }
            ps = connection.prepareStatement(strBuffer.toString());
            strBuffer = null;
            rs = ps.executeQuery();
            Vector<String> vec = new Vector<String>();
            while (rs.next()) {
                vec.add(rs.getString("fid"));
            }
            int size = vec.size();
            String sqlDel1 = "Delete T_BG_BgFormula where FBgModelNodeId =?";
            String sqlDel2 = "Delete T_BG_BgModelNode where FId =?";
            for (int i = 0; i < size; ++i) {
                String strId = (String)vec.get(i);
                statement = connection.prepareStatement(sqlDel1);
                statement.setString(1, strId);
                statement.execute();
                statement = connection.prepareStatement(sqlDel2);
                statement.setString(1, strId);
                statement.execute();
            }
        }
        catch (SQLException e) {
            try {
                throw new EASBizException(new NumericExceptionSubItem("BgModeNodeDelete", "BgTemplateDelete"), (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)connection);
                SQLUtils.cleanup(statement);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)connection);
        SQLUtils.cleanup(statement);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        BgTemplateInfo newMode = (BgTemplateInfo)model;
        this.checkNumberDup(ctx, (IObjectPK)new ObjectUuidPK(newMode.getId()), (CoreBillBaseInfo)((BgTemplateInfo)model));
        if (BgORMEngine.getIsBgORM(model)) {
            String[] ormObjectAry = BgORMEngine.getORMObjectAry(model);
            String[] bgProperty = BgORMEngine.getMainPropertyAry(model);
            BgORMEngine.storeVOColl(ctx, new IObjectValue[]{model}, bgProperty);
            for (int i = 0; i < ormObjectAry.length; ++i) {
                IObjectValue[] coll = (IObjectValue[])model.get(ormObjectAry[i] + "key");
                BOSUuid[] ids = (BOSUuid[])model.get(ormObjectAry[i] + "deletedIds");
                if (ids != null && ids.length > 0) {
                    if (ormObjectAry[i].equals("dim")) {
                        this.removeBgItemFormBgFormula(ctx, ids);
                        BgItemInfo item = new BgItemInfo();
                        BgORMEngine.removeVOColl(ctx, item.getBOSType(), "RefDimension", ids);
                    } else if (ormObjectAry[i].equals("tprow")) {
                        // empty if block
                    }
                    BgORMEngine.removeVOColl(ctx, ids);
                }
                if (coll == null || coll.length <= 0) continue;
                BgORMEngine.storeVOColl(ctx, coll, (String[])model.get(ormObjectAry[i] + "property"));
            }
        } else {
            super._update(ctx, pk, model);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeBgItemFormBgFormula(Context ctx, BOSUuid[] ids) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection(ctx);
            Vector<String> vec = new Vector<String>();
            for (int i = 0; i < ids.length; ++i) {
                String strSql = "select Fid from T_BG_BgItem where FRefDimensionID ='" + BOSUuid.read((String)ids[i].toString()).toString() + "'";
                stmt = conn.prepareStatement(strSql);
                rs = stmt.executeQuery();
                while (rs.next()) {
                    vec.add(rs.getString("Fid"));
                }
            }
            int size = vec.size();
            for (int i = 0; i < size; ++i) {
                String strId = (String)vec.get(i);
                String strDel = "delete t_Bg_BgFormula where fbgItem1id = ? or fbgItem2id = ? or fbgItem3id = ? or fbgItem4id = ? or fbgItem5id = ? or fbgItem6id = ? ";
                stmt = conn.prepareStatement(strDel);
                int index = 1;
                stmt.setString(index++, BOSUuid.read((String)strId).toString());
                stmt.setString(index++, BOSUuid.read((String)strId).toString());
                stmt.setString(index++, BOSUuid.read((String)strId).toString());
                stmt.setString(index++, BOSUuid.read((String)strId).toString());
                stmt.setString(index++, BOSUuid.read((String)strId).toString());
                stmt.setString(index++, BOSUuid.read((String)strId).toString());
                stmt.execute();
            }
        }
        catch (SQLException e1) {
            new BOSException((Throwable)e1);
        }
        finally {
            SQLUtils.cleanup(rs, stmt, (Connection)conn);
        }
    }

    @Override
    protected void _addNewSubTemplates(Context ctx, Vector orgIdVec, BOSUuid bgTpId) throws EASBizException, BOSException {
        FullOrgUnitCollection orgs = new FullOrgUnitCollection();
        IFullOrgUnit iOrg = FullOrgUnitFactory.getLocalInstance((Context)ctx);
        for (int i = 0; i < orgIdVec.size(); ++i) {
            String id = (String)orgIdVec.elementAt(i);
            FullOrgUnitInfo info = iOrg.getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(id), BgOrgHelper.getUnitSelector());
            orgs.add(info);
        }
        this.addNewSubTemplates(ctx, (IObjectCollection)orgs, bgTpId);
    }

    @Override
    protected IObjectCollection _getCollctionByOrgUnit(Context ctx, String orgId, boolean isValid) throws EASBizException, BOSException {
        IFullOrgUnit iOrg = FullOrgUnitFactory.getLocalInstance((Context)ctx);
        FullOrgUnitInfo info = iOrg.getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgId), BgOrgHelper.getUnitSelector());
        return this.getCollctionByOrgUnit(ctx, (IObjectValue)info, isValid);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        block5: {
            block4: {
                if (!BgHelper.ISDeBug) break block4;
                String delBgItemSql = " DELETE FROM T_BG_BgItem  WHERE (FRefDimensionID IN ( SELECT fid FROM T_BG_ReferencedDimension  WHERE fbgtemplateid = ?))";
                String delRefDimSql = " DELETE FROM T_BG_ReferencedDimension WHERE (FBgTemplateID = ?)";
                String delTpRsql = " DELETE FROM T_BG_BgTemplateRow WHERE (FBgTemplateID = ?)";
                String delTpCSql = " DELETE FROM T_BG_BgTemplateColumn WHERE (FBgTemplateID = ?)";
                String delRefCurSql = " DELETE FROM T_BG_ReferencedCurrency WHERE (FBgTemplateID = ?)";
                String delBgTempateSql = " DELETE FROM T_BG_BgTemplate WHERE (FID = ?)";
                String noCheckSql = null;
                Connection conn = null;
                PreparedStatement stmt = null;
                try {
                    conn = this.getConnection(ctx);
                    noCheckSql = "/*dialect*/ ALTER TABLE T_Bg_BgEntry NOCHECK CONSTRAINT FK_BG_BEY_BIT1 ";
                    stmt = conn.prepareStatement(noCheckSql);
                    stmt.executeUpdate();
                    noCheckSql = "/*dialect*/ ALTER TABLE T_Bg_BgEntry NOCHECK CONSTRAINT FK_BG_BEY_BIT2 ";
                    stmt = conn.prepareStatement(noCheckSql);
                    stmt.executeUpdate();
                    noCheckSql = "/*dialect*/ ALTER TABLE T_Bg_BgEntry NOCHECK CONSTRAINT FK_BG_BEY_BIT3 ";
                    stmt = conn.prepareStatement(noCheckSql);
                    stmt.executeUpdate();
                    noCheckSql = "/*dialect*/ ALTER TABLE T_Bg_BgEntry NOCHECK CONSTRAINT FK_BG_BEY_BIT4 ";
                    stmt = conn.prepareStatement(noCheckSql);
                    stmt.executeUpdate();
                    noCheckSql = "/*dialect*/ ALTER TABLE T_Bg_BgEntry NOCHECK CONSTRAINT FK_BG_BEY_BIT5 ";
                    stmt = conn.prepareStatement(noCheckSql);
                    stmt.executeUpdate();
                    noCheckSql = "/*dialect*/ ALTER TABLE T_Bg_BgEntry NOCHECK CONSTRAINT FK_BG_BEY_BIT6 ";
                    stmt = conn.prepareStatement(noCheckSql);
                    stmt.executeUpdate();
                    String id = pk.toString();
                    stmt = conn.prepareStatement(delBgItemSql);
                    stmt.setString(1, id);
                    stmt.executeUpdate();
                    noCheckSql = "/*dialect*/ ALTER TABLE T_Bg_BgEntry CHECK CONSTRAINT FK_BG_BEY_BIT1 ";
                    stmt = conn.prepareStatement(noCheckSql);
                    stmt.executeUpdate();
                    noCheckSql = "/*dialect*/ ALTER TABLE T_Bg_BgEntry CHECK CONSTRAINT FK_BG_BEY_BIT2 ";
                    stmt = conn.prepareStatement(noCheckSql);
                    stmt.executeUpdate();
                    noCheckSql = "/*dialect*/ ALTER TABLE T_Bg_BgEntry CHECK CONSTRAINT FK_BG_BEY_BIT3 ";
                    stmt = conn.prepareStatement(noCheckSql);
                    stmt.executeUpdate();
                    noCheckSql = "/*dialect*/ ALTER TABLE T_Bg_BgEntry CHECK CONSTRAINT FK_BG_BEY_BIT4 ";
                    stmt = conn.prepareStatement(noCheckSql);
                    stmt.executeUpdate();
                    noCheckSql = "/*dialect*/ ALTER TABLE T_Bg_BgEntry CHECK CONSTRAINT FK_BG_BEY_BIT5 ";
                    stmt = conn.prepareStatement(noCheckSql);
                    stmt.executeUpdate();
                    noCheckSql = "/*dialect*/ ALTER TABLE T_Bg_BgEntry CHECK CONSTRAINT FK_BG_BEY_BIT6 ";
                    stmt = conn.prepareStatement(noCheckSql);
                    stmt.executeUpdate();
                    stmt = conn.prepareStatement(delRefDimSql);
                    stmt.setString(1, id);
                    stmt.executeUpdate();
                    stmt = conn.prepareStatement(delTpRsql);
                    stmt.setString(1, id);
                    stmt.executeUpdate();
                    stmt = conn.prepareStatement(delTpCSql);
                    stmt.setString(1, id);
                    stmt.executeUpdate();
                    stmt = conn.prepareStatement(delRefCurSql);
                    stmt.setString(1, id);
                    stmt.executeUpdate();
                    stmt = conn.prepareStatement(delBgTempateSql);
                    stmt.setString(1, id);
                    stmt.executeUpdate();
                }
                catch (SQLException e) {
                    try {
                        throw new BgORMException(BgORMException.DELETEENTITY, e, new Object[]{pk});
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(stmt, (Connection)conn);
                        throw throwable;
                    }
                }
                SQLUtils.cleanup((Statement)stmt, (Connection)conn);
                break block5;
            }
            super._delete(ctx, pk);
        }
    }

    @Override
    protected void _splitClone(Context ctx, BOSUuid templateId, BOSUuid formId) throws BOSException, EASBizException {
        BgTemplateInfo bgTpInfo = BgTemplateDAFactory.getLocalInstance(ctx).getBgTemplate(templateId.toString());
        BgTemplateInfo clonedTpInfo = bgTpInfo.deepClone();
        clonedTpInfo.setParent(bgTpInfo.getParent());
        BgCycleTypeEnum bgCycle = clonedTpInfo.getBgCycle();
        if (bgCycle == BgCycleTypeEnum.Period) {
            return;
        }
        if (bgCycle == BgCycleTypeEnum.Season) {
            clonedTpInfo.setBgCycle(BgCycleTypeEnum.Period);
        } else if (bgCycle == BgCycleTypeEnum.Year) {
            clonedTpInfo.setBgCycle(BgCycleTypeEnum.Season);
        }
        BgTemplateHelper.setClonetNumberAndName(ctx, clonedTpInfo);
        clonedTpInfo.setIsCurrent(false);
        CtrlUnitInfo cuInfo = BgOrgHelper.getDefCU();
        clonedTpInfo.setCU(cuInfo);
        for (int i = 0; i < clonedTpInfo.getRefDimensions().size(); ++i) {
            ReferencedDimensionInfo info = clonedTpInfo.getRefDimensions().get(i);
            for (int j = 0; j < info.getBgItems().size(); ++j) {
                info.getBgItems().get(j).setCU(cuInfo);
            }
        }
        IObjectPK clonePk = this.addnew(ctx, (CoreBaseInfo)clonedTpInfo);
        Connection connection = null;
        PreparedStatement ps = null;
        String sql = "update T_BG_BgForm set FBgTemplateId=?  where FID=?";
        String fid = formId.toString();
        try {
            connection = this.getConnection(ctx);
            ps = connection.prepareStatement(sql);
            ps.setString(1, clonePk.toString());
            ps.setString(2, fid);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)connection);
        sql = "update T_BG_BgTemplate set FParentId=? where FParentId=?";
        try {
            connection = this.getConnection(ctx);
            ps = connection.prepareStatement(sql);
            ps.setString(1, clonePk.toString());
            ps.setString(2, templateId.toString());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Statement)ps, (Connection)connection);
        }
    }
}

