/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.bg.BgBizException;
import com.kingdee.eas.ma.bg.BgCycleTypeEnum;
import com.kingdee.eas.ma.bg.BgDaHelper;
import com.kingdee.eas.ma.bg.BgElementInfo;
import com.kingdee.eas.ma.bg.BgItemCollection;
import com.kingdee.eas.ma.bg.BgItemInfo;
import com.kingdee.eas.ma.bg.BgTemplateColumnCollection;
import com.kingdee.eas.ma.bg.BgTemplateColumnInfo;
import com.kingdee.eas.ma.bg.BgTemplateException;
import com.kingdee.eas.ma.bg.BgTemplateInfo;
import com.kingdee.eas.ma.bg.BgTemplateRowCollection;
import com.kingdee.eas.ma.bg.BgTemplateRowInfo;
import com.kingdee.eas.ma.bg.BgTypeFactory;
import com.kingdee.eas.ma.bg.BgTypeInfo;
import com.kingdee.eas.ma.bg.IBgType;
import com.kingdee.eas.ma.bg.ReferencedCurrencyCollection;
import com.kingdee.eas.ma.bg.ReferencedCurrencyInfo;
import com.kingdee.eas.ma.bg.ReferencedDimensionCollection;
import com.kingdee.eas.ma.bg.ReferencedDimensionInfo;
import com.kingdee.eas.ma.bg.app.AbstractBgTemplateDAControllerBean;
import com.kingdee.util.UuidException;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class BgTemplateDAControllerBean
extends AbstractBgTemplateDAControllerBean {
    @Override
    protected IObjectValue _getCurrentBgTemplate(Context ctx, String orgUnitId, String bgTypeId) throws BOSException, EASBizException {
        Connection conn = null;
        BgTemplateInfo result = null;
        try {
            conn = this.getConnection(ctx);
            result = this.innerGetCurrentBgTemplate(conn, orgUnitId, bgTypeId);
        }
        catch (SQLException e) {
            throw new BgBizException(BgBizException.GETDATA);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return result;
    }

    @Override
    protected IObjectValue _getCurrentBgTemplate(Context ctx, Vector orgIdVector, String bgTypeId) throws BOSException, EASBizException {
        Connection conn = null;
        BgTemplateInfo result = null;
        try {
            conn = this.getConnection(ctx);
            int size = orgIdVector.size();
            for (int i = 0; i < size; ++i) {
                String orgUnitId = (String)orgIdVector.get(i);
                result = this.innerGetCurrentBgTemplate(conn, orgUnitId, bgTypeId);
                if (result == null) continue;
                break;
            }
        }
        catch (SQLException e) {
            throw new BgBizException(BgBizException.GETDATA);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BgTemplateInfo innerGetCurrentBgTemplate(Connection conn, String orgUnitId, String bgTypeId) throws BOSException, EASBizException, SQLException {
        BgTemplateInfo result = null;
        String sql = "SELECT FID,FNUMBER,FNAME, FBgCycle FROM T_BG_BgTemplate WHERE (FIsCurrent = 1) AND FOrgUnitID = ? AND FBgTypeID = ?";
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        try {
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, orgUnitId);
            stmt.setString(2, bgTypeId);
            resultSet = stmt.executeQuery();
            if (resultSet.next()) {
                result = new BgTemplateInfo();
                result.setId(BOSUuid.read((String)resultSet.getString("FID")));
                result.setNumber(resultSet.getString("FNUMBER"));
                result.setName(resultSet.getString("FNAME"));
                result.setBgCycle(BgCycleTypeEnum.getEnum(resultSet.getInt("FBgCycle")));
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(resultSet, (Statement)stmt);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)resultSet, (Statement)stmt);
        return result;
    }

    @Override
    protected IObjectValue _getBgTemplate(Context ctx, String templateId) throws BOSException, EASBizException {
        BgTemplateInfo bgTemplateInfo;
        StringBuffer sb = new StringBuffer(2048);
        sb.append("SELECT T_BG_BgTemplate.FID AS fid,T_BG_BgTemplate.FNumber AS fnumber,");
        sb.append("T_BG_BgTemplate.FName AS fname, T_BG_BgTemplate.FBgCycle AS bgCycle,");
        sb.append("T_BG_BgTemplate.FRollingBgCycle AS rollingBgCycle, ");
        sb.append("T_BG_BgTemplate.FBgMethod AS bgMethod,");
        sb.append("T_BG_BgTemplate.FApproveStyle AS approveStyle,");
        sb.append("T_BG_BgTemplate.FIsMultidimensional AS isMultidimensional,");
        sb.append("T_BG_BgTemplate.FIsCurrent AS isCurrent,");
        sb.append("T_BG_BgTemplate.FParentID AS parent, ");
        sb.append("T_BG_BgTemplate.FBgCtrlType AS bgCtrlType, ");
        sb.append("T_BG_BgTemplate.FCreatorID AS creatorId, ");
        sb.append("T_BG_BgTemplate.FCreateTime AS createTime, ");
        sb.append("T_BG_BgTemplate.FBgTypeID AS bgTypeId,");
        sb.append("T_BG_BgTemplate.FOrgUnitID AS orgUnitId, ");
        sb.append("T_BG_BgType.FSeq AS bgType_seq,");
        sb.append("T_BG_BgType.FNumber AS bgType_number,");
        sb.append("T_BG_BgType.FName_@L@ AS bgType_name,");
        sb.append("T_BG_BgType.FControllable AS bgType_controllable,");
        sb.append("T_PM_User.FID AS fuser_id,");
        sb.append("T_PM_User.FNumber AS user_number,");
        sb.append("T_PM_User.FName_@L@ AS user_name,");
        sb.append("T_BG_BgTemplate.FCompanyID AS companyId,");
        sb.append("T_ORG_BaseUnit.FID AS orgUnit_id,");
        sb.append("T_ORG_BaseUnit.FNumber AS orgUnit_number,");
        sb.append("T_ORG_BaseUnit.FName_@L@ AS orgUnit_name ");
        sb.append(" FROM T_BG_BgTemplate ");
        sb.append(" LEFT OUTER JOIN T_PM_User ON T_PM_User.FID = T_BG_BgTemplate.FCreatorID ");
        sb.append(" INNER JOIN T_BG_BgType ON T_BG_BgType.FID = T_BG_BgTemplate.FBgTypeID ");
        sb.append(" INNER JOIN T_ORG_BaseUnit ON T_BG_BgTemplate.FOrgUnitID = T_ORG_BaseUnit.FID ");
        sb.append(" WHERE T_BG_BgTemplate.FID = ? ");
        Connection conn = this.getConnection(ctx);
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        try {
            stmt = conn.prepareStatement(BgDaHelper.convert(ctx, sb.toString()));
            stmt.setString(1, templateId);
            resultSet = stmt.executeQuery();
            BgTemplateInfo bgTemplateInfo2 = null;
            if (!resultSet.next()) {
                throw new BgBizException(BgBizException.GETDATA);
            }
            bgTemplateInfo2 = this.generatePlainBgTemplate(resultSet, templateId);
            bgTemplateInfo2.getBgTpRows().addCollection(this.getBgTpRows(ctx, conn, templateId));
            bgTemplateInfo2.getBgTpColumns().addCollection(this.getBgTpCols(ctx, conn, templateId));
            bgTemplateInfo2.getRefDimensions().addCollection(this.getRefDims(ctx, conn, templateId));
            bgTemplateInfo2.getRefCurrencies().addCollection(this.getRefCys(ctx, conn, templateId));
            IBgType iBgType = BgTypeFactory.getLocalInstance(ctx);
            ObjectUuidPK bgTypePk = new ObjectUuidPK(bgTemplateInfo2.getBgType().getId());
            BgTypeInfo bti = iBgType.getBgTypeBySql(bgTemplateInfo2.getBgType().getId());
            bgTemplateInfo2.setBgType(bti);
            bgTemplateInfo = bgTemplateInfo2;
        }
        catch (SQLException e) {
            try {
                System.out.println("get bg template!");
                e.printStackTrace();
                throw new BgBizException(BgBizException.GETDATA, e, new Object[]{"BgTemplate"});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(resultSet, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)resultSet, (Statement)stmt, (Connection)conn);
        return bgTemplateInfo;
    }

    private BgTemplateInfo generatePlainBgTemplate(ResultSet resultSet, String templateId) throws SQLException {
        String parentId;
        String orgUnitId;
        String companyId;
        String bgTypeId;
        BgTemplateInfo bgTpInfo = new BgTemplateInfo();
        bgTpInfo.setId(BOSUuid.read((String)templateId));
        bgTpInfo.setNumber(resultSet.getString("fnumber"));
        bgTpInfo.setName(resultSet.getString("fname"));
        bgTpInfo.setInt("bgCycle", resultSet.getInt("bgCycle"));
        bgTpInfo.setInt("rollingBgCycle", resultSet.getInt("rollingBgCycle"));
        bgTpInfo.setInt("bgMethod", resultSet.getInt("bgMethod"));
        bgTpInfo.setInt("approveStyle", resultSet.getInt("approveStyle"));
        bgTpInfo.setIsMultidimensional(resultSet.getBoolean("isMultidimensional"));
        bgTpInfo.setIsCurrent(resultSet.getBoolean("isCurrent"));
        bgTpInfo.setInt("bgCtrlType", resultSet.getInt("bgCtrlType"));
        bgTpInfo.setCreateTime(resultSet.getTimestamp("createTime"));
        String userId = resultSet.getString("creatorId");
        if (BgDaHelper.isValidIdString(userId)) {
            UserInfo userInfo = new UserInfo();
            userInfo.setId(BOSUuid.read((String)userId));
            userInfo.setNumber(resultSet.getString("user_number"));
            userInfo.setName(resultSet.getString("user_name"));
            bgTpInfo.setCreator(userInfo);
        }
        if (BgDaHelper.isValidIdString(bgTypeId = resultSet.getString("bgTypeId"))) {
            BgTypeInfo bgTypeInfo = new BgTypeInfo();
            bgTypeInfo.setId(BOSUuid.read((String)bgTypeId));
            bgTypeInfo.setSeq(resultSet.getInt("bgType_seq"));
            bgTypeInfo.setNumber(resultSet.getString("bgType_number"));
            bgTypeInfo.setName(resultSet.getString("bgType_name"));
            bgTypeInfo.setControllable(resultSet.getBoolean("bgType_controllable"));
            bgTpInfo.setBgType(bgTypeInfo);
        }
        if (BgDaHelper.isValidIdString(companyId = resultSet.getString("companyId"))) {
            CompanyOrgUnitInfo companyInfo = new CompanyOrgUnitInfo();
            companyInfo.setId(BOSUuid.read((String)companyId));
            bgTpInfo.setCompany(companyInfo);
        }
        if (BgDaHelper.isValidIdString(orgUnitId = resultSet.getString("orgUnitId"))) {
            OrgUnitInfo oui = new OrgUnitInfo();
            oui.setId(BOSUuid.read((String)orgUnitId));
            oui.setNumber(resultSet.getString("orgUnit_number"));
            oui.setName(resultSet.getString("orgUnit_name"));
            bgTpInfo.setOrgUnit(oui);
        }
        if (BgDaHelper.isValidIdString(parentId = resultSet.getString("parent"))) {
            BgTemplateInfo parent = new BgTemplateInfo();
            parent.setId(BOSUuid.read((String)parentId));
            bgTpInfo.setParent(parent);
        }
        return bgTpInfo;
    }

    private BgTemplateRowCollection getBgTpRows(Context ctx, Connection conn, String templateId) throws SQLDataException, EASBizException {
        StringBuffer sb = new StringBuffer(6000);
        sb.append(" SELECT ");
        sb.append(" T_BG_BgTemplateRow.FID AS bgTpRow_id, ");
        sb.append("T_BG_BgTemplateRow.FSeq AS bgTpRow_seq,");
        sb.append("T_BG_BgTemplateRow.FBgControlType AS bgTpRow_bgControlType,");
        sb.append("T_BG_BgTemplateRow.FIsFlexibleCtrl AS bgTpRow_isFlexibleCtrl,");
        sb.append("T_BG_BgTemplateRow.FFlexibleBgCtrlParam AS bgTpRow_flexibleBgCtrlParam,");
        sb.append("T_BG_BgTemplateRow.FRelativeCtrlFormula AS bgTpRow_relativeCtrlFormula,");
        sb.append("T_BG_BgTemplateRow.FBgItem1ID AS bgTpRow_bgItem1,");
        sb.append("T_BG_BgTemplateRow.FBgItem2ID AS bgTpRow_bgItem2,");
        sb.append("T_BG_BgTemplateRow.FBgItem3ID AS bgTpRow_bgItem3,");
        sb.append("T_BG_BgTemplateRow.FBgItem4ID AS bgTpRow_bgItem4,");
        sb.append("T_BG_BgTemplateRow.FBgItem5ID AS bgTpRow_bgItem5,");
        sb.append("T_BG_BgTemplateRow.FBgTemplateID AS bgTpRow_bgTemplate,");
        sb.append("T_BG_BgTemplateRow.FBgItem6ID AS bgTpRow_bgItem6,");
        sb.append("T_BG_BgItem1.FID AS bgItem1_id,");
        sb.append("T_BG_BgItem1.FIsLeaf AS bgItem1_isLeaf,");
        sb.append("T_BG_BgItem1.FIsFromParent AS bgItem1_isFromParent,");
        sb.append("T_BG_BgItem1.FLongNumber AS bgItem1_longNumber,");
        sb.append("T_BG_BgItem1.FItemID AS bgItem1_itemId,");
        sb.append("T_BG_BgItem1.FItemNumber AS bgItem1_itemNumber,");
        sb.append("T_BG_BgItem1.FItemName_@L@ AS bgItem1_itemName,");
        sb.append("T_BG_BgItem1.FRefDimensionID AS bgItem1_refDimension,");
        sb.append("T_BG_BgItem1.FBgDimension AS bgItem1_bgDimension,");
        sb.append("T_BG_BgItem2.FID AS bgItem2_id,");
        sb.append("T_BG_BgItem2.FIsLeaf AS bgItem2_isLeaf,");
        sb.append("T_BG_BgItem2.FIsFromParent AS bgItem2_isFromParent,");
        sb.append("T_BG_BgItem2.FLongNumber AS bgItem2_longNumber,");
        sb.append("T_BG_BgItem2.FItemID AS bgItem2_itemId,");
        sb.append("T_BG_BgItem2.FItemNumber AS bgItem2_itemNumber,");
        sb.append("T_BG_BgItem2.FItemName_@L@ AS bgItem2_itemName,");
        sb.append("T_BG_BgItem2.FRefDimensionID AS bgItem2_refDimension,");
        sb.append("T_BG_BgItem2.FBgDimension AS bgItem2_bgDimension,");
        sb.append("T_BG_BgItem3.FID AS bgItem3_id,");
        sb.append("T_BG_BgItem3.FIsLeaf AS bgItem3_isLeaf,");
        sb.append("T_BG_BgItem3.FIsFromParent AS bgItem3_isFromParent,");
        sb.append("T_BG_BgItem3.FLongNumber AS bgItem3_longNumber,");
        sb.append("T_BG_BgItem3.FItemID AS bgItem3_itemId,");
        sb.append("T_BG_BgItem3.FItemNumber AS bgItem3_itemNumber,");
        sb.append("T_BG_BgItem3.FItemName_@L@ AS bgItem3_itemName,");
        sb.append("T_BG_BgItem3.FRefDimensionID AS bgItem3_refDimension,");
        sb.append("T_BG_BgItem3.FBgDimension AS bgItem3_bgDimension,");
        sb.append("T_BG_BgItem4.FID AS bgItem4_id,");
        sb.append("T_BG_BgItem4.FIsLeaf AS bgItem4_isLeaf,");
        sb.append("T_BG_BgItem4.FIsFromParent AS bgItem4_isFromParent,");
        sb.append("T_BG_BgItem4.FLongNumber AS bgItem4_longNumber,");
        sb.append("T_BG_BgItem4.FItemID AS bgItem4_itemId,");
        sb.append("T_BG_BgItem4.FItemNumber AS bgItem4_itemNumber,");
        sb.append("T_BG_BgItem4.FItemName_@L@ AS bgItem4_itemName,");
        sb.append("T_BG_BgItem4.FRefDimensionID AS bgItem4_refDimension,");
        sb.append("T_BG_BgItem4.FBgDimension AS bgItem4_bgDimension,");
        sb.append("T_BG_BgItem5.FID AS bgItem5_id,");
        sb.append("T_BG_BgItem5.FIsLeaf AS bgItem5_isLeaf,");
        sb.append("T_BG_BgItem5.FIsFromParent AS bgItem5_isFromParent,");
        sb.append("T_BG_BgItem5.FLongNumber AS bgItem5_longNumber,");
        sb.append("T_BG_BgItem5.FItemID AS bgItem5_itemId,");
        sb.append("T_BG_BgItem5.FItemNumber AS bgItem5_itemNumber,");
        sb.append("T_BG_BgItem5.FItemName_@L@ AS bgItem5_itemName,");
        sb.append("T_BG_BgItem5.FRefDimensionID AS bgItem5_refDimension,");
        sb.append("T_BG_BgItem5.FBgDimension AS bgItem5_bgDimension,");
        sb.append("T_BG_BgItem6.FID AS bgItem6_id,");
        sb.append("T_BG_BgItem6.FIsLeaf AS bgItem6_isLeaf,");
        sb.append("T_BG_BgItem6.FIsFromParent AS bgItem6_isFromParent,");
        sb.append("T_BG_BgItem6.FLongNumber AS bgItem6_longNumber,");
        sb.append("T_BG_BgItem6.FItemID AS bgItem6_itemId,");
        sb.append("T_BG_BgItem6.FItemNumber AS bgItem6_itemNumber,");
        sb.append("T_BG_BgItem6.FItemName_@L@ AS bgItem6_itemName,");
        sb.append("T_BG_BgItem6.FRefDimensionID AS bgItem6_refDimension,");
        sb.append("T_BG_BgItem6.FBgDimension AS bgItem6_bgDimension");
        sb.append(" FROM T_BG_BgTemplateRow ");
        sb.append(" LEFT OUTER JOIN T_BG_BgItem T_BG_BgItem1 ON T_BG_BgTemplateRow.FBgItem1ID = T_BG_BgItem1.FID ");
        sb.append(" LEFT OUTER JOIN T_BG_BgItem T_BG_BgItem2 ON T_BG_BgTemplateRow.FBgItem2ID = T_BG_BgItem2.FID ");
        sb.append(" LEFT OUTER JOIN T_BG_BgItem T_BG_BgItem3 ON T_BG_BgTemplateRow.FBgItem3ID = T_BG_BgItem3.FID ");
        sb.append(" LEFT OUTER JOIN T_BG_BgItem T_BG_BgItem4 ON T_BG_BgTemplateRow.FBgItem4ID = T_BG_BgItem4.FID ");
        sb.append(" LEFT OUTER JOIN T_BG_BgItem T_BG_BgItem5 ON T_BG_BgTemplateRow.FBgItem5ID = T_BG_BgItem5.FID ");
        sb.append(" LEFT OUTER JOIN T_BG_BgItem T_BG_BgItem6 ON T_BG_BgTemplateRow.FBgItem6ID = T_BG_BgItem6.FID ");
        sb.append(" WHERE ");
        sb.append(" T_BG_BgTemplateRow.FBgTemplateID = '" + templateId + "' ");
        sb.append(" ORDER BY ");
        sb.append(" T_BG_BgItem1.FItemNumber, ");
        sb.append(" T_BG_BgItem2.FItemNumber, ");
        sb.append(" T_BG_BgItem3.FItemNumber, ");
        sb.append(" T_BG_BgItem5.FItemNumber, ");
        sb.append(" T_BG_BgItem6.FItemNumber  ");
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        BgTemplateRowCollection bgTpRows = new BgTemplateRowCollection();
        HashMap cache = new HashMap();
        try {
            stmt = conn.prepareStatement(BgDaHelper.convert(ctx, sb.toString()));
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                BgTemplateRowInfo bgTpRowInfo = this.generatePlainBgTemplateRow(resultSet, cache);
                if (bgTpRowInfo == null) continue;
                bgTpRows.add(bgTpRowInfo);
            }
        }
        catch (SQLException e) {
            try {
                throw new EASBizException(BgBizException.GETDATA, (Throwable)e, new Object[]{"Budget template rows"});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(resultSet, stmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)resultSet, (Statement)stmt);
        return bgTpRows;
    }

    private BgTemplateRowInfo generatePlainBgTemplateRow(ResultSet resultSet, Map cache) throws SQLException {
        String id = resultSet.getString("bgTpRow_id");
        if (!BgDaHelper.isValidIdString(id)) {
            return null;
        }
        BgTemplateRowInfo bgTpRowInfo = new BgTemplateRowInfo();
        bgTpRowInfo.setId(BOSUuid.read((String)id));
        bgTpRowInfo.setSeq(resultSet.getInt("bgTpRow_seq"));
        bgTpRowInfo.setInt("bgControlType", resultSet.getInt("bgTpRow_bgControlType"));
        bgTpRowInfo.setIsFlexibleCtrl(resultSet.getBoolean("bgTpRow_isFlexibleCtrl"));
        bgTpRowInfo.setFlexibleBgCtrlParam(resultSet.getBigDecimal("bgTpRow_flexibleBgCtrlParam"));
        bgTpRowInfo.setRelativeCtrlFormula(resultSet.getString("bgTpRow_relativeCtrlFormula"));
        for (int i = 1; i <= BgTemplateRowInfo.MAXREFDIM; ++i) {
            String key = "bgItem" + String.valueOf(i);
            String bgItemId = resultSet.getString("bgTpRow_" + key);
            BgItemInfo bgItemInfo = null;
            if (!BgDaHelper.isValidIdString(bgItemId)) continue;
            Object o = cache.get(bgItemId);
            if (o != null) {
                bgItemInfo = (BgItemInfo)o;
            } else {
                bgItemInfo = new BgItemInfo();
                bgItemInfo.setId(BOSUuid.read((String)bgItemId));
                bgItemInfo.setIsLeaf(resultSet.getBoolean(key + "_isLeaf"));
                bgItemInfo.setIsFromParent(resultSet.getBoolean(key + "_isFromParent"));
                bgItemInfo.setLongNumber(resultSet.getString(key + "_longNumber"));
                bgItemInfo.setItemNumber(resultSet.getString(key + "_itemNumber"));
                bgItemInfo.setItemName(resultSet.getString(key + "_itemName"));
                bgItemInfo.setInt("bgDimension", resultSet.getInt(key + "_bgDimension"));
            }
            bgTpRowInfo.put(key, bgItemInfo);
        }
        return bgTpRowInfo;
    }

    private ReferencedCurrencyCollection getRefCys(Context ctx, Connection conn, String templateId) throws EASBizException, SQLDataException {
        ReferencedCurrencyCollection referencedCurrencyCollection;
        StringBuffer sb = new StringBuffer(512);
        sb.append("SELECT T_BG_ReferencedCurrency.FID AS fid,");
        sb.append("T_BG_ReferencedCurrency.FCurrencyID AS currency,");
        sb.append("T_BD_Currency.FID AS currency_id,");
        sb.append("T_BD_Currency.FNumber AS currency_number,");
        sb.append("T_BD_Currency.FName_@L@ AS currency_name");
        sb.append(" FROM T_BG_ReferencedCurrency ");
        sb.append(" INNER JOIN T_BD_Currency ON T_BG_ReferencedCurrency.FCurrencyID = T_BD_Currency.FID ");
        sb.append(" WHERE ");
        sb.append(" T_BG_ReferencedCurrency.FBgTemplateID ='" + templateId + "' ");
        sb.append(" ORDER BY T_BD_Currency.FNumber ");
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        try {
            stmt = conn.prepareStatement(BgDaHelper.convert(ctx, sb.toString()));
            resultSet = stmt.executeQuery();
            ReferencedCurrencyCollection refCys = new ReferencedCurrencyCollection();
            while (resultSet.next()) {
                ReferencedCurrencyInfo refCyInfo = new ReferencedCurrencyInfo();
                refCyInfo.setId(BOSUuid.read((String)resultSet.getString("fid")));
                CurrencyInfo cyInfo = new CurrencyInfo();
                cyInfo.setId(BOSUuid.read((String)resultSet.getString("currency_id")));
                cyInfo.setNumber(resultSet.getString("currency_number"));
                cyInfo.setName(resultSet.getString("currency_name"));
                refCyInfo.setCurrency(cyInfo);
                refCys.add(refCyInfo);
            }
            referencedCurrencyCollection = refCys;
        }
        catch (SQLException e) {
            try {
                throw new EASBizException(BgBizException.GETDATA, (Throwable)e, new Object[]{"Budget template currencies"});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(resultSet, stmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)resultSet, (Statement)stmt);
        return referencedCurrencyCollection;
    }

    private ReferencedDimensionCollection getRefDims(Context ctx, Connection conn, String templateId) throws EASBizException, SQLDataException, UuidException {
        ReferencedDimensionCollection referencedDimensionCollection;
        StringBuffer sb = new StringBuffer(1024);
        sb.append("SELECT T_BG_ReferencedDimension.FBgDimension AS bgDimension,");
        sb.append("T_BG_ReferencedDimension.FIsPrimary AS isPrimary,");
        sb.append("T_BG_ReferencedDimension.FID AS fid,");
        sb.append("T_BG_BgItem.FRefDimensionID AS bgItem_refDim,");
        sb.append("T_BG_ReferencedDimension.FSeq AS seq,");
        sb.append(" T_BG_BgItem.FID AS bgItem_id,");
        sb.append("T_BG_BgItem.FIsLeaf AS bgItem_isLeaf,");
        sb.append("T_BG_BgItem.FLongNumber AS bgItem_longNumber,");
        sb.append("T_BG_BgItem.FItemID AS bgItem_itemId,");
        sb.append("T_BG_BgItem.FItemNumber AS bgItem_itemNumber,");
        sb.append("T_BG_BgItem.FItemName_@L@ AS bgItem_itemName,");
        sb.append("T_BG_BgItem.FMeasureUnitID AS bgItem_measureUnit,");
        sb.append("T_BG_BgItem.FIsFromParent AS bgItem_isFromParent,");
        sb.append("T_BG_BgItem.FBgDimension AS bgItem_bgDimension,");
        sb.append("T_BD_MeasureUnit.FID AS measureUnit_id,");
        sb.append("T_BD_MeasureUnit.FName_@L@ AS measureUnit_name");
        sb.append(" FROM T_BG_BgItem ");
        sb.append(" INNER JOIN T_BG_ReferencedDimension ON T_BG_BgItem.FRefDimensionID = T_BG_ReferencedDimension.FID ");
        sb.append(" LEFT OUTER JOIN T_BD_MeasureUnit ON T_BG_BgItem.FMeasureUnitID = T_BD_MeasureUnit.FID ");
        sb.append(" WHERE ");
        sb.append(" T_BG_ReferencedDimension.FBgTemplateID ='" + templateId + "' ");
        sb.append(" ORDER BY T_BG_ReferencedDimension.FSeq,T_BG_BgItem.FItemNumber");
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        try {
            stmt = conn.prepareStatement(BgDaHelper.convert(ctx, sb.toString()));
            resultSet = stmt.executeQuery();
            ReferencedDimensionCollection refDims = new ReferencedDimensionCollection();
            ReferencedDimensionInfo refDimInfo = null;
            while (resultSet.next()) {
                String refDimId = resultSet.getString("fid");
                if (refDimInfo == null || !refDimInfo.getId().toString().equals(refDimId)) {
                    refDimInfo = this.generatePlainRefDim(resultSet, refDimId);
                    refDims.add(refDimInfo);
                }
                refDimInfo.getBgItems().add(this.generatePlainRefDim_BgItem(resultSet));
            }
            referencedDimensionCollection = refDims;
        }
        catch (SQLException e) {
            try {
                throw new EASBizException(BgBizException.GETDATA, (Throwable)e, new Object[]{"budget template dimensions and items"});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(resultSet, stmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)resultSet, (Statement)stmt);
        return referencedDimensionCollection;
    }

    private ReferencedDimensionInfo generatePlainRefDim(ResultSet resultSet, String refDimId) throws SQLException {
        ReferencedDimensionInfo refDimInfo = new ReferencedDimensionInfo();
        refDimInfo.setId(BOSUuid.read((String)refDimId));
        refDimInfo.setIsPrimary(resultSet.getBoolean("isPrimary"));
        refDimInfo.setSeq(resultSet.getInt("seq"));
        refDimInfo.setInt("bgDimension", resultSet.getInt("bgDimension"));
        return refDimInfo;
    }

    private BgItemInfo generatePlainRefDim_BgItem(ResultSet resultSet) throws UuidException, SQLException {
        BgItemInfo bgItemInfo = new BgItemInfo();
        String bgItemId = resultSet.getString("bgItem_id");
        if (BgDaHelper.isValidIdString(bgItemId)) {
            bgItemInfo.setId(BOSUuid.read((String)bgItemId));
        }
        bgItemInfo.setIsLeaf(resultSet.getBoolean("bgItem_isLeaf"));
        bgItemInfo.setIsFromParent(resultSet.getBoolean("bgItem_isFromParent"));
        bgItemInfo.setLongNumber(resultSet.getString("bgItem_longNumber"));
        String itemId = resultSet.getString("bgItem_itemId");
        if (BgDaHelper.isValidIdString(itemId)) {
            bgItemInfo.setItemID(BOSUuid.read((String)itemId));
        }
        bgItemInfo.setItemNumber(resultSet.getString("bgItem_itemNumber"));
        bgItemInfo.setItemName(resultSet.getString("bgItem_itemName"));
        bgItemInfo.setInt("BgDimension", resultSet.getInt("bgItem_bgDimension"));
        String measureUnitId = resultSet.getString("measureUnit_id");
        if (BgDaHelper.isValidIdString(measureUnitId)) {
            MeasureUnitInfo mui = new MeasureUnitInfo();
            mui.setId(BOSUuid.read((String)measureUnitId));
            mui.setName(resultSet.getString("measureUnit_name"));
            bgItemInfo.setMeasureUnit(mui);
        }
        return bgItemInfo;
    }

    private BgTemplateColumnCollection getBgTpCols(Context ctx, Connection conn, String templateId) throws EASBizException, SQLDataException {
        BgTemplateColumnCollection bgTemplateColumnCollection;
        StringBuffer sb = new StringBuffer(512);
        sb.append("SELECT T_BG_BgTemplateColumn.FID AS fid,");
        sb.append("T_BG_BgTemplateColumn.FIsControlled AS isControlled,");
        sb.append("T_BG_BgTemplateColumn.FFormula AS formula,");
        sb.append("T_BG_BgTemplateColumn.FBgElementID AS bgElementID,");
        sb.append("T_BG_BgTemplateColumn.FBgTemplateID AS bgTemplateID,");
        sb.append("T_BG_BgTemplateColumn.FSeq AS seq,");
        sb.append("T_BG_BgElement.FID AS bgElement_id,");
        sb.append("T_BG_BgElement.FSeq AS bgElement_seq,");
        sb.append("T_BG_BgElement.FNumber AS bgElement_number,");
        sb.append("T_BG_BgElement.FName_@L@ AS bgElement_name,");
        sb.append("T_BG_BgElement.FBizElement AS bgElement_bizElement,");
        sb.append("T_BG_BgElement.FDataType AS bgElement_dataType,");
        sb.append("T_BG_BgElement.FApportionable AS bgElement_apportionable,");
        sb.append("T_BG_BgElement.FEnabled AS bgElement_enabled,");
        sb.append("T_BG_BgElement.FSummable AS bgElement_summable");
        sb.append(" FROM T_BG_BgTemplateColumn ");
        sb.append(" INNER JOIN T_BG_BgElement ON T_BG_BgTemplateColumn.FBgElementID = T_BG_BgElement.FID ");
        sb.append(" WHERE T_BG_BgTemplateColumn.FBgTemplateID = '" + templateId + "' ");
        sb.append(" ORDER BY T_BG_BgElement.FSeq ");
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        try {
            stmt = conn.prepareStatement(BgDaHelper.convert(ctx, sb.toString()));
            resultSet = stmt.executeQuery();
            BgTemplateColumnCollection bgTpCols = new BgTemplateColumnCollection();
            while (resultSet.next()) {
                BgTemplateColumnInfo bgTpColInfo = new BgTemplateColumnInfo();
                bgTpColInfo.setId(BOSUuid.read((String)resultSet.getString("fid")));
                bgTpColInfo.setIsControlled(resultSet.getBoolean("isControlled"));
                bgTpColInfo.setFormula(resultSet.getString("formula"));
                bgTpColInfo.setSeq(resultSet.getInt("seq"));
                BgElementInfo bgEleInfo = new BgElementInfo();
                bgEleInfo.setId(BOSUuid.read((String)resultSet.getString("bgElement_id")));
                bgEleInfo.setSeq(resultSet.getInt("bgElement_seq"));
                bgEleInfo.setNumber(resultSet.getString("bgElement_number"));
                bgEleInfo.setInt("bizElement", resultSet.getInt("bgElement_bizElement"));
                bgEleInfo.setName(resultSet.getString("bgElement_name"));
                bgEleInfo.setInt("dataType", resultSet.getInt("bgElement_dataType"));
                bgEleInfo.setApportionable(resultSet.getBoolean("bgElement_apportionable"));
                bgEleInfo.setEnabled(resultSet.getBoolean("bgElement_enabled"));
                bgEleInfo.setSummable(resultSet.getBoolean("bgElement_summable"));
                bgTpColInfo.setBgElement(bgEleInfo);
                bgTpCols.add(bgTpColInfo);
            }
            bgTemplateColumnCollection = bgTpCols;
        }
        catch (SQLException e) {
            try {
                throw new EASBizException(BgBizException.GETDATA, (Throwable)e, new Object[]{"Budget template column"});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(resultSet, stmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)resultSet, (Statement)stmt);
        return bgTemplateColumnCollection;
    }

    @Override
    protected IObjectCollection _getAccountTemplateItems(Context ctx, Vector orgUnitPath) throws BOSException, EASBizException {
        BgTemplateInfo bti = this.getCurrentBgTemplate(ctx, orgUnitPath, "c292cd11-00fb-1000-e000-0001c0a8129f530DC15D");
        if (bti == null) {
            throw new BgTemplateException(BgTemplateException.MISSINGACCOUNTTEMPLATE);
        }
        String sql = "SELECT T_BG_BgItem.FItemID, T_BG_BgItem.FItemNumber, T_BG_BgItem.FItemName_@L@ AS itemName FROM T_BG_BgTemplate INNER JOIN T_BG_ReferencedDimension ON T_BG_BgTemplate.FID = T_BG_ReferencedDimension.FBgTemplateID INNER JOIN T_BG_BgItem ON T_BG_ReferencedDimension.FID = T_BG_BgItem.FRefDimensionID WHERE T_BG_BgTemplate.FID = ? AND T_BG_ReferencedDimension.FBgDimension = 1100 ORDER BY T_BG_BgItem.FItemNumber";
        Connection conn = this.getConnection(ctx);
        PreparedStatement stmt = null;
        ResultSet rs = null;
        BgItemCollection bic = new BgItemCollection();
        try {
            stmt = conn.prepareStatement(BgDaHelper.convert(ctx, sql));
            stmt.setString(1, bti.getId().toString());
            rs = stmt.executeQuery();
            while (rs.next()) {
                bic.add(this.loadBgItem(rs));
            }
        }
        catch (SQLException e) {
            try {
                throw new BgBizException(BgBizException.GETDATA, e, new Object[]{"Budget Template"});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return bic;
    }

    private BgItemInfo loadBgItem(ResultSet rs) throws UuidException, SQLException {
        BgItemInfo bii = new BgItemInfo();
        bii.setItemID(BOSUuid.read((String)rs.getString("FItemID")));
        bii.setItemNumber(rs.getString("FItemNumber"));
        bii.setItemName(rs.getString("itemName"));
        return bii;
    }

    @Override
    protected boolean _getIsGrouping(Context ctx, String orgUnitId) throws BOSException, EASBizException {
        boolean result = false;
        String sql = "SELECT FIsGroup FROM T_ORG_COMPANY WHERE FID = ?";
        Connection conn = this.getConnection(ctx);
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, orgUnitId);
            rs = stmt.executeQuery();
            if (rs.next()) {
                result = rs.getBoolean(1);
            }
        }
        catch (SQLException e) {
            try {
                throw new BgBizException(BgBizException.GETDATA, e, new Object[]{"Company"});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return result;
    }
}

