/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.bg.BgAdjustHelper;
import com.kingdee.eas.ma.bg.BgBizException;
import com.kingdee.eas.ma.bg.BgDataCollection;
import com.kingdee.eas.ma.bg.BgDataFactory;
import com.kingdee.eas.ma.bg.BgDataInfo;
import com.kingdee.eas.ma.bg.BgEntryFactory;
import com.kingdee.eas.ma.bg.BgEntryInfo;
import com.kingdee.eas.ma.bg.BgFormCollection;
import com.kingdee.eas.ma.bg.BgFormInfo;
import com.kingdee.eas.ma.bg.BgItemCollection;
import com.kingdee.eas.ma.bg.BgItemFactory;
import com.kingdee.eas.ma.bg.BgItemInfo;
import com.kingdee.eas.ma.bg.BgORMException;
import com.kingdee.eas.ma.bg.BgRptTemplateDAFactory;
import com.kingdee.eas.ma.bg.BgRptTemplateInfo;
import com.kingdee.eas.ma.bg.BgTemplateDAFactory;
import com.kingdee.eas.ma.bg.BgTemplateFactory;
import com.kingdee.eas.ma.bg.BgTemplateInfo;
import com.kingdee.eas.ma.bg.IBgRptTemplateDA;
import com.kingdee.eas.ma.bg.IBgTemplateDA;
import com.kingdee.eas.ma.bg.app.AbstractBgV2ManagerControllerBean;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Logger;

public class BgV2ManagerControllerBean
extends AbstractBgV2ManagerControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.bg.app.BgV2ManagerControllerBean");

    @Override
    protected IObjectValue _getBgTemplate(Context ctx, String bgFormId) throws BOSException, EASBizException {
        String sql = "SELECT fBgTemplateId  FROM T_BG_BgForm BgForm WHERE BgForm.FID = ? ";
        Connection conn = this.getConnection(ctx);
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String bgTemId = "";
        try {
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, BOSUuid.read((String)bgFormId).toString());
            rs = stmt.executeQuery();
            while (rs.next()) {
                bgTemId = rs.getString(1);
            }
        }
        catch (SQLException e) {
            try {
                throw new BgBizException(BgBizException.GETDATA, e, new Object[]{"bgForm"});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        BgTemplateInfo bgTemInfo = null;
        IBgTemplateDA iBgTem = BgTemplateDAFactory.getLocalInstance(ctx);
        bgTemInfo = iBgTem.getBgTemplate(bgTemId);
        return bgTemInfo;
    }

    @Override
    protected IObjectValue _getRptBgTemplate(Context ctx, String bgFormId) throws BOSException, EASBizException {
        String sql = "SELECT fBgTemplateId  FROM T_BG_BgForm BgForm WHERE BgForm.FID = ? ";
        Connection conn = this.getConnection(ctx);
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String bgTemId = "";
        try {
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, BOSUuid.read((String)bgFormId).toString());
            rs = stmt.executeQuery();
            while (rs.next()) {
                bgTemId = rs.getString(1);
            }
        }
        catch (SQLException e) {
            try {
                throw new BgBizException(BgBizException.GETDATA, e, new Object[]{"bgForm"});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        BgRptTemplateInfo bgRptTemInfo = null;
        IBgRptTemplateDA iBgTem = BgRptTemplateDAFactory.getLocalInstance(ctx);
        bgRptTemInfo = iBgTem.getBgRptTpByBgTp(bgTemId);
        BgTemplateInfo bgTemInfo = new BgTemplateInfo();
        String oql = " select bgCycle,refCurrencies.currency.id,refCurrencies.currency.name,  refCurrencies.currency.number where id='" + bgTemId + "'";
        bgTemInfo = BgTemplateFactory.getLocalInstance(ctx).getBgTemplateInfo(oql);
        bgRptTemInfo.setBgTemplate(bgTemInfo);
        return bgRptTemInfo;
    }

    @Override
    protected IObjectCollection _getBgFormCollection(Context ctx, String whereStr) throws BOSException, EASBizException {
        String sql = "SELECT fid,fName,fNumber  FROM T_BG_BgForm BgForm WHERE  ";
        sql = sql + whereStr;
        Connection conn = this.getConnection(ctx);
        PreparedStatement stmt = null;
        ResultSet rs = null;
        BgFormCollection bgFormCol = new BgFormCollection();
        try {
            stmt = conn.prepareStatement(sql);
            rs = stmt.executeQuery();
            while (rs.next()) {
                BgFormInfo bgForm = new BgFormInfo();
                bgForm.setId(BOSUuid.read((String)rs.getString("fid")));
                bgForm.setName(rs.getString("fName"));
                bgForm.setNumber(rs.getString("fNumber"));
                bgFormCol.add(bgForm);
            }
        }
        catch (SQLException e) {
            try {
                throw new BgBizException(BgBizException.GETDATA, e, new Object[]{"bgForm"});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return bgFormCol;
    }

    @Override
    protected Hashtable _getBgDatas(Context ctx, Vector bgItemVec, String currencyId, String bgFormId) throws BOSException, EASBizException {
        Hashtable<String, BgDataInfo> result = new Hashtable<String, BgDataInfo>();
        String sql = "select a.* ,b.fperiodId ,b.fbgcycle ,c.fprecision  from t_bg_bgdata a ,t_bg_bgentry b ,t_bd_currency c  where a.fbgentryid = b.fid and a.FCurrencyID = c.fid and b.fbgformid= ? and a.FCurrencyID = ? ";
        int n = bgItemVec.size();
        for (int i = 0; i < n; ++i) {
            sql = sql + " and b.fbgitem" + (i + 1) + "id = ?";
        }
        Connection conn = this.getConnection(ctx);
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        try {
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, bgFormId);
            stmt.setString(2, currencyId);
            int index = 3;
            int n2 = bgItemVec.size();
            for (int i = 0; i < n2; ++i) {
                stmt.setString(index, ((BgItemInfo)bgItemVec.get(i)).getId().toString());
                ++index;
            }
            resultSet = stmt.executeQuery();
            BigDecimal one = new BigDecimal(1);
            while (resultSet.next()) {
                BgDataInfo bgDataInfo = this.generateBgData(resultSet, one);
                result.put(bgDataInfo.get("periodId") + "_" + (Integer)bgDataInfo.get("bgCycle") + "_" + bgDataInfo.getElementNumber(), bgDataInfo);
            }
        }
        catch (SQLException e) {
            try {
                System.out.println("get bg bgform!");
                logger.debug((Object)e);
                throw new EASBizException(BgBizException.GETDATA, (Throwable)e, new Object[]{"BgForm"});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(resultSet, (Statement)stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)resultSet, (Statement)stmt, (Connection)conn);
        return result;
    }

    private BgDataInfo generateBgData(ResultSet rs, BigDecimal one) throws SQLException {
        BgDataInfo data = new BgDataInfo();
        String id = rs.getString("fid");
        BigDecimal bgValue = rs.getBigDecimal("fbgvalue");
        String eleNumber = rs.getString("felementnumber");
        String periodId = rs.getString("fperiodid");
        int cycleType = rs.getInt("fbgcycle");
        int precision = rs.getInt("fprecision");
        data.setId(BOSUuid.read((String)id));
        data.setBgValue(bgValue.divide(one, precision, 6));
        data.setElementNumber(eleNumber);
        data.put("periodId", periodId);
        data.put("bgCycle", new Integer(cycleType));
        return data;
    }

    private BgDataInfo generateBgData(ResultSet rs, BigDecimal one, String field) throws SQLException {
        BgDataInfo data = new BgDataInfo();
        String sqlField = "f" + field;
        String id = rs.getString("fid");
        BigDecimal bgValue = rs.getBigDecimal(sqlField) == null ? new BigDecimal("0.00") : rs.getBigDecimal(sqlField);
        String eleNumber = rs.getString("felementnumber");
        String periodId = rs.getString("fperiodid");
        int cycleType = rs.getInt("fbgcycle");
        int precision = rs.getInt("fprecision");
        data.setId(BOSUuid.read((String)id));
        data.setBigDecimal(field, bgValue.divide(one, precision, 6));
        data.setElementNumber(eleNumber);
        data.put("periodId", periodId);
        data.put("bgCycle", new Integer(cycleType));
        return data;
    }

    @Override
    protected Hashtable _getBgPastDatas(Context ctx, String bgFormId) throws BOSException, EASBizException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        String sql = "select distinct a.FBgDataID  from t_bg_bgpastdata a ,t_bg_bgpastrecord b ,t_bg_bgform c  where a.FBgPastRecordID = b.fid and b.FBgFormId = c.fid and b.fbgFormid= ? ";
        Connection conn = this.getConnection(ctx);
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, bgFormId);
            rs = stmt.executeQuery();
            while (rs.next()) {
                result.put(rs.getString(1), rs.getString(1));
            }
        }
        catch (SQLException e) {
            try {
                System.out.println("get bg bgform!");
                logger.debug((Object)e);
                throw new EASBizException(BgBizException.GETDATA, (Throwable)e, new Object[]{"BgForm"});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return result;
    }

    @Override
    protected Vector _getPeriodC(Context ctx, String bgFormId) throws BOSException, EASBizException {
        Vector<PeriodInfo> periodC = new Vector<PeriodInfo>(10);
        String sql = "select *  from (select distinct a.fid ,a.fperiodyear ,a.fperiodquarter , a.fperiodnumber ,b.fbgcycle ,  (a.FPeriodYear*100000 + isnull((select 1 where b.FBgCycle=1), 0)*10000+ a.FPeriodQuarter*1000 + isnull((select 1 where b.FBgCycle=2), 0)*100 + a.FPeriodNumber) sortNumber from t_bd_period a ,t_bg_bgentry b  where b.fperiodid = a.fid and b.fbgformid= ? ) p  order by sortNumber";
        Connection conn = this.getConnection(ctx);
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        try {
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, bgFormId);
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                PeriodInfo periodInfo = new PeriodInfo();
                String id = resultSet.getString("fid");
                int year = resultSet.getInt("fperiodyear");
                int quarter = resultSet.getInt("fperiodquarter");
                int number = resultSet.getInt("fperiodnumber");
                int bgCycle = resultSet.getInt("fbgcycle");
                periodInfo.setId(BOSUuid.read((String)id));
                periodInfo.setPeriodYear(year);
                periodInfo.setPeriodQuarter(quarter);
                periodInfo.setPeriodNumber(number);
                periodInfo.put("bgCycle", (Object)new Integer(bgCycle));
                periodC.add(periodInfo);
            }
        }
        catch (SQLException e) {
            try {
                System.out.println("get bg bgform!");
                logger.debug((Object)e);
                throw new EASBizException(BgBizException.GETDATA, (Throwable)e, new Object[]{"BgForm"});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(resultSet, (Statement)stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)resultSet, (Statement)stmt, (Connection)conn);
        return periodC;
    }

    @Override
    protected void _updateBgDatas(Context ctx, String field, String bgFormId, String currencyId, Hashtable dataMap, Hashtable downTable, boolean isRptBgForm) throws BOSException, EASBizException {
        String sqlField = "f" + field;
        String updateBgFormStateSql = "update t_bg_bgform set fstate=1 where fstate!=4 and fid=?";
        String sql = " update t_bg_bgdata set " + sqlField + " = ? where fid = ?";
        String upSql = " update t_bg_bgdata set " + sqlField + " = " + sqlField + " + ? where fid in  ( select a.fid from t_bg_bgdata a,t_bg_bgentry b  where a.fbgentryid = b.fid and  a.felementnumber = ? and  a.fcurrencyid = ? and  b.fperiodid = ? and  b.fbgformid = ? ";
        PreparedStatement stmt = null;
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.prepareStatement(updateBgFormStateSql);
            stmt.setString(1, bgFormId);
            stmt.executeUpdate();
            stmt = conn.prepareStatement(sql);
            for (Object key : dataMap.keySet()) {
                BgDataInfo data = (BgDataInfo)dataMap.get(key);
                stmt.setBigDecimal(1, data.getBigDecimal(field));
                stmt.setString(2, key.toString());
                stmt.addBatch();
            }
            int[] rst = stmt.executeBatch();
            BigDecimal negOne = new BigDecimal("-1");
            for (Object key : dataMap.keySet()) {
                BgDataInfo data = (BgDataInfo)dataMap.get(key);
                String realSql = new String(upSql);
                String bgItemId = (String)data.get("bgItemIds");
                BigDecimal diff = (BigDecimal)data.get("diff");
                String periodId = (String)data.get("periodId");
                String eleNumber = (String)data.get("elementNumber");
                if (!downTable.containsKey(bgItemId)) continue;
                String bgItemIds = (String)downTable.get(bgItemId);
                if (isRptBgForm) {
                    String[] temp = bgItemIds.split("&");
                    for (int i = 0; i < temp.length; ++i) {
                        realSql = new String(upSql);
                        realSql = this.dealUpSql(realSql, temp[i]);
                        stmt = conn.prepareStatement(realSql);
                        if (temp[i].length() > 44 && temp[i].substring(44, 45).equals("-")) {
                            stmt.setBigDecimal(1, diff.multiply(negOne));
                        } else {
                            stmt.setBigDecimal(1, diff);
                        }
                        stmt.setString(2, eleNumber);
                        stmt.setString(3, currencyId);
                        stmt.setString(4, periodId);
                        stmt.setString(5, bgFormId);
                        stmt.executeUpdate();
                    }
                    continue;
                }
                realSql = this.dealUpSql(realSql, bgItemIds);
                stmt = conn.prepareStatement(realSql);
                if (bgItemIds.length() > 44 && bgItemIds.substring(44, 45).equals("-")) {
                    stmt.setBigDecimal(1, diff.multiply(negOne));
                } else {
                    stmt.setBigDecimal(1, diff);
                }
                stmt.setString(2, eleNumber);
                stmt.setString(3, currencyId);
                stmt.setString(4, periodId);
                stmt.setString(5, bgFormId);
                stmt.executeUpdate();
            }
        }
        catch (SQLException e1) {
            try {
                logger.debug((Object)e1);
                e1.printStackTrace();
                throw new BgORMException(BgORMException.ADDNEWENTITY, e1, new Object[]{"BgV2Manager"});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
    }

    private String dealUpSql(String sql, String bgItemIds) {
        String[] ids = bgItemIds.split("&");
        String str = " and ( ";
        for (int i = 0; i < ids.length; ++i) {
            String[] id1 = ids[i].split("#");
            str = str + " ( ";
            for (int j = 0; j < id1.length; ++j) {
                if (id1[j].length() > 44) {
                    id1[j] = id1[j].substring(0, 44);
                }
                str = j == 0 ? str + "b.fbgitem" + (j + 1) + "id =  '" + id1[j] + "'" : str + " and b.fbgitem" + (j + 1) + "id =  '" + id1[j] + "'";
            }
            str = str + " ) ";
            str = str + " or";
        }
        str = str.substring(0, str.length() - 2);
        str = str + " ) ";
        sql = sql + str + " ) ";
        return sql;
    }

    @Override
    protected void _updateBgDatas(Context ctx, String[] fields, Hashtable dataMap) throws BOSException, EASBizException {
    }

    @Override
    protected void _submitAdjustedBgData(Context ctx, HashMap hmAdjust) throws BOSException, EASBizException {
        if (hmAdjust == null) {
            return;
        }
        String bgFormId = (String)hmAdjust.get(BgAdjustHelper.ADJUST_BGFORMID);
        HashMap hmAddItem = (HashMap)hmAdjust.get(BgAdjustHelper.ADJUST_ADDITEM);
        HashMap hmDelItem = (HashMap)hmAdjust.get(BgAdjustHelper.ADJUST_DELITEM);
        Vector vecBgItemForCheck = (Vector)hmAddItem.get(BgAdjustHelper.ADJUST_ADDITEMFORCHECK);
        this.dealDelForAdjusting(ctx, hmDelItem, bgFormId);
        this.checkAddItemForAdjusting(ctx, bgFormId, vecBgItemForCheck);
        this.dealAddForAdjusting(ctx, hmAddItem, bgFormId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execDel(Context ctx, String strTableName, String strBgFormId, String strWhereClause) {
        StringBuffer sql = new StringBuffer(" delete from ");
        sql.append(strTableName);
        sql.append(" where fid in ");
        PreparedStatement stmt = null;
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.prepareStatement(sql.toString());
            stmt.execute();
        }
        catch (SQLException e1) {
            try {
                logger.debug((Object)e1);
                e1.printStackTrace();
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
            SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
    }

    private String combinWhereClauseIn(Vector vec) {
        StringBuffer sbWhere = new StringBuffer("(");
        int size = vec.size();
        for (int i = 0; i < size; ++i) {
            sbWhere.append((String)vec.get(i));
            if (i >= size - 1) continue;
            sbWhere.append(",");
        }
        sbWhere.append(")");
        return sbWhere.toString();
    }

    private void dealDelForAdjusting(Context ctx, HashMap hmDelItem, String bgFormId) {
        BgDataCollection bgDataColForDel = (BgDataCollection)((Object)hmDelItem.get(BgAdjustHelper.ADJUST_BGDATA));
        Vector<String> vecBgEntryIdForDel = new Vector<String>();
        Vector<String> vecBgDataIdForDel = new Vector<String>();
        if (bgDataColForDel != null && bgDataColForDel.size() > 0) {
            for (int i = 0; i < bgDataColForDel.size(); ++i) {
                BgEntryInfo bgEntry;
                BgDataInfo bgData = bgDataColForDel.get(i);
                if (bgData != null && !vecBgDataIdForDel.contains(bgData.getId().toString())) {
                    vecBgDataIdForDel.add(bgData.getId().toString());
                }
                if ((bgEntry = bgData.getBgEntry()) == null || vecBgEntryIdForDel.contains(bgEntry.getId().toString())) continue;
                vecBgEntryIdForDel.add(bgEntry.getId().toString());
            }
            if (vecBgDataIdForDel.size() > 0) {
                this.execDel(ctx, "T_Bg_BgData", bgFormId, this.combinWhereClauseIn(vecBgDataIdForDel));
            }
            if (vecBgEntryIdForDel.size() > 0) {
                this.execDel(ctx, "T_Bg_BgEntry", bgFormId, this.combinWhereClauseIn(vecBgEntryIdForDel));
            }
        }
        BgItemCollection bgItemColForDel = (BgItemCollection)((Object)hmDelItem.get(BgAdjustHelper.ADJUST_BGITEM));
        Vector<String> vecBgItemForDel = new Vector<String>();
        if (bgItemColForDel != null && bgItemColForDel.size() > 0) {
            for (int i = 0; i < bgItemColForDel.size(); ++i) {
                BgItemInfo bgItem = bgItemColForDel.get(i);
                if (bgItem == null || vecBgItemForDel.contains(bgItem.getId().toString())) continue;
                vecBgItemForDel.add(bgItem.getId().toString());
            }
            if (vecBgItemForDel.size() > 0) {
                this.execDel(ctx, "T_Bg_BgItem", bgFormId, this.combinWhereClauseIn(vecBgItemForDel));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAddItemForAdjusting(Context ctx, String bgFormId, Vector vecAddItemForCheck) throws BgBizException {
        if (vecAddItemForCheck == null && vecAddItemForCheck.size() == 0) {
            return;
        }
        for (int j = 0; j < vecAddItemForCheck.size(); ++j) {
            Connection conn;
            PreparedStatement stmt;
            block7: {
                BgItemCollection bgItemColForAdd = (BgItemCollection)((Object)vecAddItemForCheck.get(j));
                Vector<String> vecBgItemNumberForAdd = new Vector<String>();
                if (bgItemColForAdd == null || bgItemColForAdd.size() <= 0) continue;
                StringBuffer sqlInner = new StringBuffer("");
                StringBuffer sqlWhere = new StringBuffer("");
                StringBuffer strNamePlusNumber = new StringBuffer("");
                for (int i = 0; i < bgItemColForAdd.size(); ++i) {
                    BgItemInfo bgItem = bgItemColForAdd.get(i);
                    if (bgItem == null || vecBgItemNumberForAdd.contains(bgItem.getId().toString())) continue;
                    vecBgItemNumberForAdd.add(bgItem.getItemNumber());
                    String prex = "a" + (i + 1);
                    sqlInner.append(" inner join t_bg_bgitem " + prex + " on a.fbgItem" + (i + 1) + "id = " + prex + ".fid ");
                    sqlWhere.append(" and " + prex + ".fItemNumber='" + bgItem.getItemNumber() + "'");
                    strNamePlusNumber.append(bgItem.getItemName() + " (" + bgItem.getItemNumber() + ") ");
                }
                StringBuffer sql = new StringBuffer("select count(a.fid) from t_bg_bgEntry a ");
                sql.append(sqlInner.toString());
                sql.append(" where fbgformid='" + bgFormId + "' ");
                sql.append(sqlWhere.toString());
                stmt = null;
                conn = null;
                ResultSet rs = null;
                try {
                    conn = EJBFactory.getConnection((Context)ctx);
                    stmt = conn.prepareStatement(sql.toString());
                    rs = stmt.executeQuery();
                    rs.next();
                    int count = rs.getInt(0);
                    if (count <= 0) break block7;
                    throw new BgBizException(BgBizException.BGITEMSHASEXISTED, new Object[]{strNamePlusNumber.toString()});
                }
                catch (SQLException e1) {
                    try {
                        logger.debug((Object)e1);
                        e1.printStackTrace();
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(stmt, (Connection)conn);
                        throw throwable;
                    }
                    SQLUtils.cleanup((Statement)stmt, (Connection)conn);
                    continue;
                }
            }
            SQLUtils.cleanup((Statement)stmt, (Connection)conn);
            continue;
        }
    }

    private void dealAddForAdjusting(Context ctx, HashMap hmAddItem, String bgFormId) throws EASBizException, BOSException {
        BgItemCollection bgItemCol = (BgItemCollection)((Object)hmAddItem.get(BgAdjustHelper.ADJUST_BGITEM));
        for (int i = 0; i < bgItemCol.size(); ++i) {
            BgItemInfo bgItem = bgItemCol.get(i);
            BgItemFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)bgItem);
        }
        BgDataCollection bgDataCol = (BgDataCollection)((Object)hmAddItem.get(BgAdjustHelper.ADJUST_BGDATA));
        Vector<String> vecBgEntryForAdd = new Vector<String>();
        for (int i = 0; i < bgDataCol.size(); ++i) {
            BgDataInfo bgData = bgDataCol.get(i);
            BgEntryInfo bgEntry = bgData.getBgEntry();
            BgFormInfo bgform = new BgFormInfo();
            bgform.setId(BOSUuid.read((String)bgFormId));
            bgEntry.setBgForm(bgform);
            if (bgEntry != null && !vecBgEntryForAdd.contains(bgEntry.getId().toString())) {
                BgEntryFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)bgEntry);
                vecBgEntryForAdd.add(bgEntry.getId().toString());
            }
            BgDataFactory.getLocalInstance(ctx).addnew(bgData);
        }
    }

    @Override
    protected void _updateBgDatas(Context ctx, String field, Hashtable dataMap) throws BOSException, EASBizException {
        String sqlField = "f" + field;
        String sql = " update t_bg_bgdata set " + sqlField + " = ? where fid = ?";
        PreparedStatement stmt = null;
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.prepareStatement(sql);
            for (Object key : dataMap.keySet()) {
                BigDecimal value = (BigDecimal)dataMap.get(key);
                stmt.setBigDecimal(1, value);
                stmt.setString(2, key.toString());
                stmt.addBatch();
            }
            Object it = stmt.executeBatch();
        }
        catch (SQLException e1) {
            try {
                logger.debug((Object)e1);
                e1.printStackTrace();
                throw new BgORMException(BgORMException.ADDNEWENTITY, e1, new Object[]{"BgV2Manager"});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
    }

    @Override
    protected Hashtable _getBgDatas(Context ctx, Vector bgItemVec, String currencyId, String bgFormId, String field) throws BOSException, EASBizException {
        Hashtable<String, BgDataInfo> result = new Hashtable<String, BgDataInfo>();
        String sqlField = "f" + field;
        String sql = "select a.fid ,a.felementnumber ,a." + sqlField + " , b.fperiodId ,b.fbgcycle ,c.fprecision  from t_bg_bgdata a ,t_bg_bgentry b ,t_bd_currency c  where a.fbgentryid = b.fid and a.FCurrencyID = c.fid and b.fbgformid= ? and a.FCurrencyID = ? ";
        int n = bgItemVec.size();
        for (int i = 0; i < n; ++i) {
            sql = sql + " and b.fbgitem" + (i + 1) + "id = ?";
        }
        Connection conn = this.getConnection(ctx);
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        try {
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, bgFormId);
            stmt.setString(2, currencyId);
            int index = 3;
            int n2 = bgItemVec.size();
            for (int i = 0; i < n2; ++i) {
                stmt.setString(index, ((BgItemInfo)bgItemVec.get(i)).getId().toString());
                ++index;
            }
            resultSet = stmt.executeQuery();
            BigDecimal one = new BigDecimal(1);
            while (resultSet.next()) {
                BgDataInfo bgDataInfo = this.generateBgData(resultSet, one, field);
                result.put(bgDataInfo.get("periodId") + "_" + (Integer)bgDataInfo.get("bgCycle") + "_" + bgDataInfo.getElementNumber(), bgDataInfo);
            }
        }
        catch (SQLException e) {
            try {
                System.out.println("get bg bgform!");
                logger.debug((Object)e);
                throw new EASBizException(BgBizException.GETDATA, (Throwable)e, new Object[]{"BgForm"});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(resultSet, (Statement)stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)resultSet, (Statement)stmt, (Connection)conn);
        return result;
    }

    @Override
    protected boolean _checkIsAdjustItem(Context ctx, String bgDataId) throws BOSException, EASBizException {
        ResultSet rs;
        PreparedStatement stmt;
        Connection conn;
        block5: {
            boolean bl;
            block6: {
                String sql = "select a.fEntryType from t_bg_bgEntry a, t_bg_bgData b  where b.fid='";
                sql = sql + bgDataId;
                sql = sql + "' and b.fbgEntryid = a.fid";
                conn = this.getConnection(ctx);
                stmt = null;
                rs = null;
                stmt = conn.prepareStatement(sql);
                rs = stmt.executeQuery();
                if (!rs.next()) break block5;
                if (rs.getInt(1) != 2) break block6;
                boolean bl2 = true;
                SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
                return bl2;
            }
            try {
                bl = false;
            }
            catch (SQLException e) {
                try {
                    throw new BgBizException(BgBizException.GETDATA, e, new Object[]{"bgForm"});
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, (Statement)stmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
            return bl;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return false;
    }

    @Override
    protected void _updateBgFormState(Context ctx, String bgFormId, int state) throws BOSException, EASBizException {
        String sql = "update t_bg_bgform set fstate = ? where fid = ? ";
        Connection conn = this.getConnection(ctx);
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(sql);
            stmt.setInt(1, state);
            stmt.setString(2, bgFormId);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            throw new BgBizException(BgBizException.GETDATA, e, new Object[]{"bgForm"});
        }
        finally {
            SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        }
    }
}

