/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.bg.BgBizException;
import com.kingdee.eas.ma.bg.EASLoginModel;
import com.kingdee.eas.ma.bg.IUnitTestEngine;
import com.kingdee.eas.ma.bg.ServerTestCase;
import com.kingdee.eas.ma.bg.UnitTestEngineFactory;
import com.kingdee.eas.ma.bg.app.dao.BgDAO;
import com.kingdee.util.UuidException;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;

public class ServerTestBgDAO
extends ServerTestCase {
    public ServerTestBgDAO(String arg) {
        super(arg);
    }

    public static void main(String[] args) {
        EASLoginModel model = EASLoginModel.newInstance();
        model.login();
        try {
            IUnitTestEngine engine = UnitTestEngineFactory.getRemoteInstance();
            engine.runMethod(ServerTestBgDAO.class, "testGetVO");
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBuildCreateTableSql() throws BgBizException, BOSException {
        String table = null;
        ResultSet rs = null;
        String sql = "Select * from t_bg_bgdata";
        Connection conn = null;
        PreparedStatement stat = null;
        MockBgDAO dao = new MockBgDAO();
        ((BgDAO)dao).initDAO(ctx);
        MockBgDAO mockDao = dao;
        try {
            conn = this.getConnection();
            stat = conn.prepareStatement(sql);
            rs = stat.executeQuery();
            mockDao.dropTable(table);
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stat, (Connection)conn);
                throw throwable;
            }
            SQLUtils.cleanup(rs, (Statement)stat, (Connection)conn);
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stat, (Connection)conn);
    }

    public void testGetPeriodSerial() throws EASBizException, BOSException, UuidException {
        MockBgDAO dao = new MockBgDAO();
        ((BgDAO)dao).initDAO(ctx);
        int rst = dao.getPeriodSerial(BOSUuid.read((String)"0fc2f63a-00fc-1000-e000-001ac0a8100d82388C4C"));
        ServerTestBgDAO.assertEquals((String)"rst", (int)200409, (int)rst);
    }

    public void testGetHistCurrencyCollRowSet() throws EASBizException, BOSException {
        MockBgDAO dao = new MockBgDAO();
        ((BgDAO)dao).initDAO(ctx);
        MockBgDAO mockDao = dao;
        BOSUuid typeId = BOSUuid.read((String)"c292cd11-00fb-1000-e000-0013c0a8129f530DC15D");
        ((BgDAO)dao).getHistCurrencyCollRowSet(typeId);
        ((BgDAO)dao).getHistDimList(typeId);
        ((BgDAO)dao).getHistElementList(typeId);
    }

    public void testGetVO() throws EASBizException, UuidException {
    }

    public void testGetConnection() throws SQLDataException, SQLException {
        MockBgDAO dao = new MockBgDAO();
        ((BgDAO)dao).initDAO(ctx);
        MockBgDAO mockDao = dao;
        mockDao.getConnection().close();
    }

    public void testgetBgTreeId() {
    }

    class MockBgDAO
    extends BgDAO {
        String result;

        public void dropTable(String tableName) throws BgBizException, SQLDataException {
        }

        protected Connection getConnection() throws SQLDataException {
            return super.getConnection(this.ctx);
        }

        @Override
        public CurrencyCollection getHistCurrencyCollRowSet(BOSUuid bgTypeId) throws EASBizException, BOSException {
            return super.getHistCurrencyCollRowSet(bgTypeId);
        }

        @Override
        public List getHistDimList(BOSUuid bgTypeId) throws EASBizException, BOSException {
            return super.getHistDimList(bgTypeId);
        }

        @Override
        public List getHistElementList(BOSUuid bgTypeId) throws EASBizException, BOSException {
            return super.getHistElementList(bgTypeId);
        }

        @Override
        public String getLongNumber(BOSUuid treeId, BOSUuid orgId) throws EASBizException, BOSException {
            return super.getLongNumber(treeId, orgId);
        }

        @Override
        public List getPeriodIDList(int beginYear, int beginNumber, int endYear, int endNumber, String typeIDs) throws EASBizException, BOSException {
            return super.getPeriodIDList(beginYear, beginNumber, endYear, endNumber, typeIDs);
        }

        @Override
        public void initDAO(Context ctx) {
            super.initDAO(ctx);
        }
    }
}

