/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.SimpleTimer;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.bg.BgCtrlDetailEntryInfo;
import com.kingdee.eas.ma.bg.BgCtrlDetailInfo;
import com.kingdee.eas.ma.bg.BgDataCollection;
import com.kingdee.eas.ma.bg.BgDataFactory;
import com.kingdee.eas.ma.bg.BgDataInfo;
import com.kingdee.eas.ma.bg.BgEntityAccess;
import com.kingdee.eas.ma.bg.BgEntryCollection;
import com.kingdee.eas.ma.bg.BgEntryFactory;
import com.kingdee.eas.ma.bg.BgFormFactory;
import com.kingdee.eas.ma.bg.BgFormInfo;
import com.kingdee.eas.ma.bg.BgItemInfo;
import com.kingdee.eas.ma.bg.BgORMEngine;
import com.kingdee.eas.ma.bg.BgTemplateColumnCollection;
import com.kingdee.eas.ma.bg.BgTemplateFactory;
import com.kingdee.eas.ma.bg.BgTemplateInfo;
import com.kingdee.eas.ma.bg.BgTypeCollection;
import com.kingdee.eas.ma.bg.BgTypeFactory;
import com.kingdee.eas.ma.bg.EASLoginModel;
import com.kingdee.eas.ma.bg.IBgData;
import com.kingdee.eas.ma.bg.IBgEntry;
import com.kingdee.eas.ma.bg.IBgForm;
import com.kingdee.eas.ma.bg.IBgTemplate;
import com.kingdee.eas.ma.bg.IBgType;
import com.kingdee.eas.ma.bg.IUnitTestEngine;
import com.kingdee.eas.ma.bg.ServerTestCase;
import com.kingdee.eas.ma.bg.UnitTestEngineFactory;
import com.kingdee.util.Uuid;
import java.math.BigDecimal;
import java.util.ArrayList;

public class ServerTestBgORMEngine
extends ServerTestCase {
    public ServerTestBgORMEngine(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        EASLoginModel model = EASLoginModel.newInstance();
        model.login("test", "test", "eas", "db2_focus");
        try {
            IUnitTestEngine engine = UnitTestEngineFactory.getRemoteInstance();
            engine.runMethod(ServerTestBgORMEngine.class, "testAddBgctrl");
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
    }

    public void testAddBgctrl() throws EASBizException {
        BgCtrlDetailInfo info = new BgCtrlDetailInfo();
        String[] proper = BgORMEngine.getPropertyAry(ctx, info.getBOSType());
        BgEntityAccess ea = new BgEntityAccess(ctx, info.getBOSType(), proper);
        BgCtrlDetailEntryInfo entry = new BgCtrlDetailEntryInfo();
        String[] entryproper = BgORMEngine.getPropertyAry(ctx, entry.getBOSType());
        BgEntityAccess ea2 = new BgEntityAccess(ctx, entry.getBOSType(), entryproper);
    }

    public void testRemoveAndUpdate() throws EASBizException, BOSException {
        boolean isn;
        int i;
        IBgTemplate tp = BgTemplateFactory.getLocalInstance(ctx);
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)"c0460cdd-00fd-1000-e000-000dc0a812a18316351D"));
        BgTemplateInfo info = tp.getBgTemplateInfo((IObjectPK)pk);
        ArrayList list = new ArrayList();
        BgORMEngine.addCollectionRemoveLisener((IObjectCollection)info.getBgTpColumns(), list);
        ServerTestBgORMEngine.assertEquals((int)0, (int)list.size());
        ServerTestBgORMEngine.assertEquals((int)5, (int)info.getBgTpColumns().size());
        info.getBgTpColumns().clear();
        ServerTestBgORMEngine.assertEquals((int)5, (int)list.size());
        BgORMEngine.addCollectionRemoveLisener((IObjectCollection)info.getBgTpColumns(), list);
        ServerTestBgORMEngine.assertEquals((int)0, (int)list.size());
        ServerTestBgORMEngine.assertEquals((int)0, (int)info.getBgTpColumns().size());
        info = tp.getBgTemplateInfo((IObjectPK)pk);
        BgORMEngine.addCollectionRemoveLisener((IObjectCollection)info.getBgTpColumns(), list);
        ServerTestBgORMEngine.assertEquals((int)0, (int)list.size());
        BgTemplateColumnCollection coll = info.getBgTpColumns();
        info.getBgTpColumns().addCollection(coll);
        ServerTestBgORMEngine.assertEquals((int)0, (int)list.size());
        ServerTestBgORMEngine.assertEquals((int)5, (int)info.getBgTpColumns().size());
        info.getBgTpColumns().clear();
        ServerTestBgORMEngine.assertEquals((int)5, (int)list.size());
        ServerTestBgORMEngine.assertEquals((int)0, (int)info.getBgTpColumns().size());
        info.getBgTpColumns().addCollection(coll);
        info = tp.getBgTemplateInfo((IObjectPK)pk);
        coll = new BgTemplateColumnCollection();
        BgORMEngine.addCollectionRemoveLisener((IObjectCollection)info.getBgTpColumns(), list);
        ServerTestBgORMEngine.assertEquals((int)0, (int)list.size());
        ServerTestBgORMEngine.assertEquals((int)5, (int)info.getBgTpColumns().size());
        coll.addCollection(info.getBgTpColumns());
        info.getBgTpColumns().clear();
        ServerTestBgORMEngine.assertEquals((int)5, (int)list.size());
        ServerTestBgORMEngine.assertEquals((int)0, (int)info.getBgTpColumns().size());
        info.getBgTpColumns().addCollection(coll);
        ServerTestBgORMEngine.assertEquals((int)0, (int)list.size());
        ServerTestBgORMEngine.assertEquals((int)5, (int)info.getBgTpColumns().size());
        BgORMEngine.addCollectionRemoveLisener((IObjectCollection)info.getBgTpColumns(), list);
        ServerTestBgORMEngine.assertEquals((int)0, (int)list.size());
        ServerTestBgORMEngine.assertEquals((int)5, (int)info.getBgTpColumns().size());
        info.getBgTpColumns().clear();
        for (i = 0; i < coll.size(); ++i) {
            isn = BgORMEngine.getIsNew((IObjectValue)coll.get(i));
            ServerTestBgORMEngine.assertEquals((boolean)false, (boolean)isn);
        }
        info.getBgTpColumns().addCollection(coll);
        ServerTestBgORMEngine.assertEquals((int)0, (int)list.size());
        ServerTestBgORMEngine.assertEquals((int)5, (int)info.getBgTpColumns().size());
        for (i = 0; i < info.getBgTpColumns().size(); ++i) {
            isn = BgORMEngine.getIsNew((IObjectValue)info.getBgTpColumns().get(i));
            ServerTestBgORMEngine.assertEquals((boolean)false, (boolean)isn);
        }
    }

    public void testNewVO() throws EASBizException, BOSException {
        IBgData dataCtrl = BgDataFactory.getLocalInstance(ctx);
        SimpleTimer st = new SimpleTimer();
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)"2c9414ee-00fd-1000-e000-16d8c0a8100d530621CD"));
        BgDataInfo vo = dataCtrl.getBgDataInfo((IObjectPK)pk);
        IObjectValue newVO = BgORMEngine.newVO((IObjectValue)vo);
    }

    public void testNewBgForm() throws EASBizException, BOSException {
        IBgForm dataCtrl = BgFormFactory.getLocalInstance(ctx);
        SimpleTimer st = new SimpleTimer();
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)"0d41ef6c-00fd-1000-e000-1ea6c0a8100d53073EE7"));
        BgFormInfo vo = dataCtrl.getBgFormInfo((IObjectPK)pk);
        IObjectValue newVO = BgORMEngine.newVO((IObjectValue)vo);
    }

    public void testNewUpdate() throws BOSException, EASBizException {
        IBgData dataCtrl = BgDataFactory.getLocalInstance(ctx);
        SimpleTimer st = new SimpleTimer();
        BgDataCollection coll = dataCtrl.getBgDataCollection();
        System.out.print(" getData " + st.getTime());
        String[] property = BgORMEngine.getPropertyAry(ctx, dataCtrl.getType());
        System.out.print(" getProperty " + st.getTime());
        st.reset();
        BgEntityAccess ea = new BgEntityAccess(ctx, dataCtrl.getType(), property);
        ea.update(ctx, BgORMEngine.buildVOArray((IObjectCollection)coll));
        System.out.print(" new Runtime " + st.getTime());
        st.reset();
        BgORMEngine.updateColl(ctx, BgORMEngine.buildVOArray((IObjectCollection)coll), property);
        System.out.print(" old Runtime " + st.getTime());
    }

    public void testGetValue() throws EASBizException {
        SimpleTimer st = new SimpleTimer();
        BOSUuid id = BOSUuid.read((String)"2c9414ee-00fd-1000-e000-16e4c0a8100d530621CD");
        String[] property = BgORMEngine.getPropertyAry(ctx, id.getType());
        BgEntityAccess ea = new BgEntityAccess(ctx, id.getType(), property);
        IObjectValue vo = ea.getVO(ctx, id);
        System.out.print(" getData " + st.getTime());
    }

    public void testNewaddnew() throws BOSException, EASBizException {
        int i;
        IBgData dataCtrl = BgDataFactory.getLocalInstance(ctx);
        SimpleTimer st = new SimpleTimer();
        BgDataCollection coll = dataCtrl.getBgDataCollection();
        System.out.print(" getData " + st.getTime());
        String[] property = BgORMEngine.getPropertyAry(ctx, dataCtrl.getType());
        System.out.print(" getProperty " + st.getTime());
        st.reset();
        BgEntityAccess ea = new BgEntityAccess(ctx, dataCtrl.getType(), property);
        for (i = 0; i < coll.size(); ++i) {
            coll.get(i).setBOSUuid("id", null);
            coll.get(i).setString("number", Uuid.create().toString());
        }
        ea.addnew(ctx, BgORMEngine.buildVOArray((IObjectCollection)coll));
        System.out.print(" new Runtime " + st.getTime());
        for (i = 0; i < coll.size(); ++i) {
            coll.get(i).setBOSUuid("id", null);
            coll.get(i).setString("number", Uuid.create().toString());
        }
        st.reset();
        BgORMEngine.addnewVO(ctx, BgORMEngine.buildVOArray((IObjectCollection)coll), property);
        System.out.print(" old Runtime " + st.getTime());
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGetBgForm() throws EASBizException, BOSException {
        BOSUuid id = BOSUuid.read((String)"2b8e9478-00fd-1000-e000-08bec0a8100d53073EE7");
        String[] property = new String[]{"number", "bizDate", "name", "state", "purpose", "isCurrent", "modifiableByJunior", "creator", "createTime", "lastUpdateUser", "lastUpdateTime", "handler", "description", "hasEffected", "auditor"};
        IObjectValue vo = BgORMEngine.getVO(ctx, id, property);
        ServerTestBgORMEngine.assertEquals((Object)vo.getBOSUuid("id"), (Object)id);
        IObjectValue[] coll = new IObjectValue[]{vo, vo};
        BgORMEngine.updateColl(ctx, coll, property);
    }

    public void testSetNew() throws EASBizException, BOSException {
        BOSUuid id = BOSUuid.read((String)"2b8e9478-00fd-1000-e000-08bec0a8100d53073EE7");
        String[] property = new String[]{"number", "bizDate", "name", "state", "purpose", "isCurrent", "modifiableByJunior", "creator", "createTime", "lastUpdateUser", "lastUpdateTime", "handler", "description", "hasEffected", "auditor"};
        IObjectValue vo = BgORMEngine.getVO(ctx, id, property);
        vo.setString("number", "utTest");
        vo.setBOSUuid("id", null);
        BgORMEngine.addnewVO(ctx, new IObjectValue[]{vo}, property);
        BgORMEngine.removeVOColl(ctx, new BOSUuid[]{vo.getBOSUuid("id")});
        ServerTestBgORMEngine.assertEquals((boolean)false, (boolean)BgORMEngine.getIsNew(vo));
        BgORMEngine.setIsNew(vo, true);
        ServerTestBgORMEngine.assertEquals((boolean)true, (boolean)BgORMEngine.getIsNew(vo));
        BgORMEngine.storeVOColl(ctx, new IObjectValue[]{vo}, property);
        BgORMEngine.removeVOColl(ctx, new BOSUuid[]{vo.getBOSUuid("id")});
    }

    public void testBgItem() throws EASBizException, BOSException {
        BOSUuid id = BOSUuid.read((String)"0d41ef6c-00fd-1000-e000-0967c0a8100d5308AD36");
        String[] property = new String[]{"name", "isLeaf"};
        BgItemInfo bgItemInfo = new BgItemInfo();
        bgItemInfo.setId(id);
        BgORMEngine.updateColl(ctx, (IObjectValue[])new BgItemInfo[]{bgItemInfo, bgItemInfo}, property);
    }

    public void testRemove() throws EASBizException {
        BOSUuid[] ids = new BOSUuid[]{BOSUuid.read((String)"2b8e9478-00fd-1001-e000-08bec0a8100d53073EE7"), BOSUuid.read((String)"2c9414ee-002d-1000-e000-0383c0a8100d53073EE7")};
        BgORMEngine.removeVOColl(ctx, ids);
    }

    public void testGetEntityProperty() throws EASBizException {
        BgDataInfo info = new BgDataInfo();
        String[] prop = BgORMEngine.getPropertyAry(ctx, info.getBOSType());
        for (int i = 0; i < prop.length; ++i) {
        }
    }

    public void testCollectionChangeLisener() throws BOSException, EASBizException {
        IBgData dataCtrl = BgDataFactory.getLocalInstance(ctx);
        BgDataCollection coll = dataCtrl.getBgDataCollection();
        BgORMEngine.addVOColectionChangeLisener((IObjectCollection)coll, BgORMEngine.getPropertyAry(ctx, dataCtrl.getType()));
        coll.get(1).setBgActual(new BigDecimal("33"));
        boolean isNeed = BgORMEngine.isNeedUpdate((IObjectValue)coll.get(1));
        ServerTestBgORMEngine.assertEquals((String)"isNedd1 ", (boolean)true, (boolean)isNeed);
        boolean isNeed2 = BgORMEngine.isNeedUpdate((IObjectValue)coll.get(0));
        ServerTestBgORMEngine.assertEquals((String)"isNeed2 ", (boolean)false, (boolean)isNeed2);
        BgORMEngine.setIsChanged((IObjectValue)coll.get(1), false);
        boolean isNeed3 = BgORMEngine.isNeedUpdate((IObjectValue)coll.get(1));
        ServerTestBgORMEngine.assertEquals((String)"isNeed3", (boolean)false, (boolean)isNeed3);
    }

    public void testAddnewPage() throws BOSException, EASBizException {
        SimpleTimer st = new SimpleTimer();
        IBgType dataCtrl = BgTypeFactory.getLocalInstance(ctx);
        BgTypeCollection coll = dataCtrl.getBgTypeCollection();
        System.out.print(" getData " + st.getTime());
        for (int i = 0; i < coll.size(); ++i) {
            coll.get(i).setId(null);
            coll.get(i).setNumber(Uuid.create().toString());
        }
        BgORMEngine.addnewVO(ctx, BgORMEngine.buildVOArray((IObjectCollection)coll));
    }

    public void testBgType() throws BOSException, EASBizException {
        SimpleTimer st = new SimpleTimer();
        IBgType dataCtrl = BgTypeFactory.getLocalInstance(ctx);
        BgTypeCollection coll = dataCtrl.getBgTypeCollection();
        System.out.print(" getData " + st.getTime());
        String[] property = BgORMEngine.getPropertyAry(ctx, dataCtrl.getType());
        System.out.print(" getProperty " + st.getTime());
        BgORMEngine.updateColl(ctx, BgORMEngine.buildVOArray((IObjectCollection)coll), property);
        System.out.print(" upProperty " + st.getTime());
    }

    public void testBgData() throws BOSException, EASBizException {
        SimpleTimer st = new SimpleTimer();
        IBgData dataCtrl = BgDataFactory.getLocalInstance(ctx);
        BgDataCollection coll = dataCtrl.getBgDataCollection();
        System.out.print(" getData " + st.getTime());
        System.out.print(" size " + coll.size());
        String[] property = BgORMEngine.getPropertyAry(ctx, dataCtrl.getType());
        System.out.print(" getProperty " + st.getTime());
        BgORMEngine.updateColl(ctx, BgORMEngine.buildVOArray((IObjectCollection)coll), property);
        System.out.print(" upProperty " + st.getTime());
    }

    public void testRemoveBgData() throws BOSException, EASBizException {
        SimpleTimer st = new SimpleTimer();
        IBgData dataCtrl = BgDataFactory.getLocalInstance(ctx);
        BgDataCollection coll = dataCtrl.getBgDataCollection();
        System.out.print(" getData " + st.getTime());
        System.out.print(" size " + coll.size());
        System.out.print(" getProperty " + st.getTime());
        BOSUuid[] ids = BgORMEngine.getIDAry((IObjectCollection)coll);
        System.out.print(" getIds" + st.getTime());
        BgORMEngine.removeVOColl(ctx, ids);
        System.out.print(" upProperty " + st.getTime());
    }

    public void testCollectionRemoveLisener() throws BOSException, EASBizException {
        SimpleTimer st = new SimpleTimer();
        IBgEntry dataCtrl = BgEntryFactory.getLocalInstance(ctx);
        BgEntryCollection coll = dataCtrl.getBgEntryCollection();
        System.out.print(" getData " + st.getTime());
        String[] property = BgORMEngine.getPropertyAry(ctx, dataCtrl.getType());
        System.out.print(" getProperty " + st.getTime());
        BgORMEngine.updateColl(ctx, BgORMEngine.buildVOArray((IObjectCollection)coll), property);
        System.out.print(" upProperty " + st.getTime());
        int size = coll.size();
        ArrayList list = new ArrayList();
        BgORMEngine.addCollectionRemoveLisener((IObjectCollection)coll, list);
        ServerTestBgORMEngine.assertEquals((String)"size first:", (int)0, (int)list.size());
        coll.removeObject(1);
        ServerTestBgORMEngine.assertEquals((String)"size is ", (int)1, (int)list.size());
        coll.clear();
        ServerTestBgORMEngine.assertEquals((String)"size is ", (int)size, (int)list.size());
    }

    public void testVOListener() {
        BgDataInfo info = new BgDataInfo();
        BOSUuid id = BOSUuid.read((String)"0d41ef6c-00fd-1000-e000-10fec0a8100d530621CD");
        info.setId(id);
        info.setBgValue(new BigDecimal("2"));
        BgORMEngine.addVOValueChangeLisener((IObjectValue)info, new String[]{"bgValue"});
        info.setBgValue(new BigDecimal("2"));
        info.setBgBalance(new BigDecimal("33"));
        boolean isChange = BgORMEngine.isNeedUpdate((IObjectValue)info);
        ServerTestBgORMEngine.assertEquals((String)"isChange ", (boolean)false, (boolean)isChange);
        info.setBgValue(new BigDecimal("33"));
        boolean isChange2 = BgORMEngine.isNeedUpdate((IObjectValue)info);
        ServerTestBgORMEngine.assertEquals((String)"isChange2 ", (boolean)true, (boolean)isChange2);
        BgORMEngine.setIsLisener((IObjectValue)info, false);
        BgORMEngine.setIsChanged((IObjectValue)info, false);
        boolean isChange3 = BgORMEngine.isNeedUpdate((IObjectValue)info);
        ServerTestBgORMEngine.assertEquals((String)"isChange3 ", (boolean)false, (boolean)isChange3);
        info.setBgValue(new BigDecimal("12"));
        boolean isChange4 = BgORMEngine.isNeedUpdate((IObjectValue)info);
        ServerTestBgORMEngine.assertEquals((String)"isChange4 ", (boolean)false, (boolean)isChange4);
        BgORMEngine.setIsLisener((IObjectValue)info, true);
        info.setBgActual(new BigDecimal("22"));
        boolean isChange5 = BgORMEngine.isNeedUpdate((IObjectValue)info);
        ServerTestBgORMEngine.assertEquals((String)"isChange5 ", (boolean)false, (boolean)isChange5);
        info.setBgValue(new BigDecimal("3233"));
        boolean isChange6 = BgORMEngine.isNeedUpdate((IObjectValue)info);
        ServerTestBgORMEngine.assertEquals((String)"isChange6 ", (boolean)true, (boolean)isChange6);
    }
}

