/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.bg.BgBizException;
import com.kingdee.eas.ma.bg.BgHelper;
import com.kingdee.eas.ma.bg.app.dao.BgAlyDAOBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class BgExcTrackAlyDAO
extends BgAlyDAOBase {
    public static BgExcTrackAlyDAO getInstance(Context ctx) {
        BgExcTrackAlyDAO dao = new BgExcTrackAlyDAO();
        dao.ctx = ctx;
        dao.locale = ctx.getLocale().toString();
        return dao;
    }

    private BgExcTrackAlyDAO() {
    }

    public String getCreateSql1(String table) {
        StringBuffer sbCreateTable1 = new StringBuffer();
        sbCreateTable1.append("Create Table ");
        sbCreateTable1.append(table);
        sbCreateTable1.append("(FID char (44), FOrgUnitID char (44), FBgTypeID char (44), FPeriodID char (44), FBgItem1ID char (44), FBgItem2ID char (44), FBgItem3ID char (44), FBgItem4ID char (44), FBgItem5ID char (44), FBgItem6ID char (44))");
        return sbCreateTable1.toString();
    }

    public String getCreateSql2(String table) {
        StringBuffer sbCreateTable2 = new StringBuffer();
        sbCreateTable2.append("Create Table ");
        sbCreateTable2.append(table);
        sbCreateTable2.append(" (FID varchar (512),FOrgUnitID char (44),FBgTypeID char (44),FDispPeriod char (44),FBizElement int ,FCurrencyID char (44),FBgValue decimal(28,10),FBgLastBalance decimal(28,10),FBgActual decimal(28,10),FBgBalance decimal(28,10),FBgUsableValue decimal(28,10),FBIZCURRENCYID char (44),FBizDate datetime ,FSrcBillTypeID varchar (80),FSrcBillNumber varchar (80),FSrcBillID char (44),FBgAuditStyle int ,FBizData0 decimal(28,10),FBizData1 decimal(28,10),FBizData2 decimal(28,10),FBizData3 decimal(28,10),FBizData4 decimal(28,10),FCtrlSystem int , FDimSerial varchar(512),FBgItem1ID char (44),FBgItem2ID char (44),FBgItem3ID char (44),FBgItem4ID char (44),FBgItem5ID char (44),FBgItem6ID char (44))");
        return sbCreateTable2.toString();
    }

    protected Connection getConnection(Context ctx) throws SQLDataException {
        try {
            return EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException sqle) {
            throw new SQLDataException(sqle);
        }
    }

    public IRowSet getResult(EntityViewInfo ev) throws EASBizException, BOSException {
        FilterItemCollection filters = ev.getFilter().getFilterItems();
        boolean filterByBizDate = this.isByBizDate(filters);
        Integer dispPeriod = (Integer)BgHelper.getFilterValue(filters, "displayPeriodStyle");
        String tableName1 = BgHelper.getTableName(this.ctx);
        String sbCreateTable1 = this.getCreateSql1(tableName1);
        String sbInsertTable1 = this.getInsertSql1(filters, filterByBizDate, tableName1, dispPeriod);
        String tableName2 = BgHelper.getTableName(this.ctx);
        String sbCreateTable2 = this.getCreateSql2(tableName2);
        String sbInsertTable2 = this.getInsertSql2(filterByBizDate, dispPeriod, tableName1, tableName2);
        PreparedStatement stmt = null;
        ResultSet rs = null;
        JdbcRowSet result = null;
        Connection conn = this.getConnection(this.ctx);
        try {
            stmt = conn.prepareStatement(sbCreateTable1.toString());
            stmt.execute();
            stmt.close();
            stmt = conn.prepareStatement(sbInsertTable1.toString());
            this.setParams1(filters, filterByBizDate, stmt);
            stmt.execute();
            stmt.close();
            stmt = conn.prepareStatement(sbCreateTable2.toString());
            stmt.execute();
            stmt.close();
            stmt = conn.prepareStatement(sbInsertTable2.toString());
            this.setParams2(filters, filterByBizDate, stmt);
            stmt.execute();
            stmt.close();
            String sql = this.getDisplaySql(tableName2);
            stmt = conn.prepareStatement(sql);
            rs = stmt.executeQuery();
            result = new JdbcRowSet();
            result.populate(rs);
        }
        catch (SQLException ex) {
            try {
                ex.printStackTrace();
                throw new BgBizException(BgBizException.BGALYRPTFETCHDATA, ex, new Object[]{"getExpBalanceRowSet"});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)stmt, (Connection)conn);
                BgHelper.dropTable(this.ctx, tableName1);
                BgHelper.dropTable(this.ctx, tableName2);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        BgHelper.dropTable(this.ctx, tableName1);
        BgHelper.dropTable(this.ctx, tableName2);
        return result;
    }

    public String getInsertSql1(FilterItemCollection filters, boolean filterByBizDate, String tableName1, Integer dispPeriod) {
        StringBuffer sbInsertTable1 = new StringBuffer();
        sbInsertTable1.append("INSERT INTO ");
        sbInsertTable1.append(tableName1);
        sbInsertTable1.append(" SELECT v.FID, v.FOrgUnitID, v.FBgTypeID, v.FPeriodID, v.FBgItem1ID, v.FBgItem2ID, v.FBgItem3ID, v.FBgItem4ID, v.FBgItem5ID, v.FBgItem6ID FROM V_BG_BgEntry as v, t_bg_bgentry as t");
        if (filterByBizDate) {
            sbInsertTable1.append(" WHERE  (v.FOrgUnitID IN (").append(BgHelper.getFilterValue(filters, "bizOrgUnitIDs")).append(")  AND (v.FBgTypeID = ?) AND (v.FEndDate  > ?) AND  (v.FBeginDate < ?))");
        } else {
            sbInsertTable1.append(" WHERE  (v.FOrgUnitID IN (").append(BgHelper.getFilterValue(filters, "bizOrgUnitIDs")).append(") ").append(" AND (v.FBgTypeID = ?) AND (v.FPeriodYear*100+v.FPeriodNumber  BETWEEN ? AND ?)) ");
        }
        Object flag = BgHelper.getFilterValue(filters, "flag");
        if (flag != null && flag.equals("ViewCtrlDetail")) {
            String entryIds = BgHelper.getFilterValue(filters, "entryIds").toString();
            sbInsertTable1.append(" AND (v.FID IN(");
            sbInsertTable1.append(entryIds);
            sbInsertTable1.append("))");
        }
        sbInsertTable1.append(" and v.fid=t.fid ");
        if (dispPeriod != 12) {
            if (dispPeriod == 1) {
                sbInsertTable1.append(" and t.FBgCycle=3 ");
            } else if (dispPeriod == 3) {
                sbInsertTable1.append(" and (t.FBgCycle=2 or t.FBgCycle=3) ");
            }
        }
        return sbInsertTable1.toString();
    }

    public String getInsertSql2(boolean filterByBizDate, Integer dispPeriod, String tableName1, String tableName2) {
        StringBuffer sbInsertTable2 = new StringBuffer();
        String dispPeriodS = "";
        String groupPeriod = "";
        sbInsertTable2.append("INSERT INTO ");
        sbInsertTable2.append(tableName2);
        sbInsertTable2.append(" SELECT BgCtrlDetail.FID,  BgEntry.FOrgUnitID, BgEntry.FBgTypeID, to_char(Period.FPeriodYear)||'-'||right('0'||to_char(Period.FPeriodNumber),2) as FDispPeriod, BgElement.FBizElement, BgData.FCurrencyID, BgData.FBgValue, BgData.FBgLastBalance, BgData.FBgActual, BgData.FBgBalance, BgData.FBgUsableValue, BgCtrlDetail.FCurrencyID AS FBizCurrencyID, BgCtrlDetail.FBizDate, BgCtrlDetail.FSrcBillTypeID, BgCtrlDetail.FSrcBillNumber, BgCtrlDetail.FSrcBillID, BgCtrlDetail.FBgAuditStyle, BgCtrlDetail.FBizData0, BgCtrlDetail.FBizData1, BgCtrlDetail.FBizData2, BgCtrlDetail.FBizData3, BgCtrlDetail.FBizData4, BgCtrlDetail.FCtrlSystem, isnull(BgEntry.FBgItem1ID,'') || isnull(BgEntry.FBgItem2ID,'') || isnull(BgEntry.FBgItem3ID,'') || isnull(BgEntry.FBgItem4ID,'') || isnull(BgEntry.FBgItem5ID,'') || isnull(BgEntry.FBgItem5ID,'') ||BgCtrlDetail.FCurrencyID AS FDimSerial, BgEntry.FBgItem1ID, BgEntry.FBgItem2ID, BgEntry.FBgItem3ID, BgEntry.FBgItem4ID, BgEntry.FBgItem5ID, BgEntry.FBgItem6ID ");
        sbInsertTable2.append(" FROM T_BG_BgCtrlDetail BgCtrlDetail INNER JOIN T_BG_BgCtrlDetailEntry CtrlDetailEntry ON BgCtrlDetail.FID = CtrlDetailEntry.FBillID inner JOIN T_BG_BgData BgData INNER JOIN T_BG_BgElement BgElement ON BgData.FBgElementID = BgElement.FID inner JOIN ");
        sbInsertTable2.append(tableName1);
        sbInsertTable2.append(" BgEntry ON BgData.FBgEntryID = BgEntry.FID ON CtrlDetailEntry.FBgDataID = BgData.FID   INNER JOIN T_BD_Period Period ON Period.FID = BgEntry.FPeriodID");
        if (filterByBizDate) {
            sbInsertTable2.append(" WHERE (BgCtrlDetail.FBizDate BETWEEN ? AND ?)");
        }
        return sbInsertTable2.toString();
    }

    public void setParams1(FilterItemCollection filters, boolean filterByBizDate, PreparedStatement stmt) throws SQLException {
        int number = 1;
        stmt.setString(number++, BgHelper.getId(BgHelper.getFilterValue(filters, "bgType")));
        if (filterByBizDate) {
            stmt.setDate(number++, (Date)BgHelper.getFilterValue(filters, "beginBizDate"));
            stmt.setDate(number++, (Date)BgHelper.getFilterValue(filters, "endBizDate"));
        } else {
            int beginPeriodYear = Integer.parseInt(BgHelper.getFilterValue(filters, "beginPeriodYear").toString().trim());
            int beginPeriodMonth = Integer.parseInt(BgHelper.getFilterValue(filters, "beginPeriodMonth").toString().trim());
            int endPeriodYear = Integer.parseInt(BgHelper.getFilterValue(filters, "endPeriodYear").toString().trim());
            int endPeriodMonth = Integer.parseInt(BgHelper.getFilterValue(filters, "endPeriodMonth").toString().trim());
            stmt.setInt(number++, beginPeriodYear * 100 + beginPeriodMonth);
            stmt.setInt(number++, endPeriodYear * 100 + endPeriodMonth);
        }
    }

    public void setParams2(FilterItemCollection filters, boolean filterByBizDate, PreparedStatement stmt) throws SQLException {
        if (filterByBizDate) {
            stmt.setDate(1, (Date)BgHelper.getFilterValue(filters, "beginBizDate"));
            stmt.setDate(2, (Date)BgHelper.getFilterValue(filters, "endBizDate"));
        }
    }
}

