/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.control.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.CanNotDeleteException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.control.BgControlException;
import com.kingdee.eas.ma.control.BgControlItemMapFactory;
import com.kingdee.eas.ma.control.BgControlItemMapInfo;
import com.kingdee.eas.ma.control.BgControlSchemeCollection;
import com.kingdee.eas.ma.control.BgControlSchemeDistParameter;
import com.kingdee.eas.ma.control.BgControlSchemeException;
import com.kingdee.eas.ma.control.BgControlSchemeFacadeFactory;
import com.kingdee.eas.ma.control.BgControlSchemeFactory;
import com.kingdee.eas.ma.control.BgControlSchemeInfo;
import com.kingdee.eas.ma.control.IBgControlSchemeFacade;
import com.kingdee.eas.ma.control.app.AbstractBgControlSchemeControllerBean;
import com.kingdee.eas.ma.control.utils.ControlSchemeUtils;
import com.kingdee.eas.ma.mbg.BgTemplateException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgControlSchemeControllerBean
extends AbstractBgControlSchemeControllerBean {
    private static final long serialVersionUID = -8465607882285611229L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.control.app.BgControlSchemeControllerBean");

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BgControlSchemeInfo scheme = (BgControlSchemeInfo)model;
        if (scheme.getParentID() == null) {
            if (scheme.getId() == null) {
                scheme.setId(BOSUuid.create((BOSObjectType)scheme.getBOSType()));
            }
            scheme.setParentID(scheme.getId());
        }
        if (scheme.getRootID() == null) {
            if (scheme.getId() == null) {
                scheme.setId(BOSUuid.create((BOSObjectType)scheme.getBOSType()));
            }
            scheme.setRootID(scheme.getId());
        }
        CoreBaseCollection colls = new CoreBaseCollection();
        if (!scheme.getItemMaps().isEmpty()) {
            int in = scheme.getItemMaps().size();
            for (int i = 0; i < in; ++i) {
                colls.add((CoreBaseInfo)scheme.getItemMaps().get(i));
            }
            scheme.remove("itemMaps");
        }
        IObjectPK pk = super._addnew(ctx, model);
        if (!colls.isEmpty()) {
            BgControlItemMapFactory.getLocalInstance(ctx).updateBatchData(BOSUuid.read((String)pk.toString()), (IObjectCollection)colls);
        }
        return pk;
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        BgControlSchemeInfo scheme = (BgControlSchemeInfo)model;
        if (this.isValid(ctx, pk)) {
            throw new BgControlSchemeException(BgControlSchemeException.SCHEMEISVALID);
        }
        CoreBaseCollection colls = new CoreBaseCollection();
        if (!scheme.getItemMaps().isEmpty()) {
            int in = scheme.getItemMaps().size();
            for (int i = 0; i < in; ++i) {
                colls.add((CoreBaseInfo)scheme.getItemMaps().get(i));
            }
            scheme.remove("itemMaps");
        }
        super._update(ctx, pk, model);
        if (!colls.isEmpty()) {
            BgControlItemMapFactory.getLocalInstance(ctx).updateBatchData(BOSUuid.read((String)pk.toString()), (IObjectCollection)colls);
        }
    }

    private boolean isValid(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = this.getStateSelector();
        BgControlSchemeInfo _oldValue = (BgControlSchemeInfo)this._getValue(ctx, pk, sic);
        return _oldValue != null && _oldValue.isIsValid();
    }

    private SelectorItemCollection getStateSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("isValid");
        sic.add("update");
        return sic;
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (this.isValid(ctx, pk)) {
            throw new BgControlSchemeException(BgControlSchemeException.SCHEMEISVALIDOFDELETE);
        }
        String _bgControlSchemeId = pk.toString();
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            BgDBUtils.executeUpdate((Connection)conn, (String)"delete from T_MBG_BgControlItemMapEntry where FMapID IN (select FID from T_MBG_BgControlItemMap where FControlSchemeID = ?)", (Object[])new Object[]{_bgControlSchemeId});
            BgDBUtils.executeUpdate((Connection)conn, (String)"delete from T_MBG_BgControlItemMap where FControlSchemeID = ?", (Object[])new Object[]{_bgControlSchemeId});
        }
        catch (SQLException ex) {
            logger.error((Object)"delete Control Scheme sql error:", (Throwable)ex);
            throw new BgControlException(BgControlException.DATABASEEXCEPTION, new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        super._delete(ctx, pk);
    }

    protected void _canDelete(Context ctx, IObjectPK pk, Connection cn) throws CanNotDeleteException {
        super._canDelete(ctx, pk, cn);
        try {
            BgControlSchemeInfo value = (BgControlSchemeInfo)this._getValue(ctx, pk, this.getStateSelector());
            if (value.isIsValid()) {
                throw new CanNotDeleteException(new BgControlSchemeException(BgControlSchemeException.SCHEMEISVALIDOFDELETE).getMessage());
            }
            if (!value.isUpdate()) {
                throw new CanNotDeleteException(ControlSchemeUtils.getControlModifyMsg(ctx, false).getMessage());
            }
            if (this._exists(ctx, "where id <> '" + pk + "' and parentId = '" + pk + "'")) {
                throw new CanNotDeleteException(new BgControlSchemeException(BgControlSchemeException.SCHEMEASSIGNED).getMessage());
            }
        }
        catch (CanNotDeleteException e) {
            throw e;
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
            throw new CanNotDeleteException((Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            throw new CanNotDeleteException((Throwable)e);
        }
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BgControlSchemeInfo info = (BgControlSchemeInfo)model;
        String id = "000000000000000000000000000=";
        if (info.getId() != null) {
            id = info.getId().toString();
        }
        Connection conn = null;
        PreparedStatement pmst = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pmst = conn.prepareStatement("SELECT FID FROM T_MBG_BgControlScheme WHERE FOrgUnitID=? AND FNumber=? and FID <> ?  AND  FIsSysDefault = 0");
            pmst.setString(1, info.getOrgUnit().getId().toString());
            pmst.setString(2, info.getNumber());
            pmst.setString(3, id);
            rs = pmst.executeQuery();
            if (rs.next()) {
                throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{info.getNumber()});
            }
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pmst, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pmst, (Connection)conn);
    }

    @Override
    protected Map _distribute(Context ctx, Map param) throws BOSException, EASBizException {
        if (param == null || param.isEmpty() || !(param.get("parameter") instanceof BgControlSchemeDistParameter)) {
            return null;
        }
        HashMap<String, Object> rsMap = new HashMap<String, Object>();
        BgControlSchemeDistParameter p = (BgControlSchemeDistParameter)param.get("parameter");
        List schemeIds = p.getBgControlSchemeList();
        List<String> orgList = p.getDistOrgUnits();
        boolean isModifyState = p.isModifyState();
        boolean isModifyScheme = p.isUpate();
        boolean isCoverage = p.isCoverage();
        IBgControlSchemeFacade iBgControlSchemeFacade = BgControlSchemeFacadeFactory.getLocalInstance(ctx);
        BgControlSchemeDistParameter temPara = null;
        String id = null;
        for (int index = 0; index < schemeIds.size(); ++index) {
            id = (String)schemeIds.get(index);
            temPara = new BgControlSchemeDistParameter();
            temPara.setBgControlSchemeId(id);
            temPara.setDistOrgUnits(orgList);
            temPara.setModifyState(isModifyState);
            temPara.setUpate(isModifyScheme);
            temPara.setCoverage(isCoverage);
            rsMap.put(id, iBgControlSchemeFacade.distribution(temPara));
        }
        return rsMap;
    }

    @Override
    protected void _verifyCanModifyState(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        if (id == null) {
            return;
        }
        Connection conn = null;
        PreparedStatement pmst = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pmst = conn.prepareStatement("SELECT FIsModifyState FROM T_MBG_BgControlScheme WHERE FID=?");
            pmst.setString(1, id.toString());
            rs = pmst.executeQuery();
            while (rs.next()) {
                if (rs.getBoolean("FIsModifyState")) continue;
                throw new BgControlSchemeException(BgControlSchemeException.NOTMODIFYSTATE);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pmst, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pmst, (Connection)conn);
    }

    @Override
    protected void _verifyCanModifyScheme(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        if (id == null) {
            return;
        }
        Connection conn = null;
        PreparedStatement pmst = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pmst = conn.prepareStatement("SELECT FIsUpdate FROM T_MBG_BgControlScheme WHERE FID=?");
            pmst.setString(1, id.toString());
            rs = pmst.executeQuery();
            while (rs.next()) {
                if (rs.getBoolean("FIsUpdate")) continue;
                throw ControlSchemeUtils.getControlModifyMsg(ctx, false);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pmst, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pmst, (Connection)conn);
    }

    @Override
    protected Map _queryBizItemMap(Context ctx, BOSUuid bgControlSchemeId) throws BOSException, EASBizException {
        HashMap bizItemMap = new HashMap();
        if (ctx == null || bgControlSchemeId == null) {
            return bizItemMap;
        }
        String bizProp = null;
        String bizPropKey = null;
        int dimensionGroup = 0;
        Object[] obj = null;
        List<Object[]> objs = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select t.FBizProp, t.FDimensionGroup, e.FBizItemValue, e.FBizItemAlias, e.FMbgItemValue, e.FMbgItemAlias, e.FIsMatching from T_MBG_BgControlItemMap t join T_MBG_BgControlItemMapEntry e on t.FID = e.FMapId where t.FControlSchemeId = ?");
        Connection conn = null;
        IRowSet rst = null;
        try {
            conn = this.getConnection(ctx);
            rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString(), (Object[])new Object[]{bgControlSchemeId.toString()});
            while (rst.next()) {
                bizProp = rst.getString("FBizProp");
                bizPropKey = BgControlItemMapInfo.getBizPropKey(bizProp, dimensionGroup = rst.getInt("FDimensionGroup"));
                if (bizItemMap.containsKey(bizPropKey)) {
                    objs = (List)bizItemMap.get(bizPropKey);
                } else {
                    objs = new ArrayList();
                    bizItemMap.put(bizPropKey, objs);
                }
                obj = new Object[]{rst.getString("FBizItemValue"), rst.getString("FBizItemAlias"), rst.getString("FMbgItemValue"), rst.getString("FMbgItemAlias"), rst.getBoolean("FIsMatching")};
                objs.add(obj);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"queryBizItemMap sql error:", (Throwable)ex);
                throw new BgControlException(BgControlException.DATABASEEXCEPTION, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, null, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, null, (Connection)conn);
        return bizItemMap;
    }

    @Override
    protected String _antiDistribute(Context ctx, Map param) throws BOSException, EASBizException {
        String tableNameB;
        String tableNameA;
        TempTablePool pool;
        IRowSet rst;
        Connection conn;
        StringBuffer msg;
        block51: {
            msg = new StringBuffer();
            if (ctx == null || param == null) {
                return msg.toString();
            }
            conn = null;
            rst = null;
            String childId = null;
            String parentId = null;
            String checkid = null;
            String checkOrgunitid = null;
            String checkNumber = null;
            StringBuffer str = new StringBuffer();
            HashSet<String> childIds = new HashSet<String>();
            HashMap<String, String> childMap = new HashMap<String, String>();
            HashMap<String, Set<String>> parentAndChildMap = new HashMap<String, Set<String>>();
            HashSet<String> deleteSetParentIds = new HashSet<String>();
            HashSet<String> bgCheckSet = new HashSet<String>();
            Set<String> newSet = null;
            HashMap<String, String> checkidMap = new HashMap<String, String>();
            HashMap<String, String> checkOrgMap = new HashMap<String, String>();
            HashMap<String, String> checkNumMap = new HashMap<String, String>();
            HashSet<String> checkOrgunitidSet = new HashSet<String>();
            String checkOrgunitFid = null;
            String checkOrgunitFname = null;
            StringBuffer strMsg = new StringBuffer();
            Object[] mp = new String[2];
            String reason = null;
            BgControlSchemeDistParameter bgc = (BgControlSchemeDistParameter)param.get("parameter");
            List bgControlSchemeRootID = bgc.getBgControlSchemeList();
            List<String> bgControlSchemeOrgID = bgc.getDistOrgUnits();
            String bgCSid = null;
            HashSet<String> bgCSidSet = new HashSet<String>();
            pool = null;
            tableNameA = null;
            tableNameB = null;
            try {
                conn = this.getConnection(ctx);
                StringBuffer sql = new StringBuffer();
                sql.append("create table tempa(bgCSRootid varchar(44))");
                pool = TempTablePool.getInstance((Context)ctx);
                tableNameA = pool.createTempTable(sql.toString());
                BgDBUtils.insertKey((Connection)conn, (String)(" insert into " + tableNameA + " (bgCSRootid) values (?)"), (Collection)bgControlSchemeRootID);
                sql.setLength(0);
                sql.append("create table tempb(bgCSOrgid varchar(44))");
                tableNameB = pool.createTempTable(sql.toString());
                BgDBUtils.insertKey((Connection)conn, (String)(" insert into " + tableNameB + " (bgCSOrgid) values (?)"), bgControlSchemeOrgID);
                sql.setLength(0);
                sql.append("select fid from T_MBG_BgControlScheme where frootid in (select bgCSRootid from " + tableNameA + ") and forgunitid in (select bgCSOrgid from " + tableNameB + ")");
                rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString());
                while (rst.next()) {
                    bgCSid = rst.getString("fid");
                    bgCSidSet.add(bgCSid);
                }
                if (bgCSidSet != null && !bgCSidSet.isEmpty()) {
                    for (String s : bgCSidSet) {
                        str.append("'").append(s).append("'").append(" or fparentid = ");
                    }
                    str = str.delete(str.length() - 16, str.length());
                    sql.setLength(0);
                    sql.append("select fid, fparentid, forgunitid from T_MBG_BgControlScheme where fparentid = ").append(str);
                    try {
                        rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString());
                        while (rst.next()) {
                            childId = rst.getString("fid");
                            parentId = rst.getString("fparentid");
                            childIds.add(childId);
                            deleteSetParentIds.add(parentId);
                            childMap.put(childId, parentId);
                            if (parentAndChildMap.containsKey(parentId)) {
                                newSet = (Set)parentAndChildMap.get(parentId);
                                parentAndChildMap.put(parentId, newSet);
                            } else {
                                newSet = new HashSet();
                                parentAndChildMap.put(parentId, newSet);
                            }
                            newSet.add(childId);
                        }
                    }
                    catch (SQLException e) {
                        logger.error((Object)"selectData error:", (Throwable)e);
                        throw new BOSException((Throwable)e);
                    }
                    finally {
                        SQLUtils.cleanup((ResultSet)rst);
                    }
                }
                if (parentAndChildMap != null && !parentAndChildMap.isEmpty()) {
                    this.method(deleteSetParentIds, parentAndChildMap, bgCSidSet, bgCheckSet);
                }
                if (bgCSidSet != null && !bgCSidSet.isEmpty()) {
                    int index = 0;
                    ObjectUuidPK[] fids = new ObjectUuidPK[bgCSidSet.size()];
                    EntityViewInfo view = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(bgControlSchemeRootID), CompareType.INCLUDE));
                    view.setFilter(filter);
                    BgControlSchemeCollection coll = BgControlSchemeFactory.getLocalInstance(ctx).getBgControlSchemeCollection(view);
                    for (String bid : bgCSidSet) {
                        fids[index++] = new ObjectUuidPK(BOSUuid.read((String)bid));
                    }
                    this._delete(ctx, (IObjectPK[])fids);
                    this.addLog(ctx, (IObjectCollection)coll, "mbg_control_scheme_antidistribution");
                }
                if (bgCheckSet != null && !bgCheckSet.isEmpty()) {
                    str.setLength(0);
                    sql.setLength(0);
                    for (String b : bgCheckSet) {
                        str.append("'").append(b).append("'").append(" or fparentid = ");
                    }
                    str = str.delete(str.length() - 16, str.length());
                    sql.append("select fid, fparentid,forgunitid,fnumber from T_MBG_BgControlScheme where fid <> fparentid and fparentid = ").append(str);
                    try {
                        rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString());
                        while (rst.next()) {
                            checkid = rst.getString("fid");
                            checkOrgunitid = rst.getString("forgunitid");
                            checkNumber = rst.getString("fnumber");
                            checkOrgunitidSet.add(checkOrgunitid);
                            checkidMap.put(checkOrgunitid, checkid);
                            checkNumMap.put(checkid, checkNumber);
                        }
                    }
                    catch (SQLException e) {
                        logger.error((Object)"selectData error:", (Throwable)e);
                        throw new BOSException((Throwable)e);
                    }
                    finally {
                        SQLUtils.cleanup((ResultSet)rst);
                    }
                }
                if (checkOrgunitidSet != null && !checkOrgunitidSet.isEmpty()) {
                    str.setLength(0);
                    sql.setLength(0);
                    for (String f : checkOrgunitidSet) {
                        str.append("'").append(f).append("'").append(" or fid = ");
                    }
                    str = str.delete(str.length() - 10, str.length());
                    sql.append("select fid, fname_l2 from T_ORG_BaseUnit where fid = ").append(str);
                    try {
                        rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString());
                        while (rst.next()) {
                            checkOrgunitFid = rst.getString("fid");
                            checkOrgunitFname = rst.getString("fname_l2");
                            checkOrgMap.put(checkOrgunitFid, checkOrgunitFname);
                        }
                    }
                    catch (SQLException e) {
                        logger.error((Object)"selectData error:", (Throwable)e);
                        throw new BOSException((Throwable)e);
                    }
                    finally {
                        SQLUtils.cleanup((ResultSet)rst, null, (Connection)conn);
                    }
                }
                if (checkNumMap == null || checkNumMap.isEmpty() || checkOrgMap == null || checkOrgMap.isEmpty()) break block51;
                str.setLength(0);
                for (String f : checkOrgunitidSet) {
                    str.append((String)checkNumMap.get(checkidMap.get(f))).append(",");
                    strMsg.append((String)checkOrgMap.get(f)).append(",");
                }
                mp[0] = str.delete(str.length() - 1, str.length()).toString();
                mp[1] = strMsg.delete(strMsg.length() - 1, strMsg.length()).toString();
                reason = ResourceBase.getString((String)"com.kingdee.eas.ma.control.BgControlSchemeImportResource", (String)"NotAntiDistributeTheNextHas", (Locale)ctx.getLocale(), (Object[])mp);
                msg.append(reason).append("\n");
            }
            catch (Exception e) {
                try {
                    logger.error((Object)"antiDistribute error:", (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst, null, (Connection)conn);
                    if (tableNameA != null) {
                        try {
                            pool.releaseTable(tableNameA);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (tableNameB != null) {
                        try {
                            pool.releaseTable(tableNameB);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rst, null, (Connection)conn);
        if (tableNameA != null) {
            try {
                pool.releaseTable(tableNameA);
            }
            catch (Exception sql) {
                // empty catch block
            }
        }
        if (tableNameB != null) {
            try {
                pool.releaseTable(tableNameB);
            }
            catch (Exception sql) {}
        }
        return msg.toString();
    }

    private void printLog(Context ctx, DataBaseInfo info, String logItem) {
        String logName = info.getNumber() + " " + info.getName();
        IObjectPK tempPK = LogUtil.beginLog((Context)ctx, (String)"updateInfo", (BOSObjectType)new BgControlSchemeInfo().getBOSType(), null, (String)logName, (String)logItem);
        LogUtil.afterLog((Context)ctx, (IObjectPK)tempPK);
    }

    private void addLog(Context ctx, IObjectCollection colls, String logItem) {
        if (colls == null || colls.isEmpty()) {
            return;
        }
        DataBaseInfo info = null;
        int in = colls.size();
        for (int i = 0; i < in; ++i) {
            info = (DataBaseInfo)colls.getObject(i);
            this.printLog(ctx, info, logItem);
        }
    }

    protected void method(Set<String> deleteSetParentIds, Map<String, Set<String>> parentAndChildMap, Set<String> bgCSidSet, Set<String> bgCheckSet) throws BOSException {
        if (deleteSetParentIds != null && !deleteSetParentIds.isEmpty()) {
            try {
                for (String s : deleteSetParentIds) {
                    boolean b = this.findChildId(s, parentAndChildMap, bgCSidSet, bgCheckSet);
                    if (!b) continue;
                    bgCSidSet.remove(s);
                    bgCheckSet.add(s);
                }
            }
            catch (Exception e) {
                logger.error((Object)"selectData error:", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        }
    }

    protected boolean findChildId(String bgControlId, Map<String, Set<String>> parentAndChildMap, Set<String> bgCSidSet, Set<String> bgCheckSet) throws Exception {
        if (bgControlId == null) {
            return false;
        }
        if (parentAndChildMap.containsKey(bgControlId)) {
            Set<String> childIdSet = parentAndChildMap.get(bgControlId);
            for (String childId : childIdSet) {
                boolean re;
                if (!bgCSidSet.contains(childId)) {
                    return true;
                }
                if (parentAndChildMap.get(childId) == null || parentAndChildMap.get(childId).isEmpty() || !(re = this.findChildId(childId, parentAndChildMap, bgCSidSet, bgCheckSet))) continue;
                return re;
            }
        }
        return false;
    }

    @Override
    protected String _clone(Context ctx, IObjectPK bgControlSchemeID) throws BOSException, EASBizException {
        BgControlSchemeInfo info = (BgControlSchemeInfo)this._getValue(ctx, bgControlSchemeID);
        BgControlSchemeInfo cloneInfo = info.deepClone();
        if (ContextUtil.getCurrentUserInfo((Context)ctx) != null) {
            cloneInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        }
        cloneInfo.setNumber("clone_" + cloneInfo.getNumber());
        cloneInfo.setName(ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgSchemeResource", (String)"clone", (Locale)ctx.getLocale()) + "_" + cloneInfo.getName());
        cloneInfo.setIsValid(false);
        if (cloneInfo.getNumber().length() > 80) {
            throw new BgTemplateException(BgTemplateException.NUMBERTOOLONG);
        }
        if (cloneInfo.getName().length() > 80) {
            throw new BgTemplateException(BgTemplateException.NAMETOOLONG);
        }
        this._checkNumberDup(ctx, (IObjectValue)cloneInfo);
        super._save(ctx, (IObjectValue)cloneInfo);
        return cloneInfo.getId().toString();
    }

    protected void _cancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        if (pk == null) {
            return;
        }
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(pk.toString());
        BgControlSchemeFacadeFactory.getLocalInstance(ctx).batchDisable(ids);
    }

    protected void _cancelCancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        if (pk == null) {
            return;
        }
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(pk.toString());
        BgControlSchemeFacadeFactory.getLocalInstance(ctx).batchStartup(ids);
    }
}

