/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.control.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.CanNotDeleteException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.BgParamNHelper;
import com.kingdee.eas.ma.base.utils.CalendarHelper;
import com.kingdee.eas.ma.control.BgControlException;
import com.kingdee.eas.ma.control.BgControlSetSchemeExceptioin;
import com.kingdee.eas.ma.control.BgControlSetSchemeFactory;
import com.kingdee.eas.ma.control.BgControlSetSchemeInfo;
import com.kingdee.eas.ma.control.BgControlSettingCollection;
import com.kingdee.eas.ma.control.BgControlSettingFactory;
import com.kingdee.eas.ma.control.BgControlSettingInfo;
import com.kingdee.eas.ma.control.BgCtrlPeriodTypeEnum;
import com.kingdee.eas.ma.control.BgCtrlSetRuleEnum;
import com.kingdee.eas.ma.control.BgCtrlTypeEnum;
import com.kingdee.eas.ma.control.app.AbstractBgControlSetSchemeControllerBean;
import com.kingdee.eas.ma.control.utils.BgControlSetUtils;
import com.kingdee.eas.ma.control.utils.BgControlSettingUtils;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.cube.BgCubeUtils;
import com.kingdee.eas.ma.mbg.cube.utils.MbgDataHelper;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgControlSetSchemeControllerBean
extends AbstractBgControlSetSchemeControllerBean {
    private static final long serialVersionUID = -2074593325068877760L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.control.app.BgControlSetSchemeControllerBean");
    private final int disOrgUnit = 0;
    private final int disNumbers = 1;
    private final int disData = 2;
    private final int detailData = 3;

    protected FilterInfo getFilterForDefaultCU(Context ctx, IObjectValue model) {
        return null;
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkDate(ctx, model);
        return super._addnew(ctx, model);
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.checkDate(ctx, model);
        this._checkNumberDup(ctx, model);
        super._update(ctx, pk, model);
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkNumberDupInBgScheme(ctx, model);
    }

    protected void checkNumberDupInBgScheme(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        BgControlSetSchemeInfo info = (BgControlSetSchemeInfo)model;
        String bgSchemeId = info.getBgScheme().getId().toString();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)info.getNumber(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)bgSchemeId, CompareType.EQUALS));
        if (info.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
        }
        if (super._exists(ctx, filter)) {
            throw new BgControlSetSchemeExceptioin(BgControlSetSchemeExceptioin.NUMBERDUPINBGSCHEME);
        }
    }

    private void checkDate(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (model instanceof BgControlSetSchemeInfo) {
            BgControlSetSchemeInfo info = (BgControlSetSchemeInfo)model;
            if (info.getBeginTime().compareTo(info.getEndTime()) > 0) {
                throw new BgControlSetSchemeExceptioin(BgControlSetSchemeExceptioin.CHECKDATE);
            }
            String id = info.getId() == null ? "000000000000000000000000000=" : info.getId().toString();
            String bgSchemeId = info.getBgScheme().getId().toString();
            int fiscalYear = info.getFiscalYear().getValue();
            Connection conn = null;
            PreparedStatement pstmt = null;
            ResultSet rst = null;
            try {
                conn = this.getConnection(ctx);
                BgSchemeInfo bgSchemeInfo = BgSchemeFactory.getLocalInstance((Context)ctx).getBgSchemeInfo("select id, dateFrom,dateTo where id = '" + bgSchemeId + "'");
                java.util.Date dataFrom = bgSchemeInfo.getDateFrom();
                java.util.Date dataTo = bgSchemeInfo.getDateTo();
                java.util.Date begin = info.getBeginTime();
                java.util.Date end = info.getEndTime();
                if (!(begin.getTime() - dataFrom.getTime() <= 0L && end.getTime() - dataFrom.getTime() >= 0L || begin.getTime() - dataFrom.getTime() >= 0L && end.getTime() - dataTo.getTime() <= 0L || begin.getTime() - dataTo.getTime() <= 0L && end.getTime() - dataTo.getTime() >= 0L)) {
                    throw new BgControlSetSchemeExceptioin(BgControlSetSchemeExceptioin.CHECKBGSCHEME);
                }
                pstmt = conn.prepareStatement("Select Top 1 FID From T_MBG_BgControlSetScheme Where FID <> ? AND ((FBeginTime >= ? AND FBeginTime <= ?) OR (FEndTime >= ? AND FEndTime <= ?) OR (FBeginTime <= ? AND FEndTime >= ?)) AND FiscalYear = " + fiscalYear + "AND FSCHEMEID = '" + bgSchemeId + "'");
                pstmt.setString(1, id);
                pstmt.setDate(2, new Date(info.getBeginTime().getTime()));
                pstmt.setDate(3, new Date(info.getEndTime().getTime()));
                pstmt.setDate(4, new Date(info.getBeginTime().getTime()));
                pstmt.setDate(5, new Date(info.getEndTime().getTime()));
                pstmt.setDate(6, new Date(info.getBeginTime().getTime()));
                pstmt.setDate(7, new Date(info.getEndTime().getTime()));
                rst = pstmt.executeQuery();
                if (rst.next()) {
                    throw new BgControlSetSchemeExceptioin(BgControlSetSchemeExceptioin.CHECKDATECROSS);
                }
            }
            catch (SQLException e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
            CalendarHelper helper = new CalendarHelper();
            info.setBeginDate(helper.getCurrentlyYear(info.getBeginTime()));
            info.setEndDate(helper.getCurrentlyYear(info.getEndTime()));
        }
    }

    protected void _canDelete(Context ctx, IObjectPK pk, Connection cn) throws CanNotDeleteException {
        if (pk != null) {
            try {
                if (this.checkHasSetting(ctx, pk.toString())) {
                    throw new CanNotDeleteException(new BgControlSetSchemeExceptioin(BgControlSetSchemeExceptioin.CHECKHASSETTING).getMessage());
                }
            }
            catch (CanNotDeleteException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CanNotDeleteException((Throwable)e);
            }
        }
    }

    @Override
    protected boolean _checkHasSetting(Context ctx, BOSUuid schemeId) throws BOSException, EASBizException {
        if (schemeId == null) {
            return false;
        }
        return this.checkHasSetting(ctx, schemeId.toString());
    }

    private boolean checkHasSetting(Context ctx, String schemeId) throws BOSException, EASBizException {
        IRowSet rst = null;
        try {
            rst = DbUtil.executeQuery((Context)ctx, (String)"Select Top 1 FId From T_MBG_BgControlSetting Where FSchemeId = ?", (Object[])new Object[]{schemeId});
            return rst.next();
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected Set _deleteSetting(Context ctx, String setSchemeId, Set ids) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)setSchemeId) || ids == null || ids.size() == 0) {
            return null;
        }
        Set cantDel = new HashSet();
        if (!BgParamNHelper.isUpdateCtrlSetting((Context)ctx)) {
            ArrayList<String> setIds = new ArrayList<String>();
            setIds.addAll(ids);
            BgControlSetUtils.checkHasChange(ctx, setSchemeId, setIds);
        }
        cantDel = this._checkIsDistributed(ctx, ids);
        ArrayList<String> id = new ArrayList<String>();
        for (String idStr : ids) {
            if (cantDel.contains(idStr)) continue;
            id.add(idStr);
        }
        Connection conn = null;
        String sql = "DELETE FROM T_MBG_BgControlSetting WHERE FID=?";
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            MbgSqlHelper.executeBatch((Connection)conn, (String)sql, id);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        BgControlSetUtils.addLog(ctx, BgControlSetUtils.mbg_control_setting_delete);
        return cantDel;
    }

    @Override
    protected Object _batchSet(Context ctx, Object parameter) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected Object _distribute(Context ctx, Object parameter) throws BOSException, EASBizException {
        ArrayList<String> result = new ArrayList<String>();
        if (!(parameter instanceof Map)) {
            return result;
        }
        Map _parameter = (Map)parameter;
        BgControlSetSchemeInfo ctrlSchema = (BgControlSetSchemeInfo)_parameter.get("schemeInfo");
        String currOrg = (String)_parameter.get("rootOrgId");
        List distOrgUnits = (List)_parameter.get("distributeOrg");
        Set numbers = (Set)_parameter.get("numbers");
        if (currOrg == null || numbers == null || distOrgUnits == null || numbers.isEmpty() || distOrgUnits.isEmpty()) {
            return result;
        }
        List<BgControlSettingInfo> settings = null;
        String[] tmpTables = new String[4];
        Connection conn = null;
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        try {
            conn = this.getConnection(ctx);
            settings = this.queryControlSetting(pool, conn, ctrlSchema.getId().toString(), currOrg, distOrgUnits, numbers, tmpTables);
            if (settings != null) {
                String[] checkControlRecord = new HashSet();
                boolean isAllowChangeHasActualData = false;
                isAllowChangeHasActualData = BgParamNHelper.isUpdateCtrlSetting((Context)ctx);
                if (!isAllowChangeHasActualData) {
                    checkControlRecord.addAll(this.checkControlRecord(ctx, pool, conn, ctrlSchema, settings, tmpTables));
                }
                result.addAll((Collection<String>)checkControlRecord);
                result.addAll(this.checkMbgDimControlSetting(ctx, pool, conn, ctrlSchema, settings, tmpTables));
                result.addAll(BgControlSettingUtils.checkDistributeSetGroupNo(ctx, conn, settings, distOrgUnits, ctrlSchema));
                result.addAll(this.checkSubControlSetting(ctx, pool, conn, ctrlSchema, settings, tmpTables));
                this.distribute(ctx, pool, conn, ctrlSchema, tmpTables, currOrg, distOrgUnits);
            }
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            if (pool != null) {
                for (String tmpTable : tmpTables) {
                    if (StringUtils.isEmpty((String)tmpTable)) continue;
                    try {
                        pool.releaseDBSystemTempTable(tmpTable, conn);
                    }
                    catch (Exception exception) {}
                }
            }
            SQLUtils.cleanup((Connection)conn);
        }
        BgControlSetUtils.addLog(ctx, BgControlSetUtils.mbg_control_setting_distribute);
        return result;
    }

    @Override
    protected Object _antiDistribute(Context ctx, Object parameter) throws BOSException, EASBizException {
        ArrayList result = new ArrayList();
        if (!(parameter instanceof Map)) {
            return result;
        }
        Map _parameter = (Map)parameter;
        BgControlSetSchemeInfo ctrlSchema = (BgControlSetSchemeInfo)_parameter.get("schemeInfo");
        String currOrg = (String)_parameter.get("rootOrgId");
        List distOrgUnits = (List)_parameter.get("distributeOrg");
        List antiDisOrg = (List)_parameter.get("distributeOrg");
        Set numbers = (Set)_parameter.get("numbers");
        if (currOrg == null || numbers == null || distOrgUnits == null || numbers.isEmpty() || distOrgUnits.isEmpty()) {
            return result;
        }
        List<BgControlSettingInfo> settings = null;
        String[] tmpTables = new String[4];
        Connection conn = null;
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        try {
            conn = this.getConnection(ctx);
            settings = this.queryControlSetting(pool, conn, ctrlSchema.getId().toString(), currOrg, distOrgUnits, numbers, tmpTables);
            if (settings != null) {
                String[] checkControlRecord = new HashSet();
                if (!BgParamNHelper.isUpdateCtrlSetting((Context)ctx)) {
                    checkControlRecord.addAll(this.checkControlRecord(ctx, pool, conn, ctrlSchema, settings, tmpTables));
                }
                result.addAll(checkControlRecord);
                BgDBUtils.executeUpdate((Connection)conn, (String)("Delete From T_MBG_BgControlSetting Where fRootid in (select fRootid from " + tmpTables[3] + ") AND FOrgUnitId in " + this.getAppendStrByColls(antiDisOrg)));
            }
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            if (pool != null) {
                for (String tmpTable : tmpTables) {
                    if (StringUtils.isEmpty((String)tmpTable)) continue;
                    try {
                        pool.releaseDBSystemTempTable(tmpTable, conn);
                    }
                    catch (Exception exception) {}
                }
            }
            SQLUtils.cleanup((Connection)conn);
        }
        BgControlSetUtils.addLog(ctx, BgControlSetUtils.mbg_control_setting_antiDistribute);
        return result;
    }

    private String getAppendStrByColls(Collection<String> userGroupIds) {
        if (userGroupIds == null || userGroupIds.isEmpty()) {
            return null;
        }
        StringBuffer selectGroupStr = new StringBuffer();
        selectGroupStr.append("(");
        Iterator<String> it = userGroupIds.iterator();
        while (it.hasNext()) {
            selectGroupStr.append("'").append(it.next()).append("',");
        }
        selectGroupStr.delete(selectGroupStr.length() - 1, selectGroupStr.length()).append(")");
        return selectGroupStr.toString();
    }

    protected List<BgControlSettingInfo> queryControlSetting(TempTablePool pool, Connection conn, String schemaId, String orgUnitId, List<String> distOrgUnits, Set<String> numbers, String[] tmpTables) throws Exception {
        ArrayList<BgControlSettingInfo> settings = new ArrayList<BgControlSettingInfo>();
        if (pool == null || conn == null || StringUtils.isEmpty((String)schemaId) || StringUtils.isEmpty((String)orgUnitId) || tmpTables == null) {
            return settings;
        }
        BgControlSettingInfo setting = null;
        ArrayList<Object[]> sqlParams = new ArrayList<Object[]>();
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            tmpTables[0] = pool.createDBSystemTempTable("CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))", conn);
            BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpTables[0] + " (FID) values (?)"), distOrgUnits);
            tmpTables[1] = pool.createDBSystemTempTable("CREATE TABLE TEML_KSQL_0 (FNumber NVARCHAR(80))", conn);
            BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpTables[1] + " (FNumber) values (?)"), numbers);
            pstmt = conn.prepareStatement("select FID, FBgIndexNumber, FBgIndexName, FBgDimNumber, FBgDimName, FBgScenNumber, FCtrlType, FIsAllowAccess, FPeriodType, FFlexParam, FIsUpdate, FRootId, FIsGroupCtrl, FGroupNo, FCtrlSetRule from T_MBG_BgControlSetting where FSchemeId = ? and FOrgUnitID = ? and exists (select * from " + tmpTables[1] + " where FNumber = T_MBG_BgControlSetting.FBgIndexNumber)");
            pstmt.setString(1, schemaId);
            pstmt.setString(2, orgUnitId);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                setting = new BgControlSettingInfo();
                setting.setId(BOSUuid.read((String)rst.getString("FID")));
                setting.setBgIndexNumber(rst.getString("FBgIndexNumber"));
                setting.setBgIndexName(rst.getString("FBgIndexName"));
                setting.setBgDimNumber(rst.getString("FBgDimNumber"));
                setting.setBgDimName(rst.getString("FBgDimName"));
                setting.setBgScenNumber(rst.getString("FBgScenNumber"));
                setting.setCtrlType(BgCtrlTypeEnum.getEnum(rst.getInt("FCtrlType")));
                setting.setPeriodType(BgCtrlPeriodTypeEnum.getEnum(rst.getInt("FPeriodType")));
                setting.setIsAllowAccess(rst.getBoolean("FIsAllowAccess"));
                setting.setFlexParam(rst.getBigDecimal("FFlexParam"));
                setting.setRootId(rst.getString("FRootId"));
                setting.setIsGroupCtrl(rst.getBoolean("FIsGroupCtrl"));
                setting.setGroupNo(rst.getString("FGroupNo"));
                setting.setCtrlSetRule(BgCtrlSetRuleEnum.getEnum(rst.getInt("FCtrlSetRule")));
                settings.add(setting);
                sqlParams.add(new Object[]{setting.getBgIndexNumber(), setting.getBgDimNumber(), setting.getBgScenNumber(), setting.getRootId()});
            }
            SQLUtils.cleanup((ResultSet)rst);
            tmpTables[2] = pool.createDBSystemTempTable("CREATE TABLE TEML_KSQL_0 (FBgIndexNumber NVARCHAR(80), FBgDimNumber NVARCHAR(300), FBgScenNumber NVARCHAR(80), FRootId VARCHAR(44))", conn);
            BgDBUtils.insertValue1((Connection)conn, (String)("Insert Into " + tmpTables[2] + " (FBgIndexNumber, FBgDimNumber, FBgScenNumber, FRootId) values (?,?,?,?)"), sqlParams);
            tmpTables[3] = pool.createDBSystemTempTable("Create Table TEML_KSQL_1 (FID VARCHAR(44), FCreatorID VARCHAR(44), FCreateTime DateTime, FLastUpdateUserID VARCHAR(44), FLastUpdateTime DateTime, FControlUnitID VARCHAR(44), FOrgUnitID VARCHAR(44), FBgIndexNumber NVARCHAR(80), FBgIndexName NVARCHAR(300), FBgDimNumber NVARCHAR(300), FBgDimName NVARCHAR(300), FBgScenNumber NVARCHAR(80), FCtrlType INT, FIsAllowAccess INT, FPeriodType INT, FFlexParam NUMERIC(21,8), FIsGroupCtrl INT, FGroupNo VARCHAR(80), FCtrlSetRule INT, FIsUpdate INT, FRootId VARCHAR(44), FBgScenarioId VARCHAR(44))", conn);
            pool.createDBSystemTempTableIndex(tmpTables[3], "FID", true, false, conn);
            pool.createDBSystemTempTableIndex(tmpTables[3], "FOrgUnitID", false, false, conn);
            pool.createDBSystemTempTableIndex(tmpTables[3], "FBgIndexNumber", false, false, conn);
            BgDBUtils.executeUpdate((Connection)conn, (String)("Insert Into " + tmpTables[3] + " (FID, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FControlUnitID, FOrgUnitID, FBgIndexNumber, FBgIndexName, FBgDimNumber, FBgDimName, FBgScenNumber, FCtrlType, FIsAllowAccess, FPeriodType, FFlexParam, FIsUpdate, FRootId, FIsGroupCtrl, FGroupNo, FCtrlSetRule, FBgScenarioId) Select FID, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FControlUnitID, FOrgUnitID, FBgIndexNumber, FBgIndexName, FBgDimNumber, FBgDimName, FBgScenNumber, FCtrlType, FIsAllowAccess, FPeriodType, FFlexParam, FIsUpdate, FRootId, FIsGroupCtrl, FGroupNo, FCtrlSetRule, FBgScenarioId from T_MBG_BgControlSetting where FSchemeId = ? and FOrgUnitID = ? and exists (select * from " + tmpTables[1] + " where FNumber = T_MBG_BgControlSetting.FBgIndexNumber)"), (Object[])new Object[]{schemaId, orgUnitId});
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"queryControlSetting sql error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        return settings;
    }

    @Override
    protected Map _queryDispatchInfo(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        return this._queryDispatchInfo(ctx, id, null);
    }

    @Override
    public Map _queryDispatchInfo(Context ctx, BOSUuid id, String rootId) throws BOSException, EASBizException {
        if (id == null) {
            return null;
        }
        HashMap map = new HashMap();
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        Connection conn = null;
        String bgtemControlSetrootID = null;
        String orgUnitIdStr = null;
        Set<String> orgUnitIds = null;
        try {
            conn = this.getConnection(ctx);
            String sql = "SELECT FROOTID ,FORGUNITID FROM T_MBG_BgControlSetting where FSCHEMEID =? and FID <> FROOTID";
            String filter = rootId == null ? "" : " and FROOTID = ? ";
            pstmt = conn.prepareStatement(sql + filter);
            pstmt.setString(1, id.toString());
            if (rootId != null) {
                pstmt.setString(2, rootId);
            }
            rst = pstmt.executeQuery();
            while (rst.next()) {
                bgtemControlSetrootID = rst.getString("FROOTID");
                orgUnitIdStr = rst.getString("FORGUNITID");
                if (map.containsKey(bgtemControlSetrootID)) {
                    orgUnitIds = (Set)map.get(bgtemControlSetrootID);
                } else {
                    orgUnitIds = new HashSet();
                    map.put(bgtemControlSetrootID, orgUnitIds);
                }
                orgUnitIds.add(orgUnitIdStr);
            }
            SQLUtils.cleanup((ResultSet)rst);
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"queryDispatchInfo Sql Error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, null, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, null, (Connection)conn);
        return map;
    }

    protected List<String> checkControlRecord(Context ctx, TempTablePool pool, Connection conn, BgControlSetSchemeInfo ctrlSchema, List<BgControlSettingInfo> settings, String[] tmpTables) throws Exception {
        ArrayList<String> result = new ArrayList<String>();
        if (ctx == null || pool == null || conn == null || ctrlSchema == null || settings == null || settings.isEmpty() || tmpTables == null) {
            return result;
        }
        this.checkBgScheme(ctx, conn, ctrlSchema);
        MessageFormat mf = null;
        String msgDetail = null;
        String ctrlCube = BgCubeUtils.getControlCubeName((String)ctrlSchema.getBgScheme().getRefCube());
        String bgIndexName = null;
        String bgIndexNum = null;
        String bgDimName = null;
        String bgDimNum = null;
        String bgScenName = null;
        String bgScenNum = null;
        String bgOrgName = null;
        String nullStr = EASCommonResource.getString((String)"com.kingdee.eas.ma.control.BgControlMsgResource", (String)"null", (Locale)ctx.getLocale());
        PreparedStatement pstmt = null;
        PreparedStatement pstmtExist = null;
        ResultSet rst = null;
        ResultSet rstExist = null;
        try {
            pstmt = conn.prepareStatement("select t.FID, t.FBgIndexNumber, t.FBgIndexName, t.FBgDimNumber, t.FBgDimName, t.FBgScenNumber,t.FBgDimName,b.FNAME_" + ctx.getLocale() + " AS FBgOrgName,sc.FName_" + ctx.getLocale() + " AS FBgScenName  from T_MBG_BgControlSetting t LEFT JOIN T_ORG_BASEUNIT b on t.FOrgUnitId = b.FID left join T_MBG_BgScenario sc on t.FBgScenNumber = sc.FNumber  where t.FSchemeId = ?  and exists (select * from " + tmpTables[0] + " where FID = t.FOrgUnitID)  and exists (select * from " + tmpTables[1] + " where FNumber = t.FBgIndexNumber)  and exists (select FBgSettingId from " + ctrlCube + " where FBgSettingId = t.FID)");
            pstmt.setString(1, ctrlSchema.getId().toString());
            rst = pstmt.executeQuery();
            while (rst.next()) {
                bgIndexName = rst.getString("FBgIndexName");
                bgDimName = rst.getString("FBgDimName") != null ? rst.getString("FBgDimName") : nullStr;
                bgScenName = rst.getString("FBgScenName") != null ? rst.getString("FBgScenName") : nullStr;
                bgOrgName = rst.getString("FBgOrgName");
                bgIndexNum = rst.getString("FBgIndexNumber");
                bgDimNum = rst.getString("FBgDimNumber");
                bgScenNum = rst.getString("FBgScenNumber");
                String FBgDimNumber = bgDimNum == null ? "is null" : "='" + bgDimNum + "'";
                String FBgScenNumber = bgScenNum == null ? "is null" : "='" + bgScenNum + "'";
                pstmtExist = conn.prepareStatement("select FBgIndexName from " + tmpTables[3] + " where FBgIndexName = ? and FBgDimNumber " + FBgDimNumber + " and FBgScenNumber " + FBgScenNumber + "");
                pstmtExist.setString(1, bgIndexName);
                rstExist = pstmtExist.executeQuery();
                if (!rstExist.next()) continue;
                mf = new MessageFormat(EASCommonResource.getString((String)"com.kingdee.eas.ma.control.BgControlMsgResource", (String)"bgControlSettingIsUsed", (Locale)ctx.getLocale()));
                msgDetail = mf.format(new Object[]{bgOrgName, bgIndexName, bgDimName, bgScenName});
                if (!result.contains(msgDetail)) {
                    result.add(msgDetail);
                }
                BgDBUtils.executeUpdate((Connection)conn, (String)("delete from " + tmpTables[3] + " where FBgIndexName = ? and FBgDimNumber " + FBgDimNumber + " and FBgScenNumber " + FBgScenNumber + ""), (Object[])new Object[]{bgIndexName});
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"queryControlSetting sql error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt);
                SQLUtils.cleanup(rstExist, pstmtExist);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        SQLUtils.cleanup(rstExist, pstmtExist);
        return result;
    }

    private void checkBgScheme(Context ctx, Connection conn, BgControlSetSchemeInfo ctrlSchema) throws EASBizException {
        if (ctx == null || conn == null || ctrlSchema == null) {
            return;
        }
        if (ctrlSchema.getBgScheme() == null || ctrlSchema.getBgScheme().getRefCube() == null) {
            BgSchemeInfo schemeInfo = MbgDataHelper.getBgSchemeByCtrlSchema((Connection)conn, (Locale)ctx.getLocale(), (BOSUuid)ctrlSchema.getId());
            ctrlSchema.setBgScheme(schemeInfo);
        }
    }

    protected List<String> checkSubControlSetting(Context ctx, TempTablePool pool, Connection conn, BgControlSetSchemeInfo ctrlSchema, List<BgControlSettingInfo> settings, String[] tmpTables) throws EASBizException {
        ResultSet rst;
        PreparedStatement entryPrmt;
        PreparedStatement pstmt;
        ArrayList<String> result;
        block14: {
            result = new ArrayList<String>();
            if (ctx == null || pool == null || conn == null || ctrlSchema == null || settings == null || settings.isEmpty() || tmpTables == null) {
                return result;
            }
            this.checkBgScheme(ctx, conn, ctrlSchema);
            Object mf = null;
            String bgIndexName = null;
            String bgDimName = null;
            String bgScenName = null;
            String bgIndexNum = null;
            String bgDimNum = null;
            String bgScenNum = null;
            String bgOrgName = null;
            String nullStr = EASCommonResource.getString((String)"com.kingdee.eas.ma.control.BgControlMsgResource", (String)"null", (Locale)ctx.getLocale());
            pstmt = null;
            entryPrmt = null;
            rst = null;
            HashMap bgIndexMap = new HashMap();
            Map<String, BgControlSettingInfo> bgDimScMap = null;
            BgControlSettingInfo setting = null;
            String key = null;
            for (BgControlSettingInfo _setting : settings) {
                if (bgIndexMap.containsKey(_setting.getBgIndexNumber())) {
                    bgDimScMap = (Map)bgIndexMap.get(_setting.getBgIndexNumber());
                } else {
                    bgDimScMap = new HashMap();
                    bgIndexMap.put(_setting.getBgIndexNumber(), bgDimScMap);
                }
                key = _setting.getBgIndexNumber() + "_" + _setting.getBgDimNumber() + "_" + _setting.getBgScenNumber();
                bgDimScMap.put(key, _setting);
            }
            HashMap settingIDs = new HashMap();
            try {
                pstmt = conn.prepareStatement("select t.FID, t.FBgIndexNumber, t.FBgIndexName, t.FBgDimNumber, t.FBgDimName,b.FNAME_" + ctx.getLocale() + " AS FBgOrgName, t.FBgScenNumber, sc.FName_" + ctx.getLocale() + " AS FBgScenName  from T_MBG_BgControlSetting t LEFT JOIN T_ORG_BASEUNIT b on t.FOrgUnitId = b.FID left join T_MBG_BgScenario sc on t.FBgScenNumber = sc.FNumber  where t.FSchemeId = ?  and exists (select * from " + tmpTables[0] + " where FID = t.FOrgUnitID)  and exists (select * from " + tmpTables[2] + " where FBgIndexNumber = t.FBgIndexNumber and (FBgScenNumber = t.FBgScenNumber or (FBgScenNumber is null and t.FBgScenNumber is null))and FRootId <> t.FRootId) ");
                pstmt.setString(1, ctrlSchema.getId().toString());
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    bgIndexName = rst.getString("FBgIndexName");
                    bgDimName = rst.getString("FBgDimName") != null ? rst.getString("FBgDimName") : nullStr;
                    bgScenName = rst.getString("FBgScenName") != null ? rst.getString("FBgScenName") : nullStr;
                    bgIndexNum = rst.getString("FBgIndexNumber");
                    bgDimNum = rst.getString("FBgDimNumber");
                    bgScenNum = rst.getString("FBgScenNumber");
                    bgOrgName = rst.getString("FBgOrgName");
                    if (!bgIndexMap.containsKey(bgIndexNum) || !(bgDimScMap = (Map)bgIndexMap.get(bgIndexNum)).containsKey(key = bgIndexNum + "_" + bgDimNum + "_" + bgScenNum) || ((setting = (BgControlSettingInfo)bgDimScMap.get(key)).getBgDimName() != null || rst.getString("FBgDimName") != null) && !setting.getBgDimName().equals(rst.getString("FBgDimName"))) continue;
                    if (settingIDs.containsKey(setting.getId().toString())) {
                        ((Set)settingIDs.get(setting.getId().toString())).add(rst.getString("FID"));
                        continue;
                    }
                    HashSet<String> set = new HashSet<String>();
                    set.add(rst.getString("FID"));
                    settingIDs.put(setting.getId().toString(), set);
                }
                if (settingIDs.size() == 0) break block14;
                ArrayList list = new ArrayList(settingIDs.keySet());
                StringBuffer query = new StringBuffer();
                query.append("select  fid, FRootId from " + tmpTables[3] + " where fid in(");
                for (int i = 1; i < 50; ++i) {
                    query.append("?,");
                }
                query.append("?)");
                List objs = BgDBUtils.executeBatchQuery((Connection)conn, (String)query.toString(), list, (int)50);
                if (objs == null || objs.isEmpty()) break block14;
                int batchIndex = 0;
                StringBuffer sqlEntry = new StringBuffer();
                sqlEntry.append("Update T_MBG_BgControlSetting Set FRootId=? where fid=?");
                entryPrmt = conn.prepareStatement(sqlEntry.toString());
                for (Object[] obj : objs) {
                    String id = (String)obj[0];
                    for (String objects : (Set)settingIDs.get(id)) {
                        entryPrmt.setString(1, (String)obj[1]);
                        entryPrmt.setString(2, objects);
                        entryPrmt.addBatch();
                        if (++batchIndex < 50) continue;
                        entryPrmt.executeBatch();
                        batchIndex = 0;
                    }
                }
                if (batchIndex != 0) {
                    entryPrmt.executeBatch();
                }
            }
            catch (SQLException ex) {
                try {
                    logger.error((Object)"queryControlSetting sql error:", (Throwable)ex);
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(entryPrmt);
                    SQLUtils.cleanup(rst, pstmt);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup(entryPrmt);
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        return result;
    }

    protected List<String> checkMbgDimControlSetting(Context ctx, TempTablePool pool, Connection conn, BgControlSetSchemeInfo ctrlSchema, List<BgControlSettingInfo> settings, String[] tmpTables) throws EASBizException {
        ArrayList<String> result = new ArrayList<String>();
        if (ctx == null || pool == null || conn == null || ctrlSchema == null || settings == null || settings.isEmpty() || tmpTables == null) {
            return result;
        }
        this.checkBgScheme(ctx, conn, ctrlSchema);
        String key = null;
        HashMap settingMap = new HashMap();
        List<BgControlSettingInfo> tmpSettings = null;
        BgControlSettingInfo setting = null;
        HashMap refMbgDim = new HashMap();
        Set<String> refMbgSet = null;
        HashSet<String> tmpSet = new HashSet<String>();
        for (BgControlSettingInfo _setting : settings) {
            key = _setting.getBgIndexNumber() + "_" + _setting.getBgScenNumber();
            if (settingMap.containsKey(key)) {
                tmpSettings = (List)settingMap.get(key);
            } else {
                tmpSettings = new ArrayList();
                settingMap.put(key, tmpSettings);
            }
            tmpSettings.add(_setting);
            if (StringUtils.isEmpty((String)_setting.getBgDimNumber()) || refMbgDim.containsKey(_setting.getBgDimNumber())) continue;
            refMbgSet = new HashSet<String>();
            refMbgDim.put(_setting.getBgDimNumber(), refMbgSet);
            String[] numbers = _setting.getBgDimNumber().split(",");
            if (numbers == null) continue;
            int in = numbers.length;
            for (int i = 0; i < in; ++i) {
                refMbgSet.add(DimUtils.getSrcNumber((String)numbers[i]));
            }
        }
        MessageFormat mf = null;
        String bgIndexNum = null;
        String bgIndexName = null;
        String bgDimNum = null;
        String bgDimName = null;
        String bgScenNum = null;
        String bgScenName = null;
        String bgOrgName = null;
        String nullStr = EASCommonResource.getString((String)"com.kingdee.eas.ma.control.BgControlMsgResource", (String)"null", (Locale)ctx.getLocale());
        HashSet nullSet = new HashSet();
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            pstmt = conn.prepareStatement("select t.FID, t.FBgIndexNumber, t.FBgIndexName, t.FBgDimNumber, t.FBgDimName, t.FBgDimName,b.FNAME_" + ctx.getLocale() + " AS FBgOrgName,t.FBgScenNumber, sc.FName_" + ctx.getLocale() + " AS FBgScenName  from T_MBG_BgControlSetting t LEFT JOIN T_ORG_BASEUNIT b on t.FOrgUnitId = b.FID left join T_MBG_BgScenario sc on t.FBgScenNumber = sc.FNumber  where t.FSchemeId = ?  and exists (select * from " + tmpTables[0] + " where FID = t.FOrgUnitID)  and exists (select * from " + tmpTables[2] + " where FBgIndexNumber = t.FBgIndexNumber and (FBgScenNumber = t.FBgScenNumber or (FBgScenNumber is null and t.FBgScenNumber is null))) ");
            pstmt.setString(1, ctrlSchema.getId().toString());
            rst = pstmt.executeQuery();
            while (rst.next()) {
                bgIndexNum = rst.getString("FBgIndexNumber");
                bgDimNum = rst.getString("FBgDimNumber");
                bgScenNum = rst.getString("FBgScenNumber");
                bgIndexName = rst.getString("FBgIndexName");
                bgDimName = rst.getString("FBgDimName") != null ? rst.getString("FBgDimName") : nullStr;
                bgScenName = rst.getString("FBgScenName") != null ? rst.getString("FBgScenName") : nullStr;
                bgOrgName = rst.getString("FBgOrgName");
                tmpSet.clear();
                if (!StringUtils.isEmpty((String)bgDimNum) && !bgDimNum.equals(String.valueOf(null))) {
                    int i;
                    int in;
                    String[] numbers = bgDimNum.split(",");
                    if (numbers != null) {
                        in = numbers.length;
                        for (i = 0; i < in; ++i) {
                            tmpSet.add(DimUtils.getSrcNumber((String)numbers[i]));
                        }
                    }
                    if (!settingMap.containsKey(key = bgIndexNum + "_" + bgScenNum)) continue;
                    tmpSettings = (List)settingMap.get(key);
                    in = tmpSettings.size();
                    for (i = 0; i < in; ++i) {
                        setting = (BgControlSettingInfo)tmpSettings.get(i);
                        refMbgSet = !StringUtils.isEmpty((String)setting.getBgDimNumber()) && !setting.getBgDimNumber().equals(String.valueOf(null)) ? (Set)refMbgDim.get(setting.getBgDimNumber()) : nullSet;
                        if (refMbgSet.containsAll(tmpSet) && tmpSet.containsAll(refMbgSet)) continue;
                        mf = new MessageFormat(EASCommonResource.getString((String)"com.kingdee.eas.ma.control.BgControlMsgResource", (String)"mbgDimNoEquals", (Locale)ctx.getLocale()));
                        bgDimName = setting.getBgDimName() != null ? setting.getBgDimName() : nullStr;
                        result.add(mf.format(new Object[]{bgOrgName, bgIndexName, bgDimName, bgScenName}));
                        BgDBUtils.executeUpdate((Connection)conn, (String)("delete from " + tmpTables[3] + " where FID = ?"), (Object[])new Object[]{setting.getId().toString()});
                    }
                    continue;
                }
                key = bgIndexNum + "_" + bgScenNum;
                if (!settingMap.containsKey(key)) continue;
                tmpSettings = (List)settingMap.get(key);
                int in = tmpSettings.size();
                for (int i = 0; i < in; ++i) {
                    setting = (BgControlSettingInfo)tmpSettings.get(i);
                    if (StringUtils.isEmpty((String)setting.getBgDimNumber()) || setting.getBgDimNumber().equals(String.valueOf(null))) continue;
                    mf = new MessageFormat(EASCommonResource.getString((String)"com.kingdee.eas.ma.control.BgControlMsgResource", (String)"mbgDimNoEquals", (Locale)ctx.getLocale()));
                    bgDimName = setting.getBgDimName() != null ? setting.getBgDimName() : nullStr;
                    result.add(mf.format(new Object[]{bgOrgName, bgIndexName, bgDimName, bgScenName}));
                    BgDBUtils.executeUpdate((Connection)conn, (String)("delete from " + tmpTables[3] + " where FID = ?"), (Object[])new Object[]{setting.getId().toString()});
                }
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"queryControlSetting sql error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        return result;
    }

    protected void distribute(Context ctx, TempTablePool pool, Connection conn, BgControlSetSchemeInfo ctrlSchema, String[] tmpTables, String currOrg, List<String> distOrgUnits) throws EASBizException {
        if (ctx == null || pool == null || conn == null || ctrlSchema == null || tmpTables == null || currOrg == null || distOrgUnits == null) {
            return;
        }
        String schemaId = ctrlSchema.getId().toString();
        String bosType = new BgControlSettingInfo().getBOSType().toString();
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        Timestamp time = new Timestamp(System.currentTimeMillis());
        try {
            for (String distOrgUnitId : distOrgUnits) {
                BgDBUtils.executeUpdate((Connection)conn, (String)("Insert Into " + tmpTables[3] + " (FID, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FControlUnitID, FOrgUnitID, FBgIndexNumber, FBgIndexName, FBgDimNumber, FBgDimName, FBgScenNumber, FCtrlType, FIsAllowAccess, FPeriodType, FFlexParam, FIsGroupCtrl, FGroupNo, FCtrlSetRule, FIsUpdate, FRootId) select newbosid('" + bosType + "'), ?, ?, ?, ?, FControlUnitID, ?, FBgIndexNumber, FBgIndexName, FBgDimNumber, FBgDimName, FBgScenNumber, FCtrlType, FIsAllowAccess, FPeriodType, FFlexParam, FIsGroupCtrl, FGroupNo, FCtrlSetRule, FIsUpdate, FRootId from " + tmpTables[3] + " where FOrgUnitID = ?"), (Object[])new Object[]{userId, time, userId, time, distOrgUnitId, currOrg});
            }
            BgDBUtils.executeUpdate((Connection)conn, (String)("delete from " + tmpTables[3] + " where FOrgUnitId = ?"), (Object[])new Object[]{currOrg});
            BgDBUtils.executeUpdate((Connection)conn, (String)("update " + tmpTables[3] + " set FID = (select FID from T_MBG_BgControlSetting where FSchemeID = ? and FOrgUnitID = " + tmpTables[3] + ".FOrgUnitID and FRootId = " + tmpTables[3] + ".FRootId and FBgIndexNumber=" + tmpTables[3] + ".FBgIndexNumber and (FBgDimNumber=" + tmpTables[3] + ".FBgDimNumber or (FBgDimNumber is null and " + tmpTables[3] + ".FBgDimNumber is null)) and (FBGSCENNUMBER=" + tmpTables[3] + ".FBGSCENNUMBER or (FBGSCENNUMBER is null and " + tmpTables[3] + ".FBGSCENNUMBER is null))) where exists (select FID from T_MBG_BgControlSetting where FSchemeID = ? and FOrgUnitID = " + tmpTables[3] + ".FOrgUnitID and FRootId = " + tmpTables[3] + ".FRootId and FBgIndexNumber=" + tmpTables[3] + ".FBgIndexNumber and (FBgDimNumber=" + tmpTables[3] + ".FBgDimNumber or (FBgDimNumber is null and " + tmpTables[3] + ".FBgDimNumber is null)) and (FBGSCENNUMBER=" + tmpTables[3] + ".FBGSCENNUMBER or (FBGSCENNUMBER is null and " + tmpTables[3] + ".FBGSCENNUMBER is null))) "), (Object[])new Object[]{schemaId, schemaId});
            BgDBUtils.executeUpdate((Connection)conn, (String)("update T_MBG_BgControlSetting set FBgIndexNumber = (select FBgIndexNumber from " + tmpTables[3] + " where FID = T_MBG_BgControlSetting.FID)  where exists (select FID from " + tmpTables[3] + " where FID = T_MBG_BgControlSetting.FID)"));
            BgDBUtils.executeUpdate((Connection)conn, (String)("update T_MBG_BgControlSetting set FBgIndexName = (select FBgIndexName from " + tmpTables[3] + " where FID = T_MBG_BgControlSetting.FID)  where exists (select FID from " + tmpTables[3] + " where FID = T_MBG_BgControlSetting.FID)"));
            BgDBUtils.executeUpdate((Connection)conn, (String)("update T_MBG_BgControlSetting set FBgDimNumber = (select FBgDimNumber from " + tmpTables[3] + " where FID = T_MBG_BgControlSetting.FID)  where exists (select FID from " + tmpTables[3] + " where FID = T_MBG_BgControlSetting.FID)"));
            BgDBUtils.executeUpdate((Connection)conn, (String)("update T_MBG_BgControlSetting set FBgDimName = (select FBgDimName from " + tmpTables[3] + " where FID = T_MBG_BgControlSetting.FID)  where exists (select FID from " + tmpTables[3] + " where FID = T_MBG_BgControlSetting.FID)"));
            BgDBUtils.executeUpdate((Connection)conn, (String)("update T_MBG_BgControlSetting set FBgScenNumber = (select FBgScenNumber from " + tmpTables[3] + " where FID = T_MBG_BgControlSetting.FID)  where exists (select FID from " + tmpTables[3] + " where FID = T_MBG_BgControlSetting.FID)"));
            BgDBUtils.executeUpdate((Connection)conn, (String)("update T_MBG_BgControlSetting set FCtrlType = (select FCtrlType from " + tmpTables[3] + " where FID = T_MBG_BgControlSetting.FID)  where exists (select FID from " + tmpTables[3] + " where FID = T_MBG_BgControlSetting.FID)"));
            BgDBUtils.executeUpdate((Connection)conn, (String)("update T_MBG_BgControlSetting set FIsAllowAccess = (select FIsAllowAccess from " + tmpTables[3] + " where FID = T_MBG_BgControlSetting.FID)  where exists (select FID from " + tmpTables[3] + " where FID = T_MBG_BgControlSetting.FID)"));
            BgDBUtils.executeUpdate((Connection)conn, (String)("update T_MBG_BgControlSetting set FPeriodType = (select FPeriodType from " + tmpTables[3] + " where FID = T_MBG_BgControlSetting.FID)  where exists (select FID from " + tmpTables[3] + " where FID = T_MBG_BgControlSetting.FID)"));
            BgDBUtils.executeUpdate((Connection)conn, (String)("update T_MBG_BgControlSetting set FFlexParam = (select FFlexParam from " + tmpTables[3] + " where FID = T_MBG_BgControlSetting.FID)  where exists (select FID from " + tmpTables[3] + " where FID = T_MBG_BgControlSetting.FID)"));
            BgDBUtils.executeUpdate((Connection)conn, (String)("update T_MBG_BgControlSetting set FIsGroupCtrl = (select FIsGroupCtrl from " + tmpTables[3] + " where FID = T_MBG_BgControlSetting.FID)  where exists (select FID from " + tmpTables[3] + " where FID = T_MBG_BgControlSetting.FID)"));
            BgDBUtils.executeUpdate((Connection)conn, (String)("update T_MBG_BgControlSetting set FGroupNo = (select FGroupNo from " + tmpTables[3] + " where FID = T_MBG_BgControlSetting.FID)  where exists (select FID from " + tmpTables[3] + " where FID = T_MBG_BgControlSetting.FID)"));
            BgDBUtils.executeUpdate((Connection)conn, (String)("update T_MBG_BgControlSetting set FCtrlSetRule = (select FCtrlSetRule from " + tmpTables[3] + " where FID = T_MBG_BgControlSetting.FID)  where exists (select FID from " + tmpTables[3] + " where FID = T_MBG_BgControlSetting.FID)"));
            BgDBUtils.executeUpdate((Connection)conn, (String)("update T_MBG_BgControlSetting set FIsUpdate = (select FIsUpdate from " + tmpTables[3] + " where FID = T_MBG_BgControlSetting.FID)  where exists (select FID from " + tmpTables[3] + " where FID = T_MBG_BgControlSetting.FID)"));
            BgDBUtils.executeUpdate((Connection)conn, (String)("update T_MBG_BgControlSetting set FRootId = (select FRootId from " + tmpTables[3] + " where FID = T_MBG_BgControlSetting.FID)  where exists (select FID from " + tmpTables[3] + " where FID = T_MBG_BgControlSetting.FID)"));
            BgDBUtils.executeUpdate((Connection)conn, (String)("Insert Into T_MBG_BgControlSetting (FID, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FControlUnitID, FSchemeID, FOrgUnitId, FBgIndexNumber, FBgIndexName, FBgDimNumber, FBgDimName, FBgScenNumber, FCtrlType, FIsAllowAccess, FPeriodType, FFlexParam, FIsGroupCtrl, FGroupNo, FCtrlSetRule, FIsUpdate, FRootId) Select FID, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FControlUnitID, ?, FOrgUnitId, FBgIndexNumber, FBgIndexName, FBgDimNumber, FBgDimName, FBgScenNumber, FCtrlType, FIsAllowAccess, FPeriodType, FFlexParam, FIsGroupCtrl, FGroupNo, FCtrlSetRule, FIsUpdate, FRootId from " + tmpTables[3] + " where not exists (select FID from T_MBG_BgControlSetting where FID = " + tmpTables[3] + ".FID)"), (Object[])new Object[]{schemaId});
        }
        catch (SQLException ex) {
            logger.error((Object)"distribute sql error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<BgSchemeInfo> querySchemeSetting(Context ctx, TempTablePool pool, Connection conn, String setSchemeId) throws EASBizException, BOSException {
        ArrayList<BgSchemeInfo> list = new ArrayList<BgSchemeInfo>();
        if (StringUtils.isEmpty((String)setSchemeId)) {
            return null;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("beginDate");
        sic.add("endDate");
        BgControlSetSchemeInfo setSchemeInfo = BgControlSetSchemeFactory.getLocalInstance(ctx).getBgControlSetSchemeInfo((IObjectPK)new ObjectUuidPK(setSchemeId), sic);
        if (setSchemeInfo == null) {
            return null;
        }
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select FID, FRefCube,FName_" + ctx.getLocale() + " from T_MBG_BgScheme where frefcube is not null and ((Year(FDateFrom) <= ? and Year(FDateTo) >= ?) or (Year(FDateFrom) <= ? and Year(FDateTo) >= ?))");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setInt(1, setSchemeInfo.getBeginDate());
            pstmt.setInt(2, setSchemeInfo.getBeginDate());
            pstmt.setInt(3, setSchemeInfo.getEndDate());
            pstmt.setInt(4, setSchemeInfo.getEndDate());
            rst = pstmt.executeQuery();
            while (rst.next()) {
                BgSchemeInfo bg = new BgSchemeInfo();
                bg.setRefCube(rst.getString("FRefCube"));
                bg.setId(BOSUuid.read((String)rst.getString("FID")));
                bg.setName(rst.getString("FName_" + ctx.getLocale()));
                list.add(bg);
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        }
        catch (SQLDataException ex) {
            try {
                throw new BOSException((Throwable)ex);
                catch (SQLException ex2) {
                    logger.error((Object)"checkIsUse Error:", (Throwable)ex2);
                    throw new BgControlException(BgControlException.DATABASEEXCEPTION, new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return list;
    }

    @Override
    protected Map _getDistributeData(Context ctx, Map parameter) throws BOSException, EASBizException {
        if (parameter == null) {
            return null;
        }
        String orgId = null;
        BgControlSetSchemeInfo info = null;
        String filterItem = null;
        if (parameter.get("orgId") instanceof String) {
            orgId = (String)parameter.get("orgId");
        }
        if (parameter.get("info") instanceof BgControlSetSchemeInfo) {
            info = (BgControlSetSchemeInfo)parameter.get("info");
        }
        if (parameter.get("filterItem") instanceof String) {
            filterItem = (String)parameter.get("filterItem");
        }
        if (StringUtils.isEmpty((String)orgId) || info == null) {
            return null;
        }
        String sql = "SELECT FRootID id, FBgIndexNumber number, FBgIndexName name FROM T_MBG_BgControlSetting WHERE FSchemeID=? AND FOrgUnitID=? GROUP BY FRootID,FBgIndexNumber,FBgIndexName ORDER BY FBgIndexNumber ASC";
        if (StringUtils.isEmpty((String)filterItem)) {
            sql = "SELECT FRootID id, FBgIndexNumber number, FBgIndexName name FROM T_MBG_BgControlSetting WHERE FSchemeID=? AND FOrgUnitID=? GROUP BY FRootID,FBgIndexNumber,FBgIndexName ORDER BY FBgIndexNumber ASC";
        } else {
            filterItem = "%" + filterItem + "%";
            sql = "SELECT FRootID id, FBgIndexNumber number, FBgIndexName name FROM T_MBG_BgControlSetting WHERE FSchemeID=? AND FOrgUnitID=? AND (FBgIndexName LIKE '" + filterItem + "' OR FBgIndexNumber LIKE '" + filterItem + "') GROUP BY FRootID,FBgIndexNumber,FBgIndexName ORDER BY FBgIndexNumber ASC";
        }
        Connection conn = null;
        PreparedStatement pmst = null;
        ResultSet rs = null;
        ArrayList record = new ArrayList();
        HashMap rsMap = new HashMap();
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pmst = conn.prepareStatement(sql);
            pmst.setString(1, info.getId().toString());
            pmst.setString(2, orgId);
            rs = pmst.executeQuery();
            HashMap<String, String> row = null;
            while (rs.next()) {
                row = new HashMap<String, String>();
                row.put("id", rs.getString("id"));
                row.put("number", rs.getString("number"));
                row.put("name", rs.getString("name"));
                record.add(row);
            }
            rsMap.put("data", record);
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pmst, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pmst, (Connection)conn);
        return rsMap;
    }

    @Override
    protected Set _checkIsDistributed(Context ctx, Set ids) throws BOSException, EASBizException {
        if (ids == null || ids.isEmpty()) {
            return ids;
        }
        HashSet<String> cantDel = new HashSet<String>();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("rootId");
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(sic);
        view.setFilter(new FilterInfo());
        view.getFilter().getFilterItems().add(new FilterItemInfo("rootId", (Object)ids, CompareType.INCLUDE));
        BgControlSettingCollection colls = BgControlSettingFactory.getLocalInstance(ctx).getBgControlSettingCollection(view);
        for (int index = 0; index < colls.size(); ++index) {
            BgControlSettingInfo info = colls.get(index);
            if (info.getId().toString().equals(info.getRootId()) || !ids.contains(info.getRootId())) continue;
            cantDel.add(info.getRootId());
        }
        return cantDel;
    }
}

