/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.control.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.BgNPeriodHelper;
import com.kingdee.eas.ma.control.BgCurrencyMappingCollection;
import com.kingdee.eas.ma.control.BgCurrencyMappingFactory;
import com.kingdee.eas.ma.control.BgCurrencyMappingInfo;
import com.kingdee.eas.ma.control.app.AbstractBgCurrencyMappingControllerBean;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgCurrencyMappingControllerBean
extends AbstractBgCurrencyMappingControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.control.app.BgCurrencyMappingControllerBean");
    public static final String RES = "com.kingdee.eas.ma.control.BgCurrencyMappingResource";
    protected static final String ADDNEW_LOGITEM = "mbg_control_currencyMapping_addnew";
    protected static final String UPDATE_LOGITEM = "mbg_control_currencyMapping_update";
    protected static final String DELETE_LOGITEM = "mbg_control_currencyMapping_remove";
    protected static final String DISTRIBUTE_LOGITEM = "mbg_control_currencyMapping_distribute";
    protected static final String ANTIDISTRIBUTE_LOGITEM = "mbg_control_currencyMapping_antiDistribute";

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK iObjectPK = super._addnew(ctx, model);
        this.printLog(ctx, (BgCurrencyMappingInfo)model, ADDNEW_LOGITEM);
        return iObjectPK;
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._update(ctx, pk, model);
        this.printLog(ctx, (BgCurrencyMappingInfo)model, UPDATE_LOGITEM);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BgCurrencyMappingInfo model = this.getBgCurrencyMappingInfo(ctx, pk, this.getSelectors());
        super._delete(ctx, pk);
        this.printLog(ctx, model, DELETE_LOGITEM);
    }

    private void printLog(Context ctx, BgCurrencyMappingInfo info, String logItem) {
        String bill_str = EASResource.getString((String)RES, (String)"billCurrency", (Locale)ctx.getLocale());
        String bg_str = EASResource.getString((String)RES, (String)"bgCurrency", (Locale)ctx.getLocale());
        String date_str = EASResource.getString((String)RES, (String)"enabledDate", (Locale)ctx.getLocale());
        String logName = bill_str + ":" + info.getBillCurrency().getName() + " " + bg_str + ":" + info.getBgCurrency().getName() + " " + date_str + ":" + info.getEnabledDate();
        IObjectPK tempPK = LogUtil.beginLog((Context)ctx, (String)"updateInfo", (BOSObjectType)this.getBOSType(), null, (String)logName, (String)logItem);
        LogUtil.afterLog((Context)ctx, (IObjectPK)tempPK);
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("billCurrency.id"));
        sic.add(new SelectorItemInfo("billCurrency.number"));
        sic.add(new SelectorItemInfo("billCurrency.name"));
        sic.add(new SelectorItemInfo("bgCurrency.id"));
        sic.add(new SelectorItemInfo("bgCurrency.number"));
        sic.add(new SelectorItemInfo("bgCurrency.name"));
        sic.add(new SelectorItemInfo("enabledDate"));
        sic.add(new SelectorItemInfo("root.id"));
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("orgUnit.name"));
        sic.add(new SelectorItemInfo("createOrgUnit.id"));
        sic.add(new SelectorItemInfo("createOrgUnit.name"));
        sic.add(new SelectorItemInfo("description"));
        return sic;
    }

    @Override
    protected String _check(Context ctx, IObjectValue info) throws BOSException, EASBizException {
        String msg = null;
        BgCurrencyMappingInfo model = (BgCurrencyMappingInfo)info;
        String billCurrencyId = model.getBillCurrency().getId().toString();
        String bgCurrencyId = model.getBgCurrency().getId().toString();
        Date enabledDate = model.getEnabledDate();
        String orgId = model.getOrgUnit().getId().toString();
        BgCurrencyMappingInfo mappingInfo = null;
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(new FilterInfo());
        if (model.getId() != null) {
            view.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)model.getId().toString(), CompareType.NOTEQUALS));
        }
        view.getFilter().getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgId, CompareType.EQUALS));
        BgCurrencyMappingCollection colls = BgCurrencyMappingFactory.getLocalInstance(ctx).getBgCurrencyMappingCollection(view);
        if (colls != null && !colls.isEmpty()) {
            for (int i = 0; i < colls.size(); ++i) {
                mappingInfo = colls.get(i);
                if (billCurrencyId.equals(mappingInfo.getBillCurrency().getId().toString()) && bgCurrencyId.equals(mappingInfo.getBgCurrency().getId().toString()) && (BgNPeriodHelper.getDayBegin((Date)enabledDate).before(mappingInfo.getEnabledDate()) && BgNPeriodHelper.getDayEnd((Date)enabledDate).after(mappingInfo.getEnabledDate()) || BgNPeriodHelper.getDayBegin((Date)enabledDate).equals(BgNPeriodHelper.getDayBegin((Date)mappingInfo.getEnabledDate())))) {
                    return EASResource.getString((String)RES, (String)"date_equals", (Locale)ctx.getLocale());
                }
                if (!bgCurrencyId.equals(mappingInfo.getBillCurrency().getId().toString()) || !billCurrencyId.equals(mappingInfo.getBgCurrency().getId().toString())) continue;
                return ResourceBase.getString((String)RES, (String)"checkStr", (Locale)ctx.getLocale(), (Object[])new Object[]{model.getBillCurrency().getName(), model.getBgCurrency().getName()});
            }
        }
        return msg;
    }

    @Override
    protected Object _distribute(Context ctx, Map parameter) throws BOSException, EASBizException {
        ArrayList result = new ArrayList();
        if (parameter == null && parameter.isEmpty()) {
            return result;
        }
        List mappingIds = (List)parameter.get(BgBaseConstants.ID);
        List orgIds = (List)parameter.get(BgBaseConstants.ORGUNIT_ID);
        if (mappingIds == null || mappingIds.isEmpty() || orgIds == null || orgIds.isEmpty()) {
            return result;
        }
        String col_mapping = EASResource.getString((String)RES, (String)"bgCurrencyMapping", (Locale)ctx.getLocale());
        String col_org = EASResource.getString((String)RES, (String)"org", (Locale)ctx.getLocale());
        String col_result = EASResource.getString((String)RES, (String)"distributeResult", (Locale)ctx.getLocale());
        String col_detail = EASResource.getString((String)RES, (String)"failDetail", (Locale)ctx.getLocale());
        String success = EASResource.getString((String)RES, (String)"success", (Locale)ctx.getLocale());
        String fail = EASResource.getString((String)RES, (String)"fail", (Locale)ctx.getLocale());
        String hasSelfCreate = EASResource.getString((String)RES, (String)"hasSelfCreate", (Locale)ctx.getLocale());
        String hasOtherDistribute = EASResource.getString((String)RES, (String)"hasOtherDistribute", (Locale)ctx.getLocale());
        HashMap<String, String> resultMap = null;
        String msg_mapping = null;
        String msg_org = null;
        String msg_resutl = null;
        String msg_detail = null;
        CoreBaseCollection saveColls = new CoreBaseCollection();
        BgCurrencyMappingInfo mappingInfo = null;
        BgCurrencyMappingInfo cloneInfo = null;
        FullOrgUnitInfo orgInfo = null;
        List<BgCurrencyMappingInfo> mappingInfos = this.getMappings(ctx, mappingIds);
        List<FullOrgUnitInfo> orgInfos = this.getOrgs(ctx, orgIds);
        for (int i = 0; i < orgInfos.size(); ++i) {
            orgInfo = orgInfos.get(i);
            for (int j = 0; j < mappingInfos.size(); ++j) {
                mappingInfo = mappingInfos.get(j);
                if (mappingInfo.getRoot() == null) {
                    mappingInfo.setRoot(mappingInfo);
                }
                cloneInfo = mappingInfo.getRootId() != null && !mappingInfo.getRootId().equals((Object)mappingInfo.getId()) ? (BgCurrencyMappingInfo)this.getRootInfo(ctx, mappingInfo.getRootId()).clone() : (BgCurrencyMappingInfo)mappingInfo.clone();
                cloneInfo.setId(BOSUuid.create((BOSObjectType)mappingInfo.getBOSType()));
                if (cloneInfo.getCreateOrgUnit() == null && cloneInfo.getOrgUnit() != null) {
                    cloneInfo.setCreateOrgUnit(cloneInfo.getOrgUnit());
                }
                cloneInfo.setOrgUnit(orgInfo);
                msg_mapping = cloneInfo.getBillCurrency().getName() + "-" + cloneInfo.getBgCurrency().getName() + "(" + cloneInfo.getEnabledDate() + ")";
                msg_org = cloneInfo.getOrgUnit().getNumber() + "(" + cloneInfo.getOrgUnit().getName() + ")";
                Object[] check = this.checkExists(ctx, cloneInfo);
                if (!StringUtils.isEmpty((String)check[0].toString())) {
                    if (check[0].toString().equals("hasSelfCreate")) {
                        msg_resutl = fail;
                        msg_detail = hasSelfCreate;
                    } else if (check[0].toString().equals("hasOtherDistribute")) {
                        msg_resutl = fail;
                        msg_detail = hasOtherDistribute;
                    }
                } else {
                    if (check[1] != null) {
                        cloneInfo.setId(((BgCurrencyMappingInfo)check[1]).getId());
                    } else {
                        cloneInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
                        cloneInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
                    }
                    cloneInfo.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
                    cloneInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
                    msg_resutl = success;
                    msg_detail = "";
                    saveColls.add((CoreBaseInfo)cloneInfo);
                    this.printLog(ctx, cloneInfo, DISTRIBUTE_LOGITEM);
                }
                resultMap = new HashMap<String, String>();
                resultMap.put(col_mapping, msg_mapping);
                resultMap.put(col_org, msg_org);
                resultMap.put(col_result, msg_resutl);
                resultMap.put(col_detail, msg_detail);
                result.add(resultMap);
            }
        }
        if (!saveColls.isEmpty()) {
            BgCurrencyMappingFactory.getLocalInstance(ctx).saveBatchData(saveColls);
        }
        return result;
    }

    @Override
    protected Object _antiDistribute(Context ctx, Map parameter) throws BOSException, EASBizException {
        Connection conn;
        ArrayList result;
        block25: {
            result = new ArrayList();
            if (parameter == null && parameter.isEmpty()) {
                return result;
            }
            List mappingIds = (List)parameter.get(BgBaseConstants.ID);
            List orgIds = (List)parameter.get(BgBaseConstants.ORGUNIT_ID);
            if (mappingIds == null || mappingIds.isEmpty() || orgIds == null || orgIds.isEmpty()) {
                return result;
            }
            String col_mapping = EASResource.getString((String)RES, (String)"bgCurrencyMapping", (Locale)ctx.getLocale());
            String col_org = EASResource.getString((String)RES, (String)"org", (Locale)ctx.getLocale());
            String col_result = EASResource.getString((String)RES, (String)"undistributeResult", (Locale)ctx.getLocale());
            String col_detail = EASResource.getString((String)RES, (String)"failDetail", (Locale)ctx.getLocale());
            String success = EASResource.getString((String)RES, (String)"success", (Locale)ctx.getLocale());
            HashMap<String, String> resultMap = null;
            String msg_mapping = null;
            String msg_org = null;
            String msg_resutl = null;
            String msg_detail = null;
            BgCurrencyMappingInfo mappingInfo = null;
            BgCurrencyMappingInfo cloneInfo = null;
            FullOrgUnitInfo orgInfo = null;
            List<BgCurrencyMappingInfo> mappingInfos = this.getMappings(ctx, mappingIds);
            List<FullOrgUnitInfo> orgInfos = this.getOrgs(ctx, orgIds);
            for (int i = 0; i < orgInfos.size(); ++i) {
                orgInfo = orgInfos.get(i);
                for (int j = 0; j < mappingInfos.size(); ++j) {
                    mappingInfo = mappingInfos.get(j);
                    if (mappingInfo.getRoot() == null) {
                        mappingInfo.setRoot(mappingInfo);
                    }
                    cloneInfo = mappingInfo.getRootId() != null && !mappingInfo.getRootId().equals((Object)mappingInfo.getId()) ? (BgCurrencyMappingInfo)this.getRootInfo(ctx, mappingInfo.getRootId()).clone() : (BgCurrencyMappingInfo)mappingInfo.clone();
                    cloneInfo.setOrgUnit(orgInfo);
                    msg_mapping = cloneInfo.getBillCurrency().getName() + "-" + cloneInfo.getBgCurrency().getName() + "(" + cloneInfo.getEnabledDate() + ")";
                    msg_org = cloneInfo.getOrgUnit().getNumber() + "(" + cloneInfo.getOrgUnit().getName() + ")";
                    msg_resutl = success;
                    msg_detail = "";
                    resultMap = new HashMap<String, String>();
                    resultMap.put(col_mapping, msg_mapping);
                    resultMap.put(col_org, msg_org);
                    resultMap.put(col_result, msg_resutl);
                    resultMap.put(col_detail, msg_detail);
                    result.add(resultMap);
                    this.printLog(ctx, cloneInfo, ANTIDISTRIBUTE_LOGITEM);
                }
            }
            HashSet<String> rootIds = new HashSet<String>();
            if (!mappingInfos.isEmpty()) {
                for (int i = 0; i < mappingInfos.size(); ++i) {
                    mappingInfo = mappingInfos.get(i);
                    rootIds.add(mappingInfo.getId().toString());
                    if (mappingInfo.getRootId() == null || mappingIds.contains(mappingInfo.getRootId().toString())) continue;
                    rootIds.add(mappingInfo.getRootId().toString());
                }
            }
            String orgTmp = null;
            String mappingTmp = null;
            conn = null;
            TempTablePool pool = TempTablePool.getInstance((Context)ctx);
            try {
                conn = this.getConnection(ctx);
                if (!orgIds.isEmpty() && !rootIds.isEmpty()) {
                    orgTmp = pool.createDBSystemTempTable("CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))", conn);
                    BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + orgTmp + " (FID) values (?)"), (Collection)orgIds);
                    mappingTmp = pool.createDBSystemTempTable("CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))", conn);
                    BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + mappingTmp + " (FID) values (?)"), rootIds);
                    BgDBUtils.executeUpdate((Connection)conn, (String)("Delete From T_MBG_BgCurrencyMapping Where fRootid in (select FID from " + mappingTmp + ") AND FOrgUnitId in (select FID from " + orgTmp + ")"));
                }
                if (pool == null) break block25;
            }
            catch (Exception e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    if (pool != null) {
                        if (!StringUtils.isEmpty(orgTmp)) {
                            try {
                                pool.releaseDBSystemTempTable(orgTmp, conn);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (!StringUtils.isEmpty(mappingTmp)) {
                            try {
                                pool.releaseDBSystemTempTable(mappingTmp, conn);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    SQLUtils.cleanup((Connection)conn);
                    throw throwable;
                }
            }
            if (!StringUtils.isEmpty(orgTmp)) {
                try {
                    pool.releaseDBSystemTempTable(orgTmp, conn);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!StringUtils.isEmpty(mappingTmp)) {
                try {
                    pool.releaseDBSystemTempTable(mappingTmp, conn);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        SQLUtils.cleanup((Connection)conn);
        return result;
    }

    protected Object[] checkExists(Context ctx, BgCurrencyMappingInfo info) throws BOSException {
        String billCurrencyId = info.getBillCurrency().getId().toString();
        String bgCurrencyId = info.getBgCurrency().getId().toString();
        Date enabledDate = info.getEnabledDate();
        String orgId = info.getOrgUnit().getId().toString();
        BgCurrencyMappingInfo mappingInfo = null;
        Object[] obj = new Object[2];
        String str = "";
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(new FilterInfo());
        view.getFilter().getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgId, CompareType.EQUALS));
        view.getFilter().getFilterItems().add(new FilterItemInfo("billCurrency.id", (Object)billCurrencyId, CompareType.EQUALS));
        view.getFilter().getFilterItems().add(new FilterItemInfo("bgCurrency.id", (Object)bgCurrencyId, CompareType.EQUALS));
        view.getFilter().getFilterItems().add(new FilterItemInfo("enabledDate", (Object)BgNPeriodHelper.getDayBegin((Date)enabledDate), CompareType.GREATER_EQUALS));
        view.getFilter().getFilterItems().add(new FilterItemInfo("enabledDate", (Object)BgNPeriodHelper.getDayEnd((Date)enabledDate), CompareType.LESS_EQUALS));
        BgCurrencyMappingCollection colls = BgCurrencyMappingFactory.getLocalInstance(ctx).getBgCurrencyMappingCollection(view);
        if (colls != null && !colls.isEmpty()) {
            if (colls.size() == 1) {
                if (colls.get(0).getRootId() == null) {
                    str = "hasSelfCreate";
                } else if (colls.get(0).getRootId().toString().equals(colls.get(0).getId().toString())) {
                    str = "hasSelfCreate";
                } else if (colls.get(0).getRootId().toString().equals(info.getRootId().toString())) {
                    mappingInfo = colls.get(0);
                } else {
                    str = "hasOtherDistribute";
                }
            } else {
                str = "hasSelfCreate";
            }
        }
        obj[0] = str;
        obj[1] = mappingInfo;
        return obj;
    }

    protected BgCurrencyMappingInfo getRootInfo(Context ctx, BOSUuid rootId) throws EASBizException, BOSException {
        return BgCurrencyMappingFactory.getLocalInstance(ctx).getBgCurrencyMappingInfo((IObjectPK)new ObjectUuidPK(rootId.toString()), BgCurrencyMappingInfo.getSelectors());
    }

    protected List<BgCurrencyMappingInfo> getMappings(Context ctx, List<String> mappingIds) throws BOSException {
        ArrayList<BgCurrencyMappingInfo> lst = new ArrayList<BgCurrencyMappingInfo>();
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(BgCurrencyMappingInfo.getSelectors());
        view.setFilter(new FilterInfo());
        view.getFilter().getFilterItems().add(new FilterItemInfo("id", new HashSet<String>(mappingIds), CompareType.INCLUDE));
        BgCurrencyMappingCollection colls = BgCurrencyMappingFactory.getLocalInstance(ctx).getBgCurrencyMappingCollection(view);
        if (colls != null && !colls.isEmpty()) {
            for (int i = 0; i < colls.size(); ++i) {
                lst.add(colls.get(i));
            }
        }
        return lst;
    }

    protected List<FullOrgUnitInfo> getOrgs(Context ctx, List<String> orgIds) throws BOSException {
        ArrayList<FullOrgUnitInfo> lst = new ArrayList<FullOrgUnitInfo>();
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(new SelectorItemCollection());
        view.getSelector().add("id");
        view.getSelector().add("number");
        view.getSelector().add("name");
        view.setFilter(new FilterInfo());
        view.getFilter().getFilterItems().add(new FilterItemInfo("id", new HashSet<String>(orgIds), CompareType.INCLUDE));
        FullOrgUnitCollection colls = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitCollection(view);
        if (colls != null && !colls.isEmpty()) {
            for (int i = 0; i < colls.size(); ++i) {
                lst.add(colls.get(i));
            }
        }
        return lst;
    }

    @Override
    protected Object _deleteMappings(Context ctx, Set ids) throws BOSException, EASBizException {
        HashMap<String, String> result = new HashMap<String, String>();
        if (ids == null && ids.isEmpty()) {
            return result;
        }
        String deleteResult = null;
        int deleteCount = 0;
        StringBuffer deleteCheckDistributed = new StringBuffer();
        BgCurrencyMappingInfo info = null;
        List<BgCurrencyMappingInfo> mappings = this.getMappings(ctx, new ArrayList<String>(ids));
        Set<String> distributeRootIds = this.queryDistributeRootIds(ctx, new ArrayList<String>(ids));
        for (int i = 0; i < mappings.size(); ++i) {
            info = mappings.get(i);
            if (distributeRootIds.contains(info.getId().toString())) {
                String str = info.getBillCurrency().getName() + "-" + info.getBgCurrency().getName() + "(" + info.getEnabledDate() + ")";
                deleteCheckDistributed.append(ResourceBase.getString((String)RES, (String)"deleteCheckDistributed", (Locale)ctx.getLocale(), (Object[])new Object[]{info.getOrgUnit().getNumber() + "(" + info.getOrgUnit().getName() + ")", str})).append("\r\n");
                continue;
            }
            this._delete(ctx, (IObjectPK)new ObjectUuidPK(info.getId().toString()));
            this.printLog(ctx, info, DELETE_LOGITEM);
            ++deleteCount;
        }
        if (deleteCount != ids.size()) {
            deleteResult = ResourceBase.getString((String)RES, (String)"deleteResult", (Locale)ctx.getLocale(), (Object[])new Object[]{ids.size(), deleteCount, ids.size() - deleteCount});
            result.put("deleteResult", deleteResult);
            result.put("deleteCheckDistributed", deleteCheckDistributed.toString());
        } else {
            result.put("deleteResult", "");
        }
        return result;
    }

    protected Set<String> queryDistributeRootIds(Context ctx, List<String> mappingIds) throws BOSException {
        HashSet<String> distributeRootIds = new HashSet<String>();
        HashMap tmpMap = new HashMap();
        BgCurrencyMappingInfo info = null;
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(BgCurrencyMappingInfo.getSelectors());
        view.setFilter(new FilterInfo());
        view.getFilter().getFilterItems().add(new FilterItemInfo("root.id", new HashSet<String>(mappingIds), CompareType.INCLUDE));
        BgCurrencyMappingCollection colls = BgCurrencyMappingFactory.getLocalInstance(ctx).getBgCurrencyMappingCollection(view);
        if (colls != null && !colls.isEmpty()) {
            for (int i = 0; i < colls.size(); ++i) {
                info = colls.get(i);
                if (!tmpMap.containsKey(info.getRootId().toString())) {
                    tmpMap.put(info.getRootId().toString(), new HashSet());
                }
                ((Set)tmpMap.get(info.getRootId().toString())).add(info.getId().toString());
            }
        }
        String rootId2 = null;
        Set tmpSet = null;
        for (String rootId2 : tmpMap.keySet()) {
            tmpSet = (Set)tmpMap.get(rootId2);
            Iterator itr = tmpSet.iterator();
            while (itr.hasNext()) {
                String childId = (String)itr.next();
                if (!mappingIds.contains(childId)) continue;
                itr.remove();
            }
            if (((Set)tmpMap.get(rootId2)).isEmpty()) continue;
            distributeRootIds.add(rootId2);
        }
        return distributeRootIds;
    }

    @Override
    protected Map _queryDispatchInfo(Context ctx, Set ids) throws BOSException, EASBizException {
        HashMap resultMap = new HashMap();
        BgCurrencyMappingInfo info = null;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("root.Id");
        sic.add("orgUnit.id");
        sic.add("orgUnit.name");
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(sic);
        view.setFilter(new FilterInfo());
        BgCurrencyMappingCollection colls = BgCurrencyMappingFactory.getLocalInstance(ctx).getBgCurrencyMappingCollection(view);
        if (colls != null && !colls.isEmpty()) {
            for (int i = 0; i < colls.size(); ++i) {
                info = colls.get(i);
                if (info.getId().equals((Object)info.getRootId())) continue;
                if (!resultMap.containsKey(info.getRootId())) {
                    resultMap.put(info.getRootId(), new HashSet());
                }
                ((Set)resultMap.get(info.getRootId())).add(info.getOrgUnit().getId());
            }
        }
        return resultMap;
    }
}

