/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.control.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.EntityExecutorFactory;
import com.kingdee.bos.dao.query.IDataProvider;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.kscript.runtime.Interpreter;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgElementCollection;
import com.kingdee.eas.ma.base.BgElementFactory;
import com.kingdee.eas.ma.base.BgElementInfo;
import com.kingdee.eas.ma.base.BgPeriodCollection;
import com.kingdee.eas.ma.base.BgPeriodEnum;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgPeriodTypeCollection;
import com.kingdee.eas.ma.base.BgPeriodTypeFactory;
import com.kingdee.eas.ma.base.BgPeriodTypeInfo;
import com.kingdee.eas.ma.base.BgScenarioInfo;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.FiscalYearEnum;
import com.kingdee.eas.ma.base.MbgDimInfo;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.BgDimCacheUtils;
import com.kingdee.eas.ma.base.utils.BgNPeriodHelper;
import com.kingdee.eas.ma.base.utils.BgParamNHelper;
import com.kingdee.eas.ma.base.utils.BgPeriodDispHelper;
import com.kingdee.eas.ma.base.utils.BgPeriodHelper;
import com.kingdee.eas.ma.base.utils.BgScenarioHelper;
import com.kingdee.eas.ma.base.utils.BgVersionHelper;
import com.kingdee.eas.ma.control.BgControlException;
import com.kingdee.eas.ma.control.BgControlIsomerBaseCollection;
import com.kingdee.eas.ma.control.BgControlIsomerBaseFactory;
import com.kingdee.eas.ma.control.BgControlIsomerException;
import com.kingdee.eas.ma.control.BgControlRuleInfo;
import com.kingdee.eas.ma.control.BgControlSchemeInfo;
import com.kingdee.eas.ma.control.face.IControlParameter;
import com.kingdee.eas.ma.control.impl.models.BgControlParam;
import com.kingdee.eas.ma.control.impl.models.BillOQLInfo;
import com.kingdee.eas.ma.control.utils.BgControlConstants;
import com.kingdee.eas.ma.control.utils.BgControlIsomerKSQLUtils;
import com.kingdee.eas.ma.control.utils.BgControlIsomerUtils;
import com.kingdee.eas.ma.control.utils.BgControlUtils;
import com.kingdee.eas.ma.control.utils.BizItemMapUtils;
import com.kingdee.eas.ma.control.utils.BizUnitCheckUtils;
import com.kingdee.eas.ma.control.utils.ObjectFilter;
import com.kingdee.eas.ma.control.utils.ObjectValueToMap;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.cube.utils.MbgDataHelper;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.util.ObjectUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgControlParamUtils {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.control.utils.BgControlParamUtils");
    public static final int orgUnit = 0;
    public static final int orgUnitAlias = 1;
    public static final int dimItem = 2;
    public static final int dimItemAlias = 3;
    public static final int currency = 4;
    public static final int currencyAlias = 5;
    public static final int elementNumber = 6;
    public static final int bizDate = 7;
    public static final int bizDateAlias = 8;
    public static final int periodScope = 9;
    public static final int request = 10;
    public static final int requestAlias = 11;
    public static final int requestEx = 12;
    public static final int condition = 13;
    public static final int conditionAlias = 14;
    public static final int limitVal = 15;
    public static final int maskString = 16;
    public static final String VoucherEntity = "com.kingdee.eas.fi.gl.app.Voucher";
    private Map<String, BgPeriodInfo> bgPeriodMap = new HashMap<String, BgPeriodInfo>();
    private List<String> conditions = new ArrayList<String>();

    private BgControlParamUtils() {
    }

    public static BgControlParamUtils getInterace() {
        return new BgControlParamUtils();
    }

    public Map<String, BgPeriodInfo> getBgPeriodMap() {
        return this.bgPeriodMap;
    }

    public List<String> getConditions() {
        return this.conditions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BgControlParam> getControlParam(Context ctx, BgControlSchemeInfo controlScheme, IControlParameter parameter) throws BOSException, EASBizException {
        ArrayList<BgControlParam> params = new ArrayList<BgControlParam>();
        if (ctx == null || controlScheme == null || parameter == null) {
            return params;
        }
        HashMap<String, BgControlParam> keyParams = new HashMap<String, BgControlParam>();
        BizItemMapUtils bizItemMap = new BizItemMapUtils(controlScheme);
        Connection conn = null;
        IRowSet rst = null;
        BgControlIsomerBaseCollection colls = BgControlIsomerBaseFactory.getLocalInstance(ctx).getBgControlIsomerBaseCollection("select number,easNumber,TYPE where connection.id='" + parameter.getBgControlIsomer().getConnection().getId() + "'");
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            BgControlIsomerKSQLUtils client = BgControlIsomerUtils.getKSQLCilent(ctx, parameter.getBgControlIsomer().getConnection()).get(parameter.getBgControlIsomer().getConnection().getId().toString());
            int in = controlScheme.getRule().size();
            for (int i = 0; i < in; ++i) {
                BgControlRuleInfo rule = controlScheme.getRule().get(i);
                ArrayList fieldValues = new ArrayList();
                HashMap<String, Object> values = null;
                String field2 = null;
                Object[] ruleParam = this.getRuleParam(rule);
                BillOQLInfo billOQL = BgControlIsomerUtils.getQueryBillOQL(ctx, ruleParam, parameter);
                String queryBillSQL = billOQL.getBillSQL();
                logger.debug((Object)("param sql : " + queryBillSQL));
                if (billOQL.condition != null) {
                    this.getConditions().add(rule.getId().toString() + ":" + billOQL.getBillOQL());
                }
                try {
                    rst = client.getTargetRowset(queryBillSQL);
                    while (rst.next()) {
                        values = new HashMap<String, Object>();
                        fieldValues.add(values);
                        field2 = (String)ruleParam[7];
                        values.put(field2, rst.getTimestamp(billOQL.getFieldIndex().get(field2).intValue()));
                        field2 = billOQL.getField().getRequest();
                        values.put(field2, rst.getBigDecimal(billOQL.getFieldIndex().get(field2).intValue()));
                        if (billOQL.getReqExtFields() != null) {
                            for (int r = 0; r < billOQL.getReqExtFields().length; ++r) {
                                field2 = billOQL.getReqExtFields()[i];
                                values.put(field2, rst.getBigDecimal(billOQL.getFieldIndex().get(field2).intValue()));
                            }
                        }
                        for (String field2 : billOQL.getFieldIndex().keySet()) {
                            if (values.containsKey(field2)) continue;
                            if (field2.equals(ruleParam[0]) || field2.equals(ruleParam[4])) {
                                String orgNumber = rst.getString(billOQL.getFieldIndex().get(field2).intValue());
                                for (int j = 0; j < colls.size(); ++j) {
                                    if (!colls.get(j).getNumber().equals(orgNumber)) continue;
                                    if (field2.equals(ruleParam[0]) && colls.get(j).getType().getValue() == 0) {
                                        orgNumber = colls.get(j).getEasNumber();
                                        break;
                                    }
                                    if (!field2.equals(ruleParam[4]) || colls.get(j).getType().getValue() != 1) continue;
                                    orgNumber = colls.get(j).getEasNumber();
                                    break;
                                }
                                if (field2.equals(ruleParam[0])) {
                                    FullOrgUnitInfo orgUnit = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo("select * where number='" + orgNumber + "'");
                                    if (orgUnit != null) {
                                        values.put(field2, orgUnit.getNumber());
                                        continue;
                                    }
                                    throw new BgControlIsomerException(BgControlIsomerException.NOFOUNDORGUNIT);
                                }
                                CurrencyCollection curInfo = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyCollection("select * where number='" + orgNumber + "'");
                                if (!curInfo.isEmpty()) {
                                    values.put(field2, curInfo.get(0).getNumber());
                                    continue;
                                }
                                throw new BgControlIsomerException(BgControlIsomerException.NOFOUNDCURRENCY);
                            }
                            values.put(field2, rst.getObject(billOQL.getFieldIndex().get(field2).intValue()));
                        }
                    }
                    if (values == null) {
                        this.getConditions().add(rule.getId().toString() + ": filter is null");
                    }
                }
                catch (SQLException ex) {
                    logger.error((Object)"error", (Throwable)ex);
                    throw new BgControlException(BgControlException.DATABASEEXCEPTION, new String[]{ex.getMessage()});
                }
                finally {
                    SQLUtils.cleanup((ResultSet)rst);
                }
                this.buildParamOnRule(ctx, conn, params, rule, ruleParam, fieldValues, keyParams, bizItemMap, parameter.getBgControlIsomer().getPfiled());
            }
            this.afterBuildParam(ctx, conn, controlScheme, params);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BgControlParam> getControlParam(Context ctx, BOSUuid billId, BgControlSchemeInfo controlScheme, IControlParameter parameter) throws BOSException, EASBizException {
        ArrayList<BgControlParam> params = new ArrayList<BgControlParam>();
        if (ctx == null || billId == null || controlScheme == null || parameter == null) {
            return params;
        }
        HashMap<String, BgControlParam> keyParams = new HashMap<String, BgControlParam>();
        IDataProvider dataProvider = EntityExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)MetaDataPK.create((String)parameter.getBizUnit()));
        BizItemMapUtils bizItemMap = new BizItemMapUtils(controlScheme);
        Connection conn = null;
        IRowSet rst = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            int in = controlScheme.getRule().size();
            for (int i = 0; i < in; ++i) {
                BgControlRuleInfo rule = controlScheme.getRule().get(i);
                ArrayList fieldValues = new ArrayList();
                HashMap<String, Object> values = null;
                String field2 = null;
                Object[] ruleParam = this.getRuleParam(rule);
                BillOQLInfo billOQL = BgControlUtils.getQueryBillOQL(ctx, billId, ruleParam, parameter);
                dataProvider.setObjectView(billOQL.getBillOQL());
                String queryBillSQL = dataProvider.getSQL();
                queryBillSQL = BgControlUtils.transBillSQL(ctx, queryBillSQL, ruleParam, parameter);
                if (billOQL.condition != null) {
                    this.getConditions().add(rule.getId().toString() + ":" + billOQL.getBillOQL());
                }
                if (VoucherEntity.equals(parameter.getBizUnit())) {
                    logger.error((Object)("kingdee logger query voucher bill sql = " + queryBillSQL));
                    if (queryBillSQL.indexOf(".FOpposingAccountEntryID") >= 0) {
                        queryBillSQL = queryBillSQL.replaceAll(".FOpposingAccountEntryID", ".FEntryID");
                    }
                    if (queryBillSQL.indexOf("LEFT OUTER JOIN T_BD_CashFlowItem") >= 0) {
                        queryBillSQL = queryBillSQL.replaceAll("LEFT OUTER JOIN T_BD_CashFlowItem", "INNER JOIN T_BD_CashFlowItem");
                    }
                    if (queryBillSQL.indexOf(" DISTINCT ") >= 0) {
                        queryBillSQL = queryBillSQL.replaceAll(" DISTINCT ", " ");
                    }
                }
                logger.error((Object)("kingdee logger query bill sql = " + queryBillSQL));
                try {
                    rst = BgDBUtils.executeQuery((Connection)conn, (String)queryBillSQL);
                    while (rst.next()) {
                        values = new HashMap<String, Object>();
                        fieldValues.add(values);
                        field2 = (String)ruleParam[7];
                        values.put(field2, rst.getTimestamp(billOQL.getFieldIndex().get(field2).intValue()));
                        field2 = billOQL.getField().getRequest();
                        values.put(field2, rst.getBigDecimal(billOQL.getFieldIndex().get(field2).intValue()));
                        if (billOQL.getReqExtFields() != null) {
                            for (int r = 0; r < billOQL.getReqExtFields().length; ++r) {
                                field2 = billOQL.getReqExtFields()[i];
                                values.put(field2, rst.getBigDecimal(billOQL.getFieldIndex().get(field2).intValue()));
                            }
                        }
                        for (String field2 : billOQL.getFieldIndex().keySet()) {
                            if (values.containsKey(field2)) continue;
                            values.put(field2, rst.getObject(billOQL.getFieldIndex().get(field2).intValue()));
                        }
                        if (billOQL.getBillOQL().indexOf("entrys.id") >= 0) {
                            values.put("entrys.id", rst.getObject(billOQL.getFieldIndex().get("entrys.id").intValue()));
                        } else if (billOQL.getBillOQL().indexOf("entries.id") >= 0) {
                            values.put("entries.id", rst.getObject(billOQL.getFieldIndex().get("entries.id").intValue()));
                        }
                        if (billOQL.getBillOQL().indexOf("entries.assistRecords.id") < 0) continue;
                        values.put("entries.assistRecords.id", rst.getObject(billOQL.getFieldIndex().get("entries.assistRecords.id").intValue()));
                    }
                    if (values == null) {
                        this.getConditions().add(rule.getId().toString() + ": filter is null");
                    }
                }
                catch (SQLException ex) {
                    logger.error((Object)"error", (Throwable)ex);
                    throw new BgControlException(BgControlException.DATABASEEXCEPTION, new String[]{ex.getMessage()});
                }
                finally {
                    SQLUtils.cleanup((ResultSet)rst);
                }
                this.buildParamOnRule(ctx, conn, params, rule, ruleParam, fieldValues, keyParams, bizItemMap);
            }
            this.afterBuildParam(ctx, conn, controlScheme, params);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BgControlParam> getControlParam(Context ctx, IObjectValue model, BgControlSchemeInfo controlScheme, IControlParameter parameter) throws BOSException, EASBizException {
        ArrayList<BgControlParam> params = new ArrayList<BgControlParam>();
        if (ctx == null || model == null || controlScheme == null || parameter == null) {
            return params;
        }
        BizItemMapUtils bizItemMap = new BizItemMapUtils(controlScheme);
        HashMap<String, BgControlParam> keyParams = new HashMap<String, BgControlParam>();
        IObjectValue filterInfo = null;
        Connection conn = null;
        Object date = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            int in = controlScheme.getRule().size();
            for (int i = 0; i < in; ++i) {
                BgControlRuleInfo rule = controlScheme.getRule().get(i);
                Object[] ruleParam = this.getRuleParam(rule);
                String oqlCondition = (String)ruleParam[13];
                if (!StringUtils.isEmpty((String)oqlCondition)) {
                    String oql = "where " + oqlCondition;
                    this.getConditions().add(rule.getId().toString() + " : " + oql);
                    model = BgControlUtils.transBillObject(ctx, model, oql, parameter);
                    try {
                        EntityViewInfo fi = new EntityViewInfo(oql);
                        for (int f = 0; f < fi.getFilter().getFilterItems().size(); ++f) {
                            date = fi.getFilter().getFilterItems().get(f).getCompareValue();
                            if (!(date instanceof Date) || date.getClass().equals(Date.class)) continue;
                            fi.getFilter().getFilterItems().get(f).setCompareValue((Object)new Date(((Date)date).getTime()));
                        }
                        filterInfo = BgControlParamUtils.filteObjectValue(model, fi.getFilter(), true);
                    }
                    catch (BOSException ex) {
                        throw ex;
                    }
                    catch (ParserException e) {
                        throw new BOSException((Throwable)e);
                    }
                } else {
                    filterInfo = model;
                }
                if (filterInfo == null) {
                    this.getConditions().add(rule.getId().toString() + " : filter is null.");
                    continue;
                }
                String[] fields = this.getRuleFields(ruleParam, true);
                List fieldValues = new ObjectValueToMap().execute(filterInfo, fields);
                this.buildParamOnRule(ctx, conn, params, rule, ruleParam, fieldValues, keyParams, bizItemMap);
            }
            this.afterBuildParam(ctx, conn, controlScheme, params);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return params;
    }

    public static IObjectValue filteObjectValue(IObjectValue ov, FilterInfo mainRule, boolean isReturnNew) throws BOSException, EASBizException {
        IObjectValue nov = null;
        if (isReturnNew) {
            try {
                nov = (IObjectValue)ObjectUtils.createCopy((Object)ov);
            }
            catch (Exception e) {
                throw new BgControlException(BgControlException.CREATECOPYERROR);
            }
        } else {
            nov = ov;
        }
        ObjectFilter of = new ObjectFilter();
        boolean b = of.filte(nov, mainRule);
        if (b) {
            return nov;
        }
        return null;
    }

    private void buildParamOnRule(Context ctx, Connection conn, List<BgControlParam> params, BgControlRuleInfo rule, Object[] ruleParam, List fieldValues, Map<String, BgControlParam> keyParams, BizItemMapUtils bizItemMap) throws EASBizException {
        this.buildParamOnRule(ctx, conn, params, rule, ruleParam, fieldValues, keyParams, bizItemMap, null);
    }

    private void buildParamOnRule(Context ctx, Connection conn, List<BgControlParam> params, BgControlRuleInfo rule, Object[] ruleParam, List fieldValues, Map<String, BgControlParam> keyParams, BizItemMapUtils bizItemMap, String pkField) throws EASBizException {
        BizUnitCheckUtils check = BizUnitCheckUtils.getInterace();
        if (fieldValues != null && !fieldValues.isEmpty()) {
            for (int f = 0; f < fieldValues.size(); ++f) {
                Map fieldValueMap = (Map)fieldValues.get(f);
                check.checkBizUnitInfo(rule, fieldValueMap, false);
                BgControlParam param = this.createParam(rule);
                if (pkField != null) {
                    param.setBillId(String.valueOf(fieldValueMap.get(pkField)));
                    param.setBillNumber(String.valueOf(fieldValueMap.get(pkField)));
                } else {
                    this.setBillParam(param, fieldValueMap);
                }
                this.buildParamFromValueMap(ctx, conn, rule, param, fieldValueMap, ruleParam, bizItemMap);
                this.mergeControlParam(params, keyParams, param);
            }
        }
    }

    private void afterBuildParam(Context ctx, Connection conn, BgControlSchemeInfo controlScheme, List<BgControlParam> params) throws BOSException, EASBizException {
        if (ctx == null || conn == null || controlScheme == null || params == null || params.isEmpty()) {
            return;
        }
        this.fillOrg(ctx, conn, params);
        this.fillCurrency(ctx, params);
        this.fillElement(ctx, params);
        this.fillScenario(ctx, params);
        this.fillDimensionMember(ctx, controlScheme, params);
        this.fillBgPeriod(ctx, conn, controlScheme, params);
    }

    private void setBillParam(BgControlParam param, Map valueMap) {
        param.setBillId(StringUtils.cnulls(valueMap.get(BgControlConstants.PROP_ID)));
        param.setBillNumber(StringUtils.cnulls(valueMap.get(BgControlConstants.PROP_NUMBER)));
    }

    private BgControlParam createParam(BgControlRuleInfo rule) {
        BgControlParam param = new BgControlParam();
        param.setBgElement(new BgElementInfo());
        param.getBgElement().setNumber(rule.getBgElementNumber());
        param.setBgPeriodType(rule.getPeriodType());
        param.setBgRealPeriodType(rule.getRealPeriodType());
        param.setBgScenario(new BgScenarioInfo());
        param.getBgScenario().setNumber(rule.getBgScenarioNumber());
        param.setAcScenario(new BgScenarioInfo());
        param.getAcScenario().setNumber(rule.getAcScenarioNumber());
        param.setBgSchemeType(rule.getBgSchemeType());
        param.setBgPeriodGroup(rule.getBgPeriodType());
        return param;
    }

    private void buildParamFromValueMap(Context ctx, Connection conn, BgControlRuleInfo rule, BgControlParam param, Map fieldValueMap, Object[] ruleParam, BizItemMapUtils bizItemMap) throws EASBizException {
        String entryId;
        Object[] values = this.getValues(fieldValueMap, (String)ruleParam[0]);
        if (values == null) {
            throw new BgControlException(BgControlException.BILLVALUEERROR, new Object[]{param.getBillNumber(), ruleParam[1], ruleParam[1]});
        }
        OrgUnitInfo unitInfo = new OrgUnitInfo();
        unitInfo.setNumber(StringUtils.cnulls((Object)values[0], null));
        unitInfo.setName(StringUtils.cnulls((Object)values[1], null));
        param.setOrgUnit(unitInfo);
        param.setReqOrgUnit(unitInfo);
        values = this.getValues(fieldValueMap, (String)ruleParam[4]);
        if (values == null) {
            throw new BgControlException(BgControlException.BILLVALUEERROR, new Object[]{param.getBillNumber(), ruleParam[5], ruleParam[5]});
        }
        param.setCurrency(new CurrencyInfo());
        param.getCurrency().setNumber(StringUtils.cnulls((Object)values[0], null));
        param.getCurrency().setName(StringUtils.cnulls((Object)values[1], null));
        Object value = this.getValue(fieldValueMap, (String)ruleParam[7]);
        if (!(value instanceof Date)) {
            throw new BgControlException(BgControlException.BILLVALUEERROR, new Object[]{param.getBillNumber(), ruleParam[8], ruleParam[8]});
        }
        param.setBizDate(new Timestamp(((Date)value).getTime()));
        this.fillBgPeriod(ctx, conn, param);
        value = this.getValue(fieldValueMap, (String)ruleParam[10]);
        if (value == null) {
            throw new BgControlException(BgControlException.BILLVALUEERROR, new Object[]{param.getBillNumber(), ruleParam[11], ruleParam[11]});
        }
        param.setReqAmount(this.calRequestAmount(value, ruleParam[12]));
        int _limitType = rule.getLimitValue().getValue();
        if (_limitType != 0) {
            BigDecimal _value = param.getReqAmount();
            BigDecimal _limitVal = null;
            if (_limitType == -1) {
                _value = _value.multiply(BgControlConstants.NONE);
            } else if (_limitType == 1 || _limitType == 2) {
                value = this.getValue(fieldValueMap, (String)ruleParam[15]);
                if (value instanceof Number) {
                    Number _number = (Number)value;
                    if (_limitType == 1) {
                        _limitVal = BgNConstants.TWO.multiply(new BigDecimal(_number.doubleValue())).subtract(BgControlConstants.ONE);
                    } else if (_limitType == 2) {
                        _limitVal = BgControlConstants.ONE.subtract(BgNConstants.TWO.multiply(new BigDecimal(_number.doubleValue())));
                    }
                }
                _value = _value.multiply(_limitVal);
            }
            param.setReqAmount(_value);
        }
        if (fieldValueMap.containsKey("entrys.id")) {
            entryId = String.valueOf(fieldValueMap.get("entrys.id"));
            param.setBillEntryId(entryId);
        } else if (fieldValueMap.containsKey("entries.id")) {
            entryId = String.valueOf(fieldValueMap.get("entries.id"));
            param.setBillEntryId(entryId);
        }
        if (fieldValueMap.containsKey("entries.assistRecords.id")) {
            String assistRecordsId = String.valueOf(fieldValueMap.get("entries.assistRecords.id"));
            param.setAssistRecordsId(assistRecordsId);
        }
        String[] mbgItem = null;
        String[] combins = BgControlUtils.splitCombin((String)ruleParam[2]);
        String[] combinAlias = BgControlUtils.splitCombin((String)ruleParam[3]);
        if (combins != null && combins.length > 0) {
            int i;
            StringBuffer dimNumbers = new StringBuffer();
            StringBuffer dimName = new StringBuffer();
            String field = null;
            String fieldName = null;
            String fieldAlias = null;
            String dimSrcNumber = null;
            String propValue = null;
            String propName = null;
            StringBuffer propKey = new StringBuffer();
            for (i = 0; i < combins.length; ++i) {
                field = BgControlUtils.getField(BgControlUtils.splitField(combins[i]));
                propValue = StringUtils.cnulls(fieldValueMap.get(field), null);
                if (field.endsWith(".longNumber") && propValue != null && propValue.contains("!")) {
                    propValue = propValue.replaceAll("\\!", "\\.");
                    fieldValueMap.put(field, propValue);
                }
                if (i == combins.length - 1) {
                    propKey.append(propValue);
                    continue;
                }
                propKey.append(propValue).append("|");
            }
            for (i = 0; i < combins.length; ++i) {
                field = BgControlUtils.getField(BgControlUtils.splitField(combins[i]));
                fieldName = BgControlUtils.getFieldName(field);
                fieldAlias = BgControlUtils.getField(BgControlUtils.splitField(combinAlias[i]));
                dimSrcNumber = BgControlUtils.getFieldNumber(BgControlUtils.splitField(combins[i]));
                propValue = BgControlUtils.getFieldValue(ctx, field, fieldValueMap);
                propName = StringUtils.cnulls(fieldValueMap.get(fieldName), null);
                if ("bgDimNum".equals(dimSrcNumber)) {
                    DimensionFormulaHelper.addItem((StringBuffer)dimNumbers, (String)propValue);
                    DimensionFormulaHelper.addItem((StringBuffer)dimName, (String)propName);
                    continue;
                }
                mbgItem = bizItemMap.matching((String)ruleParam[2], propKey.toString(), rule.getDimensionGroup(), propValue, i);
                if (mbgItem != null) {
                    propValue = mbgItem[0];
                    propName = mbgItem[1];
                }
                if (!StringUtils.isEmpty((String)propValue) && !StringUtils.isEmpty((String)propName)) {
                    DimensionFormulaHelper.addItem((StringBuffer)dimNumbers, (String)dimSrcNumber, (String)propValue);
                    DimensionFormulaHelper.addItem((StringBuffer)dimName, (String)propName);
                    continue;
                }
                throw new BgControlException(BgControlException.BILLVALUEERROR, new Object[]{param.getBillNumber(), fieldAlias, fieldAlias});
            }
            param.setDimItemNumber(dimNumbers.toString());
            param.setDimItemName(dimName.toString());
        }
    }

    private BigDecimal calRequestAmount(Object value, Object object) {
        return (BigDecimal)value;
    }

    private Object getValue(Map fieldValueMap, String oneCombin) {
        if (StringUtils.isEmpty((String)oneCombin)) {
            return null;
        }
        String prop = BgControlUtils.getField(BgControlUtils.splitField(oneCombin));
        return fieldValueMap.get(prop);
    }

    private Object[] getValues(Map fieldValueMap, String oneCombin) {
        if (StringUtils.isEmpty((String)oneCombin)) {
            return null;
        }
        Object[] objs = new Object[2];
        String prop = BgControlUtils.getField(BgControlUtils.splitField(oneCombin));
        objs[0] = fieldValueMap.get(prop);
        String propName = BgControlUtils.getFieldName(prop);
        objs[1] = fieldValueMap.get(propName);
        return objs;
    }

    private String[] getRuleFields(Object[] ruleParam, boolean isContainDefalut) {
        HashSet<String> fields = new HashSet<String>();
        if (isContainDefalut) {
            fields.add(BgControlConstants.PROP_ID);
            fields.add(BgControlConstants.PROP_NUMBER);
        }
        this.getRuleFields(ruleParam, fields, 0);
        this.getRuleFields(ruleParam, fields, 2);
        this.getRuleFields(ruleParam, fields, 4);
        this.getRuleFields(ruleParam, fields, 7);
        this.getRuleFields(ruleParam, fields, 10);
        this.getRuleFields(ruleParam, fields, 12);
        this.getRuleFields(ruleParam, fields, 15);
        for (String field : fields) {
            if (field.contains("entries.assistRecords.")) {
                fields.add("entries.assistRecords.id");
                break;
            }
            if (field.contains("entries.")) {
                fields.add("entries.id");
                break;
            }
            if (!field.contains("entrys.")) continue;
            fields.add("entrys.id");
            break;
        }
        return fields.toArray(new String[fields.size()]);
    }

    private void getRuleFields(Object[] ruleParam, Set<String> fields, int index) {
        String rule = (String)ruleParam[index];
        String[] combin = BgControlUtils.splitCombin(rule);
        if (combin != null) {
            String field = null;
            String fieldName = null;
            for (int i = 0; i < combin.length; ++i) {
                field = BgControlUtils.getField(BgControlUtils.splitField(combin[i]));
                fields.add(BgControlUtils.checkFieldValue(field));
                fieldName = BgControlUtils.getFieldName(field);
                if (fieldName == null) continue;
                fields.add(fieldName);
            }
        }
    }

    private Object[] getRuleParam(BgControlRuleInfo rule) {
        Object[] ruleParam = new Object[17];
        ruleParam[0] = rule.getOrgUnit();
        ruleParam[1] = rule.getOrgUnitAlias();
        String dimItemStr = rule.getDimItem();
        if (dimItemStr.indexOf("entries.assistRecords.assGrp.generalAssActType") != -1) {
            String[] tmpStrs = dimItemStr.split("\\|");
            if (tmpStrs != null && tmpStrs.length > 0) {
                int in = tmpStrs.length;
                for (int i = 0; i < in; ++i) {
                    if (tmpStrs[i].indexOf("entries.assistRecords.assGrp.generalAssActType") == -1) continue;
                    tmpStrs[i] = tmpStrs[i].replaceAll(".number", ".longNumber");
                }
                String tmpStr = tmpStrs[0];
                int in2 = tmpStrs.length;
                for (int i = 1; i < in2; ++i) {
                    tmpStr = tmpStr + "|" + tmpStrs[i];
                }
                ruleParam[2] = tmpStr;
            }
        } else {
            ruleParam[2] = dimItemStr;
        }
        ruleParam[3] = rule.getDimItemAlias();
        ruleParam[4] = rule.getCurrency();
        ruleParam[5] = rule.getCurrencyAlias();
        ruleParam[6] = rule.getBgElementNumber();
        ruleParam[7] = rule.getBizDate();
        ruleParam[8] = rule.getBizDateAlias();
        ruleParam[9] = BgPeriodEnum.getEnum((int)rule.getPeriodType());
        ruleParam[10] = rule.getRequestAmount();
        ruleParam[11] = rule.getRequestAmountAlias();
        ruleParam[12] = rule.getRequestAmountEx();
        ruleParam[13] = rule.getRuleCondition();
        ruleParam[14] = rule.getRuleConditionAlias();
        ruleParam[15] = null;
        ruleParam[16] = rule.getMaskString();
        int limit = rule.getLimitValue().getValue();
        if (1 == limit || 2 == limit) {
            ruleParam[15] = BgControlConstants.VOUCHER_ENTRY_DC;
        }
        return ruleParam;
    }

    private BigDecimal calcReqAmount(BigDecimal reqAmount, IRowSet rst, BillOQLInfo billOQL) throws BOSException, EASBizException {
        if (reqAmount == null) {
            reqAmount = BgControlConstants.ZERO;
        }
        if (StringUtils.isEmpty((String)billOQL.getField().getRequestEx())) {
            return reqAmount;
        }
        HashMap<String, BigDecimal> valueMap = new HashMap<String, BigDecimal>();
        Object result = null;
        String expression = billOQL.getField().getRequestEx().replaceAll("\\.", "\\_");
        if (billOQL.getReqExtFields() == null) {
            result = new Interpreter().evalExpr(expression, valueMap);
        } else {
            String field = null;
            BigDecimal fieldVal = null;
            int in = billOQL.getReqExtFields().length;
            for (int i = 0; i < in; ++i) {
                field = billOQL.getReqExtFields()[i];
                try {
                    fieldVal = rst.getBigDecimal(billOQL.getFieldIndex().get(field).intValue());
                    valueMap.put(field.replaceAll("\\.", "\\_"), fieldVal);
                    continue;
                }
                catch (SQLException ex) {
                    logger.error((Object)("calcReqAmount " + field + " Error:"), (Throwable)ex);
                }
            }
            result = new Interpreter().evalExpr(expression, valueMap);
        }
        if (result instanceof BigDecimal) {
            reqAmount = reqAmount.multiply((BigDecimal)result);
        } else if (result instanceof Number) {
            reqAmount = reqAmount.multiply(new BigDecimal(result.toString()));
        }
        return reqAmount;
    }

    private void mergeControlParam(List<BgControlParam> params, Map<String, BgControlParam> keyParams, BgControlParam param) {
        if (params == null || keyParams == null || param == null) {
            return;
        }
        String key = param.getControlParamKey();
        if (!StringUtils.isEmpty((String)key)) {
            if (keyParams.containsKey(key)) {
                BgControlParam tmpParam = keyParams.get(key);
                tmpParam.getReqAmounts().add(param.getReqAmount());
                tmpParam.setReqAmount(tmpParam.getReqAmount().add(param.getReqAmount()));
                if (!StringUtils.isEmpty((String)param.getAssistRecordsId())) {
                    tmpParam.getAssistRecords().add(param.getAssistRecordsId());
                }
                if (!StringUtils.isEmpty((String)param.getBillEntryId())) {
                    tmpParam.getBillEntryIds().add(param.getBillEntryId());
                }
            } else {
                param.getReqAmounts().add(param.getReqAmount());
                if (!StringUtils.isEmpty((String)param.getAssistRecordsId())) {
                    param.getAssistRecords().add(param.getAssistRecordsId());
                }
                if (!StringUtils.isEmpty((String)param.getBillEntryId())) {
                    param.getBillEntryIds().add(param.getBillEntryId());
                }
                keyParams.put(key, param);
                params.add(param);
            }
        }
    }

    protected void fillBizDate(Context ctx, Connection conn, List<BgControlParam> params, boolean isALarm) throws EASBizException {
        if (params == null || params.isEmpty()) {
            return;
        }
        ArrayList<String> bgPeriodNums = new ArrayList<String>();
        Timestamp time = new Timestamp(System.currentTimeMillis());
        for (BgControlParam param : params) {
            bgPeriodNums.add(param.getBgPeriodNumber());
        }
        Map bgPeriodMap = MbgDataHelper.getBgPeriodInfoMap((Connection)conn, bgPeriodNums);
        for (BgControlParam param : params) {
            if (isALarm) {
                param.setBizDate(time);
                continue;
            }
            if (bgPeriodMap.containsKey(param.getBgPeriodNumber())) {
                param.setBizDate(new Timestamp(((BgPeriodInfo)bgPeriodMap.get(param.getBgPeriodNumber())).getEndDate().getTime()));
                continue;
            }
            param.setBizDate(time);
        }
    }

    protected void fillBgPeriod(Context ctx, Connection conn, BgControlSchemeInfo ctrlScheme, List<BgControlParam> params) throws BOSException {
        if (params == null || params.isEmpty() || ctrlScheme == null) {
            return;
        }
        this.parsePeriodMap(ctrlScheme, params);
        this.queyNoMapPeriod(ctx, conn, params);
    }

    protected void fillBgPeriod(Context ctx, Connection conn, BgControlParam param) throws EASBizException {
        if (ctx == null || conn == null || param == null) {
            return;
        }
        BgPeriodInfo bgPeriod = null;
        String key = param.getBgPeriodGroup().getNumber() + "!" + param.getBgPeriodType() + "!" + param.getBizDate().getTime();
        if (this.getBgPeriodMap().containsKey(key)) {
            bgPeriod = this.getBgPeriodMap().get(key);
        } else if ((bgPeriod = this.queryBgPeriod(ctx, conn, param, bgPeriod, param.getBgPeriodType())) != null) {
            this.getBgPeriodMap().put(key, bgPeriod);
        }
        if (bgPeriod != null) {
            param.setBgPeriodId(bgPeriod.getId().toString());
            param.setBgPeriodName(bgPeriod.getName());
            param.setBgPeriodNumber(bgPeriod.getNumber());
        }
        String realKey = param.getBgPeriodGroup().getNumber() + "!" + param.getBgRealPeriodType() + "!" + param.getBizDate().getTime();
        if (this.getBgPeriodMap().containsKey(realKey)) {
            bgPeriod = this.getBgPeriodMap().get(realKey);
        } else if ((bgPeriod = this.queryBgPeriod(ctx, conn, param, bgPeriod, param.getBgRealPeriodType())) != null) {
            this.getBgPeriodMap().put(realKey, bgPeriod);
        }
        if (bgPeriod != null) {
            param.setBgRealPeriodId(bgPeriod.getId().toString());
            param.setBgRealPeriodNumber(bgPeriod.getNumber());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BgPeriodInfo queryBgPeriod(Context ctx, Connection conn, BgControlParam param, BgPeriodInfo bgPeriod, int bgPeriodType) throws BgControlException {
        IRowSet rst = null;
        try {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("id");
            sic.add("name");
            sic.add("number");
            sic.add("level");
            sic.add("isLeaf");
            sic.add("longnumber");
            sic.add("fiscalYear");
            sic.add("year");
            sic.add("halfYear");
            sic.add("quarter");
            sic.add("month");
            sic.add("tenday");
            sic.add("yearWeek");
            sic.add("mothWeek");
            sic.add("day");
            sic.add("selfDefined");
            sic.add("creator.id");
            sic.add("creator.number");
            sic.add("creator.name");
            sic.add("parent.id");
            sic.add("createTime");
            sic.add("startYear");
            sic.add("endYear");
            sic.add("startMonth");
            sic.add("belongYear");
            sic.add("description");
            sic.add("selfDefineRule");
            sic.add("spinnerDay");
            sic.sort("createTime");
            BgPeriodTypeInfo bgPeriodTypeInfo = BgPeriodTypeFactory.getLocalInstance((Context)ctx).getBgPeriodTypeInfo((IObjectPK)new ObjectUuidPK(param.getBgPeriodGroup().getId()), sic);
            boolean onlySelfDefinedPeriod = BgNPeriodHelper.isOnlySelfDefinedPeriod((BgPeriodTypeInfo)bgPeriodTypeInfo);
            rst = onlySelfDefinedPeriod ? BgDBUtils.executeQuery((Connection)conn, (String)("select FBgPeriodID, FNumber, FName_" + ctx.getLocale() + " name,FPeriodType, FBeginDate, FEndDate from T_MBG_BgPeriodDisp where FTypeId = ?  AND FBeginDate <= ? AND FEndDate >= ? and FPeriodType!=8"), (Object[])new Object[]{param.getBgPeriodGroup().getId().toString(), param.getBizDate(), param.getBizDate()}) : BgDBUtils.executeQuery((Connection)conn, (String)("select TOP 1 FBgPeriodID, FNumber, FName_" + ctx.getLocale() + " name,FPeriodType,FBeginDate, FEndDate from T_MBG_BgPeriodDisp where FTypeId = ? and FPeriodType = ? AND FBeginDate <= ? AND FEndDate >= ?"), (Object[])new Object[]{param.getBgPeriodGroup().getId().toString(), bgPeriodType, param.getBizDate(), param.getBizDate()});
            JdbcRowSet result = (JdbcRowSet)rst;
            if (result.size() > 0) {
                while (result.next()) {
                    if (result.size() > 1 && bgPeriodType != result.getInt("FPeriodType")) continue;
                    bgPeriod = new BgPeriodInfo();
                    bgPeriod.setId(BOSUuid.read((String)result.getString("FBgPeriodID")));
                    bgPeriod.setNumber(result.getString("FNumber"));
                    bgPeriod.setName(result.getString("name"));
                    bgPeriod.setBeginDate((Date)result.getTimestamp("FBeginDate"));
                    bgPeriod.setEndDate((Date)result.getTimestamp("FEndDate"));
                }
            } else {
                throw new BgControlException(BgControlException.NOFOUNDBGPERIOD);
            }
            SQLUtils.cleanup((ResultSet)rst);
        }
        catch (Exception ex) {
            if (ex instanceof BgControlException) {
                throw (BgControlException)((Object)ex);
            }
            logger.error((Object)"fillBgPeriod Error:", (Throwable)ex);
        }
        finally {
            SQLUtils.cleanup(rst);
        }
        return bgPeriod;
    }

    protected void queyNoMapPeriod(Context ctx, Connection conn, List<BgControlParam> params) throws BOSException {
        block18: {
            BgPeriodInfo bgPeriod;
            BgPeriodCollection periodCol;
            if (ctx == null || params == null || params.isEmpty()) {
                return;
            }
            String periodKey2 = null;
            String periodTypeId = null;
            String[] tmpStrs = null;
            Integer periodType = null;
            HashMap periodMap = new HashMap();
            for (BgControlParam param : params) {
                Set<Timestamp> dates;
                if (!StringUtils.isEmpty((String)param.getBgPeriodNumber())) continue;
                periodKey2 = param.getBgPeriodGroup().getId() + "_" + param.getBgPeriodType();
                if (periodMap.containsKey(periodKey2)) {
                    dates = (Set)periodMap.get(periodKey2);
                } else {
                    dates = new HashSet();
                    periodMap.put(periodKey2, dates);
                }
                dates.add(param.getBizDate());
            }
            if (periodMap.isEmpty()) break block18;
            HashMap<String, BgPeriodCollection> periodInfos = new HashMap<String, BgPeriodCollection>();
            PreparedStatement pstmt = null;
            ResultSet res = null;
            java.sql.Date now = new java.sql.Date(System.currentTimeMillis());
            int batchCount = 15;
            try {
                StringBuffer sql = new StringBuffer();
                sql.append("select FBgPeriodID, FNumber, FName_" + ctx.getLocale() + " name, FBeginDate, FEndDate from T_MBG_BgPeriodDisp where FTypeId = ? and FPeriodType = ? AND (");
                for (int i = 0; i < batchCount; ++i) {
                    if (i != 0) {
                        sql.append(" OR ");
                    }
                    sql.append("(FBeginDate <= ? AND FEndDate >= ?)");
                }
                sql.append(")");
                pstmt = conn.prepareStatement(sql.toString());
                for (String periodKey2 : periodMap.keySet()) {
                    tmpStrs = periodKey2.split("_");
                    periodTypeId = tmpStrs[0];
                    periodType = new Integer(tmpStrs[1]);
                    Object[] ds = ((Set)periodMap.get(periodKey2)).toArray();
                    periodCol = new BgPeriodCollection();
                    periodInfos.put(periodKey2, periodCol);
                    int loopCount = MbgSqlHelper.getBatchCount((int)ds.length, (int)batchCount);
                    for (int i = 0; i < loopCount; ++i) {
                        pstmt.setString(1, periodTypeId);
                        pstmt.setInt(2, periodType);
                        for (int j = 0; j < batchCount; ++j) {
                            int index = i * batchCount + j;
                            java.sql.Date d = null;
                            d = index >= ds.length ? now : new java.sql.Date(((Date)ds[index]).getTime());
                            pstmt.setDate(j * 2 + 3, d);
                            pstmt.setDate(j * 2 + 4, d);
                        }
                        res = pstmt.executeQuery();
                        while (res.next()) {
                            bgPeriod = new BgPeriodInfo();
                            bgPeriod.setId(BOSUuid.read((String)res.getString("FBgPeriodID")));
                            bgPeriod.setNumber(res.getString("fnumber"));
                            bgPeriod.setBeginDate((Date)res.getDate("FBeginDate"));
                            bgPeriod.setName(res.getString("name"));
                            bgPeriod.setEndDate(BgNPeriodHelper.getDayEnd((Date)res.getDate("FEndDate")));
                            periodCol.add(bgPeriod);
                        }
                        SQLUtils.cleanup((ResultSet)res);
                    }
                }
            }
            catch (SQLException e) {
                try {
                    logger.error((Object)"", (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(res, pstmt);
                    throw throwable;
                }
            }
            SQLUtils.cleanup(res, (Statement)pstmt);
            block10: for (BgControlParam param : params) {
                if (!StringUtils.isEmpty((String)param.getBgPeriodNumber()) || (periodCol = (BgPeriodCollection)periodInfos.get(periodKey2 = param.getBgPeriodGroup().getId() + "_" + param.getBgPeriodType())) == null || periodCol.isEmpty()) continue;
                for (int i = 0; i < periodCol.size(); ++i) {
                    bgPeriod = periodCol.get(i);
                    if (param.getBizDate().before(bgPeriod.getBeginDate()) || param.getBizDate().after(bgPeriod.getEndDate())) continue;
                    if (periodType != null && 8 == periodType) {
                        if (!StringUtils.isEmpty((String)param.getBgPeriodNumber())) {
                            logger.error((Object)("fillPeriod Error(bgPeriodRepeat):" + param.getBizDate() + "(" + periodType + ")"));
                            param.setBgPeriodNumber(null);
                            continue block10;
                        }
                        param.setBgPeriodNumber(bgPeriod.getNumber());
                        param.setBgPeriodId(bgPeriod.getId().toString());
                        param.setBgPeriodName(bgPeriod.getName());
                        continue;
                    }
                    param.setBgPeriodNumber(bgPeriod.getNumber());
                    param.setBgPeriodId(bgPeriod.getId().toString());
                    param.setBgPeriodName(bgPeriod.getName());
                    continue block10;
                }
            }
        }
    }

    protected void parsePeriodMap(BgControlSchemeInfo ctrlScheme, List<BgControlParam> params) throws BOSException {
    }

    protected void fillElement(Context ctx, List<BgControlParam> params) throws BOSException {
        int i;
        if (ctx == null || params == null || params.isEmpty()) {
            return;
        }
        HashMap<String, BgElementInfo> elementMap = BgDimCacheUtils.loadObject((Context)ctx, (String)"BudgetDimDataCache-Element");
        if (elementMap == null) {
            elementMap = new HashMap<String, BgElementInfo>();
        }
        HashSet<String> bgEleNumbers = new HashSet<String>();
        for (i = 0; i < params.size(); ++i) {
            if (params.get(i).getBgElement() == null || elementMap.containsKey(params.get(i).getBgElement().getNumber())) continue;
            bgEleNumbers.add(params.get(i).getBgElement().getNumber());
        }
        if (!bgEleNumbers.isEmpty()) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", bgEleNumbers, CompareType.INCLUDE));
            view.setFilter(filter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("id");
            sic.add("number");
            sic.add("name");
            view.getSelector().addObjectCollection((IObjectCollection)sic);
            BgElementInfo element = null;
            BgElementCollection colls = BgElementFactory.getLocalInstance((Context)ctx).getBgElementCollection(view);
            int in = colls.size();
            for (int i2 = 0; i2 < in; ++i2) {
                element = colls.get(i2);
                elementMap.put(element.getNumber(), element);
            }
            BgDimCacheUtils.saveObject((Context)ctx, (String)"BudgetDimDataCache-Element", elementMap);
        }
        int in = params.size();
        for (i = 0; i < in; ++i) {
            if (params.get(i).getBgElement() == null || !elementMap.containsKey(params.get(i).getBgElement().getNumber())) continue;
            params.get(i).setBgElement((BgElementInfo)elementMap.get(params.get(i).getBgElement().getNumber()));
        }
    }

    protected void fillScenario(Context ctx, List<BgControlParam> params) throws BOSException {
        int i;
        if (ctx == null || params == null || params.isEmpty()) {
            return;
        }
        HashMap scenarioMap = BgDimCacheUtils.loadObject((Context)ctx, (String)"BudgetDimDataCache-Scenario");
        if (scenarioMap == null) {
            scenarioMap = new HashMap();
        }
        BgControlParam param = null;
        HashSet<String> scenNums = new HashSet<String>();
        for (i = 0; i < params.size(); ++i) {
            param = params.get(i);
            if (param.getBgScenario() != null && !scenarioMap.containsKey(param.getBgScenario().getNumber())) {
                scenNums.add(param.getBgScenario().getNumber());
            }
            if (param.getAcScenario() == null || scenarioMap.containsKey(param.getAcScenario().getNumber())) continue;
            scenNums.add(param.getAcScenario().getNumber());
        }
        if (!scenNums.isEmpty()) {
            Map bgScenarioObjMap = BgScenarioHelper.getScenariooObjMap((Context)ctx);
            Map.Entry entry2 = null;
            for (Map.Entry entry2 : bgScenarioObjMap.entrySet()) {
                if (scenarioMap.containsKey(entry2.getKey())) continue;
                scenarioMap.put(entry2.getKey(), entry2.getValue());
            }
            BgDimCacheUtils.saveObject((Context)ctx, (String)"BudgetDimDataCache-Scenario", scenarioMap);
        }
        int in = params.size();
        for (i = 0; i < in; ++i) {
            param = params.get(i);
            if (param.getBgScenario() != null && scenarioMap.containsKey(param.getBgScenario().getNumber())) {
                param.setBgScenario((BgScenarioInfo)scenarioMap.get(param.getBgScenario().getNumber()));
            }
            if (param.getAcScenario() == null || !scenarioMap.containsKey(param.getAcScenario().getNumber())) continue;
            param.setAcScenario((BgScenarioInfo)scenarioMap.get(param.getAcScenario().getNumber()));
        }
    }

    protected void fillOrg(Context ctx, Connection conn, List<BgControlParam> params) throws BOSException {
        if (ctx == null || params == null || params.isEmpty()) {
            return;
        }
        HashSet<String> orgNumbers = new HashSet<String>();
        for (BgControlParam param : params) {
            if (param.getOrgUnit() == null || StringUtils.isEmpty((String)param.getOrgUnit().getNumber())) continue;
            orgNumbers.add(param.getOrgUnit().getNumber());
        }
        HashMap<String, FullOrgUnitInfo> orgMap = new HashMap<String, FullOrgUnitInfo>();
        PreparedStatement pstmt = null;
        ResultSet res = null;
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("select fid, fnumber, fname_" + ctx.getLocale() + " name,fdisplayName_" + ctx.getLocale() + " displayName from T_ORG_BaseUnit where fnumber in(");
            MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(")");
            pstmt = conn.prepareStatement(sql.toString());
            Object[] ps = orgNumbers.toArray();
            int loopCount = MbgSqlHelper.getBatchCount((int)ps.length);
            for (int i = 0; i < loopCount; ++i) {
                MbgSqlHelper.setParam4Batch((PreparedStatement)pstmt, (int)i, (int)50, (Object[])ps);
                res = pstmt.executeQuery();
                while (res.next()) {
                    FullOrgUnitInfo orgUnit = new FullOrgUnitInfo();
                    orgUnit.setId(BOSUuid.read((String)res.getString("fid")));
                    orgUnit.setNumber(res.getString("fnumber"));
                    orgUnit.setName(res.getString("name"));
                    orgUnit.setDisplayName(res.getString("displayName"));
                    orgMap.put(orgUnit.getNumber(), orgUnit);
                }
                SQLUtils.cleanup((ResultSet)res);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"fillOrg Sql Error:", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(res, pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup(res, (Statement)pstmt);
        for (BgControlParam param : params) {
            if (param.getOrgUnit() == null || !orgMap.containsKey(param.getOrgUnit().getNumber())) continue;
            param.setOrgUnit((OrgUnitInfo)((FullOrgUnitInfo)orgMap.get(param.getOrgUnit().getNumber())));
            param.setReqOrgUnit(param.getOrgUnit());
        }
    }

    protected void fillCurrency(Context ctx, List<BgControlParam> params) throws BOSException {
        int i;
        if (ctx == null || params == null || params.isEmpty()) {
            return;
        }
        HashMap<String, CurrencyInfo> currencyMap = BgDimCacheUtils.loadObject((Context)ctx, (String)"BudgetDimDataCache-Currency");
        if (currencyMap == null) {
            currencyMap = new HashMap<String, CurrencyInfo>();
        }
        HashSet<String> currNumbers = new HashSet<String>();
        for (i = 0; i < params.size(); ++i) {
            if (params.get(i).getCurrency() == null || currencyMap.containsKey(params.get(i).getCurrency().getNumber())) continue;
            currNumbers.add(params.get(i).getCurrency().getNumber());
        }
        if (!currNumbers.isEmpty()) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", currNumbers, CompareType.INCLUDE));
            view.setFilter(filter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("id");
            sic.add("number");
            sic.add("name");
            sic.add("precision");
            view.getSelector().addObjectCollection((IObjectCollection)sic);
            CurrencyInfo currency = null;
            CurrencyCollection colls = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyCollection(view);
            int in = colls.size();
            for (int i2 = 0; i2 < in; ++i2) {
                currency = colls.get(i2);
                currencyMap.put(currency.getNumber(), currency);
            }
            BgDimCacheUtils.saveObject((Context)ctx, (String)"BudgetDimDataCache-Currency", currencyMap);
        }
        int in = params.size();
        for (i = 0; i < in; ++i) {
            if (params.get(i).getCurrency() == null || !currencyMap.containsKey(params.get(i).getCurrency().getNumber())) continue;
            params.get(i).setCurrency((CurrencyInfo)currencyMap.get(params.get(i).getCurrency().getNumber()));
        }
    }

    private void fillDimensionMember(Context ctx, BgControlSchemeInfo controlScheme, List<BgControlParam> params) throws EASBizException, BOSException {
        if (ctx == null || params == null || params.isEmpty()) {
            return;
        }
        Map mbgDimMap = DimUtils.getDimInfoMap((Context)ctx);
        MbgDimInfo mbgDim = null;
        StringBuffer indexNumber = new StringBuffer();
        StringBuffer dimRefs = new StringBuffer();
        StringBuffer dimItemNumber = new StringBuffer();
        HashMap<String, String> refFields = new HashMap<String, String>();
        ArrayList fields = new ArrayList();
        for (BgControlParam param : params) {
            indexNumber.setLength(0);
            dimItemNumber.setLength(0);
            dimRefs.setLength(0);
            refFields.clear();
            String[] combins = DimensionFormulaHelper.splitCombinations((String)param.getDimItemNumber());
            for (int c = 0; c < combins.length; ++c) {
                String srcNumber = DimensionFormulaHelper.getSrcNumber((String)combins[c]);
                String number = DimensionFormulaHelper.getMemberNumber((String)combins[c]);
                mbgDim = (MbgDimInfo)mbgDimMap.get(srcNumber);
                refFields.put(mbgDim.getRefField(), combins[c]);
                if (!DimensionConstants.DEF_INDEX_SRCNUMBER.equals(srcNumber)) continue;
                DimensionFormulaHelper.addItem((StringBuffer)indexNumber, (String)srcNumber, (String)number);
            }
            fields.clear();
            fields.addAll(refFields.keySet());
            DimUtils.sortFields(fields);
            for (int r = 0; r < fields.size(); ++r) {
                if (dimRefs.length() > 0) {
                    dimRefs.append(",");
                }
                dimRefs.append((String)fields.get(r));
                DimensionFormulaHelper.addItem((StringBuffer)dimItemNumber, (String)((String)refFields.get(fields.get(r))));
            }
            param.setDimNumber(dimRefs.toString());
            param.setBgIndexNumber(indexNumber.toString());
            param.setDimItemNumber(dimItemNumber.toString());
        }
    }

    public List<BgControlParam> getControlParam(Context ctx, BOSUuid bgSchemeId, BOSUuid orgUnitId, List<String> formulas, IControlParameter parameter, boolean isBgExcuteAnaly, boolean isQueryOrg) throws BOSException, EASBizException {
        return this.getControlParam(ctx, bgSchemeId, orgUnitId, formulas, parameter, isBgExcuteAnaly, isQueryOrg, false);
    }

    public List<BgControlParam> getControlParam(Context ctx, BOSUuid bgSchemeId, BOSUuid orgUnitId, List<String> formulas, IControlParameter parameter, boolean isBgExcuteAnaly, boolean isQueryOrg, boolean isALarm) throws BOSException, EASBizException {
        ArrayList<BgControlParam> params = new ArrayList<BgControlParam>();
        if (ctx == null || bgSchemeId == null || formulas == null || formulas == null || parameter == null) {
            return params;
        }
        String[] keys = null;
        String[] formulaParam = null;
        String[] periods = null;
        String formula = null;
        String acScenarioNum = null;
        String period = null;
        String periodNumber = null;
        BgControlParam param = null;
        HashSet<String> tmpSet = new HashSet<String>(formulas);
        Connection conn = null;
        IRowSet res = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            BgSchemeInfo bgSchemeInfo = MbgDataHelper.getBgSchemeInfo((Connection)conn, (Locale)ctx.getLocale(), (BOSUuid)bgSchemeId);
            if (bgSchemeInfo == null) {
                ArrayList<BgControlParam> arrayList = params;
                return arrayList;
            }
            OrgUnitInfo unitInfo = null;
            if (isQueryOrg) {
                unitInfo = CostCenterOrgUnitFactory.getLocalInstance((Context)ctx).getOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgUnitId));
                if (unitInfo == null) {
                    ArrayList<BgControlParam> arrayList = params;
                    return arrayList;
                }
                String sql = "select fOrgUnitid, fnumber, fname_" + ctx.getLocale() + " name,fdisplayName_" + ctx.getLocale() + " displayName from T_MBG_BgOrgUnit where fOrgUnitid = ? and FViewID = ?  and FisVirtual = 0 ";
                BgSchemeDimensionHelper schemeHelper = new BgSchemeDimensionHelper(ctx, bgSchemeId.toString());
                res = BgDBUtils.executeQuery((Connection)conn, (String)sql, (Object[])new Object[]{orgUnitId.toString(), schemeHelper.getBgOrgViewId()});
                while (res.next()) {
                    unitInfo.setId(BOSUuid.read((String)res.getString("fOrgUnitid")));
                    unitInfo.setNumber(res.getString("fnumber"));
                    unitInfo.setName(res.getString("name"));
                    unitInfo.setDisplayName(res.getString("displayName"));
                }
            }
            Map<String, BgPeriodTypeInfo> fidPerTypeInfo = this.fillFiscalcYear(ctx);
            Map fisCalyearMap = BgPeriodDispHelper.getPeriodDispFiscalyear((Connection)conn);
            BgVersionInfo bgVersionInfo = null;
            BgScenarioInfo bgScenarioInfo = null;
            BgScenarioInfo acScenarioInfo = null;
            Map scenario = BgScenarioHelper.getScenariooObjMap((Connection)conn, (Locale)ctx.getLocale());
            for (String formulaKey : tmpSet) {
                keys = formulaKey.split("_");
                formula = keys[0];
                acScenarioNum = keys[1];
                formulaParam = BgNFSHelper.parseFormulaPara((String)formula);
                param = new BgControlParam();
                param.setOrgUnit(unitInfo);
                param.setBgSchemeInfo(bgSchemeInfo);
                bgVersionInfo = BgVersionHelper.getVersion((Context)ctx, (String)"Ve");
                param.setVersion(bgVersionInfo);
                bgScenarioInfo = (BgScenarioInfo)scenario.get(formulaParam[3]);
                param.setBgScenario(bgScenarioInfo);
                acScenarioInfo = (BgScenarioInfo)scenario.get(acScenarioNum);
                param.setAcScenario(acScenarioInfo);
                param.setDimItemNumber(formulaParam[0]);
                periodNumber = formulaParam[1];
                periods = periodNumber.replaceFirst("\\.", "!").split("!");
                period = periods[1];
                param.setBgPeriodNumber(periodNumber);
                param.setBgPeriodType(BgPeriodHelper.getBgPeriodType((String)period));
                param.setBgPeriodGroup(fidPerTypeInfo.get(periods[0]));
                param.getBgPeriodGroup().setFiscalYear(FiscalYearEnum.getEnum((int)BgPeriodDispHelper.getFiscalyear((Map)fisCalyearMap, (String)periods[0])));
                param.setFormula(formula);
                param.setBgElement(new BgElementInfo());
                param.getBgElement().setNumber(formulaParam[2]);
                param.setCurrency(new CurrencyInfo());
                param.getCurrency().setNumber(formulaParam[5]);
                param.setBgExcuteAnaly(isBgExcuteAnaly);
                params.add(param);
            }
            this.fillBizDate(ctx, conn, params, isALarm);
            this.fillCurrency(ctx, params);
            this.fillElement(ctx, params);
            this.fillDimensionMember(ctx, null, params);
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
            SQLUtils.cleanup(res);
        }
        return params;
    }

    protected Map<String, BgPeriodTypeInfo> fillFiscalcYear(Context ctx) throws BOSException {
        HashMap<String, BgPeriodTypeInfo> fidPerTypeInfo = new HashMap<String, BgPeriodTypeInfo>();
        if (ctx == null) {
            return fidPerTypeInfo;
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add("id");
        evi.getSelector().add("name");
        evi.getSelector().add("number");
        evi.getSelector().add("periodType");
        evi.setFilter(new FilterInfo());
        BgPeriodTypeCollection bgPeriodCol = BgPeriodTypeFactory.getLocalInstance((Context)ctx).getBgPeriodTypeCollection(evi);
        for (int i = 0; i < bgPeriodCol.size(); ++i) {
            fidPerTypeInfo.put(bgPeriodCol.get(i).getNumber(), bgPeriodCol.get(i));
        }
        return fidPerTypeInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void checkBizUnit(Context ctx, List<BgControlParam> params) {
        if (params == null) return;
        if (params.isEmpty()) return;
        if (BgParamNHelper.isNotBgOrgControlCheck((Context)ctx)) return;
        BgControlParam param = null;
        String orgId = null;
        ArrayList<String> orgIds = new ArrayList<String>();
        for (int i = params.size() - 1; i >= 0; --i) {
            param = params.get(i);
            if (param.getOrgUnit() == null || param.getOrgUnit().getId() == null || orgIds.contains(orgId = param.getOrgUnit().getId().toString())) continue;
            orgIds.add(orgId);
        }
        if (orgIds.isEmpty()) return;
        HashSet<String> existsOrgIds = new HashSet<String>();
        String tmpTable = null;
        Connection conn = null;
        IRowSet rst = null;
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            if (orgIds.size() == 1) {
                rst = BgDBUtils.executeQuery((Connection)conn, (String)"select distinct FOrgUnitId from T_MBG_BgOrgUnit where  FOrgUnitId = ?", (Object[])new Object[]{orgIds.get(0)});
            } else {
                tmpTable = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
                if (tmpTable != null) {
                    BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpTable + " (FID) values (?)"), new HashSet(orgIds));
                }
                rst = BgDBUtils.executeQuery((Connection)conn, (String)("select distinct  FOrgUnitId from T_MBG_BgOrgUnit where  exists (select FID from " + tmpTable + " where FID = T_MBG_BgOrgUnit.FOrgUnitId)"));
            }
            while (rst.next()) {
                existsOrgIds.add(rst.getString("FOrgUnitId"));
            }
            for (int i = params.size() - 1; i >= 0; --i) {
                param = params.get(i);
                if (param.getOrgUnit() == null || param.getOrgUnit().getId() == null || existsOrgIds.contains(orgId = param.getOrgUnit().getId().toString()) || !orgIds.contains(orgId)) continue;
                params.remove(i);
            }
            SQLUtils.cleanup((ResultSet)rst, null, (Connection)conn);
            if (pool == null) return;
            if (tmpTable == null) return;
        }
        catch (Exception ex) {
            logger.error((Object)"", (Throwable)ex);
            return;
        }
        try {
            pool.releaseTable(tmpTable);
            return;
        }
        catch (Exception i) {
            return;
        }
        finally {
            SQLUtils.cleanup(rst, null, (Connection)conn);
            if (pool != null && tmpTable != null) {
                try {
                    pool.releaseTable(tmpTable);
                }
                catch (Exception exception) {}
            }
        }
    }
}

