/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.control.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableFactory;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.base.utils.BgNPeriodHelper;
import com.kingdee.eas.ma.control.BgControlException;
import com.kingdee.eas.ma.control.BgCurrencyMappingCollection;
import com.kingdee.eas.ma.control.BgCurrencyMappingFactory;
import com.kingdee.eas.ma.control.BgCurrencyMappingInfo;
import com.kingdee.eas.ma.control.BgExchangeRateSourceEnum;
import com.kingdee.eas.ma.control.impl.models.BgControlParam;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgCurrencyMappingUtils {
    private static final Logger logger = Logger.getLogger(BgCurrencyMappingUtils.class);
    public static final String DETAIL = "DETAIL";
    public static final String EXCHANGETABLE = "EXCHANGETABLE";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void transCurrency(Context ctx, List<BgControlParam> params) throws BOSException, EASBizException {
        if (params == null || params.isEmpty()) {
            return;
        }
        HashMap<String, CompanyOrgUnitInfo> companyCacheMap = new HashMap<String, CompanyOrgUnitInfo>();
        HashMap<String, ExchangeRateInfo> exchangeRateCacheMap = new HashMap<String, ExchangeRateInfo>();
        Timestamp bizData = null;
        String companyId = null;
        OrgUnitInfo org = null;
        CurrencyInfo billCurrency = null;
        BgControlParam param = null;
        HashSet<String> currencyIds = new HashSet<String>();
        HashSet<String> currencyNums = new HashSet<String>();
        HashSet orgIds = new HashSet();
        HashSet<String> orgNums = new HashSet<String>();
        List<BgCurrencyMappingInfo> mappingLst = null;
        BgCurrencyMappingInfo mappingInfo = null;
        ExchangeRateInfo exRateInfo = null;
        BigDecimal rate = BigDecimal.ONE;
        for (int i = 0; i < params.size(); ++i) {
            param = params.get(i);
            billCurrency = param.getCurrency();
            if (billCurrency.getId() != null) {
                currencyIds.add(billCurrency.getId().toString());
            } else if (!StringUtils.isEmpty((String)billCurrency.getNumber())) {
                currencyNums.add(billCurrency.getNumber());
            }
            orgNums.add(param.getOrgUnit().getNumber());
        }
        Map<String, List<BgCurrencyMappingInfo>> mappings = BgCurrencyMappingUtils.query(ctx, orgNums, !currencyIds.isEmpty() ? currencyIds : currencyNums, !currencyIds.isEmpty() ? "id" : "number");
        if (mappings.isEmpty()) {
            return;
        }
        Map<String, OrgUnitInfo> orgNumsMap = BgCurrencyMappingUtils.getOrgNumsMap(ctx, orgNums);
        CurrencyCollection colls = BgCurrencyMappingUtils.getAllCurrencys(ctx);
        Map<String, CurrencyInfo> currencyNumsMap = BgCurrencyMappingUtils.getCurrencyNumsMap(colls);
        Map<String, CurrencyInfo> currencyIdsMap = BgCurrencyMappingUtils.getCurrencyIdsMap(colls);
        block1: for (int i = 0; i < params.size(); ++i) {
            param = params.get(i);
            if (!StringUtils.isEmpty((String)param.getOrgUnit().getNumber()) && orgNumsMap.containsKey(param.getOrgUnit().getNumber())) {
                org = orgNumsMap.get(param.getOrgUnit().getNumber());
            }
            if (!StringUtils.isEmpty((String)param.getCurrency().getNumber()) && currencyNumsMap.containsKey(param.getCurrency().getNumber())) {
                billCurrency = currencyNumsMap.get(param.getCurrency().getNumber());
            }
            bizData = param.getBizDate();
            if (org == null || billCurrency == null || billCurrency.getId() == null || mappings == null || !mappings.containsKey(billCurrency.getId().toString()) || null == (mappingLst = mappings.get(billCurrency.getId().toString())) || mappingLst.isEmpty()) continue;
            boolean hasTrans = false;
            HashSet<String> repeatCheck = new HashSet<String>();
            String repeatKey = null;
            for (int j = 0; j < mappingLst.size(); ++j) {
                FullOrgUnitInfo orgUnit;
                if (BgNPeriodHelper.getDayBegin((Date)mappingLst.get(j).getEnabledDate()).getTime() > bizData.getTime() && !mappingLst.get(j).getEnabledDate().before(bizData) || (orgUnit = mappingLst.get(j).getOrgUnit()) != null && orgUnit.getId() != null && org != null && org.getId() != null && !orgUnit.getId().toString().equals(org.getId().toString())) continue;
                mappingInfo = (BgCurrencyMappingInfo)mappingLst.get(j).clone();
                repeatKey = mappingInfo.getBgCurrency().getId().toString() + "_" + mappingInfo.getBillCurrency().getId().toString();
                if (repeatCheck.contains(repeatKey)) continue block1;
                repeatCheck.add(repeatKey);
                mappingInfo.setBillCurrency(currencyIdsMap.get(mappingInfo.getBillCurrency().getId().toString()));
                mappingInfo.setBgCurrency(currencyIdsMap.get(mappingInfo.getBgCurrency().getId().toString()));
                if (mappingInfo.getBgExchangeRateSource().equals((Object)BgExchangeRateSourceEnum.ExchangeRateTable)) {
                    if (org != null && org.getId() != null) {
                        companyId = BgCurrencyMappingUtils.getCompanyId(ctx, companyCacheMap, org.getId().toString());
                    }
                    if ((exRateInfo = BgCurrencyMappingUtils.getExRateInfo(ctx, billCurrency.getId().toString(), mappingInfo.getBgCurrency().getId().toString(), companyId, bizData, exchangeRateCacheMap)) == null) throw new BgControlException(BgControlException.NOEXRATEMATCH, new Object[]{org.getName(), mappingInfo.getBillCurrency().getName(), mappingInfo.getBgCurrency().getName(), ((CompanyOrgUnitInfo)companyCacheMap.get(org.getId().toString())).getBaseExchangeTable().getName()});
                    rate = exRateInfo.getConvertRate().setScale(exRateInfo.getPrecision());
                    hasTrans = true;
                    mappingInfo.setBgExchangeRate(rate);
                    mappingInfo.put(EXCHANGETABLE, exRateInfo.getExchangeAux().getExchangeTable().getName());
                } else if (mappingInfo.getBgExchangeRateSource().equals((Object)BgExchangeRateSourceEnum.Manually)) {
                    rate = mappingInfo.getBgExchangeRate();
                    hasTrans = true;
                }
                if (!hasTrans) continue;
                param.setCurrency(currencyIdsMap.get(mappingInfo.getBgCurrency().getId().toString()));
                BigDecimal value = param.getReqAmount().multiply(rate);
                DecimalFormat bigDecimalFormula = BgNationalFormatUIUtil.getDecimalFormat((int)param.getCurrency().getPrecision());
                String showValue = bigDecimalFormula.format(value);
                String detail = param.getReqAmount() + " * " + rate + " = " + showValue;
                param.setReqAmount(value);
                mappingInfo.put(DETAIL, detail);
                ArrayList<BigDecimal> reqAmounts = new ArrayList<BigDecimal>();
                reqAmounts.addAll(param.getReqAmounts());
                param.getReqAmounts().clear();
                for (int x = 0; x < reqAmounts.size(); ++x) {
                    param.getReqAmounts().add(((BigDecimal)reqAmounts.get(x)).multiply(rate));
                }
                param.getCurrencyMappings().add(mappingInfo);
            }
        }
        List<BgControlParam> newParams = BgCurrencyMappingUtils.mergeControlParam(params);
        if (newParams == null || newParams.isEmpty()) return;
        params.clear();
        params.addAll(newParams);
    }

    private static List<BgControlParam> mergeControlParam(List<BgControlParam> params) {
        if (params == null) {
            return params;
        }
        HashMap<String, BgControlParam> keyParams = new HashMap<String, BgControlParam>();
        String key = null;
        ArrayList<BgControlParam> newParams = new ArrayList<BgControlParam>();
        BgControlParam param = null;
        for (int i = 0; i < params.size(); ++i) {
            param = params.get(i);
            key = param.getControlParamKey();
            if (!StringUtils.isEmpty((String)key) && keyParams.containsKey(key)) {
                BgControlParam tmpParam = (BgControlParam)keyParams.get(key);
                tmpParam.getReqAmounts().add(param.getReqAmount());
                tmpParam.setReqAmount(tmpParam.getReqAmount().add(param.getReqAmount()));
                tmpParam.getCurrencyMappings().addAll(param.getCurrencyMappings());
                continue;
            }
            keyParams.put(key, param);
            newParams.add(param);
        }
        return newParams;
    }

    private static Map<String, List<BgCurrencyMappingInfo>> query(Context ctx, Set<String> orgNums, Set<String> currencys, String field) throws BOSException {
        HashMap<String, List<BgCurrencyMappingInfo>> mappings = new HashMap<String, List<BgCurrencyMappingInfo>>();
        if (!currencys.isEmpty()) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("billCurrency." + field, currencys, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.number", orgNums, CompareType.INCLUDE));
            view.setFilter(filter);
            BgCurrencyMappingCollection colls = BgCurrencyMappingFactory.getLocalInstance(ctx).getBgCurrencyMappingCollection(view);
            if (colls != null && !colls.isEmpty()) {
                BgCurrencyMappingInfo info = null;
                for (int i = 0; i < colls.size(); ++i) {
                    info = colls.get(i);
                    if (!mappings.containsKey(info.getBillCurrency().getId().toString())) {
                        mappings.put(info.getBillCurrency().getId().toString(), new ArrayList());
                    }
                    ((List)mappings.get(info.getBillCurrency().getId().toString())).add(info);
                }
                Iterator ite = mappings.keySet().iterator();
                while (ite.hasNext()) {
                    Collections.sort((List)mappings.get(ite.next()), new Comparator<BgCurrencyMappingInfo>(){

                        @Override
                        public int compare(BgCurrencyMappingInfo o1, BgCurrencyMappingInfo o2) {
                            if (o1.getEnabledDate().before(o2.getEnabledDate())) {
                                return 1;
                            }
                            return -1;
                        }
                    });
                }
            }
        }
        return mappings;
    }

    private static ExchangeRateInfo getExRateInfo(Context ctx, String srcCurrId, String destCurrId, String companyId, Date date, Map<String, ExchangeRateInfo> exchangeRateCacheMap) throws BOSException, EASBizException {
        ExchangeTableInfo baseExchangeTable;
        CompanyOrgUnitInfo companyInfo;
        CompanyOrgUnitInfo company;
        String key = companyId + "_" + srcCurrId + "_" + destCurrId + "_" + date;
        if (exchangeRateCacheMap.containsKey(key)) {
            return exchangeRateCacheMap.get(key);
        }
        CompanyOrgUnitInfo companyCommInfo = new CompanyOrgUnitInfo();
        companyCommInfo = companyId != null && !companyId.equals("") ? (company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId))) : (companyInfo = (CompanyOrgUnitInfo)ctx.get((Object)"CompanyInfo"));
        if (destCurrId == null) {
            destCurrId = companyCommInfo.getBaseCurrency().getId().toString();
        }
        if ((baseExchangeTable = companyCommInfo.getBaseExchangeTable()) == null) {
            return null;
        }
        ObjectUuidPK sourceCurrpk = new ObjectUuidPK(srcCurrId);
        ObjectUuidPK destCurrpk = new ObjectUuidPK(destCurrId);
        ObjectUuidPK exchangeTablepk = new ObjectUuidPK(baseExchangeTable.getId());
        ExchangeRateInfo exRateInfo = null;
        try {
            IExchangeRate iExchangRate = ExchangeRateFactory.getLocalInstance((Context)ctx);
            exRateInfo = iExchangRate.getExchangeRate((IObjectPK)exchangeTablepk, (IObjectPK)sourceCurrpk, (IObjectPK)destCurrpk, DateTimeUtils.truncateDate((Date)date));
            if (exRateInfo != null) {
                exchangeRateCacheMap.put(key, exRateInfo);
                if (exRateInfo.getExchangeAux().getExchangeTable() != null && StringUtils.isEmpty((String)exRateInfo.getExchangeAux().getExchangeTable().getName())) {
                    ExchangeTableInfo table = ExchangeTableFactory.getLocalInstance((Context)ctx).getExchangeTableInfo((IObjectPK)new ObjectUuidPK(exRateInfo.getExchangeAux().getExchangeTable().getId()));
                    exRateInfo.getExchangeAux().setExchangeTable(table);
                }
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        return exRateInfo;
    }

    private static String getCompanyId(Context ctx, Map<String, CompanyOrgUnitInfo> companyMap, String orgUnitId) throws BOSException {
        String companyId = null;
        if (companyMap.containsKey(orgUnitId)) {
            companyId = companyMap.get(orgUnitId).getId().toString();
        } else {
            try {
                CompanyOrgUnitInfo company = BgNFSHelper.getCompanyByOrgUnit((Context)ctx, (BOSUuid)BOSUuid.read((String)orgUnitId));
                if (company != null) {
                    companyId = company.getId().toString();
                    companyMap.put(orgUnitId, company);
                }
            }
            catch (Exception ex) {
                throw new BOSException((Throwable)ex);
            }
        }
        return companyId;
    }

    private static Map<String, CurrencyInfo> getCurrencyIdsMap(CurrencyCollection colls) throws BOSException {
        HashMap<String, CurrencyInfo> map = new HashMap<String, CurrencyInfo>();
        if (colls != null && !colls.isEmpty()) {
            for (int i = 0; i < colls.size(); ++i) {
                map.put(colls.get(i).getId().toString(), colls.get(i));
            }
        }
        return map;
    }

    private static Map<String, CurrencyInfo> getCurrencyNumsMap(CurrencyCollection colls) throws BOSException {
        HashMap<String, CurrencyInfo> map = new HashMap<String, CurrencyInfo>();
        if (colls != null && !colls.isEmpty()) {
            for (int i = 0; i < colls.size(); ++i) {
                map.put(colls.get(i).getNumber(), colls.get(i));
            }
        }
        return map;
    }

    private static CurrencyCollection getAllCurrencys(Context ctx) throws BOSException {
        return CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyCollection();
    }

    private static Map<String, OrgUnitInfo> getOrgNumsMap(Context ctx, Set<String> orgNums) throws BOSException {
        HashMap<String, OrgUnitInfo> map = new HashMap<String, OrgUnitInfo>();
        if (!orgNums.isEmpty()) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", orgNums, CompareType.INCLUDE));
            view.setFilter(filter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("id");
            sic.add("number");
            sic.add("name");
            view.getSelector().addObjectCollection((IObjectCollection)sic);
            OrgUnitCollection colls = FullOrgUnitFactory.getLocalInstance((Context)ctx).getOrgUnitCollection(view);
            if (colls != null && !colls.isEmpty()) {
                for (int i = 0; i < colls.size(); ++i) {
                    map.put(colls.get(i).getNumber(), colls.get(i));
                }
            }
        }
        return map;
    }
}

