/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.control.utils;

import com.kingdee.bos.ctrl.swing.KDComboBox;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class BizDataObject
implements Serializable {
    private static final long serialVersionUID = -5837435830687091511L;
    private String maskString = null;
    private boolean isomer = false;
    private String display = null;
    private String value = null;

    public BizDataObject() {
    }

    public BizDataObject(String display, String value, String maskString) {
        this.setDisplay(display);
        this.setValue(value);
        this.setMaskString(maskString);
    }

    public String getMaskString() {
        return this.maskString;
    }

    public void setMaskString(String maskString) {
        this.maskString = maskString;
    }

    public BizDataObject(String display, String value) {
        this.setDisplay(display);
        this.setValue(value);
    }

    public BizDataObject(String[] bizData) {
        if (bizData != null) {
            if (bizData.length < 3) {
                this.setValue(bizData[0]);
                this.setDisplay(bizData[1]);
            } else if (bizData.length == 3) {
                this.setValue(bizData[0]);
                this.setDisplay(bizData[1]);
                this.setIsomer(Boolean.valueOf(bizData[2]));
            } else if (bizData.length == 4) {
                this.setValue(bizData[0]);
                this.setDisplay(bizData[1]);
                this.setIsomer(Boolean.valueOf(bizData[3]));
            }
        }
    }

    public static List<BizDataObject> transData(List<String[]> bizDatas) {
        ArrayList<BizDataObject> tmpList = new ArrayList<BizDataObject>();
        if (bizDatas == null || bizDatas.isEmpty()) {
            return tmpList;
        }
        int in = bizDatas.size();
        for (int i = 0; i < in; ++i) {
            tmpList.add(new BizDataObject(bizDatas.get(i)));
        }
        return tmpList;
    }

    public static void selected(KDComboBox combo, String bizProp) {
        if (combo == null || bizProp == null) {
            return;
        }
        BizDataObject bizData = null;
        int in = combo.getItemCount();
        for (int i = 0; i < in; ++i) {
            bizData = (BizDataObject)combo.getItemAt(i);
            if (!bizData.getValue().equals(bizProp)) continue;
            combo.setSelectedIndex(i);
        }
    }

    public boolean isIsomer() {
        return this.isomer;
    }

    public void setIsomer(boolean isomer) {
        this.isomer = isomer;
    }

    public void setDisplay(String display) {
        this.display = display;
    }

    public String getDisplay() {
        return this.display;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        if (this.getDisplay() != null) {
            return this.getDisplay();
        }
        return this.getValue();
    }
}

