/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.control.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgPeriodTypeInfo;
import com.kingdee.eas.ma.base.FiscalYearEnum;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.BgParamNHelper;
import com.kingdee.eas.ma.control.BgControlBaseInfo;
import com.kingdee.eas.ma.control.BgControlException;
import com.kingdee.eas.ma.control.BgControlExpendEntryInfo;
import com.kingdee.eas.ma.control.BgControlExpendRuleInfo;
import com.kingdee.eas.ma.control.BgControlItemMapEntryInfo;
import com.kingdee.eas.ma.control.BgControlItemMapInfo;
import com.kingdee.eas.ma.control.BgControlNotNullBudgetEnum;
import com.kingdee.eas.ma.control.BgControlNullBudgetEnum;
import com.kingdee.eas.ma.control.BgControlRuleInfo;
import com.kingdee.eas.ma.control.BgControlSchemeCollection;
import com.kingdee.eas.ma.control.BgControlSchemeException;
import com.kingdee.eas.ma.control.BgControlSchemeFacadeFactory;
import com.kingdee.eas.ma.control.BgControlSchemeInfo;
import com.kingdee.eas.ma.control.BgCtrlLimitValueEnum;
import com.kingdee.eas.ma.control.BgCtrlValueEnum;
import com.kingdee.eas.ma.control.BgReqRuleEnum;
import com.kingdee.eas.ma.control.face.IControlParameter;
import com.kingdee.eas.ma.control.utils.BgControlIsomerUtils;
import com.kingdee.eas.ma.control.utils.BgControlUtils;
import com.kingdee.eas.ma.mbg.BgSchemeTypeInfo;
import com.kingdee.eas.ma.mbg.RptSrcTypeEnum;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.IOException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ControlSchemeUtils {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.control.utils.ControlSchemeUtils");

    private ControlSchemeUtils() {
    }

    public static ControlSchemeUtils getInstance() {
        return new ControlSchemeUtils();
    }

    public BgControlSchemeInfo queryControlScheme(Context ctx, IControlParameter parameter, String bizUnit, String OUName, boolean hasMapping, boolean hasExpand) throws BOSException, EASBizException {
        if (ctx == null || StringUtils.isEmpty((String)bizUnit) || parameter == null) {
            throw new BgControlException(BgControlException.BIZOROUIDERROR);
        }
        String bizStr = BgControlSchemeFacadeFactory.getLocalInstance(ctx).getDefaultBizUnit(bizUnit, 4);
        if (StringUtils.isEmpty((String)bizStr)) {
            throw new BgControlException(BgControlException.NOFOUNDDEFAULTBIZ);
        }
        Object bizValue = BgControlIsomerUtils.getBillBizValue(ctx, bizUnit, bizStr, parameter);
        Timestamp timestamp = this.checkDefaultBizDateValue(bizValue);
        return this.queryControlScheme(ctx, bizUnit, parameter.getOUID(), OUName, timestamp, hasMapping, hasExpand);
    }

    public BgControlSchemeInfo queryControlScheme(Context ctx, BOSUuid billId, String bizUnit, String OUID, String OUName, boolean hasMapping, boolean hasExpand) throws BOSException, EASBizException {
        if (ctx == null || StringUtils.isEmpty((String)bizUnit) || StringUtils.isEmpty((String)OUID)) {
            throw new BgControlException(BgControlException.BIZOROUIDERROR);
        }
        String bizStr = BgControlSchemeFacadeFactory.getLocalInstance(ctx).getDefaultBizUnit(bizUnit, 4);
        if (StringUtils.isEmpty((String)bizStr)) {
            throw new BgControlException(BgControlException.NOFOUNDDEFAULTBIZ);
        }
        Object bizValue = BgControlUtils.getBillBizValue(ctx, bizUnit, bizStr, billId);
        Timestamp timestamp = this.checkDefaultBizDateValue(bizValue);
        return this.queryControlScheme(ctx, bizUnit, OUID, OUName, timestamp, hasMapping, hasExpand);
    }

    public BgControlSchemeInfo queryControlScheme(Context ctx, IObjectValue model, String bizUnit, String OUID, String OUName, boolean hasMapping, boolean hasExpand) throws BOSException, EASBizException {
        if (ctx == null || StringUtils.isEmpty((String)bizUnit) || StringUtils.isEmpty((String)OUID)) {
            throw new BgControlException(BgControlException.BIZOROUIDERROR);
        }
        String bizStr = BgControlSchemeFacadeFactory.getLocalInstance(ctx).getDefaultBizUnit(bizUnit, 4);
        if (StringUtils.isEmpty((String)bizStr)) {
            throw new BgControlException(BgControlException.NOFOUNDDEFAULTBIZ);
        }
        Object bizValue = BgControlUtils.getBillBizValue(ctx, bizStr, model);
        Timestamp timestamp = this.checkDefaultBizDateValue(bizValue);
        return this.queryControlScheme(ctx, bizUnit, OUID, OUName, timestamp, hasMapping, hasExpand);
    }

    private Timestamp checkDefaultBizDateValue(Object bizValue) throws EASBizException {
        if (bizValue == null) {
            throw new BgControlException(BgControlException.NOFOUNDDEFAULTBIZ);
        }
        Timestamp timestamp = null;
        if (bizValue instanceof Timestamp) {
            timestamp = (Timestamp)bizValue;
        } else if (bizValue instanceof Date) {
            timestamp = new Timestamp(((Date)bizValue).getTime());
        }
        if (timestamp == null) {
            throw new BgControlException(BgControlException.NOFOUNDDEFAULTBIZ);
        }
        return timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BgControlSchemeInfo queryControlScheme(Context ctx, String bizUnit, String OUID, String OUName, Timestamp timestamp, boolean hasMapping, boolean hasExpand) throws BOSException, EASBizException {
        String tmpStr = null;
        StringBuffer sql = new StringBuffer();
        BgControlSchemeCollection colls = new BgControlSchemeCollection();
        BgControlSchemeInfo schemeInfo = null;
        BgControlRuleInfo rule = null;
        BgControlItemMapInfo itemMap = null;
        BgControlItemMapEntryInfo itemEntry = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        PreparedStatement pbase = null;
        ResultSet rst = null;
        ResultSet rbase = null;
        boolean isShareItem = BgParamNHelper.isShareBizItem((Context)ctx);
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            pstmt = conn.prepareStatement("select FID, FNumber, FBizSystem, FBegindate, FEnddate, FBaseId, FRootId from T_MBG_BgControlScheme where FOrgUnitId = ? and FBizUnit = ? and FisValid = ? and FBegindate <= ? and FEnddate >= ? and FisSysDefault = ?");
            pstmt.setString(1, OUID);
            pstmt.setString(2, bizUnit);
            pstmt.setBoolean(3, Boolean.TRUE);
            pstmt.setTimestamp(4, timestamp);
            pstmt.setTimestamp(5, timestamp);
            pstmt.setBoolean(6, Boolean.FALSE);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                schemeInfo = new BgControlSchemeInfo();
                schemeInfo.setId(BOSUuid.read((String)rst.getString("FID")));
                schemeInfo.setNumber(rst.getString("FNumber"));
                schemeInfo.setBizSystem(rst.getString("FBizSystem"));
                schemeInfo.setBizUnit(bizUnit);
                schemeInfo.setBeginDate(rst.getTimestamp("FBegindate"));
                schemeInfo.setEndDate(rst.getTimestamp("FEnddate"));
                schemeInfo.setOrgUnit(new CostCenterOrgUnitInfo());
                schemeInfo.getOrgUnit().setId(BOSUuid.read((String)OUID));
                schemeInfo.setBase(new BgControlBaseInfo());
                schemeInfo.getBase().setId(BOSUuid.read((String)rst.getString("FBaseId")));
                schemeInfo.setRootID(BOSUuid.read((String)rst.getString("FRootId")));
                try {
                    pbase = conn.prepareStatement("select FIsAllowAccess, FIsCtrlOfEmpty, FNullBudget, FNotNullBudget from T_MBG_BgControlBase where FID = ?");
                    pbase.setString(1, schemeInfo.getBase().getId().toString());
                    rbase = pbase.executeQuery();
                    if (rbase.next()) {
                        schemeInfo.getBase().setIsAllowAccess(rbase.getBoolean("FIsAllowAccess"));
                        schemeInfo.getBase().setIsCtrlOfEmpty(rbase.getBoolean("FIsCtrlOfEmpty"));
                        schemeInfo.getBase().setNullBudget(BgControlNullBudgetEnum.getEnum(rbase.getInt("FNullBudget")));
                        schemeInfo.getBase().setNotNullBudget(BgControlNotNullBudgetEnum.getEnum(rbase.getInt("FNotNullBudget")));
                    }
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rbase, (Statement)pbase);
                    throw throwable;
                }
                SQLUtils.cleanup((ResultSet)rbase, (Statement)pbase);
                sql = new StringBuffer();
                sql.append("select t.FID, t.FSEQ, t.FOrgUnit, t.FOrgUnitAlias, t.FDimItem, t.FDimItemAlias, t.FCurrency, t.FDimensionGroup, t.FCurrencyAlias, t.FPeriodType,t.FRealPeriodType, t.FBizDate, t.FBizDateAlias, t.FBgElementNumber, t.FScenarioNumber, t.FAcScenarioNumber, t.FRequestAmount, t.FRequestAmountAlias, t.FRequestAmountEx, t.FRuleCondition, t.FRuleConditionAlias, t.FLimitValue, t.FBgSchemeTypeId, st.FName_" + ctx.getLocale() + " AS FSTName, st.FSchemeType, st.FNumber AS FSTNumber,t.FBgPeriodTypeId, pt.FiscalYear, pt.FName_" + ctx.getLocale() + " AS FPTName, pt.FNumber AS FPTNumber  from T_MBG_BgControlRule t left join T_MBG_BgSchemeType st on t.FBgSchemeTypeId = st.FID left join T_MBG_BgPeriodType pt on t.FBgPeriodTypeId = pt.FID where t.FSchemeID = ?");
                try {
                    pbase = conn.prepareStatement(sql.toString());
                    pbase.setString(1, schemeInfo.getId().toString());
                    rbase = pbase.executeQuery();
                    while (rbase.next()) {
                        rule = new BgControlRuleInfo();
                        rule.setId(BOSUuid.read((String)rbase.getString("FID")));
                        rule.setSeq(rbase.getInt("FSEQ"));
                        rule.setOrgUnit(rbase.getString("FOrgUnit"));
                        rule.setOrgUnitAlias(rbase.getString("FOrgUnitAlias"));
                        rule.setDimItem(rbase.getString("FDimItem"));
                        rule.setDimItemAlias(rbase.getString("FDimItemAlias"));
                        rule.setCurrency(rbase.getString("FCurrency"));
                        rule.setCurrencyAlias(rbase.getString("FCurrencyAlias"));
                        rule.setPeriodType(rbase.getInt("FPeriodType"));
                        rule.setRealPeriodType(rbase.getInt("FRealPeriodType"));
                        rule.setBizDate(rbase.getString("FBizDate"));
                        rule.setBizDateAlias(rbase.getString("FBizDateAlias"));
                        rule.setBgElementNumber(rbase.getString("FBgElementNumber"));
                        rule.setBgScenarioNumber(rbase.getString("FScenarioNumber"));
                        rule.setAcScenarioNumber(rbase.getString("FAcScenarioNumber"));
                        rule.setRequestAmount(rbase.getString("FRequestAmount"));
                        rule.setRequestAmountAlias(rbase.getString("FRequestAmountAlias"));
                        rule.setRequestAmountEx(rbase.getString("FRequestAmountEx"));
                        rule.setRuleCondition(rbase.getString("FRuleCondition"));
                        rule.setRuleConditionAlias(rbase.getString("FRuleConditionAlias"));
                        rule.setDimensionGroup(rbase.getInt("FDimensionGroup"));
                        rule.setLimitValue(BgCtrlLimitValueEnum.getEnum(rbase.getInt("FLimitValue")));
                        if (rbase.getString("FBgSchemeTypeId") == null) {
                            throw new BgControlException(BgControlException.NOFOUNDBGSCHEMETYPE, new Object[]{OUName, schemeInfo.getNumber()});
                        }
                        rule.setBgSchemeType(new BgSchemeTypeInfo());
                        rule.getBgSchemeType().setId(BOSUuid.read((String)rbase.getString("FBgSchemeTypeId")));
                        rule.getBgSchemeType().setName(rbase.getString("FSTName"));
                        rule.getBgSchemeType().setNumber(rbase.getString("FSTNumber"));
                        rule.getBgSchemeType().setSchemeType(RptSrcTypeEnum.getEnum((int)rbase.getInt("fschemetype")));
                        if (rbase.getString("FBgPeriodTypeId") == null) {
                            throw new BgControlException(BgControlException.NOFOUNDBGPERIODTYPE, new Object[]{OUName, schemeInfo.getNumber()});
                        }
                        rule.setBgPeriodType(new BgPeriodTypeInfo());
                        rule.getBgPeriodType().setId(BOSUuid.read((String)rbase.getString("FBgPeriodTypeId")));
                        rule.getBgPeriodType().setFiscalYear(FiscalYearEnum.getEnum((int)rbase.getInt("FiscalYear")));
                        rule.getBgPeriodType().setName(rbase.getString("FPTName"));
                        rule.getBgPeriodType().setNumber(rbase.getString("FPTNumber"));
                        schemeInfo.getRule().add(rule);
                    }
                }
                finally {
                    SQLUtils.cleanup((ResultSet)rbase, (Statement)pbase);
                }
                if (hasMapping) {
                    sql = new StringBuffer();
                    sql.append("select t.FBizProp, e.FBizItemValue, e.FBizItemAlias, e.FMbgItemValue, e.FMbgItemAlias, e.FIsMatching, t.FDimensionGroup from T_MBG_BgControlItemMap t join T_MBG_BgControlItemMapEntry e on t.FID = e.FMapId where t.FControlSchemeId = ?");
                    HashMap<String, BgControlItemMapInfo> itemsMap = new HashMap<String, BgControlItemMapInfo>();
                    try {
                        pbase = conn.prepareStatement(sql.toString());
                        if (isShareItem) {
                            pbase.setString(1, schemeInfo.getRootID().toString());
                        } else {
                            pbase.setString(1, schemeInfo.getId().toString());
                        }
                        rbase = pbase.executeQuery();
                        while (rbase.next()) {
                            tmpStr = BgControlItemMapInfo.getBizPropKey(rbase.getString("FBizProp"), rbase.getInt("FDimensionGroup"));
                            if (itemsMap.containsKey(tmpStr)) {
                                itemMap = (BgControlItemMapInfo)itemsMap.get(tmpStr);
                            } else {
                                itemMap = new BgControlItemMapInfo();
                                itemMap.setBizProp(rbase.getString("FBizProp"));
                                itemMap.setDimensionGroup(rbase.getInt("FDimensionGroup"));
                                itemsMap.put(itemMap.getBizProp(), itemMap);
                                schemeInfo.getItemMaps().add(itemMap);
                            }
                            itemEntry = new BgControlItemMapEntryInfo();
                            itemEntry.setBizItemValue(rbase.getString("FBizItemValue"));
                            itemEntry.setBizItemAlias(rbase.getString("FBizItemAlias"));
                            itemEntry.setMbgItemValue(rbase.getString("FMbgItemValue"));
                            itemEntry.setMbgItemAlias(rbase.getString("FMbgItemAlias"));
                            itemEntry.setMatching(rbase.getBoolean("FIsMatching"));
                            itemMap.getEntry().add(itemEntry);
                        }
                    }
                    finally {
                        SQLUtils.cleanup((ResultSet)rbase, (Statement)pbase);
                    }
                }
                if (hasExpand) {
                    sql = new StringBuffer();
                    sql.append("select FID, FBgReqAccNum, FBgReqAccName_" + ctx.getLocale() + " FBgReqAccName, FBgCtrlAccNum, FBgCtrlValue, FBgCtrlParam, FBgReqRule, FIsGroup from T_MBG_BgControlExpendRule where FControlSchemeId = ?");
                    HashMap expandGroupMap = new HashMap();
                    HashMap<String, BgControlExpendRuleInfo> expandMap = new HashMap<String, BgControlExpendRuleInfo>();
                    try {
                        pbase = conn.prepareStatement(sql.toString());
                        pbase.setString(1, schemeInfo.getId().toString());
                        rbase = pbase.executeQuery();
                        while (rbase.next()) {
                            BgControlExpendRuleInfo expandInfo = new BgControlExpendRuleInfo();
                            expandInfo.setId(BOSUuid.read((String)rbase.getString("FID")));
                            expandInfo.setBgCtrlAccNum(rbase.getString("FBgCtrlAccNum"));
                            expandInfo.setBgReqAccNum(rbase.getString("FBgReqAccNum"));
                            expandInfo.setBgReqAccName(rbase.getString("FBgReqAccName"));
                            expandInfo.setControlScheme(schemeInfo);
                            expandInfo.setIsGroup(rbase.getBoolean("FIsGroup"));
                            expandInfo.setBgCtrlParam(rbase.getBigDecimal("FBgCtrlParam"));
                            expandInfo.setBgCtrlValue(BgCtrlValueEnum.getEnum(rbase.getInt("FBgCtrlValue")));
                            expandInfo.setBgReqRule(BgReqRuleEnum.getEnum(rbase.getInt("FBgReqRule")));
                            schemeInfo.getBgCtrlExpendRule().add(expandInfo);
                            if (expandInfo.isIsGroup() && BgCtrlValueEnum.ControlBudget.equals((Object)expandInfo.getBgCtrlValue())) {
                                if (!expandGroupMap.containsKey(expandInfo.getBgCtrlAccNum())) {
                                    expandGroupMap.put(expandInfo.getBgCtrlAccNum(), new HashMap());
                                }
                                ((Map)expandGroupMap.get(expandInfo.getBgCtrlAccNum())).put(expandInfo.getId().toString(), expandInfo);
                            }
                            expandMap.put(expandInfo.getId().toString(), expandInfo);
                        }
                    }
                    finally {
                        SQLUtils.cleanup((ResultSet)rbase, (Statement)pbase);
                    }
                    sql = new StringBuffer();
                    sql.append("select FID, FBgCtrlExpendRuleId, FBgCtrlValue, FBgCtrlParam, FBgCtrlRange from T_MBG_BgControlExpendEntry where FBgCtrlExpendRuleId IN(Select FID FROM T_MBG_BgControlExpendRule Where FControlSchemeId = ?)");
                    try {
                        pbase = conn.prepareStatement(sql.toString());
                        pbase.setString(1, schemeInfo.getId().toString());
                        rbase = pbase.executeQuery();
                        while (rbase.next()) {
                            String expandId = rbase.getString("FBgCtrlExpendRuleId");
                            if (!expandMap.containsKey(expandId)) continue;
                            BgControlExpendEntryInfo expandEntryInfo = new BgControlExpendEntryInfo();
                            expandEntryInfo.setId(BOSUuid.read((String)rbase.getString("FID")));
                            expandEntryInfo.setBgCtrlParam(rbase.getBigDecimal("FBgCtrlParam"));
                            expandEntryInfo.setBgCtrlValue(BgCtrlValueEnum.getEnum(rbase.getInt("FBgCtrlValue")));
                            expandEntryInfo.setBgCtrlRange(BgDBUtils.getBytes((ResultSet)rbase, (String)"FBgCtrlRange"));
                            expandEntryInfo.setBgCtrlExpendRule((BgControlExpendRuleInfo)expandMap.get(expandId));
                            expandEntryInfo.getBgCtrlExpendRule().getEntry().add(expandEntryInfo);
                        }
                    }
                    finally {
                        SQLUtils.cleanup((ResultSet)rbase, (Statement)pbase);
                    }
                    for (Map subExpandMap : expandGroupMap.values()) {
                        BgControlExpendRuleInfo mainInfo = null;
                        for (BgControlExpendRuleInfo info : subExpandMap.values()) {
                            if (info.getEntry().isEmpty()) continue;
                            mainInfo = info;
                            break;
                        }
                        for (BgControlExpendRuleInfo info : subExpandMap.values()) {
                            if (mainInfo == null || !info.getEntry().isEmpty()) continue;
                            info.getEntry().addCollection(mainInfo.getEntry());
                        }
                    }
                }
                colls.add(schemeInfo);
            }
        }
        catch (IOException ex) {
            try {
                logger.error((Object)"queryControlScheme Error", (Throwable)ex);
                throw new BgControlException(BgControlException.DATABASEEXCEPTION, new String[]{ex.getMessage()});
                catch (SQLException ex2) {
                    logger.error((Object)"queryControlScheme Error", (Throwable)ex2);
                    throw new BgControlException(BgControlException.DATABASEEXCEPTION, new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        if (colls.size() > 1) {
            throw new BgControlException(BgControlException.CONTROLSCHEMEREPEATERROR, new Object[]{OUName});
        }
        if (schemeInfo == null) {
            throw new BgControlException(BgControlException.NOFOUNDCONTROLSCHEME, new Object[]{OUName});
        }
        int i = 0;
        int in = schemeInfo.getRule().size();
        while (i < in) {
            rule = schemeInfo.getRule().get(i);
            if (rule.getBgSchemeType() == null) {
                throw new BgControlException(BgControlException.NOFOUNDBGSCHEMETYPE, new Object[]{OUName, schemeInfo.getNumber()});
            }
            if (rule.getBgPeriodType() == null) {
                throw new BgControlException(BgControlException.NOFOUNDBGPERIODTYPE, new Object[]{OUName, schemeInfo.getNumber()});
            }
            ++i;
        }
        return schemeInfo;
    }

    public static BgControlSchemeException getControlModifyMsg(Context ctx, boolean isUpdate) {
        if (BgParamNHelper.isShareBizItem((Context)ctx)) {
            return new BgControlSchemeException(BgControlSchemeException.NOTMODIFYSCHEMEBY030);
        }
        if (!isUpdate) {
            return new BgControlSchemeException(BgControlSchemeException.NOTMODIFYSCHEME);
        }
        return null;
    }
}

