/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.control.utils;

import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.ma.control.BgControlException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ObjectValueToMap {
    private List propList = new ArrayList();
    private String[] prop;

    public List execute(IObjectValue value, String[] prop) throws BgControlException {
        this.prop = prop;
        this.initProp(prop);
        LinkedList rtn = new LinkedList();
        this.flatten(value, rtn, new HashMap(), null, false);
        return rtn;
    }

    private void initProp(String[] prop) {
        this.propList.clear();
        for (int i = 0; i < prop.length; ++i) {
            String[] pns = prop[i].trim().split("[.]");
            StringBuffer p = new StringBuffer(pns[0]);
            this.addToPropList(p.toString());
            for (int j = 1; j < pns.length; ++j) {
                p.append(".").append(pns[j]);
                this.addToPropList(p.toString());
            }
        }
    }

    private void addToPropList(String key) {
        if (!this.propList.contains(key = key.toLowerCase())) {
            this.propList.add(key);
        }
    }

    private boolean isInFilterProp(String key) {
        key = key.toLowerCase();
        return this.propList.contains(key);
    }

    private void clearObjectValueMap(Map map, String pre) {
        if (pre == null || pre.length() == 0) {
            map.clear();
        } else {
            pre = pre + ".";
            for (String key : map.keySet()) {
                if (key == null || !key.startsWith(pre)) continue;
                map.put(key, null);
            }
        }
    }

    private void flatten(IObjectValue value, List list, Map map, String pre, boolean isIgnoreCollection) throws BgControlException {
        if (value == null) {
            throw new IllegalArgumentException("value is null");
        }
        if (map == null) {
            throw new IllegalArgumentException("map is null");
        }
        if (pre == null) {
            pre = "";
        }
        this.clearObjectValueMap(map, pre);
        String entryName = null;
        Enumeration enu = value.keys();
        while (enu.hasMoreElements()) {
            String key = (String)enu.nextElement();
            if (key == null) continue;
            String p = (pre.length() == 0 ? "" : pre + ".") + key;
            if (!this.isInFilterProp(p = p.toLowerCase())) continue;
            Object val = value.get(key);
            if (val instanceof IObjectValue) {
                map.put(p, val);
                this.flatten((IObjectValue)val, list, map, p, true);
                continue;
            }
            if (val instanceof IObjectCollection) {
                if (isIgnoreCollection) {
                    throw new BgControlException(BgControlException.LIMITONECOLLECTION);
                }
                if (entryName == null || entryName.equalsIgnoreCase(key)) {
                    entryName = key;
                    continue;
                }
                throw new BgControlException(BgControlException.LIMITONECOLLECTION, new Object[]{entryName, key});
            }
            if (val == null) continue;
            map.put(p, val);
        }
        if (!isIgnoreCollection) {
            if (entryName != null) {
                String p = (pre.length() == 0 ? "" : pre + ".") + entryName;
                IObjectCollection entries = (IObjectCollection)value.get(entryName);
                int len = entries.size();
                for (int i = 0; i < len; ++i) {
                    map.put(p, entries.getObject(i));
                    this.flatten(entries.getObject(i), list, map, p, false);
                }
            } else {
                HashMap map2 = new HashMap();
                for (int i = 0; i < this.prop.length; ++i) {
                    String pn = this.prop[i].trim();
                    String p = pn.toLowerCase();
                    Object data = map.get(p);
                    map2.put(pn, data);
                }
                list.add(map2);
            }
        }
    }
}

