/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mobile.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.budget.BgFormException;
import com.kingdee.eas.ma.budget.BgItemGroupCollection;
import com.kingdee.eas.ma.budget.BgItemGroupFactory;
import com.kingdee.eas.ma.budget.BgItemGroupInfo;
import com.kingdee.eas.ma.mobile.BgMobileChartFactory;
import com.kingdee.eas.ma.mobile.BgMobileDimenseFactory;
import com.kingdee.eas.ma.mobile.BgMobileDimenseInfo;
import com.kingdee.eas.ma.mobile.BgMobileInfo;
import com.kingdee.eas.ma.mobile.BgMobileMappingFactory;
import com.kingdee.eas.ma.mobile.BgMobileNormFactory;
import com.kingdee.eas.ma.mobile.IBgMobileChart;
import com.kingdee.eas.ma.mobile.IBgMobileDimense;
import com.kingdee.eas.ma.mobile.IBgMobileMapping;
import com.kingdee.eas.ma.mobile.IBgMobileNorm;
import com.kingdee.eas.ma.mobile.app.AbstractBgMobileFacadeControllerBean;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgMobileFacadeControllerBean
extends AbstractBgMobileFacadeControllerBean {
    private static final long serialVersionUID = -3021235142609518361L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mobile.app.BgMobileFacadeControllerBean");

    protected IBgMobileNorm getNormInterface(Context ctx) throws BOSException {
        return BgMobileNormFactory.getLocalInstance(ctx);
    }

    protected IBgMobileDimense getDimenseInterface(Context ctx) throws BOSException {
        return BgMobileDimenseFactory.getLocalInstance(ctx);
    }

    protected IBgMobileMapping getMappgingInterface(Context ctx) throws BOSException {
        return BgMobileMappingFactory.getLocalInstance(ctx);
    }

    protected IBgMobileChart getChartInterface(Context ctx) throws BOSException {
        return BgMobileChartFactory.getLocalInstance(ctx);
    }

    private EntityViewInfo getNormView() {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().addObjectCollection((IObjectCollection)this.getNormSelector());
        viewInfo.getSorter().add(new SorterItemInfo("serial"));
        viewInfo.getSorter().add(new SorterItemInfo("itemEntry.number"));
        return viewInfo;
    }

    private EntityViewInfo getDimenseView() {
        EntityViewInfo viewInfo = new EntityViewInfo();
        SorterItemInfo sort = new SorterItemInfo("isSys");
        sort.setSortType(SortType.DESCEND);
        viewInfo.getSorter().add(sort);
        viewInfo.getSorter().add(new SorterItemInfo("serial"));
        return viewInfo;
    }

    private EntityViewInfo getChartView() {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().addObjectCollection((IObjectCollection)this.getChartSelector());
        viewInfo.getSorter().add(new SorterItemInfo("dimense.serial"));
        return viewInfo;
    }

    private SelectorItemCollection getNormSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("serial");
        sic.add("name");
        sic.add("creator.id");
        sic.add("createTime");
        sic.add("lastUpdateUser.id");
        sic.add("lastUpdateTime");
        sic.add("cu.id");
        sic.add("bgItemGroup.id");
        sic.add("bgItemGroup.name");
        sic.add("bgItemGroup.number");
        sic.add("bgItemGroup.refField");
        sic.add("itemEntry.id");
        sic.add("itemEntry.name");
        sic.add("itemEntry.number");
        sic.add("bgElement.id");
        sic.add("bgElement.name");
        sic.add("bgElement.number");
        sic.add("measureUnit.id");
        sic.add("measureUnit.name");
        sic.add("measureUnit.number");
        sic.add("measureUnit.coefficient");
        sic.add("bgScheme.id");
        sic.add("bgScheme.name");
        sic.add("bgScheme.number");
        sic.add("bgScheme.rootId");
        sic.add("bgScheme.dateFrom");
        sic.add("bgScheme.dateTo");
        sic.add("currency.id");
        sic.add("currency.name");
        sic.add("currency.number");
        sic.add("currency.precision");
        return sic;
    }

    private SelectorItemCollection getChartSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("dimense.id");
        sic.add("dimense.name");
        sic.add("dimense.serial");
        sic.add("isHistogram");
        sic.add("isPie");
        sic.add("isLineGraph");
        return sic;
    }

    @Override
    protected Object _getValue(Context ctx) throws BOSException, EASBizException {
        BgMobileInfo bgMobileInfo = new BgMobileInfo();
        bgMobileInfo.setNorms((IObjectCollection)this.getNormInterface(ctx).getBgMobileNormCollection(this.getNormView()));
        bgMobileInfo.setDimenses((IObjectCollection)this.getDimenseInterface(ctx).getBgMobileDimenseCollection(this.getDimenseView()));
        bgMobileInfo.setMapping((IObjectCollection)this.getMappgingInterface(ctx).getBgMobileMappingCollection());
        bgMobileInfo.setChart((IObjectCollection)this.getChartInterface(ctx).getBgMobileChartCollection(this.getChartView()));
        if (bgMobileInfo.getDimenses() != null && !bgMobileInfo.getDimenses().isEmpty()) {
            BgMobileDimenseInfo dimenseInfo = null;
            int in = bgMobileInfo.getDimenses().size();
            for (int i = 0; i < in; ++i) {
                dimenseInfo = (BgMobileDimenseInfo)bgMobileInfo.getDimenses().getObject(i);
                if (dimenseInfo.getDataReleId() == null) continue;
                bgMobileInfo.getDataRele().put(dimenseInfo.getDataReleId(), null);
            }
            if (!bgMobileInfo.getDataRele().isEmpty()) {
                this.checkDataRelation(ctx, bgMobileInfo.getDataRele());
            }
        }
        bgMobileInfo.setBgItemMap(this.getBgItemInfo(ctx));
        return bgMobileInfo;
    }

    protected void checkDataRelation(Context ctx, Map dataRelation) throws BOSException {
        if (dataRelation == null) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", dataRelation.keySet(), CompareType.INCLUDE));
        view.setFilter(filter);
        BgItemGroupCollection colls = null;
        colls = BgItemGroupFactory.getLocalInstance((Context)ctx).getBgItemGroupCollection(view);
        if (colls != null) {
            String id = null;
            BgItemGroupInfo groupInfo = null;
            int in = colls.size();
            for (int i = 0; i < in; ++i) {
                groupInfo = colls.get(i);
                id = groupInfo.getId().toString();
                if (!dataRelation.containsKey(id)) continue;
                dataRelation.put(id, groupInfo.getName());
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map getBgItemInfo(Context ctx) throws BOSException, EASBizException {
        if (ctx == null) {
            return null;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        HashMap<String, Integer> bgItemMap = new HashMap<String, Integer>();
        String sql = "select FNumber, FLevel from T_BG_BgItem where FOrgUnitId = '00000000-0000-0000-0000-000000000000CCE7AED4' and FNumber in (select FNumber from T_BG_BgMobileNormEntry)";
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                bgItemMap.put(rst.getString("FNumber"), new Integer(rst.getInt("FLevel")));
            }
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)"query BgItem error!", (Throwable)ex2);
                    throw new BgFormException(BgFormException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return bgItemMap;
    }

    @Override
    protected Object _save(Context ctx, Object value) throws BOSException, EASBizException {
        if (value == null) {
            return null;
        }
        if (value instanceof BgMobileInfo) {
            Iterator iter;
            BgMobileInfo bgMobileInfo = (BgMobileInfo)value;
            CoreBaseCollection colls = new CoreBaseCollection();
            if (bgMobileInfo.getNorms() != null && !bgMobileInfo.getNorms().isEmpty()) {
                iter = bgMobileInfo.getNorms().iterator();
                while (iter.hasNext()) {
                    colls.add((CoreBaseInfo)iter.next());
                }
                this.getNormInterface(ctx).saveBatchData(colls);
            } else {
                this.getNormInterface(ctx).removeAll();
            }
            colls.clear();
            if (bgMobileInfo.getDimenses() != null && !bgMobileInfo.getDimenses().isEmpty()) {
                iter = bgMobileInfo.getDimenses().iterator();
                while (iter.hasNext()) {
                    colls.add((CoreBaseInfo)iter.next());
                }
                this.getDimenseInterface(ctx).saveBatchData(colls);
            } else {
                this.getDimenseInterface(ctx).removeAll();
            }
            colls.clear();
            if (bgMobileInfo.getMapping() != null && !bgMobileInfo.getMapping().isEmpty()) {
                iter = bgMobileInfo.getMapping().iterator();
                while (iter.hasNext()) {
                    colls.add((CoreBaseInfo)iter.next());
                }
            }
            this.getMappgingInterface(ctx).saveBatchData(colls);
            colls.clear();
            if (bgMobileInfo.getChart() != null && !bgMobileInfo.getChart().isEmpty()) {
                iter = bgMobileInfo.getChart().iterator();
                while (iter.hasNext()) {
                    colls.add((CoreBaseInfo)iter.next());
                }
                this.getChartInterface(ctx).saveBatchData(colls);
            }
        }
        return this._getValue(ctx);
    }
}

