/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.scmcommon.app.thread;

import com.kingdee.eas.ma.scmcommon.app.thread.SyncTask;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

public class ThreadPool {
    private static final Logger logger = Logger.getLogger(ThreadPool.class);
    private static ThreadPool instance = null;
    private boolean isClosed = false;
    private ThreadWorker[] workerArray;
    private int threadCount;
    private List<Runnable> taskList;

    private ThreadPool() {
        this(10);
    }

    private ThreadPool(int threadCount) {
        this.threadCount = threadCount;
        this.isClosed = false;
        this.taskList = Collections.synchronizedList(new LinkedList());
        this.workerArray = new ThreadWorker[this.threadCount];
        for (int i = 0; i < threadCount; ++i) {
            ThreadWorker thread = new ThreadWorker(i);
            thread.start();
            this.workerArray[i] = thread;
        }
    }

    public static final synchronized ThreadPool getInstance() {
        if (null == instance) {
            instance = new ThreadPool();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTask(Runnable task) {
        if (null == task) {
            return;
        }
        List<Runnable> list = this.taskList;
        synchronized (list) {
            this.taskList.add(task);
            this.taskList.notify();
            if (this.taskList.size() > 5) {
                logger.error((Object)("p04_beta_debug_log_taskList_size:" + this.taskList.size()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTask(List<Runnable> tasks) {
        if (null == tasks || tasks.size() == 0) {
            return;
        }
        List<Runnable> list = this.taskList;
        synchronized (list) {
            Runnable task = null;
            int len = tasks.size();
            for (int i = 0; i < len; ++i) {
                task = tasks.get(i);
                if (null == task) continue;
                this.taskList.add(task);
            }
            if (!this.taskList.isEmpty()) {
                this.taskList.notifyAll();
            }
            if (this.taskList.size() > 5 + tasks.size()) {
                logger.error((Object)("p04_beta_debug_log_taskList_size:" + this.taskList.size()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean removeTask(String taskid) {
        List<Runnable> list = this.taskList;
        synchronized (list) {
            SyncTask syncTask = null;
            int size = this.taskList.size();
            for (int i = 0; i < size; ++i) {
                if (!(this.taskList.get(i) instanceof SyncTask) || !(syncTask = (SyncTask)this.taskList.get(i)).getTaskid().equals(taskid)) continue;
                syncTask.releaseLock();
                this.taskList.remove(i);
                --i;
                --size;
                return true;
            }
            return false;
        }
    }

    private class ThreadWorker
    extends Thread {
        private String threadId;
        private Runnable task;

        public Runnable getTask() {
            return this.task;
        }

        ThreadWorker(int threadId) {
            super("ThreadPool_Worker" + threadId);
            this.threadId = "ThreadPool_Worker" + threadId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long startTime = 0L;
            while (!ThreadPool.this.isClosed) {
                try {
                    List list = ThreadPool.this.taskList;
                    synchronized (list) {
                        if (!ThreadPool.this.taskList.isEmpty()) {
                            this.task = (Runnable)ThreadPool.this.taskList.remove(0);
                        }
                        if (null == this.task) {
                            ThreadPool.this.taskList.wait(5000L);
                        } else {
                            startTime = System.currentTimeMillis();
                            this.task.run();
                            this.task = null;
                            if (!ThreadPool.this.taskList.isEmpty()) {
                                ThreadPool.this.taskList.notifyAll();
                            }
                            logger.error((Object)("p04_beta_debug_log_execute_time:" + (System.currentTimeMillis() - startTime)));
                        }
                    }
                }
                catch (Exception e) {
                    logger.error((Object)("\u6267\u884c\u4efb\u52a1\u65f6\u51fa\u73b0\u5f02\u5e38\u3002\u7ebf\u7a0bID:" + this.threadId), (Throwable)e);
                }
            }
        }
    }
}

