/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.scmcommon.tools;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.scmcommon.MAException;
import com.kingdee.eas.ma.scmcommon.tools.BizLogger;
import com.kingdee.eas.ma.scmcommon.tools.LogParam;
import com.kingdee.eas.ma.scmcommon.tools.SQLLogger;
import com.kingdee.eas.ma.scmcommon.tools.SQLUtils;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class BizCommand {
    protected static final Logger logger = BizLogger.getLogger();
    protected Context ctx;
    protected Date beginTime;
    protected int sqlCount = 0;

    public BizCommand(Context ctx) {
        this.ctx = ctx;
    }

    public Context getContext() {
        return this.ctx;
    }

    public abstract String getTaskID();

    protected void logBegin() {
        this.beginTime = new Date();
        this.sqlCount = 0;
        if (LogParam.getInstance().isOpen()) {
            String exeClassName = this.getClass().toString();
            logger.info((Object)(exeClassName + ".doing(), begin execute time(s) at :" + System.currentTimeMillis()));
        }
    }

    protected void logEnd() {
        if (LogParam.getInstance().isOpen()) {
            String exeClassName = this.getClass().toString();
            logger.info((Object)(exeClassName + ".doing(),execute time(s)," + String.valueOf(this.countExeTime()) + ",SQL count," + String.valueOf(this.sqlCount)));
        }
    }

    private BigDecimal countExeTime() {
        Date endTime = new Date();
        BigDecimal e = new BigDecimal(String.valueOf(endTime.getTime()));
        BigDecimal b = new BigDecimal(String.valueOf(this.beginTime.getTime()));
        BigDecimal runSecs = e.subtract(b).divide(new BigDecimal("1000"), 2, 4);
        return runSecs;
    }

    public Object execute(Object inParam) throws BOSException, EASBizException {
        this.logBegin();
        Object ret = this.doing(inParam);
        this.logEnd();
        return ret;
    }

    protected abstract Object doing(Object var1) throws BOSException, EASBizException;

    protected int getStatus(String taskID) throws BOSException, EASBizException {
        String sql = "select FStatus from T_MAS_Progress where FId = ? ";
        Object[] params = new Object[]{taskID};
        IRowSet rs = SQLUtils.executeQuery(this.ctx, sql, params);
        int status = -1;
        try {
            if (rs.next()) {
                status = rs.getInt("FStatus");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return status;
    }

    protected void checkTask() throws BOSException, EASBizException {
        int status;
        String taskID = this.getTaskID();
        if (taskID == null && (status = this.getStatus(taskID)) == 3) {
            throw new MAException(MAException.TASK_ABORT);
        }
    }

    public int execute(String sql) throws BOSException, EASBizException {
        this.checkTask();
        long timeFrom = System.currentTimeMillis();
        int count = SQLUtils.execute(this.ctx, sql);
        long timeTo = System.currentTimeMillis();
        this.writeLog(this.ctx, timeFrom, timeTo, sql, null, count);
        ++this.sqlCount;
        return count;
    }

    public int execute(String sql, Object[] params) throws BOSException, EASBizException {
        this.checkTask();
        long timeFrom = System.currentTimeMillis();
        int count = SQLUtils.execute(this.ctx, sql, params);
        long timeTo = System.currentTimeMillis();
        this.writeLog(this.ctx, timeFrom, timeTo, sql, params, count);
        ++this.sqlCount;
        return count;
    }

    public IRowSet executeQuery(String sql) throws BOSException, EASBizException {
        this.checkTask();
        long timeFrom = System.currentTimeMillis();
        IRowSet rs = SQLUtils.executeQuery(this.ctx, sql);
        long timeTo = System.currentTimeMillis();
        try {
            this.writeLog(this.ctx, timeFrom, timeTo, sql, null, rs.getRow());
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        ++this.sqlCount;
        return rs;
    }

    public IRowSet executeQuery(String sql, Object[] params) throws BOSException, EASBizException {
        this.checkTask();
        long timeFrom = System.currentTimeMillis();
        IRowSet rs = SQLUtils.executeQuery(this.ctx, sql, params);
        long timeTo = System.currentTimeMillis();
        try {
            this.writeLog(this.ctx, timeFrom, timeTo, sql, null, rs.getRow());
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        ++this.sqlCount;
        return rs;
    }

    public int[] executeBatch(String sql, List paramsList) throws BOSException, EASBizException {
        this.checkTask();
        long timeFrom = System.currentTimeMillis();
        int[] resultNum = SQLUtils.executeBatch(this.ctx, sql, paramsList);
        long timeTo = System.currentTimeMillis();
        this.writeLog(this.ctx, timeFrom, timeTo, new String[]{sql}, paramsList.toArray(), resultNum);
        ++this.sqlCount;
        return resultNum;
    }

    public int[] executeBatch(String[] sqls) throws BOSException, EASBizException {
        this.checkTask();
        long timeFrom = System.currentTimeMillis();
        int[] resultNum = SQLUtils.executeBatch(this.ctx, sqls);
        long timeTo = System.currentTimeMillis();
        this.writeLog(this.ctx, timeFrom, timeTo, sqls, null, resultNum);
        this.sqlCount += sqls.length;
        return resultNum;
    }

    protected String getBizName() {
        return this.getClass().toString();
    }

    private void writeLog(Context ctx, long timeFrom, long timeTo, String[] sqls, Object[] params, int[] numbers) throws BOSException {
        SQLLogger.writeLog(ctx, this.getBizName(), timeFrom, timeTo, sqls, params, numbers);
    }

    private void writeLog(Context ctx, long timeFrom, long timeTo, String sql, Object[] params, int number) throws BOSException {
        this.writeLog(ctx, timeFrom, timeTo, new String[]{sql}, params, new int[]{number});
    }
}

