/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.scmcommon.tools;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.transaction.EJBTransactionProxy;
import com.kingdee.eas.ma.scmcommon.tools.SQLLogger;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public final class SQLUtils {
    private static final int MAX_DATA_ROW = 8000;

    public static int execute(Context ctx, String sql) throws BOSException {
        int n;
        Connection conn = null;
        Statement statement = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            statement = conn.createStatement();
            long timeFrom = System.currentTimeMillis();
            int number = statement.executeUpdate(sql);
            long timeTo = System.currentTimeMillis();
            SQLUtils.writeLog(ctx, timeFrom, timeTo, sql, null, number);
            n = number;
        }
        catch (SQLException exc) {
            try {
                throw new BOSException(sql, (Throwable)exc);
            }
            catch (Throwable throwable) {
                com.kingdee.util.db.SQLUtils.cleanup(statement, (Connection)conn);
                throw throwable;
            }
        }
        com.kingdee.util.db.SQLUtils.cleanup((Statement)statement, (Connection)conn);
        return n;
    }

    public static int execute(Context ctx, String sql, Object[] params) throws BOSException {
        int n;
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.prepareStatement(sql);
            for (int i = 0; i < params.length; ++i) {
                ps.setObject(i + 1, params[i]);
            }
            long timeFrom = System.currentTimeMillis();
            int number = ps.executeUpdate();
            long timeTo = System.currentTimeMillis();
            SQLUtils.writeLog(ctx, timeFrom, timeTo, sql, params, number);
            n = number;
        }
        catch (SQLException exc) {
            try {
                StringBuffer sb = new StringBuffer("sql is:" + sql + " param is:");
                for (int i = 0; i < params.length; ++i) {
                    sb.append("param ").append(i).append(" is:").append(params[i]);
                }
                throw new BOSException(sb.toString(), (Throwable)exc);
            }
            catch (Throwable throwable) {
                com.kingdee.util.db.SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        com.kingdee.util.db.SQLUtils.cleanup((Statement)ps, (Connection)conn);
        return n;
    }

    public static IRowSet executeQuery(Context ctx, String sql) throws BOSException {
        JdbcRowSet jdbcRowSet;
        Connection conn = null;
        Statement statement = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            statement = conn.createStatement();
            long timeFrom = System.currentTimeMillis();
            rs = statement.executeQuery(sql);
            long timeTo = System.currentTimeMillis();
            JdbcRowSet rowset = new JdbcRowSet();
            rowset.populate(rs);
            SQLUtils.writeLog(ctx, timeFrom, timeTo, sql, null, rowset.size());
            jdbcRowSet = rowset;
        }
        catch (SQLException exc) {
            try {
                throw new BOSException(sql, (Throwable)exc);
            }
            catch (Throwable throwable) {
                com.kingdee.util.db.SQLUtils.cleanup(rs, (Statement)statement, (Connection)conn);
                throw throwable;
            }
        }
        com.kingdee.util.db.SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)conn);
        return jdbcRowSet;
    }

    public static IRowSet executeQuery(Context ctx, String sql, Object[] params) throws BOSException {
        JdbcRowSet jdbcRowSet;
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        if (sql == null) {
            return null;
        }
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.prepareStatement(sql);
            if (params != null) {
                for (int i = 0; i < params.length; ++i) {
                    ps.setObject(i + 1, params[i]);
                }
            }
            long timeFrom = System.currentTimeMillis();
            rs = ps.executeQuery();
            long timeTo = System.currentTimeMillis();
            JdbcRowSet rowset = new JdbcRowSet();
            rowset.populate(rs);
            SQLUtils.writeLog(ctx, timeFrom, timeTo, sql, params, rowset.size());
            jdbcRowSet = rowset;
        }
        catch (SQLException exc) {
            try {
                StringBuffer sb = new StringBuffer("sql is:" + sql + " param is:");
                for (int i = 0; i < params.length; ++i) {
                    sb.append("param ").append(i).append(" is:").append(params[i]);
                }
                throw new BOSException(sb.toString(), (Throwable)exc);
            }
            catch (Throwable throwable) {
                com.kingdee.util.db.SQLUtils.cleanup(rs, ps, (Connection)conn);
                throw throwable;
            }
        }
        com.kingdee.util.db.SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return jdbcRowSet;
    }

    public static int[] executeBatch(Context ctx, String sql, List paramsList) throws BOSException {
        Connection conn = null;
        PreparedStatement ps = null;
        long startTime = 0L;
        long timeOffset = 0L;
        int[] resultNum = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.prepareStatement(sql);
            Object[] params = null;
            int k = 1;
            boolean flag = false;
            for (int i = 0; i < paramsList.size(); ++i) {
                params = (Object[])paramsList.get(i);
                for (int j = 0; j < params.length; ++j) {
                    if (params[j] != null) {
                        ps.setObject(j + 1, params[j]);
                        continue;
                    }
                    ps.setNull(j + 1, 12);
                }
                ps.addBatch();
                if (i == k * 8000) {
                    flag = true;
                }
                if (i <= k * 8000 || !flag) continue;
                long timeFrom = System.currentTimeMillis();
                if (startTime <= 0L) {
                    startTime = timeFrom;
                }
                int[] result = ps.executeBatch();
                long timeTo = System.currentTimeMillis();
                timeOffset += timeTo - timeFrom;
                resultNum = SQLLogger.arraycopy(resultNum, result);
                ++k;
                flag = false;
                ps.clearBatch();
            }
            if (!flag) {
                long timeFrom = System.currentTimeMillis();
                if (startTime <= 0L) {
                    startTime = timeFrom;
                }
                int[] result = ps.executeBatch();
                long timeTo = System.currentTimeMillis();
                timeOffset += timeTo - timeFrom;
                resultNum = SQLLogger.arraycopy(resultNum, result);
            }
            SQLUtils.writeLog(ctx, startTime, startTime + timeOffset, new String[]{sql}, paramsList.toArray(), resultNum);
        }
        catch (SQLException exc) {
            try {
                throw new BOSException(sql, (Throwable)exc);
            }
            catch (Throwable throwable) {
                com.kingdee.util.db.SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        com.kingdee.util.db.SQLUtils.cleanup((Statement)ps, (Connection)conn);
        return resultNum;
    }

    public static int[] executeBatch(Context ctx, String[] sqls) throws BOSException {
        int[] nArray;
        Connection conn = null;
        Statement statement = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            statement = conn.createStatement();
            for (int i = 0; i < sqls.length; ++i) {
                statement.addBatch(sqls[i]);
            }
            long timeFrom = System.currentTimeMillis();
            int[] resultNum = statement.executeBatch();
            long timeTo = System.currentTimeMillis();
            SQLUtils.writeLog(ctx, timeFrom, timeTo, sqls, null, resultNum);
            nArray = resultNum;
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                com.kingdee.util.db.SQLUtils.cleanup(statement, (Connection)conn);
                throw throwable;
            }
        }
        com.kingdee.util.db.SQLUtils.cleanup((Statement)statement, (Connection)conn);
        return nArray;
    }

    public static final void cleanup(Connection cn) {
        SQLUtils.cleanup(null, null, cn);
    }

    public static final void cleanup(Statement stmt) {
        SQLUtils.cleanup(null, stmt, null);
    }

    public static final void cleanup(Statement stmt, Connection cn) {
        SQLUtils.cleanup(null, stmt, cn);
    }

    public static final void cleanup(ResultSet rs) {
        SQLUtils.cleanup(rs, null, null);
    }

    public static final void cleanup(ResultSet rs, Statement stmt) {
        SQLUtils.cleanup(rs, stmt, null);
    }

    public static void cleanup(ResultSet rs, Statement stmt, Connection cn) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            rs = null;
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            stmt = null;
        }
        if (cn != null) {
            try {
                cn.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            cn = null;
        }
    }

    private static void writeLog(Context ctx, long timeFrom, long timeTo, String[] sqls, Object[] params, int[] numbers) throws BOSException {
        SQLLogger.writeLog(ctx, "SQLUtils", timeFrom, timeTo, sqls, params, numbers);
    }

    private static final void writeLog(Context ctx, long timeFrom, long timeTo, String sql, Object[] params, int number) throws BOSException {
        SQLUtils.writeLog(ctx, timeFrom, timeTo, new String[]{sql}, params, new int[]{number});
    }

    public static String buildSqlFromIds(Set ids) {
        StringBuffer idsSql = new StringBuffer();
        if (ids != null && ids.size() > 0) {
            idsSql.append("(");
            Iterator it = ids.iterator();
            while (it.hasNext()) {
                idsSql.append("'" + it.next() + "',");
            }
            idsSql.deleteCharAt(idsSql.length() - 1);
            idsSql.append(")");
        }
        return idsSql.toString();
    }

    public static String createTempTableWithNewTx(Context ctx, String createSql) throws BOSException {
        try {
            Method method = SQLUtils.class.getDeclaredMethod("createTempTable4NewTx", Context.class, String.class);
            method.setAccessible(true);
            EJBTransactionProxy txInvoker = EJBFactory.getEJBTransactionProxy((Object)new SQLUtils());
            Object value = txInvoker.invoke(method, new Object[]{ctx, createSql}, 3);
            return value.toString();
        }
        catch (NoSuchMethodException e) {
            throw new BOSException((Throwable)e);
        }
        catch (Throwable e) {
            throw new BOSException(e);
        }
    }

    String createTempTable4NewTx(Context ctx, String createSql) throws BOSException {
        return SQLUtils.createTempTable(ctx, createSql);
    }

    public static String createTempTable(Context ctx, String createSql) throws BOSException {
        try {
            TempTablePool pool = TempTablePool.getInstance((Context)ctx);
            return pool.createTempTable(createSql);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }
}

