/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.control.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.DefineSysEnum;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.bot.app.BOTMappingHelper;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.function.WfEventListenerStateManager;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.util.BotRelationUtil;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.mm.common.app.CommonUtils;
import com.kingdee.eas.mm.common.util.ResourceManage;
import com.kingdee.eas.mm.control.DDMReceivalBillEntryCollection;
import com.kingdee.eas.mm.control.DDMReceivalBillEntryInfo;
import com.kingdee.eas.mm.control.DDMReceivalBillEntryTargetEntryCollection;
import com.kingdee.eas.mm.control.DDMReceivalBillEntryTargetEntryInfo;
import com.kingdee.eas.mm.control.DDMReceivalBillException;
import com.kingdee.eas.mm.control.DDMReceivalBillInfo;
import com.kingdee.eas.mm.control.FinishedRptFactory;
import com.kingdee.eas.mm.control.FinishedRptInfo;
import com.kingdee.eas.mm.control.IProductionOrderStockEntry;
import com.kingdee.eas.mm.control.ProductionOrderStockEntryFactory;
import com.kingdee.eas.mm.control.ProductionOrderStockEntryInfo;
import com.kingdee.eas.mm.control.app.AbstractDDMReceivalBillControllerBean;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.ISCMBillParam;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.SCMBillParamFactory;
import com.kingdee.eas.scm.im.dt.util.DtUtils;
import com.kingdee.eas.scm.im.inv.IMaterialReqBill;
import com.kingdee.eas.scm.im.inv.IPurInWarehsBill;
import com.kingdee.eas.scm.im.inv.MaterialReqBillFactory;
import com.kingdee.eas.scm.im.inv.MaterialReqBillInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillFactory;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillInfo;
import com.kingdee.eas.scm.sm.pur.IPurOrderEntry;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import org.apache.log4j.Logger;

public class DDMReceivalBillControllerBean
extends AbstractDDMReceivalBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.control.app.DDMReceivalBillControllerBean");

    private void markBOTPRelation(Context ctx, DDMReceivalBillInfo info, IObjectPK pk) throws BOSException {
        int sourceType = info.getSourceType().getValue();
        if (sourceType == 10) {
            String srcBosType = "3171BFAD";
            String destBosType = "7AB0A0DA";
            String destObjId = pk.getKeyValue(null).toString();
            ArrayList purOrderIDs = BotRelationUtil.getSrcObjectIdBySrcType((Context)ctx, (String)destObjId, (String)srcBosType);
            if (purOrderIDs.size() > 0) {
                BotRelationUtil.removeRelationByDestObjId((Context)ctx, (String)destObjId, (String)srcBosType);
            }
            DDMReceivalBillEntryCollection entryColl = info.getEntrys();
            DDMReceivalBillEntryInfo entryInfo = null;
            ArrayList<String> srcObjectList = new ArrayList<String>();
            String srcObjectId = null;
            for (int i = 0; i < entryColl.size(); ++i) {
                entryInfo = entryColl.get(i);
                srcObjectId = entryInfo.getSourceBillId();
                if (srcObjectList.contains(srcObjectId)) continue;
                srcObjectList.add(srcObjectId);
            }
            IBOTRelation iRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
            for (int i = 0; i < srcObjectList.size(); ++i) {
                BOTRelationInfo relationInfo = new BOTRelationInfo();
                relationInfo.setSrcEntityID(srcBosType);
                relationInfo.setSrcObjectID((String)srcObjectList.get(i));
                relationInfo.setDestEntityID(destBosType);
                relationInfo.setDestObjectID(destObjId);
                relationInfo.setDate(new Date());
                relationInfo.setOperatorID(ctx.getCaller().toString());
                relationInfo.setIsEffected(true);
                relationInfo.setType(1);
                iRelation.addnew(relationInfo);
            }
        }
        this.markBOTPRelationD2(ctx, info, pk);
    }

    private void markBOTPRelationD2(Context ctx, DDMReceivalBillInfo info, IObjectPK pk) throws BOSException {
        String srcBosType = "1F66774E";
        String destBosType = "7AB0A0DA";
        String destObjId = pk.getKeyValue(null).toString();
        ArrayList prdOrderIDs = BotRelationUtil.getSrcObjectIdBySrcType((Context)ctx, (String)destObjId, (String)srcBosType);
        if (prdOrderIDs.size() > 0) {
            BotRelationUtil.removeRelationByDestObjId((Context)ctx, (String)destObjId, (String)srcBosType);
        }
        DDMReceivalBillEntryCollection entryColl = info.getEntrys();
        DDMReceivalBillEntryInfo entryInfo = null;
        DDMReceivalBillEntryTargetEntryCollection targetColl = null;
        DDMReceivalBillEntryTargetEntryInfo targetInfo = null;
        ArrayList<String> srcObjectList = new ArrayList<String>();
        String srcObjectId = null;
        for (int i = 0; i < entryColl.size(); ++i) {
            entryInfo = entryColl.get(i);
            targetColl = entryInfo.getTargetEntry();
            for (int j = 0; j < targetColl.size(); ++j) {
                targetInfo = targetColl.get(j);
                srcObjectId = targetInfo.getProductionOrder().getId().toString();
                if (srcObjectList.contains(srcObjectId)) continue;
                srcObjectList.add(srcObjectId);
            }
        }
        IBOTRelation iRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
        for (int i = 0; i < srcObjectList.size(); ++i) {
            BOTRelationInfo relationInfo = new BOTRelationInfo();
            relationInfo.setSrcEntityID(srcBosType);
            relationInfo.setSrcObjectID((String)srcObjectList.get(i));
            relationInfo.setDestEntityID(destBosType);
            relationInfo.setDestObjectID(destObjId);
            relationInfo.setDate(new Date());
            relationInfo.setOperatorID(ctx.getCaller().toString());
            relationInfo.setIsEffected(true);
            relationInfo.setType(1);
            iRelation.addnew(relationInfo);
        }
        int sourceType = info.getSourceType().getValue();
        if (sourceType == 20) {
            srcBosType = new FinishedRptInfo().getBOSType().toString();
            ArrayList finishedRptIDs = BotRelationUtil.getSrcObjectIdBySrcType((Context)ctx, (String)destObjId, (String)srcBosType);
            if (finishedRptIDs.size() > 0) {
                BotRelationUtil.removeRelationByDestObjId((Context)ctx, (String)destObjId, (String)srcBosType);
            }
            BOTRelationInfo relationInfo = new BOTRelationInfo();
            relationInfo.setSrcEntityID(srcBosType);
            relationInfo.setSrcObjectID(info.getSourceBillId());
            relationInfo.setDestEntityID(destBosType);
            relationInfo.setDestObjectID(destObjId);
            relationInfo.setDate(new Date());
            relationInfo.setOperatorID(ctx.getCaller().toString());
            relationInfo.setIsEffected(true);
            relationInfo.setType(1);
            iRelation.addnew(relationInfo);
        }
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DDMReceivalBillInfo info = (DDMReceivalBillInfo)model;
        this.setNullToDefault(ctx, (IObjectValue)info);
        IObjectPK pk = super._save(ctx, model);
        this.markBOTPRelation(ctx, info, pk);
        return pk;
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DDMReceivalBillInfo info = (DDMReceivalBillInfo)model;
        this.validateData(ctx, info);
        this.setNullToDefault(ctx, (IObjectValue)info);
        DDMReceivalBillEntryCollection entryCollection = info.getEntrys();
        Iterator itr = entryCollection.iterator();
        while (itr.hasNext()) {
            DDMReceivalBillEntryInfo entryInfo = (DDMReceivalBillEntryInfo)itr.next();
            entryInfo.setBaseStatus(EntryBaseStatusEnum.SUBMITED);
        }
        IObjectPK pk = super._submit(ctx, model);
        this.markBOTPRelation(ctx, info, pk);
        boolean isAutoAudit = false;
        String orgUnitID = info.getStorageOrgUnit().getId().toString();
        if (info.getBillType() != null) {
            String billTypeID = info.getBillType().getId().toString();
            ISCMBillParam scmParam = SCMBillParamFactory.getLocalInstance((Context)ctx);
            String strAutoAudit = scmParam.getParamByBillTypeID("SCM_Submit_01", 4, orgUnitID, billTypeID);
            if (strAutoAudit != null && strAutoAudit.trim().length() != 0 && strAutoAudit.trim().toLowerCase().equals("1")) {
                isAutoAudit = true;
            }
        }
        if (isAutoAudit) {
            this._audit(ctx, pk);
        }
        return pk;
    }

    protected void setNullToDefault(Context ctx, IObjectValue model) {
        if (model == null) {
            return;
        }
        IObjectCollection entrys = (IObjectCollection)model.get("entry");
        if (entrys == null) {
            return;
        }
        String[] entryDecimalFields = this.getEntryDecimalFields();
        if (entryDecimalFields != null) {
            int n = entrys.size();
            for (int i = 0; i < n; ++i) {
                IObjectValue entry = entrys.getObject(i);
                for (int j = 0; j < entryDecimalFields.length; ++j) {
                    if (entry.get(entryDecimalFields[j]) != null) continue;
                    entry.put(entryDecimalFields[j], (Object)DtUtils.ZERO);
                }
            }
        }
    }

    protected String[] getEntryDecimalFields() {
        return new String[]{"assistQty"};
    }

    protected boolean isSameNumber(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        DDMReceivalBillInfo info = (DDMReceivalBillInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)info.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (info.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)info.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (info.getCU() != null) {
            filterItem = new FilterItemInfo("CU", (Object)info.getCU().getId().toString(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        } else {
            filterItem = new FilterItemInfo("CU", null, CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (info.getStorageOrgUnit() != null) {
            filterItem = new FilterItemInfo("storageOrgUnit.id", (Object)info.getStorageOrgUnit().getId().toString(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (this.getBindingProperty(ctx) != null && this.getBindingProperty(ctx).trim().length() > 0 && info.get(this.getBindingProperty(ctx)) != null) {
            filterItem = new FilterItemInfo(this.getBindingProperty(ctx), this.getBindingPropertyValue(info), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        }
        return super._exists(ctx, filter);
    }

    private void validateData(Context ctx, DDMReceivalBillInfo info) throws DDMReceivalBillException {
        DDMReceivalBillEntryCollection entryCollection;
        StringBuffer errorMsg = new StringBuffer();
        if (info.getStorageOrgUnit() == null) {
            errorMsg.append(this.getResource(ctx, "storageOrgNull")).append("\n");
        }
        if (info.getBizDate() == null) {
            errorMsg.append(this.getResource(ctx, "bizDateNull")).append("\n");
        }
        if ((entryCollection = info.getEntrys()) == null || entryCollection.size() == 0) {
            errorMsg.append(this.getResource(ctx, "entryNull")).append("\n");
        } else {
            String di = this.getResource(ctx, "di");
            String line = this.getResource(ctx, "line");
            int rowIndex = 0;
            for (int i = 0; i < entryCollection.size(); ++i) {
                String prefix = di + ++rowIndex + line;
                DDMReceivalBillEntryInfo entryInfo = entryCollection.get(i);
                if (entryInfo.getMaterial().getAssistAttr() != null && entryInfo.getAssistProperty() == null) {
                    errorMsg.append(prefix).append(this.getResource(ctx, "assistAttrNull")).append("\n");
                }
                if (entryInfo.getMaterialInventory() != null) {
                    if (entryInfo.getMaterialInventory().isIsLotNumber() && entryInfo.getLotNumber() == null) {
                        errorMsg.append(prefix).append(this.getResource(ctx, "lotNumberNull")).append("\n");
                    }
                    if (entryInfo.getMaterialInventory().isIsPeriodValid() && entryInfo.getProductDate() == null) {
                        errorMsg.append(prefix).append(this.getResource(ctx, "productDateNull")).append("\n");
                    }
                    if (entryInfo.getMaterialInventory().isIsPeriodValid() && entryInfo.getExpireDate() == null) {
                        errorMsg.append(prefix).append(this.getResource(ctx, "expireDateNull")).append("\n");
                    }
                }
                if (entryInfo.getProductDate() != null && entryInfo.getExpireDate() != null && entryInfo.getExpireDate().compareTo(entryInfo.getProductDate()) <= 0) {
                    errorMsg.append(prefix).append(this.getResource(ctx, "expireDateMustLarger")).append("\n");
                }
                if (entryInfo.getWarehouse() == null) {
                    errorMsg.append(prefix).append(this.getResource(ctx, "warehouseNull")).append("\n");
                }
                if (entryInfo.getWarehouse() == null || !entryInfo.getWarehouse().isHasLocation() || entryInfo.getLocation() != null) continue;
                errorMsg.append(prefix).append(this.getResource(ctx, "locationNull")).append("\n");
            }
        }
        if (errorMsg.length() > 0) {
            throw new DDMReceivalBillException(DDMReceivalBillException.BASEEXCEPTION, new String[]{errorMsg.toString()});
        }
    }

    private String getResource(Context ctx, String name) {
        return ResourceManage.getResource((String)"com.kingdee.eas.mm.control.DDMReceivalBillResource", (String)name, (Locale)ctx.getLocale());
    }

    private void checkPermission(Context ctx, DDMReceivalBillInfo info, boolean isAudit) throws BOSException, EASBizException {
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        ObjectUuidPK userId = new ObjectUuidPK(userInfo.getId());
        ObjectUuidPK orgId = new ObjectUuidPK(info.getStorageOrgUnit().getId());
        IPermission iPermission = PermissionFactory.getLocalInstance((Context)ctx);
        if (isAudit) {
            try {
                iPermission.checkFunctionPermission((IObjectPK)userId, (IObjectPK)orgId, "purinwarehs_new");
            }
            catch (EASBizException e) {
                throw new DDMReceivalBillException(DDMReceivalBillException.PERM_PURINWAREHS_NEW);
            }
            try {
                iPermission.checkFunctionPermission((IObjectPK)userId, (IObjectPK)orgId, "materialreq_new");
            }
            catch (EASBizException e) {
                throw new DDMReceivalBillException(DDMReceivalBillException.PERM_MATERIALREQ_NEW);
            }
            try {
                iPermission.checkFunctionPermission((IObjectPK)userId, (IObjectPK)orgId, "purinwarehs_audit");
            }
            catch (EASBizException e) {
                throw new DDMReceivalBillException(DDMReceivalBillException.PERM_PURINWAREHS_AUDIT);
            }
            try {
                iPermission.checkFunctionPermission((IObjectPK)userId, (IObjectPK)orgId, "materialreq_audit");
            }
            catch (EASBizException e) {
                throw new DDMReceivalBillException(DDMReceivalBillException.PERM_MATERIALREQ_AUDIT);
            }
        }
        try {
            iPermission.checkFunctionPermission((IObjectPK)userId, (IObjectPK)orgId, "purinwarehs_unAudit");
        }
        catch (EASBizException e) {
            throw new DDMReceivalBillException(DDMReceivalBillException.PERM_PURINWAREHS_UNAUDIT);
        }
        try {
            iPermission.checkFunctionPermission((IObjectPK)userId, (IObjectPK)orgId, "purinwarehs_del");
        }
        catch (EASBizException e) {
            throw new DDMReceivalBillException(DDMReceivalBillException.PERM_PURINWAREHS_UNAUDIT);
        }
        try {
            iPermission.checkFunctionPermission((IObjectPK)userId, (IObjectPK)orgId, "materialreq_unAudit");
        }
        catch (EASBizException e) {
            throw new DDMReceivalBillException(DDMReceivalBillException.PERM_MATERIALREQ_UNAUDIT);
        }
        try {
            iPermission.checkFunctionPermission((IObjectPK)userId, (IObjectPK)orgId, "materialreq_delete");
        }
        catch (EASBizException e) {
            throw new DDMReceivalBillException(DDMReceivalBillException.PERM_MATERIALREQ_UNAUDIT);
        }
    }

    private void checkCodingRule(Context ctx, DDMReceivalBillInfo info) throws BOSException, EASBizException {
        PurInWarehsBillInfo pibInfo = new PurInWarehsBillInfo();
        pibInfo.setStorageOrgUnit(info.getStorageOrgUnit());
        boolean isExistNumber1 = CommonUtils.existCodingRule((Context)ctx, (IObjectValue)pibInfo, (String)pibInfo.getStorageOrgUnit().getId().toString());
        if (!isExistNumber1) {
            throw new DDMReceivalBillException(DDMReceivalBillException.CODINGRULE_NO_PURINWAREHS);
        }
        MaterialReqBillInfo mrbInfo = new MaterialReqBillInfo();
        mrbInfo.setStorageOrgUnit(info.getStorageOrgUnit());
        boolean isExistNumber2 = CommonUtils.existCodingRule((Context)ctx, (IObjectValue)mrbInfo, (String)mrbInfo.getStorageOrgUnit().getId().toString());
        if (!isExistNumber2) {
            throw new DDMReceivalBillException(DDMReceivalBillException.CODINGRULE_NO_MATERIALREQ);
        }
    }

    private void generateDestBill(Context ctx, DDMReceivalBillInfo info) throws BOSException, EASBizException {
        String srcBosTypeString = "7AB0A0DA";
        BOSObjectType srcBosType = new BOSObjectType("7AB0A0DA");
        String pBosTypeString = "783061E3";
        BOSObjectType pBosType = new BOSObjectType("783061E3");
        String mBosTypeString = "500AB75E";
        BOSObjectType mBosType = new BOSObjectType("500AB75E");
        BOTMappingCollection purInWarehsRuleCollection = BOTMappingHelper.getMappingForSelect((Context)ctx, (String)srcBosTypeString, (String)pBosTypeString, (DefineSysEnum)DefineSysEnum.BTP, null);
        if (purInWarehsRuleCollection.size() == 0) {
            throw new DDMReceivalBillException(DDMReceivalBillException.BOTP_NO_PURINWAREHSBILL);
        }
        BOTMappingCollection materialReqRuleCollection = BOTMappingHelper.getMappingForSelect((Context)ctx, (String)srcBosTypeString, (String)mBosTypeString, (DefineSysEnum)DefineSysEnum.BTP, null);
        if (materialReqRuleCollection.size() == 0) {
            throw new DDMReceivalBillException(DDMReceivalBillException.BOTP_NO_MATERIALREQBILL);
        }
        String purInWarehsBOTPID = purInWarehsRuleCollection.get(0).getId().toString();
        String materialReqBOTPID = materialReqRuleCollection.get(0).getId().toString();
        CoreBaseCollection srcBillCollection = new CoreBaseCollection();
        srcBillCollection.addObject((IObjectValue)info);
        IObjectCollection destBillCollection = null;
        IObjectValue objectValue = null;
        IObjectPK objectPK = null;
        BTPTransformResult pBOTPResult = CommonUtils.mapppingToBills2((Context)ctx, null, null, (BOSObjectType)srcBosType, (BOSObjectType)pBosType, (String)purInWarehsBOTPID, (IObjectCollection)srcBillCollection, (boolean)true);
        destBillCollection = pBOTPResult.getBills();
        IPurInWarehsBill iPIB = PurInWarehsBillFactory.getLocalInstance((Context)ctx);
        PurInWarehsBillInfo pibInfo = null;
        for (int i = 0; i < destBillCollection.size(); ++i) {
            objectValue = destBillCollection.getObject(i);
            pibInfo = (PurInWarehsBillInfo)objectValue;
            try {
                if (WfEventListenerStateManager.getInstance().isEnable()) {
                    WfEventListenerStateManager.getInstance().disableEventListener();
                }
                if (BillBaseStatusEnum.AUDITED.equals((Object)(pibInfo = iPIB.getPurInWarehsBillInfo(objectPK = iPIB.submit((CoreBaseInfo)pibInfo))).getBaseStatus())) continue;
                iPIB.audit(objectPK);
                continue;
            }
            catch (EASBizException e) {
                String prefix = this.getResource(ctx, "purInWarehsBill") + pibInfo.getNumber() + this.getResource(ctx, "colon");
                String errorMsg = e.getMessage(ctx.getLocale());
                throw new DDMReceivalBillException(DDMReceivalBillException.BASEEXCEPTION, new String[]{prefix + errorMsg});
            }
            finally {
                if (!WfEventListenerStateManager.getInstance().isEnable()) {
                    WfEventListenerStateManager.getInstance().enableEventListener();
                }
            }
        }
        BTPTransformResult mBOTPResult = CommonUtils.mapppingToBills2((Context)ctx, null, null, (BOSObjectType)srcBosType, (BOSObjectType)mBosType, (String)materialReqBOTPID, (IObjectCollection)srcBillCollection, (boolean)true);
        destBillCollection = mBOTPResult.getBills();
        IMaterialReqBill iMRB = MaterialReqBillFactory.getLocalInstance((Context)ctx);
        MaterialReqBillInfo mrbInfo = null;
        try {
            if (WfEventListenerStateManager.getInstance().isEnable()) {
                WfEventListenerStateManager.getInstance().disableEventListener();
            }
            for (int i = 0; i < destBillCollection.size(); ++i) {
                objectValue = destBillCollection.getObject(i);
                mrbInfo = (MaterialReqBillInfo)objectValue;
                objectPK = iMRB.submit((CoreBaseInfo)mrbInfo);
                if (BillBaseStatusEnum.AUDITED.equals((Object)(mrbInfo = iMRB.getMaterialReqBillInfo(objectPK)).getBaseStatus())) continue;
                iMRB.audit(objectPK);
            }
        }
        catch (EASBizException e) {
            String prefix = this.getResource(ctx, "materialReqBill") + mrbInfo.getNumber() + this.getResource(ctx, "colon");
            String errorMsg = e.getMessage(ctx.getLocale());
            throw new DDMReceivalBillException(DDMReceivalBillException.BASEEXCEPTION, new String[]{prefix + errorMsg});
        }
        finally {
            if (!WfEventListenerStateManager.getInstance().isEnable()) {
                WfEventListenerStateManager.getInstance().enableEventListener();
            }
        }
    }

    private void removeDestBill(Context ctx, DDMReceivalBillInfo info) throws BOSException, EASBizException {
        String srcObjId = info.getId().toString();
        String pBosTypeString = "783061E3";
        String mBosTypeString = "500AB75E";
        ArrayList destBillIdList = null;
        String destbillID = null;
        ObjectUuidPK destbillPK = null;
        String destBillNumber = null;
        String prefix = null;
        String colon = this.getResource(ctx, "colon");
        destBillIdList = BotRelationUtil.getDestObjectIdByDestType((Context)ctx, (String)srcObjId, (String)mBosTypeString);
        String mPrefix = this.getResource(ctx, "materialReqBill");
        IMaterialReqBill iMRB = MaterialReqBillFactory.getLocalInstance((Context)ctx);
        for (int i = 0; i < destBillIdList.size(); ++i) {
            destbillID = (String)destBillIdList.get(i);
            destbillPK = new ObjectUuidPK(BOSUuid.read((String)destbillID));
            try {
                destBillNumber = iMRB.getMaterialReqBillInfo((IObjectPK)destbillPK).getNumber();
                iMRB.unAudit((IObjectPK)destbillPK);
                iMRB.delete((IObjectPK)destbillPK);
                continue;
            }
            catch (EASBizException e) {
                String errorMsg = e.getMessage(ctx.getLocale());
                prefix = mPrefix + destBillNumber + colon;
                throw new DDMReceivalBillException(DDMReceivalBillException.BASEEXCEPTION, new String[]{prefix + errorMsg});
            }
        }
        destBillIdList = BotRelationUtil.getDestObjectIdByDestType((Context)ctx, (String)srcObjId, (String)pBosTypeString);
        String pPrefix = this.getResource(ctx, "purInWarehsBill");
        IPurInWarehsBill iPIB = PurInWarehsBillFactory.getLocalInstance((Context)ctx);
        for (int i = 0; i < destBillIdList.size(); ++i) {
            destbillID = (String)destBillIdList.get(i);
            destbillPK = new ObjectUuidPK(BOSUuid.read((String)destbillID));
            try {
                destBillNumber = iPIB.getPurInWarehsBillInfo((IObjectPK)destbillPK).getNumber();
                iPIB.unAudit((IObjectPK)destbillPK);
                iPIB.delete((IObjectPK)destbillPK);
                continue;
            }
            catch (EASBizException e) {
                String errorMsg = e.getMessage(ctx.getLocale());
                prefix = pPrefix + destBillNumber + colon;
                throw new DDMReceivalBillException(DDMReceivalBillException.BASEEXCEPTION, new String[]{prefix + errorMsg});
            }
        }
    }

    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        DDMReceivalBillInfo info = (DDMReceivalBillInfo)this.getValue(ctx, pk);
        if (info.getBaseStatus() != BillBaseStatusEnum.SUBMITED) {
            String errorMsg = ResourceBase.getString((String)"com.kingdee.eas.scm.common.SCMResource.NotAudit", (Locale)ctx.getLocale());
            throw new DDMReceivalBillException(DDMReceivalBillException.BASEEXCEPTION, new String[]{errorMsg});
        }
        CompanyOrgUnitInfo companyOrgInfo = info.getCompanyOrgUnit();
        if (companyOrgInfo == null) {
            companyOrgInfo = CommonUtils.getCompanyOrgByStorageOrg((Context)ctx, (String)info.getStorageOrgUnit().getId().toString());
            if (companyOrgInfo == null) {
                throw new DDMReceivalBillException(DDMReceivalBillException.STORAGEORGNOTHASCOMPANYORG);
            }
            info.setCompanyOrgUnit(companyOrgInfo);
        }
        this.update_whileAudit(ctx, info);
        DDMReceivalBillEntryCollection entryCollection = info.getEntrys();
        for (int i = 0; i < entryCollection.size(); ++i) {
            DDMReceivalBillEntryInfo entryInfo = entryCollection.get(i);
            DDMReceivalBillEntryTargetEntryCollection targetCollection = entryInfo.getTargetEntry();
            this.writeBackStockEntry(ctx, targetCollection, true);
        }
        if (info.getSourceType().getValue() == 20 || info.getSourceType().getValue() == 30) {
            ArrayList<String> idList = new ArrayList<String>();
            idList.add(pk.getKeyValue(null).toString());
            FinishedRptFactory.getLocalInstance(ctx).writeBackDirectDisQty(idList, true);
        }
        if (info.getSourceType().getValue() == 10) {
            this.checkPermission(ctx, info, true);
            this.checkCodingRule(ctx, info);
            this.generateDestBill(ctx, info);
        }
    }

    public void _unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        DDMReceivalBillInfo info = (DDMReceivalBillInfo)this.getValue(ctx, pk);
        if (info.getBaseStatus() != BillBaseStatusEnum.AUDITED) {
            String errorMsg = ResourceBase.getString((String)"com.kingdee.eas.scm.common.SCMResource.NotUnAudit", (Locale)ctx.getLocale());
            throw new DDMReceivalBillException(DDMReceivalBillException.BASEEXCEPTION, new String[]{errorMsg});
        }
        String orgUnitID = info.getStorageOrgUnit().getId().toString();
        if (!this.isUnAudit(ctx, info, orgUnitID, 4)) {
            throw new SCMBillException(SCMBillException.ISUNAUDITINPARAM);
        }
        this.update_whileUnAudit(ctx, info);
        DDMReceivalBillEntryCollection entryCollection = info.getEntrys();
        for (int i = 0; i < entryCollection.size(); ++i) {
            DDMReceivalBillEntryInfo entryInfo = entryCollection.get(i);
            DDMReceivalBillEntryTargetEntryCollection targetCollection = entryInfo.getTargetEntry();
            this.writeBackStockEntry(ctx, targetCollection, false);
        }
        if (info.getSourceType().getValue() == 20 || info.getSourceType().getValue() == 30) {
            ArrayList<String> idList = new ArrayList<String>();
            idList.add(pk.getKeyValue(null).toString());
            FinishedRptFactory.getLocalInstance(ctx).writeBackDirectDisQty(idList, false);
        }
        if (info.getSourceType().getValue() == 10) {
            this.checkPermission(ctx, info, false);
            this.removeDestBill(ctx, info);
        }
    }

    private void update_whileUnAudit(Context ctx, DDMReceivalBillInfo info) throws EASBizException, BOSException {
        info.setAuditor(null);
        info.setAuditTime(null);
        info.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        DDMReceivalBillEntryCollection collection = info.getEntrys();
        for (int j = 0; j < collection.size(); ++j) {
            collection.get(j).setBaseStatus(EntryBaseStatusEnum.TEMPORARILYSAVED);
        }
        this.update(ctx, (IObjectPK)new ObjectUuidPK(info.getId()), (CoreBaseInfo)info);
    }

    private void update_whileAudit(Context ctx, DDMReceivalBillInfo info) throws EASBizException, BOSException {
        info.setAuditor(UserFactory.getLocalInstance((Context)ctx).getUserInfo(ctx.getCaller()));
        info.setAuditTime(new Timestamp(System.currentTimeMillis()));
        info.setBaseStatus(BillBaseStatusEnum.AUDITED);
        DDMReceivalBillEntryCollection collection = info.getEntrys();
        for (int j = 0; j < collection.size(); ++j) {
            collection.get(j).setBaseStatus(EntryBaseStatusEnum.AUDITED);
        }
        this.update(ctx, (IObjectPK)new ObjectUuidPK(info.getId()), (CoreBaseInfo)info);
    }

    public void writeBackStockEntry(Context ctx, DDMReceivalBillEntryTargetEntryCollection targetCollection, boolean isAudit) throws EASBizException, BOSException {
        DDMReceivalBillEntryTargetEntryInfo targetInfo = null;
        IProductionOrderStockEntry iStockEntry = ProductionOrderStockEntryFactory.getLocalInstance(ctx);
        ProductionOrderStockEntryInfo stockEntryInfo = null;
        for (int i = 0; i < targetCollection.size(); ++i) {
            targetInfo = targetCollection.get(i);
            BOSUuid stockEntryId = targetInfo.getStockEntry().getId();
            ObjectUuidPK stockEntryPK = new ObjectUuidPK(stockEntryId);
            BigDecimal receiveQty = targetInfo.getReceiveQty();
            BigDecimal bsReceiveQty = targetInfo.getBaseReceiveQty();
            if (!isAudit) {
                receiveQty = receiveQty.negate();
                bsReceiveQty = bsReceiveQty.negate();
            }
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("*"));
            selector.add(new SelectorItemInfo("parent.*"));
            selector.add(new SelectorItemInfo("materialInventory.*"));
            stockEntryInfo = (ProductionOrderStockEntryInfo)iStockEntry.getValue((IObjectPK)stockEntryPK, selector);
            stockEntryInfo.setTotleReceiveQty(stockEntryInfo.getTotleReceiveQty().add(receiveQty));
            stockEntryInfo.setBaseTotleReceiveQty(stockEntryInfo.getBaseTotleReceiveQty().add(bsReceiveQty));
            if (isAudit) {
                BigDecimal maxRequiredBaseQty = stockEntryInfo.getBaseQty();
                MaterialPlanInfo planInfo = stockEntryInfo.getMaterialInventory();
                if (planInfo != null && planInfo.isIsQuotaControl()) {
                    maxRequiredBaseQty = maxRequiredBaseQty.multiply(planInfo.getIssInHightLimit().add(new BigDecimal(1)));
                }
                if (maxRequiredBaseQty.compareTo(stockEntryInfo.getBaseTotleReceiveQty()) < 0) {
                    String pdOrder = stockEntryInfo.getParent().getNumber().toString();
                    String lineSeq = stockEntryInfo.getLineSeq();
                    throw new DDMReceivalBillException(DDMReceivalBillException.TOTALRCVQTYMORETHANREQQTY, new String[]{pdOrder, lineSeq});
                }
            }
            iStockEntry.update((IObjectPK)stockEntryPK, stockEntryInfo);
        }
    }

    public void writeBackPurOrder(Context ctx, DDMReceivalBillEntryCollection entryColl, boolean isAudit) throws EASBizException, BOSException {
        DDMReceivalBillEntryInfo entryInfo = null;
        IPurOrderEntry iPurEntry = PurOrderEntryFactory.getLocalInstance((Context)ctx);
        PurOrderEntryInfo purEntryInfo = null;
        BOSUuid purEntryId = null;
        ObjectUuidPK purEntryPK = null;
        BigDecimal receiveQty = null;
        BigDecimal bsReceiveQty = null;
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("parent.id"));
        selector.add(new SelectorItemInfo("parent.number"));
        for (int i = 0; i < entryColl.size(); ++i) {
            entryInfo = entryColl.get(i);
            purEntryId = entryInfo.getPurOrderEntry().getId();
            purEntryPK = new ObjectUuidPK(purEntryId);
            receiveQty = entryInfo.getReceiveQty();
            bsReceiveQty = entryInfo.getBaseReceiveQty();
            if (!isAudit) {
                receiveQty = receiveQty.negate();
                bsReceiveQty = bsReceiveQty.negate();
            }
            purEntryInfo = iPurEntry.getPurOrderEntryInfo((IObjectPK)purEntryPK, selector);
            purEntryInfo.setTotalReceiveQty(purEntryInfo.getTotalReceiveQty().add(receiveQty));
            purEntryInfo.setTotalReceiveBaseQty(purEntryInfo.getTotalReceiveBaseQty().add(bsReceiveQty));
            if (isAudit && purEntryInfo.getBaseQty().compareTo(purEntryInfo.getTotalReceiveBaseQty()) < 0) {
                String purOrderNumber = purEntryInfo.getParent().getNumber();
                String seq = String.valueOf(purEntryInfo.getSeq());
                throw new DDMReceivalBillException(DDMReceivalBillException.WRITEBACK_PURORDER, new String[]{purOrderNumber, seq});
            }
            iPurEntry.update((IObjectPK)purEntryPK, (CoreBaseInfo)purEntryInfo);
        }
    }
}

