/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.control.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryCollection;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.LotFrame;
import com.kingdee.eas.basedata.scm.im.inv.LotRuleFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.lot.LotFacadeFactory;
import com.kingdee.eas.mm.lot.LotParamValueInfo;
import java.util.ArrayList;
import java.util.List;

public class FinishedRPTServerUtils {
    public static int dealLotNoSituation(StorageOrgUnitInfo sou, MaterialInfo material, boolean isRelateTaskDisp, Context ctx) throws EASBizException, BOSException {
        if (material == null || sou == null) {
            return 0;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)material.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)sou.getId().toString(), CompareType.EQUALS));
        EntityViewInfo viewer = new EntityViewInfo();
        viewer.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("isLotNumber");
        viewer.setSelector(selector);
        MaterialInventoryCollection inv = MaterialInventoryFactory.getLocalInstance((Context)ctx).getMaterialInventoryCollection(viewer);
        if (inv.size() <= 0) {
            return 0;
        }
        MaterialInventoryInfo invInfo = inv.get(0);
        if (!invInfo.isIsLotNumber()) {
            return 0;
        }
        LotFrame lotFrame = new LotFrame();
        lotFrame.setMainBizOrg(sou.getId().toString());
        lotFrame.setMaterial(material.getId().toString());
        List lotList = new ArrayList<LotFrame>();
        lotList.add(lotFrame);
        lotList = LotRuleFactory.getLocalInstance((Context)ctx).fillLotFramesNoSerial(lotList);
        if (lotList != null && lotList.size() > 0) {
            lotFrame = (LotFrame)lotList.get(0);
        }
        LotParamValueInfo param = LotFacadeFactory.getLocalInstance((Context)ctx).getLotParamValueByOrg(sou.getId().toString());
        boolean isPlanOrderGene = param.isProductionOrderPlan();
        boolean isPrdOrderGene = param.isProductionOrderProduction();
        boolean isTaskDispGene = param.isProductionOrderTaskDisp();
        boolean isFinRptGene = param.isProductionOrderFinishedRpt();
        if (isRelateTaskDisp) {
            if (null == lotFrame || null == lotFrame.getLotRule()) {
                return FinishedRPTServerUtils.getReturnValueFromTask(isPlanOrderGene, isPrdOrderGene, isTaskDispGene, isFinRptGene);
            }
            return FinishedRPTServerUtils.getReturnValueFromTask(isPlanOrderGene, isPrdOrderGene, isTaskDispGene, isFinRptGene);
        }
        if (null == lotFrame || null == lotFrame.getLotRule()) {
            return FinishedRPTServerUtils.getReturnValueFormPrd(isPlanOrderGene, isPrdOrderGene, isFinRptGene);
        }
        return FinishedRPTServerUtils.getReturnValueFormPrd(isPlanOrderGene, isPrdOrderGene, isFinRptGene);
    }

    private static int getReturnValueFromTask(boolean isPlanOrderGene, boolean isPrdOrderGene, boolean isTaskDispGene, boolean isFinRptGene) {
        if (isPlanOrderGene) {
            return 1;
        }
        if (isTaskDispGene) {
            return 1;
        }
        if (isFinRptGene) {
            return 1;
        }
        return 0;
    }

    private static int getReturnValueFormPrd(boolean isPlanOrderGene, boolean isPrdOrderGene, boolean isFinRptGene) {
        if (isPlanOrderGene) {
            return 1;
        }
        if (isPrdOrderGene) {
            return 1;
        }
        if (isFinRptGene) {
            return 1;
        }
        return 0;
    }

    public static boolean dealLotNoToMaterialReq(StorageOrgUnitInfo sou, MaterialInfo material, Context ctx) throws EASBizException, BOSException {
        if (material == null || sou == null) {
            return false;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)material.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)sou.getId().toString(), CompareType.EQUALS));
        EntityViewInfo viewer = new EntityViewInfo();
        viewer.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("isLotNumber");
        viewer.setSelector(selector);
        MaterialInventoryCollection inv = MaterialInventoryFactory.getLocalInstance((Context)ctx).getMaterialInventoryCollection(viewer);
        if (inv.size() <= 0) {
            return false;
        }
        MaterialInventoryInfo invInfo = inv.get(0);
        if (!invInfo.isIsLotNumber()) {
            return false;
        }
        LotParamValueInfo param = LotFacadeFactory.getLocalInstance((Context)ctx).getLotParamValueByOrg(sou.getId().toString());
        boolean isProductionOrderRec = param.isProductionOrderRec();
        return isProductionOrderRec;
    }
}

