/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.control.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectSingleKey;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.batch.BatchExecuteResult;
import com.kingdee.bos.framework.bp.BPOption;
import com.kingdee.bos.framework.bp.BPResult;
import com.kingdee.bos.framework.bp.DynamicBackground;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.IServiceContext;
import com.kingdee.bos.sql.util.StringUtil;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.IMaterialInventory;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialAttributeEnum;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryCollection;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.master.material.MaterialIssueModeEnum;
import com.kingdee.eas.basedata.master.material.MaterialPlanCollection;
import com.kingdee.eas.basedata.master.material.MaterialPlanFactory;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.master.material.MaterialProductEnum;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.QualityOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.ITransactionType;
import com.kingdee.eas.basedata.scm.common.TransactionTypeCollection;
import com.kingdee.eas.basedata.scm.common.TransactionTypeFactory;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.batchaction.ActionCommonException;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.mm.basedata.ProductLineWPEntryInfo;
import com.kingdee.eas.mm.common.MMCommonException;
import com.kingdee.eas.mm.common.app.DBBatchUtil;
import com.kingdee.eas.mm.common.backFlush.BackFlushRecordFactory;
import com.kingdee.eas.mm.common.backFlush.BackFlushStatusEnum;
import com.kingdee.eas.mm.common.backFlush.BatchBackFlushResults;
import com.kingdee.eas.mm.common.backFlush.app.BFCalcParam;
import com.kingdee.eas.mm.common.backFlush.app.processor.GeneralBFProcessor;
import com.kingdee.eas.mm.common.backFlush.util.BackFlushUtil;
import com.kingdee.eas.mm.common.util.ResourceManage;
import com.kingdee.eas.mm.control.AbstractFinishedRptEntryInfo;
import com.kingdee.eas.mm.control.BizTypeEnum;
import com.kingdee.eas.mm.control.DDMReceivalBillCollection;
import com.kingdee.eas.mm.control.DDMReceivalBillEntryCollection;
import com.kingdee.eas.mm.control.DDMReceivalBillEntryFactory;
import com.kingdee.eas.mm.control.DDMReceivalBillEntryInfo;
import com.kingdee.eas.mm.control.DDMReceivalBillEntryTargetEntryInfo;
import com.kingdee.eas.mm.control.DDMReceivalBillFactory;
import com.kingdee.eas.mm.control.DDMReceivalBillInfo;
import com.kingdee.eas.mm.control.DDMSourceBillTypeEnum;
import com.kingdee.eas.mm.control.DirectDisChildVO;
import com.kingdee.eas.mm.control.DirectDisParentVO;
import com.kingdee.eas.mm.control.FinishedRptBOTPParams;
import com.kingdee.eas.mm.control.FinishedRptBillingVO;
import com.kingdee.eas.mm.control.FinishedRptCRCollection;
import com.kingdee.eas.mm.control.FinishedRptCRFactory;
import com.kingdee.eas.mm.control.FinishedRptCRInfo;
import com.kingdee.eas.mm.control.FinishedRptCollection;
import com.kingdee.eas.mm.control.FinishedRptEntryCollection;
import com.kingdee.eas.mm.control.FinishedRptEntryFactory;
import com.kingdee.eas.mm.control.FinishedRptEntryInfo;
import com.kingdee.eas.mm.control.FinishedRptException;
import com.kingdee.eas.mm.control.FinishedRptFacadeFactory;
import com.kingdee.eas.mm.control.FinishedRptFactory;
import com.kingdee.eas.mm.control.FinishedRptInfo;
import com.kingdee.eas.mm.control.FinishedRptTypeEnum;
import com.kingdee.eas.mm.control.IProductionOrder;
import com.kingdee.eas.mm.control.ProductionOrderCollection;
import com.kingdee.eas.mm.control.ProductionOrderEntryCollection;
import com.kingdee.eas.mm.control.ProductionOrderEntryInfo;
import com.kingdee.eas.mm.control.ProductionOrderFacadeFactory;
import com.kingdee.eas.mm.control.ProductionOrderFactory;
import com.kingdee.eas.mm.control.ProductionOrderInfo;
import com.kingdee.eas.mm.control.ProductionOrderOutputEntryCollection;
import com.kingdee.eas.mm.control.ProductionOrderOutputEntryInfo;
import com.kingdee.eas.mm.control.ProductionOrderStockEntryCollection;
import com.kingdee.eas.mm.control.ProductionOrderStockEntryInfo;
import com.kingdee.eas.mm.control.TaskDispBillFactory;
import com.kingdee.eas.mm.control.TaskDispBillInfo;
import com.kingdee.eas.mm.control.app.AbstractFinishedRptControllerBean;
import com.kingdee.eas.mm.control.app.FinishedRPTServerUtils;
import com.kingdee.eas.mm.control.app.PoMaterialWithDraw;
import com.kingdee.eas.mm.control.util.FinishedRptUtil;
import com.kingdee.eas.mm.lot.LotFacadeFactory;
import com.kingdee.eas.qm.common.QMBillBaseInfo;
import com.kingdee.eas.qm.common.QMBillBaseStatusEnum;
import com.kingdee.eas.qm.qc.QCRequestFactory;
import com.kingdee.eas.qm.qc.QCRequestInfo;
import com.kingdee.eas.qm.qc.QCReturnResultInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.common.ISCMBillParam;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillParamFactory;
import com.kingdee.eas.scm.common.SCMGroupFacadeFactory;
import com.kingdee.eas.scm.common.loadmass.SCMEntryDataVO;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.im.dt.util.DtUtils;
import com.kingdee.eas.scm.im.inv.IManufactureRecBill;
import com.kingdee.eas.scm.im.inv.IMaterialReqBill;
import com.kingdee.eas.scm.im.inv.IOtherInWarehsBill;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.ManufactureRecBillEntryCollection;
import com.kingdee.eas.scm.im.inv.ManufactureRecBillEntryFactory;
import com.kingdee.eas.scm.im.inv.ManufactureRecBillEntryInfo;
import com.kingdee.eas.scm.im.inv.ManufactureRecBillFactory;
import com.kingdee.eas.scm.im.inv.ManufactureRecBillInfo;
import com.kingdee.eas.scm.im.inv.MaterialReqBillEntryInfo;
import com.kingdee.eas.scm.im.inv.MaterialReqBillInfo;
import com.kingdee.eas.scm.im.inv.OtherInWarehsBillFactory;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import com.kingdee.util.db.SQLUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class FinishedRptControllerBean
extends AbstractFinishedRptControllerBean {
    private static final long serialVersionUID = -3266558695075666702L;
    private static Logger logger = Logger.getLogger((String)FinishedRptControllerBean.class.getName());
    private static final String RCVIN_HIGHT_LIMIT = "RCVIN_HIGHT_LIMIT";
    private static final String RCVIN_LOW_LIMIT = "RCVIN_LOW_LIMIT";
    private static final String RCV_DISPERSION_BASE = "RCV_DISPERSION_BASE";
    private static final String ISSTORAGELIMIT = "isStorageLimit";
    private static final String ISREPORTLIMIT = "isreportlimit";
    private Map scmSubmitAuditParam = null;

    private Map getFRCVInLimit(Context ctx, String manufactureRecBillId, String orgId) throws BOSException {
        String kSQL = "select FMaterialID, FRCVInLowLimit, FRCVInHightLimit, FRCVDispersionBase ,FisStorageLimit from T_BD_MaterialPlan where FMaterialID in (select r.FMaterialID from T_IM_ManufactureRecBillEntry r where r.FParentID = ? ) And FOrgUnit = '" + orgId + "'";
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)kSQL, (Object[])new Object[]{manufactureRecBillId});
        HashMap result = new HashMap();
        if (null != rows) {
            try {
                while (rows.next()) {
                    HashMap<String, Serializable> materialFRCVInLowLimit = new HashMap<String, Serializable>();
                    String materialid = rows.getString("FMaterialID");
                    BigDecimal lowLimtValue = rows.getBigDecimal("FRCVInLowLimit") == null ? new BigDecimal(String.valueOf(0.0)) : rows.getBigDecimal("FRCVInLowLimit");
                    lowLimtValue = lowLimtValue.setScale(4, 5).divide(new BigDecimal(String.valueOf(100)), 5);
                    BigDecimal hignLimitValue = rows.getBigDecimal("FRCVInHightLimit") == null ? new BigDecimal(String.valueOf(0.0)) : rows.getBigDecimal("FRCVInHightLimit");
                    hignLimitValue = hignLimitValue.setScale(4, 5).divide(new BigDecimal(String.valueOf(100)), 5);
                    Integer dispersionBase = new Integer(rows.getInt("FRCVDispersionBase"));
                    Boolean isStorageLimit = new Boolean(rows.getBoolean("FisStorageLimit"));
                    materialFRCVInLowLimit.put(RCVIN_HIGHT_LIMIT, hignLimitValue);
                    materialFRCVInLowLimit.put(RCVIN_LOW_LIMIT, lowLimtValue);
                    materialFRCVInLowLimit.put(RCV_DISPERSION_BASE, dispersionBase);
                    materialFRCVInLowLimit.put(ISSTORAGELIMIT, isStorageLimit);
                    result.put(materialid, materialFRCVInLowLimit);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return result;
    }

    @Override
    protected void _writeBackStockTotalQty(Context ctx, List pkList, boolean writeBack) throws BOSException, EASBizException {
        if (null == pkList || pkList.size() == 0) {
            return;
        }
        IManufactureRecBill iManufactureRecBill = ManufactureRecBillFactory.getLocalInstance((Context)ctx);
        IOtherInWarehsBill iOtherInWarehsBill = OtherInWarehsBillFactory.getLocalInstance((Context)ctx);
        ArrayList<String> idList = new ArrayList<String>();
        Iterator iter = pkList.iterator();
        while (iter.hasNext()) {
            BOSObjectType billBOSType;
            String id = iter.next().toString();
            ObjectUuidPK pk = new ObjectUuidPK(id);
            try {
                billBOSType = BOSUuid.read((String)id).getType();
            }
            catch (UuidException e) {
                logger.error((Object)e.getMessage());
                continue;
            }
            catch (IllegalArgumentException e) {
                logger.error((Object)e.getMessage());
                continue;
            }
            Object billInfo = billBOSType.equals((Object)BOSObjectType.create((String)"FA1292B4")) ? iManufactureRecBill.getManufactureRecBillInfo((IObjectPK)pk) : iOtherInWarehsBill.getOtherInWarehsBillInfo((IObjectPK)pk);
            IObjectCollection recEntryCollection = (IObjectCollection)billInfo.get("entry");
            InvBillBaseEntryInfo entryInfo2 = null;
            HashMap<String, Boolean> hasWriteBack = new HashMap<String, Boolean>();
            for (InvBillBaseEntryInfo entryInfo2 : recEntryCollection) {
                Object o = hasWriteBack.get(entryInfo2.getSourceBillId().toString());
                if (o == null) {
                    this.writeBackStockTotalQty(ctx, entryInfo2.getSourceBillId(), (InvBillBaseInfo)billInfo, writeBack);
                    hasWriteBack.put(entryInfo2.getSourceBillId().toString(), Boolean.TRUE);
                }
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add("*");
                sic.add("productionOrder.*");
                FinishedRptInfo info = (FinishedRptInfo)FinishedRptFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(entryInfo2.getSourceBillId()), sic);
                idList.add(info.getProductionOrder().getId().toString());
            }
        }
        ProductionOrderFacadeFactory.getLocalInstance(ctx).dealAutoFinished(idList, writeBack);
    }

    @Override
    protected void _writeBackStockTotalQty(Context ctx, String finishedRptId, ManufactureRecBillInfo recBillInfo, boolean writeBack) throws BOSException, EASBizException {
        if (null == finishedRptId || "".equals(finishedRptId) || null == recBillInfo) {
            return;
        }
        FinishedRptInfo finishedRpt = this.getFinishedRptInfoById(ctx, finishedRptId);
        String passTransactionTypes = FinishedRptFactory.getLocalInstance(ctx).getPassTransactionTypes();
        if (null != finishedRpt && null != finishedRpt.getEntrys() && null != recBillInfo.getEntry()) {
            String productionOrderId = finishedRpt.getProductionOrder().getId().toString();
            ProductionOrderInfo productionOrder = ProductionOrderFactory.getLocalInstance(ctx).getProductionOrderInfo((IObjectPK)new ObjectUuidPK(productionOrderId));
            if (BillBaseStatusEnum.CLOSED == productionOrder.getBaseStatus()) {
                if (writeBack) {
                    throw new FinishedRptException(FinishedRptException.BLANK, new String[]{FinishedRptUtil.getResource("Msg_OrderStatusCheckForReqAudit", ctx)});
                }
                throw new FinishedRptException(FinishedRptException.BLANK, new String[]{FinishedRptUtil.getResource("Msg_OrderStatusCheckForReqUnAudit", ctx)});
            }
            String taskDispBillId = null;
            boolean isTaskDisp = false;
            if (null != finishedRpt.getTaskDispBill()) {
                taskDispBillId = finishedRpt.getTaskDispBill().getId().toString();
                isTaskDisp = true;
            }
            Map materialFRCVInLimit = this.getFRCVInLimit(ctx, recBillInfo.getId().toString(), finishedRpt.getStorageOrgUnit().getId().toString());
            HashMap<String, MaterialProductEnum> materialOutType = new HashMap<String, MaterialProductEnum>();
            HashMap<String, FinishedRptEntryInfo> idEntryMap = new HashMap<String, FinishedRptEntryInfo>();
            Iterator iter = finishedRpt.getEntrys().iterator();
            while (iter.hasNext()) {
                FinishedRptEntryInfo element = (FinishedRptEntryInfo)iter.next();
                materialOutType.put(element.getId().toString(), element.getOutputType());
                idEntryMap.put(element.getId().toString(), element);
            }
            String kSQL = null;
            for (ManufactureRecBillEntryInfo entryInfo : recBillInfo.getEntry()) {
                Boolean isStorageLimit;
                String checkSql;
                BOSObjectType sourceBillEntryBOSType;
                if (entryInfo.getSourceBillId() != null && !entryInfo.getSourceBillId().equals(finishedRptId)) continue;
                String materialId = entryInfo.getMaterial().getId().toString();
                BigDecimal qty = entryInfo.getQty();
                BigDecimal baseQty = entryInfo.getBaseQty();
                int status = 0;
                if (!writeBack) {
                    qty = entryInfo.getQty().negate();
                    baseQty = entryInfo.getBaseQty().negate();
                }
                BigDecimal passQty = new BigDecimal("0");
                BigDecimal basePassQty = new BigDecimal("0");
                BigDecimal unPassQty = new BigDecimal("0");
                BigDecimal baseUnPassQty = new BigDecimal("0");
                FinishedRptCRInfo checkInfo = null;
                FinishedRptEntryInfo element = null;
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add("*");
                TransactionTypeInfo ty = (TransactionTypeInfo)TransactionTypeFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(recBillInfo.getTransactionType().getId().toString()), sic);
                boolean isPass = true;
                try {
                    sourceBillEntryBOSType = BOSUuid.read((String)entryInfo.getSourceBillEntryId()).getType();
                }
                catch (UuidException e) {
                    logger.error((Object)e.getMessage());
                    continue;
                }
                catch (IllegalArgumentException e) {
                    logger.error((Object)e.getMessage());
                    continue;
                }
                if (BOSObjectType.create((String)"21191C95").equals((Object)sourceBillEntryBOSType)) {
                    if (ty.getNumber().equals("503")) {
                        sic = this.getEntrySelector();
                        element = (FinishedRptEntryInfo)FinishedRptEntryFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(entryInfo.getSourceBillEntryId().toString()), sic);
                        passQty = SCMUtils.getExchangeQtyForServer((Context)ctx, (String)element.getMaterial().getId().toString(), (MeasureUnitInfo)element.getMaterial().getBaseUnit(), (MeasureUnitInfo)element.getUnit(), (BigDecimal)baseQty);
                        basePassQty = baseQty;
                        isPass = true;
                    } else if (ty.getNumber().equals("504")) {
                        sic = this.getEntrySelector();
                        element = (FinishedRptEntryInfo)FinishedRptEntryFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(entryInfo.getSourceBillEntryId().toString()), sic);
                        unPassQty = SCMUtils.getExchangeQtyForServer((Context)ctx, (String)element.getMaterial().getId().toString(), (MeasureUnitInfo)element.getMaterial().getBaseUnit(), (MeasureUnitInfo)element.getUnit(), (BigDecimal)baseQty);
                        baseUnPassQty = baseQty;
                        isPass = false;
                    } else if (passTransactionTypes.indexOf(ty.getNumber()) >= 0) {
                        sic = this.getEntrySelector();
                        element = (FinishedRptEntryInfo)FinishedRptEntryFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(entryInfo.getSourceBillEntryId().toString()), sic);
                        passQty = SCMUtils.getExchangeQtyForServer((Context)ctx, (String)element.getMaterial().getId().toString(), (MeasureUnitInfo)element.getMaterial().getBaseUnit(), (MeasureUnitInfo)element.getUnit(), (BigDecimal)baseQty);
                        basePassQty = baseQty;
                        isPass = true;
                    } else {
                        sic = this.getEntrySelector();
                        element = (FinishedRptEntryInfo)FinishedRptEntryFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(entryInfo.getSourceBillEntryId().toString()), sic);
                        unPassQty = SCMUtils.getExchangeQtyForServer((Context)ctx, (String)element.getMaterial().getId().toString(), (MeasureUnitInfo)element.getMaterial().getBaseUnit(), (MeasureUnitInfo)element.getUnit(), (BigDecimal)baseQty);
                        baseUnPassQty = baseQty;
                        isPass = false;
                    }
                } else if (ty.getNumber().equals("505") || ty.getNumber().equals("506")) {
                    checkSql = "update t_mm_finishedRptCr set FTotalReportQty = FTotalReportQty+?,FBaseTotalReportQty=FBaseTotalReportQty+? where fid = ?";
                    DbUtil.execute((Context)ctx, (String)checkSql, (Object[])new Object[]{qty, baseQty, entryInfo.getSourceBillEntryId()});
                    sic = this.getCheckEntrySelector();
                    checkInfo = (FinishedRptCRInfo)FinishedRptCRFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(entryInfo.getSourceBillEntryId().toString()), sic);
                    element = checkInfo.getParent();
                    if (checkInfo.getMaterial().getId().toString().equals(element.getMaterial().getId().toString())) {
                        if (ty.getNumber().equals("505")) {
                            passQty = SCMUtils.getExchangeQtyForServer((Context)ctx, (String)checkInfo.getMaterial().getId().toString(), (MeasureUnitInfo)element.getMaterial().getBaseUnit(), (MeasureUnitInfo)element.getUnit(), (BigDecimal)baseQty);
                            basePassQty = baseQty;
                        } else {
                            unPassQty = SCMUtils.getExchangeQtyForServer((Context)ctx, (String)checkInfo.getMaterial().getId().toString(), (MeasureUnitInfo)element.getMaterial().getBaseUnit(), (MeasureUnitInfo)element.getUnit(), (BigDecimal)baseQty);
                            baseUnPassQty = baseQty;
                        }
                    }
                    isPass = ty.getNumber().equals("505");
                } else if (passTransactionTypes.indexOf(ty.getNumber()) >= 0) {
                    checkSql = "update t_mm_finishedRptCr set FTotalReportQty = FTotalReportQty+?,FBaseTotalReportQty=FBaseTotalReportQty+? where fid = ?";
                    DbUtil.execute((Context)ctx, (String)checkSql, (Object[])new Object[]{qty, baseQty, entryInfo.getSourceBillEntryId()});
                    sic = this.getCheckEntrySelector();
                    checkInfo = (FinishedRptCRInfo)FinishedRptCRFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(entryInfo.getSourceBillEntryId().toString()), sic);
                    element = checkInfo.getParent();
                    if (checkInfo.getMaterial().getId().toString().equals(element.getMaterial().getId().toString())) {
                        passQty = SCMUtils.getExchangeQtyForServer((Context)ctx, (String)checkInfo.getMaterial().getId().toString(), (MeasureUnitInfo)element.getMaterial().getBaseUnit(), (MeasureUnitInfo)element.getUnit(), (BigDecimal)baseQty);
                        basePassQty = baseQty;
                    }
                    isPass = true;
                } else {
                    checkSql = "update t_mm_finishedRptCr set FTotalReportQty = FTotalReportQty+?,FBaseTotalReportQty=FBaseTotalReportQty+? where fid = ?";
                    DbUtil.execute((Context)ctx, (String)checkSql, (Object[])new Object[]{qty, baseQty, entryInfo.getSourceBillEntryId()});
                    sic = this.getCheckEntrySelector();
                    checkInfo = (FinishedRptCRInfo)FinishedRptCRFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(entryInfo.getSourceBillEntryId().toString()), sic);
                    element = checkInfo.getParent();
                    if (checkInfo.getMaterial().getId().toString().equals(element.getMaterial().getId().toString())) {
                        unPassQty = SCMUtils.getExchangeQtyForServer((Context)ctx, (String)checkInfo.getMaterial().getId().toString(), (MeasureUnitInfo)element.getMaterial().getBaseUnit(), (MeasureUnitInfo)element.getUnit(), (BigDecimal)baseQty);
                        baseUnPassQty = baseQty;
                    }
                    isPass = false;
                }
                if (element == null) continue;
                Map material = (Map)materialFRCVInLimit.get(materialId);
                BigDecimal frcvInLowLimit = (BigDecimal)material.get(RCVIN_LOW_LIMIT);
                BigDecimal frcvInHighLimit = (BigDecimal)material.get(RCVIN_HIGHT_LIMIT);
                Boolean bl = isStorageLimit = material.get(ISSTORAGELIMIT) != null ? (Boolean)material.get(ISSTORAGELIMIT) : new Boolean(false);
                if (isStorageLimit.booleanValue()) {
                    if (null == frcvInLowLimit) {
                        frcvInLowLimit = new BigDecimal(String.valueOf(0.0));
                    }
                    if (null == frcvInHighLimit) {
                        frcvInHighLimit = new BigDecimal(String.valueOf(0.0));
                    }
                    if (this.isOverLimit(baseQty, isPass, element, frcvInHighLimit)) {
                        throw new FinishedRptException(FinishedRptException.OVERHIGHLIMIT, new Object[]{element.getParent().getNumber()});
                    }
                }
                if (this.isEntryComplete(baseQty, element, frcvInLowLimit)) {
                    status = 8;
                }
                BigDecimal backPrdQty = new BigDecimal(String.valueOf(0.0));
                backPrdQty = SCMUtils.getExchangeQtyForServer((Context)ctx, (String)entryInfo.getMaterial().getId().toString(), (MeasureUnitInfo)entryInfo.getBaseUnit(), (MeasureUnitInfo)productionOrder.getUnit(), (BigDecimal)baseQty);
                if (passQty.compareTo(new BigDecimal("0")) == 0) {
                    kSQL = " update T_MM_FinishedRptEntry set FBejectStockTotalQty = FBejectStockTotalQty+?,FBaseRejectStockTotalQty=FBaseRejectStockTotalQty+?,FStatus = ? where FID = ? ";
                    DbUtil.execute((Context)ctx, (String)kSQL, (Object[])new Object[]{unPassQty, baseUnPassQty, new Integer(status), element.getId().toString()});
                } else {
                    kSQL = " update T_MM_FinishedRptEntry set FStockTotalQty = FStockTotalQty + ?,FBaseStockTotalQty = FBaseStockTotalQty + ?,FStatus = ? where FID = ? ";
                    DbUtil.execute((Context)ctx, (String)kSQL, (Object[])new Object[]{passQty, basePassQty, new Integer(status), element.getId().toString()});
                }
                int outputType = element.getOutputType().getValue();
                if (10710 == outputType) {
                    if (isTaskDisp) {
                        kSQL = "update T_MM_TaskDispBill set FStockTotalQty = FStockTotalQty + ?,FBaseStockTotalQty = FBaseStockTotalQty + ? where FID = ? ";
                        DbUtil.execute((Context)ctx, (String)kSQL, (Object[])new Object[]{backPrdQty, baseQty, taskDispBillId});
                    }
                    kSQL = "update T_MM_ProductionOrder set FStockTotalQty = FStockTotalQty + ?,FBaseStockTotalQty = FBaseStockTotalQty + ? where FID = ? ";
                    DbUtil.execute((Context)ctx, (String)kSQL, (Object[])new Object[]{backPrdQty, baseQty, productionOrderId});
                    continue;
                }
                if (10720 != outputType && 10730 != outputType) continue;
                kSQL = "update T_MM_ProductionOrderOEntry set FStockTotalQty = FStockTotalQty + ?,FBaseStockTotalQty = FBaseStockTotalQty + ? where FParentID = ? and FOutputType = ? and FMaterialID = ?";
                DbUtil.execute((Context)ctx, (String)kSQL, (Object[])new Object[]{qty, baseQty, productionOrderId, new Integer(outputType), materialId});
            }
            kSQL = "update T_MM_FinishedRpt set FBaseStatus = ? where FID = ? ";
            int status = this.getBillStatus(ctx, finishedRptId);
            DbUtil.execute((Context)ctx, (String)kSQL, (Object[])new Object[]{new Integer(status), finishedRptId});
        }
    }

    protected int getBillStatus(Context ctx, String billId) throws EASBizException, BOSException {
        int status = 4;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("baseStatus");
        sic.add("entrys.status");
        FinishedRptInfo info = (FinishedRptInfo)FinishedRptFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(billId));
        if (info.getBaseStatus().getValue() == 7) {
            status = 7;
        } else {
            boolean isFinished = true;
            FinishedRptEntryCollection entryCollection = info.getEntrys();
            for (int i = 0; i < entryCollection.size(); ++i) {
                if (entryCollection.get(i).getStatus().getValue() == 8) continue;
                isFinished = false;
                break;
            }
            if (isFinished) {
                status = 90;
            }
        }
        return status;
    }

    protected boolean isFinished(FinishedRptEntryInfo entryInfo, BigDecimal baseQty, BigDecimal lowLimit) {
        BigDecimal total = entryInfo.getBaseStockTotalQty().add(entryInfo.getBaseRejectStockTotalQty()).add(entryInfo.getBaseReworkRptTotalQty()).add(entryInfo.getBaseRepairRptTotalQty()).add(entryInfo.getBaseTotalReversePreQty());
        BigDecimal result = total.add(baseQty).subtract(entryInfo.getBaseCommtQty().multiply(new BigDecimal("1").subtract(lowLimit)));
        return result.doubleValue() >= 0.0;
    }

    @Override
    protected String _getMaterialIDsFromOrderOutPut(Context ctx, String productionOrderId, MaterialProductEnum outPutType) throws BOSException, EASBizException {
        IRowSet rows;
        StringBuffer rs = new StringBuffer();
        StringBuffer sqlBuffer = new StringBuffer();
        if (null == productionOrderId) {
            return rs.toString();
        }
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(productionOrderId);
        sqlBuffer.append("select o.FMaterialID from T_MM_ProductionOrderOEntry o where o.FParentID = ? ");
        if (outPutType != null) {
            sqlBuffer.append("and o.FOutputType = ? ");
            params.add(new Integer(outPutType.getValue()));
        }
        if (null != (rows = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString(), (Object[])params.toArray()))) {
            try {
                while (rows.next()) {
                    rs.append("," + rows.getString(1));
                }
                if (rs.length() > 0) {
                    rs.deleteCharAt(0);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return rs.toString();
    }

    private void check(Context ctx, FinishedRptInfo finishedRpt) throws EASBizException, BOSException {
        FinishedRptInfo tFinishedRpt;
        boolean isTaskDisp = this.getTaskDispType(ctx, finishedRpt);
        Boolean isRelateTaskDisp = null;
        if (finishedRpt != null && finishedRpt.getId() != null && null != (tFinishedRpt = this.getFinishedRptInfoById(ctx, finishedRpt.getId().toString()))) {
            if (tFinishedRpt.getTaskDispBill() != null) {
                isRelateTaskDisp = Boolean.TRUE;
            } else if (tFinishedRpt.getProductionOrder() != null) {
                isRelateTaskDisp = Boolean.FALSE;
            }
        }
        if (isRelateTaskDisp != null) {
            isTaskDisp = isRelateTaskDisp;
        }
        StringBuffer error = new StringBuffer();
        if (finishedRpt.getStorageOrgUnit() == null) {
            error.append(FinishedRptUtil.getResource("StorageOrgUnitIsNotNull_NOPrompt", ctx)).append("\n");
        }
        if (isTaskDisp && finishedRpt.getTaskDispBill() == null) {
            error.append(FinishedRptUtil.getResource("TaskDispBillIsNotNull_NOPrompt", ctx)).append("\n");
        }
        if (finishedRpt.getProductionOrder() == null) {
            error.append(FinishedRptUtil.getResource("ProductionOrderIsNotNull_NOPrompt", ctx)).append("\n");
        }
        if (finishedRpt.getBizDate() == null) {
            error.append(FinishedRptUtil.getResource("BizDateIsNotNull_NOPrompt", ctx)).append("\n");
        }
        StringBuffer entryError = this.checkEntry(ctx, finishedRpt, isTaskDisp);
        error.append(entryError);
        if (error.length() > 0) {
            throw new FinishedRptException(FinishedRptException.BLANK, new String[]{error.toString()});
        }
    }

    private void checkQty(Context ctx, FinishedRptInfo finishedRpt) throws EASBizException, BOSException {
        FinishedRptEntryCollection entryColls = finishedRpt.getEntrys();
        boolean flag = FinishedRptUtil.hasCheckModular(ctx, finishedRpt.getStorageOrgUnit().getId().toString());
        StringBuffer sqlStr = new StringBuffer();
        for (int i = 0; i < entryColls.size(); ++i) {
            FinishedRptEntryInfo entryInfo = entryColls.get(i);
            if (flag && entryInfo.isIsCheck()) continue;
            BigDecimal total = new BigDecimal("0");
            if (entryInfo.getTotalPassQty() != null) {
                total = total.add(entryInfo.getTotalPassQty());
            }
            if (entryInfo.getTotalRejectQty() != null) {
                total = total.add(entryInfo.getTotalRejectQty());
            }
            if (entryInfo.getTotalReworkQty() != null) {
                total = total.add(entryInfo.getTotalReworkQty());
            }
            if (entryInfo.getTotalRepairQty() != null) {
                total = total.add(entryInfo.getTotalRepairQty());
            }
            if (total.subtract(entryInfo.getCommitQty()).doubleValue() == 0.0) continue;
            sqlStr.append(FinishedRptUtil.getResource("row", ctx) + (i + 1));
            sqlStr.append(FinishedRptUtil.getResource("totalQtyNotEqual", ctx) + "\n");
        }
        if (sqlStr.length() > 0) {
            ActionCommonException bizExp = new ActionCommonException(null);
            bizExp.setMessage(sqlStr.toString());
            throw bizExp;
        }
    }

    private StringBuffer checkEntry(Context ctx, FinishedRptInfo finishedRpt, boolean isTaskDisp) throws FinishedRptException, BOSException {
        StringBuffer error = new StringBuffer();
        FinishedRptEntryCollection entrys = finishedRpt.getEntrys();
        if (entrys != null && entrys.size() > 0) {
            Date taskDispTime = null;
            boolean flag = true;
            if (!isTaskDisp || finishedRpt.getTaskDispBill() == null) {
                flag = false;
            } else {
                TaskDispBillInfo taskDispBillInfo = finishedRpt.getTaskDispBill();
                taskDispTime = taskDispBillInfo.getStartDate();
                if (null == taskDispTime) {
                    ObjectUuidPK pk = new ObjectUuidPK(finishedRpt.getTaskDispBill().getId());
                    try {
                        taskDispBillInfo = (TaskDispBillInfo)TaskDispBillFactory.getLocalInstance(ctx).getValue((IObjectPK)pk);
                        taskDispTime = taskDispBillInfo.getStartDate();
                    }
                    catch (EASBizException e) {
                        throw new BOSException((Throwable)e);
                    }
                    catch (BOSException e) {
                        throw new BOSException((Throwable)e);
                    }
                }
            }
            Iterator it = entrys.iterator();
            int rowIndex = 0;
            while (it.hasNext()) {
                boolean[] check = new boolean[]{true, true, true, true, true, true, flag, true};
                ++rowIndex;
                StringBuffer emptyError = new StringBuffer();
                FinishedRptEntryInfo entry = (FinishedRptEntryInfo)it.next();
                if (check[0] && (null == entry.getOutputType() || entry.getOutputType().getValue() == 0)) {
                    emptyError.append(FinishedRptUtil.getResource("OutPutType", ctx)).append(",");
                    check[0] = false;
                }
                if (check[1] && null == entry.getMaterial()) {
                    emptyError.append(FinishedRptUtil.getResource("MaterialNum", ctx)).append(",");
                    check[1] = false;
                }
                if (check[2] && null == entry.getCommitQty()) {
                    emptyError.append(FinishedRptUtil.getResource("CommitQty", ctx)).append(",");
                    check[2] = false;
                } else if (check[3] && entry.getCommitQty().doubleValue() <= 0.0) {
                    error.append(FinishedRptUtil.getHolderResource("RowIndex", new String[]{String.valueOf(rowIndex)}));
                    error.append(FinishedRptUtil.getResource("CommitQtyCanNotLessZero", ctx)).append("\n");
                    check[3] = false;
                }
                if (check[4] && null == entry.getWarehouse()) {
                    emptyError.append(FinishedRptUtil.getResource("Warehouse", ctx)).append(",");
                    check[4] = false;
                }
                if (check[5] && null == entry.getFinishDate()) {
                    emptyError.append(FinishedRptUtil.getResource("FinishDate", ctx)).append(",");
                    check[5] = false;
                }
                if (check[6] && null != entry.getFinishDate() && null != taskDispTime && taskDispTime.getTime() > entry.getFinishDate().getTime()) {
                    DateFormat dtformat = BOSLocaleUtil.getDateTimeFormat();
                    error.append(FinishedRptUtil.getHolderResource("RowIndex", new String[]{String.valueOf(rowIndex)}));
                    error.append(FinishedRptUtil.getResource("FinishDateCanNotEarlyTaskDispDate", ctx)).append("[").append(dtformat.format(taskDispTime)).append("]\n");
                    check[6] = false;
                }
                if (emptyError == null || emptyError.length() <= 0) continue;
                error.append(FinishedRptUtil.getResource("RowIndex", new String[]{String.valueOf(rowIndex)}, ctx));
                error.append(emptyError.toString().substring(0, emptyError.toString().lastIndexOf(",")));
                error.append(FinishedRptUtil.getResource("NotFillIn", ctx)).append("\n");
            }
        } else {
            error.append(FinishedRptUtil.getResource("entryIsNotNull", ctx)).append("\n");
        }
        return error;
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FinishedRptInfo finishedRpt = (FinishedRptInfo)model;
        this.checkUpperExist(ctx, finishedRpt);
        this.setNullToDefault(ctx, model);
        IObjectPK pk = super._save(ctx, model);
        return pk;
    }

    private void checkUpperExist(Context ctx, FinishedRptInfo finishedRpt) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("baseStatus"));
        StringBuffer error = new StringBuffer();
        if (finishedRpt.getTaskDispBill() != null) {
            if (TaskDispBillFactory.getLocalInstance(ctx).exists((IObjectPK)new ObjectUuidPK(finishedRpt.getTaskDispBill().getId().toString()))) {
                TaskDispBillInfo taskInfo = (TaskDispBillInfo)TaskDispBillFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(finishedRpt.getTaskDispBill().getId().toString()));
                if (taskInfo == null || taskInfo.getBaseStatus().getValue() < 4) {
                    error.append(FinishedRptUtil.getResource("Msg_upperBillCheck2", ctx));
                    throw new FinishedRptException(FinishedRptException.BLANK, new String[]{error.toString()});
                }
            } else {
                error.append(FinishedRptUtil.getResource("Msg_upperBillCheck2", ctx));
                throw new FinishedRptException(FinishedRptException.BLANK, new String[]{error.toString()});
            }
        }
        if (finishedRpt.getProductionOrder() != null) {
            if (ProductionOrderFactory.getLocalInstance(ctx).exists((IObjectPK)new ObjectUuidPK(finishedRpt.getProductionOrder().getId().toString()))) {
                ProductionOrderInfo orderInfo = (ProductionOrderInfo)ProductionOrderFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(finishedRpt.getProductionOrder().getId().toString()));
                if (orderInfo == null || orderInfo.getBaseStatus().getValue() < 5) {
                    error.append(FinishedRptUtil.getResource("Msg_upperBillCheck", ctx));
                    throw new FinishedRptException(FinishedRptException.BLANK, new String[]{error.toString()});
                }
            } else {
                error.append(FinishedRptUtil.getResource("Msg_upperBillCheck", ctx));
                throw new FinishedRptException(FinishedRptException.BLANK, new String[]{error.toString()});
            }
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        SCMBillBaseInfo sourceBill;
        FinishedRptInfo finishedRpt = (FinishedRptInfo)model;
        FinishedRptException bizExp = null;
        IObjectPK pk = null;
        this.checkBillStatus(ctx, finishedRpt);
        try {
            this.check(ctx, finishedRpt);
            this.checkQty(ctx, finishedRpt);
            this.checkUpperExist(ctx, finishedRpt);
        }
        catch (FinishedRptException e) {
            bizExp = e;
        }
        FinishedRptEntryCollection entrys = finishedRpt.getEntrys();
        for (int i = 0; i < entrys.size(); ++i) {
            FinishedRptEntryInfo entry = entrys.get(i);
            if (entry == null || entry.getCommitQty() == null) continue;
            entry.setAssociateQty(entry.getCommitQty());
        }
        this.setNullToDefault(ctx, model);
        try {
            pk = super._submit(ctx, model);
        }
        catch (EASBizException scmBizExp) {
            if (bizExp != null) {
                throw new FinishedRptException(FinishedRptException.BLANK, new String[]{scmBizExp.getMessage() + "\n" + bizExp.getMessage()});
            }
            throw scmBizExp;
        }
        if (null != bizExp) {
            throw bizExp;
        }
        boolean isAutoAudit = false;
        String orgUnitID = finishedRpt.getStorageOrgUnit().getId().toString();
        if (finishedRpt.getBillType() != null) {
            String billTypeID = finishedRpt.getBillType().getId().toString();
            ISCMBillParam scmParam = SCMBillParamFactory.getLocalInstance((Context)ctx);
            String strAutoAudit = scmParam.getParamByBillTypeID("SCM_Submit_01", 4, orgUnitID, billTypeID);
            if (strAutoAudit != null && strAutoAudit.trim().length() != 0 && strAutoAudit.trim().toLowerCase().equals("1")) {
                isAutoAudit = true;
            }
        }
        if (isAutoAudit) {
            boolean isOver;
            IParamControl ipc = ParamControlFactory.getLocalInstance((Context)ctx);
            String strValue = ipc.getParamValue((IObjectPK)new ObjectStringPK(finishedRpt.getStorageOrgUnit().getId().toString()), "OverRunMeasure");
            if (strValue == null) {
                throw new FinishedRptException(FinishedRptException.OVERRUNMEASURERES);
            }
            if (strValue.equals("2") && (isOver = this.checkOverLimitForUpperBill(ctx, finishedRpt))) {
                throw new FinishedRptException(FinishedRptException.OVER_RPT_HIGHT_LIMIT, new String[]{finishedRpt.getNumber()});
            }
            this._audit(ctx, pk);
        }
        if (null == (sourceBill = finishedRpt.getTaskDispBill())) {
            sourceBill = finishedRpt.getProductionOrder();
        }
        return pk;
    }

    private void checkBillStatus(Context ctx, FinishedRptInfo finishedRpt) throws BOSException, EASBizException {
        if (finishedRpt.getId() != null && this._exists(ctx, (IObjectPK)new ObjectUuidPK(finishedRpt.getId().toString()))) {
            FinishedRptInfo info = (FinishedRptInfo)this.getValue(ctx, (IObjectPK)new ObjectUuidPK(finishedRpt.getId().toString()));
            if (info.getBaseStatus().getValue() == 7) {
                throw new FinishedRptException(FinishedRptException.CLOSENOTSUBMIT);
            }
            if (info.getBaseStatus().getValue() == 90) {
                throw new FinishedRptException(FinishedRptException.FINISHEDNOTSUBMIT);
            }
        }
    }

    private void checkPickingSlipBeforeAudit(Context ctx, String orgId, String id) throws EASBizException, BOSException {
        String errorStr;
        String value = ParamManager.getParamValue((Context)ctx, (IObjectPK)new ObjectUuidPK(orgId), (String)"IsFinishedMustPickslip");
        if (value != null && !value.trim().equals("") && value.trim().equals("false")) {
            return;
        }
        boolean flag = this._isPickingSlipWhenFinished(ctx, id);
        if (!flag && (errorStr = ResourceManage.getResource((String)"com.kingdee.eas.mm.control.FinishedRptResource", (String)"ParamPickWhenFinished", (Locale)ctx.getLocale())).length() > 0) {
            ActionCommonException bizExp = new ActionCommonException(null);
            bizExp.setMessage(errorStr);
            throw bizExp;
        }
    }

    private BigDecimal[] calculateMainCommitQty(Context ctx, FinishedRptInfo finishedRpt) throws BOSException, EASBizException {
        if (null == finishedRpt) {
            throw new BOSException(FinishedRptUtil.getResource("finishedRptInfoNull", ctx));
        }
        BigDecimal commitQty = new BigDecimal(String.valueOf(0.0));
        BigDecimal baseCommitQty = new BigDecimal(String.valueOf(0.0));
        FinishedRptEntryCollection entrys = finishedRpt.getEntrys();
        FinishedRptEntryInfo tempEntry = new FinishedRptEntryInfo();
        if (null != entrys && entrys.size() > 0) {
            for (int i = 0; i < entrys.size(); ++i) {
                FinishedRptEntryInfo item = entrys.get(i);
                BigDecimal tempCommitQty = new BigDecimal(String.valueOf("0.00"));
                if (item == null || item.getOutputType() == null || item.getOutputType().getValue() != 10710) continue;
                if (null == tempEntry || null == tempEntry.getId()) {
                    tempEntry = item;
                    tempCommitQty = item.getCommitQty();
                } else if (item != tempEntry) {
                    tempCommitQty = SCMUtils.getExchangeQtyForServer((Context)ctx, (String)item.getMaterial().getId().toString(), (MeasureUnitInfo)item.getUnit(), (MeasureUnitInfo)tempEntry.getUnit(), (BigDecimal)item.getCommitQty());
                }
                if (null != tempCommitQty) {
                    commitQty = commitQty.add(tempCommitQty);
                }
                if (null == item.getBaseCommtQty()) continue;
                baseCommitQty = baseCommitQty.add(item.getBaseCommtQty());
            }
        }
        return new BigDecimal[]{commitQty, baseCommitQty};
    }

    public BigDecimal getExchangeQtyForServer(Context ctx, String materialID, MeasureUnitInfo unitInfo, MeasureUnitInfo otherUnitInfo, BigDecimal qty, MultiMeasureUnitCollection multiUnitColls) throws BOSException, EASBizException {
        if (materialID == null) {
            throw new IllegalArgumentException();
        }
        BigDecimal targetQty = null;
        MultiMeasureUnitInfo multiUnifInfo = null;
        MultiMeasureUnitInfo othermultiUnifInfo = null;
        MultiMeasureUnitInfo tempInfo = null;
        for (int i = 0; i < multiUnitColls.size(); ++i) {
            tempInfo = multiUnitColls.get(i);
            if (tempInfo.getMaterial().getId().toString().equals(materialID) && tempInfo.getMeasureUnit().getId().toString().equals(unitInfo.getId().toString())) {
                multiUnifInfo = tempInfo;
            }
            if (!tempInfo.getMaterial().getId().toString().equals(materialID) || !tempInfo.getMeasureUnit().getId().toString().equals(otherUnitInfo.getId().toString())) continue;
            othermultiUnifInfo = tempInfo;
        }
        if (multiUnifInfo != null && othermultiUnifInfo != null) {
            BigDecimal baseExchangeRate1 = multiUnifInfo.getBaseConvsRate();
            BigDecimal baseExchangeRate2 = othermultiUnifInfo.getBaseConvsRate();
            if (baseExchangeRate1 == null) {
                baseExchangeRate1 = new BigDecimal("1.00");
            }
            if (baseExchangeRate2 == null) {
                baseExchangeRate2 = new BigDecimal("1.00");
            }
            BigDecimal baseQty = qty.multiply(baseExchangeRate1);
            targetQty = baseQty.divide(baseExchangeRate2, othermultiUnifInfo.getQtyPrecision(), 4);
        }
        return targetQty;
    }

    public MultiMeasureUnitCollection getMultiMeasureUnit(Context ctx, HashSet materialIds) throws BOSException, EASBizException {
        IMultiMeasureUnit multiUnit = MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialIds, CompareType.INCLUDE));
        EntityViewInfo env = new EntityViewInfo();
        env.setFilter(filter);
        MultiMeasureUnitCollection colls = multiUnit.getMultiMeasureUnitCollection(env);
        return colls;
    }

    private boolean isOverRPTInHightLimit(Context ctx, FinishedRptInfo finishedRpt, BigDecimal baseQty) throws BOSException, EASBizException {
        boolean isOver = false;
        if (finishedRpt.getProductionOrder() == null || finishedRpt.getMasterProductId() == null || null == baseQty) {
            throw new BOSException(FinishedRptUtil.getResource("overLimitParamNull", ctx));
        }
        Map map = this.getRPTInLowAndHightLimit(ctx, finishedRpt.getMasterProductId(), finishedRpt.getStorageOrgUnit().getId().toString());
        BigDecimal[] rptInLimit = (BigDecimal[])map.get("bigdecimalRs");
        Boolean isReportingLimit = (Boolean)map.get(ISREPORTLIMIT);
        if (isReportingLimit.booleanValue()) {
            BigDecimal rptInHightLimit;
            BigDecimal bigDecimal = rptInHightLimit = rptInLimit[1] == null ? new BigDecimal(String.valueOf(0.0)) : rptInLimit[1];
            if (finishedRpt.getTaskDispBill() != null && finishedRpt.getTaskDispBill().getId() != null) {
                BigDecimal vaidReqQty;
                BigDecimal[] tskCommitQtyAndPdtQty = this.getTskDspPrdQtyAndCommitQty(ctx, finishedRpt.getTaskDispBill().getId().toString());
                BigDecimal pdtQty = tskCommitQtyAndPdtQty[1];
                BigDecimal tskCommitTotalAndReqQty = tskCommitQtyAndPdtQty[3];
                BigDecimal preCommitTotalQty = baseQty.add(tskCommitTotalAndReqQty);
                if (preCommitTotalQty.subtract(vaidReqQty = pdtQty.multiply(new BigDecimal(1).add(rptInHightLimit))).doubleValue() > 0.0) {
                    isOver = true;
                }
            } else {
                BigDecimal vaidReqQty;
                BigDecimal[] commitTotalAndReqQty = this.getCommitTotalAndReqQty(ctx, finishedRpt.getProductionOrder().getId().toString());
                BigDecimal commitTotalQty = commitTotalAndReqQty[1] == null ? new BigDecimal(String.valueOf(0.0)) : commitTotalAndReqQty[1];
                BigDecimal reqQty = commitTotalAndReqQty[3] == null ? new BigDecimal(String.valueOf(0.0)) : commitTotalAndReqQty[3];
                BigDecimal preCommitTotalQty = baseQty.add(commitTotalQty);
                if (preCommitTotalQty.subtract(vaidReqQty = reqQty.multiply(new BigDecimal(1).add(rptInHightLimit))).doubleValue() > 0.0) {
                    isOver = true;
                }
            }
        }
        return isOver;
    }

    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("entrys.material.id"));
        sic.add(new SelectorItemInfo("entrys.lotNo"));
        sic.add(new SelectorItemInfo("entrys.outputType"));
        sic.add(new SelectorItemInfo("productionOrder.id"));
        sic.add(new SelectorItemInfo("productionOrder.stockEntry.isBackFlush"));
        FinishedRptInfo finishedRpt = this.getFinishedRptInfo(ctx, pk, sic);
        if (finishedRpt.getBaseStatus().getValue() != 2) {
            throw new FinishedRptException(FinishedRptException.AUDIT_MUST_SUBMIT);
        }
        this.checkPickingSlipBeforeAudit(ctx, finishedRpt.getStorageOrgUnit().getId().toString(), pk.toString());
        if (finishedRpt.getProductionOrder() != null && finishedRpt.getProductionOrder().getId() != null) {
            ArrayList<String> orderIds = new ArrayList<String>();
            orderIds.add(finishedRpt.getProductionOrder().getId().toString());
            ProductionOrderFacadeFactory.getLocalInstance(ctx).isClosed(orderIds);
        }
        this.checkLotNo(ctx, finishedRpt, false);
        super._audit(ctx, pk);
        if (this.hasMasterProduct(finishedRpt.getEntrys()) && this.hasBackFlushMaterial(finishedRpt.getProductionOrder().getStockEntry())) {
            finishedRpt.setBackFlushFlag(BackFlushStatusEnum.NOT_BACKFRUSH);
        } else {
            finishedRpt.setBackFlushFlag(BackFlushStatusEnum.NO_BACKFRUSH);
        }
        finishedRpt.setAuditor(UserFactory.getLocalInstance((Context)ctx).getUserInfo(ctx.getCaller()));
        finishedRpt.setAuditTime(new Timestamp(System.currentTimeMillis()));
        finishedRpt.setBaseStatus(BillBaseStatusEnum.AUDITED);
        finishedRpt.setOnceAudit(true);
        this._update(ctx, pk, (IObjectValue)finishedRpt);
        String productionOrderId = finishedRpt.getProductionOrder().getId().toString();
        ArrayList<String> prdIdList = new ArrayList<String>();
        prdIdList.add(productionOrderId);
        PoMaterialWithDraw.updatePoABDate(ctx, prdIdList);
        this._writeBack(ctx, pk.toString(), true);
        String[] ids = new String[]{pk.toString()};
        LotFacadeFactory.getLocalInstance((Context)ctx).finishedRptInsertLotSource(ids);
    }

    private boolean hasMasterProduct(FinishedRptEntryCollection coll) {
        boolean result = false;
        FinishedRptEntryInfo entryInfo = null;
        int n = coll.size();
        for (int i = 0; i < n; ++i) {
            entryInfo = coll.get(i);
            if (!entryInfo.getOutputType().equals((Object)MaterialProductEnum.MASTERPRODUCT)) continue;
            result = true;
            break;
        }
        return result;
    }

    private boolean hasBackFlushMaterial(ProductionOrderStockEntryCollection coll) {
        boolean result = false;
        ProductionOrderStockEntryInfo entryInfo = null;
        int n = coll.size();
        for (int i = 0; i < n; ++i) {
            entryInfo = coll.get(i);
            if (!entryInfo.isIsBackFlush()) continue;
            result = true;
            break;
        }
        return result;
    }

    @Override
    protected void _auditForList(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this._audit(ctx, pk);
    }

    private void checkLotNo(Context ctx, FinishedRptInfo finishedRpt, boolean isList) throws EASBizException, BOSException, FinishedRptException {
        FinishedRptEntryCollection entrys = finishedRpt.getEntrys();
        int rowIndex = 0;
        if (entrys != null && entrys.size() > 0) {
            StringBuffer error = new StringBuffer();
            Iterator it = entrys.iterator();
            while (it.hasNext()) {
                int type;
                ++rowIndex;
                FinishedRptEntryInfo entry = (FinishedRptEntryInfo)it.next();
                boolean isRelateTaskDisp = false;
                if (finishedRpt.getTaskDispBill() != null && finishedRpt.getTaskDispBill().getId() != null) {
                    isRelateTaskDisp = true;
                }
                if ((type = FinishedRPTServerUtils.dealLotNoSituation(finishedRpt.getStorageOrgUnit(), entry.getMaterial(), isRelateTaskDisp, ctx)) != 1 || null != entry.getLotNo() && !"".equals(entry.getLotNo().trim())) continue;
                if (isList) {
                    error.append(FinishedRptUtil.getResource("SelectedBill")).append(": ");
                    error.append(finishedRpt.getNumber());
                    error.append(FinishedRptUtil.getResource("LotIsEmptyCheck", ctx));
                    continue;
                }
                error.append(FinishedRptUtil.getHolderResource("RowIndex", new String[]{String.valueOf(rowIndex)}) + FinishedRptUtil.getResource("LotIsEmptyCheck", ctx) + "\n");
            }
            if (error.length() > 0) {
                throw new FinishedRptException(FinishedRptException.BLANK, new String[]{error.toString()});
            }
        }
    }

    protected boolean checkOverLimitForUpperBill(Context ctx, FinishedRptInfo finishedRpt) throws BOSException, EASBizException {
        BigDecimal baseCommitQty;
        boolean isOver = false;
        if (null != finishedRpt.getMasterProductId() && !finishedRpt.getMasterProductId().equals("") && this.isOverRPTInHightLimit(ctx, finishedRpt, baseCommitQty = this.calculateMainCommitQty(ctx, finishedRpt)[1])) {
            isOver = true;
        }
        return isOver;
    }

    private void unAuditCheck(Context ctx, FinishedRptInfo finishedRpt) throws BOSException, EASBizException {
        if (finishedRpt.getProductionOrder() != null && finishedRpt.getProductionOrder().getId() != null) {
            ArrayList<String> orderIds = new ArrayList<String>();
            orderIds.add(finishedRpt.getProductionOrder().getId().toString());
            ProductionOrderFacadeFactory.getLocalInstance(ctx).isClosed(orderIds);
        }
        String billTypeId = finishedRpt.getBillType().getId().toString();
        String orgUnitID = finishedRpt.getStorageOrgUnit().getId().toString();
        ISCMBillParam scmParam = SCMBillParamFactory.getLocalInstance((Context)ctx);
        String strCanUnAudit = scmParam.getParamByBillTypeID("SCM_UnAudit_01", 4, orgUnitID, billTypeId);
        if (strCanUnAudit == null || strCanUnAudit.trim().length() == 0 || !strCanUnAudit.trim().toLowerCase().equals("1")) {
            throw new FinishedRptException(FinishedRptException.ISUNAUDITINPARAM);
        }
        if (finishedRpt.getBaseStatus().getValue() != 4) {
            throw new FinishedRptException(FinishedRptException.FINISHEDRPT_CANNOT_UNAUDIT);
        }
        if (this.isBackFlushed(ctx, finishedRpt.getId().toString())) {
            throw new FinishedRptException(FinishedRptException.BACKFLUSHED_CANNOT_UNAUDIT);
        }
        if (this.isAssociateManufactureRecBill(ctx, finishedRpt.getId().toString())) {
            throw new FinishedRptException(FinishedRptException.HASMANUFACTURERECBILL_CANNOT_UNAUDIT);
        }
        String idStr = "'" + finishedRpt.getId().toString() + "'";
        StringBuffer selectSql = new StringBuffer();
        selectSql.append("select distinct FSrcObjectID from t_bot_Relation ").append("where FSrcObjectID in (").append(idStr).append(") ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
        try {
            Object msg = null;
            if (rs != null && rs.next()) {
                throw new FinishedRptException(FinishedRptException.HASMANUFACTURERECBILL_CANNOT_UNAUDIT);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private boolean isBackFlushed(Context ctx, String finishedRptId) throws BOSException {
        return this.hasAssociateBill(ctx, finishedRptId, "500AB75E");
    }

    private boolean hasAssociateBill(Context ctx, String srcBillId, String destBillBOSType) throws BOSException {
        String kSQL = "select count(*) assCount from T_BOT_Relation o where o.FSrcObjectID = ? and FDestEntityID = ?";
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)kSQL, (Object[])new Object[]{srcBillId, destBillBOSType});
        if (null != rows && rows.size() > 0) {
            try {
                while (rows.next()) {
                    if (rows.getInt("assCount") <= 0) continue;
                    return true;
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return false;
    }

    private boolean isAssociateManufactureRecBill(Context ctx, String finishedRptId) throws BOSException {
        return this.hasAssociateBill(ctx, finishedRptId, "FA1292B4");
    }

    protected void _unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        FinishedRptInfo finishedRpt = this.getFinishedRptInfo(ctx, pk);
        this.unAuditCheck(ctx, finishedRpt);
        super._unAudit(ctx, pk);
        this.beforeWriteBack(ctx, pk.toString(), false);
        this._writeBack(ctx, pk.toString(), false);
        finishedRpt = this.getFinishedRptInfo(ctx, pk);
        finishedRpt.setAuditor(null);
        finishedRpt.setAuditTime(null);
        finishedRpt.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        for (int i = 0; i < finishedRpt.getEntrys().size(); ++i) {
            finishedRpt.getEntrys().get(i).setUrgentRelease(false);
        }
        finishedRpt.setBackFlushFlag(BackFlushStatusEnum.NOT_BACKFRUSH);
        this._update(ctx, pk, (IObjectValue)finishedRpt);
        String productionOrderId = finishedRpt.getProductionOrder().getId().toString();
        ArrayList<String> prdIdList = new ArrayList<String>();
        prdIdList.add(productionOrderId);
        PoMaterialWithDraw.updatePoABDate(ctx, prdIdList);
        String[] ids = new String[]{pk.toString()};
        LotFacadeFactory.getLocalInstance((Context)ctx).finishedRptDeleteLotSource(ids);
    }

    protected void _unAudit(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        if (null != pks && pks.length > 0) {
            for (int i = 0; i < pks.length; ++i) {
                this._unAudit(ctx, pks[i]);
            }
        }
    }

    public FinishedRptEntryCollection sumEntrys(Context ctx, FinishedRptInfo finishedRpt) throws EASBizException, BOSException {
        FinishedRptEntryCollection finishedRptEntrys = new FinishedRptEntryCollection();
        if (null != finishedRpt && null != finishedRpt.getEntrys()) {
            boolean isMerge = false;
            for (int i = 0; i < finishedRpt.getEntrys().size(); ++i) {
                FinishedRptEntryInfo newEntry = finishedRpt.getEntrys().get(i);
                for (int j = 0; j < finishedRptEntrys.size(); ++j) {
                    FinishedRptEntryInfo entry = finishedRptEntrys.get(j);
                    if (null == entry.getOutputType() || entry.getOutputType().getValue() != newEntry.getOutputType().getValue() || !entry.getMaterial().getId().toString().equals(newEntry.getMaterial().getId().toString()) || null == newEntry.getCommitQty() || !(newEntry.getCommitQty().doubleValue() >= 0.0)) continue;
                    BigDecimal addCommitQty = SCMUtils.getExchangeQtyForServer((Context)ctx, (String)entry.getMaterial().getId().toString(), (MeasureUnitInfo)newEntry.getUnit(), (MeasureUnitInfo)entry.getUnit(), (BigDecimal)newEntry.getCommitQty());
                    BigDecimal addPassQty = SCMUtils.getExchangeQtyForServer((Context)ctx, (String)entry.getMaterial().getId().toString(), (MeasureUnitInfo)newEntry.getUnit(), (MeasureUnitInfo)entry.getUnit(), (BigDecimal)newEntry.getTotalPassQty());
                    BigDecimal addRejectQty = SCMUtils.getExchangeQtyForServer((Context)ctx, (String)entry.getMaterial().getId().toString(), (MeasureUnitInfo)newEntry.getUnit(), (MeasureUnitInfo)entry.getUnit(), (BigDecimal)newEntry.getTotalRejectQty());
                    if (null == addCommitQty) {
                        addCommitQty = new BigDecimal(String.valueOf("0.00"));
                    }
                    if (null == addPassQty) {
                        addPassQty = new BigDecimal(String.valueOf("0.00"));
                    }
                    if (null == addRejectQty) {
                        addRejectQty = new BigDecimal(String.valueOf("0.00"));
                    }
                    entry.setCommitQty(entry.getCommitQty().add(addCommitQty));
                    entry.setBaseCommtQty(entry.getBaseCommtQty().add(newEntry.getBaseCommtQty()));
                    entry.setTotalPassQty(entry.getTotalPassQty().add(addPassQty));
                    entry.setBaseTotalPassQty(entry.getBaseTotalPassQty().add(newEntry.getBaseTotalPassQty()));
                    entry.setTotalRejectQty(entry.getTotalRejectQty().add(addRejectQty));
                    entry.setBaseTotalRejectQty(entry.getBaseTotalRejectQty().add(newEntry.getBaseTotalRejectQty()));
                    isMerge = true;
                }
                if (!isMerge) {
                    FinishedRptEntryInfo cloneEntry = (FinishedRptEntryInfo)newEntry.clone();
                    finishedRptEntrys.add(cloneEntry);
                }
                isMerge = false;
            }
        }
        return this.simpleSort(finishedRptEntrys);
    }

    private FinishedRptEntryCollection simpleSort(FinishedRptEntryCollection finishedRptEntrys) {
        if (null != finishedRptEntrys) {
            FinishedRptEntryInfo mianEntry = null;
            for (int i = 0; i < finishedRptEntrys.size(); ++i) {
                if (null == finishedRptEntrys.get(i).getOutputType() || finishedRptEntrys.get(i).getOutputType().getValue() != 10710) continue;
                mianEntry = finishedRptEntrys.get(i);
                finishedRptEntrys.removeObject(i);
                --i;
                break;
            }
            if (null != mianEntry) {
                finishedRptEntrys.add(mianEntry);
            }
        }
        return finishedRptEntrys;
    }

    private boolean isFinished(Context ctx, FinishedRptInfo finishedRpt, String materialId, BigDecimal currentCommitQty) throws BOSException {
        BigDecimal lowLimit;
        boolean finished = false;
        Map map = this.getRPTInLowAndHightLimit(ctx, materialId, finishedRpt.getStorageOrgUnit().getId().toString());
        BigDecimal[] rptInLimit = (BigDecimal[])map.get("bigdecimalRs");
        Boolean isReportingLimit = (Boolean)map.get(ISREPORTLIMIT);
        BigDecimal bigDecimal = lowLimit = rptInLimit[0] == null ? new BigDecimal(String.valueOf(0.0)) : rptInLimit[0];
        if (finishedRpt.getTaskDispBill() != null) {
            BigDecimal[] tskCommitTotalAndReqQty = this.getTskDspPrdQtyAndCommitQty(ctx, finishedRpt.getTaskDispBill().getId().toString());
            BigDecimal pdtQty = tskCommitTotalAndReqQty[1] == null ? new BigDecimal(String.valueOf(0.0)) : tskCommitTotalAndReqQty[1];
            BigDecimal commitTotal = tskCommitTotalAndReqQty[3] == null ? new BigDecimal(String.valueOf(0.0)) : tskCommitTotalAndReqQty[3];
            BigDecimal vaidReqQty = pdtQty.multiply(BigDecimal.valueOf(1L).subtract(lowLimit));
            if (commitTotal.add(currentCommitQty).subtract(vaidReqQty).doubleValue() >= 0.0) {
                finished = true;
            }
        } else {
            BigDecimal[] commitTotalAndReqQty = this.getCommitTotalAndReqQty(ctx, finishedRpt.getProductionOrder().getId().toString());
            BigDecimal commitTotal = commitTotalAndReqQty[1] == null ? new BigDecimal(String.valueOf(0.0)) : commitTotalAndReqQty[1];
            BigDecimal reqQty = commitTotalAndReqQty[3] == null ? new BigDecimal(String.valueOf(0.0)) : commitTotalAndReqQty[3];
            BigDecimal vaidReqQty = reqQty.multiply(BigDecimal.valueOf(1L).subtract(lowLimit));
            if (commitTotal.add(currentCommitQty).subtract(vaidReqQty).doubleValue() >= 0.0) {
                finished = true;
            }
        }
        return finished;
    }

    private Boolean writeBackCommitQtyAndStatus(Context ctx, FinishedRptInfo finishedRpt, FinishedRptEntryInfo entry, boolean writeBack) throws BOSException, EASBizException {
        int outputType;
        if (null == finishedRpt || null == entry) {
            return null;
        }
        Boolean isComplete = null;
        String kSQL = null;
        String productionOrderId = finishedRpt.getProductionOrder().getId().toString();
        String materialId = entry.getMaterial().getId().toString();
        String productLineWPId = "";
        if (null != entry.getProductLineWP()) {
            productLineWPId = entry.getProductLineWP().getId().toString();
        }
        ProductionOrderInfo productionOrder = ProductionOrderFactory.getLocalInstance(ctx).getProductionOrderInfo((IObjectPK)new ObjectUuidPK(productionOrderId));
        if (!writeBack) {
            entry.setCommitQty(entry.getCommitQty().negate());
            entry.setBaseCommtQty(entry.getBaseCommtQty().negate());
            entry.setTotalPassQty(entry.getTotalPassQty().negate());
            entry.setBaseTotalPassQty(entry.getBaseTotalPassQty().negate());
            entry.setTotalRejectQty(entry.getTotalRejectQty().negate());
            entry.setBaseTotalRejectQty(entry.getBaseTotalRejectQty().negate());
        }
        if (10720 == (outputType = entry.getOutputType().getValue()) || 10730 == outputType) {
            BigDecimal backOCommitQty = null;
            BigDecimal backOPassQty = null;
            ProductionOrderOutputEntryCollection outputEntrys = productionOrder.getOutputEntry();
            if (null != outputEntrys && outputEntrys.size() > 0) {
                Iterator iter = outputEntrys.iterator();
                while (iter.hasNext()) {
                    ProductionOrderOutputEntryInfo info = (ProductionOrderOutputEntryInfo)iter.next();
                    if (info.getOutputType().getValue() != outputType || !info.getMaterial().getId().toString().equals(materialId) || !info.getProductLineWP().getId().toString().equals(productLineWPId)) continue;
                    backOCommitQty = SCMUtils.getExchangeQtyForServer((Context)ctx, (String)entry.getMaterial().getId().toString(), (MeasureUnitInfo)entry.getBaseUnit(), (MeasureUnitInfo)info.getUnit(), (BigDecimal)entry.getBaseCommtQty());
                    backOPassQty = SCMUtils.getExchangeQtyForServer((Context)ctx, (String)entry.getMaterial().getId().toString(), (MeasureUnitInfo)entry.getBaseUnit(), (MeasureUnitInfo)info.getUnit(), (BigDecimal)entry.getBaseTotalPassQty());
                }
            }
            if (null == backOCommitQty) {
                backOCommitQty = new BigDecimal(String.valueOf("0.00"));
            }
            if (null == backOPassQty) {
                backOPassQty = new BigDecimal(String.valueOf("0.00"));
            }
            kSQL = " update T_MM_ProductionOrderOEntry ";
            kSQL = kSQL + " set FCommitTotalQty = FCommitTotalQty + ?,FBaseCommitTotalQty = FBaseCommitTotalQty + ?,FPassTotalQty = FPassTotalQty + ?,FBasePassTotalQty = FBasePassTotalQty + ? ";
            kSQL = kSQL + " where FParentID = ? and FOutputType = ? and FMaterialID = ? and FProductLineWPID = ? ";
            DbUtil.execute((Context)ctx, (String)kSQL, (Object[])new Object[]{backOCommitQty, entry.getBaseCommtQty(), backOPassQty, entry.getTotalPassQty(), productionOrderId, new Integer(outputType), materialId, productLineWPId});
        } else if (10710 == outputType) {
            boolean finished = false;
            finished = this.isFinished(ctx, finishedRpt, materialId, entry.getBaseCommtQty());
            BigDecimal backCommitQty = new BigDecimal("0");
            BigDecimal backPassQty = new BigDecimal("0");
            BigDecimal backRejectQty = new BigDecimal("0");
            if (entry.getUnit().getId().toString().equals(productionOrder.getUnit().getId().toString())) {
                backCommitQty = entry.getCommitQty();
                backPassQty = entry.getTotalPassQty();
                backRejectQty = entry.getTotalRejectQty();
            } else {
                backCommitQty = SCMUtils.getExchangeQtyForServer((Context)ctx, (String)entry.getMaterial().getId().toString(), (MeasureUnitInfo)entry.getBaseUnit(), (MeasureUnitInfo)productionOrder.getUnit(), (BigDecimal)entry.getBaseCommtQty());
                backPassQty = SCMUtils.getExchangeQtyForServer((Context)ctx, (String)entry.getMaterial().getId().toString(), (MeasureUnitInfo)entry.getBaseUnit(), (MeasureUnitInfo)productionOrder.getUnit(), (BigDecimal)entry.getBaseTotalPassQty());
                backRejectQty = SCMUtils.getExchangeQtyForServer((Context)ctx, (String)entry.getMaterial().getId().toString(), (MeasureUnitInfo)entry.getBaseUnit(), (MeasureUnitInfo)productionOrder.getUnit(), (BigDecimal)entry.getBaseTotalRejectQty());
            }
            if (null != finishedRpt.getTaskDispBill()) {
                String taskDispBillId = finishedRpt.getTaskDispBill().getId().toString();
                kSQL = "update T_MM_TaskDispBill set FCommitTotalQty = FCommitTotalQty + ?,FBaseCommitTotalQty = FBaseCommitTotalQty + ?,FPassTotalQty = FPassTotalQty + ?,FBasePassTotalQty = FBasePassTotalQty + ? where FID = ? ";
                DbUtil.execute((Context)ctx, (String)kSQL, (Object[])new Object[]{backCommitQty, entry.getBaseCommtQty(), backPassQty, entry.getBaseTotalPassQty(), taskDispBillId});
                if (writeBack && finished) {
                    kSQL = "update T_MM_TaskDispBill set FBaseStatus = ?,FIsManualFinish = ? where FID = ? ";
                    DbUtil.execute((Context)ctx, (String)kSQL, (Object[])new Object[]{new Integer(8), new Integer(0), taskDispBillId});
                }
                if (!writeBack && !finished) {
                    kSQL = "update T_MM_TaskDispBill set FBaseStatus = ? where FID = ? and FBaseStatus = ? ";
                    DbUtil.execute((Context)ctx, (String)kSQL, (Object[])new Object[]{new Integer(4), taskDispBillId, new Integer(8)});
                }
                kSQL = "update T_MM_ProductionOrder set FCommitTotalQty = FCommitTotalQty + ?,FBaseCommitTotalQty = FBaseCommitTotalQty + ?,FPassTotalQty = FPassTotalQty + ?,FBasePassTotalQty = FBasePassTotalQty + ?,FTotalRejectQty = FTotalRejectQty+?,FBaseTotalRejectQty = FBaseTotalRejectQty+? where FID = ? ";
                DbUtil.execute((Context)ctx, (String)kSQL, (Object[])new Object[]{backCommitQty, entry.getBaseCommtQty(), backPassQty, entry.getBaseTotalPassQty(), backRejectQty, entry.getBaseTotalRejectQty(), productionOrderId});
                if (writeBack) {
                    boolean isProductComplete = false;
                    isProductComplete = ProductionOrderFacadeFactory.getLocalInstance(ctx).isAutoFinished(productionOrderId);
                    if (isProductComplete) {
                        ArrayList<String> idList = new ArrayList<String>();
                        idList.add(productionOrderId);
                        ProductionOrderFacadeFactory.getLocalInstance(ctx).dealCanAutoFinished(idList);
                        isComplete = this.isAllCompletePickingSlip(ctx, productionOrderId);
                    }
                } else {
                    ArrayList<String> idList = new ArrayList<String>();
                    idList.add(productionOrderId);
                    ProductionOrderFacadeFactory.getLocalInstance(ctx).dealAutoFinished(idList, false);
                }
            } else {
                kSQL = "update T_MM_ProductionOrder set FCommitTotalQty = FCommitTotalQty + ?,FBaseCommitTotalQty = FBaseCommitTotalQty + ?,FPassTotalQty = FPassTotalQty + ?,FBasePassTotalQty = FBasePassTotalQty + ?,FTotalRejectQty = FTotalRejectQty+?,FBaseTotalRejectQty = FBaseTotalRejectQty+? where FID = ? ";
                DbUtil.execute((Context)ctx, (String)kSQL, (Object[])new Object[]{backCommitQty, entry.getBaseCommtQty(), backPassQty, entry.getBaseTotalPassQty(), backRejectQty, entry.getBaseTotalRejectQty(), productionOrderId});
                if (writeBack) {
                    boolean isAutoFinished = ProductionOrderFacadeFactory.getLocalInstance(ctx).isAutoFinished(productionOrderId);
                    if (isAutoFinished) {
                        ArrayList<String> idList = new ArrayList<String>();
                        idList.add(productionOrderId);
                        ProductionOrderFacadeFactory.getLocalInstance(ctx).dealCanAutoFinished(idList);
                        isComplete = this.isAllCompletePickingSlip(ctx, productionOrderId);
                    }
                } else {
                    ArrayList<String> idList = new ArrayList<String>();
                    idList.add(productionOrderId);
                    ProductionOrderFacadeFactory.getLocalInstance(ctx).dealAutoFinished(idList, false);
                }
            }
        }
        return isComplete;
    }

    private Map getRPTInLowAndHightLimit(Context ctx, String materialId, String orgId) throws BOSException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        BigDecimal[] rs = new BigDecimal[]{new BigDecimal(String.valueOf(0.0)), new BigDecimal(String.valueOf(0.0))};
        Boolean isReportingLimit = new Boolean(false);
        String sql = "select FRPTInLowLimit,FRPTInHightLimit,FisReportingLimit from T_BD_MaterialPlan where fMaterialID = ? And FOrgUnit = '" + orgId + "'";
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{materialId});
        if (null != rows) {
            try {
                if (rows.next()) {
                    if (null != rows.getBigDecimal(1)) {
                        rs[0] = rows.getBigDecimal(1);
                        rs[0] = rs[0].setScale(4, 5).divide(new BigDecimal(String.valueOf(100)), 5);
                    }
                    if (null != rows.getBigDecimal(2)) {
                        rs[1] = rows.getBigDecimal(2);
                        rs[1] = rs[1].setScale(4, 5).divide(new BigDecimal(String.valueOf(100)), 5);
                    }
                    isReportingLimit = new Boolean(rows.getBoolean(3));
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        result.put("bigdecimalRs", rs);
        result.put(ISREPORTLIMIT, isReportingLimit);
        return result;
    }

    private BigDecimal[] getCommitTotalAndReqQty(Context ctx, String orderId) throws BOSException {
        BigDecimal[] rs = new BigDecimal[4];
        String sql = "select FCommitTotalQty,FBaseCommitTotalQty,FQty,FBaseQty from T_MM_ProductionOrder where fID = ? ";
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{orderId});
        if (null != rows) {
            try {
                if (rows.next()) {
                    rs[0] = rows.getBigDecimal(1);
                    rs[1] = rows.getBigDecimal(2);
                    rs[2] = rows.getBigDecimal(3);
                    rs[3] = rows.getBigDecimal(4);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return rs;
    }

    private BigDecimal[] getTskDspPrdQtyAndCommitQty(Context ctx, String taskDispId) throws BOSException {
        BigDecimal[] rs = new BigDecimal[4];
        String sql = "select FProductQty, FBaseProductQty, FCommitTotalQty, FBaseCommitTotalQty from T_MM_TaskDispBill where fID = ? ";
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{taskDispId});
        if (null != rows) {
            try {
                if (rows.next()) {
                    rs[0] = rows.getBigDecimal(1);
                    rs[1] = rows.getBigDecimal(2);
                    rs[2] = rows.getBigDecimal(3);
                    rs[3] = rows.getBigDecimal(4);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return rs;
    }

    protected boolean isAllCompletePickingSlip(Context ctx, String productionOrderId) throws BOSException {
        boolean isComplete = true;
        String sql = "select FBaseStatus from T_MM_PickingSlipBill where FProductionOrderID = ? ";
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{productionOrderId});
        if (null != rows) {
            try {
                while (rows.next()) {
                    if (rows.getInt(1) == 90) continue;
                    isComplete = false;
                    break;
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return isComplete;
    }

    private FinishedRptInfo getFinishedRptInfoById(Context ctx, String finishedRptId) throws BOSException, EASBizException {
        ObjectSingleKey pk = new ObjectSingleKey((Object)finishedRptId);
        FinishedRptInfo finishedRpt = this.getFinishedRptInfo(ctx, (IObjectPK)pk);
        return finishedRpt;
    }

    @Override
    protected Object[] _getWarehouseAndWP(Context ctx, String orderId, String materialId, MaterialProductEnum outPutType) throws BOSException, EASBizException {
        WarehouseInfo warehouse;
        ProductLineWPEntryInfo wp;
        block8: {
            IProductionOrder productionOrder;
            SelectorItemCollection sic;
            ProductionOrderInfo order;
            block7: {
                if (null == orderId || null == materialId || null == outPutType) {
                    throw new BOSException("The params of calculateCommitQty is null");
                }
                wp = null;
                warehouse = null;
                order = null;
                sic = new SelectorItemCollection();
                productionOrder = ProductionOrderFactory.getLocalInstance(ctx);
                sic.add(new SelectorItemInfo("*"));
                if (outPutType.getValue() != 10710) break block7;
                sic.add(new SelectorItemInfo("warehouse.id"));
                sic.add(new SelectorItemInfo("warehouse.name"));
                sic.add(new SelectorItemInfo("warehouse.number"));
                sic.add(new SelectorItemInfo("wpEntry.*"));
                sic.add(new SelectorItemInfo("wpEntry.productLineWP.id"));
                sic.add(new SelectorItemInfo("wpEntry.productLineWP.number"));
                sic.add(new SelectorItemInfo("wpEntry.productLineWP.name"));
                order = productionOrder.getProductionOrderInfo((IObjectPK)new ObjectSingleKey((Object)orderId), sic);
                if (null == order) break block8;
                ProductionOrderEntryCollection wps = order.getWpEntry();
                if (null != wps && wps.size() > 0) {
                    ProductionOrderEntryInfo info = wps.get(wps.size() - 1);
                    wp = info.getProductLineWP();
                }
                warehouse = order.getWarehouse();
                break block8;
            }
            ProductionOrderInfo poInfo = null;
            if (orderId != null) {
                poInfo = productionOrder.getProductionOrderInfo((IObjectPK)new ObjectSingleKey((Object)orderId));
            }
            IMaterialInventory materialInventory = MaterialInventoryFactory.getLocalInstance((Context)ctx);
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialId, CompareType.EQUALS));
            if (poInfo != null && poInfo.getStorageOrgUnit() != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)poInfo.getStorageOrgUnit().getId().toString(), CompareType.EQUALS));
            }
            viewInfo.setFilter(filterInfo);
            viewInfo.getSelector().add(new SelectorItemInfo("defaultWarehouse.id"));
            viewInfo.getSelector().add(new SelectorItemInfo("defaultWarehouse.number"));
            viewInfo.getSelector().add(new SelectorItemInfo("defaultWarehouse.name"));
            viewInfo.getSelector().add(new SelectorItemInfo("material.id"));
            MaterialInventoryCollection materialInventorySet = materialInventory.getMaterialInventoryCollection(viewInfo);
            if (materialInventorySet != null && materialInventorySet.size() > 0) {
                warehouse = materialInventorySet.get(0).getDefaultWarehouse();
            }
            if (outPutType.getValue() == 10730 || outPutType.getValue() == 10720) {
                sic.add(new SelectorItemInfo("outputEntry.*"));
                sic.add(new SelectorItemInfo("outputEntry.productLineWP.id"));
                sic.add(new SelectorItemInfo("outputEntry.productLineWP.number"));
                sic.add(new SelectorItemInfo("outputEntry.productLineWP.name"));
                sic.add(new SelectorItemInfo("outputEntry.material.id"));
                order = productionOrder.getProductionOrderInfo((IObjectPK)new ObjectSingleKey((Object)orderId), sic);
                ProductionOrderOutputEntryCollection outPuts = order.getOutputEntry();
                for (int i = 0; i < outPuts.size(); ++i) {
                    if (!outPuts.get(i).getMaterial().getId().toString().equals(materialId)) continue;
                    wp = outPuts.get(i).getProductLineWP();
                    break;
                }
            }
        }
        return new Object[]{wp, warehouse};
    }

    @Override
    protected String _getUsableMaterialIDs(Context ctx, MaterialAttributeEnum materialAttr) throws BOSException, EASBizException {
        IRowSet rows;
        StringBuffer rs = new StringBuffer();
        StringBuffer sqlBuffer = new StringBuffer();
        ArrayList<Integer> params = new ArrayList<Integer>();
        sqlBuffer.append("select o.FMaterialID from T_BD_MaterialPlan o where o.FStatus = ? ");
        params.add(new Integer(1));
        if (materialAttr != null) {
            sqlBuffer.append(" and o.FMaterialAttr = ? ");
            params.add(new Integer(materialAttr.getValue()));
        }
        if (null != (rows = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString(), (Object[])params.toArray()))) {
            try {
                while (rows.next()) {
                    rs.append("," + rows.getString(1));
                }
                if (rs.length() > 0) {
                    rs.deleteCharAt(0);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return rs.toString();
    }

    @Override
    protected Boolean _writeBack(Context ctx, String finishedRptId, boolean writeBack) throws BOSException, EASBizException {
        Boolean isComplete = null;
        FinishedRptInfo finishedRpt = this.getFinishedRptInfoById(ctx, finishedRptId);
        FinishedRptEntryCollection tempEntrys = this.sumEntrys(ctx, finishedRpt);
        for (int i = 0; i < tempEntrys.size(); ++i) {
            FinishedRptEntryInfo entry = tempEntrys.get(i);
            isComplete = this.writeBackCommitQtyAndStatus(ctx, finishedRpt, entry, writeBack);
        }
        return isComplete;
    }

    private void beforeWriteBack(Context ctx, String finishedRptId, boolean writeBack) throws BOSException, EASBizException {
        FinishedRptInfo finishedRpt = this.getFinishedRptInfoById(ctx, finishedRptId);
        FinishedRptEntryCollection tempEntrys = this.sumEntrys(ctx, finishedRpt);
        for (int i = 0; i < tempEntrys.size(); ++i) {
            FinishedRptEntryInfo entry = tempEntrys.get(i);
            if (writeBack || !entry.isUrgentRelease()) continue;
            String sql = "update T_MM_FinishedRptEntry set FTotalPassQty = ?,FBaseTotalPassQty = ? where FID = ? ";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new BigDecimal(0), new BigDecimal(0), entry.getId().toString()});
        }
    }

    @Override
    protected void _updatePickingSlipStatus(Context ctx, String productionOrderId) throws BOSException, EASBizException {
        String kSQL = "update T_MM_PickingSlipBill set FBaseStatus = ? where FProductionOrderID = ? ";
        DbUtil.execute((Context)ctx, (String)kSQL, (Object[])new Object[]{new Integer(90), productionOrderId});
    }

    public ProductionOrderStockEntryCollection calculateSendOutQty(Context ctx, ProductionOrderInfo productionOrderInfo, BigDecimal mainProductBaseCommitQty) throws EASBizException, BOSException {
        ProductionOrderStockEntryInfo stockEntryInfo;
        Iterator iter;
        ProductionOrderStockEntryCollection list = new ProductionOrderStockEntryCollection();
        if (null == productionOrderInfo || null == mainProductBaseCommitQty) {
            return list;
        }
        ProductionOrderStockEntryCollection stockEntrys = productionOrderInfo.getStockEntry();
        IMultiMeasureUnit multiUnit = MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
        MultiMeasureUnitInfo multiUnifInfo = multiUnit.getMultiUnit(productionOrderInfo.getMaterial().getId().toString(), productionOrderInfo.getUnit().getId().toString());
        HashSet<String> stockMaterialIds = new HashSet<String>();
        MultiMeasureUnitCollection multiUnitColls = null;
        if (null != stockEntrys && stockEntrys.size() > 0) {
            iter = stockEntrys.iterator();
            while (iter.hasNext()) {
                stockEntryInfo = (ProductionOrderStockEntryInfo)iter.next();
                stockMaterialIds.add(stockEntryInfo.getMaterial().getId().toString());
            }
            stockMaterialIds.add(productionOrderInfo.getMaterial().getId().toString());
            multiUnitColls = this.getMultiMeasureUnit(ctx, stockMaterialIds);
        }
        if (null != stockEntrys && stockEntrys.size() > 0) {
            iter = stockEntrys.iterator();
            while (iter.hasNext()) {
                stockEntryInfo = (ProductionOrderStockEntryInfo)iter.next();
                BigDecimal sendOutQty = new BigDecimal(String.valueOf(0.0));
                BigDecimal sendOutBaseQty = new BigDecimal(String.valueOf(0.0));
                if (!stockEntryInfo.isIsBackFlush()) continue;
                sendOutBaseQty = mainProductBaseCommitQty.multiply(stockEntryInfo.getBaseQty()).divide(productionOrderInfo.getBaseQty(), 16, 4);
                sendOutQty = this.getExchangeQtyForServer(ctx, stockEntryInfo.getMaterial().getId().toString(), stockEntryInfo.getBaseUnit(), stockEntryInfo.getUnit(), sendOutBaseQty, multiUnitColls);
                sendOutBaseQty = sendOutBaseQty.divide(new BigDecimal("1"), stockEntryInfo.getBaseUnit().getQtyPrecision(), 4);
                if (!(sendOutQty.doubleValue() > 0.0)) continue;
                stockEntryInfo.setThisSendOutQty(sendOutQty);
                if (stockEntryInfo.getSendOutTotalQty() == null) {
                    stockEntryInfo.setSendOutTotalQty(new BigDecimal(String.valueOf(0.0)));
                }
                stockEntryInfo.setSendOutTotalQty(sendOutQty);
                stockEntryInfo.setBaseSendOutTotalQty(sendOutBaseQty);
                list.add(stockEntryInfo);
            }
        }
        return list;
    }

    public MaterialReqBillInfo transform(Context ctx, IMaterialReqBill iMaterialReqBill, FinishedRptInfo finishedRpt, ProductionOrderStockEntryCollection stockEntrys) throws EASBizException, BOSException {
        MaterialReqBillInfo outBill = (MaterialReqBillInfo)iMaterialReqBill.createNewData(false);
        outBill.setSourceBillType(finishedRpt.getBillType());
        outBill.setAdminOrgUnit(finishedRpt.getWorkshop());
        outBill.setStorageOrgUnit(finishedRpt.getStorageOrgUnit());
        BillTypeInfo billType = new BillTypeInfo();
        billType.setId(BOSUuid.read((String)"50957179-0105-1000-e000-0163c0a812fd463ED552"));
        outBill.setBillType(billType);
        TransactionTypeInfo tsInfo = new TransactionTypeInfo();
        tsInfo.setId(BOSUuid.read((String)"vLfUF0vKSKepVDxJN9eVQLAI3Kc="));
        outBill.setTransactionType(tsInfo);
        outBill.setIsBackflush(true);
        ProductionOrderInfo productionOrderInfo = ProductionOrderFactory.getLocalInstance(ctx).getProductionOrderInfo((IObjectPK)new ObjectUuidPK(finishedRpt.getProductionOrder().getId()));
        Iterator iter = stockEntrys.iterator();
        while (iter.hasNext()) {
            ProductionOrderStockEntryInfo stockEntryInfo = (ProductionOrderStockEntryInfo)iter.next();
            MaterialReqBillEntryInfo outBillEntry = new MaterialReqBillEntryInfo();
            outBillEntry.setWarehouse(stockEntryInfo.getDefaultWarehouse());
            outBillEntry.setSourceBillNumber(finishedRpt.getNumber());
            outBillEntry.setStorageOrgUnit(finishedRpt.getStorageOrgUnit());
            outBillEntry.setProductLine(finishedRpt.getProductLine());
            outBillEntry.setClassGroup(finishedRpt.getClassGroup());
            outBillEntry.setPerson(finishedRpt.getPerson());
            outBillEntry.setTraceNo(finishedRpt.getTraceNo());
            outBillEntry.setMaterial(stockEntryInfo.getMaterial());
            outBillEntry.setUnit(stockEntryInfo.getUnit());
            outBillEntry.setBaseUnit(stockEntryInfo.getBaseUnit());
            outBillEntry.setIssueQty(stockEntryInfo.getThisSendOutQty());
            outBillEntry.setQty(stockEntryInfo.getThisSendOutQty());
            outBillEntry.setBaseQty(SCMUtils.getExchangeQtyForServer((Context)ctx, (String)outBillEntry.getMaterial().getId().toString(), (MeasureUnitInfo)outBillEntry.getUnit(), (MeasureUnitInfo)outBillEntry.getBaseUnit(), (BigDecimal)outBillEntry.getQty()));
            outBillEntry.setProductLineWP(stockEntryInfo.getProductLineWP());
            outBillEntry.setPickingDate(new Timestamp(System.currentTimeMillis()));
            outBillEntry.setParent(outBill);
            outBillEntry.setOrderBillId(productionOrderInfo.getId().toString());
            outBillEntry.setOrderNumber(productionOrderInfo.getNumber());
            outBillEntry.setAssistUnit(stockEntryInfo.getMaterial().getAssistUnit());
            if (stockEntryInfo.getMaterial().getAssistUnit() != null) {
                outBillEntry.setAssistQty(SCMUtils.getExchangeQtyForServer((Context)ctx, (String)outBillEntry.getMaterial().getId().toString(), (MeasureUnitInfo)outBillEntry.getUnit(), (MeasureUnitInfo)outBillEntry.getAssistUnit(), (BigDecimal)outBillEntry.getQty()));
            }
            outBill.getEntry().add(outBillEntry);
        }
        return outBill;
    }

    protected String getScmSubmitAuditParam(Context ctx, String orgUnitID, String billTypeId) throws BOSException, EASBizException {
        ISCMBillParam scmParam;
        String key;
        String pValue;
        if (null == this.scmSubmitAuditParam) {
            this.scmSubmitAuditParam = new HashMap();
        }
        if (null == (pValue = (String)this.scmSubmitAuditParam.get(key = orgUnitID + "-" + billTypeId + "-" + 4)) && null != (pValue = (scmParam = SCMBillParamFactory.getLocalInstance((Context)ctx)).getParamByBillTypeID("SCM_Submit_01", 4, orgUnitID, billTypeId))) {
            this.scmSubmitAuditParam.put(key, pValue);
        }
        return pValue;
    }

    @Override
    protected void _updateRptTotalQty(Context ctx, Map billingData) throws BOSException, EASBizException {
        if (null == billingData) {
            return;
        }
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        String kSQL = "update T_MM_FinishedRptEntry set FRptTotalQty = FRptTotalQty + ?,FBaseRptTotalQty = FBaseRptTotalQty + ?,FBillingQty = ?,FBaseBillingQty = ? where FID = ? ";
        for (FinishedRptBillingVO element : billingData.values()) {
            params.add(new Object[]{element.getRecQty(), element.getBaseRecQty(), element.getRecQty(), element.getBaseRecQty(), element.getBillLineId()});
        }
        DBBatchUtil.executeBatch((Context)ctx, (String)kSQL, params);
    }

    @Override
    protected void _updateRptTotalQty(Context ctx, IObjectCollection objectColls, boolean isFinishedRpt) throws BOSException, EASBizException {
        FinishedRptCollection colls = (FinishedRptCollection)objectColls;
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        if (isFinishedRpt) {
            String sql = "update T_MM_FinishedRptEntry set FRptTotalQty = FRptTotalQty + ?,FBaseRptTotalQty = FBaseRptTotalQty + ?,FRejectRptTotalQty = FRejectRptTotalQty+?,FBaseRejectRptTotalQty = FBaseRejectRptTotalQty+? where FID = ? ";
            for (int i = 0; i < colls.size(); ++i) {
                FinishedRptInfo info = colls.get(i);
                for (int j = 0; j < info.getEntrys().size(); ++j) {
                    FinishedRptEntryInfo entryInfo = info.getEntrys().get(j);
                    BigDecimal passQty = new BigDecimal("0");
                    BigDecimal basePassQty = new BigDecimal("0");
                    if (entryInfo.getPassBillingQty() != null) {
                        passQty = entryInfo.getPassBillingQty();
                        basePassQty = SCMUtils.getExchangeQtyForServer((Context)ctx, (String)entryInfo.getMaterial().getId().toString(), (MeasureUnitInfo)entryInfo.getUnit(), (MeasureUnitInfo)entryInfo.getMaterial().getBaseUnit(), (BigDecimal)entryInfo.getPassBillingQty());
                    }
                    BigDecimal unPassQty = new BigDecimal("0");
                    BigDecimal baseUnPassQty = new BigDecimal("0");
                    if (entryInfo.getUnPassBillingQty() != null) {
                        unPassQty = entryInfo.getUnPassBillingQty();
                        baseUnPassQty = SCMUtils.getExchangeQtyForServer((Context)ctx, (String)entryInfo.getMaterial().getId().toString(), (MeasureUnitInfo)entryInfo.getUnit(), (MeasureUnitInfo)entryInfo.getMaterial().getBaseUnit(), (BigDecimal)entryInfo.getUnPassBillingQty());
                    }
                    params.add(new Object[]{passQty, basePassQty, unPassQty, baseUnPassQty, entryInfo.getId().toString()});
                }
            }
            DBBatchUtil.executeBatch((Context)ctx, (String)sql, params);
        }
    }

    @Override
    protected void _updateRptTotalQty(Context ctx, String manufactureRecId, List entrysId) throws BOSException, EASBizException {
        StringBuffer kSQL = null;
        StringBuffer strEntryIds = new StringBuffer();
        IRowSet rows = null;
        if (entrysId != null && entrysId.size() > 0) {
            if (null != entrysId && entrysId.size() > 0) {
                Iterator iter = entrysId.iterator();
                while (iter.hasNext()) {
                    strEntryIds.append((String)iter.next()).append(",");
                }
            }
            kSQL = new StringBuffer();
            kSQL.append(" select FReceiveQty, FBaseQty, FSourceBillID, FSourceBillEntryID ");
            kSQL.append(" from T_IM_ManufactureRecBillEntry where FID in (?) ");
            if (strEntryIds != null && !"".equals(strEntryIds.toString())) {
                Object[] param = new Object[]{strEntryIds.substring(0, strEntryIds.lastIndexOf(","))};
                rows = DbUtil.executeQuery((Context)ctx, (String)kSQL.toString(), (Object[])param);
            }
        } else {
            kSQL = new StringBuffer();
            kSQL.append(" select b.FReceiveQty FReceiveQty, b.FBaseQty FBaseQty, b.FSourceBillID FSourceBillID, b.FSourceBillEntryID FSourceBillEntryID ");
            kSQL.append(" from T_IM_ManufactureRecBill a, T_IM_ManufactureRecBillEntry b ");
            kSQL.append(" where a.fid = b.fparentid ");
            kSQL.append(" and a.fid = ? ");
            rows = DbUtil.executeQuery((Context)ctx, (String)kSQL.toString(), (Object[])new Object[]{manufactureRecId});
        }
        if (rows != null) {
            try {
                while (rows.next()) {
                    BigDecimal receiveQty = rows.getBigDecimal("FReceiveQty");
                    BigDecimal baseReceiveQty = null;
                    String finishedEntryId = rows.getString("FSourceBillEntryID");
                    String finishedId = rows.getString("FSourceBillID");
                    FinishedRptInfo finishedRpt = this.getFinishedRptInfo(ctx, (IObjectPK)new ObjectUuidPK(finishedId));
                    Iterator iter = finishedRpt.getEntrys().iterator();
                    while (iter.hasNext()) {
                        FinishedRptEntryInfo info = (FinishedRptEntryInfo)iter.next();
                        if (!info.getId().toString().equals(finishedEntryId)) continue;
                        baseReceiveQty = SCMUtils.getExchangeQtyForServer((Context)ctx, (String)info.getMaterial().getId().toString(), (MeasureUnitInfo)info.getUnit(), (MeasureUnitInfo)info.getBaseUnit(), (BigDecimal)receiveQty);
                        break;
                    }
                    if (baseReceiveQty == null) {
                        baseReceiveQty = new BigDecimal(String.valueOf("0.00"));
                    }
                    StringBuffer updateSQL = new StringBuffer();
                    updateSQL.append(" update T_MM_FinishedRptEntry ");
                    updateSQL.append(" set FRptTotalQty = FRptTotalQty + ?, ");
                    updateSQL.append(" FBaseRptTotalQty = FBaseRptTotalQty + ? ");
                    updateSQL.append(" where fid = ? ");
                    DbUtil.execute((Context)ctx, (String)updateSQL.toString(), (Object[])new Object[]{receiveQty.negate(), baseReceiveQty.negate(), finishedEntryId});
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    public void buildLotMaterial(Context ctx, FinishedRptInfo finishedRpt) throws BOSException {
        if (null == finishedRpt || finishedRpt.isOnceAudit()) {
            return;
        }
        String tableName = null;
        try {
            StringBuffer createSQL = new StringBuffer();
            createSQL.append("Create Table T_MM_FinishedRpt_LOT_Mid (").append("FID VARCHAR(44),").append("FFinisheRptID VARCHAR(44),").append("FFinishedRptEntryID VARCHAR(44),").append("FTaskDispBillID VARCHAR(44),").append("FProductionOrderID VARCHAR(44),").append("FStorageOrgUnitID VARCHAR(44),").append("FWorkshopID VARCHAR(44),").append("FProductLineID VARCHAR(44),").append("FClassGroupID VARCHAR(44),").append("FMaterialID VARCHAR(44),").append("FLotNo NVARCHAR(80),").append("FBussinessType INT,").append("FFinishDate DateTime);");
            tableName = this.createTempTable(ctx, createSQL.toString());
            StringBuffer headKSQL = new StringBuffer();
            headKSQL.append("insert into  ");
            headKSQL.append(tableName);
            headKSQL.append(" (FID,FFinisheRptID,FFinishedRptEntryID,FTaskdispbillid,FProductionorderid,FStorageOrgUnitID,FWorkshopID,FProductLineID,FClassGroupID,FMaterialID,FLotNo,FBussinessType,FFinishDate) ");
            headKSQL.append("select newbosid('").append("F936F7CF").append("'),");
            headKSQL.append("FParentID,");
            headKSQL.append("fid,");
            headKSQL.append("ftaskdispbillid,");
            headKSQL.append("fproductionorderid,");
            headKSQL.append("FStorageOrgUnitID,");
            headKSQL.append("FWorkshopID,");
            headKSQL.append("FProductLineID,");
            headKSQL.append("FClassGroupID,");
            headKSQL.append("FMaterialID,");
            headKSQL.append("FLotNo, ");
            headKSQL.append("FMmBizType, ");
            headKSQL.append("FFinishDate from (");
            headKSQL.append("select distinct ");
            headKSQL.append("h.ftaskdispbillid,");
            headKSQL.append("h.fproductionorderid,");
            headKSQL.append("h.FStorageOrgUnitID,");
            headKSQL.append("h.FWorkshopID,");
            headKSQL.append("h.FProductLineID,");
            headKSQL.append("h.FClassGroupID,");
            headKSQL.append("d.FMaterialID,");
            headKSQL.append("d.FLotNo,");
            headKSQL.append("d.FFinishDate,");
            headKSQL.append("p.FMmBizType,");
            headKSQL.append("d.fparentid,");
            headKSQL.append("d.fid  ");
            headKSQL.append("from T_MM_FinishedRpt h,T_MM_FinishedRptEntry d,T_MM_ProductionOrder p where d.FParentID = h.fid and h.FProductionOrderID = p.fid and h.fid = ? and d.FLotNo is not null) aa");
            DbUtil.execute((Context)ctx, (String)headKSQL.toString(), (Object[])new Object[]{finishedRpt.getId().toString()});
            headKSQL.setLength(0);
            headKSQL.append("insert into T_MM_BatchFile(FID,FSourceBillID,FSourceBillEntryID,FStorageOrgUnitID,FWorkshopID,FProductLineID,FClassGroupID,FMaterialID,FLotNo,FBussinessType,FBatchTime,FBaseStatus) ");
            headKSQL.append("select ");
            headKSQL.append("FID,");
            headKSQL.append("FFinisheRptID,");
            headKSQL.append("FFinishedRptEntryID,");
            headKSQL.append("FStorageOrgUnitID,");
            headKSQL.append("FWorkshopID,");
            headKSQL.append("FProductLineID,");
            headKSQL.append("FClassGroupID,");
            headKSQL.append("FMaterialID,");
            headKSQL.append("FLotNo,");
            headKSQL.append("FBussinessType,");
            headKSQL.append("FFinishDate, ");
            headKSQL.append(2);
            headKSQL.append(" from ").append(tableName).append(" mid ");
            headKSQL.append("where mid.fid not in (select mid.fid from ").append(tableName).append(" mid ").append(",T_MM_BatchFile b where mid.FMaterialID =b.FMaterialID and mid.FLotNo = b.FLotNo)");
            DbUtil.execute((Context)ctx, (String)headKSQL.toString());
            headKSQL.setLength(0);
            headKSQL.append("insert into T_MM_BatchFileEntry(FID,FParentID,FStorageOrgUnitID,FMaterialID,FLotNo) ");
            headKSQL.append("select newbosid('").append("3AC6A9E3").append("'),");
            headKSQL.append("FParentID,");
            headKSQL.append("FStorageOrgUnitID,");
            headKSQL.append("FMaterialID,");
            headKSQL.append("FLotNo from (");
            headKSQL.append("select distinct ");
            headKSQL.append("b.fid as FParentID,");
            headKSQL.append("h.FStorageOrgUnitID,");
            headKSQL.append("d.FMaterialID,");
            headKSQL.append("dd.FLot FLotNo,");
            headKSQL.append("mid.fid fMidID ");
            headKSQL.append("from T_MM_PickingSlipBill h,T_MM_PickingSlipBillEntry d ,T_MM_PickingSlipLot dd, ").append(tableName).append(" mid ").append(",T_MM_BatchFile b  ");
            headKSQL.append("where dd.FPickingSlipEntryID = d.FID and mid.FMaterialID =b.FMaterialID and mid.FLotNo = b.FLotNo and d.FParentID = h.FID ");
            if (null == finishedRpt.getTaskDispBill()) {
                headKSQL.append("and mid.fproductionorderid = h.fproductionorderid");
            } else {
                headKSQL.append("and mid.ftaskdispbillid = h.ftaskdispid");
            }
            headKSQL.append(") p ");
            headKSQL.append("where p.fMidID not in(select p.fMidID from T_MM_BatchFileEntry  bb where bb.FLotNo = p.FLotNo and bb.FParentID = p.FParentID and bb.FMaterialID = p.FMaterialID) ");
            DbUtil.execute((Context)ctx, (String)headKSQL.toString());
        }
        catch (BOSException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                if (!StringUtils.isEmpty(tableName)) {
                    String sql = "delete from " + tableName;
                    DbUtil.execute((Context)ctx, (String)sql);
                    this.releaseTempTable(ctx, tableName);
                }
                throw throwable;
            }
        }
        if (!StringUtils.isEmpty((String)tableName)) {
            String sql = "delete from " + tableName;
            DbUtil.execute((Context)ctx, (String)sql);
            this.releaseTempTable(ctx, tableName);
        }
    }

    private String createTempTable(Context ctx, String createTableSQL) throws BOSException {
        String rtnTableName = "";
        try {
            TempTablePool pool = TempTablePool.getInstance((Context)ctx);
            rtnTableName = pool.createTempTable(createTableSQL);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return rtnTableName;
    }

    private void releaseTempTable(Context ctx, String tableName) {
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        pool.releaseTable(tableName);
    }

    private boolean getTaskDispType(Context ctx, FinishedRptInfo finishedRpt) throws FinishedRptException {
        boolean isTaskDisp = false;
        int taskDispType = -1;
        try {
            String value;
            if (finishedRpt != null && finishedRpt.getStorageOrgUnit() != null && (taskDispType = Integer.parseInt(value = ParamManager.getParamValue((Context)ctx, (IObjectPK)new ObjectUuidPK(finishedRpt.getStorageOrgUnit().getId().toString()), (String)"TaskDispType"))) != 2) {
                isTaskDisp = true;
            }
        }
        catch (Exception e) {
            throw new FinishedRptException(FinishedRptException.BLANK, new String[]{FinishedRptUtil.getHolderResource("GetTaskTypeFailed", new String[]{finishedRpt.getStorageOrgUnit().getName()})});
        }
        return isTaskDisp;
    }

    @Override
    protected String _getProductLineWPIdsByOrder(Context ctx, String productionOrderId) throws BOSException, EASBizException {
        String rtnIds = "";
        StringBuffer ids = new StringBuffer();
        StringBuffer kSQL = new StringBuffer();
        kSQL.append(" select FProductLineWPID from T_MM_ProductionOrderEntry where FParentID = ? and FIsReportPoint = 1 ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)kSQL.toString(), (Object[])new Object[]{productionOrderId});
        try {
            while (rs.next()) {
                ids.append(rs.getString("FProductLineWPID")).append(",");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (ids != null && ids.length() > 0) {
            rtnIds = ids.substring(0, ids.length() - 1);
        }
        return rtnIds;
    }

    @Override
    protected Object[] _isCanFinish(Context ctx, FinishedRptInfo finishedRpt) throws BOSException, EASBizException {
        if (null == finishedRpt.getProductionOrder()) {
            return null;
        }
        Object[] rtnObject = null;
        FinishedRptEntryCollection entrys = this.sumEntrys(ctx, finishedRpt);
        AbstractFinishedRptEntryInfo mainEntry = null;
        if (null != entrys && entrys.size() > 0) {
            for (int i = 0; i < entrys.size(); ++i) {
                FinishedRptEntryInfo info = entrys.get(i);
                if (null == info.getOutputType() || info.getOutputType().getValue() != 10710) continue;
                mainEntry = info;
            }
        }
        if (null != mainEntry && null != mainEntry.getCommitQty() && mainEntry.getCommitQty().doubleValue() >= 0.0) {
            rtnObject = new Object[3];
            boolean isFinishFlag = this.isFinished(ctx, finishedRpt, mainEntry.getMaterial().getId().toString(), mainEntry.getBaseCommtQty());
            String sourceBillNumber = "";
            Boolean isPckSlipComplete = null;
            if (finishedRpt.getTaskDispBill() != null) {
                sourceBillNumber = finishedRpt.getTaskDispBill().getNumber();
                if (isFinishFlag) {
                    boolean isPrdAutoFinsihed = ProductionOrderFacadeFactory.getLocalInstance(ctx).isAutoFinished(finishedRpt.getProductionOrder().getId().toString());
                    if (isPrdAutoFinsihed) {
                        isPckSlipComplete = this.isAllCompletePickingSlip(ctx, finishedRpt.getProductionOrder().getId().toString());
                    } else {
                        isFinishFlag = false;
                    }
                }
            } else {
                boolean isPrdAutoFinsihed = ProductionOrderFacadeFactory.getLocalInstance(ctx).isAutoFinished(finishedRpt.getProductionOrder().getId().toString());
                if (isPrdAutoFinsihed) {
                    isPckSlipComplete = this.isAllCompletePickingSlip(ctx, finishedRpt.getProductionOrder().getId().toString());
                } else {
                    isFinishFlag = false;
                }
            }
            rtnObject[0] = new Boolean(isFinishFlag);
            rtnObject[1] = sourceBillNumber;
            rtnObject[2] = isPckSlipComplete;
        }
        return rtnObject;
    }

    @Override
    protected Object[] _isCanFinish(Context ctx, String finishedRptId) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)finishedRptId)) {
            return null;
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("entrys.*"));
        selector.add(new SelectorItemInfo("productionOrder.*"));
        selector.add(new SelectorItemInfo("taskDispBill.*"));
        FinishedRptInfo finishedRpt = this.getFinishedRptInfo(ctx, (IObjectPK)new ObjectUuidPK(finishedRptId), selector);
        return this._isCanFinish(ctx, finishedRpt);
    }

    @Override
    protected String _getBatchFileID(Context ctx, String finishedID, String finishedentryID, String storageOrgUnitID) throws BOSException {
        StringBuffer kSQL = new StringBuffer();
        kSQL.append(" select fid from T_MM_BatchFile where FStorageOrgUnitID = ? and FSourceBillID = ? and FSourcebillEntryID=? ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)kSQL.toString(), (Object[])new Object[]{storageOrgUnitID, finishedID, finishedentryID});
        String id = null;
        try {
            while (rs.next()) {
                id = rs.getString("fid");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return id;
    }

    @Override
    protected boolean _isPickingSlipWhenFinished(Context ctx, String finishedId) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)finishedId)) {
            return true;
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("entrys.*"));
        selector.add(new SelectorItemInfo("productionOrder.*"));
        selector.add(new SelectorItemInfo("productionOrder.stockEntry.*"));
        selector.add(new SelectorItemInfo("productionOrder.stockEntry.material.*"));
        selector.add(new SelectorItemInfo("taskDispBill.*"));
        selector.add(new SelectorItemInfo("storageOrgUnit.*"));
        FinishedRptInfo finishedRpt = this.getFinishedRptInfo(ctx, (IObjectPK)new ObjectUuidPK(finishedId), selector);
        FinishedRptEntryCollection entrys = this.sumEntrys(ctx, finishedRpt);
        AbstractFinishedRptEntryInfo mainEntry = null;
        if (null != entrys && entrys.size() > 0) {
            for (int i = 0; i < entrys.size(); ++i) {
                FinishedRptEntryInfo info = entrys.get(i);
                if (null == info.getOutputType() || info.getOutputType().getValue() != 10710) continue;
                mainEntry = info;
                entrys.removeObject(i);
                break;
            }
        }
        boolean mainFlag = true;
        boolean otherFlag = true;
        if (mainEntry != null) {
            BigDecimal commitQty = mainEntry.getCommitQty();
            BigDecimal reqQty = finishedRpt.getProductionOrder().getQty();
            ProductionOrderInfo productOrder = finishedRpt.getProductionOrder();
            MaterialInfo[] materialInfos = new MaterialInfo[productOrder.getStockEntry().size()];
            StorageOrgUnitInfo[] storageOrgUnitInfos = new StorageOrgUnitInfo[materialInfos.length];
            MeasureUnitInfo[] unitInfos = new MeasureUnitInfo[materialInfos.length];
            MeasureUnitInfo[] baseUnitInfos = new MeasureUnitInfo[materialInfos.length];
            for (int i = 0; i < productOrder.getStockEntry().size(); ++i) {
                MaterialInfo material = productOrder.getStockEntry().get(i).getMaterial();
                MeasureUnitInfo unit = productOrder.getStockEntry().get(i).getUnit();
                MeasureUnitInfo baseUnit = productOrder.getStockEntry().get(i).getBaseUnit();
                materialInfos[i] = material;
                unitInfos[i] = unit;
                baseUnitInfos[i] = baseUnit;
                storageOrgUnitInfos[i] = finishedRpt.getStorageOrgUnit();
            }
            SCMEntryDataVO vo = new SCMEntryDataVO();
            SCMEntryDataVO voResult = new SCMEntryDataVO();
            vo.setIsLoadingMaterialInventory(true);
            vo.setMaterialInfos(materialInfos);
            vo.setIsLoadingMaterialPlan(true);
            vo.setIsLoadingMaterialInventory(true);
            vo.setStorageOrgUnitInfos(storageOrgUnitInfos);
            vo.setMeasureUnitInfos(unitInfos);
            vo.setBaseMeasureUnitInfos(baseUnitInfos);
            vo.setIsLoadingMmuPrecision(true);
            voResult = SCMGroupFacadeFactory.getLocalInstance((Context)ctx).loadComplexData(vo);
            Map mpInfoMap = voResult.getMaterialPlanInfos();
            Map precisionMap = voResult.getMmuPrecisions();
            int preci = 8;
            for (int i = 0; i < productOrder.getStockEntry().size(); ++i) {
                MaterialInfo material = productOrder.getStockEntry().get(i).getMaterial();
                MeasureUnitInfo unit = productOrder.getStockEntry().get(i).getUnit();
                if (productOrder.getStockEntry().get(i).isIsBackFlush()) continue;
                MaterialPlanInfo plan = (MaterialPlanInfo)mpInfoMap.get(material.getId().toString() + finishedRpt.getStorageOrgUnit().getId().toString());
                Integer precision = (Integer)precisionMap.get(material.getId().toString() + unit.getId().toString());
                if (precision != null) {
                    preci = precision;
                }
                BigDecimal per = plan.getIssInLowLimit().divide(new BigDecimal("100"), 8, 4);
                BigDecimal shouldPick = commitQty.multiply(productOrder.getStockEntry().get(i).getQty()).multiply(new BigDecimal("1").subtract(per)).divide(reqQty, preci, 4);
                BigDecimal temp = new BigDecimal("0");
                if (productOrder.getStockEntry().get(i).getIssMode().equals((Object)MaterialIssueModeEnum.STRAIGHT)) {
                    temp = productOrder.getStockEntry().get(i).getTotleReceiveQty();
                } else {
                    if (!productOrder.getStockEntry().get(i).getIssMode().equals((Object)MaterialIssueModeEnum.PRODUCEISSMODE)) continue;
                    temp = productOrder.getStockEntry().get(i).getSendOutTotalQty().subtract(productOrder.getStockEntry().get(i).getUntreadTotalQty());
                }
                if (!(temp.subtract(shouldPick).doubleValue() < 0.0)) continue;
                mainFlag = false;
                break;
            }
        }
        if (entrys != null && entrys.size() > 0) {
            ProductionOrderInfo productOrder = finishedRpt.getProductionOrder();
            int count = 0;
            for (int i = 0; i < productOrder.getStockEntry().size(); ++i) {
                if (productOrder.getStockEntry().get(i).isIsBackFlush()) {
                    ++count;
                    continue;
                }
                BigDecimal total = productOrder.getStockEntry().get(i).getSendOutTotalQty().subtract(productOrder.getStockEntry().get(i).getUntreadTotalQty()).add(productOrder.getStockEntry().get(i).getTotleReceiveQty());
                if (total.doubleValue() > 0.0) {
                    otherFlag = true;
                    break;
                }
                ++count;
            }
            if (count == productOrder.getStockEntry().size()) {
                otherFlag = false;
            }
        }
        return mainFlag && otherFlag;
    }

    @Override
    protected void _makeCheckReq(Context ctx, IObjectCollection collection, IObjectPK[] pks) throws BOSException, EASBizException {
        FinishedRptInfo info;
        int i;
        FinishedRptCollection colls = (FinishedRptCollection)collection;
        CoreBillBaseCollection coreBillColl = new CoreBillBaseCollection();
        for (i = 0; i < colls.size(); ++i) {
            info = colls.get(i);
            coreBillColl.add((CoreBillBaseInfo)info);
        }
        for (i = 0; i < collection.size(); ++i) {
            info = (FinishedRptInfo)collection.getObject(i);
            for (int j = 0; j < info.getEntrys().size(); ++j) {
                MaterialPlanInfo plan;
                FinishedRptEntryInfo entryInfo = info.getEntrys().get(j);
                IOrgUnitRelation iOrgUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
                QualityOrgUnitInfo orgInfo = (QualityOrgUnitInfo)iOrgUnitRel.getDefaultToUnit(info.getStorageOrgUnit().getId().toString(), 4, 32);
                entryInfo.setQualityOrgUnit(orgInfo);
                SCMEntryDataVO vo = new SCMEntryDataVO();
                SCMEntryDataVO voResult = new SCMEntryDataVO();
                MaterialInfo[] materialInfos = new MaterialInfo[]{entryInfo.getMaterial()};
                vo.setIsLoadingMaterialInventory(true);
                vo.setMaterialInfos(materialInfos);
                vo.setIsLoadingMaterialPlan(true);
                vo.setIsLoadingMaterialInventory(true);
                vo.setStorageOrgUnitInfos(new StorageOrgUnitInfo[]{info.getStorageOrgUnit()});
                voResult = SCMGroupFacadeFactory.getLocalInstance((Context)ctx).loadComplexData(vo);
                Map mpInfoMap = voResult.getMaterialPlanInfos();
                Object value = mpInfoMap.get(entryInfo.getMaterial().getId().toString() + info.getStorageOrgUnit().getId().toString());
                if (value == null || (plan = (MaterialPlanInfo)mpInfoMap.get(entryInfo.getMaterial().getId().toString() + info.getStorageOrgUnit().getId().toString())).getQualityOrg() == null) continue;
                OrgUnitCollection orgColls = iOrgUnitRel.getToUnit(info.getStorageOrgUnit().getId().toString(), 4, 32);
                boolean flag = false;
                for (int m = 0; m < orgColls.size(); ++m) {
                    if (!orgColls.get(m).getId().toString().equals(plan.getQualityOrg().getId().toString())) continue;
                    entryInfo.setQualityOrgUnit(plan.getQualityOrg());
                    flag = true;
                    break;
                }
                if (flag) continue;
                ActionCommonException bizExp = new ActionCommonException(null);
                bizExp.setMessage(FinishedRptUtil.getResource("qualityOrgNotValidate", ctx));
                throw bizExp;
            }
        }
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        BOSObjectType bosType = new QCRequestInfo().getBOSType();
        BTPTransformResult result = iBTPManager.transformMultiBill(coreBillColl, bosType.toString());
        IObjectCollection destBillColl = result.getBills();
        BOTRelationCollection botRelateColl = result.getBOTRelationCollection();
        QCRequestFactory.getLocalInstance((Context)ctx).handleAfterTransform("SAVE", destBillColl);
        QCRequestInfo destBillInfo = null;
        int size = destBillColl.size();
        for (int i2 = 0; i2 < size; ++i2) {
            destBillInfo = (QCRequestInfo)destBillColl.getObject(i2);
            FinishedRptControllerBean.botpSave(ctx, botRelateColl, (QMBillBaseInfo)destBillInfo);
        }
        StringBuffer sql = new StringBuffer("select ");
        Locale locale = ContextUtils.getLocaleFromEnv();
        if ("l1".equalsIgnoreCase(locale.getLanguage())) {
            sql.append(" FDescription_L1 ");
        } else if ("l3".equalsIgnoreCase(locale.getLanguage())) {
            sql.append(" FDescription_L3 ");
        } else if ("l2".equalsIgnoreCase(locale.getLanguage())) {
            sql.append(" FDescription_L2 ");
        }
        sql.append(" as methodDesc from T_LOG_LogItem where fname = 'mm_finishedRpt_makeCheckReq'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        String methodDesc = "";
        try {
            if (rs.next()) {
                methodDesc = rs.getString("methodDesc");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        for (int i3 = 0; i3 < coreBillColl.size(); ++i3) {
            FinishedRptInfo info2 = (FinishedRptInfo)collection.getObject(i3);
            IObjectPK logPk = LogUtil.beginLog((Context)ctx, (String)"1", (BOSObjectType)this.getBOSType(), (IObjectPK)new ObjectUuidPK(info2.getId().toString()), (String)info2.getNumber(), (String)"mm_finishedRpt_makeCheckReq", (String)info2.getStorageOrgUnit().getId().toString(), (String)methodDesc);
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPk);
        }
    }

    public static void botpSave(Context ctx, BOTRelationCollection botRelationCols, QMBillBaseInfo destBillInfo) throws BOSException, EASBizException {
        IBTPManager btpManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        if (destBillInfo.getBillStatus() == QMBillBaseStatusEnum.Submit) {
            btpManager.submitRelations((CoreBillBaseInfo)destBillInfo, botRelationCols);
        } else {
            btpManager.saveRelations((CoreBillBaseInfo)destBillInfo, botRelationCols);
        }
    }

    @Override
    protected boolean _makeRepairOrder(Context ctx, IObjectCollection srcColls, IObjectPK[] pks) throws BOSException, EASBizException {
        this.makeOrderByBizType(ctx, srcColls, "1");
        return true;
    }

    @Override
    protected boolean _makeReworkOrder(Context ctx, IObjectCollection srcColls, IObjectPK[] pks) throws BOSException, EASBizException {
        this.makeOrderByBizType(ctx, srcColls, "0");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeOrderByBizType(Context ctx, IObjectCollection srcColls, String type) throws BOSException, EASBizException {
        Connection cn = null;
        Connection cn_bot = null;
        try {
            cn = this.getConnection(ctx);
            IORMappingDAO dao = ORMappingDAO.getInstance((BOSObjectType)BOSObjectType.create((String)new ProductionOrderInfo().getBOSType().toString()), (Context)ctx, (Connection)cn);
            cn_bot = this.getConnection(ctx);
            IORMappingDAO dao_bot = ORMappingDAO.getInstance((BOSObjectType)BOSObjectType.create((String)new BOTRelationInfo().getBOSType().toString()), (Context)ctx, (Connection)cn_bot);
            FinishedRptCollection colls = (FinishedRptCollection)srcColls;
            FinishedRptInfo info = null;
            String orgID = null;
            HashMap<String, Boolean> map = new HashMap<String, Boolean>();
            boolean isHasCheckModular = false;
            FinishedRptEntryInfo entryInfo = null;
            FinishedRptCRInfo checkInfo = null;
            ArrayList<String> prdIdList = new ArrayList<String>();
            ProductionOrderInfo prdInfo = null;
            for (int i = 0; i < colls.size(); ++i) {
                info = colls.get(i);
                orgID = info.getStorageOrgUnit().getId().toString();
                Object value = map.get(orgID);
                if (value == null) {
                    String val = ParamManager.getParamValue((Context)ctx, (IObjectPK)new ObjectUuidPK(orgID), (String)"IsHasCheckModular");
                    if (val != null && !val.trim().equals("") && val.trim().equals("true")) {
                        isHasCheckModular = true;
                    }
                    map.put(orgID, new Boolean(val));
                } else {
                    Boolean flag = (Boolean)value;
                    if (flag.booleanValue()) {
                        isHasCheckModular = true;
                    }
                }
                for (int j = 0; j < info.getEntrys().size(); ++j) {
                    entryInfo = info.getEntrys().get(j);
                    if (!isHasCheckModular) {
                        prdInfo = this.buildPrdInfo(ctx, info, entryInfo, null, type);
                        if (prdInfo == null) continue;
                        dao.addNewBatch((IObjectValue)prdInfo);
                        BOTRelationInfo relation = this.buildBOTRelation(ctx, info, prdInfo);
                        dao_bot.addNewBatch((IObjectValue)relation);
                        prdIdList.add(prdInfo.getId().toString());
                        continue;
                    }
                    if (!entryInfo.isIsCheck()) {
                        prdInfo = this.buildPrdInfo(ctx, info, entryInfo, null, type);
                        if (prdInfo == null) continue;
                        dao.addNewBatch((IObjectValue)prdInfo);
                        BOTRelationInfo relation = this.buildBOTRelation(ctx, info, prdInfo);
                        dao_bot.addNewBatch((IObjectValue)relation);
                        prdIdList.add(prdInfo.getId().toString());
                        continue;
                    }
                    if (entryInfo.isUrgentRelease()) continue;
                    for (int k = 0; k < entryInfo.getCheckEntry().size(); ++k) {
                        checkInfo = entryInfo.getCheckEntry().get(k);
                        prdInfo = this.buildPrdInfo(ctx, info, entryInfo, checkInfo, type);
                        if (prdInfo == null) continue;
                        dao.addNewBatch((IObjectValue)prdInfo);
                        BOTRelationInfo relation = this.buildBOTRelation(ctx, info, prdInfo);
                        dao_bot.addNewBatch((IObjectValue)relation);
                        prdIdList.add(prdInfo.getId().toString());
                    }
                }
            }
            dao.executeBatch();
            dao_bot.executeBatch();
            StringBuffer numberSQL = new StringBuffer();
            numberSQL.append("select p.fid as fid ,p.fstorageorgunitid as fstorageorgunitid from t_mm_productionorder p where p.fnumber is null and p.fid in (");
            for (int i = 0; i < prdIdList.size(); ++i) {
                if (i != 0) {
                    numberSQL.append(",");
                }
                numberSQL.append("'" + prdIdList.get(i).toString() + "'");
            }
            numberSQL.append(")");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)numberSQL.toString());
            ArrayList<String> updateList = new ArrayList<String>();
            try {
                ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
                while (rowSet.next()) {
                    String id = rowSet.getString("fid");
                    String orgUnit = rowSet.getString("fstorageorgunitid");
                    ProductionOrderInfo orderInfo = new ProductionOrderInfo();
                    orderInfo.setBizDate(new Date());
                    if (!codingRuleManager.isExist((IObjectValue)orderInfo, orgUnit)) continue;
                    String number = codingRuleManager.getNumber((IObjectValue)orderInfo, orgUnit);
                    String updateNumberSQL = "update t_mm_productionorder set fnumber = '" + number + "' where fid = '" + id + "'";
                    updateList.add(updateNumberSQL);
                }
                if (updateList.size() > 0) {
                    DBBatchUtil.executeBatch((Context)ctx, updateList);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup((Connection)cn);
            SQLUtils.cleanup(cn_bot);
            throw throwable;
        }
        SQLUtils.cleanup((Connection)cn);
        SQLUtils.cleanup((Connection)cn_bot);
    }

    private ProductionOrderInfo buildPrdInfo(Context ctx, FinishedRptInfo info, FinishedRptEntryInfo entryInfo, FinishedRptCRInfo checkInfo, String type) throws EASBizException, BOSException {
        BigDecimal baseQty;
        ProductionOrderInfo prdInfo = new ProductionOrderInfo();
        BOSUuid uuid = BOSUuid.create((String)new ProductionOrderInfo().getBOSType().toString());
        prdInfo.setId(uuid);
        prdInfo.setStorageOrgUnit(info.getStorageOrgUnit());
        if (type.equals("0")) {
            prdInfo.setMmBizType(BizTypeEnum.rework);
        } else {
            prdInfo.setMmBizType(BizTypeEnum.repair);
        }
        prdInfo.setMaterial(entryInfo.getMaterial());
        prdInfo.setBizDate(new Date());
        if (entryInfo.getOutputType().getValue() == 10710) {
            prdInfo.setProductLine(info.getProductLine());
        }
        prdInfo.setExpectEndDate(entryInfo.getFinishDate());
        if (checkInfo == null) {
            if (entryInfo.getUnit() != null) {
                prdInfo.setUnit(entryInfo.getUnit());
            }
            if (entryInfo.getBaseUnit() != null) {
                prdInfo.setBaseUnit(entryInfo.getBaseUnit());
            }
            if (entryInfo.getCurrPrdQty() == null || entryInfo.getCurrPrdQty().doubleValue() == 0.0) {
                return null;
            }
            baseQty = SCMUtils.getExchangeQtyForServer((Context)ctx, (String)entryInfo.getMaterial().getId().toString(), (MeasureUnitInfo)entryInfo.getUnit(), (MeasureUnitInfo)entryInfo.getBaseUnit(), (BigDecimal)entryInfo.getCurrPrdQty());
            prdInfo.setQty(entryInfo.getCurrPrdQty());
            prdInfo.setBaseQty(baseQty);
            prdInfo.setSourceBillEntry(entryInfo.getId().toString());
            prdInfo.setFinishedType(FinishedRptTypeEnum.ENTRY);
        } else {
            if (checkInfo.getUnit() != null) {
                prdInfo.setUnit(checkInfo.getUnit());
            }
            if (checkInfo.getMaterial().getBaseUnit() != null) {
                prdInfo.setBaseUnit(checkInfo.getMaterial().getBaseUnit());
            }
            if (checkInfo.getCurrQty() == null || checkInfo.getCurrQty().doubleValue() == 0.0) {
                return null;
            }
            baseQty = SCMUtils.getExchangeQtyForServer((Context)ctx, (String)checkInfo.getMaterial().getId().toString(), (MeasureUnitInfo)checkInfo.getUnit(), (MeasureUnitInfo)checkInfo.getMaterial().getBaseUnit(), (BigDecimal)checkInfo.getCurrQty());
            prdInfo.setQty(checkInfo.getCurrQty());
            prdInfo.setBaseQty(baseQty);
            prdInfo.setSourceBillEntry(checkInfo.getId().toString());
            prdInfo.setFinishedType(FinishedRptTypeEnum.CHECKENTRY);
        }
        prdInfo.setStartDate(new Date());
        prdInfo.setEndDate(new Date());
        prdInfo.setExpectEndDate(new Date());
        if (info.getTraceNo() != null && !info.getTraceNo().trim().equals("")) {
            prdInfo.setTraceNo(info.getTraceNo());
        }
        if (info.getTrackNumber() != null) {
            prdInfo.setTrackNumber(info.getTrackNumber());
        }
        if (info.getSaleOrder() != null) {
            prdInfo.setSaleOrder(info.getSaleOrder());
        }
        if (entryInfo.getLotNo() != null && !entryInfo.getLotNo().trim().equals("")) {
            prdInfo.setLotNo(entryInfo.getLotNo());
        }
        if (info.getWorkshop() != null) {
            prdInfo.setWorkShop(info.getWorkshop());
        }
        prdInfo.setIsPickSlip(false);
        BillTypeInfo billType = new BillTypeInfo();
        billType.setId(BOSUuid.read((String)"ejIZHXXTQliYCQJg9t4Re0Y+1VI="));
        prdInfo.setBillType(billType);
        prdInfo.setSourceBillId(info.getId().toString());
        prdInfo.setSourceBillNumber(info.getNumber());
        prdInfo.setSource(info.getProductionOrder());
        billType = new BillTypeInfo();
        billType.setId(BOSUuid.read((String)"e3soUQaBR8un8D2R7UpNwkY+1VI="));
        prdInfo.setSourceBillType(billType);
        prdInfo.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        UserInfo user = new UserInfo();
        user.setId(BOSUuid.read((String)ctx.getCaller().toString()));
        prdInfo.setCreator(user);
        prdInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
        prdInfo.setCU(info.getCU());
        MaterialInfo material = prdInfo.getMaterial();
        EntityViewInfo viewer = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)material.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)prdInfo.getStorageOrgUnit().getId().toString(), CompareType.EQUALS));
        viewer.setFilter(filter);
        MaterialPlanCollection planColls = MaterialPlanFactory.getLocalInstance((Context)ctx).getMaterialPlanCollection(viewer);
        if (planColls.size() > 0) {
            MaterialPlanInfo plan = planColls.get(0);
            BigDecimal yield = plan.getYield();
            BigDecimal outputQty = prdInfo.getQty().multiply(yield).divide(new BigDecimal("100"), prdInfo.getUnit().getQtyPrecision(), 4);
            BigDecimal baseOutputQty = prdInfo.getBaseQty().multiply(yield).divide(new BigDecimal("100"), prdInfo.getBaseUnit().getQtyPrecision(), 4);
            prdInfo.setExpectOutputQty(outputQty);
            prdInfo.setBaseExpectOutputQty(baseOutputQty);
        }
        return prdInfo;
    }

    private BOTRelationInfo buildBOTRelation(Context ctx, SCMBillBaseInfo srcBill, SCMBillBaseInfo destBill) {
        BOTRelationInfo relation = new BOTRelationInfo();
        relation.setId(BOSUuid.create((BOSObjectType)new BOTRelationInfo().getBOSType()));
        relation.setSrcEntityID(srcBill.getBOSType().toString());
        relation.setSrcObjectID(srcBill.getId().toString());
        relation.setDestEntityID(destBill.getBOSType().toString());
        relation.setDestObjectID(destBill.getId().toString());
        relation.setDate(new Date());
        relation.setOperatorID(ctx.getUserName());
        relation.setIsEffected(true);
        relation.setType(0);
        return relation;
    }

    @Override
    protected void _writeBackReworkRepairQty(Context ctx, List idList, boolean flag) throws BOSException, EASBizException {
        EntityViewInfo env = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("sourceBillType.id");
        sic.add("material.*");
        sic.add("material.baseUnit.*");
        sic.add("materialPlan.id");
        sic.add("materialPlan.rcvInLowLimit");
        env.setSelector(sic);
        HashSet<String> hs = new HashSet<String>();
        for (int i = 0; i < idList.size(); ++i) {
            hs.add(idList.get(i).toString());
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", hs, CompareType.INCLUDE));
        env.setFilter(filter);
        ProductionOrderCollection prdColls = ProductionOrderFactory.getLocalInstance(ctx).getProductionOrderCollection(env);
        ProductionOrderInfo prdInfo = null;
        ArrayList<String> prdIdList = new ArrayList<String>();
        for (int i = 0; i < prdColls.size(); ++i) {
            prdInfo = prdColls.get(i);
            if (prdInfo.getMmBizType().getValue() != 20 && prdInfo.getMmBizType().getValue() != 30 || prdInfo.getSourceBillType() == null || prdInfo.getSourceBillType().getId() == null || !prdInfo.getSourceBillType().getId().toString().equals("e3soUQaBR8un8D2R7UpNwkY+1VI=")) continue;
            FinishedRptTypeEnum finishedType = prdInfo.getFinishedType();
            if (!finishedType.equals((Object)FinishedRptTypeEnum.ENTRY)) {
                if (!finishedType.equals((Object)FinishedRptTypeEnum.CHECKENTRY)) continue;
            }
            int status = 0;
            int billStatus = 4;
            BigDecimal qty = new BigDecimal("0");
            BigDecimal baseQty = new BigDecimal("0");
            baseQty = flag ? prdInfo.getBaseQty() : prdInfo.getBaseQty().negate();
            FinishedRptEntryInfo entryInfo = null;
            String sql = "";
            if (finishedType.equals((Object)FinishedRptTypeEnum.ENTRY)) {
                sic = this.getEntrySelector();
                entryInfo = (FinishedRptEntryInfo)FinishedRptEntryFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(prdInfo.getSourceBillEntry()), sic);
                qty = SCMUtils.getExchangePrecisionQtyForServer((Context)ctx, (String)entryInfo.getMaterial().getId().toString(), (MeasureUnitInfo)entryInfo.getBaseUnit(), (MeasureUnitInfo)entryInfo.getUnit(), (BigDecimal)baseQty);
            } else if (finishedType.equals((Object)FinishedRptTypeEnum.CHECKENTRY)) {
                sic = this.getCheckEntrySelector();
                FinishedRptCRInfo crInfo = (FinishedRptCRInfo)FinishedRptCRFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(prdInfo.getSourceBillEntry()), sic);
                entryInfo = crInfo.getParent();
                qty = SCMUtils.getExchangePrecisionQtyForServer((Context)ctx, (String)crInfo.getMaterial().getId().toString(), (MeasureUnitInfo)crInfo.getMaterial().getBaseUnit(), (MeasureUnitInfo)crInfo.getUnit(), (BigDecimal)baseQty);
                if (prdInfo.getMmBizType().equals((Object)BizTypeEnum.rework)) {
                    sql = "update t_mm_finishedrptcr set FTotalReportQty = FTotalReportQty+?,FBaseTotalReportQty = FBaseTotalReportQty+? where fid = ?";
                    DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{qty, baseQty, prdInfo.getSourceBillEntry()});
                } else if (prdInfo.getMmBizType().equals((Object)BizTypeEnum.repair)) {
                    sql = "update t_mm_finishedrptcr set FTotalReportQty = FTotalReportQty+?,FBaseTotalReportQty = FBaseTotalReportQty+? where fid = ?";
                    DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{qty, baseQty, prdInfo.getSourceBillEntry()});
                }
                if (!entryInfo.getMaterial().getId().equals((Object)crInfo.getMaterial().getId())) continue;
            }
            if (flag) {
                BigDecimal needBaseQty = new BigDecimal("0");
                BigDecimal actualBaseQty = new BigDecimal("0");
                if (prdInfo.getMmBizType().equals((Object)BizTypeEnum.rework)) {
                    needBaseQty = entryInfo.getBaseTotalReworkQty();
                    actualBaseQty = entryInfo.getBaseReworkRptTotalQty().add(baseQty);
                } else if (prdInfo.getMmBizType().equals((Object)BizTypeEnum.repair)) {
                    needBaseQty = entryInfo.getBaseTotalRepairQty();
                    actualBaseQty = entryInfo.getBaseRepairRptTotalQty().add(baseQty);
                }
                if (needBaseQty.subtract(actualBaseQty).doubleValue() < 0.0) {
                    String errorStr = "";
                    errorStr = prdInfo.getMmBizType().equals((Object)BizTypeEnum.rework) ? FinishedRptUtil.getResource("reworkEroor", ctx) : FinishedRptUtil.getResource("repairError", ctx);
                    ActionCommonException bizExp = new ActionCommonException(null);
                    bizExp.setMessage(errorStr.toString());
                    throw bizExp;
                }
            }
            BigDecimal lowLimit = new BigDecimal("0");
            if (prdInfo.getMaterialPlan().getRcvInLowLimit() != null) {
                lowLimit = prdInfo.getMaterialPlan().getRcvInLowLimit().divide(new BigDecimal("100"), 4);
            }
            if (this.isEntryComplete(baseQty, entryInfo, lowLimit)) {
                status = 8;
            }
            qty = SCMUtils.getExchangePrecisionQtyForServer((Context)ctx, (String)entryInfo.getMaterial().getId().toString(), (MeasureUnitInfo)entryInfo.getBaseUnit(), (MeasureUnitInfo)entryInfo.getUnit(), (BigDecimal)baseQty);
            if (prdInfo.getMmBizType().equals((Object)BizTypeEnum.rework)) {
                sql = "update t_mm_finishedrptentry set FReworkRptTotalQty = FReworkRptTotalQty+?,FBaseReworkRptTotalQty = FBaseReworkRptTotalQty+?,FStatus = ? where fid = ?";
            } else if (prdInfo.getMmBizType().equals((Object)BizTypeEnum.repair)) {
                sql = "update t_mm_finishedrptentry set FRepairRptTotalQty = FRepairRptTotalQty+?,FBaseRepairRptTotalQty = FBaseRepairRptTotalQty+?,FStatus = ? where fid = ?";
            }
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{qty, baseQty, new Integer(status), entryInfo.getId().toString()});
            billStatus = this.getBillStatus(ctx, entryInfo.getParent().getId().toString());
            sql = "update t_mm_finishedrpt set FBaseStatus = ? where fid = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(billStatus), entryInfo.getParent().getId().toString()});
            if (entryInfo.getOutputType().getValue() == 10710) {
                BigDecimal baseReworkQty = new BigDecimal("0");
                BigDecimal reworkQty = new BigDecimal("0");
                BigDecimal baseRepairQty = new BigDecimal("0");
                BigDecimal repairQty = new BigDecimal("0");
                if (prdInfo.getMmBizType().equals((Object)BizTypeEnum.rework)) {
                    baseReworkQty = baseQty;
                    reworkQty = SCMUtils.getExchangeQtyForServer((Context)ctx, (String)prdInfo.getMaterial().getId().toString(), (MeasureUnitInfo)prdInfo.getBaseUnit(), (MeasureUnitInfo)entryInfo.getParent().getProductionOrder().getUnit(), (BigDecimal)baseQty);
                } else {
                    baseRepairQty = baseQty;
                    repairQty = SCMUtils.getExchangeQtyForServer((Context)ctx, (String)prdInfo.getMaterial().getId().toString(), (MeasureUnitInfo)prdInfo.getBaseUnit(), (MeasureUnitInfo)entryInfo.getParent().getProductionOrder().getUnit(), (BigDecimal)baseQty);
                }
                sql = "update t_mm_productionorder set FTotalRepairQty = FTotalRepairQty+?,FBaseTotalRepairQty = FBaseTotalRepairQty+?,FTotalReworkQty = FTotalReworkQty+?,FBaseTotalReworkQty = FBaseTotalReworkQty+? where fid = ?";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{repairQty, baseRepairQty, reworkQty, baseReworkQty, entryInfo.getParent().getProductionOrder().getId().toString()});
            }
            prdIdList.add(entryInfo.getParent().getProductionOrder().getId().toString());
        }
        if (prdIdList.size() > 0) {
            ProductionOrderFacadeFactory.getLocalInstance(ctx).dealAutoFinished(prdIdList, flag);
        }
    }

    public boolean isEntryComplete(BigDecimal baseQty, FinishedRptEntryInfo entryInfo, BigDecimal lowLimit) {
        BigDecimal comp;
        BigDecimal temp = entryInfo.getBaseStockTotalQty().add(entryInfo.getBaseRejectStockTotalQty()).add(entryInfo.getBaseReworkRptTotalQty()).add(entryInfo.getBaseRepairRptTotalQty()).add(entryInfo.getBaseTotalReversePreQty()).add(baseQty);
        if (lowLimit == null) {
            lowLimit = new BigDecimal("0");
        }
        return temp.subtract(comp = entryInfo.getBaseCommtQty().multiply(new BigDecimal("1").subtract(lowLimit))).doubleValue() >= 0.0;
    }

    public boolean isBillFinished(Context ctx, String billId) throws BOSException {
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("status");
        filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)billId, CompareType.EQUALS));
        EntityViewInfo env = new EntityViewInfo();
        env.setFilter(filter);
        env.setSelector(sic);
        FinishedRptEntryCollection entryCollection = FinishedRptEntryFactory.getLocalInstance(ctx).getFinishedRptEntryCollection(env);
        for (int i = 0; i < entryCollection.size(); ++i) {
            if (entryCollection.get(i).getStatus().getValue() == 8) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void _dealUrgentRelease(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FinishedRptInfo info = (FinishedRptInfo)model;
        ArrayList<String> sqlList = new ArrayList<String>();
        for (int i = 0; i < info.getEntrys().size(); ++i) {
            StringBuffer sqlStr = new StringBuffer("update t_mm_finishedrptentry set FUrgentRelease = ");
            if (info.getEntrys().get(i).isUrgentRelease()) {
                EntityViewInfo env = new EntityViewInfo();
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add("*");
                sic.add("checkEntry.*");
                env.setSelector(sic);
                FinishedRptEntryInfo entryInfo = (FinishedRptEntryInfo)FinishedRptEntryFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(info.getEntrys().get(i).getId().toString()));
                FinishedRptCRCollection colls = entryInfo.getCheckEntry();
                for (int j = 0; j < colls.size(); ++j) {
                    FinishedRptCRInfo checkInfo = colls.get(j);
                    checkInfo.setParent(entryInfo);
                    boolean flag = this.isHasDownerBill(ctx, checkInfo);
                    if (!flag) continue;
                    ActionCommonException bizExp = new ActionCommonException(null);
                    bizExp.setMessage(FinishedRptUtil.getResource("noUrgentReleaseByCR", ctx));
                    throw bizExp;
                }
                sqlStr.append(1);
            } else {
                sqlStr.append(0);
            }
            sqlStr.append(", ftotalPassQty = fcommitQty, fbaseTotalPassQty = fbaseCommtQty where fid = '" + info.getEntrys().get(i).getId().toString() + "'");
            sqlList.add(sqlStr.toString());
        }
        DBBatchUtil.executeBatch((Context)ctx, sqlList);
    }

    protected boolean isSameNumber(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        FinishedRptInfo info = (FinishedRptInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)info.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (info.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)info.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (info.getCU() != null) {
            filterItem = new FilterItemInfo("CU", (Object)info.getCU().getId().toString(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        } else {
            filterItem = new FilterItemInfo("CU", null, CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (info.getStorageOrgUnit() != null) {
            filterItem = new FilterItemInfo("storageOrgUnit.id", (Object)info.getStorageOrgUnit().getId().toString(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (this.getBindingProperty(ctx) != null && this.getBindingProperty(ctx).trim().length() > 0 && info.get(this.getBindingProperty(ctx)) != null) {
            filterItem = new FilterItemInfo(this.getBindingProperty(ctx), this.getBindingPropertyValue(info), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        }
        return super._exists(ctx, filter);
    }

    @Override
    protected void _makeManuRecBill(Context ctx, IObjectCollection srcObjs, boolean isFinished) throws BOSException, EASBizException {
        ITransactionType ty = TransactionTypeFactory.getLocalInstance((Context)ctx);
        EntityViewInfo env = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("number");
        env.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)"503", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)"504", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)"505", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)"506", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)"024", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)"025", CompareType.EQUALS));
        filter.setMaskString("#0 or #1 or #2 or #3 or #4 or #5");
        env.setFilter(filter);
        TransactionTypeCollection tyColls = ty.getTransactionTypeCollection(env);
        HashMap<String, TransactionTypeInfo> map = new HashMap<String, TransactionTypeInfo>();
        for (int i = 0; i < tyColls.size(); ++i) {
            map.put(tyColls.get(i).getNumber(), tyColls.get(i));
        }
        FinishedRptCollection finishedColls = (FinishedRptCollection)srcObjs;
        String bot_id = "";
        String bot_number = "";
        env = new EntityViewInfo();
        env.getSelector().add("id");
        filter = new FilterInfo();
        bot_number = isFinished ? "MM_PMES001" : "MM_PMES003";
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)bot_number, CompareType.EQUALS));
        env.setFilter(filter);
        BOTMappingCollection botColls = BOTMappingFactory.getLocalInstance((Context)ctx).getBOTMappingCollection(env);
        if (botColls.size() > 0) {
            bot_id = botColls.get(0).getId().toString();
        }
        CoreBillBaseCollection colls = new CoreBillBaseCollection();
        if (isFinished) {
            FinishedRptInfo info = null;
            FinishedRptCollection passColls = (FinishedRptCollection)((Object)finishedColls.clone());
            for (int i = 0; i < passColls.size(); ++i) {
                info = passColls.get(i);
                FinishedRptInfo cloneInfo = (FinishedRptInfo)info.clone();
                for (int j = cloneInfo.getEntrys().size() - 1; j >= 0; --j) {
                    FinishedRptEntryInfo entryInfo = cloneInfo.getEntrys().get(j);
                    if (entryInfo.getPassBillingQty() == null || entryInfo.getPassBillingQty().doubleValue() <= 0.0) {
                        cloneInfo.getEntrys().removeObject(j);
                        continue;
                    }
                    entryInfo.setBillingQty(entryInfo.getPassBillingQty());
                    BigDecimal baseQty = SCMUtils.getExchangeQtyForServer((Context)ctx, (String)entryInfo.getMaterial().getId().toString(), (MeasureUnitInfo)entryInfo.getUnit(), (MeasureUnitInfo)entryInfo.getBaseUnit(), (BigDecimal)entryInfo.getPassBillingQty());
                    entryInfo.setBaseBillingQty(baseQty);
                    if (map.get("024") != null) {
                        entryInfo.setTransactionType((TransactionTypeInfo)map.get("024"));
                        continue;
                    }
                    entryInfo.setTransactionType((TransactionTypeInfo)map.get("503"));
                }
                if (map.get("024") != null) {
                    cloneInfo.setWarehousingType((TransactionTypeInfo)map.get("024"));
                } else {
                    cloneInfo.setWarehousingType((TransactionTypeInfo)map.get("503"));
                }
                if (cloneInfo.getEntrys().size() <= 0) continue;
                colls.add((CoreBillBaseInfo)cloneInfo);
            }
            if (colls.size() > 0) {
                this.makeManuRecBillByBotp(ctx, colls, bot_id);
            }
            colls = new CoreBillBaseCollection();
            FinishedRptCollection unPassColls = (FinishedRptCollection)((Object)finishedColls.clone());
            for (int i = 0; i < unPassColls.size(); ++i) {
                info = unPassColls.get(i);
                FinishedRptInfo cloneInfo = (FinishedRptInfo)info.clone();
                for (int j = cloneInfo.getEntrys().size() - 1; j >= 0; --j) {
                    FinishedRptEntryInfo entryInfo = cloneInfo.getEntrys().get(j);
                    if (entryInfo.getUnPassBillingQty() == null || entryInfo.getUnPassBillingQty().doubleValue() <= 0.0) {
                        cloneInfo.getEntrys().removeObject(j);
                        continue;
                    }
                    entryInfo.setBillingQty(entryInfo.getUnPassBillingQty());
                    BigDecimal baseQty = SCMUtils.getExchangeQtyForServer((Context)ctx, (String)entryInfo.getMaterial().getId().toString(), (MeasureUnitInfo)entryInfo.getUnit(), (MeasureUnitInfo)entryInfo.getBaseUnit(), (BigDecimal)entryInfo.getUnPassBillingQty());
                    entryInfo.setBaseBillingQty(baseQty);
                    entryInfo.setWarehouse(entryInfo.getUnPassWarehouse());
                    if (map.get("025") != null) {
                        entryInfo.setTransactionType((TransactionTypeInfo)map.get("025"));
                        continue;
                    }
                    entryInfo.setTransactionType((TransactionTypeInfo)map.get("504"));
                }
                if (map.get("025") != null) {
                    cloneInfo.setWarehousingType((TransactionTypeInfo)map.get("025"));
                } else {
                    cloneInfo.setWarehousingType((TransactionTypeInfo)map.get("504"));
                }
                if (cloneInfo.getEntrys().size() <= 0) continue;
                colls.add((CoreBillBaseInfo)cloneInfo);
            }
            if (colls.size() > 0) {
                this.makeManuRecBillByBotp(ctx, colls, bot_id);
            }
        } else {
            FinishedRptInfo info = null;
            for (int i = 0; i < finishedColls.size(); ++i) {
                info = finishedColls.get(i);
                FinishedRptInfo cloneInfo = (FinishedRptInfo)info.clone();
                for (int j = cloneInfo.getEntrys().size() - 1; j >= 0; --j) {
                    FinishedRptEntryInfo entryInfo = cloneInfo.getEntrys().get(j);
                    for (int k = entryInfo.getCheckEntry().size() - 1; k >= 0; --k) {
                        FinishedRptCRInfo checkInfo = entryInfo.getCheckEntry().get(k);
                        if (checkInfo == null || checkInfo.getBillingQty().doubleValue() <= 0.0) {
                            entryInfo.getCheckEntry().removeObject(k);
                            continue;
                        }
                        BigDecimal billingQty = checkInfo.getBillingQty();
                        BigDecimal baseBillingqty = SCMUtils.getExchangeQtyForServer((Context)ctx, (String)checkInfo.getMaterial().getId().toString(), (MeasureUnitInfo)checkInfo.getUnit(), (MeasureUnitInfo)checkInfo.getMaterial().getBaseUnit(), (BigDecimal)billingQty);
                        checkInfo.setBaseBillingQty(baseBillingqty);
                        if (checkInfo.getCheckResult().getValue() == 2) {
                            if (map.get("024") != null) {
                                checkInfo.setTransactionType((TransactionTypeInfo)map.get("024"));
                                continue;
                            }
                            checkInfo.setTransactionType((TransactionTypeInfo)map.get("505"));
                            continue;
                        }
                        if (map.get("025") != null) {
                            checkInfo.setTransactionType((TransactionTypeInfo)map.get("025"));
                            continue;
                        }
                        checkInfo.setTransactionType((TransactionTypeInfo)map.get("506"));
                    }
                    if (entryInfo.getCheckEntry().size() > 0) continue;
                    cloneInfo.getEntrys().removeObject(j);
                }
                if (cloneInfo.getEntrys().size() > 0) {
                    colls.add((CoreBillBaseInfo)cloneInfo);
                }
                if (colls.size() <= 0) continue;
                this.makeManuRecBillByBotp(ctx, colls, bot_id);
            }
        }
    }

    private void makeManuRecBillByBotp(Context ctx, CoreBillBaseCollection colls, String bot_id) throws BOSException, EASBizException {
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        BOSObjectType bosType = new ManufactureRecBillInfo().getBOSType();
        iBTPManager.transformForBotp(colls, bosType.toString(), (IObjectPK)new ObjectUuidPK(bot_id));
    }

    @Override
    protected void _writeBackDirectDisQty(Context ctx, List idList, boolean flag) throws BOSException, EASBizException {
        String currId = null;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("entrys.*");
        sic.add("entrys.material.*");
        sic.add("entrys.unit.*");
        HashSet<String> hs = new HashSet<String>();
        for (int i = 0; i < idList.size(); ++i) {
            currId = idList.get(i).toString();
            hs.add(currId);
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", hs, CompareType.INCLUDE));
        EntityViewInfo env = new EntityViewInfo();
        env.setSelector(sic);
        env.setFilter(filter);
        DDMReceivalBillCollection colls = DDMReceivalBillFactory.getLocalInstance(ctx).getDDMReceivalBillCollection(env);
        DDMReceivalBillInfo info = null;
        DDMReceivalBillEntryCollection entryColl = null;
        DDMReceivalBillEntryInfo entryInfo = null;
        ArrayList<String> prdIdList = new ArrayList<String>();
        for (int i = 0; i < colls.size(); ++i) {
            info = colls.get(i);
            if (info.getSourceType().getValue() == 10) continue;
            AbstractFinishedRptEntryInfo fEntryInfo = null;
            entryColl = info.getEntrys();
            for (int j = 0; j < entryColl.size(); ++j) {
                entryInfo = entryColl.get(j);
                BigDecimal qty = new BigDecimal("0");
                BigDecimal baseQty = new BigDecimal("0");
                baseQty = flag ? entryInfo.getBaseReceiveQty() : entryInfo.getBaseReceiveQty().negate();
                if (info.getSourceType().getValue() == 30) {
                    sic = this.getCheckEntrySelector();
                    FinishedRptCRInfo checkInfo = (FinishedRptCRInfo)FinishedRptCRFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(entryInfo.getFinishedRptCR().getId().toString()), sic);
                    qty = SCMUtils.getExchangeQtyForServer((Context)ctx, (String)checkInfo.getMaterial().getId().toString(), (MeasureUnitInfo)checkInfo.getMaterial().getBaseUnit(), (MeasureUnitInfo)checkInfo.getUnit(), (BigDecimal)baseQty);
                    StringBuffer checkSql = new StringBuffer("update t_mm_finishedrptcr set FTotalReportQty =FTotalReportQty+");
                    checkSql.append(qty);
                    checkSql.append(",FBaseTotalReportQty=FBaseTotalReportQty+");
                    checkSql.append(baseQty);
                    checkSql.append("where fid = '" + entryInfo.getFinishedRptCR().getId().toString() + "'");
                    DbUtil.execute((Context)ctx, (String)checkSql.toString());
                    if (!checkInfo.getMaterial().getId().toString().equals(checkInfo.getParent().getMaterial().getId().toString())) continue;
                    fEntryInfo = checkInfo.getParent();
                } else {
                    sic = this.getEntrySelector();
                    fEntryInfo = (FinishedRptEntryInfo)FinishedRptEntryFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(entryInfo.getFinishedRptEntry().getId().toString()), sic);
                }
                qty = SCMUtils.getExchangeQtyForServer((Context)ctx, (String)fEntryInfo.getMaterial().getId().toString(), (MeasureUnitInfo)fEntryInfo.getMaterial().getBaseUnit(), (MeasureUnitInfo)fEntryInfo.getUnit(), (BigDecimal)baseQty);
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)fEntryInfo.getMaterial().getId().toString(), CompareType.EQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)fEntryInfo.getParent().getStorageOrgUnit().getId().toString(), CompareType.EQUALS));
                EntityViewInfo viewer = new EntityViewInfo();
                viewer.setFilter(filterInfo);
                MaterialPlanCollection mpColls = MaterialPlanFactory.getLocalInstance((Context)ctx).getMaterialPlanCollection(viewer);
                if (colls.size() <= 0) {
                    return;
                }
                MaterialPlanInfo mpInfo = mpColls.get(0);
                if (flag) {
                    BigDecimal highLimit = new BigDecimal("0");
                    if (mpInfo.getRcvInHightLimit() != null) {
                        highLimit = mpInfo.getRcvInHightLimit().divide(new BigDecimal("100"), 4);
                    }
                    if (this.isOverLimit(baseQty, true, (FinishedRptEntryInfo)fEntryInfo, highLimit)) {
                        throw new FinishedRptException(FinishedRptException.OVERHIGHLIMIT, new Object[]{fEntryInfo.getParent().getNumber()});
                    }
                }
                int status = 0;
                int billStatus = 4;
                BigDecimal lowLimit = new BigDecimal("0");
                if (mpInfo.getRcvInLowLimit() != null) {
                    lowLimit = mpInfo.getRcvInLowLimit().divide(new BigDecimal("100"), 4);
                }
                if (this.isEntryComplete(baseQty, (FinishedRptEntryInfo)fEntryInfo, lowLimit)) {
                    status = 8;
                }
                String sql = "update t_mm_finishedrptentry set FTotalReversePreQty = FTotalReversePreQty+?,FBaseTotalReversePreQty = FBaseTotalReversePreQty+?,FStatus = ? where fid = ?";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{qty, baseQty, new Integer(status), fEntryInfo.getId().toString()});
                billStatus = this.getBillStatus(ctx, entryInfo.getSourceBillId());
                sql = "update t_mm_finishedrpt set FBaseStatus = ? where fid = ?";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(billStatus), entryInfo.getSourceBillId()});
                if (fEntryInfo.getOutputType().getValue() != 10710) continue;
                qty = SCMUtils.getExchangePrecisionQtyForServer((Context)ctx, (String)fEntryInfo.getMaterial().getId().toString(), (MeasureUnitInfo)fEntryInfo.getBaseUnit(), (MeasureUnitInfo)fEntryInfo.getParent().getProductionOrder().getUnit(), (BigDecimal)baseQty);
                sql = "update t_mm_productionorder set FTotalDDMQty = FTotalDDMQty+?,FBaseTotalDDMQty=FBaseTotalDDMQty+? where fid = ?";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{qty, baseQty, fEntryInfo.getParent().getProductionOrder().getId().toString()});
            }
            prdIdList.add(fEntryInfo.getParent().getProductionOrder().getId().toString());
        }
        ProductionOrderFacadeFactory.getLocalInstance(ctx).dealAutoFinished(prdIdList, flag);
    }

    protected boolean isOverLimit(BigDecimal baseQty, boolean isPass, FinishedRptEntryInfo entryInfo, BigDecimal highLimit) {
        BigDecimal total = new BigDecimal("0");
        BigDecimal compare = new BigDecimal("0");
        if (isPass) {
            total = total.add(entryInfo.getBaseStockTotalQty().add(entryInfo.getBaseTotalReversePreQty())).add(baseQty);
            compare = entryInfo.isUrgentRelease() ? entryInfo.getBaseCommtQty() : entryInfo.getBaseTotalPassQty();
        } else {
            total = total.add(entryInfo.getBaseRejectStockTotalQty()).add(baseQty);
            compare = entryInfo.getBaseTotalRejectQty();
        }
        if (highLimit == null) {
            highLimit = new BigDecimal("0");
        }
        return total.subtract(compare.multiply(new BigDecimal("1").add(highLimit))).doubleValue() > 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _makeDDMReceivingBill(Context ctx, List srcObj, IObjectPK[] pks) throws BOSException, EASBizException {
        DirectDisParentVO parent = null;
        ArrayList<String> idList = new ArrayList<String>();
        Connection cn = null;
        try {
            cn = this.getConnection(ctx);
            IORMappingDAO dao = ORMappingDAO.getInstance((BOSObjectType)new DDMReceivalBillInfo().getBOSType(), (Context)ctx, (Connection)cn);
            IORMappingDAO bot_dao = ORMappingDAO.getInstance((BOSObjectType)new BOTRelationInfo().getBOSType(), (Context)ctx, (Connection)cn);
            for (int i = 0; i < srcObj.size(); ++i) {
                parent = (DirectDisParentVO)srcObj.get(i);
                BOSUuid id = BOSUuid.create((String)new DDMReceivalBillInfo().getBOSType().toString());
                DDMReceivalBillInfo ddmInfo = new DDMReceivalBillInfo();
                ddmInfo.setId(id);
                StorageOrgUnitInfo storage = new StorageOrgUnitInfo();
                storage.setId(parent.getStorage().getId());
                ddmInfo.setStorageOrgUnit(storage);
                ddmInfo.setBizDate(new Date());
                UserInfo user = new UserInfo();
                user.setId(BOSUuid.read((String)ctx.getCaller().toString()));
                ddmInfo.setCreator(user);
                ddmInfo.setCreateTime(new Timestamp(new Date().getTime()));
                ddmInfo.setCU(parent.getFinishedRpt().getCU());
                if (parent.getFinishedRptCRId() != null && !parent.getFinishedRptCRId().trim().equals("")) {
                    ddmInfo.setSourceType(DDMSourceBillTypeEnum.finishedRptCR);
                } else {
                    ddmInfo.setSourceType(DDMSourceBillTypeEnum.finishedRpt);
                }
                ddmInfo.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
                BillTypeInfo sourBillType = new BillTypeInfo();
                sourBillType.setId(BOSUuid.read((String)"e3soUQaBR8un8D2R7UpNwkY+1VI="));
                ddmInfo.setSourceBillType(sourBillType);
                BillTypeInfo billType = new BillTypeInfo();
                billType.setId(BOSUuid.read((String)"EVuaJtWZ4kKbRG9czgLdmkY+1VI="));
                ddmInfo.setBillType(billType);
                ddmInfo.setSourceBillId(parent.getFinishedRptId());
                DirectDisChildVO child = null;
                DirectDisChildVO targetChild = null;
                if (parent.getChildDirectDisVO().size() > 0) {
                    MaterialInventoryInfo inventory;
                    targetChild = (DirectDisChildVO)parent.getChildDirectDisVO().get(0);
                    int prdLineCount = 0;
                    int workShopCount = 0;
                    int classTeamCount = 0;
                    int classGroupCount = 0;
                    for (int j = 0; j < parent.getChildDirectDisVO().size(); ++j) {
                        child = (DirectDisChildVO)parent.getChildDirectDisVO().get(j);
                        if (!FinishedRptControllerBean.isDiffrent(child.getProducitonOrder().getClassGroup(), targetChild.getProducitonOrder().getClassGroup())) {
                            ++classGroupCount;
                        }
                        if (!FinishedRptControllerBean.isDiffrent(child.getProducitonOrder().getProductLine(), targetChild.getProducitonOrder().getProductLine())) {
                            ++prdLineCount;
                        }
                        if (!FinishedRptControllerBean.isDiffrent(child.getProducitonOrder().getWorkShop(), targetChild.getProducitonOrder().getWorkShop())) {
                            ++workShopCount;
                        }
                        if (FinishedRptControllerBean.isDiffrent(child.getProducitonOrder().getClassTeam(), targetChild.getProducitonOrder().getClassTeam())) continue;
                        ++classTeamCount;
                    }
                    if (workShopCount == parent.getChildDirectDisVO().size() && targetChild.getProducitonOrder().getWorkShop() != null) {
                        ddmInfo.setWorkshop(targetChild.getProducitonOrder().getWorkShop());
                    }
                    if (prdLineCount == parent.getChildDirectDisVO().size() && targetChild.getProducitonOrder().getProductLine() != null) {
                        ddmInfo.setProductLine(targetChild.getProducitonOrder().getProductLine());
                    }
                    if (classTeamCount == parent.getChildDirectDisVO().size() && targetChild.getProducitonOrder().getClassTeam() != null) {
                        ddmInfo.setClassTeam(targetChild.getProducitonOrder().getClassTeam());
                    }
                    if (classGroupCount == parent.getChildDirectDisVO().size() && targetChild.getProducitonOrder().getClassGroup() != null) {
                        ddmInfo.setClassGroup(targetChild.getProducitonOrder().getClassGroup());
                    }
                    EntityViewInfo env = new EntityViewInfo();
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add("*");
                    sic.add("defaultWarehouse.*");
                    sic.add("defaultWarehouse.whman.*");
                    env.setSelector(sic);
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)parent.getStorage().getId().toString(), CompareType.EQUALS));
                    filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)parent.getMaterial().getId().toString(), CompareType.EQUALS));
                    env.setFilter(filter);
                    MaterialInventoryCollection colls = MaterialInventoryFactory.getLocalInstance((Context)ctx).getMaterialInventoryCollection(env);
                    DDMReceivalBillEntryInfo entryInfo = new DDMReceivalBillEntryInfo();
                    BOSUuid entryId = BOSUuid.create((BOSObjectType)new DDMReceivalBillEntryInfo().getBOSType());
                    entryInfo.setId(entryId);
                    entryInfo.setSeq(1);
                    entryInfo.setMaterial(parent.getMaterial());
                    entryInfo.setUnit(parent.getUnit());
                    entryInfo.setBaseUnit(parent.getMaterial().getBaseUnit());
                    entryInfo.setSourceBillType(sourBillType);
                    entryInfo.setSourceBillId(parent.getFinishedRptId());
                    entryInfo.setSourceBillNumber(parent.getFinishedRpt().getNumber());
                    entryInfo.setTrackNumber(parent.getFinishedRpt().getTrackNumber());
                    if (parent.getFinishedRptCRId() != null && !parent.getFinishedRptCRId().trim().equals("")) {
                        entryInfo.setSourceBillEntryId(parent.getFinishedRptCRId());
                        entryInfo.setSourceBillEntrySeq(parent.getFinishedRptCR().getSeq());
                    } else {
                        entryInfo.setSourceBillEntryId(parent.getFinishedRptEntryId());
                        entryInfo.setSourceBillEntrySeq(parent.getFinishedRptEntry().getSeq());
                    }
                    entryInfo.setParent(ddmInfo);
                    entryInfo.setFinishedRpt(parent.getFinishedRpt());
                    entryInfo.setFinishedRptEntry(parent.getFinishedRptEntry());
                    if (parent.getFinishedRptCRId() != null && !parent.getFinishedRptCRId().trim().equals("")) {
                        entryInfo.setFinishedRptCR(parent.getFinishedRptCR());
                    }
                    entryInfo.setReceivableQty(parent.getCouldQty());
                    entryInfo.setBsReceivableQty(parent.getBaseCouldQty());
                    entryInfo.setReceiveQty(parent.getCurrQty());
                    entryInfo.setBaseReceiveQty(parent.getBaseCurrQty());
                    FinishedRptEntryInfo fEntryInfo = (FinishedRptEntryInfo)FinishedRptEntryFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(parent.getFinishedRptEntryId()));
                    entryInfo.setProductDate(fEntryInfo.getFinishDate());
                    entryInfo.setExpireDate(fEntryInfo.getExpDate());
                    if (colls.size() > 0) {
                        inventory = colls.get(0);
                        entryInfo.setMaterialInventory(inventory);
                    }
                    if (parent.getFinishedRptCRId() == null) {
                        entryInfo.setLotNumber(parent.getFinishedRptEntry().getLotNo());
                        entryInfo.setWarehouse(parent.getFinishedRptEntry().getWarehouse());
                        if (parent.getFinishedRptEntry().getWarehouse().getWhman() != null) {
                            entryInfo.setStocker(parent.getFinishedRptEntry().getWarehouse().getWhman());
                        }
                    } else if (parent.getFinishedRptCR().getMaterial().getId().toString().equals(parent.getFinishedRptEntry().getMaterial().getId().toString())) {
                        entryInfo.setLotNumber(parent.getFinishedRptEntry().getLotNo());
                        entryInfo.setWarehouse(parent.getFinishedRptEntry().getWarehouse());
                        if (parent.getFinishedRptEntry().getWarehouse().getWhman() != null) {
                            entryInfo.setStocker(parent.getFinishedRptEntry().getWarehouse().getWhman());
                        }
                    } else {
                        if (colls.size() > 0 && (inventory = colls.get(0)).getDefaultWarehouse() != null) {
                            entryInfo.setWarehouse(inventory.getDefaultWarehouse());
                            if (inventory.getDefaultWarehouse().getWhman() != null) {
                                entryInfo.setStocker(inventory.getDefaultWarehouse().getWhman());
                            }
                        }
                        if (parent.getMaterial().getAssistUnit() != null) {
                            BigDecimal assistQty = SCMUtils.getExchangeQtyForServer((Context)ctx, (String)parent.getMaterial().getId().toString(), (MeasureUnitInfo)parent.getMaterial().getBaseUnit(), (MeasureUnitInfo)parent.getMaterial().getAssistUnit(), (BigDecimal)parent.getBaseCurrQty());
                            entryInfo.setAssistUnit(parent.getMaterial().getAssistUnit());
                            entryInfo.setAssistQty(assistQty);
                        }
                    }
                    ddmInfo.getEntrys().add(entryInfo);
                    ArrayList<String> prdIdList = new ArrayList<String>();
                    for (int j = 0; j < parent.getChildDirectDisVO().size(); ++j) {
                        child = (DirectDisChildVO)parent.getChildDirectDisVO().get(j);
                        if (!child.isSubmitBotp() || child.getCurrQty().doubleValue() <= 0.0) continue;
                        DDMReceivalBillEntryTargetEntryInfo tEntryInfo = new DDMReceivalBillEntryTargetEntryInfo();
                        tEntryInfo.setId(BOSUuid.create((String)new DDMReceivalBillEntryTargetEntryInfo().getBOSType().toString()));
                        tEntryInfo.setSeq(j + 1);
                        tEntryInfo.setParent1(entryInfo);
                        tEntryInfo.setProductionOrder(child.getProducitonOrder());
                        tEntryInfo.setLineSeq(child.getStockInfo().getLineSeq());
                        tEntryInfo.setUnit(child.getUnit());
                        tEntryInfo.setBaseUnit(parent.getMaterial().getBaseUnit());
                        tEntryInfo.setStockEntry(child.getStockInfo());
                        tEntryInfo.setReceivableQty(child.getCouldQty());
                        tEntryInfo.setBaseReceiveQty(child.getBaseCouldQty());
                        tEntryInfo.setReceiveQty(child.getCurrQty());
                        tEntryInfo.setBaseReceiveQty(child.getBaseCurrQty());
                        tEntryInfo.setStartDate(child.getStockInfo().getStartDate());
                        tEntryInfo.setEndDate(child.getStockInfo().getEndDate());
                        entryInfo.getTargetEntry().add(tEntryInfo);
                        if (!prdIdList.contains(child.getProducitonOrder().getId().toString())) {
                            BOTRelationInfo relation = this.buildBOTRelation(ctx, child.getProducitonOrder(), ddmInfo);
                            bot_dao.addNewBatch((IObjectValue)relation);
                        }
                        prdIdList.add(child.getProducitonOrder().getId().toString());
                    }
                }
                BOTRelationInfo relation = this.buildBOTRelation(ctx, parent.getFinishedRpt(), ddmInfo);
                bot_dao.addNewBatch((IObjectValue)relation);
                idList.add(id.toString());
                dao.addNewBatch((IObjectValue)ddmInfo);
            }
            dao.executeBatch();
            bot_dao.executeBatch();
            StringBuffer numberSQL = new StringBuffer();
            numberSQL.append("select p.fid as fid ,p.fstorageorgunitid as fstorageorgunitid from T_MM_DDMReceivalBill p where p.fnumber is null and p.fid in (");
            for (int i = 0; i < idList.size(); ++i) {
                if (i != 0) {
                    numberSQL.append(",");
                }
                numberSQL.append("'" + idList.get(i).toString() + "'");
            }
            numberSQL.append(")");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)numberSQL.toString());
            ArrayList<String> updateList = new ArrayList<String>();
            try {
                ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
                while (rowSet.next()) {
                    String id = rowSet.getString("fid");
                    String orgUnit = rowSet.getString("fstorageorgunitid");
                    DDMReceivalBillInfo bill = new DDMReceivalBillInfo();
                    bill.setBizDate(new Date());
                    if (!codingRuleManager.isExist((IObjectValue)bill, orgUnit)) continue;
                    String number = codingRuleManager.getNumber((IObjectValue)bill, orgUnit);
                    String updateNumberSQL = "update T_MM_DDMReceivalBill set fnumber = '" + number + "' where fid = '" + id + "'";
                    updateList.add(updateNumberSQL);
                }
                if (updateList.size() > 0) {
                    DBBatchUtil.executeBatch((Context)ctx, updateList);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    @Override
    protected void _canDeleteResult(Context ctx, IObjectCollection qcReturnColls) throws BOSException, EASBizException {
        QCReturnResultInfo info = null;
        for (int i = 0; i < qcReturnColls.size(); ++i) {
            boolean flag;
            info = (QCReturnResultInfo)qcReturnColls.getObject(i);
            EntityViewInfo env = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("*");
            sic.add("parent.id");
            sic.add("parent.parent.id");
            env.setSelector(sic);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)info.getBillEntryID(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("sourceBillEntryID", (Object)info.getSourceBillEntryID(), CompareType.EQUALS));
            env.setFilter(filter);
            FinishedRptCRCollection colls = FinishedRptCRFactory.getLocalInstance(ctx).getFinishedRptCRCollection(env);
            FinishedRptCRInfo checkInfo = null;
            if (colls.size() <= 0 || !(flag = this.isHasDownerBill(ctx, checkInfo = colls.get(0)))) continue;
            ActionCommonException bizExp = new ActionCommonException(null);
            bizExp.setMessage(FinishedRptUtil.getResource("deleteResultFail", ctx));
            throw bizExp;
        }
    }

    private boolean isHasDownerBill(Context ctx, FinishedRptCRInfo checkInfo) throws BOSException, EASBizException {
        boolean flag1 = false;
        boolean flag2 = false;
        boolean flag3 = false;
        EntityViewInfo env = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("checkResult");
        sic.add("parent.parent.id");
        env.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        env.setFilter(filter);
        if (checkInfo.getCheckResult().getValue() == 4 || checkInfo.getCheckResult().getValue() == 5) {
            env = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("sourceBillEntry", (Object)checkInfo.getId().toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("finishedType", (Object)new Integer(20), CompareType.EQUALS));
            env.setFilter(filter);
            ProductionOrderCollection finishedColls = ProductionOrderFactory.getLocalInstance(ctx).getProductionOrderCollection(env);
            if (finishedColls.size() > 0) {
                flag1 = true;
            }
        } else {
            env = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)checkInfo.getParent().getParent().getId().toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("sourceBillEntryId", (Object)checkInfo.getId().toString(), CompareType.EQUALS));
            env.setFilter(filter);
            ManufactureRecBillEntryCollection manuBills = ManufactureRecBillEntryFactory.getLocalInstance((Context)ctx).getManufactureRecBillEntryCollection(env);
            if (manuBills.size() > 0) {
                flag2 = true;
            }
            if (checkInfo.getCheckResult().getValue() == 2) {
                env = new EntityViewInfo();
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("finishedRpt", (Object)checkInfo.getParent().getParent().getId().toString(), CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("finishedRptCR", (Object)checkInfo.getId().toString(), CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("parent.sourceType", (Object)new Integer(30), CompareType.EQUALS));
                env.setFilter(filter);
                DDMReceivalBillEntryCollection ddmColls = DDMReceivalBillEntryFactory.getLocalInstance(ctx).getDDMReceivalBillEntryCollection(env);
                if (ddmColls.size() > 0) {
                    flag3 = true;
                }
            }
        }
        return flag1 || flag2 || flag3;
    }

    protected SelectorItemCollection getEntrySelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("material.*");
        sic.add("material.baseUnit.*");
        sic.add("sourceBillType.id");
        sic.add("parent.id");
        sic.add("parent.number");
        sic.add("parent.productionOrder.*");
        sic.add("unit.*");
        sic.add("parent.storageOrgUnit.id");
        sic.add("parent.productionOrder.unit.*");
        return sic;
    }

    protected SelectorItemCollection getCheckEntrySelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("material.*");
        sic.add("material.baseUnit.*");
        sic.add("unit.*");
        sic.add("parent.id");
        sic.add("parent.reworkRptTotalQty");
        sic.add("parent.repairRptTotalQty");
        sic.add("parent.outputType");
        sic.add("parent.commitQty");
        sic.add("parent.baseCommtQty");
        sic.add("parent.material.*");
        sic.add("parent.material.baseUnit.*");
        sic.add("parent.baseStockTotalQty");
        sic.add("parent.baseTotalReversePreQty");
        sic.add("parent.baseRejectStockTotalQty");
        sic.add("parent.baseRepairRptTotalQty");
        sic.add("parent.baseReworkRptTotalQty");
        sic.add("parent.baseTotalPassQty");
        sic.add("parent.baseTotalRejectQty");
        sic.add("parent.baseTotalReworkQty");
        sic.add("parent.baseTotalRepairQty");
        sic.add("parent.baseUnit");
        sic.add("parent.material.*");
        sic.add("parent.unit.*");
        sic.add("parent.parent.id");
        sic.add("parent.parent.number");
        sic.add("parent.parent.productionOrder.*");
        sic.add("parent.parent.productionOrder.unit.*");
        sic.add("parent.parent.storageOrgUnit.id");
        return sic;
    }

    @Override
    protected void _materialReqReWrite(Context ctx, String tempTableName, BizActionEnum bizAction) throws BOSException, EASBizException {
        if (bizAction.getValue() == 109) {
            StringBuffer sb = new StringBuffer();
            sb.append("select top 1 FID from T_IM_MaterialReqBill ").append("where FIsBackflush = 1 and FID in (select FBillID from ").append(tempTableName).append(") ");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            try {
                if (rs != null && rs.next()) {
                    throw new FinishedRptException(FinishedRptException.MATERIALREQBILLNOTAUDIT);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    @Override
    protected void _unBackFlush(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.checkBackFlushRecord(ctx, pk);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("entrys.*");
        sic.add("entrys.material.*");
        sic.add("entrys.unit.*");
        sic.add("entrys.baseUnit.*");
        sic.add("productionOrder.*");
        sic.add("productionOrder.stockEntry.*");
        sic.add("productionOrder.stockEntry.material.*");
        sic.add("productionOrder.stockEntry.material.unit.*");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)pk.getKeyValue(null).toString(), CompareType.EQUALS));
        EntityViewInfo env = new EntityViewInfo();
        env.setFilter(filter);
        env.setSelector(sic);
        FinishedRptCollection finiColl = FinishedRptFactory.getLocalInstance(ctx).getFinishedRptCollection(env);
        StringBuffer errBuffer = new StringBuffer();
        for (int i = 0; i < finiColl.size(); ++i) {
            if (finiColl.get(i).getBaseStatus().getValue() != 4 && finiColl.get(i).getBaseStatus().getValue() != 90) {
                errBuffer.append(FinishedRptUtil.getResource("UnBackFlushErr", ctx));
                continue;
            }
            if (!finiColl.get(i).isIsBackFlushed()) {
                errBuffer.append(FinishedRptUtil.getResource("UnBackFlushErr2", ctx));
                continue;
            }
            if (finiColl.get(i).getProductionOrder().getBaseStatus() != BillBaseStatusEnum.CLOSED) continue;
            errBuffer.append(FinishedRptUtil.getResource("UnBackFlushErr3", ctx));
        }
        if (errBuffer.length() > 0) {
            throw new FinishedRptException(FinishedRptException.UNBACKFLUSHERR, new String[]{errBuffer.toString()});
        }
        FinishedRptFacadeFactory.getLocalInstance(ctx).unBackFlush((IObjectCollection)finiColl);
    }

    private void checkBackFlushRecord(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        String sql = "select count(1) iCount from t_mm_BackFlushRecord where fsrcBillId = ?";
        Object[] params = new Object[]{pk.toString()};
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
        try {
            while (rows.next()) {
                if (rows.getInt("iCount") <= 0) continue;
                throw new MMCommonException(MMCommonException.BLANK, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.mm.control.CONTROLAutoGenerateResource", (String)"26_FinishedRptControllerBean", (Locale)ctx.getLocale())});
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _finishedRptBackFlushed(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ProductionOrderStockEntryInfo sEntryInfo;
        FinishedRptCollection finishedColls = new FinishedRptCollection();
        String finishedRptId = pk.getKeyValue(null).toString();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("entrys.*"));
        selector.add(new SelectorItemInfo("productionOrder.*"));
        selector.add(new SelectorItemInfo("productionOrder.productLine.*"));
        selector.add(new SelectorItemInfo("productionOrder.material.*"));
        selector.add(new SelectorItemInfo("productionOrder.unit.*"));
        selector.add(new SelectorItemInfo("productionOrder.baseUnit.*"));
        selector.add(new SelectorItemInfo("productionOrder.formula.*"));
        selector.add(new SelectorItemInfo("productionOrder.stockEntry.*"));
        selector.add(new SelectorItemInfo("productionOrder.stockEntry.material.id"));
        selector.add(new SelectorItemInfo("productionOrder.stockEntry.material.baseUnit.*"));
        selector.add(new SelectorItemInfo("productionOrder.stockEntry.material.assistUnit.*"));
        selector.add(new SelectorItemInfo("productionOrder.stockEntry.unit.*"));
        selector.add(new SelectorItemInfo("productionOrder.stockEntry.baseUnit.*"));
        selector.add(new SelectorItemInfo("productionOrder.stockEntry.defaultWarehouse.*"));
        selector.add(new SelectorItemInfo("productionOrder.stockEntry.location.*"));
        selector.add(new SelectorItemInfo("productionOrder.formula.id"));
        selector.add(new SelectorItemInfo("productionOrder.formula.productQty"));
        selector.add(new SelectorItemInfo("productionOrder.stockEntry.material.name"));
        selector.add(new SelectorItemInfo("productionOrder.trackNumber.name"));
        FinishedRptInfo finishedRptInfo = (FinishedRptInfo)this._getValue(ctx, (IObjectPK)new ObjectUuidPK(finishedRptId), selector);
        finishedColls.add(finishedRptInfo);
        StringBuffer errorStr = new StringBuffer();
        if (90 != finishedRptInfo.getBaseStatus().getValue() && 4 != finishedRptInfo.getBaseStatus().getValue()) {
            errorStr.append(FinishedRptUtil.getResource("FlushError1", ctx));
            throw new FinishedRptException(FinishedRptException.BACKFLUSHERROR, new Object[]{errorStr.toString()});
        }
        if (null == finishedRptInfo.getMasterProductId()) {
            errorStr.append(FinishedRptUtil.getResource("FlushError2", ctx));
            throw new FinishedRptException(FinishedRptException.BACKFLUSHERROR, new Object[]{errorStr.toString()});
        }
        if (finishedRptInfo.isIsBackFlushed()) {
            errorStr.append(FinishedRptUtil.getResource("FlushError4", ctx));
            throw new FinishedRptException(FinishedRptException.BACKFLUSHERROR, new Object[]{errorStr.toString()});
        }
        BigDecimal baseBackFlushTotalQty = finishedRptInfo.getProductionOrder().getBaseBackFlushTotalQty();
        if (baseBackFlushTotalQty == null) {
            baseBackFlushTotalQty = new BigDecimal(String.valueOf(0.0));
        }
        if (baseBackFlushTotalQty.doubleValue() >= finishedRptInfo.getProductionOrder().getBaseCommitTotalQty().doubleValue()) {
            errorStr.append(FinishedRptUtil.getResource("FlushError3", ctx));
            throw new FinishedRptException(FinishedRptException.BACKFLUSHERROR, new Object[]{errorStr.toString()});
        }
        ProductionOrderInfo orderInfo = finishedRptInfo.getProductionOrder();
        ProductionOrderStockEntryCollection entryColls = orderInfo.getStockEntry();
        int count = 0;
        for (int j = 0; j < entryColls.size() && !(sEntryInfo = entryColls.get(j)).isIsBackFlush(); ++j) {
            ++count;
        }
        if (count == entryColls.size()) {
            errorStr.append(FinishedRptUtil.getResource("FlushError5", ctx));
            throw new FinishedRptException(FinishedRptException.BACKFLUSHERROR, new Object[]{errorStr.toString()});
        }
        if (orderInfo.getBaseStatus() == BillBaseStatusEnum.CLOSED) {
            errorStr.append(FinishedRptUtil.getResource("FlushError6", ctx));
            throw new FinishedRptException(FinishedRptException.BACKFLUSHERROR, new Object[]{errorStr.toString()});
        }
        FinishedRptFacadeFactory.getLocalInstance(ctx).backFlush(finishedColls);
    }

    public static boolean isDiffrent(Object arg0, Object arg1) {
        boolean isChanged = false;
        if (arg0 == null && arg1 != null || arg0 != null && arg1 == null) {
            isChanged = true;
        } else if (arg0 != null && arg1 != null) {
            isChanged = arg0 instanceof CoreBaseInfo && arg1 instanceof CoreBaseInfo ? !((CoreBaseInfo)arg0).getId().toString().equals(((CoreBaseInfo)arg1).getId().toString()) : !arg0.equals(arg1);
        }
        return isChanged;
    }

    protected void setNullToDefault(Context ctx, IObjectValue model) {
        if (model == null) {
            return;
        }
        IObjectCollection entrys = (IObjectCollection)model.get("entrys");
        if (entrys == null) {
            return;
        }
        String[] entryDecimalFields = this.getEntryDecimalFields();
        if (entryDecimalFields != null) {
            int n = entrys.size();
            for (int i = 0; i < n; ++i) {
                IObjectValue entry = entrys.getObject(i);
                for (int j = 0; j < entryDecimalFields.length; ++j) {
                    if (entry.get(entryDecimalFields[j]) != null) continue;
                    entry.put(entryDecimalFields[j], (Object)DtUtils.ZERO);
                }
            }
        }
    }

    protected String[] getEntryDecimalFields() {
        return new String[]{"commitQty", "totalPassQty", "totalRejectQty", "totalReworkQty", "totalRepairQty"};
    }

    @Override
    protected void _commonCheck(Context ctx, List idList, int operationType) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("baseStatus"));
        selector.add(new SelectorItemInfo("productionOrder.baseStatus"));
        EntityViewInfo env = new EntityViewInfo();
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < idList.size(); ++i) {
            set.add(idList.get(i).toString());
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        env.setFilter(filter);
        env.setSelector(selector);
        StringBuffer errBuffer = new StringBuffer();
        StringBuffer statusBuffer = new StringBuffer();
        StringBuffer upStatusBuffer = new StringBuffer();
        FinishedRptCollection finiColl = FinishedRptFactory.getLocalInstance(ctx).getFinishedRptCollection(env);
        for (int i = 0; i < finiColl.size(); ++i) {
            if (finiColl.get(i).getBaseStatus().getValue() != 4 && finiColl.get(i).getBaseStatus().getValue() != 90) {
                statusBuffer.append(finiColl.get(i).getNumber() + ",");
            }
            if (finiColl.get(i).getProductionOrder() == null || finiColl.get(i).getProductionOrder().getBaseStatus() != BillBaseStatusEnum.CLOSED) continue;
            upStatusBuffer.append(finiColl.get(i).getNumber() + ",");
        }
        if (statusBuffer.length() > 0) {
            if (operationType == 1) {
                errBuffer.append(FinishedRptUtil.getResource("PushCreateToMsgOnListUI", new String[]{statusBuffer.replace(statusBuffer.length() - 1, statusBuffer.length(), "").toString()}, ctx));
            } else if (operationType == 2) {
                errBuffer.append(FinishedRptUtil.getResource("SelectRowDDSkCheck", new String[]{statusBuffer.replace(statusBuffer.length() - 1, statusBuffer.length(), "").toString()}, ctx));
            } else if (operationType == 3) {
                errBuffer.append(FinishedRptUtil.getResource("SelectRowReworkCheck", new String[]{statusBuffer.replace(statusBuffer.length() - 1, statusBuffer.length(), "").toString()}, ctx));
            } else if (operationType == 4) {
                errBuffer.append(FinishedRptUtil.getResource("SelectRowRepairCheck", new String[]{statusBuffer.replace(statusBuffer.length() - 1, statusBuffer.length(), "").toString()}, ctx));
            }
        }
        if (upStatusBuffer.length() > 0) {
            if (errBuffer.length() > 0) {
                errBuffer.append("\n");
            }
            if (operationType == 1) {
                errBuffer.append(FinishedRptUtil.getResource("PushCreateToMsgOnListUI2", new String[]{upStatusBuffer.replace(upStatusBuffer.length() - 1, upStatusBuffer.length(), "").toString()}, ctx));
            } else if (operationType == 2) {
                errBuffer.append(FinishedRptUtil.getResource("SelectRowDDSkCheck2", new String[]{upStatusBuffer.replace(upStatusBuffer.length() - 1, upStatusBuffer.length(), "").toString()}, ctx));
            } else if (operationType == 3) {
                errBuffer.append(FinishedRptUtil.getResource("SelectRowReworkCheck2", new String[]{upStatusBuffer.replace(upStatusBuffer.length() - 1, upStatusBuffer.length(), "").toString()}, ctx));
            } else if (operationType == 4) {
                errBuffer.append(FinishedRptUtil.getResource("SelectRowRepairCheck2", new String[]{upStatusBuffer.replace(upStatusBuffer.length() - 1, upStatusBuffer.length(), "").toString()}, ctx));
            }
        }
        if (errBuffer.length() > 0) {
            throw new FinishedRptException(FinishedRptException.BLANK, new String[]{errBuffer.toString()});
        }
    }

    @Override
    protected String _getPassTransactionTypes(Context ctx) throws BOSException {
        String transactionTypes = "024,032-A";
        return transactionTypes;
    }

    @Override
    protected String[] _excessQtyIds(Context ctx, String[] ids) throws BOSException, EASBizException {
        if (ids == null) {
            return null;
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("entrys.*"));
        selector.add(new SelectorItemInfo("productionOrder.*"));
        selector.add(new SelectorItemInfo("taskDispBill.*"));
        String[] strIds = new String[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            String finishedRptId = ids[i];
            if (StringUtils.isEmpty((String)finishedRptId)) continue;
            FinishedRptInfo finishedRpt = this.getFinishedRptInfo(ctx, (IObjectPK)new ObjectUuidPK(finishedRptId), selector);
            if (null == finishedRpt.getProductionOrder()) {
                return null;
            }
            if (!this.checkOverLimitForUpperBill(ctx, finishedRpt)) continue;
            strIds[i] = finishedRpt.getNumber();
        }
        return strIds;
    }

    public BatchExecuteResult batchExecute(Context ctx, String name, Class[] paramTypes, BatchExecuteParamsEntry[] paramEntries) throws BaseException {
        BatchExecuteResult result = super.batchExecute(ctx, name, paramTypes, paramEntries);
        if (name.equalsIgnoreCase("audit")) {
            HashSet<String> idSet = new HashSet<String>();
            int n = paramEntries.length;
            for (int i = 0; i < n; ++i) {
                if (result.getException(i) != null) continue;
                idSet.add(paramEntries[i].get(0).toString());
            }
            this.doBackFlushRun(ctx, this.filter4AutoBackFlush(ctx, idSet));
        } else if (name.equalsIgnoreCase("submitRelations")) {
            String isAutoBackFlush;
            FinishedRptInfo info = (FinishedRptInfo)paramEntries[0].get(0);
            String strAutoAudit = SCMBillParamFactory.getLocalInstance((Context)ctx).getParamByBillTypeID("SCM_Submit_01", 4, info.getStorageOrgUnit().getId().toString(), info.getBillType().getId().toString());
            boolean isAutoAudit = false;
            if (strAutoAudit != null && strAutoAudit.trim().length() != 0 && strAutoAudit.trim().toLowerCase().equals("1")) {
                isAutoAudit = true;
            }
            if (isAutoAudit && "true".equalsIgnoreCase(isAutoBackFlush = ParamManager.getParamValue((Context)ctx, (IObjectPK)new ObjectUuidPK(info.getStorageOrgUnit().getId().toString()), (String)"AutoBackFlush"))) {
                ArrayList<String> idList = new ArrayList<String>();
                idList.add(info.getId().toString());
                this.doBackFlushRun(ctx, idList);
            }
        } else if (name.equalsIgnoreCase("unAudit")) {
            ArrayList<String> idList = new ArrayList<String>();
            int n = paramEntries.length;
            for (int i = 0; i < n; ++i) {
                if (result.getException(i) != null) continue;
                idList.add(paramEntries[i].get(0).toString());
            }
            this.deleteBackFlushRecord(ctx, idList);
        }
        return result;
    }

    private List filter4AutoBackFlush(Context ctx, Set idSet) throws BOSException, EASBizException {
        ArrayList<String> idList = new ArrayList<String>();
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("storageOrgUnit.id"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSelector(sic);
        FinishedRptCollection coll = this.getFinishedRptCollection(ctx, view);
        FinishedRptInfo info = null;
        String orgUnitId = null;
        int n = coll.size();
        for (int i = 0; i < n; ++i) {
            info = coll.get(i);
            orgUnitId = info.getStorageOrgUnit().getId().toString();
            if (!paramsMap.containsKey(orgUnitId)) {
                paramsMap.put(orgUnitId, ParamManager.getParamValue((Context)ctx, (IObjectPK)new ObjectUuidPK(orgUnitId), (String)"AutoBackFlush"));
            }
            if (!"true".equalsIgnoreCase((String)paramsMap.get(orgUnitId))) continue;
            idList.add(info.getId().toString());
        }
        return idList;
    }

    private void doBackFlushRun(Context ctx, List idList) throws BOSException, EASBizException {
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[idList.size()];
        Class[] paramTypes = new Class[]{IObjectPK.class};
        int n = idList.size();
        for (int i = 0; i < n; ++i) {
            entries[i] = new BatchExecuteParamsEntry(paramTypes);
            entries[i].add((Object)new ObjectUuidPK((String)idList.get(i)));
        }
        this.doBackFlush(ctx, entries, true);
    }

    private void doBackoundRun(Context ctx, List idList) throws BOSException {
        BPOption bpOption = new BPOption();
        bpOption.setImmediately(true);
        DynamicBackground bd = new DynamicBackground(ctx);
        Class[] paramTypes = new Class[]{String.class, Class[].class, BatchExecuteParamsEntry[].class};
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[idList.size()];
        Class[] _paramTypes = new Class[]{IObjectPK.class};
        int n = idList.size();
        for (int i = 0; i < n; ++i) {
            entries[i] = new BatchExecuteParamsEntry(_paramTypes);
            entries[i].add((Object)new ObjectUuidPK((String)idList.get(i)));
        }
        Object[] params = new Object[]{"autoBackFlush", _paramTypes, entries};
        BPResult r = bd.invokeBackound(this.getBOSType(), "batchExecute", paramTypes, params, bpOption);
        if (r.status == -1) {
            logger.error((Object)r.Message);
        }
    }

    public BatchActionResults batchFinishedRptBackFlushed(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        return this.doBackFlush(ctx, entries, false);
    }

    public BatchActionResults batchAutoBackFlush(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        return this.doBackFlush(ctx, entries, true);
    }

    public BatchActionResults batchSubmit(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        BatchActionResults results = this.submitForList(ctx, entries);
        return results;
    }

    private BatchActionResults submitForList(Context ctx, BatchExecuteParamsEntry[] entries) throws BOSException, EASBizException {
        HashSet<String> ids = new HashSet<String>();
        int n = entries.length;
        for (int i = 0; i < n; ++i) {
            ids.add(entries[i].get(0).toString());
        }
        if (ids.size() > 0) {
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
            ev.setFilter(filter);
            FinishedRptCollection frColl = FinishedRptFactory.getLocalInstance(ctx).getFinishedRptCollection(ev);
            for (int i = 0; i < frColl.size(); ++i) {
                FinishedRptInfo frInfo = frColl.get(i);
                if (frInfo.getStorageOrgUnit() == null) {
                    throw new FinishedRptException(FinishedRptException.BLANK, new String[]{ResourceUtils.getMessage((String)"com.kingdee.eas.mm.control.FinishedRptResource", (String)"StorageOrgUnitNullInfo")});
                }
                if (frInfo.getTaskDispBill() != null) {
                    TaskDispBillInfo task = frInfo.getTaskDispBill();
                    frInfo.setSourceBillId(task.getId().toString());
                    frInfo.setSourceBillType(task.getBillType());
                } else if (frInfo.getProductionOrder() != null) {
                    ProductionOrderInfo prdInfo = frInfo.getProductionOrder();
                    frInfo.setSourceBillId(prdInfo.getId().toString());
                    frInfo.setSourceBillType(prdInfo.getBillType());
                }
                super.submit(ctx, (CoreBaseInfo)frInfo);
            }
        }
        return null;
    }

    private BatchActionResults doBackFlush(Context ctx, BatchExecuteParamsEntry[] entries, boolean isAutoBackFlush) throws BOSException, EASBizException {
        ArrayList<String> idList = new ArrayList<String>();
        int n = entries.length;
        for (int i = 0; i < n; ++i) {
            idList.add(entries[i].get(0).toString());
        }
        BFCalcParam runParam = null;
        runParam = this.getBFRunParam(ctx, idList, isAutoBackFlush);
        GeneralBFProcessor processor = new GeneralBFProcessor();
        processor.run(runParam);
        return runParam.getBackFlushResults();
    }

    private BFCalcParam getBFRunParam(Context ctx, List idList, boolean isAuto) throws EASBizException, BOSException {
        BatchBackFlushResults batchResults = this.populateActionResults(idList);
        String idStr = StringUtil.arrayToString((Object[])idList.toArray(), (String)"','");
        StringBuffer sql = new StringBuffer();
        sql.append("Select t1.FId as srcBillId, t2.FId as srcBillEntryId,");
        sql.append("t1.FBaseStatus as status, t1.FBackFlushFlag as backFlushFlag  ");
        sql.append("From  T_MM_FinishedRpt t1 ");
        sql.append("LEFT JOIN T_MM_FinishedRptEntry t2 on t1.FId = t2.FParentId ");
        sql.append("WHERE t1.FId in ('").append(idStr).append("')");
        ArrayList<String> billIdList = new ArrayList<String>();
        ArrayList<String> entryIdList = new ArrayList<String>();
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            String srcBillId = null;
            while (rows.next()) {
                srcBillId = rows.getString("srcBillId");
                if (!batchResults.getToDoIdsSet().contains(srcBillId)) continue;
                if (!this.checkBillStatus4BackFlush(rows.getInt("status"))) {
                    batchResults.addError(srcBillId, FinishedRptUtil.getResource("FlushError1", ctx));
                    continue;
                }
                if (!this.checkBackFlushStatus(rows.getInt("backFlushFlag"))) {
                    batchResults.addError(srcBillId, BackFlushUtil.getString((String)"BACKFLUSH_BFFLAGERROR"));
                    continue;
                }
                billIdList.add(srcBillId);
                entryIdList.add(rows.getString("srcBillEntryId"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        HashMap map = new HashMap();
        map.put("BFBillIdList", billIdList);
        map.put("BFBillEntryIdList", entryIdList);
        map.put("ReqBillToDoIdList", new ArrayList());
        BFCalcParam runParam = BFCalcParam.parseFrom(map);
        runParam.setContext(ctx);
        runParam.setBFBillBOSType("F2901DDD");
        runParam.setAutoBackFlush(isAuto);
        runParam.setBackFlushResults(batchResults);
        return runParam;
    }

    private boolean checkBillStatus4BackFlush(int status) {
        return 4 == status || 90 == status;
    }

    private boolean checkBackFlushStatus(int flag) {
        return 4 == flag || 3 == flag;
    }

    private BatchBackFlushResults populateActionResults(List billIdList) {
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[billIdList.size()];
        Class[] parameTypes = new Class[]{String.class};
        int n = billIdList.size();
        for (int i = 0; i < n; ++i) {
            entries[i] = new BatchExecuteParamsEntry(parameTypes);
            entries[i].add(billIdList.get(i));
        }
        return BatchBackFlushResults.populateActionResults((BatchExecuteParamsEntry[])entries);
    }

    private void deleteBackFlushRecord(Context ctx, List idList) throws EASBizException, BOSException {
        String strIds = StringUtil.arrayToString((Object[])idList.toArray(), (String)"','");
        String sql = "select fid from t_mm_BackFlushRecord where fsrcBillId in ('" + strIds + "')";
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql);
        ArrayList<ObjectUuidPK> deletePkList = new ArrayList<ObjectUuidPK>();
        try {
            while (rows.next()) {
                deletePkList.add(new ObjectUuidPK(rows.getString("fid")));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (deletePkList.size() > 0) {
            IObjectPK[] pkArray = new IObjectPK[deletePkList.size()];
            int n = deletePkList.size();
            for (int i = 0; i < n; ++i) {
                pkArray[i] = (ObjectUuidPK)deletePkList.get(i);
            }
            BackFlushRecordFactory.getLocalInstance((Context)ctx).deleteBatchData(pkArray);
        }
    }

    @Override
    @Deprecated
    protected void _autoBackFlush(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
    }

    @Override
    protected IObjectCollection _transformForBotp(Context ctx, List srcBillList, List mappingList) throws BOSException, EASBizException {
        IObjectCollection colls = null;
        if (mappingList.size() > 0 && srcBillList.size() > 0 && mappingList.size() == srcBillList.size()) {
            IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
            int n = mappingList.size();
            for (int i = 0; i < n; ++i) {
                BOTMappingInfo mappingInfo = (BOTMappingInfo)mappingList.get(i);
                CoreBillBaseCollection srcBillCols = (CoreBillBaseCollection)srcBillList.get(i);
                BTPTransformResult aaa = iBTPManager.transformForBotp(srcBillCols, mappingInfo.getDestEntityName(), (IObjectPK)new ObjectUuidPK(mappingInfo.getId()));
                if (colls == null) {
                    colls = aaa.getBills();
                    continue;
                }
                colls.addObjectCollection(aaa.getBills());
            }
            return colls;
        }
        logger.error((Object)("mappingList:" + mappingList.size()));
        logger.error((Object)("srcBillList:" + srcBillList.size()));
        logger.error((Object)ResourceBase.getString((String)"com.kingdee.eas.mm.control.CONTROLAutoGenerateResource", (String)"27_FinishedRptControllerBean", (Locale)ctx.getLocale()));
        return null;
    }

    @Override
    protected FinishedRptBOTPParams _getBOTPParameters(Context ctx, IObjectValue orgUnit) throws BOSException, EASBizException {
        StorageOrgUnitInfo storageOrgUnit = (StorageOrgUnitInfo)orgUnit;
        FinishedRptBOTPParams params = new FinishedRptBOTPParams();
        params.setStorageOrgUnit(storageOrgUnit);
        String sql = "select FKeyId, FMappingId from T_MM_FinishedRptBOTPParams where FOrgUnitId = ?";
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{storageOrgUnit.getId().toString()});
        if (rows.size() > 0) {
            try {
                HashMap<String, String> mappingMap = new HashMap<String, String>();
                HashSet<String> botpIds = new HashSet<String>();
                while (rows.next()) {
                    String keyId = rows.getString("FKeyId");
                    String mappingId = rows.getString("FMappingId");
                    botpIds.add(mappingId);
                    mappingMap.put(keyId, mappingId);
                }
                this.buildParams(ctx, params, botpIds, mappingMap);
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        } else {
            this.buildParams(ctx, params, this.getDefaultBOTPIds(), this.getDefaultBOTPMappings());
        }
        return params;
    }

    private void buildParams(Context ctx, FinishedRptBOTPParams params, Set botpIds, Map mappingMap) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)botpIds, CompareType.INCLUDE));
        view.setFilter(filter);
        BOTMappingCollection colls = BOTMappingFactory.getLocalInstance((Context)ctx).getBOTMappingCollection(view);
        if (colls != null && colls.size() >= 4 && colls.size() <= 12) {
            for (Map.Entry entry : mappingMap.entrySet()) {
                String keyId = (String)entry.getKey();
                String mappingId = (String)entry.getValue();
                boolean isFound = false;
                int n = colls.size();
                for (int i = 0; i < n; ++i) {
                    BOTMappingInfo mappingInfo = colls.get(i);
                    if (!mappingId.equals(mappingInfo.getId().toString())) continue;
                    params.setBOTPMapping(keyId, mappingInfo);
                    isFound = true;
                    break;
                }
                if (isFound) continue;
                throw new FinishedRptException(FinishedRptException.BLANK, new String[]{FinishedRptUtil.getResource("BOTPParamError", ctx)});
            }
        } else {
            throw new FinishedRptException(FinishedRptException.BLANK, new String[]{FinishedRptUtil.getResource("BOTPParamError", ctx)});
        }
    }

    private Map getDefaultBOTPMappings() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("botpRule1", "kRtOPa28Thqn6DHBy8y5zgRRIsQ=");
        map.put("botpRule2", "kRtOPa28Thqn6DHBy8y5zgRRIsQ=");
        map.put("botpRule3", "kRtOPa28Thqn6DHBy8y5zgRRIsQ=");
        map.put("botpRule4", "N+Wua9dmQqK2ToHPb/I5vQRRIsQ=");
        map.put("botpRule5", "N+Wua9dmQqK2ToHPb/I5vQRRIsQ=");
        map.put("botpRule6", "N+Wua9dmQqK2ToHPb/I5vQRRIsQ=");
        map.put("botpRule7", "ZSSnawQDS+mJ+VoshUcGAQRRIsQ=");
        map.put("botpRule8", "ZSSnawQDS+mJ+VoshUcGAQRRIsQ=");
        map.put("botpRule9", "ZSSnawQDS+mJ+VoshUcGAQRRIsQ=");
        map.put("botpRule10", "uQPqpzNtQP2Cd7bmi0a1FwRRIsQ=");
        map.put("botpRule11", "uQPqpzNtQP2Cd7bmi0a1FwRRIsQ=");
        map.put("botpRule12", "uQPqpzNtQP2Cd7bmi0a1FwRRIsQ=");
        return map;
    }

    private Set getDefaultBOTPIds() {
        HashSet<String> ids = new HashSet<String>();
        ids.add("kRtOPa28Thqn6DHBy8y5zgRRIsQ=");
        ids.add("N+Wua9dmQqK2ToHPb/I5vQRRIsQ=");
        ids.add("ZSSnawQDS+mJ+VoshUcGAQRRIsQ=");
        ids.add("uQPqpzNtQP2Cd7bmi0a1FwRRIsQ=");
        return ids;
    }

    @Override
    protected void _saveBOTPParameters(Context ctx, FinishedRptBOTPParams params) throws BOSException, EASBizException {
        String orgUnitId = params.getStorageOrgUnit().getId().toString();
        String deleteSql = "delete from T_MM_FinishedRptBOTPParams where FOrgUnitId = ?";
        DbUtil.execute((Context)ctx, (String)deleteSql, (Object[])new Object[]{orgUnitId});
        String insertSql = "insert into T_MM_FinishedRptBOTPParams(FOrgUnitId, FKeyId, FMappingId) values(?, ?, ?)";
        String defaultKey = "botpRule";
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        for (int i = 1; i <= 12; ++i) {
            String key = defaultKey + String.valueOf(i);
            BOTMappingInfo mappingInfo = params.getBOTPMapping(key);
            if (mappingInfo == null) {
                throw new FinishedRptException(FinishedRptException.BLANK, new String[]{FinishedRptUtil.getResource("BOTPParamError", ctx)});
            }
            Object[] param = new Object[]{orgUnitId, key, mappingInfo.getId().toString()};
            paramsList.add(param);
        }
        DbUtil.executeBatch((Context)ctx, (String)insertSql, paramsList);
    }

    protected void writeBackStockTotalQty(Context ctx, String finishedRptId, InvBillBaseInfo recBillInfo, boolean writeBack) throws BOSException, EASBizException {
        if (null == finishedRptId || "".equals(finishedRptId) || null == recBillInfo) {
            return;
        }
        FinishedRptInfo finishedRpt = this.getFinishedRptInfoById(ctx, finishedRptId);
        String passTransactionTypes = FinishedRptFactory.getLocalInstance(ctx).getPassTransactionTypes();
        if (null != finishedRpt && null != finishedRpt.getEntrys() && null != recBillInfo.get("entry")) {
            String productionOrderId = finishedRpt.getProductionOrder().getId().toString();
            ProductionOrderInfo productionOrder = ProductionOrderFactory.getLocalInstance(ctx).getProductionOrderInfo((IObjectPK)new ObjectUuidPK(productionOrderId));
            if (BillBaseStatusEnum.CLOSED == productionOrder.getBaseStatus()) {
                if (writeBack) {
                    throw new FinishedRptException(FinishedRptException.BLANK, new String[]{FinishedRptUtil.getResource("Msg_OrderStatusCheckForReqAudit", ctx)});
                }
                throw new FinishedRptException(FinishedRptException.BLANK, new String[]{FinishedRptUtil.getResource("Msg_OrderStatusCheckForReqUnAudit", ctx)});
            }
            String taskDispBillId = null;
            boolean isTaskDisp = false;
            if (null != finishedRpt.getTaskDispBill()) {
                taskDispBillId = finishedRpt.getTaskDispBill().getId().toString();
                isTaskDisp = true;
            }
            String tableName = recBillInfo instanceof ManufactureRecBillInfo ? "T_IM_ManufactureRecBillEntry" : "T_IM_OtherInWarehsBillEntry";
            Map materialFRCVInLimit = this.getFRCVInLimit(ctx, recBillInfo.getId().toString(), finishedRpt.getStorageOrgUnit().getId().toString(), tableName);
            HashMap<String, MaterialProductEnum> materialOutType = new HashMap<String, MaterialProductEnum>();
            HashMap<String, FinishedRptEntryInfo> idEntryMap = new HashMap<String, FinishedRptEntryInfo>();
            Iterator iter = finishedRpt.getEntrys().iterator();
            while (iter.hasNext()) {
                FinishedRptEntryInfo element = (FinishedRptEntryInfo)iter.next();
                materialOutType.put(element.getId().toString(), element.getOutputType());
                idEntryMap.put(element.getId().toString(), element);
            }
            String kSQL = null;
            IObjectCollection entryCol = (IObjectCollection)recBillInfo.get("entry");
            for (InvBillBaseEntryInfo entryInfo : entryCol) {
                Boolean isStorageLimit;
                String checkSql;
                BOSObjectType sourceBillEntryBOSType;
                if (entryInfo.getSourceBillId() != null && !entryInfo.getSourceBillId().equals(finishedRptId)) continue;
                String materialId = entryInfo.getMaterial().getId().toString();
                BigDecimal qty = entryInfo.getQty();
                BigDecimal baseQty = entryInfo.getBaseQty();
                int status = 0;
                if (!writeBack) {
                    qty = entryInfo.getQty().negate();
                    baseQty = entryInfo.getBaseQty().negate();
                }
                BigDecimal passQty = new BigDecimal("0");
                BigDecimal basePassQty = new BigDecimal("0");
                BigDecimal unPassQty = new BigDecimal("0");
                BigDecimal baseUnPassQty = new BigDecimal("0");
                FinishedRptCRInfo checkInfo = null;
                FinishedRptEntryInfo element = null;
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add("*");
                TransactionTypeInfo ty = (TransactionTypeInfo)TransactionTypeFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(recBillInfo.getTransactionType().getId().toString()), sic);
                boolean isPass = true;
                try {
                    sourceBillEntryBOSType = BOSUuid.read((String)entryInfo.getSourceBillEntryId()).getType();
                }
                catch (UuidException e) {
                    logger.error((Object)e.getMessage());
                    continue;
                }
                catch (IllegalArgumentException e) {
                    logger.error((Object)e.getMessage());
                    continue;
                }
                if (BOSObjectType.create((String)"21191C95").equals((Object)sourceBillEntryBOSType)) {
                    if (ty.getNumber().equals("503")) {
                        sic = this.getEntrySelector();
                        element = (FinishedRptEntryInfo)FinishedRptEntryFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(entryInfo.getSourceBillEntryId().toString()), sic);
                        passQty = SCMUtils.getExchangePrecisionQtyForServer((Context)ctx, (String)element.getMaterial().getId().toString(), (MeasureUnitInfo)element.getMaterial().getBaseUnit(), (MeasureUnitInfo)element.getUnit(), (BigDecimal)baseQty);
                        basePassQty = baseQty;
                        isPass = true;
                    } else if (ty.getNumber().equals("504")) {
                        sic = this.getEntrySelector();
                        element = (FinishedRptEntryInfo)FinishedRptEntryFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(entryInfo.getSourceBillEntryId().toString()), sic);
                        unPassQty = SCMUtils.getExchangePrecisionQtyForServer((Context)ctx, (String)element.getMaterial().getId().toString(), (MeasureUnitInfo)element.getMaterial().getBaseUnit(), (MeasureUnitInfo)element.getUnit(), (BigDecimal)baseQty);
                        baseUnPassQty = baseQty;
                        isPass = false;
                    } else if (passTransactionTypes.indexOf(ty.getNumber()) >= 0) {
                        sic = this.getEntrySelector();
                        element = (FinishedRptEntryInfo)FinishedRptEntryFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(entryInfo.getSourceBillEntryId().toString()), sic);
                        passQty = SCMUtils.getExchangePrecisionQtyForServer((Context)ctx, (String)element.getMaterial().getId().toString(), (MeasureUnitInfo)element.getMaterial().getBaseUnit(), (MeasureUnitInfo)element.getUnit(), (BigDecimal)baseQty);
                        basePassQty = baseQty;
                        isPass = true;
                    } else {
                        sic = this.getEntrySelector();
                        element = (FinishedRptEntryInfo)FinishedRptEntryFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(entryInfo.getSourceBillEntryId().toString()), sic);
                        unPassQty = SCMUtils.getExchangePrecisionQtyForServer((Context)ctx, (String)element.getMaterial().getId().toString(), (MeasureUnitInfo)element.getMaterial().getBaseUnit(), (MeasureUnitInfo)element.getUnit(), (BigDecimal)baseQty);
                        baseUnPassQty = baseQty;
                        isPass = false;
                    }
                } else if (ty.getNumber().equals("505") || ty.getNumber().equals("506")) {
                    checkSql = "update t_mm_finishedRptCr set FTotalReportQty = FTotalReportQty+?,FBaseTotalReportQty=FBaseTotalReportQty+? where fid = ?";
                    DbUtil.execute((Context)ctx, (String)checkSql, (Object[])new Object[]{qty, baseQty, entryInfo.getSourceBillEntryId()});
                    sic = this.getCheckEntrySelector();
                    checkInfo = (FinishedRptCRInfo)FinishedRptCRFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(entryInfo.getSourceBillEntryId().toString()), sic);
                    element = checkInfo.getParent();
                    if (checkInfo.getMaterial().getId().toString().equals(element.getMaterial().getId().toString())) {
                        if (ty.getNumber().equals("505")) {
                            passQty = SCMUtils.getExchangePrecisionQtyForServer((Context)ctx, (String)checkInfo.getMaterial().getId().toString(), (MeasureUnitInfo)element.getMaterial().getBaseUnit(), (MeasureUnitInfo)element.getUnit(), (BigDecimal)baseQty);
                            basePassQty = baseQty;
                        } else {
                            unPassQty = SCMUtils.getExchangePrecisionQtyForServer((Context)ctx, (String)checkInfo.getMaterial().getId().toString(), (MeasureUnitInfo)element.getMaterial().getBaseUnit(), (MeasureUnitInfo)element.getUnit(), (BigDecimal)baseQty);
                            baseUnPassQty = baseQty;
                        }
                    }
                    isPass = ty.getNumber().equals("505");
                } else if (passTransactionTypes.indexOf(ty.getNumber()) >= 0) {
                    checkSql = "update t_mm_finishedRptCr set FTotalReportQty = FTotalReportQty+?,FBaseTotalReportQty=FBaseTotalReportQty+? where fid = ?";
                    DbUtil.execute((Context)ctx, (String)checkSql, (Object[])new Object[]{qty, baseQty, entryInfo.getSourceBillEntryId()});
                    sic = this.getCheckEntrySelector();
                    checkInfo = (FinishedRptCRInfo)FinishedRptCRFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(entryInfo.getSourceBillEntryId().toString()), sic);
                    element = checkInfo.getParent();
                    if (checkInfo.getMaterial().getId().toString().equals(element.getMaterial().getId().toString())) {
                        passQty = SCMUtils.getExchangePrecisionQtyForServer((Context)ctx, (String)checkInfo.getMaterial().getId().toString(), (MeasureUnitInfo)element.getMaterial().getBaseUnit(), (MeasureUnitInfo)element.getUnit(), (BigDecimal)baseQty);
                        basePassQty = baseQty;
                    }
                    isPass = true;
                } else {
                    checkSql = "update t_mm_finishedRptCr set FTotalReportQty = FTotalReportQty+?,FBaseTotalReportQty=FBaseTotalReportQty+? where fid = ?";
                    DbUtil.execute((Context)ctx, (String)checkSql, (Object[])new Object[]{qty, baseQty, entryInfo.getSourceBillEntryId()});
                    sic = this.getCheckEntrySelector();
                    checkInfo = (FinishedRptCRInfo)FinishedRptCRFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(entryInfo.getSourceBillEntryId().toString()), sic);
                    element = checkInfo.getParent();
                    if (checkInfo.getMaterial().getId().toString().equals(element.getMaterial().getId().toString())) {
                        unPassQty = SCMUtils.getExchangePrecisionQtyForServer((Context)ctx, (String)checkInfo.getMaterial().getId().toString(), (MeasureUnitInfo)element.getMaterial().getBaseUnit(), (MeasureUnitInfo)element.getUnit(), (BigDecimal)baseQty);
                        baseUnPassQty = baseQty;
                    }
                    isPass = false;
                }
                if (element == null) continue;
                Map material = (Map)materialFRCVInLimit.get(materialId);
                BigDecimal frcvInLowLimit = (BigDecimal)material.get(RCVIN_LOW_LIMIT);
                BigDecimal frcvInHighLimit = (BigDecimal)material.get(RCVIN_HIGHT_LIMIT);
                Boolean bl = isStorageLimit = material.get(ISSTORAGELIMIT) != null ? (Boolean)material.get(ISSTORAGELIMIT) : new Boolean(false);
                if (isStorageLimit.booleanValue()) {
                    if (null == frcvInLowLimit) {
                        frcvInLowLimit = new BigDecimal(String.valueOf(0.0));
                    }
                    if (null == frcvInHighLimit) {
                        frcvInHighLimit = new BigDecimal(String.valueOf(0.0));
                    }
                    if (this.isOverLimit(baseQty, isPass, element, frcvInHighLimit)) {
                        throw new FinishedRptException(FinishedRptException.OVERHIGHLIMIT, new Object[]{element.getParent().getNumber()});
                    }
                }
                if (this.isEntryComplete(baseQty, element, frcvInLowLimit)) {
                    status = 8;
                }
                BigDecimal backPrdQty = new BigDecimal(String.valueOf(0.0));
                backPrdQty = SCMUtils.getExchangePrecisionQtyForServer((Context)ctx, (String)entryInfo.getMaterial().getId().toString(), (MeasureUnitInfo)entryInfo.getBaseUnit(), (MeasureUnitInfo)productionOrder.getUnit(), (BigDecimal)baseQty);
                if (passQty.compareTo(new BigDecimal("0")) == 0) {
                    kSQL = " update T_MM_FinishedRptEntry set FBejectStockTotalQty = FBejectStockTotalQty+?,FBaseRejectStockTotalQty=FBaseRejectStockTotalQty+?,FStatus = ? where FID = ? ";
                    DbUtil.execute((Context)ctx, (String)kSQL, (Object[])new Object[]{unPassQty, baseUnPassQty, new Integer(status), element.getId().toString()});
                } else {
                    kSQL = " update T_MM_FinishedRptEntry set FStockTotalQty = FStockTotalQty + ?,FBaseStockTotalQty = FBaseStockTotalQty + ?,FStatus = ? where FID = ? ";
                    DbUtil.execute((Context)ctx, (String)kSQL, (Object[])new Object[]{passQty, basePassQty, new Integer(status), element.getId().toString()});
                }
                int outputType = element.getOutputType().getValue();
                if (10710 == outputType) {
                    if (isTaskDisp) {
                        kSQL = "update T_MM_TaskDispBill set FStockTotalQty = FStockTotalQty + ?,FBaseStockTotalQty = FBaseStockTotalQty + ? where FID = ? ";
                        DbUtil.execute((Context)ctx, (String)kSQL, (Object[])new Object[]{backPrdQty, baseQty, taskDispBillId});
                    }
                    kSQL = "update T_MM_ProductionOrder set FStockTotalQty = FStockTotalQty + ?,FBaseStockTotalQty = FBaseStockTotalQty + ? where FID = ? ";
                    DbUtil.execute((Context)ctx, (String)kSQL, (Object[])new Object[]{backPrdQty, baseQty, productionOrderId});
                    continue;
                }
                if (10720 != outputType && 10730 != outputType) continue;
                kSQL = "update T_MM_ProductionOrderOEntry set FStockTotalQty = FStockTotalQty + ?,FBaseStockTotalQty = FBaseStockTotalQty + ? where FParentID = ? and FOutputType = ? and FMaterialID = ?";
                DbUtil.execute((Context)ctx, (String)kSQL, (Object[])new Object[]{qty, baseQty, productionOrderId, new Integer(outputType), materialId});
            }
            kSQL = "update T_MM_FinishedRpt set FBaseStatus = ? where FID = ? ";
            int status = this.getBillStatus(ctx, finishedRptId);
            DbUtil.execute((Context)ctx, (String)kSQL, (Object[])new Object[]{new Integer(status), finishedRptId});
        }
    }

    private Map getFRCVInLimit(Context ctx, String destBillId, String orgId, String tableName) throws BOSException {
        String kSQL = "select FMaterialID, FRCVInLowLimit, FRCVInHightLimit, FRCVDispersionBase ,FisStorageLimit from T_BD_MaterialPlan where FMaterialID in (select r.FMaterialID from " + tableName + " r where r.FParentID = ? ) And FOrgUnit = '" + orgId + "'";
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)kSQL, (Object[])new Object[]{destBillId});
        HashMap result = new HashMap();
        if (null != rows) {
            try {
                while (rows.next()) {
                    HashMap<String, Serializable> materialFRCVInLowLimit = new HashMap<String, Serializable>();
                    String materialid = rows.getString("FMaterialID");
                    BigDecimal lowLimtValue = rows.getBigDecimal("FRCVInLowLimit") == null ? new BigDecimal(String.valueOf(0.0)) : rows.getBigDecimal("FRCVInLowLimit");
                    lowLimtValue = lowLimtValue.setScale(4, 5).divide(new BigDecimal(String.valueOf(100)), 5);
                    BigDecimal hignLimitValue = rows.getBigDecimal("FRCVInHightLimit") == null ? new BigDecimal(String.valueOf(0.0)) : rows.getBigDecimal("FRCVInHightLimit");
                    hignLimitValue = hignLimitValue.setScale(4, 5).divide(new BigDecimal(String.valueOf(100)), 5);
                    Integer dispersionBase = new Integer(rows.getInt("FRCVDispersionBase"));
                    Boolean isStorageLimit = new Boolean(rows.getBoolean("FisStorageLimit"));
                    materialFRCVInLowLimit.put(RCVIN_HIGHT_LIMIT, hignLimitValue);
                    materialFRCVInLowLimit.put(RCVIN_LOW_LIMIT, lowLimtValue);
                    materialFRCVInLowLimit.put(RCV_DISPERSION_BASE, dispersionBase);
                    materialFRCVInLowLimit.put(ISSTORAGELIMIT, isStorageLimit);
                    result.put(materialid, materialFRCVInLowLimit);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return result;
    }

    @Override
    protected IObjectCollection _getCollection(Context ctx, IServiceContext svcCtx, EntityViewInfo view) throws BOSException {
        SelectorItemCollection sic = view.getSelector();
        boolean isSelectCheckEntry = false;
        SelectorItemCollection subSelectors = new SelectorItemCollection();
        for (int i = sic.size() - 1; i >= 0; --i) {
            SelectorItemInfo selectInfo = sic.get(i);
            String propertyName = selectInfo.getPropertyName();
            if (propertyName.indexOf("checkEntry") <= 0) continue;
            isSelectCheckEntry = true;
            break;
        }
        if (isSelectCheckEntry && view.getEntryFilters().size() == 0) {
            Iterator iter = view.getFilter().getFilterItems().iterator();
            String strIdLists = "";
            while (iter.hasNext()) {
                FilterItemInfo filterItem = (FilterItemInfo)iter.next();
                if (!"id".equalsIgnoreCase(filterItem.getPropertyName())) continue;
                HashSet ids = (HashSet)filterItem.getCompareValue();
                strIdLists = StringUtils.arrayToString((Object[])ids.toArray(), (String)"','");
                break;
            }
            FilterInfo entryFilter = new FilterInfo();
            entryFilter.setEntryName("entrys");
            entryFilter.getFilterItems().add(new FilterItemInfo("id", (Object)("select fid from T_MM_FinishedrptEntry where fparentId in ('" + strIdLists + "')"), CompareType.INNER));
            view.getEntryFilters().add(entryFilter);
        }
        FinishedRptCollection colls = (FinishedRptCollection)super._getCollection(ctx, svcCtx, view);
        return colls;
    }
}

