/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.control.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.scm.common.TransactionTypeFactory;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.common.MMCommonException;
import com.kingdee.eas.mm.common.app.BillUpdater;
import com.kingdee.eas.mm.common.backFlush.BackFlushRecordCollection;
import com.kingdee.eas.mm.common.backFlush.BackFlushRecordInfo;
import com.kingdee.eas.mm.common.backFlush.util.BackFlushUtil;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.mm.control.ProductionOrderException;
import com.kingdee.eas.mm.control.ProductionOrderFacadeFactory;
import com.kingdee.eas.mm.control.app.PoMaterialWithDraw;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MaterialReqBillWriteBackOrderUpdater
extends BillUpdater {
    private String billTypeID = null;
    private String[] billIds = null;
    private TransactionTypeInfo transactionTypeInfo = null;

    public MaterialReqBillWriteBackOrderUpdater() {
    }

    public MaterialReqBillWriteBackOrderUpdater(Context ctx) {
        super(ctx);
    }

    protected boolean beforeExecute() throws BOSException, EASBizException {
        if (!"50957179-0105-1000-e000-0163c0a812fd463ED552".equals(this.billTypeID)) {
            return false;
        }
        this.transactionTypeInfo = this.getSrcBillTransactionType(this.billIds[0]);
        this.insertTempTableData();
        if (!this.checkTempTableData()) {
            return false;
        }
        this.isBackFlush();
        this.isOrderClosed();
        this.setTargetTable("T_MM_ProductionOrderSEntry");
        this.setWriteBackFields();
        this.setOperationSign();
        this.setQtyCheckException();
        this.setUpdateHead(false);
        this.setTransfUnit(true);
        this.setReleaseTempTable(true);
        this.setThrowException(true);
        return true;
    }

    private void isBackFlush() throws BOSException, EASBizException {
        if (this.isAuditAction) {
            return;
        }
        StringBuffer tempSql = new StringBuffer();
        tempSql.append("select top 1 fbillid from ").append(this.sourceDataTable);
        tempSql.append(" where FIsBackflush = 1 and FBackFlushBillId is NULL and FBackFlushBillEntryId is NULL");
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)tempSql.toString());
        try {
            if (rs.next()) {
                throw new MMCommonException(MMCommonException.BLANK, (Object[])new String[]{BackFlushUtil.getString((String)"BACKFLUSH_REQBILLCANNOTUNAUDIT")});
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private boolean checkTempTableData() throws BOSException {
        boolean flag = true;
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT COUNT(FBillID) AS totalCount FROM ");
        sb.append(this.sourceDataTable);
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sb.toString());
        try {
            int closedCount;
            if (rs != null && rs.next() && (closedCount = rs.getInt("totalCount")) <= 0) {
                flag = false;
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return flag;
    }

    protected void insertTempTableData() throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("insert into ").append(this.sourceDataTable);
        sb.append(" (FBillID, FSourceBillID, FSourceBillEntryId, FBackFlushBillId,FBackFlushBillEntryId, FBaseQty, FQty, FIsBackflush) ");
        sb.append("select head.FID, entry.FSourceBillID, entry.FSourceBillEntryId, entry.FBackFlushBillId, entry.FBackFlushBillEntryId, entry.FBaseQty, entry.FQty, head.FIsBackflush ");
        sb.append("from T_IM_MATERIALREQBILL head ");
        sb.append("inner join T_IM_MATERIALREQBILLENTRY entry on head.FID = entry.FParentId ");
        sb.append("where head.FID in (").append(SQLUtil.arrayToString((Object[])this.billIds)).append(") AND ");
        sb.append(" head.FSourceBillTypeID = '").append("ejIZHXXTQliYCQJg9t4Re0Y+1VI=").append("'");
        DbUtil.execute((Context)this.ctx, (String)sb.toString());
    }

    public void setBillTypeID(String billTypeID) {
        this.billTypeID = billTypeID;
    }

    public void setBillIds(String[] billIds) {
        this.billIds = billIds;
    }

    private void setWriteBackFields() {
        int bizDirection = this.transactionTypeInfo.getRiType().getBizDirection().getValue();
        if (1 == bizDirection) {
            this.setBaseQtyFields(new String[]{"FBaseSendOutTotalQty"});
            this.setQtyFields(new String[]{"FSendOutTotalQty"});
        } else {
            this.setBaseQtyFields(new String[]{"FBaseUntreadTotalQty"});
            this.setQtyFields(new String[]{"FUntreadTotalQty"});
        }
    }

    private void setOperationSign() throws EASBizException, BOSException {
        int bizDirection = this.transactionTypeInfo.getRiType().getBizDirection().getValue();
        if (this.isAuditAction) {
            if (1 == bizDirection) {
                this.setBaseQtyOperation(new String[]{"+"});
                this.setQtyOperation(new String[]{"+"});
            } else {
                this.setBaseQtyOperation(new String[]{"-"});
                this.setQtyOperation(new String[]{"-"});
            }
        } else if (1 == bizDirection) {
            this.setBaseQtyOperation(new String[]{"-"});
            this.setQtyOperation(new String[]{"-"});
        } else {
            this.setBaseQtyOperation(new String[]{"+"});
            this.setQtyOperation(new String[]{"+"});
        }
    }

    private TransactionTypeInfo getSrcBillTransactionType(String srcBillId) throws BOSException, EASBizException {
        TransactionTypeInfo transactionTypeInfo = null;
        StringBuffer tempSql = new StringBuffer();
        tempSql.append("select FTransactionTypeID from T_IM_MATERIALREQBILL where FID = '").append(srcBillId).append("'");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)tempSql.toString());
            if (rs != null && rs.size() > 0) {
                String transactionTypeId = null;
                while (rs.next()) {
                    transactionTypeId = rs.getString("FTransactionTypeID");
                }
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("riType.id"));
                selector.add(new SelectorItemInfo("riType.name"));
                selector.add(new SelectorItemInfo("riType.number"));
                selector.add(new SelectorItemInfo("riType.bizDirection"));
                transactionTypeInfo = TransactionTypeFactory.getLocalInstance((Context)this.ctx).getTransactionTypeInfo((IObjectPK)new ObjectUuidPK(transactionTypeId), selector);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return transactionTypeInfo;
    }

    private void isOrderClosed() throws BOSException, EASBizException {
        StringBuffer tempSql = new StringBuffer();
        tempSql.append("select top 1 fid from t_mm_productionorder where fbasestatus = 7 and fid in (").append("select FSourceBillID from ").append(this.sourceDataTable).append(" where FSourceBillId is not NULL ").append(")");
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)tempSql.toString());
        try {
            if (rs.next()) {
                throw new ProductionOrderException(ProductionOrderException.SRCPOCLOSED, new String[]{""});
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public boolean qtyCheck() throws BOSException, EASBizException {
        boolean ret = true;
        StringBuffer sqlBuf = new StringBuffer();
        if (this.isThrowException()) {
            sqlBuf.append("select top 1 * from ");
        } else {
            sqlBuf.append("select distinct FBillID from ");
        }
        sqlBuf.append(this.getQtyCheckSql());
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sqlBuf.toString());
        try {
            if (this.isThrowException()) {
                if (rs != null && rs.next()) {
                    ret = false;
                }
            } else {
                sqlBuf.setLength(0);
                sqlBuf.append("delete ").append(this.sourceDataTable).append(" where FBillID in (");
                int i = 0;
                HashMap<String, String> errMap = new HashMap<String, String>();
                while (rs != null && rs.next()) {
                    String billID = rs.getString("FBillID");
                    if (errMap.containsKey(billID)) continue;
                    this.batchResults.addError(billID, (Exception)((Object)this.throwExcpetion));
                    errMap.put(billID, "1");
                    sqlBuf.append(i > 0 ? "," : " ").append("?");
                    ++i;
                }
                sqlBuf.append(")");
                if (i > 0 && this.isDeleteTempData) {
                    DbUtil.execute((Context)this.ctx, (String)sqlBuf.toString(), (Object[])errMap.keySet().toArray());
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return ret;
    }

    private String getQtyCheckSql() {
        StringBuffer sqlBuf = new StringBuffer();
        int bizDirection = this.transactionTypeInfo.getRiType().getBizDirection().getValue();
        if (1 == bizDirection) {
            sqlBuf.append(this.targetTable).append(" t1").append(" inner join (select tmp.").append(this.getFID()).append(", sum(tmp.FBaseQty) as Sum_BaseQty from ").append(this.sourceDataTable).append(" tmp group by tmp.").append(this.getFID()).append(") t2 on t1.FId = t2.FSourceBillEntryId").append(" inner join T_BD_MaterialPlan t3 on t3.FId = t1.FMaterialInventoryId").append(" where t3.FIsQuotaControl = 1 and ((100 + t3.FIssinHightLimit)/100) * ISNULL(t1.FBaseQty,0) + ISNULL(t1.FBaseUntreadTotalQty,0) - ISNULL(t1.FBaseSendOutTotalQty,0) < t2.Sum_BaseQty");
        } else {
            sqlBuf.append(this.targetTable).append(" t1").append(" inner join (select tmp.").append(this.getFID()).append(", sum(tmp.FBaseQty) as Sum_BaseQty from ").append(this.sourceDataTable).append(" tmp group by tmp.").append(this.getFID()).append(") t2 on t1.FId = t2.FSourceBillEntryId").append(" where t1.FBaseSendOutTotalQty < t2.Sum_BaseQty");
        }
        return sqlBuf.toString();
    }

    private void setQtyCheckException() {
        int bizDirection = this.transactionTypeInfo.getRiType().getBizDirection().getValue();
        if (1 == bizDirection) {
            this.setThrowExcpetion(new ProductionOrderException(ProductionOrderException.OVERISSINHIGHTLIMIT));
        } else {
            this.setThrowExcpetion(new ProductionOrderException(ProductionOrderException.OVERSENDOUTTOTALQTY));
        }
    }

    protected void afterExecute() throws BOSException, EASBizException {
        this.writeBack4BackFlush(this.isAuditAction);
        List orderIds = this.getOrderId();
        if (orderIds == null || orderIds.size() < 1) {
            return;
        }
        int bizDirection = this.transactionTypeInfo.getRiType().getBizDirection().getValue();
        if (this.isAuditAction && 1 == bizDirection || !this.isAuditAction && -1 == bizDirection) {
            ProductionOrderFacadeFactory.getLocalInstance(this.ctx).dealAutoFinished(orderIds, true);
        } else {
            ProductionOrderFacadeFactory.getLocalInstance(this.ctx).dealAutoFinished(orderIds, false);
        }
        PoMaterialWithDraw.updatePoABDate(this.ctx, orderIds);
        super.afterExecute();
    }

    private List getOrderId() throws BOSException {
        ArrayList<String> orderIds = new ArrayList<String>();
        StringBuffer selectSql = new StringBuffer();
        selectSql.append(" select distinct FSourceBillId from ").append(this.sourceDataTable).append(" where FSourceBillId is not NULL");
        IRowSet rowSetPick = DbUtil.executeQuery((Context)this.ctx, (String)selectSql.toString());
        try {
            while (rowSetPick.next()) {
                String id = rowSetPick.getString("FSourceBillId");
                orderIds.add(id);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return orderIds;
    }

    private void writeBack4BackFlush(boolean isAudit) throws BOSException, EASBizException {
        this.updateBackFlushRecord(this.isAuditAction);
        Set billIds = this.getBackFlushBillIds();
        if (billIds.size() > 0) {
            this.updateBackFlushBillFlag(billIds);
        }
    }

    private Set getBackFlushBillIds() throws BOSException {
        HashSet<String> billIds = new HashSet<String>();
        StringBuffer tempSql = new StringBuffer();
        tempSql.append("SELECT distinct FBackFlushBillId, FBackFlushBillEntryId ");
        tempSql.append("FROM ").append(this.sourceDataTable).append(" ");
        tempSql.append("WHERE FBackFlushBillId is not null ");
        IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)tempSql.toString());
        try {
            while (rowSet.next()) {
                billIds.add(rowSet.getString("FBackFlushBillId"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return billIds;
    }

    private void updateBackFlushRecord(boolean isAudit) throws BOSException {
        StringBuffer tempSql = new StringBuffer();
        tempSql.append("SELECT FSourceBillId, FSourceBillEntryId, FBackFlushBillId, FBackFlushBillEntryId, sum(FBaseQty) as FBaseQty, sum(FQty) as FQty ");
        tempSql.append("FROM ").append(this.sourceDataTable).append(" ");
        tempSql.append("WHERE FBackFlushBillId is not null ");
        tempSql.append("GROUP BY FSourceBillID, FSourceBillEntryId, FBackFlushBillId, FBackFlushBillEntryId");
        StringBuffer updateQtySql = new StringBuffer();
        updateQtySql.append("UPDATE T_MM_BackFlushRecord ");
        updateQtySql.append("SET FTotalBFQty = FTotalBFQty ").append(this.getOperationSign(isAudit)).append(" ?, ");
        updateQtySql.append("FBaseTotalBFQty = FBaseTotalBFQty ").append(this.getOperationSign(isAudit)).append(" ? ");
        updateQtySql.append("WHERE FSrcBillId = ? AND FSrcBillEntryId = ? AND FOrderId = ? AND FOrderEntryId = ?");
        ArrayList<Object[]> updateQtyParams = new ArrayList<Object[]>();
        StringBuffer updateFlagSql = new StringBuffer();
        updateFlagSql.append("UPDATE T_MM_BackFlushRecord ");
        updateFlagSql.append("SET FIsBackFlushed = ? ");
        updateFlagSql.append("WHERE FSrcBillEntryId = ? ");
        updateFlagSql.append("AND FTotalBFQty ").append(this.getCompareTypeSign(isAudit)).append(" FPlanBFQty ");
        updateFlagSql.append("AND FBaseTotalBFQty ").append(this.getCompareTypeSign(isAudit)).append(" FBasePlanBFQty ");
        updateFlagSql.append("AND FIsBackFlushed = ? ");
        ArrayList<Object[]> updateFlagParams = new ArrayList<Object[]>();
        IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)tempSql.toString());
        if (rowSet.size() == 0) {
            return;
        }
        try {
            String sourceBillId = null;
            String sourceBillEntryId = null;
            String backFlushBillId = null;
            String backFlushBillEntryId = null;
            BigDecimal baseQty = null;
            BigDecimal qty = null;
            while (rowSet.next()) {
                backFlushBillId = rowSet.getString("FBackFlushBillId");
                backFlushBillEntryId = rowSet.getString("FBackFlushBillEntryId");
                sourceBillId = rowSet.getString("FSourceBillId");
                sourceBillEntryId = rowSet.getString("FSourceBillEntryId");
                qty = rowSet.getBigDecimal("FQty");
                baseQty = rowSet.getBigDecimal("FBaseQty");
                Object[] qtyParams = new Object[]{qty, baseQty, backFlushBillId, backFlushBillEntryId, sourceBillId, sourceBillEntryId};
                Object[] flagParams = new Object[]{isAudit ? 1 : 0, backFlushBillEntryId, isAudit ? 0 : 1};
                updateQtyParams.add(qtyParams);
                updateFlagParams.add(flagParams);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        DbUtil.executeBatch((Context)this.ctx, (String)updateQtySql.toString(), updateQtyParams);
        DbUtil.executeBatch((Context)this.ctx, (String)updateFlagSql.toString(), updateFlagParams);
    }

    private void updateBackFlushBillFlag(Set billIds) throws BOSException, EASBizException {
        HashMap<Object, Integer> flagMap = new HashMap<Object, Integer>();
        Iterator ite = billIds.iterator();
        while (ite.hasNext()) {
            flagMap.put(ite.next(), 4);
        }
        BackFlushRecordCollection dbCol = BackFlushUtil.getSortBFRecordsFromDBBySrcBillIds((Context)this.ctx, (Set)billIds);
        BackFlushRecordInfo info2 = null;
        String srcBillTypeId = null;
        for (BackFlushRecordInfo info2 : dbCol) {
            int flag;
            if (srcBillTypeId == null) {
                srcBillTypeId = info2.getSrcBillType().getId().toString();
            }
            if ((flag = ((Integer)flagMap.get(info2.getSrcBillId())).intValue()) == 4) {
                if (!this.isBackFlushed(info2)) continue;
                if (this.isFinishedBF(info2)) {
                    flagMap.put(info2.getSrcBillId(), 1);
                    continue;
                }
                flagMap.put(info2.getSrcBillId(), 3);
                continue;
            }
            if (flag != 1 || this.isBackFlushed(info2) && this.isFinishedBF(info2)) continue;
            flagMap.put(info2.getSrcBillId(), 3);
        }
        StringBuffer updateFlagSql = new StringBuffer();
        updateFlagSql.append("UPDATE ").append(this.getBackFlushBillTableName(srcBillTypeId)).append(" ");
        updateFlagSql.append("SET FBackFlushFlag = ? ");
        updateFlagSql.append("WHERE FId = ? ");
        ArrayList<Object[]> updateFlagParams = new ArrayList<Object[]>();
        Map.Entry entry2 = null;
        for (Map.Entry entry2 : flagMap.entrySet()) {
            updateFlagParams.add(new Object[]{entry2.getValue(), entry2.getKey()});
        }
        DbUtil.executeBatch((Context)this.ctx, (String)updateFlagSql.toString(), updateFlagParams);
    }

    private void updateBackFlushedQty(Set billIds2, boolean isAuditAction) {
        StringBuffer tempSql = new StringBuffer();
        tempSql.append("SELECT FProductionOrderId, sum(FCommitQty) as FCommitQty ");
        tempSql.append("FROM ").append(this.sourceDataTable).append(" ");
        tempSql.append("WHERE FBackFlushBillId is not null ");
        tempSql.append("GROUP BY FSourceBillID, FSourceBillEntryId, FBackFlushBillId, FBackFlushBillEntryId");
    }

    private boolean isBackFlushed(BackFlushRecordInfo dbInfo) {
        return dbInfo.getTotalBFQty().compareTo(SCMConstant.BIGDECIMAL_ZERO) > 0 && dbInfo.getBaseTotalBFQty().compareTo(SCMConstant.BIGDECIMAL_ZERO) > 0;
    }

    private boolean isFinishedBF(BackFlushRecordInfo dbInfo) {
        return dbInfo.getPlanBFQty().compareTo(dbInfo.getTotalBFQty()) <= 0 && dbInfo.getBasePlanBFQty().compareTo(dbInfo.getBaseTotalBFQty()) <= 0;
    }

    private String getOperationSign(boolean isAudit) {
        if (isAudit) {
            return "+";
        }
        return "-";
    }

    private String getCompareTypeSign(boolean isAudit) {
        if (isAudit) {
            return ">=";
        }
        return "<";
    }

    private String getBackFlushBillTableName(String srcBillTypeId) {
        if ("e3soUQaBR8un8D2R7UpNwkY+1VI=".equalsIgnoreCase(srcBillTypeId)) {
            return "T_MM_FinishedRpt";
        }
        return "T_MM_FinishedRpt";
    }
}

