/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.control.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.common.MMCommonException;
import com.kingdee.eas.mm.common.app.BillUpdater;
import com.kingdee.eas.mm.common.app.BillUpdaterFactory;
import com.kingdee.eas.mm.common.app.MMExternalProcessor;
import com.kingdee.eas.mm.control.POWriteBackInfo;
import com.kingdee.eas.mm.control.app.Field.StockAllocationAppFieldName;
import com.kingdee.eas.mm.control.app.util.StockAllocationUtil;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class POWriteBackByStockTransfer
extends BillUpdater
implements MMExternalProcessor,
StockAllocationAppFieldName {
    private String[] billIds = null;

    public POWriteBackByStockTransfer() {
    }

    public POWriteBackByStockTransfer(Context ctx) {
        super(ctx);
    }

    public void process(Context ctx, int bizAction, String billTypeId, String[] billIds) throws BOSException, EASBizException {
        this.ctx = ctx;
        StorageOrgUnitInfo storageOrgUnitInfo = (StorageOrgUnitInfo)ctx.get((Object)OrgType.Storage);
        if (storageOrgUnitInfo == null) {
            return;
        }
        boolean flag = StockAllocationUtil.isAllocationMethod(ctx, storageOrgUnitInfo.getId().toString());
        if (!"50957179-0105-1000-e000-0172c0a812fd463ED552".equalsIgnoreCase(billTypeId) || flag) {
            return;
        }
        this.setSourceDataTable(BillUpdaterFactory.createTempTable((Context)ctx));
        this.billIds = billIds;
        this.setAuditAction(bizAction == 103);
        this.execute();
    }

    public void execute() throws BOSException, EASBizException {
        boolean isContinue = this.beforeExecute();
        String countSQL = "SELECT COUNT(*) as num FROM " + this.sourceDataTable;
        IRowSet countRs = DbUtil.executeQuery((Context)this.ctx, (String)countSQL);
        try {
            while (countRs.next()) {
                int num = countRs.getInt("num");
                if (num > 0) continue;
                this.afterExecute();
                return;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        boolean flag = true;
        String sql = "SELECT COUNT(*) as num FROM " + this.sourceDataTable + " WHERE fsourcebillid IS NULL";
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql);
        try {
            while (rs.next()) {
                int num = rs.getInt("num");
                if (num <= 0) continue;
                flag = false;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (flag && isContinue) {
            if (this.isAuditAction && !this.qtyCheck()) {
                throw this.throwExcpetion != null ? this.throwExcpetion : new MMCommonException(MMCommonException.REWRITEQTY_GT_UNQTY);
            }
            super.writeBack();
            this.afterExecute();
        } else {
            String idSQL = "SELECT * FROM " + this.sourceDataTable + " WHERE fsourcebillid IS NULL";
            String delSQL = "DELETE FROM " + this.sourceDataTable + " WHERE fsourcebillid IS NULL";
            IRowSet idRs = DbUtil.executeQuery((Context)this.ctx, (String)idSQL);
            HashMap destBillMap = new HashMap();
            try {
                while (idRs.next()) {
                    Set<POWriteBackInfo> entryIdSet;
                    POWriteBackInfo writeBakckInfo = new POWriteBackInfo();
                    String billId = idRs.getString("FBillId");
                    writeBakckInfo.setBillId(billId);
                    writeBakckInfo.setBillEntryId(idRs.getString("FBillEntryId"));
                    writeBakckInfo.setBaseQty(idRs.getBigDecimal("FBaseQty"));
                    writeBakckInfo.setQty(idRs.getBigDecimal("FQty"));
                    if (destBillMap.containsKey(billId)) {
                        entryIdSet = (Set)destBillMap.get(billId);
                        entryIdSet.add(writeBakckInfo);
                        continue;
                    }
                    entryIdSet = new HashSet();
                    entryIdSet.add(writeBakckInfo);
                    destBillMap.put(billId, entryIdSet);
                }
                DbUtil.execute((Context)this.ctx, (String)delSQL);
                if (isContinue) {
                    IRowSet numRs = DbUtil.executeQuery((Context)this.ctx, (String)countSQL);
                    while (numRs.next()) {
                        int num = numRs.getInt("num");
                        if (num <= 0) continue;
                        flag = true;
                    }
                    if (flag) {
                        if (this.isAuditAction && !this.qtyCheck()) {
                            throw this.throwExcpetion != null ? this.throwExcpetion : new MMCommonException(MMCommonException.REWRITEQTY_GT_UNQTY);
                        }
                        super.writeBack();
                    }
                }
                this.collectWriteBack(destBillMap);
            }
            catch (SQLException e) {
                throw new BOSException(e.getMessage());
            }
            this.afterExecute();
        }
    }

    private void collectWriteBack(Map destBillMap) throws BOSException, SQLException, EASBizException {
        IMeasureUnit measureUnit = MeasureUnitFactory.getLocalInstance((Context)this.ctx);
        if (destBillMap == null) {
            return;
        }
        Set entrySet = destBillMap.entrySet();
        for (Map.Entry entry : entrySet) {
            Set poWriteBackInfoSet = (Set)entry.getValue();
            for (POWriteBackInfo poWriteBackInfo : poWriteBackInfoSet) {
                String billEntryId = poWriteBackInfo.getBillEntryId();
                BigDecimal baseQty = poWriteBackInfo.getBaseQty();
                if (billEntryId == null) {
                    return;
                }
                String orderFlag = "";
                if (!this.isAuditAction) {
                    orderFlag = orderFlag + " DESC";
                }
                StringBuffer selectSQLBuffer = new StringBuffer();
                selectSQLBuffer.append("SELECT distinct s.fid as stockId,s.fqty as stockQty,s.fbaseQty stockBaseQty,");
                selectSQLBuffer.append("       s.ftotalTransferInQty as ftotalreceiptqty, ");
                selectSQLBuffer.append("       s.ftotalTransferInBaseQty as ftotalreceiptbaseqty, ");
                selectSQLBuffer.append("       s.funitid, ");
                selectSQLBuffer.append("       s.fbaseunitid,");
                selectSQLBuffer.append("       s.funreceiptqty, ");
                selectSQLBuffer.append("       s.funreceiptbaseqty, ");
                selectSQLBuffer.append("       s.fmaterialid,");
                selectSQLBuffer.append("       o.fnumber ");
                selectSQLBuffer.append("  FROM t_bot_relationentry entry ");
                selectSQLBuffer.append(" INNER JOIN t_bot_relation r ON r.fsrcobjectid = entry.fsrcobjectid ");
                selectSQLBuffer.append(" INNER JOIN T_MM_ProductionOrder o ON o.fid = entry.fsrcobjectid ");
                selectSQLBuffer.append(" INNER JOIN T_MM_ProductionOrderSEntry s ON s.fid = entry.fsrcentryid WHERE ");
                selectSQLBuffer.append(" 1 = 1  AND entry.fdestentryid = '" + billEntryId + "' ");
                selectSQLBuffer.append("  AND r.fsrcentityid = '1F66774E' ");
                selectSQLBuffer.append("  AND r.fdestentityid = '2239F30A' ");
                selectSQLBuffer.append(" ORDER BY o.fnumber " + orderFlag);
                IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)selectSQLBuffer.toString());
                int i = rowSet.size();
                int j = 0;
                BigDecimal baseSubstract = baseQty;
                while (rowSet.next()) {
                    BigDecimal tempSubBasQty;
                    BigDecimal tempSubQty;
                    String stockId = rowSet.getString("stockId");
                    String materialId = rowSet.getString("fmaterialid");
                    String unitId = rowSet.getString("funitid");
                    MeasureUnitInfo unitInfo = measureUnit.getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)unitId)));
                    String baseUnitId = rowSet.getString("fbaseunitid");
                    MeasureUnitInfo baseUnitInfo = measureUnit.getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)baseUnitId)));
                    BigDecimal totalreceiptqty = rowSet.getBigDecimal("ftotalreceiptqty");
                    BigDecimal totalreceiptbaseqty = rowSet.getBigDecimal("ftotalreceiptbaseqty");
                    BigDecimal unreceiptqty = rowSet.getBigDecimal("funreceiptqty");
                    BigDecimal unreceiptbaseqty = rowSet.getBigDecimal("funreceiptbaseqty");
                    BigDecimal stockQty = rowSet.getBigDecimal("stockQty");
                    BigDecimal stockBaseQty = rowSet.getBigDecimal("stockBaseQty");
                    BigDecimal resultUnreceiptqty = ZERO;
                    BigDecimal resultUnreceiptbaseqty = ZERO;
                    if (this.isAuditAction) {
                        if (j == i - 1) {
                            totalreceiptqty = totalreceiptqty.add(SCMUtils.getExchangePrecisionQtyForServer((Context)this.ctx, (String)materialId, (MeasureUnitInfo)baseUnitInfo, (MeasureUnitInfo)unitInfo, (BigDecimal)baseSubstract));
                            totalreceiptbaseqty = totalreceiptbaseqty.add(baseSubstract);
                        } else {
                            tempSubQty = ZERO;
                            tempSubBasQty = ZERO;
                            if (unreceiptqty.compareTo(ZERO) >= 0) {
                                tempSubQty = SCMUtils.getExchangePrecisionQtyForServer((Context)this.ctx, (String)materialId, (MeasureUnitInfo)baseUnitInfo, (MeasureUnitInfo)unitInfo, (BigDecimal)baseSubstract).subtract(unreceiptqty);
                                tempSubBasQty = baseSubstract.subtract(unreceiptbaseqty);
                                if (tempSubQty.compareTo(ZERO) >= 0) {
                                    totalreceiptqty = totalreceiptqty.add(unreceiptqty);
                                    totalreceiptbaseqty = totalreceiptbaseqty.add(unreceiptbaseqty);
                                } else {
                                    totalreceiptqty = totalreceiptqty.add(SCMUtils.getExchangePrecisionQtyForServer((Context)this.ctx, (String)materialId, (MeasureUnitInfo)baseUnitInfo, (MeasureUnitInfo)unitInfo, (BigDecimal)baseSubstract));
                                    totalreceiptbaseqty = totalreceiptbaseqty.add(baseSubstract);
                                }
                            } else {
                                tempSubQty = SCMUtils.getExchangePrecisionQtyForServer((Context)this.ctx, (String)materialId, (MeasureUnitInfo)baseUnitInfo, (MeasureUnitInfo)unitInfo, (BigDecimal)baseSubstract);
                                tempSubBasQty = baseSubstract;
                            }
                            baseSubstract = tempSubBasQty.compareTo(ZERO) >= 0 ? tempSubBasQty : ZERO;
                        }
                        resultUnreceiptqty = stockQty.subtract(totalreceiptqty);
                        resultUnreceiptbaseqty = stockBaseQty.subtract(totalreceiptbaseqty);
                    } else {
                        tempSubQty = SCMUtils.getExchangePrecisionQtyForServer((Context)this.ctx, (String)materialId, (MeasureUnitInfo)baseUnitInfo, (MeasureUnitInfo)unitInfo, (BigDecimal)baseSubstract).subtract(totalreceiptqty);
                        tempSubBasQty = baseSubstract.subtract(totalreceiptbaseqty);
                        if (tempSubQty.compareTo(ZERO) >= 0) {
                            totalreceiptqty = ZERO;
                            totalreceiptbaseqty = ZERO;
                        } else {
                            totalreceiptqty = totalreceiptqty.subtract(SCMUtils.getExchangePrecisionQtyForServer((Context)this.ctx, (String)materialId, (MeasureUnitInfo)baseUnitInfo, (MeasureUnitInfo)unitInfo, (BigDecimal)baseSubstract));
                            totalreceiptbaseqty = totalreceiptbaseqty.subtract(baseSubstract);
                        }
                        baseSubstract = tempSubBasQty.compareTo(ZERO) >= 0 ? tempSubBasQty : ZERO;
                        resultUnreceiptqty = stockQty.subtract(totalreceiptqty);
                        resultUnreceiptbaseqty = stockBaseQty.subtract(totalreceiptbaseqty);
                    }
                    StringBuffer updateSQLBuffer = new StringBuffer();
                    updateSQLBuffer.append("update T_MM_ProductionOrderSEntry set ");
                    if ("0E-8".equals(totalreceiptqty.toString())) {
                        updateSQLBuffer.append(" ftotalTransferInQty=0, ");
                    } else {
                        updateSQLBuffer.append(" ftotalTransferInQty=" + totalreceiptqty + ", ");
                    }
                    if ("0E-8".equals(totalreceiptbaseqty.toString())) {
                        updateSQLBuffer.append(" ftotalTransferInBaseQty=0,");
                    } else {
                        updateSQLBuffer.append(" ftotalTransferInBaseQty=" + totalreceiptbaseqty + ", ");
                    }
                    if ("0E-8".equals(resultUnreceiptqty.toString())) {
                        updateSQLBuffer.append(" funreceiptqty=0,");
                    } else {
                        updateSQLBuffer.append(" funreceiptqty=" + resultUnreceiptqty + ", ");
                    }
                    if ("0E-8".equals(resultUnreceiptbaseqty.toString())) {
                        updateSQLBuffer.append(" funreceiptbaseqty=0");
                    } else {
                        updateSQLBuffer.append(" funreceiptbaseqty=" + resultUnreceiptbaseqty);
                    }
                    updateSQLBuffer.append(" where fid='" + stockId + "'");
                    DbUtil.execute((Context)this.ctx, (String)updateSQLBuffer.toString());
                    ++j;
                }
            }
        }
        this.afterExecute();
    }

    protected boolean beforeExecute() throws BOSException, EASBizException {
        this.insertTempTableData();
        boolean ret = false;
        this.setTargetTable("T_MM_ProductionOrderSEntry");
        this.setUpdateHead(false);
        this.setTransfUnit(true);
        this.setBaseQtyFields(new String[]{"ftotalTransferInBaseQty"});
        this.setQtyFields(new String[]{"ftotalTransferInQty"});
        if (this.isAuditAction) {
            this.setBaseQtyOperation(new String[]{"+", "-"});
            this.setQtyOperation(new String[]{"+", "-"});
        } else {
            this.setBaseQtyOperation(new String[]{"-", "+"});
            this.setQtyOperation(new String[]{"-", "+"});
        }
        ret = true;
        this.setReleaseTempTable(true);
        this.setThrowException(true);
        this.setThrowExcpetion((EASBizException)new MMCommonException(MMCommonException.REWRITEQTY_GT_UNRECEIPTQTY));
        return ret;
    }

    private void insertTempTableData() throws BOSException {
        StringBuffer idStrs = new StringBuffer();
        for (int i = 0; i < this.billIds.length; ++i) {
            idStrs.append("'" + this.billIds[i] + "', ");
        }
        String idStr = idStrs.toString().trim().substring(0, idStrs.toString().trim().length() - 1);
        StringBuffer insertSql = new StringBuffer();
        insertSql.append("INSERT INTO ").append(this.sourceDataTable).append(" (FBillID,FBillEntryID,FSourceBillID,FSourceBillEntryId,FBaseQty,FQty) ").append("   SELECT DISTINCT s.fid, e.fid,s.fsourcebillid,e.fsourcebillentryid,round(DECIMAL(mbe.fqty * b.fbaseconvsrate,21,8),b.fqtyprecision),mbe.fqty ").append("  FROM T_IM_StockTransferBill  s  ").append("  INNER JOIN t_im_stocktransferbillentry e ON e.fparentid =s.fid ").append("  INNER JOIN T_IM_MoveIssueBillEntry f ON f.fsourcebillentryid =e.fid ").append("  INNER JOIN t_im_moveinwarehsbillentry mbe ON mbe.fsourcebillentryid = f.fid ").append("  INNER JOIN t_im_moveinwarehsbill r ON mbe.fparentid = r.fid ").append("  INNER JOIN t_bd_multimeasureunit b ON mbe.fmaterialid = b.fmaterialid AND mbe.funitid = b.fmeasureunitid ").append("  WHERE s.FSOURCEBILLTYPEID='ejIZHXXTQliYCQJg9t4Re0Y+1VI='").append("  and r.fid IN (" + idStr + ") ").append("  UNION ALL ").append("   SELECT DISTINCT s.fid, e.fid,s.fsourcebillid,e.fsourcebillentryid,round(DECIMAL(mbe.fqty * b.fbaseconvsrate,21,8),b.fqtyprecision),mbe.fqty ").append("  FROM T_IM_StockTransferBill  s  ").append("  INNER JOIN t_im_stocktransferbillentry e ON e.fparentid =s.fid ").append("  INNER JOIN t_im_moveinwarehsbillentry mbe ON mbe.fsourcebillentryid = e.fid ").append("  INNER JOIN t_im_moveinwarehsbill r ON mbe.fparentid = r.fid ").append("  INNER JOIN t_bd_multimeasureunit b ON mbe.fmaterialid = b.fmaterialid AND mbe.funitid = b.fmeasureunitid ").append("  WHERE s.FSOURCEBILLTYPEID='ejIZHXXTQliYCQJg9t4Re0Y+1VI='").append("  and r.fid IN (" + idStr + ") ");
        DbUtil.execute((Context)this.ctx, (String)insertSql.toString());
    }
}

