/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.control.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.common.app.DBBatchUtil;
import com.kingdee.eas.mm.common.util.ParamUtil;
import com.kingdee.eas.mm.control.ControlParamFactory;
import com.kingdee.eas.mm.control.ControlParamInfo;
import com.kingdee.eas.mm.control.ProductionOrderException;
import com.kingdee.eas.mm.control.ProductionOrderFactory;
import com.kingdee.eas.mm.control.ProductionOrderInfo;
import com.kingdee.eas.mm.control.ProductionOrderStockEntryCollection;
import com.kingdee.eas.mm.control.ProductionOrderStockEntryInfo;
import com.kingdee.eas.mm.control.app.AbstractProductionOrderFacadeControllerBean;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.log4j.Logger;

public class ProductionOrderFacadeControllerBean
extends AbstractProductionOrderFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.control.app.ProductionOrderFacadeControllerBean");
    private ControlParamInfo param = null;

    protected boolean isBaseQtyFinished(Context ctx, String id) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select FBaseCommitTotalQty-(FBaseQty*(1-ISNULL(FRPTInLowLimit,0)/100))  as result from t_mm_productionorder p ");
        sql.append("  inner join t_bd_materialplan pl on p.fmaterialid = pl.fmaterialid and p.fstorageorgunitid = pl.forgunit ");
        sql.append("  where p.fid = ? ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{id});
        try {
            while (rs.next()) {
                BigDecimal result = rs.getBigDecimal("result");
                if (!(result.doubleValue() < 0.0)) continue;
                return false;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return true;
    }

    @Override
    protected boolean _isAutoFinished(Context ctx, String id) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("storageOrgUnit.*");
        ProductionOrderInfo orderInfo = (ProductionOrderInfo)ProductionOrderFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(id), sic);
        this.param = ControlParamFactory.getLocalInstance(ctx).getParameters((OrgUnitInfo)orderInfo.getStorageOrgUnit());
        ParamUtil paramUtil = new ParamUtil(ctx, orderInfo.getStorageOrgUnit().getId().toString());
        String enabledReport = paramUtil.getEnabledProductionReportParam("true");
        if ("true".equals(enabledReport)) {
            boolean isBaseQtyFinished = this.isBaseQtyFinished(ctx, id);
            boolean isAllTaskdispComplete = this.isAllTaskdispComplete(ctx, id);
            boolean isQtyOverExpect = this.isQtyOverExpect(ctx, id);
            boolean isPickingFinished = this.isPickingFinished(ctx, id);
            if (isBaseQtyFinished && isAllTaskdispComplete && isQtyOverExpect && isPickingFinished) {
                return true;
            }
        } else {
            boolean isQtyOverExpect = this.isQtyOverExpectNR(ctx, id);
            boolean isPickingFinished = this.isPickingFinishedNR(ctx, id);
            if (isQtyOverExpect && isPickingFinished) {
                return true;
            }
        }
        return false;
    }

    protected boolean isBillClosed(Context ctx, String orderId) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("storageOrgUnit.*");
        ProductionOrderInfo orderInfo = (ProductionOrderInfo)ProductionOrderFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(orderId), sic);
        boolean isClosed = false;
        if (orderInfo.getBaseStatus().getValue() == 7) {
            isClosed = true;
        }
        return isClosed;
    }

    protected boolean isAllTaskdispComplete(Context ctx, String prdId) throws BOSException {
        if (this.param.isTaskDispBillComplete()) {
            StringBuffer sqlBuff = new StringBuffer();
            sqlBuff.append(" select t1.fid from t_mm_taskdispbill t1  ");
            sqlBuff.append(" where not exists (select * from t_mm_taskdispbill t2 where t2.fid = t1.fid and t2.fbasestatus=?)");
            sqlBuff.append("   and t1.FProductionOrderID = ? ");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlBuff.toString(), (Object[])new Object[]{new Integer(8), prdId});
            try {
                if (rs.next()) {
                    return false;
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            return true;
        }
        return true;
    }

    protected boolean isAllBackFlushed(Context ctx, String prdId) throws BOSException {
        if (this.param.isBackFlushComplete()) {
            StringBuffer chkFlushSql = new StringBuffer();
            chkFlushSql.append("select p.fid from t_mm_productionorder p ");
            chkFlushSql.append("where ((p.fBackFlushTotalQty<p.fCommitTotalQty and p.fCommitTotalQty>0) or p.fCommitTotalQty=0) ");
            chkFlushSql.append(" and  exists (select * from T_MM_ProductionOrderSEntry s where s.fparentid = p.fid and s.FIsBackFlush = 1)");
            chkFlushSql.append(" and p.fid = ?");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)chkFlushSql.toString(), (Object[])new Object[]{prdId});
            try {
                if (rs.next()) {
                    return false;
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            return true;
        }
        return true;
    }

    protected boolean isQtyOverExpect(Context ctx, String prdId) throws BOSException {
        if (this.param.isAllInStock()) {
            StringBuffer chkFlushSql = new StringBuffer();
            chkFlushSql.append(" select (p.FBaseStockTotalQty+p.FBaseTotalRepairQty+p.FBaseTotalReworkQty+p.FBaseTotalDDMQty)-(p.FBaseExpectOutputQty) as result");
            chkFlushSql.append(" from t_mm_productionorder p  ");
            chkFlushSql.append(" inner join t_bd_materialplan pl on p.fmaterialid = pl.fmaterialid and p.fstorageorgunitid = pl.forgunit ");
            chkFlushSql.append(" where p.fid = ?");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)chkFlushSql.toString(), (Object[])new Object[]{prdId});
            try {
                BigDecimal result;
                if (rs.next() && (result = rs.getBigDecimal("result")).doubleValue() >= 0.0) {
                    return true;
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            return false;
        }
        return true;
    }

    protected boolean isQtyOverExpectNR(Context ctx, String prdId) throws BOSException {
        if (this.param.isNrStock()) {
            StringBuffer chkFlushSql = new StringBuffer();
            chkFlushSql.append(" select p.FBaseStockTotalQty-p.FBaseExpectOutputQty as result");
            chkFlushSql.append(" from t_mm_productionorder p  ");
            chkFlushSql.append(" inner join t_bd_materialplan pl on p.fmaterialid = pl.fmaterialid and p.fstorageorgunitid = pl.forgunit ");
            chkFlushSql.append(" where p.fid = ?");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)chkFlushSql.toString(), (Object[])new Object[]{prdId});
            try {
                BigDecimal result;
                if (rs.next() && (result = rs.getBigDecimal("result")).doubleValue() >= 0.0) {
                    return true;
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            return false;
        }
        return true;
    }

    protected boolean isPickingFinished(Context ctx, String prdId) throws BOSException, EASBizException {
        if (this.param.isPickingSlipComplete()) {
            return this.isPickingFinishedWithoutParam(ctx, prdId);
        }
        return true;
    }

    protected boolean isPickingFinishedNR(Context ctx, String prdId) throws EASBizException, BOSException {
        if (this.param.isNrPickingSlipComplete()) {
            return this.isPickingFinishedWithoutParam(ctx, prdId);
        }
        return true;
    }

    protected boolean isPickingFinishedWithoutParam(Context ctx, String prdId) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("stockEntry.baseQty");
        sic.add("stockEntry.baseSendOutTotalQty");
        sic.add("stockEntry.baseUntreadTotalQty");
        sic.add("stockEntry.isBackFlush");
        sic.add("stockEntry.issMode");
        sic.add("stockEntry.material.id");
        sic.add("stockEntry.material.number");
        sic.add("stockEntry.materialInventory.isQuotaControl");
        sic.add("stockEntry.materialInventory.issInLowLimit");
        ProductionOrderInfo prdInfo = (ProductionOrderInfo)ProductionOrderFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(prdId), sic);
        ProductionOrderStockEntryCollection entryColls = prdInfo.getStockEntry();
        ProductionOrderStockEntryInfo entryInfo = null;
        MaterialPlanInfo planInfo = null;
        BigDecimal pickQty = null;
        BigDecimal baseQty = null;
        BigDecimal rate = new BigDecimal("1");
        for (int i = 0; i < entryColls.size(); ++i) {
            entryInfo = entryColls.get(i);
            if (entryInfo.getIssMode().getValue() != 11010 || (planInfo = entryInfo.getMaterialInventory()) == null || !((pickQty = entryInfo.getBaseSendOutTotalQty().subtract(entryInfo.getBaseUntreadTotalQty())).subtract((baseQty = entryInfo.getBaseQty()).multiply(rate = rate.subtract(planInfo.getIssInLowLimit().divide(new BigDecimal("100"), 4, 4)))).doubleValue() < 0.0)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void _dealCanAutoFinished(Context ctx, List idList) throws BOSException, EASBizException {
        if (idList.size() <= 0) {
            return;
        }
        StringBuffer reportFinishedIds = new StringBuffer();
        String currId = null;
        int count = 0;
        ArrayList<String> reportFinishedIdList = new ArrayList<String>();
        for (int i = 0; i < idList.size(); ++i) {
            currId = idList.get(i).toString();
            if (this.isreport(ctx, currId)) {
                if (i != 0) {
                    reportFinishedIds.append(",");
                }
                reportFinishedIds.append("'");
                reportFinishedIds.append(currId);
                reportFinishedIds.append("'");
                reportFinishedIdList.add(currId);
            }
            ++count;
        }
        if (reportFinishedIds.length() > 0) {
            this.reportFinished(ctx, reportFinishedIds);
            this._updatePLSStatus(ctx, reportFinishedIdList, true);
        }
    }

    protected boolean isreport(Context ctx, String id) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("storageOrgUnit.*");
        ProductionOrderInfo orderInfo = (ProductionOrderInfo)ProductionOrderFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(id), sic);
        this.param = ControlParamFactory.getLocalInstance(ctx).getParameters((OrgUnitInfo)orderInfo.getStorageOrgUnit());
        ParamUtil paramUtil = new ParamUtil(ctx, orderInfo.getStorageOrgUnit().getId().toString());
        String enabledReport = paramUtil.getEnabledProductionReportParam("true");
        return "true".equals(enabledReport);
    }

    protected void reportFinished(Context ctx, StringBuffer reportFinishedIds) throws BOSException {
        StringBuffer reportsql = new StringBuffer();
        reportsql.append("update t_mm_productionorder as po set fbasestatus = 8, FIsManualFinish = 0, FActualEndDate = ").append("(select fbizdate from ").append("(select p.fid,max(f.fbizdate) as fbizdate from t_mm_productionorder as p left outer join t_mm_finishedrpt as f on p.fid = f.FProductionOrderID group by  p.fid ) as t where po.fid = t.fid ) ").append("where fid in (").append(reportFinishedIds).append(")");
        DbUtil.execute((Context)ctx, (String)reportsql.toString());
    }

    @Override
    protected void _dealAutoFinished(Context ctx, List idList, boolean flag) throws BOSException, EASBizException {
        String currId = null;
        if (idList.size() <= 0) {
            return;
        }
        if (flag) {
            StringBuffer reportFinishedIds = new StringBuffer();
            ArrayList<String> reportFinishedIdList = new ArrayList<String>();
            StringBuffer finishedIds = new StringBuffer();
            ArrayList<String> finishedIdList = new ArrayList<String>();
            int count = 0;
            for (int i = 0; i < idList.size(); ++i) {
                currId = idList.get(i).toString();
                if (this.isManualFinish(ctx, currId) || !this._isAutoFinished(ctx, currId)) continue;
                if (this.isreport(ctx, currId)) {
                    if (this.isBillClosed(ctx, currId)) continue;
                    if (count != 0) {
                        reportFinishedIds.append(",");
                    }
                    reportFinishedIds.append("'");
                    reportFinishedIds.append(currId);
                    reportFinishedIds.append("'");
                    reportFinishedIdList.add(currId);
                    ++count;
                    continue;
                }
                if (this.isBillClosed(ctx, currId)) continue;
                if (count != 0) {
                    finishedIds.append(",");
                }
                finishedIds.append("'");
                finishedIds.append(currId);
                finishedIds.append("'");
                finishedIdList.add(currId);
                ++count;
            }
            if (reportFinishedIds.length() > 0) {
                this.reportFinished(ctx, reportFinishedIds);
                this._updatePLSStatus(ctx, reportFinishedIdList, flag);
            }
            if (finishedIds.length() > 0) {
                StringBuffer sql = new StringBuffer();
                sql.append("update t_mm_productionorder as po set fbasestatus = 8, FIsManualFinish = 0, FActualEndDate = ").append("(select fbizdate from ").append("(select rec.poid,max(rec.fbizdate) as fbizdate from t_mm_productionorder as p left outer join ").append("(select entry.fmanubillid as poid,head.fbizdate as fbizdate from t_im_manufacturerecbill as head left outer join t_im_manufacturerecbillentry ").append("as entry on head.fid = entry.fparentid) as rec ").append(" on p.fid = rec.poid  group by rec.poid) ").append("as r where po.fid=r.poid ) ").append("where fid in (").append(finishedIds).append(")");
                DbUtil.execute((Context)ctx, (String)sql.toString());
                this._updatePLSStatus(ctx, finishedIdList, flag);
            }
        } else {
            StringBuffer ids = new StringBuffer();
            for (int i = 0; i < idList.size(); ++i) {
                currId = idList.get(i).toString();
                if (this.isManualFinish(ctx, currId) || this._isAutoFinished(ctx, currId) || this.isBillClosed(ctx, currId)) continue;
                ids.append("'");
                ids.append(currId);
                ids.append("'");
                ids.append(",");
            }
            if (ids.length() > 0) {
                ids = ids.replace(ids.length() - 1, ids.length(), "");
                String sql = "update t_mm_productionorder set fbasestatus = 5,FActualEndDate = null,FIsManualFinish=0 where fid in (" + ids + ")";
                DbUtil.execute((Context)ctx, (String)sql);
                this._updatePLSStatus(ctx, idList, flag);
            }
        }
    }

    protected boolean isManualFinish(Context ctx, String currId) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("isManualFinish");
        ProductionOrderInfo orderInfo = (ProductionOrderInfo)ProductionOrderFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(currId), sic);
        boolean isIsManualFinish = orderInfo.isIsManualFinish();
        return isIsManualFinish;
    }

    @Override
    protected void _updatePLSStatus(Context ctx, List idList, boolean flag) throws BOSException, EASBizException {
        block11: {
            StringBuffer ids;
            block10: {
                if (idList == null || idList.size() <= 0) {
                    return;
                }
                ids = new StringBuffer();
                StringBuffer havSrcIDLst = new StringBuffer();
                StringBuffer writePLSESql = new StringBuffer();
                StringBuffer writePLSSql = new StringBuffer();
                StringBuffer statusLst = new StringBuffer();
                for (int i = 0; i < idList.size(); ++i) {
                    ids.append("'");
                    ids.append(idList.get(i).toString());
                    ids.append("'");
                    ids.append(",");
                }
                ids = ids.replace(ids.length() - 1, ids.length(), "");
                if (!flag) break block10;
                List status = EntryBaseStatusEnum.getEnumList();
                for (int i = 0; i < status.size(); ++i) {
                    int value = ((EntryBaseStatusEnum)status.get(i)).getValue();
                    if (value == 9 || value == 3) continue;
                    statusLst.append(value);
                    statusLst.append(",");
                }
                statusLst = statusLst.replace(statusLst.length() - 1, statusLst.length(), "");
                StringBuffer updateIdsSql = new StringBuffer();
                updateIdsSql.append(" select ");
                updateIdsSql.append(" fid, ");
                updateIdsSql.append(" fSourceBillEntryID ");
                updateIdsSql.append(" from ");
                updateIdsSql.append(" t_mm_productionOrder ");
                updateIdsSql.append(" where fSourceBillEntryID is not null");
                updateIdsSql.append(" and fid in (");
                updateIdsSql.append(ids.toString());
                updateIdsSql.append(")");
                try {
                    IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)updateIdsSql.toString());
                    while (rowSet.next()) {
                        havSrcIDLst.append("'");
                        havSrcIDLst.append(rowSet.getString("fid"));
                        havSrcIDLst.append("'");
                        havSrcIDLst.append(",");
                    }
                }
                catch (SQLException ex) {
                    logger.error((Object)ex);
                    throw new BOSException((Throwable)ex);
                }
                if (havSrcIDLst.length() <= 0) break block11;
                Connection conn = null;
                Statement stmt = null;
                try {
                    conn = EJBFactory.getConnection((Context)ctx);
                    stmt = conn.createStatement();
                    havSrcIDLst = havSrcIDLst.replace(havSrcIDLst.length() - 1, havSrcIDLst.length(), "");
                    writePLSESql.append(" update ");
                    writePLSESql.append(" t_mm_plsEntry ");
                    writePLSESql.append(" set ");
                    writePLSESql.append(" fBaseStatus=9");
                    writePLSESql.append(" where ");
                    writePLSESql.append(" fid in (");
                    writePLSESql.append("select fSourceBillEntryID from t_mm_productionOrder where fid in (" + havSrcIDLst.toString() + ")");
                    writePLSESql.append(")");
                    stmt.addBatch(writePLSESql.toString());
                    writePLSSql.append("update T_MM_ProductionLineScheduling as t ");
                    writePLSSql.append(" set ");
                    writePLSSql.append(" fBaseStatus=7");
                    writePLSSql.append(" where not exists(select t3.fid from t_mm_plsEntry as t3 where t3.FParent=t.fid ");
                    writePLSSql.append(" and t3.fBaseStatus in (");
                    writePLSSql.append(statusLst.toString());
                    writePLSSql.append("))");
                    writePLSSql.append(" and t.fid in (");
                    writePLSSql.append(" select distinct(t1.fid)");
                    writePLSSql.append(" from ");
                    writePLSSql.append(" T_MM_ProductionLineScheduling t1");
                    writePLSSql.append(" inner join t_mm_plsEntry as t2 on t2.FParent=t1.fid ");
                    writePLSSql.append(" where ");
                    writePLSSql.append(" t2.fid in (");
                    writePLSSql.append("select fSourceBillEntryID from t_mm_productionOrder where fid in (" + havSrcIDLst.toString() + ")");
                    writePLSSql.append("))");
                    stmt.addBatch(writePLSSql.toString());
                    stmt.executeBatch();
                }
                catch (SQLException ex) {
                    try {
                        logger.error((Object)ex);
                        throw new BOSException((Throwable)ex);
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(stmt, (Connection)conn);
                        throw throwable;
                    }
                }
                SQLUtils.cleanup((Statement)stmt, (Connection)conn);
                break block11;
            }
            ArrayList<String> sqlList = new ArrayList<String>();
            StringBuffer sqlBuff = new StringBuffer();
            sqlBuff.append(" update ");
            sqlBuff.append(" t_mm_plsEntry ");
            sqlBuff.append(" set ");
            sqlBuff.append(" fBaseStatus=8");
            sqlBuff.append(" where ");
            sqlBuff.append(" fid in (");
            sqlBuff.append("select fSourceBillEntryID from t_mm_productionOrder where fid in (" + ids.toString() + ")");
            sqlBuff.append(")");
            sqlList.add(sqlBuff.toString());
            sqlBuff = new StringBuffer();
            sqlBuff.append(" update T_MM_ProductionLineScheduling set fbasestatus = 2");
            sqlBuff.append(" where fid in ");
            sqlBuff.append(" (select pl.fid from T_MM_ProductionLineScheduling pl   ");
            sqlBuff.append(" inner join t_mm_plsentry pls on pl.fid = pls.FParent ");
            sqlBuff.append(" inner join t_mm_productionorder p on p.FSourceBillEntryID = pls.fid ");
            sqlBuff.append(" where p.fid in  ( " + ids.toString() + "))");
            sqlList.add(sqlBuff.toString());
            DBBatchUtil.executeBatch((Context)ctx, sqlList);
        }
    }

    @Override
    protected boolean _isClosed(Context ctx, List idList) throws BOSException, EASBizException {
        if (idList.size() <= 0) {
            return false;
        }
        StringBuffer checkIds = new StringBuffer();
        for (int i = 0; i < idList.size(); ++i) {
            if (i != 0) {
                checkIds.append(",");
            }
            checkIds.append("'");
            checkIds.append(idList.get(i).toString());
            checkIds.append("'");
        }
        String checkSql = "select top 1 fid from t_mm_productionorder where fbasestatus = 7 and fid in (" + checkIds + ")";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)checkSql);
        try {
            if (rs.next()) {
                throw new ProductionOrderException(ProductionOrderException.SRCPOCLOSED, new Object[]{""});
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    @Override
    protected String _getPOrderDataByBill(Context ctx, PeriodInfo period, Object[][] costData, String tblName) throws BOSException, EASBizException {
        String returnValue = "Failure";
        StringBuffer sqls = new StringBuffer();
        String FCalculatePeriod = period.getId().toString();
        String[] dateStrArray = this.dealPeriod(period);
        for (int i = 0; i < costData.length; ++i) {
            sqls.setLength(0);
            String storageOrgID = costData[i][0] == null ? "" : (String)costData[i][0];
            String costCenterID = costData[i][1] == null ? "" : (String)costData[i][1];
            sqls.append("insert into ").append(tblName).append(" (FCalculatePeriod,FManufactureOrderID,FCostCenterID,FMaterialID,FQty,FLot) ").append("select '").append(FCalculatePeriod).append("',t1.FID,t2.FCostCenterOrgUnitID,t1.FMaterialID,t1.FBaseQty,t1.FLotNo ").append("from T_MM_ProductionOrder t1 ").append("left join T_MM_ProductLine t2 on t1.FProductLineID=t2.FID ").append("where 1 = 1 ");
            if (!this.isEmpty(storageOrgID)) {
                sqls.append(" and t1.FStorageOrgUnitID = '").append(storageOrgID).append("'");
            }
            if (!this.isEmpty(costCenterID)) {
                sqls.append(" and t2.FCostCenterOrgUnitID = '").append(costCenterID).append("'");
            }
            if (!this.isEmpty(dateStrArray[0])) {
                sqls.append(" and t1.FActualBeginDate >= to_date('").append(dateStrArray[0]).append("') ");
            }
            if (!this.isEmpty(dateStrArray[1])) {
                sqls.append(" and t1.FActualBeginDate <= to_date('").append(dateStrArray[1]).append("') ");
            }
            DbUtil.execute((Context)ctx, (String)sqls.toString());
        }
        returnValue = "Success";
        return returnValue;
    }

    private String[] dealPeriod(PeriodInfo period) {
        Calendar ca = Calendar.getInstance();
        String bdStr = null;
        String edStr = null;
        DateFormat dtformat = BOSLocaleUtil.getDateTimeFormat();
        if (period.getEndDate() != null) {
            ca.setTime(period.getEndDate());
            ca.set(11, 23);
            ca.set(12, 59);
            ca.set(13, 59);
            edStr = dtformat.format(ca.getTime());
        }
        if (period.getBeginDate() != null) {
            bdStr = dtformat.format(period.getBeginDate());
        }
        return new String[]{bdStr, edStr};
    }

    private boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }
}

