/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.control.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.mm.basedata.ProductLineInfo;
import com.kingdee.eas.mm.common.loadmass.HashMapObject;
import com.kingdee.eas.mm.control.IProductionOrderStockEntry;
import com.kingdee.eas.mm.control.ProductionOrderStockEntryFactory;
import com.kingdee.eas.mm.control.app.AbstractProductionOrderStockEntryControllerBean;
import com.kingdee.eas.scm.im.inv.StockTransferBillEntryCollection;
import com.kingdee.eas.scm.im.inv.StockTransferBillEntryInfo;
import com.kingdee.eas.scm.im.inv.StockTransferBillFactory;
import com.kingdee.eas.scm.im.inv.StockTransferBillInfo;
import com.kingdee.eas.scm.im.inv.TransferOrderBillEntryCollection;
import com.kingdee.eas.scm.im.inv.TransferOrderBillEntryInfo;
import com.kingdee.eas.scm.im.inv.TransferOrderBillFactory;
import com.kingdee.eas.scm.im.inv.TransferOrderBillInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ProductionOrderStockEntryControllerBean
extends AbstractProductionOrderStockEntryControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.control.app.ProductionOrderStockEntryControllerBean");

    @Override
    protected IRowSet _getStockGatherByCondition(Context ctx, FilterInfo filterInfo) throws BOSException {
        IRowSet rowSet = null;
        StringBuffer sqlBuff = new StringBuffer();
        sqlBuff.append(" select distinct c.FMaterialid as material,");
        sqlBuff.append("e.FNumber as materialNumber,e.");
        sqlBuff.append(this.getFieldName(ctx));
        sqlBuff.append(" as materialName,");
        sqlBuff.append(" e.Fmodel as model,");
        sqlBuff.append(" c.Fbaseunitid as baseUnit,f.");
        sqlBuff.append(this.getFieldName(ctx));
        sqlBuff.append(" as baseUnitName,");
        sqlBuff.append(" f.FqtyPrecision as basePrecision,");
        sqlBuff.append(" d.FbaseQty as baseQty,");
        sqlBuff.append(" case when d.count > 1 then null else c.funitid end as unit,");
        sqlBuff.append(" case when d.count > 1 then null else e1.");
        sqlBuff.append(this.getFieldName(ctx));
        sqlBuff.append(" end as unitName,");
        sqlBuff.append(" case when d.count > 1 then null else e1.FQtyPrecision end as unitPrecision,");
        sqlBuff.append(" case when d.count > 1 then null else d.fqty end as qty,");
        sqlBuff.append(" c.Fdefaultwarehouseid as defaultwarehouse, ");
        sqlBuff.append(" c.Fdefaultwarehouseid as defaultwarehouseId ");
        sqlBuff.append(" from T_MM_ProductionOrderSEntry c inner join ");
        sqlBuff.append(" (select b.fMaterialid,");
        sqlBuff.append(" b.Fdefaultwarehouseid,");
        sqlBuff.append(" sum(b.fbaseQty) fbaseQty,  ");
        sqlBuff.append(" sum(b.fqty) fqty,   ");
        sqlBuff.append(" count(distinct b.funitid) count");
        sqlBuff.append(" from T_MM_ProductionOrder a inner join T_MM_ProductionOrderSEntry b");
        sqlBuff.append(" on a.fid = b.FParentID inner join T_BD_Material c on c.Fid = a.FMaterialid Where ");
        this.getFilterSQL(filterInfo, sqlBuff);
        sqlBuff.append(" group by b.fMaterialid, b.Fdefaultwarehouseid) d ");
        sqlBuff.append(" on c.fMaterialid = d.fMaterialid ");
        sqlBuff.append(" and (c.Fdefaultwarehouseid = d.Fdefaultwarehouseid or (c.Fdefaultwarehouseid is null and d.Fdefaultwarehouseid is null)) ");
        sqlBuff.append(" inner join (select distinct b.fid as fid ");
        sqlBuff.append(" from T_MM_ProductionOrder a inner join T_MM_ProductionOrderSEntry b");
        sqlBuff.append(" on a.fid = b.FParentID inner join T_BD_Material c on c.Fid = a.FMaterialid Where ");
        this.getFilterSQL(filterInfo, sqlBuff);
        sqlBuff.append(") g on c.fid=g.fid ");
        sqlBuff.append(" inner join T_BD_Material e on c.fMaterialid = e.fid");
        sqlBuff.append(" left join T_BD_MeasureUnit e1 on  e1.fid = c.funitid");
        sqlBuff.append(" left join T_BD_MeasureUnit f on c.fbaseunitid = f.fid");
        try {
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlBuff.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return rowSet;
    }

    private void getFilterSQL(FilterInfo filterInfo, StringBuffer sqlBuff) {
        for (FilterItemInfo filterItem : filterInfo.getFilterItems()) {
            if ("storageOrgUnitID".equals(filterItem.getPropertyName())) {
                sqlBuff.append(" a.FStorageOrgUnitID = '");
                sqlBuff.append((String)filterItem.getCompareValue());
                sqlBuff.append("' and");
            }
            if ("workShopID".equals(filterItem.getPropertyName())) {
                sqlBuff.append(" a.FWorkShopID = '");
                sqlBuff.append((String)filterItem.getCompareValue());
                sqlBuff.append("' and");
            }
            if ("productLineID".equals(filterItem.getPropertyName())) {
                sqlBuff.append(" (");
                Set productLineInfos = (Set)filterItem.getCompareValue();
                Iterator iterPli = productLineInfos.iterator();
                int i = 1;
                while (iterPli.hasNext()) {
                    if (i == 1) {
                        sqlBuff.append(" a.FProductLineID ='" + (String)iterPli.next() + "' ");
                    } else {
                        sqlBuff.append(" OR a.FProductLineID ='" + (String)iterPli.next() + "' ");
                    }
                    ++i;
                }
                sqlBuff.append(") and");
            }
            if ("materialNumFrom".equals(filterItem.getPropertyName())) {
                sqlBuff.append(" c.Fnumber >= '");
                sqlBuff.append((String)filterItem.getCompareValue());
                sqlBuff.append("' and");
            }
            if ("materialNumTo".equals(filterItem.getPropertyName())) {
                sqlBuff.append(" c.Fnumber <= '");
                sqlBuff.append((String)filterItem.getCompareValue());
                sqlBuff.append("'and");
            }
            if ("bizDateFrom".equals(filterItem.getPropertyName())) {
                sqlBuff.append(" to_char(a.Fbizdate,'yyyy-mm-dd') >= substring('");
                sqlBuff.append(filterItem.getCompareValue());
                sqlBuff.append("',0,10) and");
            }
            if ("bizDateTo".equals(filterItem.getPropertyName())) {
                sqlBuff.append(" to_char(a.Fbizdate,'yyyy-mm-dd') <= substring('");
                sqlBuff.append(filterItem.getCompareValue());
                sqlBuff.append("',0,10) and");
            }
            if ("productionOrderFrom".equals(filterItem.getPropertyName())) {
                sqlBuff.append(" a.Fnumber >= '");
                sqlBuff.append((String)filterItem.getCompareValue());
                sqlBuff.append("' and");
            }
            if ("productionOrderTo".equals(filterItem.getPropertyName())) {
                sqlBuff.append(" a.Fnumber <= '");
                sqlBuff.append((String)filterItem.getCompareValue());
                sqlBuff.append("' and");
            }
            if ("productionOrderStatus".equals(filterItem.getPropertyName()) && (Integer)filterItem.getCompareValue() != -1) {
                sqlBuff.append(" a.FbaseStatus = ");
                sqlBuff.append(filterItem.getCompareValue());
                sqlBuff.append(" and");
            }
            if ("isBackFlush".equals(filterItem.getPropertyName())) {
                switch ((Integer)filterItem.getCompareValue()) {
                    case 1: {
                        sqlBuff.append(" b.FIsBackFlush = ");
                        sqlBuff.append(filterItem.getCompareValue());
                        sqlBuff.append(" and");
                        break;
                    }
                    case 0: {
                        sqlBuff.append(" b.FIsBackFlush = ");
                        sqlBuff.append(filterItem.getCompareValue());
                        sqlBuff.append(" and");
                        break;
                    }
                }
            }
            if (!"isTranslateID".equals(filterItem.getPropertyName())) continue;
            switch ((Integer)filterItem.getCompareValue()) {
                case 1: {
                    sqlBuff.append(" b.FTranslateID is not null ");
                    break;
                }
                case 0: {
                    sqlBuff.append(" b.FTranslateID is null ");
                    break;
                }
                case 2: {
                    sqlBuff.append(" b.Fid is not null ");
                }
            }
        }
    }

    @Override
    protected String _getMaterialIDs(Context ctx, String orgUnitId) throws BOSException {
        StringBuffer strRet = new StringBuffer();
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("select FMaterialID from T_BD_MaterialPlan where (FStatus = ");
        sqlBuffer.append(1);
        sqlBuffer.append(" or FStatus = ");
        sqlBuffer.append(2);
        sqlBuffer.append(") and (FMaterialAttr = ");
        sqlBuffer.append(new Integer(10030));
        sqlBuffer.append(" or FMaterialAttr = ");
        sqlBuffer.append(new Integer(10050));
        sqlBuffer.append(")");
        sqlBuffer.append(" and FOrgUnit = '" + orgUnitId + "'");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString());
        if (null != rows) {
            try {
                while (rows.next()) {
                    strRet.append("," + rows.getString(1));
                }
                if (strRet.length() > 0) {
                    strRet.deleteCharAt(0);
                }
            }
            catch (SQLException e) {
                logger.error((Object)e);
            }
        }
        return strRet.toString();
    }

    @Override
    protected IRowSet _getStockProductionOrderByCondition(Context ctx, FilterInfo filterInfo) throws BOSException {
        IRowSet rowSet = null;
        StringBuffer sqlBuff = new StringBuffer();
        sqlBuff.append(" select distinct a.FNumber as number,");
        sqlBuff.append(" c.FNumber as material,c.");
        sqlBuff.append(this.getFieldName(ctx));
        sqlBuff.append(" as materialName,");
        sqlBuff.append(" a.FModel as model,d.");
        sqlBuff.append(this.getFieldName(ctx));
        sqlBuff.append(" as productionLine,e.");
        sqlBuff.append(this.getFieldName(ctx));
        sqlBuff.append(" as unit,");
        sqlBuff.append(" e.FqtyPrecision as unitPrecision,");
        sqlBuff.append(" a.FQty as qty,");
        sqlBuff.append(" to_char(a.FStartDate,'yyyy-mm-dd') as startDate,");
        sqlBuff.append(" to_char(a.FEndDate,'yyyy-mm-dd') as enddate,f.");
        sqlBuff.append(this.getFieldName(ctx));
        sqlBuff.append(" as workShop ");
        sqlBuff.append(" from T_MM_ProductionOrder a inner join T_MM_ProductionOrderSEntry b");
        sqlBuff.append(" on a.fid = b.FParentID ");
        sqlBuff.append(" inner join T_BD_Material c on a.fMaterialid = c.fid");
        sqlBuff.append(" left join T_MM_ProductLine d on a.FProductLineID = d.fid");
        sqlBuff.append(" left join T_BD_MeasureUnit e on a.FUnitID = e.fid");
        sqlBuff.append(" left join T_ORG_Admin f on a.FWorkShopID = f.fid");
        sqlBuff.append(" Where ");
        for (FilterItemInfo filterItem : filterInfo.getFilterItems()) {
            if ("storageOrgUnitID".equals(filterItem.getPropertyName())) {
                sqlBuff.append(" a.FStorageOrgUnitID = '");
                sqlBuff.append((String)filterItem.getCompareValue());
                sqlBuff.append("' and");
            }
            if ("workShopID".equals(filterItem.getPropertyName())) {
                sqlBuff.append(" a.FWorkShopID = '");
                sqlBuff.append((String)filterItem.getCompareValue());
                sqlBuff.append("' and");
            }
            if ("productLineID".equals(filterItem.getPropertyName())) {
                sqlBuff.append(" (");
                Set productLineInfos = (Set)filterItem.getCompareValue();
                Iterator iterPli = productLineInfos.iterator();
                int i = 1;
                while (iterPli.hasNext()) {
                    if (i == 1) {
                        sqlBuff.append(" a.FProductLineID ='" + (String)iterPli.next() + "' ");
                    } else {
                        sqlBuff.append(" OR a.FProductLineID ='" + (String)iterPli.next() + "' ");
                    }
                    ++i;
                }
                sqlBuff.append(") and");
            }
            if ("materialIdFrom".equals(filterItem.getPropertyName())) {
                sqlBuff.append(" c.Fnumber >= '");
                sqlBuff.append((String)filterItem.getCompareValue());
                sqlBuff.append("' and");
            }
            if ("materialIdTo".equals(filterItem.getPropertyName())) {
                sqlBuff.append(" c.Fnumber <= '");
                sqlBuff.append((String)filterItem.getCompareValue());
                sqlBuff.append("' and");
            }
            if ("bizDateFrom".equals(filterItem.getPropertyName())) {
                sqlBuff.append(" to_char(a.Fbizdate,'yyyy-mm-dd') >= substring('");
                sqlBuff.append(filterItem.getCompareValue());
                sqlBuff.append("',0,10) and");
            }
            if ("bizDateTo".equals(filterItem.getPropertyName())) {
                sqlBuff.append(" to_char(a.Fbizdate,'yyyy-mm-dd') <= substring('");
                sqlBuff.append(filterItem.getCompareValue());
                sqlBuff.append("',0,10) and");
            }
            if ("productionOrderFrom".equals(filterItem.getPropertyName())) {
                sqlBuff.append(" a.Fnumber >= '");
                sqlBuff.append((String)filterItem.getCompareValue());
                sqlBuff.append("' and");
            }
            if ("productionOrderTo".equals(filterItem.getPropertyName())) {
                sqlBuff.append(" a.Fnumber <= '");
                sqlBuff.append((String)filterItem.getCompareValue());
                sqlBuff.append("' and");
            }
            if ("productionOrderStatus".equals(filterItem.getPropertyName()) && (Integer)filterItem.getCompareValue() != -1) {
                sqlBuff.append(" a.FbaseStatus = ");
                sqlBuff.append(filterItem.getCompareValue());
                sqlBuff.append(" and");
            }
            if ("isBackFlush".equals(filterItem.getPropertyName())) {
                switch ((Integer)filterItem.getCompareValue()) {
                    case 1: {
                        sqlBuff.append(" b.FIsBackFlush = ");
                        sqlBuff.append(filterItem.getCompareValue());
                        sqlBuff.append(" and");
                        break;
                    }
                    case 0: {
                        sqlBuff.append(" b.FIsBackFlush = ");
                        sqlBuff.append(filterItem.getCompareValue());
                        sqlBuff.append(" and");
                        break;
                    }
                }
            }
            if (!"isTranslateID".equals(filterItem.getPropertyName())) continue;
            switch ((Integer)filterItem.getCompareValue()) {
                case 1: {
                    sqlBuff.append(" b.FTranslateID is not null and");
                    break;
                }
                case 0: {
                    sqlBuff.append(" b.FTranslateID is null and");
                    break;
                }
            }
        }
        sqlBuff.append(" b.FQty > 0");
        try {
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlBuff.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return rowSet;
    }

    private String getFilterSql(FilterInfo filterInfo) {
        StringBuffer sqlBuff = new StringBuffer();
        for (FilterItemInfo filterItem : filterInfo.getFilterItems()) {
            if ("storageOrgUnitID".equals(filterItem.getPropertyName())) {
                sqlBuff.append(" a.FStorageOrgUnitID = '");
                sqlBuff.append((String)filterItem.getCompareValue());
                sqlBuff.append("'");
            }
            if ("workShopID".equals(filterItem.getPropertyName())) {
                sqlBuff.append(" and a.FWorkShopID = '");
                sqlBuff.append((String)filterItem.getCompareValue());
                sqlBuff.append("'");
            }
            if ("productLineID".equals(filterItem.getPropertyName())) {
                sqlBuff.append(" and (");
                Set productLineInfos = (Set)filterItem.getCompareValue();
                Iterator iterPli = productLineInfos.iterator();
                int i = 1;
                while (iterPli.hasNext()) {
                    ProductLineInfo plInfo = (ProductLineInfo)iterPli.next();
                    if (i == 1) {
                        sqlBuff.append(" a.FProductLineID ='" + plInfo.getId().toString() + "' ");
                    } else {
                        sqlBuff.append(" OR a.FProductLineID ='" + plInfo.getId().toString() + "' ");
                    }
                    ++i;
                }
                sqlBuff.append(") ");
            }
            if ("materialIdFrom".equals(filterItem.getPropertyName())) {
                sqlBuff.append(" and c.Fnumber >= '");
                sqlBuff.append((String)filterItem.getCompareValue());
                sqlBuff.append("'");
            }
            if ("materialIdTo".equals(filterItem.getPropertyName())) {
                sqlBuff.append(" and c.Fnumber <= '");
                sqlBuff.append((String)filterItem.getCompareValue());
                sqlBuff.append("'");
            }
            if ("bizDateFrom".equals(filterItem.getPropertyName())) {
                sqlBuff.append(" and to_char(a.Fbizdate,'yyyy-mm-dd') >= substring('");
                sqlBuff.append(filterItem.getCompareValue());
                sqlBuff.append("',0,10)");
            }
            if ("bizDateTo".equals(filterItem.getPropertyName())) {
                sqlBuff.append(" and to_char(a.Fbizdate,'yyyy-mm-dd') <= substring('");
                sqlBuff.append(filterItem.getCompareValue());
                sqlBuff.append("',0,10)");
            }
            if ("productionOrderFrom".equals(filterItem.getPropertyName())) {
                sqlBuff.append(" and a.Fnumber >= '");
                sqlBuff.append((String)filterItem.getCompareValue());
                sqlBuff.append("'");
            }
            if ("productionOrderTo".equals(filterItem.getPropertyName())) {
                sqlBuff.append(" and a.Fnumber <= '");
                sqlBuff.append((String)filterItem.getCompareValue());
                sqlBuff.append("'");
            }
            if ("productionOrderStatus".equals(filterItem.getPropertyName()) && (Integer)filterItem.getCompareValue() != -1) {
                sqlBuff.append(" and a.FbaseStatus = ");
                sqlBuff.append(filterItem.getCompareValue());
            }
            if ("isBackFlush".equals(filterItem.getPropertyName())) {
                switch ((Integer)filterItem.getCompareValue()) {
                    case 1: {
                        sqlBuff.append(" and b.FIsBackFlush = ");
                        sqlBuff.append(filterItem.getCompareValue());
                        break;
                    }
                    case 0: {
                        sqlBuff.append(" and b.FIsBackFlush = ");
                        sqlBuff.append(filterItem.getCompareValue());
                        break;
                    }
                }
            }
            if ("isTranslateID".equals(filterItem.getPropertyName())) {
                switch ((Integer)filterItem.getCompareValue()) {
                    case 1: {
                        sqlBuff.append(" and b.FTranslateID is not null ");
                        break;
                    }
                    case 0: {
                        sqlBuff.append(" and b.FTranslateID is null ");
                        break;
                    }
                }
            }
            if ("materialId".equals(filterItem.getPropertyName())) {
                sqlBuff.append(" and b.FMaterialid = '");
                sqlBuff.append((String)filterItem.getCompareValue());
                sqlBuff.append("'");
            }
            if (!"defaultWarehouseId".equals(filterItem.getPropertyName())) continue;
            String warehouseId = (String)filterItem.getCompareValue();
            if (warehouseId == null || warehouseId.equals("")) {
                sqlBuff.append(" and b.Fdefaultwarehouseid is null ");
                continue;
            }
            sqlBuff.append(" and b.Fdefaultwarehouseid = '");
            sqlBuff.append(warehouseId);
            sqlBuff.append("'");
        }
        return sqlBuff.toString();
    }

    @Override
    protected void _backWriteTransferBill(Context ctx, String transferBillId, FilterInfo filterInfo, boolean orderOrStockFlg, String transferNumber) throws BOSException, EASBizException {
        try {
            StringBuffer sqlBuff = new StringBuffer();
            if (orderOrStockFlg) {
                sqlBuff.append(" insert into T_MM_StockEntryToBillEntry (FBillId,FBillEntryId,FStockId,FStockEntryId) ");
                sqlBuff.append("select c.FParentID,c.fid,d.fStockId,d.fStockEntryId ");
                sqlBuff.append("from T_IM_StockTransferBillEntry c inner join (");
                sqlBuff.append(" select distinct a.fid as fStockId,b.fid as fStockEntryId, b.FMaterialid, b.Fdefaultwarehouseid");
                sqlBuff.append(" from T_MM_ProductionOrder a inner join T_MM_ProductionOrderSEntry b");
                sqlBuff.append(" on a.fid = b.FParentID inner join T_BD_Material c on c.Fid = a.FMaterialid Where ");
                sqlBuff.append(this.getFilterSql(filterInfo));
                sqlBuff.append(") d on c.FMaterialid = d.FMaterialid");
                sqlBuff.append(" and c.FParentID= '");
                sqlBuff.append(transferBillId);
                sqlBuff.append("'");
            } else if (!orderOrStockFlg) {
                sqlBuff.append(" insert into T_MM_StockEntryTOBillEntry (FBillId,FBillEntryId,FStockId,FStockEntryId) ");
                sqlBuff.append("select c.FParentID,c.fid,d.fStockId,d.fStockEntryId ");
                sqlBuff.append("from T_IM_TransferOrderBillEntry c inner join (");
                sqlBuff.append(" select distinct a.fid as fStockId,b.fid as fStockEntryId, b.FMaterialid, b.Fdefaultwarehouseid");
                sqlBuff.append(" from T_MM_ProductionOrder a inner join T_MM_ProductionOrderSEntry b");
                sqlBuff.append(" on a.fid = b.FParentID inner join T_BD_Material c on c.Fid = a.FMaterialid Where ");
                sqlBuff.append(this.getFilterSql(filterInfo));
                sqlBuff.append(") d on c.FMaterialid = d.FMaterialid");
                sqlBuff.append(" and c.FParentID= '");
                sqlBuff.append(transferBillId);
                sqlBuff.append("'");
            }
            DbUtil.execute((Context)ctx, (String)sqlBuff.toString());
            sqlBuff = new StringBuffer();
            sqlBuff.append(" update T_MM_ProductionOrderSEntry set FTranslateID ='");
            sqlBuff.append(transferNumber);
            sqlBuff.append("' where fid in (");
            sqlBuff.append(" select distinct b.fid");
            sqlBuff.append(" from T_MM_ProductionOrder a inner join T_MM_ProductionOrderSEntry b");
            sqlBuff.append(" on a.fid = b.FParentID inner join T_BD_Material c on c.Fid = a.FMaterialid Where ");
            sqlBuff.append(this.getFilterSql(filterInfo));
            sqlBuff.append(")");
            DbUtil.execute((Context)ctx, (String)sqlBuff.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected boolean _checkTransferBillExisted(Context ctx, FilterInfo filterInfo) throws BOSException, EASBizException {
        try {
            StringBuffer sqlBuff = new StringBuffer();
            sqlBuff.append(" select distinct c.FMaterialid as material,");
            sqlBuff.append("e.FNumber as materialNumber,e.");
            sqlBuff.append(this.getFieldName(ctx));
            sqlBuff.append(" as materialName,");
            sqlBuff.append(" e.Fmodel as model,");
            sqlBuff.append(" c.Fbaseunitid as baseUnit,f.");
            sqlBuff.append(this.getFieldName(ctx));
            sqlBuff.append(" as baseUnitName,");
            sqlBuff.append(" d.FbaseQty as baseQty,");
            sqlBuff.append(" case when d.count > 1 then null else c.funitid end as unit,");
            sqlBuff.append(" case when d.count > 1 then null else e1.");
            sqlBuff.append(this.getFieldName(ctx));
            sqlBuff.append(" end as unitName,");
            sqlBuff.append(" case when d.count > 1 then null else d.fqty end as qty,");
            sqlBuff.append(" c.Fdefaultwarehouseid as defaultwarehouse, ");
            sqlBuff.append(" c.Fdefaultwarehouseid as defaultwarehouseId ");
            sqlBuff.append(" from T_MM_ProductionOrderSEntry c inner join ");
            sqlBuff.append(" (select b.fMaterialid,");
            sqlBuff.append(" b.Fdefaultwarehouseid,");
            sqlBuff.append(" sum(b.fbaseQty) fbaseQty,  ");
            sqlBuff.append(" sum(b.fqty) fqty,   ");
            sqlBuff.append(" count(distinct b.funitid) count");
            sqlBuff.append(" from T_MM_ProductionOrder a inner join T_MM_ProductionOrderSEntry b");
            sqlBuff.append(" on a.fid = b.FParentID inner join T_BD_Material c on c.Fid = a.FMaterialid Where ");
            String checkNum = "-1";
            for (FilterItemInfo filterItem : filterInfo.getFilterItems()) {
                String beforeNumber;
                if ("storageOrgUnitID".equals(filterItem.getPropertyName())) {
                    sqlBuff.append(" a.FStorageOrgUnitID = '");
                    sqlBuff.append((String)filterItem.getCompareValue());
                    sqlBuff.append("'");
                }
                if ("workShopID".equals(filterItem.getPropertyName())) {
                    sqlBuff.append(" and a.FWorkShopID = '");
                    sqlBuff.append((String)filterItem.getCompareValue());
                    sqlBuff.append("'");
                }
                if ("productLineID".equals(filterItem.getPropertyName())) {
                    sqlBuff.append(" and (");
                    Set productLineInfos = (Set)filterItem.getCompareValue();
                    Iterator iterPli = productLineInfos.iterator();
                    int i = 1;
                    while (iterPli.hasNext()) {
                        if (i == 1) {
                            sqlBuff.append(" a.FProductLineID ='" + (String)iterPli.next() + "' ");
                        } else {
                            sqlBuff.append(" OR a.FProductLineID ='" + (String)iterPli.next() + "' ");
                        }
                        ++i;
                    }
                    sqlBuff.append(") ");
                }
                if ("materialNumFrom".equals(filterItem.getPropertyName())) {
                    sqlBuff.append(" and c.Fnumber >= '");
                    sqlBuff.append((String)filterItem.getCompareValue());
                    sqlBuff.append("'");
                }
                if ("materialNumTo".equals(filterItem.getPropertyName())) {
                    sqlBuff.append(" and c.Fnumber <= '");
                    sqlBuff.append((String)filterItem.getCompareValue());
                    sqlBuff.append("'");
                }
                if ("bizDateFrom".equals(filterItem.getPropertyName())) {
                    sqlBuff.append(" and to_char(a.Fbizdate,'yyyy-mm-dd') >= substring('");
                    sqlBuff.append(filterItem.getCompareValue());
                    sqlBuff.append("',0,10)");
                }
                if ("bizDateTo".equals(filterItem.getPropertyName())) {
                    sqlBuff.append(" and to_char(a.Fbizdate,'yyyy-mm-dd') <= substring('");
                    sqlBuff.append(filterItem.getCompareValue());
                    sqlBuff.append("',0,10)");
                }
                if ("productionOrderFrom".equals(filterItem.getPropertyName())) {
                    sqlBuff.append(" and a.Fnumber >= '");
                    sqlBuff.append((String)filterItem.getCompareValue());
                    sqlBuff.append("'");
                }
                if ("productionOrderTo".equals(filterItem.getPropertyName())) {
                    sqlBuff.append(" and a.Fnumber <= '");
                    sqlBuff.append((String)filterItem.getCompareValue());
                    sqlBuff.append("'");
                }
                if ("productionOrderStatus".equals(filterItem.getPropertyName()) && (Integer)filterItem.getCompareValue() != -1) {
                    sqlBuff.append(" and a.FbaseStatus = ");
                    sqlBuff.append(filterItem.getCompareValue());
                }
                if ("isBackFlush".equals(filterItem.getPropertyName())) {
                    switch ((Integer)filterItem.getCompareValue()) {
                        case 1: {
                            sqlBuff.append(" and b.FIsBackFlush = ");
                            sqlBuff.append(filterItem.getCompareValue());
                            break;
                        }
                        case 0: {
                            sqlBuff.append(" and b.FIsBackFlush = ");
                            sqlBuff.append(filterItem.getCompareValue());
                            break;
                        }
                    }
                }
                if ("isTranslateID".equals(filterItem.getPropertyName())) {
                    switch ((Integer)filterItem.getCompareValue()) {
                        case 1: {
                            sqlBuff.append(" and b.FTranslateID is not null ");
                            break;
                        }
                        case 0: {
                            sqlBuff.append(" and b.FTranslateID is null ");
                            break;
                        }
                    }
                }
                if ("materialId".equals(filterItem.getPropertyName())) {
                    sqlBuff.append(" and b.FMaterialid = '");
                    sqlBuff.append((String)filterItem.getCompareValue());
                    sqlBuff.append("'");
                }
                if ("defaultWarehouseId".equals(filterItem.getPropertyName())) {
                    String warehouseId = (String)filterItem.getCompareValue();
                    if (warehouseId == null || warehouseId.equals("")) {
                        sqlBuff.append(" and b.Fdefaultwarehouseid is null ");
                    } else {
                        sqlBuff.append(" and b.Fdefaultwarehouseid = '");
                        sqlBuff.append(warehouseId);
                        sqlBuff.append("'");
                    }
                }
                if (!"beforeNumber".equals(filterItem.getPropertyName()) || (beforeNumber = (String)filterItem.getCompareValue()) == null || beforeNumber.equals("")) continue;
                checkNum = beforeNumber;
            }
            sqlBuff.append(" group by b.fMaterialid, b.Fdefaultwarehouseid) d ");
            sqlBuff.append(" on c.fMaterialid = d.fMaterialid ");
            sqlBuff.append(" and (c.Fdefaultwarehouseid = d.Fdefaultwarehouseid or (c.Fdefaultwarehouseid is null and d.Fdefaultwarehouseid is null)) ");
            sqlBuff.append(" inner join (select distinct b.fid as fid ");
            sqlBuff.append(" from T_MM_ProductionOrder a inner join T_MM_ProductionOrderSEntry b");
            sqlBuff.append(" on a.fid = b.FParentID inner join T_BD_Material c on c.Fid = a.FMaterialid Where ");
            this.getFilterSQL(filterInfo, sqlBuff);
            sqlBuff.append(") g on c.fid=g.fid ");
            sqlBuff.append(" inner join T_BD_Material e on c.fMaterialid = e.fid");
            sqlBuff.append(" left join T_BD_MeasureUnit e1 on  e1.fid = c.funitid");
            sqlBuff.append(" left join T_BD_MeasureUnit f on c.fbaseunitid = f.fid");
            IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sqlBuff.toString());
            if (rows == null || rows.size() == 0) {
                return true;
            }
            while (rows.next()) {
                BigDecimal baseQty = rows.getBigDecimal("baseQty");
                if (baseQty.equals(new BigDecimal(checkNum))) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected boolean _backWriteDeleteTransferBill(Context ctx, String billId, Collection entryIds) throws BOSException, EASBizException {
        boolean bRet = false;
        StringBuffer sqlBuff = null;
        try {
            if (entryIds == null || entryIds.isEmpty()) {
                sqlBuff = new StringBuffer();
                sqlBuff.append(" UPDATE T_MM_ProductionOrderSEntry  set FTranslateID = null ");
                sqlBuff.append(" WHERE FId in (select a.FStockEntryId from T_MM_StockEntryToBillEntry a ");
                sqlBuff.append(" inner join T_MM_ProductionOrderSEntry b on a.FStockEntryId = b.Fid ");
                sqlBuff.append(" and a.FStockId = b.FParentID ");
                sqlBuff.append(" where a.FBillId ='");
                sqlBuff.append(billId);
                sqlBuff.append("')");
                DbUtil.execute((Context)ctx, (String)sqlBuff.toString());
                sqlBuff = new StringBuffer();
                sqlBuff.append(" delete from T_MM_StockEntryToBillEntry ");
                sqlBuff.append(" where FBillId ='");
                sqlBuff.append(billId);
                sqlBuff.append("'");
                DbUtil.execute((Context)ctx, (String)sqlBuff.toString());
            } else {
                Iterator it = entryIds.iterator();
                while (it.hasNext()) {
                    String strBillEntryId = it.next().toString();
                    sqlBuff = new StringBuffer();
                    sqlBuff.append(" UPDATE T_MM_ProductionOrderSEntry  set FTranslateID = null ");
                    sqlBuff.append(" WHERE FId in (select a.FStockEntryId from T_MM_StockEntryToBillEntry a ");
                    sqlBuff.append(" inner join T_MM_ProductionOrderSEntry b on a.FStockEntryId = b.Fid ");
                    sqlBuff.append(" and a.FStockId = b.FParentID ");
                    sqlBuff.append(" where a.FBillId ='");
                    sqlBuff.append(billId);
                    sqlBuff.append("' and a.FBillEntryId ='");
                    sqlBuff.append(strBillEntryId);
                    sqlBuff.append("')");
                    DbUtil.execute((Context)ctx, (String)sqlBuff.toString());
                    sqlBuff = new StringBuffer();
                    sqlBuff.append(" delete from T_MM_StockEntryToBillEntry ");
                    sqlBuff.append(" where FBillId ='");
                    sqlBuff.append(billId);
                    sqlBuff.append("' and FBillEntryId ='");
                    sqlBuff.append(strBillEntryId);
                    sqlBuff.append("'");
                    DbUtil.execute((Context)ctx, (String)sqlBuff.toString());
                }
            }
            bRet = true;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return bRet;
    }

    private String getFieldName(Context ctx) {
        return "FName_" + ctx.getLocale();
    }

    @Override
    protected void _addNewAndBackWrite(Context ctx, IObjectValue model, FilterInfo filterInfo) throws BOSException, EASBizException {
        try {
            IObjectPK id = StockTransferBillFactory.getLocalInstance((Context)ctx).addnew((CoreBaseInfo)((StockTransferBillInfo)model));
            String strId = id.toString();
            StockTransferBillEntryCollection stockTransferBillEntryCollection = ((StockTransferBillInfo)model).getEntry();
            for (StockTransferBillEntryInfo stockTransferBillEntryInfo : stockTransferBillEntryCollection) {
                String materialId = stockTransferBillEntryInfo.getMaterial().getId().toString();
                String defaultWarehouse = stockTransferBillEntryInfo.getManuWarehouseId();
                FilterInfo backFilterInfo = (FilterInfo)filterInfo.clone();
                FilterItemCollection items = backFilterInfo.getFilterItems();
                items.add(new FilterItemInfo("materialId", (Object)materialId, CompareType.EQUALS));
                items.add(new FilterItemInfo("defaultWarehouseId", (Object)defaultWarehouse, CompareType.EQUALS));
                ProductionOrderStockEntryFactory.getLocalInstance(ctx).backWriteTransferBill(strId, backFilterInfo, true, ((StockTransferBillInfo)model).getNumber());
            }
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _addNew2AndBackWrite(Context ctx, IObjectValue model, FilterInfo filterInfo) throws BOSException, EASBizException {
        try {
            IObjectPK id = TransferOrderBillFactory.getLocalInstance((Context)ctx).addnew((CoreBaseInfo)((TransferOrderBillInfo)model));
            String strId = id.toString();
            TransferOrderBillEntryCollection transferOrderBillEntryCollection = ((TransferOrderBillInfo)model).getEntry();
            for (TransferOrderBillEntryInfo transferOrderBillEntryInfo : transferOrderBillEntryCollection) {
                String materialId = transferOrderBillEntryInfo.getMaterial().getId().toString();
                String defaultWarehouse = transferOrderBillEntryInfo.getManuWarehouseId();
                FilterInfo backFilterInfo = (FilterInfo)filterInfo.clone();
                FilterItemCollection items = backFilterInfo.getFilterItems();
                items.add(new FilterItemInfo("materialId", (Object)materialId, CompareType.EQUALS));
                items.add(new FilterItemInfo("defaultWarehouseId", (Object)defaultWarehouse, CompareType.EQUALS));
                ProductionOrderStockEntryFactory.getLocalInstance(ctx).backWriteTransferBill(strId, backFilterInfo, false, ((TransferOrderBillInfo)model).getNumber());
            }
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected int _totleAddNewAndBackWrite(Context ctx, HashMapObject collection, FilterInfo filterInfo, String currentOrgUnitId) throws BOSException, EASBizException {
        int successNum = 0;
        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        IProductionOrderStockEntry ipos = ProductionOrderStockEntryFactory.getLocalInstance(ctx);
        Enumeration collectionList = collection.keys();
        while (collectionList.hasMoreElements()) {
            String number;
            String key = (String)collectionList.nextElement();
            HashMapObject detailMap = (HashMapObject)collection.get(key);
            String billType = (String)detailMap.get("billType");
            if (billType.equals("1")) {
                number = codingRuleManager.getNumber((IObjectValue)new StockTransferBillInfo(), currentOrgUnitId);
                StockTransferBillInfo stockTransferBillInfo = (StockTransferBillInfo)detailMap.get("stockTransferBillInfo");
                stockTransferBillInfo.setNumber(number);
                ipos.addNewAndBackWrite(stockTransferBillInfo, filterInfo);
                ++successNum;
                continue;
            }
            if (!billType.equals("0")) continue;
            number = codingRuleManager.getNumber((IObjectValue)new TransferOrderBillInfo(), currentOrgUnitId);
            TransferOrderBillInfo transferOrderBillInfo = (TransferOrderBillInfo)detailMap.get("transferOrderBillInfo");
            transferOrderBillInfo.setNumber(number);
            ipos.addNew2AndBackWrite(transferOrderBillInfo, filterInfo);
            ++successNum;
        }
        return successNum;
    }

    @Override
    protected Map _getInventoryQty(Context ctx, FilterInfo filterInfo, String[] materialIds, String[] wareHouseIds, Date requireDate) throws BOSException, EASBizException {
        String wareHouseId;
        String materialId;
        int i;
        HashMap<String, BigDecimal> result = new HashMap<String, BigDecimal>();
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
        String expDate = sf.format(requireDate);
        StringBuffer sqlBuff1 = new StringBuffer();
        StringBuffer sqlBuff2 = new StringBuffer();
        StringBuffer sqlDymicBuff = new StringBuffer();
        sqlBuff1.append("select tii.FWarehouseID as fWarehouseID,tii.FMaterialID as fMaterialID, ISNULL(sum(tii.FBaseQty), 0) as FBaseQty from T_IM_Inventory tii  left join T_DB_WAREHOUSE tdw on tii.FWarehouseID=tdw.FID");
        if (requireDate != null) {
            sqlBuff1.append(" LEFT OUTER JOIN T_BD_MaterialInventory tbmi on tii.FMaterialID = tbmi.FMaterialID AND tii.FStorageOrgUnitID = tbmi.FOrgUnit ");
            sqlBuff1.append(" LEFT OUTER JOIN T_IM_DateOfMinDurability tidd on tii.FLot = tidd.FLot AND tii.FStorageOrgUnitID = tidd.FStorageOrgUnitID AND tii.FMaterialID= tidd.FMaterialID ");
        }
        sqlBuff1.append(" where tii.FStorageOrgUnitID = '");
        sqlBuff1.append((String)((FilterItemInfo)filterInfo.getFilterItems().getObject(0)).getCompareValue());
        sqlBuff1.append("'");
        sqlBuff1.append(" and tii.FStoreTypeID = '181875d5-0105-1000-e000-0111c0a812fd97D461A6'");
        sqlBuff1.append(" and tii.FStoreStatusID = '181875d5-0105-1000-e000-012ec0a812fd62A73FA5'");
        sqlBuff1.append(" and tdw.FTransState in ('1','2')");
        if (requireDate != null) {
            sqlBuff1.append(" and ((tbmi.FIsPeriodValid = 1 AND to_char(tidd.FEXP,'yyyy-mm-dd')>='" + expDate + "') or (tbmi.FIsPeriodValid != 1))");
        }
        sqlBuff1.append(" and (");
        sqlBuff2.append(" ) group by tii.FWarehouseID,tii.FMaterialID");
        for (i = 0; i < materialIds.length; ++i) {
            materialId = materialIds[i];
            wareHouseId = wareHouseIds[i];
            sqlDymicBuff.append(" tii.FWarehouseID='" + wareHouseId + "'");
            sqlDymicBuff.append(" and tii.FMaterialID ='" + materialId + "'");
            if (i == materialIds.length - 1 || i != 0 && i % 9 == 0) {
                StringBuffer sqlBuff = new StringBuffer("").append(sqlBuff1).append(sqlDymicBuff).append(sqlBuff2);
                IRowSet rowSet = null;
                try {
                    rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlBuff.toString());
                    if (rowSet != null && rowSet.size() != 0) {
                        while (rowSet.next()) {
                            BigDecimal inventoryQty = rowSet.getBigDecimal("FBaseQty");
                            String warehouseKey = rowSet.getString("fWarehouseID");
                            String materialKey = rowSet.getString("fMaterialID");
                            if (result.containsKey(materialKey + warehouseKey)) continue;
                            result.put(materialKey + warehouseKey, inventoryQty);
                        }
                    }
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
                sqlDymicBuff = new StringBuffer();
                continue;
            }
            sqlDymicBuff.append("or");
        }
        for (i = 0; i < materialIds.length; ++i) {
            materialId = materialIds[i];
            wareHouseId = wareHouseIds[i];
            if (result.containsKey(materialId + wareHouseId)) continue;
            result.put(materialId + wareHouseId, new BigDecimal(0));
        }
        return result;
    }

    @Override
    protected Map _getInventoryQtys(Context ctx, FilterInfo filterInfo, String materialId, String wareHouseId, Date requireDate) throws BOSException, EASBizException {
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
        String expDate = sf.format(requireDate);
        StringBuffer sqlBuff = new StringBuffer();
        sqlBuff.append("select tii.FWarehouseID as fWarehouseID,tii.FMaterialID as fMaterialID, ISNULL(sum(tii.FBaseQty), 0) as FBaseQty from T_IM_Inventory tii  left join T_DB_WAREHOUSE tdw on tii.FWarehouseID=tdw.FID");
        sqlBuff.append(" LEFT OUTER JOIN T_MM_PlanRangeParam D on tii.FStorageOrgUnitID = D.FStorageOrgUnitID ");
        sqlBuff.append(" LEFT OUTER JOIN T_MM_PlanRangeWarehs E on E.FParentID = D.FID ");
        if (requireDate != null) {
            sqlBuff.append(" LEFT OUTER JOIN T_BD_MaterialInventory tbmi on tii.FMaterialID = tbmi.FMaterialID AND tii.FStorageOrgUnitID = tbmi.FOrgUnit ");
            sqlBuff.append(" LEFT OUTER JOIN T_IM_DateOfMinDurability tidd on tii.FLot = tidd.FLot AND tii.FStorageOrgUnitID = tidd.FStorageOrgUnitID AND tii.FMaterialID= tidd.FMaterialID ");
        }
        sqlBuff.append(" where ");
        sqlBuff.append(" ( D.FID is null ");
        sqlBuff.append("   OR ( ");
        sqlBuff.append("((D.FIsNormal  =1 AND  tii.FStoreTypeID = '181875d5-0105-1000-e000-0111c0a812fd97D461A6') ");
        sqlBuff.append(" OR (D.FIsSupplierBorrow =1 AND tii.FStoreTypeID = '181875d5-0105-1000-e000-0120c0a812fd97D461A6') ");
        sqlBuff.append(" OR (D.FIsSupplierStorage =1 AND tii.FStoreTypeID = '181875d5-0105-1000-e000-0114c0a812fd97D461A6')) ");
        sqlBuff.append(" AND ");
        sqlBuff.append("((D.FIsAvailable  =1 AND  tii.FStoreStatusID = '181875d5-0105-1000-e000-012ec0a812fd62A73FA5') ");
        sqlBuff.append(" OR (D.FIsProvisionalFreeze =1 AND tii.FStoreStatusID = '181875d5-1105-1000-e000-013dc0a812fd62A73FA5') ");
        sqlBuff.append(" OR (D.FIsOutGoodsCheck =1 AND tii.FStoreStatusID = '181875d5-0105-1000-e000-0134c0a812fd62A73FA5') ");
        sqlBuff.append(" OR (D.FIsCheckStorageFreeze =1 AND tii.FStoreStatusID = '181875d5-2105-1000-e000-013dc0a812fd62A73FA5')) ");
        sqlBuff.append(" AND ");
        sqlBuff.append("(D.FIsAllStorage = 1 ");
        sqlBuff.append(" OR (D.FIsAllStorage = 0 AND tii.FWarehouseID = E.FWarhouseID)) ");
        sqlBuff.append("   )) ");
        sqlBuff.append(" and tii.FStorageOrgUnitID = '");
        sqlBuff.append((String)((FilterItemInfo)filterInfo.getFilterItems().getObject(0)).getCompareValue());
        sqlBuff.append("'");
        sqlBuff.append(" and tii.FStoreTypeID = '181875d5-0105-1000-e000-0111c0a812fd97D461A6'");
        sqlBuff.append(" and tii.FStoreStatusID = '181875d5-0105-1000-e000-012ec0a812fd62A73FA5'");
        sqlBuff.append(" and tdw.FTransState in ('1','2')");
        if (requireDate != null) {
            sqlBuff.append(" and ((tbmi.FIsPeriodValid = 1 AND to_char(tidd.FEXP,'yyyy-mm-dd')>='" + expDate + "') or (tbmi.FIsPeriodValid != 1))");
        }
        sqlBuff.append(" and tii.FWarehouseID='" + wareHouseId + "'");
        sqlBuff.append(" and tii.FMaterialID ='" + materialId + "'");
        sqlBuff.append(" group by tii.FWarehouseID,tii.FMaterialID");
        IRowSet rowSet = null;
        try {
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlBuff.toString());
            if (rowSet == null || rowSet.size() == 0) {
                HashMap<String, BigDecimal> result = new HashMap<String, BigDecimal>();
                result.put(materialId + wareHouseId, new BigDecimal(0));
                return result;
            }
            HashMap<String, BigDecimal> result = new HashMap<String, BigDecimal>();
            while (rowSet.next()) {
                BigDecimal inventoryQty = rowSet.getBigDecimal("FBaseQty");
                result.put(materialId + wareHouseId, inventoryQty);
            }
            return result;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected Map _getProductStageQty(Context ctx, FilterInfo filterInfo) throws BOSException, EASBizException {
        StringBuffer sqlBuff = new StringBuffer();
        sqlBuff.append(" select tps.FDefaultWarehouseID as warehouseID,tps.FMaterialid as materialid, ISNULL(sum(tps.FBaseQty - tps.FBaseSendOutTotalQty + tps.FBaseUntreadTotalQty),0) as baseTakeUpQty  from T_MM_ProductionOrderSEntry tps ");
        sqlBuff.append(" inner join T_MM_ProductionOrder tpo on tpo.Fid=tps.FParentId");
        sqlBuff.append(" inner join (");
        sqlBuff.append("select distinct b.FMaterialid as materialId,");
        sqlBuff.append("b.FDefaultWarehouseID as warehouseId ");
        sqlBuff.append(" from T_MM_ProductionOrder a inner join T_MM_ProductionOrderSEntry b");
        sqlBuff.append(" on a.fid = b.FParentID ");
        sqlBuff.append(" inner join T_BD_Material c");
        sqlBuff.append(" on c.Fid = a.FMaterialid Where ");
        this.getFilterSQL(filterInfo, sqlBuff);
        sqlBuff.append(") g on tps.FDefaultWarehouseID=g.warehouseId and tps.FMaterialid=g.materialId");
        sqlBuff.append(" where tpo.FBaseStatus in (");
        sqlBuff.append("4,");
        sqlBuff.append("5)");
        sqlBuff.append(" and tps.FTranslateID is not null");
        sqlBuff.append(" group by tps.FDefaultWarehouseID,tps.FMaterialid");
        IRowSet rowSet = null;
        try {
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlBuff.toString());
            if (rowSet == null || rowSet.size() == 0) {
                return new HashMap();
            }
            HashMap<String, BigDecimal> result = new HashMap<String, BigDecimal>();
            while (rowSet.next()) {
                BigDecimal baseTakeUpQty = rowSet.getBigDecimal("baseTakeUpQty");
                String warehouseID = rowSet.getString("warehouseID");
                String materialid = rowSet.getString("materialid");
                result.put(materialid + warehouseID, baseTakeUpQty);
            }
            return result;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected Map _getProductStageQtyS(Context ctx, String materialId, String wareHouseId) throws BOSException, EASBizException {
        StringBuffer sqlBuff = new StringBuffer();
        sqlBuff.append(" select tps.FDefaultWarehouseID as warehouseID,tps.FMaterialid as materialid, ISNULL(sum(tps.FBaseQty - tps.FBaseSendOutTotalQty + tps.FBaseUntreadTotalQty), 0) as baseTakeUpQty  from T_MM_ProductionOrderSEntry tps ");
        sqlBuff.append(" inner join T_MM_ProductionOrder tpo on tpo.Fid=tps.FParentId");
        sqlBuff.append(" where tpo.FBaseStatus in (");
        sqlBuff.append("4,");
        sqlBuff.append("5)");
        sqlBuff.append(" and tps.FTranslateID is not null");
        sqlBuff.append(" and tps.FDefaultWarehouseID='" + wareHouseId + "'");
        sqlBuff.append(" and tps.FMaterialid='" + materialId + "'");
        sqlBuff.append(" group by tps.FDefaultWarehouseID,tps.FMaterialid");
        IRowSet rowSet = null;
        try {
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlBuff.toString());
            if (rowSet == null || rowSet.size() == 0) {
                HashMap<String, BigDecimal> result = new HashMap<String, BigDecimal>();
                result.put(materialId + wareHouseId, new BigDecimal(0));
                return result;
            }
            HashMap<String, BigDecimal> result = new HashMap<String, BigDecimal>();
            while (rowSet.next()) {
                BigDecimal baseTakeUpQty = rowSet.getBigDecimal("baseTakeUpQty");
                String warehouseID = rowSet.getString("warehouseID");
                String materialid = rowSet.getString("materialid");
                result.put(materialid + warehouseID, baseTakeUpQty);
            }
            return result;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected IRowSet _getStockGatherByCondition(Context ctx, FilterInfo filterInfo, Date requireDate) throws BOSException, EASBizException {
        IRowSet rowSet = null;
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
        String expDate = sf.format(requireDate);
        StringBuffer sqlBuff = new StringBuffer();
        sqlBuff.append(" select distinct c.FMaterialid as material,");
        sqlBuff.append("e.FNumber as materialNumber,e.");
        sqlBuff.append(this.getFieldName(ctx));
        sqlBuff.append(" as materialName,");
        sqlBuff.append(" e.Fmodel as model,");
        sqlBuff.append(" c.Fbaseunitid as baseUnit,f.");
        sqlBuff.append(this.getFieldName(ctx));
        sqlBuff.append(" as baseUnitName,");
        sqlBuff.append(" multiBaseUnit.FqtyPrecision as basePrecision,");
        sqlBuff.append(" d.FbaseQty as baseQty,");
        sqlBuff.append("  k.FProductUnitID as unit,");
        sqlBuff.append(" productUnit.");
        sqlBuff.append(this.getFieldName(ctx));
        sqlBuff.append(" as unitName,");
        sqlBuff.append(" multiProductUnit.FQtyPrecision as unitPrecision,");
        sqlBuff.append(" ISNULL(ROUND(decimal(d.FbaseQty, 21, 8)/multiProductUnit.FBaseConvsRate,multiProductUnit.fQtyPrecision), 0) as qty, ");
        sqlBuff.append(" c.Fdefaultwarehouseid as defaultwarehouse, ");
        sqlBuff.append(" c.Fdefaultwarehouseid as defaultwarehouseId, ");
        sqlBuff.append(" c.FMoveOutwarehouseid as warehouse, ");
        sqlBuff.append(" c.FMoveOutwarehouseid as warehouseId, ");
        sqlBuff.append(" e.FAssistUnit as assitantUnitId, ");
        sqlBuff.append(" af.FBaseConvsRate as assitantRate, ");
        sqlBuff.append(" af.fQtyPrecision as assitantPre, ");
        sqlBuff.append(" ISNULL(h.FBaseQty, 0) as inventoryBaseQty,");
        sqlBuff.append(" ISNULL(ROUND(decimal(h.FBaseQty, 21, 8)/multiProductUnit.FBaseConvsRate,multiProductUnit.fQtyPrecision), 0) as inventoryQty, ");
        sqlBuff.append(" 0 as moveQty, ");
        sqlBuff.append(" 0 as moveBaseQty, ");
        sqlBuff.append(" k.FTransferBatch  as transBatch,");
        sqlBuff.append(" '' as remark, ");
        sqlBuff.append(" multiProductUnit.FBaseConvsRate as rate ");
        sqlBuff.append(" from T_MM_ProductionOrderSEntry c inner join ");
        sqlBuff.append(" (select b.fMaterialid,");
        sqlBuff.append(" b.Fdefaultwarehouseid,");
        sqlBuff.append(" b.FMoveOutwarehouseid,");
        sqlBuff.append(" sum(b.fbaseQty) fbaseQty,  ");
        sqlBuff.append(" sum(b.fqty) fqty");
        sqlBuff.append(" from T_MM_ProductionOrder a inner join T_MM_ProductionOrderSEntry b");
        sqlBuff.append(" on a.fid = b.FParentID inner join T_BD_Material c on c.Fid = a.FMaterialid Where ");
        this.getFilterSQL(filterInfo, sqlBuff);
        sqlBuff.append(" group by b.fMaterialid, b.Fdefaultwarehouseid,  b.FMoveOutwarehouseid) d ");
        sqlBuff.append(" on c.fMaterialid = d.fMaterialid ");
        sqlBuff.append(" and (c.Fdefaultwarehouseid = d.Fdefaultwarehouseid or (c.Fdefaultwarehouseid is null and d.Fdefaultwarehouseid is null)) ");
        sqlBuff.append(" and (c.FMoveOutwarehouseid = d.FMoveOutwarehouseid or (c.FMoveOutwarehouseid is null and d.FMoveOutwarehouseid is null)) ");
        sqlBuff.append(" inner join (select distinct b.fid as fid ");
        sqlBuff.append(" from T_MM_ProductionOrder a inner join T_MM_ProductionOrderSEntry b");
        sqlBuff.append(" on a.fid = b.FParentID inner join T_BD_Material c on c.Fid = a.FMaterialid Where ");
        this.getFilterSQL(filterInfo, sqlBuff);
        sqlBuff.append(") g on c.fid=g.fid ");
        sqlBuff.append(" inner join T_BD_Material e on c.fMaterialid = e.fid");
        sqlBuff.append(" inner join T_BD_MaterialPlan k on c.fMaterialid = k.fMaterialid and FOrgUnit='");
        sqlBuff.append((String)((FilterItemInfo)filterInfo.getFilterItems().getObject(0)).getCompareValue());
        sqlBuff.append("'");
        sqlBuff.append(" left join T_BD_MeasureUnit productUnit on  productUnit.fid = k.FProductUnitID");
        sqlBuff.append(" left join T_BD_MultiMeasureUnit multiProductUnit on multiProductUnit.FMaterialID = c.fMaterialid and multiProductUnit.FMeasureUnitID = k.FProductUnitID");
        sqlBuff.append(" left join T_BD_MeasureUnit f on c.fbaseunitid = f.fid");
        sqlBuff.append(" left join T_BD_MultiMeasureUnit multiBaseUnit on multiBaseUnit.FMaterialID = c.fMaterialid and multiBaseUnit.FMeasureUnitID = c.fbaseunitid");
        sqlBuff.append(" left join T_BD_MultiMeasureUnit af on af.FMaterialID = e.fid and af.FMeasureUnitID = e.FAssistUnit");
        sqlBuff.append(" left join (");
        sqlBuff.append("select tii.FWarehouseID as fWarehouseID,tii.FMaterialID as fMaterialID, ISNULL(sum(tii.FBaseQty), 0) as FBaseQty from T_IM_Inventory tii  left join T_DB_WAREHOUSE tdw on tii.FWarehouseID=tdw.FID");
        if (requireDate != null) {
            sqlBuff.append(" LEFT OUTER JOIN T_BD_MaterialInventory tbmi on tii.FMaterialID = tbmi.FMaterialID AND tii.FStorageOrgUnitID = tbmi.FOrgUnit ");
            sqlBuff.append(" LEFT OUTER JOIN T_IM_DateOfMinDurability tidd on tii.FLot = tidd.FLot AND tii.FStorageOrgUnitID = tidd.FStorageOrgUnitID AND tii.FMaterialID= tidd.FMaterialID ");
        }
        sqlBuff.append(" where tii.FStorageOrgUnitID = '");
        sqlBuff.append((String)((FilterItemInfo)filterInfo.getFilterItems().getObject(0)).getCompareValue());
        sqlBuff.append("'");
        sqlBuff.append(" and tii.FStoreTypeID = '181875d5-0105-1000-e000-0111c0a812fd97D461A6'");
        sqlBuff.append(" and tii.FStoreStatusID = '181875d5-0105-1000-e000-012ec0a812fd62A73FA5'");
        sqlBuff.append(" and tdw.FTransState in ('1','2')");
        if (requireDate != null) {
            sqlBuff.append(" and ((tbmi.FIsPeriodValid = 1 AND to_char(tidd.FEXP,'yyyy-mm-dd')>='" + expDate + "') or (tbmi.FIsPeriodValid != 1))");
        }
        sqlBuff.append(" group by tii.FWarehouseID,tii.FMaterialID) h ");
        sqlBuff.append(" on c.fMaterialid = h.fMaterialID and c.Fdefaultwarehouseid = h.fWarehouseID");
        try {
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlBuff.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return rowSet;
    }
}

